{"version":5,"vars":[{"line":111,"kind":2,"containerName":"","name":"vars"},{"kind":2,"line":114,"containerName":"","name":"base"},{"line":116,"kind":13,"name":"@PSMFORMATS","containerName":null},{"kind":12,"children":[{"line":135,"kind":13,"localvar":"my","containerName":"new","name":"$caller","definition":"my"},{"line":135,"kind":13,"name":"@args","containerName":"new"},{"line":136,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"line":136,"kind":13,"containerName":"new","name":"$caller"},{"name":"$caller","containerName":"new","line":136,"kind":13},{"kind":13,"line":137,"containerName":"new","definition":"my","name":"$self","localvar":"my"},{"name":"$class","containerName":"new","kind":13,"line":140},{"containerName":"new","name":"$self","line":141,"kind":13},{"kind":13,"line":141,"containerName":"new","name":"$class"},{"name":"@args","containerName":"new","line":141,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":142},{"kind":12,"line":142,"containerName":"new","name":"_initialize"},{"kind":13,"line":142,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","kind":13,"line":143},{"line":145,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"%param"},{"kind":13,"line":145,"name":"@args","containerName":"new"},{"line":146,"kind":13,"name":"@param","containerName":"new"},{"name":"%param","containerName":"new","kind":13,"line":146},{"kind":13,"line":146,"name":"%param","containerName":"new"},{"kind":13,"line":147,"containerName":"new","definition":"my","name":"$format","localvar":"my"},{"name":"$param","containerName":"new","kind":13,"line":147},{"kind":13,"line":148,"name":"$class","containerName":"new"},{"line":148,"kind":12,"containerName":"new","name":"_guess_format"},{"name":"$param","containerName":"new","kind":13,"line":148},{"line":148,"kind":13,"name":"$ARGV","containerName":"new"},{"kind":13,"line":150,"containerName":"new","name":"$class"},{"containerName":"new","name":"throw","line":150,"kind":12},{"line":150,"kind":13,"containerName":"new","name":"@Bio"},{"containerName":"new","name":"$format","kind":13,"line":151},{"containerName":"new","name":"$class","kind":13,"line":154},{"name":"_load_format_module","containerName":"new","line":154,"kind":12},{"containerName":"new","name":"$format","kind":13,"line":154},{"kind":12,"line":155,"name":"new","containerName":"new"},{"line":155,"kind":13,"name":"@args","containerName":"new"}],"line":134,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO - PSM parser\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::IO;\n\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n\n  my $release=$psmIO->release; #Using Bio::Matrix::PSM::PsmHeader methods\n\n  my $release=$psmIO->release;\n\n  while (my $psm=$psmIO->next_psm) {\n   my %psm_header=$psm->header;\n   my $ic=$psm_header{IC};\n   my $sites=$psm_header{sites};\n   my $width=$psm_header{width};\n   my $score=$psm_header{e_val};\n   my $IUPAC=$psm->IUPAC;\n  }\n\n  my $instances=$psm->instances;\n  foreach my $instance (@{$instances}) {\n    my $id=$instance->primary_id;\n  }\n\n\n=head1 DESCRIPTION\n\nThis module allows you to read DNA position scoring matrices and/or\ntheir respective sequence matches from a file.\n\nThere are two header methods, one belonging to\nBio::Matrix::PSM::IO::driver and the other to\nBio::Matrix::PSM::Psm. They provide general information about the file\n(driver) and for the current PSM result (Psm) respectively. Psm header\nmethod always returns the same thing, but some values in the hash\nmight be empty, depending on the file you are parsing. You will get\nundef in this case (no exceptions are thrown).\n\nPlease note that the file header data (commenatries, version, input\ndata, configuration, etc.)  might be obtained through\nBio::Matrix::PSM::PsmHeader methods. Some methods are driver specific\n(meme, transfac, etc.): meme: weight mast: seq, instances\n\nIf called when you parse a different file type you will get undef. For\nexample:\n\n  my $psmIO= Bio::Matrix::PSM::IO->new(file=>$file, format=>'transfac');\n  my %seq=$psmIO->seq;\n\nwill return an empty hash. To see all methods and how to use them go\nto Bio::Matrix::PSM::PsmHeaderI.\n\nSee also Bio::Matrix::PSM::PsmI for details on using and manipulating\nthe parsed data.\n\nThe only way to write PFM/PWM is through masta module (something like fasta for\nDNA matrices). You can see an example by reading Bio::Matrix::PSM::IO::masta\ndocumentation.\n\n=head1 See also\n\nBio::Matrix::PSM::PsmI, Bio::Matrix::PSM::PsmHeaderI, Bio::Matrix::PSM::IO::masta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO;\nuse vars qw(@PSMFORMATS);\nuse strict;\n\nuse base qw(Bio::Root::IO);\n\n@PSMFORMATS = qw(meme transfac mast psiblast masta);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or \n           if some criteria for the file\n           format are not met. See L<Bio::Matrix::PSM::IO::meme> and \n           L<Bio::Matrix::PSM::IO::transfac> for more details.\n Example :\n Returns : psm object, associated with a file with matrix file\n Args    : hash","label":"new($caller,@args)"},"detail":"($caller,@args)","name":"new","range":{"end":{"character":9999,"line":157},"start":{"character":0,"line":134}}},{"kind":12,"line":141,"containerName":"new","name":"SUPER"},{"name":"Matrix","containerName":"PSM::IO::PSMFORMATS","line":150,"kind":12},{"range":{"start":{"character":0,"line":171},"end":{"character":9999,"line":177}},"definition":"sub","name":"fh","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"fh","localvar":"my","kind":13,"line":172},{"kind":13,"line":173,"definition":"my","name":"$class","containerName":"fh","localvar":"my"},{"containerName":"fh","name":"$self","kind":13,"line":173},{"kind":13,"line":173,"containerName":"fh","name":"$self"},{"localvar":"my","definition":"my","name":"$s","containerName":"fh","line":174,"kind":13},{"name":"$class","containerName":"fh","line":175,"kind":13},{"containerName":"fh","name":"$self","line":175,"kind":13},{"name":"$s","containerName":"fh","line":176,"kind":13}],"line":171,"kind":12},{"name":"Symbol","containerName":"gensym","kind":12,"line":175},{"signature":{"parameters":[{"label":"$self"},{"label":"$format"}],"documentation":"1;\n#---------------------------------------------------------\n# $Id: IO.pm 16123 2009-09-17 12:57:27Z cjfields $\n\n=head1 NAME\n\nBio::Matrix::PSM::IO - PSM parser\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::PSM::IO;\n\n  my $psmIO= Bio::Matrix::PSM::IO->new(-file=>$file, -format=>'transfac');\n\n  my $release=$psmIO->release; #Using Bio::Matrix::PSM::PsmHeader methods\n\n  my $release=$psmIO->release;\n\n  while (my $psm=$psmIO->next_psm) {\n   my %psm_header=$psm->header;\n   my $ic=$psm_header{IC};\n   my $sites=$psm_header{sites};\n   my $width=$psm_header{width};\n   my $score=$psm_header{e_val};\n   my $IUPAC=$psm->IUPAC;\n  }\n\n  my $instances=$psm->instances;\n  foreach my $instance (@{$instances}) {\n    my $id=$instance->primary_id;\n  }\n\n\n=head1 DESCRIPTION\n\nThis module allows you to read DNA position scoring matrices and/or\ntheir respective sequence matches from a file.\n\nThere are two header methods, one belonging to\nBio::Matrix::PSM::IO::driver and the other to\nBio::Matrix::PSM::Psm. They provide general information about the file\n(driver) and for the current PSM result (Psm) respectively. Psm header\nmethod always returns the same thing, but some values in the hash\nmight be empty, depending on the file you are parsing. You will get\nundef in this case (no exceptions are thrown).\n\nPlease note that the file header data (commenatries, version, input\ndata, configuration, etc.)  might be obtained through\nBio::Matrix::PSM::PsmHeader methods. Some methods are driver specific\n(meme, transfac, etc.): meme: weight mast: seq, instances\n\nIf called when you parse a different file type you will get undef. For\nexample:\n\n  my $psmIO= Bio::Matrix::PSM::IO->new(file=>$file, format=>'transfac');\n  my %seq=$psmIO->seq;\n\nwill return an empty hash. To see all methods and how to use them go\nto Bio::Matrix::PSM::PsmHeaderI.\n\nSee also Bio::Matrix::PSM::PsmI for details on using and manipulating\nthe parsed data.\n\nThe only way to write PFM/PWM is through masta module (something like fasta for\nDNA matrices). You can see an example by reading Bio::Matrix::PSM::IO::masta\ndocumentation.\n\n=head1 See also\n\nBio::Matrix::PSM::PsmI, Bio::Matrix::PSM::PsmHeaderI, Bio::Matrix::PSM::IO::masta\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Stefan Kirov\n\nEmail skirov@utk.edu\n\n=head1 APPENDIX\n\n\n\n# Let the code begin...\npackage Bio::Matrix::PSM::IO;\nuse vars qw(@PSMFORMATS);\nuse strict;\n\nuse base qw(Bio::Root::IO);\n\n@PSMFORMATS = qw(meme transfac mast psiblast masta);\n\n=head2 new\n\n Title   : new\n Usage   : my $psmIO =  Bio::Matrix::PSM::IO->new(-format=>'meme', \n\t\t\t\t\t\t -file=>$file);\n Function: Associates a file with the appropriate parser\n Throws  : Throws if the file passed is in HTML format or \n           if some criteria for the file\n           format are not met. See L<Bio::Matrix::PSM::IO::meme> and \n           L<Bio::Matrix::PSM::IO::transfac> for more details.\n Example :\n Returns : psm object, associated with a file with matrix file\n Args    : hash\n\n\nsub new {\n    my($caller,@args) = @_;\n    my $class = ref($caller) || $caller;\n    my $self;\n    # or do we want to call SUPER on an object if $caller is an\n    # object?\n    if( $class =~ /Bio::Matrix::PSM::IO(\\S+)/ ) {\n\t$self = $class->SUPER::new(@args);\n\t$self->_initialize(@args);\n\treturn $self;\n    } else {\n\tmy %param = @args;\n\t@param{ map { lc $_ } keys %param } = values %param; # lowercase keys\n\tmy $format = $param{'-format'} ||\n\t    $class->_guess_format( $param{'-file'} || $ARGV[0] ) ||\n\t    'scoring';\n\t$class->throw(\"$format format unrecognized or an argument error occured\\n.\") if (!grep(/$format/,@Bio::Matrix::PSM::IO::PSMFORMATS));\n\t$format = \"\\L$format\"; # normalize capitalization to lower case\n\n\t# normalize capitalization\n\treturn unless( $class->_load_format_module($format) );\n\treturn \"Bio::Matrix::PSM::IO::$format\"->new(@args);\n    }\n}\n\n=head2 fh\n\n Title   : fh\n Usage   : $obj->fh\n Function: Get a filehandle type access to the matrix parser\n Example : $fh = $obj->fh;      # make a tied filehandle\n           $matrix = <$fh>;     # read a matrix object\n Returns : filehandle tied to Bio::Matrix::PSM::IO class\n Args    : none\n\n\nsub fh {\n    my $self = shift;\n    my $class = ref($self) || $self;\n    my $s = Symbol::gensym;\n    tie $$s,$class,$self;\n    return $s;\n}\n\n\n=head2 _load_format_module\n\n Title   : _load_format_module\n Usage   : *INTERNAL Matrix::PSM::IO stuff*\n Function: Loads up (like use) a module at run time on demand","label":"_load_format_module($self,$format)"},"detail":"($self,$format)","definition":"sub","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_load_format_module","localvar":"my","kind":13,"line":189},{"line":189,"kind":13,"containerName":"_load_format_module","name":"$format"},{"line":190,"kind":13,"localvar":"my","containerName":"_load_format_module","definition":"my","name":"$module"},{"kind":13,"line":190,"containerName":"_load_format_module","name":"$format"},{"containerName":"_load_format_module","name":"$ok","definition":"my","localvar":"my","kind":13,"line":191},{"line":194,"kind":13,"containerName":"_load_format_module","name":"$ok"},{"kind":13,"line":194,"containerName":"_load_format_module","name":"$self"},{"containerName":"_load_format_module","name":"_load_module","line":194,"kind":12},{"containerName":"_load_format_module","name":"$module","line":194,"kind":13},{"kind":13,"line":206,"name":"$ok","containerName":"_load_format_module"}],"line":188,"kind":12,"range":{"start":{"character":0,"line":188},"end":{"line":207,"character":9999}},"name":"_load_format_module"},{"children":[{"localvar":"my","name":"$class","definition":"my","containerName":"_guess_format","line":220,"kind":13}],"line":219,"kind":12,"range":{"start":{"line":219,"character":0},"end":{"character":9999,"line":225}},"name":"_guess_format","definition":"sub","containerName":"main::"},{"range":{"end":{"character":9999,"line":243},"start":{"character":0,"line":240}},"definition":"sub","name":"next_psm","containerName":"main::","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"next_psm","line":241,"kind":13},{"name":"$self","containerName":"next_psm","kind":13,"line":242},{"containerName":"next_psm","name":"throw_not_implemented","kind":12,"line":242}],"line":240,"kind":12},{"range":{"start":{"line":257,"character":0},"end":{"character":9999,"line":260}},"definition":"sub","name":"_parseMatrix","containerName":"main::","children":[{"definition":"my","name":"$self","containerName":"_parseMatrix","localvar":"my","kind":13,"line":258},{"kind":13,"line":259,"name":"$self","containerName":"_parseMatrix"},{"containerName":"_parseMatrix","name":"throw_not_implemented","kind":12,"line":259}],"line":257,"kind":12},{"line":274,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_parseInstance","line":275,"kind":13},{"containerName":"_parseInstance","name":"$self","kind":13,"line":276},{"line":276,"kind":12,"name":"throw_not_implemented","containerName":"_parseInstance"}],"kind":12,"range":{"end":{"line":277,"character":9999},"start":{"line":274,"character":0}},"containerName":"main::","definition":"sub","name":"_parseInstance"},{"line":291,"children":[{"definition":"my","name":"$self","containerName":"_parse_coordinates","localvar":"my","kind":13,"line":292},{"containerName":"_parse_coordinates","name":"$self","line":293,"kind":13},{"containerName":"_parse_coordinates","name":"throw_not_implemented","kind":12,"line":293}],"kind":12,"range":{"start":{"line":291,"character":0},"end":{"line":294,"character":9999}},"containerName":"main::","name":"_parse_coordinates","definition":"sub"},{"range":{"start":{"line":308,"character":0},"end":{"character":9999,"line":311}},"name":"header","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"header","localvar":"my","kind":13,"line":309},{"containerName":"header","name":"$self","line":310,"kind":13},{"kind":12,"line":310,"name":"throw_not_implemented","containerName":"header"}],"line":308,"kind":12},{"name":"_make_matrix","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":328},"start":{"line":325,"character":0}},"kind":12,"children":[{"kind":13,"line":326,"containerName":"_make_matrix","definition":"my","name":"$self","localvar":"my"},{"line":327,"kind":13,"name":"$self","containerName":"_make_matrix"},{"containerName":"_make_matrix","name":"throw_not_implemented","kind":12,"line":327}],"line":325},{"children":[{"localvar":"my","containerName":"DESTROY","name":"$self","definition":"my","line":332,"kind":13},{"kind":13,"line":333,"containerName":"DESTROY","name":"$self"},{"containerName":"DESTROY","name":"close","kind":12,"line":333}],"line":331,"kind":12,"range":{"start":{"character":0,"line":331},"end":{"character":9999,"line":334}},"name":"DESTROY","definition":"sub","containerName":"main::"}]}