{"vars":[{"kind":2,"line":75,"name":"vars","containerName":""},{"kind":13,"line":78,"name":"$DEFAULTPROGRAM","containerName":null},{"name":"strict","containerName":"","kind":2,"line":78},{"kind":2,"line":82,"name":"base","containerName":""},{"kind":12,"line":95,"children":[{"kind":13,"line":96,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"kind":13,"line":96,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":98},{"kind":13,"line":98,"name":"$class","containerName":"new"},{"kind":13,"line":98,"name":"@args","containerName":"new"},{"localvar":"my","containerName":"new","definition":"my","name":"$prog","line":99,"kind":13},{"name":"$self","containerName":"new","line":99,"kind":13},{"name":"_rearrange","containerName":"new","kind":12,"line":99},{"kind":13,"line":99,"containerName":"new","name":"@args"},{"line":100,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"$prog","line":100,"kind":13},{"name":"$DEFAULTPROGRAM","containerName":"new","kind":13,"line":100},{"line":101,"kind":13,"name":"$self","containerName":"new"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: phylip.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::phylip\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::phylip - A parser for PHYLIP distance matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format   => 'phylip',\n                                   -file     => 't/data/phylipdist.out');\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a parser for PHYLIP distance matrix output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO::phylip;\nuse vars qw($DEFAULTPROGRAM);\nuse strict;\n\n$DEFAULTPROGRAM = 'phylipdist';\n\nuse Bio::Matrix::PhylipDist;\n\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::phylip->new();\n Function: Builds a new Bio::Matrix::IO::phylip object \n Returns : an instance of Bio::Matrix::IO::phylip\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"name":"new","range":{"end":{"character":9999,"line":102},"start":{"line":95,"character":0}}},{"kind":12,"line":98,"containerName":"new","name":"SUPER"},{"range":{"start":{"character":0,"line":116},"end":{"line":138,"character":9999}},"name":"next_matrix","signature":{"label":"next_matrix($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: phylip.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::phylip\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::phylip - A parser for PHYLIP distance matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format   => 'phylip',\n                                   -file     => 't/data/phylipdist.out');\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a parser for PHYLIP distance matrix output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO::phylip;\nuse vars qw($DEFAULTPROGRAM);\nuse strict;\n\n$DEFAULTPROGRAM = 'phylipdist';\n\nuse Bio::Matrix::PhylipDist;\n\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::phylip->new();\n Function: Builds a new Bio::Matrix::IO::phylip object \n Returns : an instance of Bio::Matrix::IO::phylip\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($prog) = $self->_rearrange([qw(PROGRAM)], @args);\n  $self->{'_program'} = $prog || $DEFAULTPROGRAM;\n  return $self;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $parser->next_matrix\n Function: Get the next result set from parser data\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : none"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"next_matrix","definition":"my","name":"$self","line":117,"kind":13},{"localvar":"my","containerName":"next_matrix","definition":"my","name":"@names","line":118,"kind":13},{"name":"@values","definition":"my","containerName":"next_matrix","localvar":"my","kind":13,"line":119},{"kind":13,"line":120,"containerName":"next_matrix","name":"$entry","definition":"my","localvar":"my"},{"kind":13,"line":121,"containerName":"next_matrix","name":"$size","definition":"my","localvar":"my"},{"line":122,"kind":13,"name":"$entry","containerName":"next_matrix"},{"name":"$self","containerName":"next_matrix","line":122,"kind":13},{"containerName":"next_matrix","name":"_readline","kind":12,"line":122},{"kind":13,"line":123,"name":"$entry","containerName":"next_matrix"},{"line":124,"kind":13,"containerName":"next_matrix","name":"$self"},{"name":"_pushback","containerName":"next_matrix","kind":12,"line":124},{"containerName":"next_matrix","name":"$entry","kind":13,"line":124},{"containerName":"next_matrix","name":"$entry","kind":13,"line":126},{"containerName":"next_matrix","name":"$size","line":127,"kind":13},{"containerName":"next_matrix","name":"$entry","line":129,"kind":13},{"kind":13,"line":130,"definition":"my","name":"@line","containerName":"next_matrix","localvar":"my"},{"name":"$entry","containerName":"next_matrix","kind":13,"line":130},{"name":"$values","containerName":"next_matrix","line":131,"kind":13},{"containerName":"next_matrix","name":"@line","line":131,"kind":13},{"line":134,"kind":13,"localvar":"my","containerName":"next_matrix","name":"$n","definition":"my"},{"containerName":"next_matrix","name":"@line","line":134,"kind":13},{"kind":13,"line":134,"name":"$entry","containerName":"next_matrix"},{"line":136,"kind":13,"name":"@names","containerName":"next_matrix"},{"line":136,"kind":13,"containerName":"next_matrix","name":"$n"},{"kind":13,"line":137,"name":"@values","containerName":"next_matrix"},{"name":"@line","containerName":"next_matrix","kind":13,"line":137}],"line":116,"kind":12},{"line":123,"kind":12,"name":"names"},{"name":"@names","containerName":null,"kind":13,"line":139},{"line":139,"kind":13,"name":"%size","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":140},{"containerName":"main::","name":"warn","line":140,"kind":12},{"kind":13,"line":140,"containerName":null,"name":"@names"},{"name":"names","line":143,"kind":12},{"kind":13,"line":144,"definition":"my","name":"%dist","containerName":null,"localvar":"my"},{"localvar":"my","name":"$i","definition":"my","containerName":null,"line":145,"kind":13},{"localvar":"my","definition":"my","name":"$name","containerName":null,"line":146,"kind":13},{"containerName":null,"name":"@names","kind":13,"line":146},{"line":147,"kind":13,"localvar":"my","containerName":null,"name":"$j","definition":"my"},{"kind":13,"line":148,"name":"$n","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"@names","line":148,"kind":13},{"name":"%dist","containerName":null,"line":149,"kind":13},{"name":"%name","containerName":null,"kind":13,"line":149},{"name":"@n","containerName":null,"kind":13,"line":149},{"name":"$i","containerName":null,"kind":13,"line":149},{"name":"$j","containerName":null,"kind":13,"line":149},{"name":"$j","containerName":null,"kind":13,"line":150},{"kind":13,"line":152,"containerName":null,"name":"$i"},{"name":"$matrix","definition":"my","containerName":null,"localvar":"my","kind":13,"line":154},{"kind":12,"line":154,"name":"Bio","containerName":"Matrix::PhylipDist"},{"line":155,"kind":12,"containerName":"main::","name":"new"},{"containerName":null,"name":"%self","line":155,"kind":13},{"line":156,"kind":13,"name":"%dist","containerName":null},{"line":157,"kind":13,"containerName":null,"name":"@names"},{"line":158,"kind":13,"name":"@values","containerName":null},{"line":159,"kind":13,"containerName":null,"name":"$matrix"},{"range":{"end":{"character":9999,"line":177},"start":{"character":0,"line":173}},"name":"write_matrix","children":[{"kind":13,"line":174,"definition":"my","name":"$self","containerName":"write_matrix","localvar":"my"},{"containerName":"write_matrix","name":"@matricies","kind":13,"line":174},{"localvar":"my","containerName":"write_matrix","name":"$matrix","definition":"my","line":175,"kind":13},{"containerName":"write_matrix","name":"@matricies","kind":13,"line":175},{"localvar":"my","containerName":"write_matrix","definition":"my","name":"@names","line":176,"kind":13},{"kind":13,"line":176,"containerName":"write_matrix","name":"$matrix"},{"line":176,"kind":12,"name":"names","containerName":"write_matrix"},{"name":"@values","definition":"my","containerName":"write_matrix","localvar":"my","kind":13,"line":177},{"containerName":"write_matrix","name":"$matrix","line":177,"kind":13},{"containerName":"write_matrix","name":"_values","line":177,"kind":12}],"line":173,"kind":12,"signature":{"label":"write_matrix($self,@matricies)","parameters":[{"label":"$self"},{"label":"@matricies"}],"documentation":"1;\n# $Id: phylip.pm 16168 2009-09-25 21:07:32Z cjfields $\n#\n# BioPerl module for Bio::Matrix::IO::phylip\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl-dot.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Matrix::IO::phylip - A parser for PHYLIP distance matricies\n\n=head1 SYNOPSIS\n\n  use Bio::Matrix::IO;\n  my $parser = Bio::Matrix::IO->new(-format   => 'phylip',\n                                   -file     => 't/data/phylipdist.out');\n  my $matrix = $parser->next_matrix;\n\n=head1 DESCRIPTION\n\nThis is a parser for PHYLIP distance matrix output.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Matrix::IO::phylip;\nuse vars qw($DEFAULTPROGRAM);\nuse strict;\n\n$DEFAULTPROGRAM = 'phylipdist';\n\nuse Bio::Matrix::PhylipDist;\n\nuse base qw(Bio::Matrix::IO);\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Matrix::IO::phylip->new();\n Function: Builds a new Bio::Matrix::IO::phylip object \n Returns : an instance of Bio::Matrix::IO::phylip\n Args    :\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($prog) = $self->_rearrange([qw(PROGRAM)], @args);\n  $self->{'_program'} = $prog || $DEFAULTPROGRAM;\n  return $self;\n}\n\n\n=head2 next_matrix\n\n Title   : next_matrix\n Usage   : my $matrix = $parser->next_matrix\n Function: Get the next result set from parser data\n Returns : L<Bio::Matrix::PhylipDist>\n Args    : none\n\n\n\nsub next_matrix {\n   my ($self) = @_;\n   my @names;\n   my @values;\n   my $entry;\n   my $size = 0;\n   while ($entry=$self->_readline) {\n       if($#names >=0 && $entry =~/^\\s+\\d+\\n$/){\n\t   $self->_pushback($entry);\n\t   last;\n       } elsif($entry=~/^\\s+(\\d+)\\n$/){\t   \n\t   $size = $1;\n\t   next;\n       } elsif( $entry =~ s/^\\s+(\\-?\\d+\\.\\d+)/$1/ ) {\n\t   my (@line) = split( /\\s+/,$entry);\n\t   push @{$values[-1]}, @line;\n\t   next;\n       }\n       my ($n,@line) = split( /\\s+/,$entry);\n       \n       push @names, $n;\n       push @values, [@line];\n   }\n   if( scalar @names != $size ) {\n       $self->warn(\"The number of entries \".(scalar @names).\n\t\t   \" is not the same $size\");\n   }\n   $#names>=0 || return;\n   my %dist;\n   my $i=0;\n   foreach my $name(@names){\n       my $j=0;\n       foreach my $n(@names) {\n\t   $dist{$name}{$n} = [$i,$j];\n\t   $j++;\n       }\n       $i++;\n   }\n   my $matrix = Bio::Matrix::PhylipDist->new\n       (-matrix_name => $self->{'_program'},\n\t-matrix      => \\%dist,\n\t-names       => \\@names,\n\t-values      => \\@values);\n    return $matrix;\n}\n\n=head2 write_matrix\n\n Title   : write_matrix\n Usage   : $matio->write_matrix($matrix)\n Function: Write out a matrix in the phylip distance format\n Returns : none\n Args    : L<Bio::Matrix::PhylipDist>"},"detail":"($self,@matricies)","definition":"sub","containerName":"main::"},{"containerName":null,"name":"%matrix","definition":"my","localvar":"my","kind":13,"line":178},{"kind":13,"line":178,"containerName":null,"name":"$matrix"},{"kind":12,"line":178,"containerName":"main::","name":"_matrix"},{"name":"$str","definition":"my","containerName":null,"localvar":"my","kind":13,"line":179},{"name":"$str","containerName":null,"line":180,"kind":13},{"name":"@names","containerName":null,"line":180,"kind":13},{"localvar":"my","definition":"my","name":"$name","containerName":null,"line":181,"kind":13},{"containerName":null,"name":"@names","line":181,"kind":13},{"containerName":null,"definition":"my","name":"$newname","localvar":"my","kind":13,"line":182},{"name":"$name","containerName":null,"line":182,"kind":13},{"line":182,"kind":13,"containerName":null,"name":"$name"},{"name":"%name","containerName":null,"kind":13,"line":183},{"line":183,"kind":13,"containerName":null,"name":"$newname"},{"name":"$str","containerName":null,"kind":13,"line":184},{"containerName":null,"name":"$newname","kind":13,"line":184},{"kind":13,"line":185,"name":"$count","definition":"my","containerName":null,"localvar":"my"},{"localvar":"my","name":"$n","definition":"my","containerName":null,"line":186,"kind":13},{"line":186,"kind":13,"name":"@names","containerName":null},{"localvar":"my","containerName":null,"name":"$i","definition":"my","line":187,"kind":13},{"line":187,"kind":13,"containerName":null,"name":"$j"},{"kind":13,"line":187,"containerName":null,"name":"%matrix"},{"kind":13,"line":187,"name":"%name","containerName":null},{"containerName":null,"name":"$n","kind":13,"line":187},{"name":"$count","containerName":null,"line":188,"kind":13},{"kind":12,"line":188,"name":"names"},{"kind":13,"line":189,"containerName":null,"name":"$str"},{"containerName":null,"name":"@values","line":189,"kind":13},{"kind":13,"line":189,"name":"@i","containerName":null},{"line":189,"kind":13,"containerName":null,"name":"%j"},{"name":"$str","containerName":null,"kind":13,"line":192},{"line":192,"kind":13,"containerName":null,"name":"@values"},{"name":"@i","containerName":null,"line":192,"kind":13},{"line":192,"kind":13,"name":"$j","containerName":null},{"containerName":null,"name":"$count","line":194,"kind":13},{"kind":13,"line":196,"name":"$str","containerName":null},{"line":198,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":198,"name":"_print","containerName":"main::"},{"line":198,"kind":13,"containerName":null,"name":"$str"}],"version":5}