{"version":5,"vars":[{"kind":2,"line":71,"name":"base","containerName":""},{"localvar":"my","name":"$_readcor","definition":"my","containerName":null,"line":73,"kind":13},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"# fpc.pm,v 1.2.2.1 2005/10/09 15:16:27 jason Exp\n#\n# BioPerl module for Bio::MapIO::fpc\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::fpc - A FPC Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system\n\n    use Bio::MapIO;\n\n     -format  : specifies the format of the file format is \"fpc\",\n     -file    : specifies the name of the .fpc file\n     -readcor : boolean argument, indicating if .cor is to be read\n                 or not. It looks for the .cor file in the same path\n                 as .fpc file.\n                 0 : doesn't read .cor file\n                 1 : reads the .cor file\n                 [default 0]\n     -verbose : indicates the process of loading of fpc file\n    my $mapio = Bio::MapIO->new(-format  => \"fpc\",\n                               -file    => \"rice.fpc\",\n                               -readcor => 0,\n                               -verbose => 0);\n\n    my $map = $mapio->next_map();\n\n    foreach my $marker ( $map->each_markerid() ) {\n         # loop through the markers associated with the map\n         # likewise for contigs, clones, etc.\n    }\n\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing FPC files and creating\nL<Bio::Map::Physical> object from it.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\nWe handle reading of the FPC ourselves, since MapIO module of Bioperl adds\ntoo much overhead.\n\n\n# Let the code begin...\n\npackage Bio::MapIO::fpc;\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Physical;\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\nuse Bio::Range;\n\nuse base qw(Bio::MapIO);\n\nmy $_readcor;\n\n=head1 Initializer\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : called implicitly\n Function: calls the SUPER::_initialize\n Returns : nothing\n Args    : species, readcor","label":"_initialize($self,@args)"},"detail":"($self,@args)","kind":12,"children":[{"containerName":"_initialize","name":"$self","definition":"my","localvar":"my","kind":13,"line":88},{"name":"@args","containerName":"_initialize","line":88,"kind":13},{"line":89,"kind":13,"localvar":"my","containerName":"_initialize","definition":"my","name":"$species"},{"kind":13,"line":90,"containerName":"_initialize","name":"$self"},{"kind":13,"line":90,"name":"@args","containerName":"_initialize"},{"containerName":"_initialize","name":"$species","line":91,"kind":13},{"line":91,"kind":13,"containerName":"_initialize","name":"$_readcor"},{"containerName":"_initialize","name":"$self","kind":13,"line":91},{"containerName":"_initialize","name":"_rearrange","line":91,"kind":12},{"kind":13,"line":91,"containerName":"_initialize","name":"@args"},{"line":92,"kind":13,"name":"$_readcor","containerName":"_initialize"},{"kind":13,"line":92,"name":"$_readcor","containerName":"_initialize"}],"line":87,"name":"_initialize","range":{"start":{"line":87,"character":0},"end":{"line":93,"character":9999}}},{"line":90,"kind":12,"name":"SUPER","containerName":"_initialize"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"next_map($self)","documentation":"# fpc.pm,v 1.2.2.1 2005/10/09 15:16:27 jason Exp\n#\n# BioPerl module for Bio::MapIO::fpc\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::fpc - A FPC Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system\n\n    use Bio::MapIO;\n\n     -format  : specifies the format of the file format is \"fpc\",\n     -file    : specifies the name of the .fpc file\n     -readcor : boolean argument, indicating if .cor is to be read\n                 or not. It looks for the .cor file in the same path\n                 as .fpc file.\n                 0 : doesn't read .cor file\n                 1 : reads the .cor file\n                 [default 0]\n     -verbose : indicates the process of loading of fpc file\n    my $mapio = Bio::MapIO->new(-format  => \"fpc\",\n                               -file    => \"rice.fpc\",\n                               -readcor => 0,\n                               -verbose => 0);\n\n    my $map = $mapio->next_map();\n\n    foreach my $marker ( $map->each_markerid() ) {\n         # loop through the markers associated with the map\n         # likewise for contigs, clones, etc.\n    }\n\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing FPC files and creating\nL<Bio::Map::Physical> object from it.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\nWe handle reading of the FPC ourselves, since MapIO module of Bioperl adds\ntoo much overhead.\n\n\n# Let the code begin...\n\npackage Bio::MapIO::fpc;\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Physical;\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\nuse Bio::Range;\n\nuse base qw(Bio::MapIO);\n\nmy $_readcor;\n\n=head1 Initializer\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : called implicitly\n Function: calls the SUPER::_initialize\n Returns : nothing\n Args    : species, readcor\n\n\nsub _initialize{\n    my ($self,@args) = @_;\n    my $species;\n    $self->SUPER::_initialize(@args);\n    ($species,$_readcor) = $self->_rearrange([qw(SPECIES READCOR)], @args);\n    $_readcor = 0 unless (defined($_readcor));\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 next_map\n\n Title   : next_map\n Usage   : my $fpcmap = $mapio->next_map();\n Function: gets the fpcmap from MapIO\n Returns : object of type L<Bio::Map::MapI>\n Args    : none","parameters":[{"label":"$self"}]},"kind":12,"line":109,"children":[{"definition":"my","name":"$self","containerName":"next_map","localvar":"my","kind":13,"line":111},{"localvar":"my","definition":"my","name":"$line","containerName":"next_map","line":113,"kind":13},{"containerName":"next_map","definition":"my","name":"$name","localvar":"my","kind":13,"line":114},{"kind":13,"line":114,"containerName":"next_map","name":"$fpcver"},{"containerName":"next_map","name":"$moddate","kind":13,"line":114},{"kind":13,"line":114,"name":"$moduser","containerName":"next_map"},{"kind":13,"line":114,"name":"$contigcnt","containerName":"next_map"},{"kind":13,"line":114,"containerName":"next_map","name":"$clonecnt"},{"containerName":"next_map","name":"$markerscnt","kind":13,"line":114},{"kind":13,"line":115,"name":"$bandcnt","containerName":"next_map"},{"kind":13,"line":115,"name":"$marker","containerName":"next_map"},{"containerName":"next_map","name":"$seqclone","line":115,"kind":13},{"line":116,"kind":13,"localvar":"my","containerName":"next_map","name":"$corfile","definition":"my"},{"name":"$corindex","containerName":"next_map","kind":13,"line":116},{"kind":13,"line":116,"name":"$BUFFER","containerName":"next_map"},{"localvar":"my","containerName":"next_map","definition":"my","name":"@cordata","line":117,"kind":13},{"definition":"my","name":"%fpcmarker","containerName":"next_map","localvar":"my","kind":13,"line":118},{"localvar":"my","name":"$contig","definition":"my","containerName":"next_map","line":119,"kind":13},{"kind":13,"line":119,"containerName":"next_map","name":"$contigNumber"},{"name":"$curClone","definition":"my","containerName":"next_map","localvar":"my","kind":13,"line":120},{"containerName":"next_map","definition":"my","name":"$curMarker","localvar":"my","kind":13,"line":121},{"definition":"my","name":"$curContig","containerName":"next_map","localvar":"my","kind":13,"line":122},{"definition":"my","name":"%_clones","containerName":"next_map","localvar":"my","kind":13,"line":123},{"line":124,"kind":13,"localvar":"my","name":"%_markers","definition":"my","containerName":"next_map"},{"kind":13,"line":125,"containerName":"next_map","definition":"my","name":"%_contigs","localvar":"my"},{"kind":13,"line":126,"name":"$ctgzeropos","definition":"my","containerName":"next_map","localvar":"my"},{"line":128,"kind":13,"localvar":"my","name":"$map","definition":"my","containerName":"next_map"},{"name":"new","containerName":"next_map","line":128,"kind":12},{"name":"$filename","definition":"my","containerName":"next_map","localvar":"my","kind":13,"line":131},{"containerName":"next_map","name":"$self","line":131,"kind":13},{"containerName":"next_map","name":"file","line":131,"kind":12},{"line":132,"kind":13,"localvar":"my","name":"$fh","definition":"my","containerName":"next_map"},{"name":"$self","containerName":"next_map","line":132,"kind":13},{"name":"$_readcor","containerName":"next_map","kind":13,"line":134},{"line":135,"kind":13,"name":"$map","containerName":"next_map"},{"containerName":"next_map","name":"core_exists","line":135,"kind":12},{"name":"$_readcor","containerName":"next_map","line":135,"kind":13},{"containerName":"next_map","name":"$map","line":138,"kind":13},{"name":"core_exists","containerName":"next_map","line":138,"kind":12},{"line":141,"kind":13,"containerName":"next_map","name":"$map"},{"containerName":"next_map","name":"core_exists","kind":12,"line":141},{"name":"$corfile","containerName":"next_map","line":142,"kind":13},{"kind":13,"line":142,"containerName":"next_map","name":"$filename"},{"name":"$filename","containerName":"next_map","kind":13,"line":142},{"name":"$corfile","containerName":"next_map","line":143,"kind":13},{"containerName":"next_map","name":"$BUFFER","line":144,"kind":13},{"name":"@cordata","containerName":"next_map","kind":13,"line":145},{"kind":13,"line":145,"containerName":"next_map","name":"$BUFFER"},{"name":"$map","containerName":"next_map","kind":13,"line":149},{"line":149,"kind":12,"name":"core_exists","containerName":"next_map"},{"name":"$line","containerName":"next_map","kind":13,"line":154},{"name":"$fh","containerName":"next_map","kind":13,"line":154},{"kind":13,"line":155,"name":"$line","containerName":"next_map"},{"line":157,"kind":13,"name":"$line","containerName":"next_map"},{"containerName":"next_map","name":"$map","kind":13,"line":157},{"kind":12,"line":157,"name":"name","containerName":"next_map"},{"containerName":"next_map","name":"$line","kind":13,"line":158},{"kind":13,"line":159,"containerName":"next_map","name":"$version","definition":"my","localvar":"my"},{"line":160,"kind":13,"containerName":"next_map","name":"$version"},{"kind":13,"line":161,"name":"$map","containerName":"next_map"},{"containerName":"next_map","name":"version","kind":12,"line":161},{"containerName":"next_map","name":"$line","line":162,"kind":13},{"line":162,"kind":13,"name":"$map","containerName":"next_map"},{"line":162,"kind":12,"containerName":"next_map","name":"modification_user"},{"kind":13,"line":165,"containerName":"next_map","name":"$line"},{"name":"$map","containerName":"next_map","kind":13,"line":167},{"containerName":"next_map","name":"group_type","line":167,"kind":12},{"containerName":"next_map","name":"$map","line":168,"kind":13},{"name":"group_abbr","containerName":"next_map","line":168,"kind":12},{"name":"$line","containerName":"next_map","line":171,"kind":13},{"line":174,"kind":13,"name":"$map","containerName":"next_map"},{"name":"group_type","containerName":"next_map","line":174,"kind":12},{"line":174,"kind":13,"containerName":"next_map","name":"$map"},{"containerName":"next_map","name":"group_abbr","line":174,"kind":12},{"containerName":"next_map","name":"$map","kind":13,"line":175},{"containerName":"next_map","name":"group_type","line":175,"kind":12},{"name":"$map","containerName":"next_map","kind":13,"line":176},{"line":176,"kind":12,"name":"group_abbr","containerName":"next_map"},{"name":"$_contigs","containerName":"next_map","line":179,"kind":13},{"containerName":"next_map","name":"$_contigs","line":180,"kind":13},{"name":"$line","containerName":"next_map","line":183,"kind":13},{"name":"$fh","containerName":"next_map","line":183,"kind":13},{"containerName":"next_map","name":"$marker","line":184,"kind":13},{"containerName":"next_map","name":"$contig","line":185,"kind":13},{"containerName":"next_map","name":"$seqclone","line":186,"kind":13},{"kind":13,"line":187,"name":"$contigNumber","containerName":"next_map"},{"line":189,"kind":13,"localvar":"my","containerName":"next_map","definition":"my","name":"$type"},{"containerName":"next_map","name":"$name","line":189,"kind":13},{"definition":"my","name":"@amatch","containerName":"next_map","localvar":"my","kind":13,"line":190},{"kind":13,"line":190,"containerName":"next_map","name":"@pmatch"},{"kind":13,"line":190,"name":"@ematch","containerName":"next_map"},{"containerName":"next_map","name":"$bandsread","definition":"my","localvar":"my","kind":13,"line":192},{"name":"$line","containerName":"next_map","line":194,"kind":13},{"name":"$line","containerName":"next_map","kind":13,"line":197},{"name":"$type","containerName":"next_map","line":200,"kind":13},{"kind":13,"line":200,"name":"$name","containerName":"next_map"},{"name":"$name","containerName":"next_map","kind":13,"line":202},{"containerName":"next_map","name":"$seqclone","kind":13,"line":203},{"containerName":"next_map","name":"$_clones","kind":13,"line":206},{"name":"$name","containerName":"next_map","kind":13,"line":206},{"kind":13,"line":206,"name":"$type","containerName":"next_map"},{"line":207,"kind":13,"name":"$_clones","containerName":"next_map"},{"line":207,"kind":13,"containerName":"next_map","name":"$name"},{"line":208,"kind":13,"containerName":"next_map","name":"$_contigs"},{"line":208,"kind":13,"containerName":"next_map","name":"$name"},{"name":"$temp","definition":"my","containerName":"next_map","localvar":"my","kind":13,"line":210},{"name":"$line","containerName":"next_map","kind":13,"line":213},{"containerName":"next_map","name":"$fh","kind":13,"line":213},{"containerName":"next_map","name":"$line","line":213,"kind":13},{"line":215,"kind":13,"containerName":"next_map","name":"$line"},{"kind":13,"line":216,"name":"$_clones","containerName":"next_map"},{"line":216,"kind":13,"name":"$name","containerName":"next_map"},{"line":217,"kind":13,"containerName":"next_map","name":"$_contigs"},{"containerName":"next_map","name":"$name","kind":13,"line":217},{"line":219,"kind":13,"name":"$_contigs","containerName":"next_map"},{"kind":13,"line":219,"containerName":"next_map","name":"$name"},{"containerName":"next_map","name":"$temp","kind":13,"line":221},{"line":222,"kind":13,"name":"$contigNumber","containerName":"next_map"},{"name":"$line","containerName":"next_map","line":223,"kind":13},{"line":223,"kind":13,"containerName":"next_map","name":"$fh"},{"containerName":"next_map","name":"$line","kind":13,"line":224},{"kind":13,"line":225,"containerName":"next_map","name":"$_clones"},{"name":"$name","containerName":"next_map","kind":13,"line":225},{"containerName":"next_map","name":"$temp","line":225,"kind":13},{"name":"$_contigs","containerName":"next_map","line":227,"kind":13},{"containerName":"next_map","name":"$contigNumber","kind":13,"line":227},{"kind":13,"line":228,"name":"$temp","containerName":"next_map"},{"containerName":"next_map","name":"$_contigs","line":228,"kind":13},{"containerName":"next_map","name":"$contigNumber","line":228,"kind":13},{"kind":13,"line":229,"containerName":"next_map","name":"$_contigs"},{"containerName":"next_map","name":"$contigNumber","kind":13,"line":229},{"name":"$temp","containerName":"next_map","line":230,"kind":13},{"name":"$_clones","containerName":"next_map","kind":13,"line":232},{"containerName":"next_map","name":"$name","line":232,"kind":13},{"name":"$_contigs","containerName":"next_map","kind":13,"line":234},{"containerName":"next_map","name":"$contigNumber","line":234,"kind":13},{"line":235,"kind":13,"containerName":"next_map","name":"$_contigs"},{"kind":13,"line":235,"name":"$contigNumber","containerName":"next_map"},{"name":"$_contigs","containerName":"next_map","kind":13,"line":236},{"containerName":"next_map","name":"$contigNumber","line":236,"kind":13},{"name":"$line","containerName":"next_map","kind":13,"line":239},{"line":240,"kind":13,"localvar":"my","containerName":"next_map","name":"$matchtype","definition":"my"},{"containerName":"next_map","name":"$_clones","kind":13,"line":241},{"kind":13,"line":241,"containerName":"next_map","name":"$name"},{"name":"$matchtype","containerName":"next_map","line":241,"kind":13},{"line":243,"kind":13,"name":"$line","containerName":"next_map"},{"name":"$_clones","containerName":"next_map","kind":13,"line":244},{"name":"$name","containerName":"next_map","line":244,"kind":13},{"name":"$_markers","containerName":"next_map","kind":13,"line":245},{"kind":13,"line":245,"containerName":"next_map","name":"$name"},{"kind":13,"line":246,"containerName":"next_map","name":"$_markers"},{"name":"$_markers","containerName":"next_map","line":247,"kind":13},{"name":"$contigNumber","containerName":"next_map","kind":13,"line":247},{"containerName":"next_map","name":"$_contigs","kind":13,"line":248},{"kind":13,"line":248,"containerName":"next_map","name":"$contigNumber"},{"line":250,"kind":13,"containerName":"next_map","name":"$line"},{"kind":13,"line":250,"name":"$bandsread","containerName":"next_map"},{"localvar":"my","definition":"my","name":"$i","containerName":"next_map","line":251,"kind":13},{"containerName":"next_map","name":"@numbands","definition":"my","localvar":"my","kind":13,"line":252},{"containerName":"next_map","name":"$bandsread","kind":13,"line":253},{"name":"$map","containerName":"next_map","line":255,"kind":13},{"name":"core_exists","containerName":"next_map","line":255,"kind":12},{"kind":13,"line":256,"name":"$i","containerName":"next_map"},{"name":"@numbands","containerName":"next_map","kind":13,"line":257},{"name":"$cordata","containerName":"next_map","kind":13,"line":257},{"line":257,"kind":13,"name":"$i","containerName":"next_map"},{"kind":13,"line":258,"containerName":"next_map","name":"$i"},{"kind":13,"line":260,"name":"$_clones","containerName":"next_map"},{"name":"$name","containerName":"next_map","line":260,"kind":13},{"kind":13,"line":260,"name":"@numbands","containerName":"next_map"},{"line":263,"kind":13,"containerName":"next_map","name":"@numbands"},{"line":264,"kind":13,"containerName":"next_map","name":"$_clones"},{"containerName":"next_map","name":"$name","kind":13,"line":264},{"kind":13,"line":264,"name":"@numbands","containerName":"next_map"},{"kind":13,"line":266,"name":"$_contigs","containerName":"next_map"},{"line":266,"kind":13,"containerName":"next_map","name":"$name"},{"kind":13,"line":267,"name":"$_clones","containerName":"next_map"},{"name":"$name","containerName":"next_map","kind":13,"line":267},{"name":"$ctgzeropos","containerName":"next_map","line":267,"kind":13},{"containerName":"next_map","name":"$_clones","line":268,"kind":13},{"kind":13,"line":268,"name":"$name","containerName":"next_map"},{"kind":13,"line":268,"containerName":"next_map","name":"$ctgzeropos"},{"containerName":"next_map","name":"$_contigs","kind":13,"line":269},{"line":269,"kind":13,"containerName":"next_map","name":"$ctgzeropos"},{"line":270,"kind":13,"containerName":"next_map","name":"$ctgzeropos"},{"name":"$line","containerName":"next_map","kind":13,"line":273},{"name":"$_clones","containerName":"next_map","line":274,"kind":13},{"kind":13,"line":274,"containerName":"next_map","name":"$name"},{"containerName":"next_map","name":"$line","kind":13,"line":276},{"kind":13,"line":277,"name":"$_clones","containerName":"next_map"},{"line":277,"kind":13,"name":"$name","containerName":"next_map"},{"name":"$_clones","containerName":"next_map","line":278,"kind":13},{"name":"$name","containerName":"next_map","kind":13,"line":278},{"name":"$seqclone","containerName":"next_map","line":279,"kind":13},{"name":"$_clones","containerName":"next_map","kind":13,"line":281},{"name":"$name","containerName":"next_map","kind":13,"line":281},{"line":285,"kind":13,"name":"$line","containerName":"next_map"},{"kind":13,"line":286,"name":"$_clones","containerName":"next_map"},{"kind":13,"line":286,"containerName":"next_map","name":"$name"},{"line":288,"kind":13,"name":"$line","containerName":"next_map"},{"line":289,"kind":13,"containerName":"next_map","name":"$_clones"},{"kind":13,"line":289,"containerName":"next_map","name":"$name"},{"containerName":"next_map","name":"$_clones","line":290,"kind":13},{"kind":13,"line":290,"containerName":"next_map","name":"$name"},{"kind":13,"line":292,"name":"$line","containerName":"next_map"},{"name":"$_clones","containerName":"next_map","kind":13,"line":293},{"containerName":"next_map","name":"$name","kind":13,"line":293},{"name":"$_clones","containerName":"next_map","kind":13,"line":294},{"containerName":"next_map","name":"$name","kind":13,"line":294},{"name":"$curClone","containerName":"next_map","kind":13,"line":298},{"line":300,"kind":13,"containerName":"next_map","name":"$self"},{"containerName":"next_map","name":"verbose","kind":12,"line":300},{"kind":13,"line":300,"name":"$curClone","containerName":"next_map"},{"kind":13,"line":303,"containerName":"next_map","name":"$map"},{"name":"_setCloneRef","containerName":"next_map","kind":12,"line":303},{"kind":13,"line":303,"containerName":"next_map","name":"%_clones"},{"name":"$line","containerName":"next_map","kind":13,"line":304},{"kind":13,"line":304,"containerName":"next_map","name":"$fh"},{"kind":13,"line":306,"name":"$line","containerName":"next_map"},{"kind":13,"line":306,"name":"$fh","containerName":"next_map"},{"containerName":"next_map","name":"$line","kind":13,"line":306},{"name":"$type","definition":"my","containerName":"next_map","localvar":"my","kind":13,"line":307},{"line":307,"kind":13,"containerName":"next_map","name":"$name"},{"name":"$line","containerName":"next_map","kind":13,"line":309},{"line":311,"kind":13,"containerName":"next_map","name":"$type"},{"line":311,"kind":13,"name":"$name","containerName":"next_map"},{"kind":13,"line":313,"name":"$_markers","containerName":"next_map"},{"name":"$name","containerName":"next_map","line":313,"kind":13},{"line":313,"kind":13,"name":"$type","containerName":"next_map"},{"containerName":"next_map","name":"$_markers","kind":13,"line":314},{"kind":13,"line":314,"name":"$name","containerName":"next_map"},{"kind":13,"line":315,"containerName":"next_map","name":"$_markers"},{"name":"$name","containerName":"next_map","line":315,"kind":13},{"kind":13,"line":316,"name":"$_markers","containerName":"next_map"},{"kind":13,"line":316,"name":"$name","containerName":"next_map"},{"kind":13,"line":318,"name":"$line","containerName":"next_map"},{"kind":13,"line":318,"containerName":"next_map","name":"$fh"},{"kind":13,"line":318,"containerName":"next_map","name":"$line"},{"kind":13,"line":319,"containerName":"next_map","name":"$line"},{"containerName":"next_map","definition":"my","name":"$position","localvar":"my","kind":13,"line":320},{"line":321,"kind":13,"containerName":"next_map","name":"$position"},{"containerName":"next_map","name":"$position","kind":13,"line":321},{"containerName":"next_map","name":"$_markers","line":323,"kind":13},{"line":323,"kind":13,"name":"$name","containerName":"next_map"},{"line":323,"kind":13,"containerName":"next_map","name":"$position"},{"name":"$_markers","containerName":"next_map","kind":13,"line":324},{"name":"$name","containerName":"next_map","kind":13,"line":324},{"name":"$_markers","containerName":"next_map","kind":13,"line":325},{"name":"$name","containerName":"next_map","kind":13,"line":325},{"containerName":"next_map","name":"$_markers","line":328,"kind":13},{"name":"$name","containerName":"next_map","line":328,"kind":13},{"name":"$_markers","containerName":"next_map","line":331,"kind":13},{"containerName":"next_map","name":"$name","kind":13,"line":331},{"line":334,"kind":13,"containerName":"next_map","name":"$line"},{"localvar":"my","containerName":"next_map","name":"$grpmatch","definition":"my","line":335,"kind":13},{"kind":13,"line":336,"name":"$grptype","definition":"my","containerName":"next_map","localvar":"my"},{"name":"$map","containerName":"next_map","line":336,"kind":13},{"kind":12,"line":336,"name":"group_type","containerName":"next_map"},{"containerName":"next_map","name":"$grpmatch","kind":13,"line":338},{"localvar":"my","containerName":"next_map","name":"$group","definition":"my","line":340,"kind":13},{"name":"$subgroup","containerName":"next_map","kind":13,"line":340},{"containerName":"next_map","name":"$group","kind":13,"line":341},{"line":342,"kind":13,"name":"$subgroup","containerName":"next_map"},{"containerName":"next_map","name":"$subgroup","kind":13,"line":344},{"line":344,"kind":13,"containerName":"next_map","name":"$subgroup"},{"line":344,"kind":13,"name":"$subgroup","containerName":"next_map"},{"line":346,"kind":13,"name":"$_markers","containerName":"next_map"},{"kind":13,"line":346,"name":"$name","containerName":"next_map"},{"name":"$group","containerName":"next_map","kind":13,"line":346},{"name":"$_markers","containerName":"next_map","line":347,"kind":13},{"kind":13,"line":347,"name":"$name","containerName":"next_map"},{"containerName":"next_map","name":"$subgroup","line":347,"kind":13},{"line":349,"kind":13,"containerName":"next_map","name":"$line"},{"containerName":"next_map","name":"$_markers","kind":13,"line":350},{"kind":13,"line":350,"containerName":"next_map","name":"$name"},{"line":351,"kind":13,"containerName":"next_map","name":"$_markers"},{"line":351,"kind":13,"name":"$name","containerName":"next_map"},{"line":354,"kind":13,"containerName":"next_map","name":"$_markers"},{"line":354,"kind":13,"containerName":"next_map","name":"$name"},{"containerName":"next_map","name":"$_markers","kind":13,"line":357},{"kind":13,"line":357,"containerName":"next_map","name":"$name"},{"name":"$line","containerName":"next_map","line":360,"kind":13},{"kind":13,"line":361,"name":"$_markers","containerName":"next_map"},{"line":361,"kind":13,"containerName":"next_map","name":"$name"},{"name":"$line","containerName":"next_map","line":363,"kind":13},{"kind":13,"line":364,"name":"$_markers","containerName":"next_map"},{"containerName":"next_map","name":"$name","kind":13,"line":364},{"kind":13,"line":365,"name":"$_markers","containerName":"next_map"},{"name":"$name","containerName":"next_map","kind":13,"line":365},{"kind":13,"line":368,"name":"$curMarker","containerName":"next_map"},{"name":"$self","containerName":"next_map","line":370,"kind":13},{"name":"verbose","containerName":"next_map","line":370,"kind":12},{"line":370,"kind":13,"name":"$curMarker","containerName":"next_map"},{"kind":13,"line":373,"containerName":"next_map","name":"$map"},{"name":"_setMarkerRef","containerName":"next_map","line":373,"kind":12},{"name":"%_markers","containerName":"next_map","line":373,"kind":13},{"name":"$ctgname","definition":"my","containerName":"next_map","localvar":"my","kind":13,"line":375},{"line":376,"kind":13,"localvar":"my","containerName":"next_map","name":"$grpabbr","definition":"my"},{"containerName":"next_map","name":"$map","kind":13,"line":376},{"line":376,"kind":12,"containerName":"next_map","name":"group_abbr"},{"line":377,"kind":13,"localvar":"my","containerName":"next_map","definition":"my","name":"$chr_remark"},{"name":"$_contigs","containerName":"next_map","line":379,"kind":13},{"line":381,"kind":13,"containerName":"next_map","name":"$line"},{"name":"$fh","containerName":"next_map","line":381,"kind":13},{"name":"$line","containerName":"next_map","kind":13,"line":383},{"name":"$ctgname","containerName":"next_map","line":384,"kind":13},{"name":"$_contigs","containerName":"next_map","line":385,"kind":13},{"line":385,"kind":13,"containerName":"next_map","name":"$ctgname"},{"containerName":"next_map","name":"$_contigs","line":386,"kind":13},{"kind":13,"line":386,"name":"$ctgname","containerName":"next_map"},{"line":387,"kind":13,"name":"$_contigs","containerName":"next_map"},{"containerName":"next_map","name":"$ctgname","kind":13,"line":387},{"containerName":"next_map","name":"$line","line":389,"kind":13},{"name":"$_contigs","containerName":"next_map","line":390,"kind":13},{"line":390,"kind":13,"name":"$ctgname","containerName":"next_map"},{"kind":13,"line":391,"name":"$line","containerName":"next_map"},{"kind":13,"line":392,"containerName":"next_map","name":"$_contigs"},{"containerName":"next_map","name":"$ctgname","line":392,"kind":13},{"containerName":"next_map","name":"$_contigs","kind":13,"line":393},{"line":393,"kind":13,"containerName":"next_map","name":"$ctgname"},{"containerName":"next_map","name":"$line","kind":13,"line":397},{"containerName":"next_map","name":"$_contigs","line":399,"kind":13},{"kind":13,"line":399,"containerName":"next_map","name":"$ctgname"},{"name":"$_contigs","containerName":"next_map","kind":13,"line":400},{"name":"$ctgname","containerName":"next_map","line":400,"kind":13},{"name":"$_contigs","containerName":"next_map","kind":13,"line":403},{"line":403,"kind":13,"name":"$ctgname","containerName":"next_map"},{"containerName":"next_map","name":"$_contigs","line":406,"kind":13},{"name":"$ctgname","containerName":"next_map","kind":13,"line":406},{"name":"$line","containerName":"next_map","kind":13,"line":409},{"containerName":"next_map","name":"$_contigs","kind":13,"line":410},{"name":"$ctgname","containerName":"next_map","line":410,"kind":13},{"containerName":"next_map","name":"$line","kind":13,"line":412},{"containerName":"next_map","name":"$_contigs","line":413,"kind":13},{"containerName":"next_map","name":"$ctgname","kind":13,"line":413},{"line":415,"kind":13,"containerName":"next_map","name":"$grpabbr"},{"containerName":"next_map","name":"$line","line":415,"kind":13},{"localvar":"my","definition":"my","name":"$grpmatch","containerName":"next_map","line":417,"kind":13},{"containerName":"next_map","name":"$pos","definition":"my","localvar":"my","kind":13,"line":418},{"containerName":"next_map","name":"$pos","line":419,"kind":13},{"line":420,"kind":13,"containerName":"next_map","name":"$pos"},{"containerName":"next_map","name":"$_contigs","kind":13,"line":423},{"kind":13,"line":423,"name":"$ctgname","containerName":"next_map"},{"kind":13,"line":424,"containerName":"next_map","name":"$_contigs"},{"kind":13,"line":424,"name":"$ctgname","containerName":"next_map"},{"line":424,"kind":13,"name":"$pos","containerName":"next_map"},{"name":"$_contigs","containerName":"next_map","line":425,"kind":13},{"kind":13,"line":425,"containerName":"next_map","name":"$ctgname"},{"name":"$grpmatch","containerName":"next_map","kind":13,"line":427},{"line":428,"kind":13,"name":"$_contigs","containerName":"next_map"},{"kind":13,"line":428,"name":"$ctgname","containerName":"next_map"},{"name":"$grpmatch","containerName":"next_map","line":430,"kind":13},{"line":432,"kind":13,"localvar":"my","name":"$group","definition":"my","containerName":"next_map"},{"kind":13,"line":432,"name":"$subgroup","containerName":"next_map"},{"name":"$group","containerName":"next_map","kind":13,"line":433},{"kind":13,"line":433,"containerName":"next_map","name":"$grpabbr"},{"line":434,"kind":13,"containerName":"next_map","name":"$subgroup"},{"containerName":"next_map","name":"$grpabbr","line":434,"kind":13},{"containerName":"next_map","name":"$group","line":436,"kind":13},{"line":436,"kind":13,"name":"$grpabbr","containerName":"next_map"},{"line":437,"kind":13,"name":"$subgroup","containerName":"next_map"},{"containerName":"next_map","name":"$grpabbr","line":437,"kind":13},{"kind":13,"line":439,"name":"$subgroup","containerName":"next_map"},{"name":"$subgroup","containerName":"next_map","kind":13,"line":439},{"name":"$subgroup","containerName":"next_map","kind":13,"line":439},{"kind":13,"line":440,"name":"$_contigs","containerName":"next_map"},{"containerName":"next_map","name":"$ctgname","kind":13,"line":440},{"name":"$group","containerName":"next_map","kind":13,"line":440},{"containerName":"next_map","name":"$_contigs","line":441,"kind":13},{"name":"$ctgname","containerName":"next_map","kind":13,"line":441},{"line":441,"kind":13,"name":"$subgroup","containerName":"next_map"},{"name":"$_contigs","containerName":"next_map","line":445,"kind":13},{"containerName":"next_map","name":"$ctgname","kind":13,"line":445},{"containerName":"next_map","name":"$grpmatch","kind":13,"line":445},{"name":"$_contigs","containerName":"next_map","line":449,"kind":13},{"containerName":"next_map","name":"$ctgname","line":449,"kind":13},{"containerName":"next_map","name":"$_contigs","kind":13,"line":450},{"containerName":"next_map","name":"$ctgname","kind":13,"line":450},{"containerName":"next_map","name":"$curContig","kind":13,"line":453},{"containerName":"next_map","name":"$self","line":455,"kind":13},{"containerName":"next_map","name":"verbose","kind":12,"line":455},{"containerName":"next_map","name":"$curContig","line":455,"kind":13},{"kind":13,"line":458,"name":"$map","containerName":"next_map"},{"containerName":"next_map","name":"_setContigRef","kind":12,"line":458},{"kind":13,"line":458,"name":"%_contigs","containerName":"next_map"},{"containerName":"next_map","name":"$map","kind":13,"line":459},{"kind":12,"line":459,"name":"_calc_markerposition","containerName":"next_map"},{"containerName":"next_map","name":"$map","line":460,"kind":13},{"name":"_calc_contigposition","containerName":"next_map","kind":12,"line":460},{"kind":13,"line":460,"containerName":"next_map","name":"$map"},{"containerName":"next_map","name":"version","line":460,"kind":12},{"containerName":"next_map","name":"$map","kind":13,"line":461},{"kind":12,"line":461,"containerName":"next_map","name":"_calc_contiggroup"},{"kind":13,"line":461,"containerName":"next_map","name":"$map"},{"containerName":"next_map","name":"version","kind":12,"line":461},{"containerName":"next_map","name":"$map","line":463,"kind":13}],"name":"next_map","range":{"start":{"character":0,"line":109},"end":{"line":464,"character":9999}}},{"containerName":"Map::Physical","name":"Bio","kind":12,"line":128},{"kind":12,"line":320,"name":"floor"},{"name":"floor","kind":12,"line":324},{"kind":12,"children":[{"localvar":"my","containerName":"write_map","definition":"my","name":"$self","line":478,"kind":13},{"name":"@args","containerName":"write_map","kind":13,"line":478},{"kind":13,"line":479,"containerName":"write_map","name":"$self"},{"line":479,"kind":12,"name":"throw_not_implemented","containerName":"write_map"}],"line":477,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"# fpc.pm,v 1.2.2.1 2005/10/09 15:16:27 jason Exp\n#\n# BioPerl module for Bio::MapIO::fpc\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Gaurav Gupta <gaurav@genome.arizona.edu>\n#\n# Copyright AGCoL\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::MapIO::fpc - A FPC Map reader\n\n=head1 SYNOPSIS\n\n# do not use this object directly it is accessed through the Bio::MapIO system\n\n    use Bio::MapIO;\n\n     -format  : specifies the format of the file format is \"fpc\",\n     -file    : specifies the name of the .fpc file\n     -readcor : boolean argument, indicating if .cor is to be read\n                 or not. It looks for the .cor file in the same path\n                 as .fpc file.\n                 0 : doesn't read .cor file\n                 1 : reads the .cor file\n                 [default 0]\n     -verbose : indicates the process of loading of fpc file\n    my $mapio = Bio::MapIO->new(-format  => \"fpc\",\n                               -file    => \"rice.fpc\",\n                               -readcor => 0,\n                               -verbose => 0);\n\n    my $map = $mapio->next_map();\n\n    foreach my $marker ( $map->each_markerid() ) {\n         # loop through the markers associated with the map\n         # likewise for contigs, clones, etc.\n    }\n\n\n=head1 DESCRIPTION\n\nThis object contains code for parsing and processing FPC files and creating\nL<Bio::Map::Physical> object from it.\n\nFor faster access and better optimization, the data is stored internally in\nhashes. The corresponding objects are created on request.\n\nWe handle reading of the FPC ourselves, since MapIO module of Bioperl adds\ntoo much overhead.\n\n\n# Let the code begin...\n\npackage Bio::MapIO::fpc;\nuse strict;\nuse POSIX;\n\nuse Bio::Map::Physical;\nuse Bio::Map::Clone;\nuse Bio::Map::Contig;\nuse Bio::Map::FPCMarker;\nuse Bio::Range;\n\nuse base qw(Bio::MapIO);\n\nmy $_readcor;\n\n=head1 Initializer\n\n=head2 _initialize\n\n Title   : _initialize\n Usage   : called implicitly\n Function: calls the SUPER::_initialize\n Returns : nothing\n Args    : species, readcor\n\n\nsub _initialize{\n    my ($self,@args) = @_;\n    my $species;\n    $self->SUPER::_initialize(@args);\n    ($species,$_readcor) = $self->_rearrange([qw(SPECIES READCOR)], @args);\n    $_readcor = 0 unless (defined($_readcor));\n}\n\n=head1 Access Methods\n\nThese methods let you get and set the member variables\n\n=head2 next_map\n\n Title   : next_map\n Usage   : my $fpcmap = $mapio->next_map();\n Function: gets the fpcmap from MapIO\n Returns : object of type L<Bio::Map::MapI>\n Args    : none\n\n\nsub next_map{\n\n    my ($self) = @_;\n\n    my $line;\n    my ($name,$fpcver,$moddate,$moduser,$contigcnt,$clonecnt,$markerscnt,\n        $bandcnt,$marker,$seqclone);\n    my ($corfile,$corindex,$BUFFER);\n    my @cordata;\n    my %fpcmarker;\n    my ($contig, $contigNumber);\n    my $curClone  = 0;\n    my $curMarker = 0;\n    my $curContig = 0;\n    my %_clones;\n    my %_markers;\n    my %_contigs;\n    my $ctgzeropos = 1;\n\n    my $map = Bio::Map::Physical->new('-units' => 'CB',\n                                     '-type'  => 'physical');\n\n    my $filename = $self->file();\n    my $fh = $self->{'_filehandle'};\n\n    if (defined($_readcor)) {\n        $map->core_exists($_readcor);\n    }\n    else {\n        $map->core_exists(0);\n    }\n\n    if ($map->core_exists()) {\n        $corfile = substr($filename,0,length($filename)-3).\"cor\";\n        if (open(CORE,$corfile)) {\n            while(read(CORE,$BUFFER,2)) {\n                push(@cordata,unpack('n*', $BUFFER));\n            }\n        }\n        else {\n            $map->core_exists(0);\n        }\n    }\n\n    ## Read in the header\n    while (defined($line = <$fh>)) {\n        chomp($line);\n\n        if ($line =~ m{^//\\s+fpc\\s+project\\s+(.+)}) { $map->name($1); }\n        if ($line =~ m{^//\\s+([\\d.]+)}) {\n            my $version = $1;\n            $version =~ /((\\d+)\\.(\\d+))(.*)/;\n            $map->version($1);\n            if ($line =~ /User:\\s+(.+)/) { $map->modification_user($1); }\n        }\n\n        if ($line =~ m{^//\\s+Framework\\s+(\\w+)\\s+(\\w+)\\s+([-\\w]+)\\s+(\\w+)\\s+(\\w+)\\s+(.+)$})\n        {\n            $map->group_type($3) if ($2 eq \"Label\");\n            $map->group_abbr($5) if ($4 eq \"Abbrev\");\n        }\n\n        last unless ($line =~ m{^//});\n    }\n\n    if (!defined($map->group_type()) || !defined($map->group_abbr()) ) {\n        $map->group_type(\"Chromosome\");\n        $map->group_abbr(\"Chr\");\n    }\n\n    $_contigs{0}{'range'}{'end'}   = 0;\n    $_contigs{0}{'range'}{'start'} = 0;\n\n    ## Read in the clone data\n    while (defined($line = <$fh>)) {\n        $marker = 0;\n        $contig = 0;\n        $seqclone = 0;\n        $contigNumber = 0;\n\n        my ($type,$name);\n        my (@amatch,@pmatch,@ematch);\n\n        my $bandsread = 0;\n\n        last if ($line =~ /^Markerdata/);\n\n\n        $line =~ /^(\\w+)\\s+:\\s+\"(.+)\"/;\n\n        ## these will be set if we did find the clone line\n        ($type, $name) = ($1, $2);\n\n        if ($name =~ /sd1/) {\n            $seqclone = 1;\n        }\n\n        $_clones{$name}{'type'} = $type;\n        $_clones{$name}{'contig'} = 0;\n        $_contigs{'0'}{'clones'}{$name}  = 0;\n\n        my $temp;\n\n        ## Loop through the following lines, getting attributes for clone\n        while (defined($line = <$fh>) && $line !~ /^\\s*\\n$/)  {\n\n            if ($line =~ /^Map \"ctg(\\d+)\" Ends (Left|Right) ([-\\d]+)/)  {\n                $_clones{$name}{'contig'} = $1;\n                $_contigs{$1}{'clones'}{$name} = 0;\n\n                delete($_contigs{'0'}{'clones'}{$name});\n\n                $temp = $3;\n                $contigNumber = $1;\n                $line = <$fh>;\n                $line =~ /^Map \"ctg(\\d+)\" Ends (Left|Right) ([\\d]+)/;\n                $_clones{$name}{'range'}{'start'} = $temp;\n\n                $_contigs{$contigNumber}{'range'}{'start'} = $temp\n                    if (!exists($_contigs{$contigNumber}{'range'}{'start'})\n                        || $_contigs{$contigNumber}{'range'}{'start'}\n                        >  $temp );\n\n                $_clones{$name}{'range'}{'end'} = $3;\n\n                $_contigs{$contigNumber}{'range'}{'end'} = $3\n                    if (!exists($_contigs{$contigNumber}{'range'}{'end'})\n                        || $_contigs{$contigNumber}{'range'}{'end'} < $3 );\n\n            }\n            elsif ($line =~ /^([a-zA-Z]+)_match_to_\\w+\\s+\"(.+)\"/) {\n                my $matchtype = \"match\" . lc(substr($1, 0, 1));\n                $_clones{$name}{$matchtype}{$2} = 0;\n            }\n            elsif ($line =~ /^Positive_(\\w+)\\s+\"(.+)\"/) {\n                $_clones{$name}{'markers'}{$2} = 0;\n                $_markers{$2}{'clones'}{$name} = 0;\n                $_markers{$2}{'type'} = $1;\n                $_markers{$2}{'contigs'}{$contigNumber} = 0;\n                $_contigs{$contigNumber}{'markers'}{$2} = 0;\n            }\n            elsif ($line =~ /^Bands\\s+(\\d+)\\s+(\\d+)/ && !$bandsread) {\n                my $i = 0;\n                my @numbands;\n                $bandsread = 1;\n\n                if ($map->core_exists()) {\n                    while($i<$2){\n                        push(@numbands,$cordata[($1-1)+$i]);\n                        $i++;\n                    }\n                    $_clones{$name}{'bands'} = \\@numbands;\n                }\n                else {\n                    push(@numbands,$1,$2);\n                    $_clones{$name}{'bands'} = \\@numbands;\n                }\n                if (exists($_contigs{0}{'clones'}{$name})) {\n                    $_clones{$name}{'range'}{'start'} = $ctgzeropos;\n                    $_clones{$name}{'range'}{'end'} = $ctgzeropos + $2;\n                    $_contigs{0}{'range'}{'end'} = $ctgzeropos + $2;\n                    $ctgzeropos += $2;\n                }\n            }\n            elsif ($line =~ /^Gel_number\\s+(.+)/) {\n                $_clones{$name}{'gel'} = $1;\n            }\n            elsif ($line =~ /^Remark\\s+\"(.+)\"/)  {\n                $_clones{$name}{'remark'} .= $1;\n                $_clones{$name}{'remark'} .= \"\\n\";\n                if($seqclone == 1 ) {\n                    if( $1 =~ /\\,\\s+Chr(\\d+)\\s+/){\n                        $_clones{$name}{'group'} = $1;\n                    }\n                }\n            }\n            elsif ($line =~ /^Fp_number\\s+\"(.+)\"/) {\n                $_clones{$name}{'fp_number'} = $1;\n            }\n            elsif ($line =~ /^Shotgun\\s+(\\w+)\\s+(\\w+)/) {\n                $_clones{$name}{'sequence_type'} = $1;\n                $_clones{$name}{'sequence_status'} = $2;\n            }\n            elsif ($line =~ /^Fpc_remark\\s+\"(.+)\"/) {\n                $_clones{$name}{'fpc_remark'} .= $1;\n                $_clones{$name}{'fpc_remark'} .= \"\\n\";\n            }\n        }\n\n        $curClone++;\n        print \"Adding clone $curClone...\\n\\r\"\n            if ($self->verbose()  && $curClone % 1000 == 0);\n    }\n\n    $map->_setCloneRef(\\%_clones);\n    $line = <$fh>;\n\n    while (defined($line = <$fh>) && $line !~ /Contigdata/) {\n        my ($type,$name);\n\n        last if ($line !~ /^Marker_(\\w+)\\s+:\\s+\"(.+)\"/);\n\n        ($type, $name) = ($1, $2);\n\n        $_markers{$name}{'type'}   = $type;\n        $_markers{$name}{'group'}  = 0;\n        $_markers{$name}{'global'} = 0;\n        $_markers{$name}{'anchor'} = 0;\n\n        while (defined($line = <$fh>) && $line !~ /^\\s*\\n$/)  {\n            if ($line =~ /^Global_position\\s+([\\d.]+)\\s*(Frame)?/)  {\n                my $position = $1 - floor($1/1000)*1000;\n                $position = sprintf(\"%.2f\",$position);\n\n                $_markers{$name}{'global'} = $position;\n                $_markers{$name}{'group'}  = floor($1/1000);\n                $_markers{$name}{'anchor'} = 1;\n\n                if(defined($2)) {\n                    $_markers{$name}{'framework'} = 1;\n                }\n                else {\n                    $_markers{$name}{'framework'} = 0;\n                }\n            }\n            elsif ($line =~ /^Anchor_bin\\s+\"([\\w\\d.]+)\"/) {\n                my $grpmatch = $1;\n                my $grptype  = $map->group_type();\n\n                $grpmatch =~ /(\\d+|\\w)(.*)/;\n\n                my ($group,$subgroup);\n                $group    = $1;\n                $subgroup = $2;\n\n                $subgroup = substr($subgroup,1) if ($subgroup =~ /^\\./);\n\n                $_markers{$name}{'group'}      = $group;\n                $_markers{$name}{'subgroup'}   = $subgroup;\n            }\n            elsif ($line =~ /^Anchor_pos\\s+([\\d.]+)\\s+(F|P)?/){\n                $_markers{$name}{'global'}  = $1;\n                $_markers{$name}{'anchor'}  = 1;\n\n                if ($2 eq 'F') {\n                    $_markers{$name}{'framework'} = 1;\n                }\n                else {\n                    $_markers{$name}{'framework'} = 0;\n                }\n            }\n            elsif ($line =~ /^anchor$/) {\n                $_markers{$name}{'anchor'} = 1;\n            }\n            elsif ($line =~ /^Remark\\s+\"(.+)\"/)  {\n                $_markers{$name}{'remark'} .= $1;\n                $_markers{$name}{'remark'} .= \"\\n\";\n            }\n        }\n        $curMarker++;\n        print \"Adding Marker $curMarker...\\n\"\n            if ($self->verbose() && $curMarker % 1000 == 0);\n    }\n\n    $map->_setMarkerRef(\\%_markers);\n\n    my $ctgname;\n    my $grpabbr = $map->group_abbr();\n    my $chr_remark;\n\n    $_contigs{0}{'group'} = 0;\n\n    while (defined($line = <$fh>)) {\n\n        if ($line =~ /^Ctg(\\d+)/) {\n            $ctgname = $1;\n            $_contigs{$ctgname}{'group'}      = 0;\n            $_contigs{$ctgname}{'anchor'}     = 0;\n            $_contigs{$ctgname}{'position'}   = 0;\n\n            if ($line =~ /#\\w*(.*)\\w*$/) {\n                $_contigs{$ctgname}{'remark'} = $1;\n                if ($line =~ /#\\s+Chr(\\d+)\\s+/) {\n                    $_contigs{$ctgname}{'group'}  = $1;\n                    $_contigs{$ctgname}{'anchor'} = 1;\n                }\n            }\n        }\n        elsif ($line =~ /^Chr_remark\\s+\"(-|\\+|Chr(\\d+))\\s+(.+)\"$/) {\n\n            $_contigs{$ctgname}{'anchor'}     = 1;\n            $_contigs{$ctgname}{'chr_remark'} = $3 if(defined($3));\n\n            if (defined($2)) {\n                $_contigs{$ctgname}{'group'}  = $2;\n            }\n            else {\n                $_contigs{$ctgname}{'group'}  = \"?\";\n            }\n        }\n        elsif ($line =~ /^User_remark\\s+\"(.+)\"/) {\n            $_contigs{$ctgname}{'usr_remark'} = $1;\n        }\n        elsif ($line =~ /^Trace_remark\\s+\"(.+)\"/) {\n            $_contigs{$ctgname}{'trace_remark'} = $1;\n        }\n        elsif ($grpabbr && $line =~ /^Chr_remark\\s+\"(\\W|$grpabbr((\\d+)|(\\w+)|([.\\w\\d]+)))\\s*(\\{(.*)\\}|\\[(.*)\\])?\"\\s+(Pos\\s+((\\d.)+|NaN))(NOEDIT)?/)\n        {\n            my $grpmatch = $2;\n            my $pos = $10;\n            if ($pos eq \"NaN\") {\n                $pos = 0;\n                print \"Warning: Nan encountered for Contig position \\n\";\n            }\n            $_contigs{$ctgname}{'chr_remark'}   = $6;\n            $_contigs{$ctgname}{'position'} = $pos;\n            $_contigs{$ctgname}{'subgroup'} = 0;\n\n            if (defined($grpmatch)) {\n                $_contigs{$ctgname}{'anchor'} = 1;\n\n                if ($grpmatch =~ /((\\d+)((\\D\\d.\\d+)|(.\\d+)))|((\\w+)(\\.\\d+))/) {\n\n                    my ($group,$subgroup);\n                    $group    = $2 if($grpabbr eq \"Chr\");\n                    $subgroup = $3 if($grpabbr eq \"Chr\");\n\n                    $group    = $7 if($grpabbr eq \"Lg\");\n                    $subgroup = $8 if($grpabbr eq \"Lg\");\n\n                    $subgroup = substr($subgroup,1) if ($subgroup =~ /^\\./);\n                    $_contigs{$ctgname}{'group'}     = $group;\n                    $_contigs{$ctgname}{'subgroup'}  = $subgroup;\n\n                }\n                else {\n                    $_contigs{$ctgname}{'group'} = $grpmatch;\n                }\n            }\n            else {\n                $_contigs{$ctgname}{'anchor'} = 1;\n                $_contigs{$ctgname}{'group'}  = \"?\";\n            }\n        }\n        $curContig++;\n        print \"Adding Contig $curContig...\\n\"\n            if ($self->verbose() && $curContig % 100 == 0);\n    }\n\n    $map->_setContigRef(\\%_contigs);\n    $map->_calc_markerposition();\n    $map->_calc_contigposition() if ($map->version() < 7.0);\n    $map->_calc_contiggroup() if ($map->version() == 4.6);\n\n    return $map;\n}\n\n\n=head2 write_map\n\n Title   : write_map\n Usage   : $mapio->write_map($map);\n Function: Write a map out\n Returns : none\n Args    : Bio::Map::MapI","label":"write_map($self,@args)"},"detail":"($self,@args)","name":"write_map","range":{"start":{"line":477,"character":0},"end":{"character":9999,"line":480}}}]}