{"vars":[{"containerName":"","name":"base","kind":2,"line":131},{"signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Marker - An central map object representing a generic marker\nthat can have multiple location in several maps.\n\n=head1 SYNOPSIS\n\n  # get map objects somehow\n\n  # a marker with complex localisation\n  $o_usat = Bio::Map::Marker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t  -positions => [ [$map1, $position1], \n                                                  [$map1, $position2] \n\t\t\t\t\t\t] );\n\n  # The markers deal with Bio::Map::Position objects which can also\n  # be explicitely created and passed on to markers as an array ref:\n  $o_usat2 = Bio::Map::Marker->new(-name=>'Chad Super Marker 3',\n\t\t\t\t  -positions => [ $pos1, \n                                                  $pos2 \n\t\t\t\t\t\t] );\n\n  # a marker with unique position in a map\n  $marker1 = Bio::Map::Marker->new(-name=>'hypervariable1',\n\t\t\t\t   -map => $map1,\n\t\t\t\t   -position => 100\n\t\t\t\t   );\n\n  # an other way of creating a marker with unique position in a map:\n  $marker2 = Bio::Map::Marker->new(-name=>'hypervariable2');\n  $map1->add_element($marker2);\n  $marker2->position(100);\n\n  # position method is a short cut for get/setting unique positions\n  # which overwrites previous values\n  # to place a marker to other maps or to have multiple positions \n  # for a map within the same map use add_position()\n\n  $marker2->add_position(200);\t# new position in the same map\n  $marker2->add_position($map2,200); # new map\n\n  # setting a map() in a marker or adding a marker into a map are\n  # identical mathods. Both set the bidirectional connection which is\n  # used by the marker to remember its latest, default map.\n\n  # Regardes of how marker positions are created, they are stored and\n  # returned as Bio::Map::PositionI objects:\n\n  # unique position\n  print $marker1->position->value, \"\\n\";\n  # several positions\n  foreach $pos ($marker2->each_position($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nA Marker is a Bio::Map::Mappable with some properties particular to markers.\nIt also offers a number of convienience methods to make dealing with map\nelements easier.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Marker;\nuse strict;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::Mappable Bio::Map::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $marker = Bio::Map::Marker->new( -name => 'Whizzy marker',\n\t                                          -position => $position);\n Function: Builds a new Bio::Map::Marker object\n Returns : Bio::Map::Marker\n Args    :\n           -name    => name of this microsatellite \n                       [optional], string,default 'Unknown'\n           -default_map => the default map for this marker, a Bio::Map::MapI\n           -position => map position for this marker, a Bio::Map::PositionI\n           -positions => array ref of Bio::Map::PositionI objects\n\n           position and positions can also take as values anything the\n           corresponding methods can take"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":153,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"name":"@args","containerName":"new","line":153,"kind":13},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":154,"kind":13},{"kind":13,"line":154,"containerName":"new","name":"$class"},{"containerName":"new","name":"@args","line":154,"kind":13},{"line":155,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"$class","kind":13,"line":155},{"containerName":"new","name":"$class","line":155,"kind":13},{"name":"$name","definition":"my","containerName":"new","localvar":"my","kind":13,"line":157},{"name":"$default_map","containerName":"new","line":157,"kind":13},{"name":"$map","containerName":"new","line":157,"kind":13},{"name":"$position","containerName":"new","kind":13,"line":157},{"line":157,"kind":13,"containerName":"new","name":"$positions"},{"name":"$self","containerName":"new","line":158,"kind":13},{"line":158,"kind":12,"containerName":"new","name":"_rearrange"},{"kind":13,"line":163,"name":"@args","containerName":"new"},{"name":"$name","containerName":"new","kind":13,"line":165},{"name":"$self","containerName":"new","kind":13,"line":165},{"kind":12,"line":165,"name":"name","containerName":"new"},{"containerName":"new","name":"$name","line":165,"kind":13},{"line":166,"kind":13,"name":"$self","containerName":"new"},{"line":166,"kind":12,"name":"name","containerName":"new"},{"name":"$map","containerName":"new","kind":13,"line":168},{"line":168,"kind":13,"name":"$self","containerName":"new"},{"line":168,"kind":12,"containerName":"new","name":"default_map"},{"containerName":"new","name":"$map","kind":13,"line":168},{"name":"$default_map","containerName":"new","line":169,"kind":13},{"containerName":"new","name":"$self","line":169,"kind":13},{"name":"default_map","containerName":"new","kind":12,"line":169},{"containerName":"new","name":"$default_map","kind":13,"line":169},{"line":170,"kind":13,"containerName":"new","name":"$position"},{"name":"$self","containerName":"new","line":170,"kind":13},{"containerName":"new","name":"position","kind":12,"line":170},{"containerName":"new","name":"$position","line":170,"kind":13},{"name":"$positions","containerName":"new","kind":13,"line":171},{"name":"$self","containerName":"new","line":171,"kind":13},{"kind":12,"line":171,"name":"positions","containerName":"new"},{"name":"$positions","containerName":"new","line":171,"kind":13},{"kind":13,"line":173,"name":"$self","containerName":"new"}],"line":152,"kind":12,"range":{"end":{"line":174,"character":9999},"start":{"line":152,"character":0}},"name":"new"},{"line":154,"kind":12,"name":"SUPER","containerName":"new"},{"range":{"end":{"line":193,"character":9999},"start":{"character":0,"line":186}},"name":"default_map","children":[{"kind":13,"line":187,"name":"$self","definition":"my","containerName":"default_map","localvar":"my"},{"kind":13,"line":187,"containerName":"default_map","name":"$map"},{"kind":13,"line":188,"containerName":"default_map","name":"$map"},{"containerName":"default_map","name":"$self","kind":13,"line":189},{"line":189,"kind":12,"name":"thow","containerName":"default_map"},{"name":"$map","containerName":"default_map","kind":13,"line":189},{"containerName":"default_map","name":"isa","kind":12,"line":189},{"kind":13,"line":190,"containerName":"default_map","name":"$self"},{"kind":13,"line":190,"containerName":"default_map","name":"$map"},{"name":"$self","containerName":"default_map","line":192,"kind":13}],"line":186,"kind":12,"signature":{"documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Marker - An central map object representing a generic marker\nthat can have multiple location in several maps.\n\n=head1 SYNOPSIS\n\n  # get map objects somehow\n\n  # a marker with complex localisation\n  $o_usat = Bio::Map::Marker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t  -positions => [ [$map1, $position1], \n                                                  [$map1, $position2] \n\t\t\t\t\t\t] );\n\n  # The markers deal with Bio::Map::Position objects which can also\n  # be explicitely created and passed on to markers as an array ref:\n  $o_usat2 = Bio::Map::Marker->new(-name=>'Chad Super Marker 3',\n\t\t\t\t  -positions => [ $pos1, \n                                                  $pos2 \n\t\t\t\t\t\t] );\n\n  # a marker with unique position in a map\n  $marker1 = Bio::Map::Marker->new(-name=>'hypervariable1',\n\t\t\t\t   -map => $map1,\n\t\t\t\t   -position => 100\n\t\t\t\t   );\n\n  # an other way of creating a marker with unique position in a map:\n  $marker2 = Bio::Map::Marker->new(-name=>'hypervariable2');\n  $map1->add_element($marker2);\n  $marker2->position(100);\n\n  # position method is a short cut for get/setting unique positions\n  # which overwrites previous values\n  # to place a marker to other maps or to have multiple positions \n  # for a map within the same map use add_position()\n\n  $marker2->add_position(200);\t# new position in the same map\n  $marker2->add_position($map2,200); # new map\n\n  # setting a map() in a marker or adding a marker into a map are\n  # identical mathods. Both set the bidirectional connection which is\n  # used by the marker to remember its latest, default map.\n\n  # Regardes of how marker positions are created, they are stored and\n  # returned as Bio::Map::PositionI objects:\n\n  # unique position\n  print $marker1->position->value, \"\\n\";\n  # several positions\n  foreach $pos ($marker2->each_position($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nA Marker is a Bio::Map::Mappable with some properties particular to markers.\nIt also offers a number of convienience methods to make dealing with map\nelements easier.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Marker;\nuse strict;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::Mappable Bio::Map::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $marker = Bio::Map::Marker->new( -name => 'Whizzy marker',\n\t                                          -position => $position);\n Function: Builds a new Bio::Map::Marker object\n Returns : Bio::Map::Marker\n Args    :\n           -name    => name of this microsatellite \n                       [optional], string,default 'Unknown'\n           -default_map => the default map for this marker, a Bio::Map::MapI\n           -position => map position for this marker, a Bio::Map::PositionI\n           -positions => array ref of Bio::Map::PositionI objects\n\n           position and positions can also take as values anything the\n           corresponding methods can take\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\tbless($self, ref $class || $class);\n\t\n    my ($name, $default_map, $map, $position, $positions) = \n\t$self->_rearrange([qw(NAME\n\t\t\t\t  DEFAULT_MAP\n\t\t\t      MAP\n\t\t\t      POSITION\n\t\t\t      POSITIONS\n\t\t\t      )], @args);\n    \n    if ($name) { $self->name($name); } \n    else {$self->name('Unnamed marker'); }\n    \n    $map         && $self->default_map($map);\n\t$default_map && $self->default_map($default_map);\n    $position    && $self->position($position); \n    $positions   && $self->positions($positions);\n \n    return $self;\n}\n\n=head2 default_map\n\n Title   : default_map\n Usage   : my $map = $marker->default_map();\n Function: Get/Set the default map for the marker.\n Returns : L<Bio::Map::MapI>\n Args    : [optional] new L<Bio::Map::MapI>","parameters":[{"label":"$self"},{"label":"$map"}],"label":"default_map($self,$map)"},"detail":"($self,$map)","definition":"sub","containerName":"main::"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$map"},{"label":"$value"}],"documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Marker - An central map object representing a generic marker\nthat can have multiple location in several maps.\n\n=head1 SYNOPSIS\n\n  # get map objects somehow\n\n  # a marker with complex localisation\n  $o_usat = Bio::Map::Marker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t  -positions => [ [$map1, $position1], \n                                                  [$map1, $position2] \n\t\t\t\t\t\t] );\n\n  # The markers deal with Bio::Map::Position objects which can also\n  # be explicitely created and passed on to markers as an array ref:\n  $o_usat2 = Bio::Map::Marker->new(-name=>'Chad Super Marker 3',\n\t\t\t\t  -positions => [ $pos1, \n                                                  $pos2 \n\t\t\t\t\t\t] );\n\n  # a marker with unique position in a map\n  $marker1 = Bio::Map::Marker->new(-name=>'hypervariable1',\n\t\t\t\t   -map => $map1,\n\t\t\t\t   -position => 100\n\t\t\t\t   );\n\n  # an other way of creating a marker with unique position in a map:\n  $marker2 = Bio::Map::Marker->new(-name=>'hypervariable2');\n  $map1->add_element($marker2);\n  $marker2->position(100);\n\n  # position method is a short cut for get/setting unique positions\n  # which overwrites previous values\n  # to place a marker to other maps or to have multiple positions \n  # for a map within the same map use add_position()\n\n  $marker2->add_position(200);\t# new position in the same map\n  $marker2->add_position($map2,200); # new map\n\n  # setting a map() in a marker or adding a marker into a map are\n  # identical mathods. Both set the bidirectional connection which is\n  # used by the marker to remember its latest, default map.\n\n  # Regardes of how marker positions are created, they are stored and\n  # returned as Bio::Map::PositionI objects:\n\n  # unique position\n  print $marker1->position->value, \"\\n\";\n  # several positions\n  foreach $pos ($marker2->each_position($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nA Marker is a Bio::Map::Mappable with some properties particular to markers.\nIt also offers a number of convienience methods to make dealing with map\nelements easier.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Marker;\nuse strict;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::Mappable Bio::Map::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $marker = Bio::Map::Marker->new( -name => 'Whizzy marker',\n\t                                          -position => $position);\n Function: Builds a new Bio::Map::Marker object\n Returns : Bio::Map::Marker\n Args    :\n           -name    => name of this microsatellite \n                       [optional], string,default 'Unknown'\n           -default_map => the default map for this marker, a Bio::Map::MapI\n           -position => map position for this marker, a Bio::Map::PositionI\n           -positions => array ref of Bio::Map::PositionI objects\n\n           position and positions can also take as values anything the\n           corresponding methods can take\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\tbless($self, ref $class || $class);\n\t\n    my ($name, $default_map, $map, $position, $positions) = \n\t$self->_rearrange([qw(NAME\n\t\t\t\t  DEFAULT_MAP\n\t\t\t      MAP\n\t\t\t      POSITION\n\t\t\t      POSITIONS\n\t\t\t      )], @args);\n    \n    if ($name) { $self->name($name); } \n    else {$self->name('Unnamed marker'); }\n    \n    $map         && $self->default_map($map);\n\t$default_map && $self->default_map($default_map);\n    $position    && $self->position($position); \n    $positions   && $self->positions($positions);\n \n    return $self;\n}\n\n=head2 default_map\n\n Title   : default_map\n Usage   : my $map = $marker->default_map();\n Function: Get/Set the default map for the marker.\n Returns : L<Bio::Map::MapI>\n Args    : [optional] new L<Bio::Map::MapI>\n\n\nsub default_map {\n\tmy ($self, $map) = @_;\n\tif (defined $map) {\n\t\t$self->thow(\"This is [$map], not Bio::Map::MapI object\") unless $map->isa('Bio::Map::MapI');\n\t\t$self->{'_default_map'} = $map;\n\t}\n\treturn $self->{'_default_map'} || return;\n}\n\n=head2 map\n\n Title   : map\n Function: This is a synonym of the default_map() method\n\n\t\t   *** does not actually add this marker to the map! ***\n\n Status  : deprecated, will be removed in next version\n\n\n*map = \\&default_map;\n\n=head2 get_position_object\n\n Title   : get_position_class\n Usage   : my $position = $marker->get_position_object();\n Function: To get an object of the default Position class\n           for this Marker. Subclasses should redefine this method.\n           The Position returned needs to be a L<Bio::Map::PositionI> with\n\t\t   -element set to self.\n Returns : L<Bio::Map::PositionI>\n Args    : none for an 'empty' PositionI object, optionally\n           Bio::Map::MapI and value string to set the Position's -map and -value\n           attributes.","label":"get_position_object($self,$map,$value)"},"detail":"($self,$map,$value)","kind":12,"children":[{"kind":13,"line":224,"containerName":"get_position_object","definition":"my","name":"$self","localvar":"my"},{"containerName":"get_position_object","name":"$map","kind":13,"line":224},{"kind":13,"line":224,"name":"$value","containerName":"get_position_object"},{"containerName":"get_position_object","name":"$map","kind":13,"line":225},{"name":"$self","containerName":"get_position_object","kind":13,"line":225},{"containerName":"get_position_object","name":"default_map","line":225,"kind":12},{"name":"$value","containerName":"get_position_object","line":226,"kind":13},{"kind":13,"line":227,"containerName":"get_position_object","name":"$self"},{"name":"throw","containerName":"get_position_object","line":227,"kind":12},{"containerName":"get_position_object","name":"$value","line":227,"kind":13},{"localvar":"my","containerName":"get_position_object","definition":"my","name":"$pos","line":230,"kind":13},{"containerName":"get_position_object","name":"new","line":230,"kind":12},{"containerName":"get_position_object","name":"$pos","line":231,"kind":13},{"kind":12,"line":231,"containerName":"get_position_object","name":"map"},{"kind":13,"line":231,"containerName":"get_position_object","name":"$map"},{"containerName":"get_position_object","name":"$map","line":231,"kind":13},{"containerName":"get_position_object","name":"$pos","line":232,"kind":13},{"containerName":"get_position_object","name":"value","kind":12,"line":232},{"containerName":"get_position_object","name":"$value","line":232,"kind":13},{"name":"$value","containerName":"get_position_object","kind":13,"line":232},{"line":233,"kind":13,"name":"$pos","containerName":"get_position_object"},{"kind":12,"line":233,"name":"element","containerName":"get_position_object"},{"containerName":"get_position_object","name":"$self","kind":13,"line":233},{"line":234,"kind":13,"name":"$pos","containerName":"get_position_object"}],"line":223,"name":"get_position_object","range":{"start":{"line":223,"character":0},"end":{"character":9999,"line":235}}},{"name":"Bio","containerName":"Map::Position","line":230,"kind":12},{"name":"position","range":{"end":{"character":9999,"line":265},"start":{"character":0,"line":254}},"definition":"sub","containerName":"main::","signature":{"label":"position($self,$pos,$pos_actual)","parameters":[{"label":"$self"},{"label":"$pos"},{"label":"$pos_actual"}],"documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Marker - An central map object representing a generic marker\nthat can have multiple location in several maps.\n\n=head1 SYNOPSIS\n\n  # get map objects somehow\n\n  # a marker with complex localisation\n  $o_usat = Bio::Map::Marker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t  -positions => [ [$map1, $position1], \n                                                  [$map1, $position2] \n\t\t\t\t\t\t] );\n\n  # The markers deal with Bio::Map::Position objects which can also\n  # be explicitely created and passed on to markers as an array ref:\n  $o_usat2 = Bio::Map::Marker->new(-name=>'Chad Super Marker 3',\n\t\t\t\t  -positions => [ $pos1, \n                                                  $pos2 \n\t\t\t\t\t\t] );\n\n  # a marker with unique position in a map\n  $marker1 = Bio::Map::Marker->new(-name=>'hypervariable1',\n\t\t\t\t   -map => $map1,\n\t\t\t\t   -position => 100\n\t\t\t\t   );\n\n  # an other way of creating a marker with unique position in a map:\n  $marker2 = Bio::Map::Marker->new(-name=>'hypervariable2');\n  $map1->add_element($marker2);\n  $marker2->position(100);\n\n  # position method is a short cut for get/setting unique positions\n  # which overwrites previous values\n  # to place a marker to other maps or to have multiple positions \n  # for a map within the same map use add_position()\n\n  $marker2->add_position(200);\t# new position in the same map\n  $marker2->add_position($map2,200); # new map\n\n  # setting a map() in a marker or adding a marker into a map are\n  # identical mathods. Both set the bidirectional connection which is\n  # used by the marker to remember its latest, default map.\n\n  # Regardes of how marker positions are created, they are stored and\n  # returned as Bio::Map::PositionI objects:\n\n  # unique position\n  print $marker1->position->value, \"\\n\";\n  # several positions\n  foreach $pos ($marker2->each_position($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nA Marker is a Bio::Map::Mappable with some properties particular to markers.\nIt also offers a number of convienience methods to make dealing with map\nelements easier.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Marker;\nuse strict;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::Mappable Bio::Map::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $marker = Bio::Map::Marker->new( -name => 'Whizzy marker',\n\t                                          -position => $position);\n Function: Builds a new Bio::Map::Marker object\n Returns : Bio::Map::Marker\n Args    :\n           -name    => name of this microsatellite \n                       [optional], string,default 'Unknown'\n           -default_map => the default map for this marker, a Bio::Map::MapI\n           -position => map position for this marker, a Bio::Map::PositionI\n           -positions => array ref of Bio::Map::PositionI objects\n\n           position and positions can also take as values anything the\n           corresponding methods can take\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\tbless($self, ref $class || $class);\n\t\n    my ($name, $default_map, $map, $position, $positions) = \n\t$self->_rearrange([qw(NAME\n\t\t\t\t  DEFAULT_MAP\n\t\t\t      MAP\n\t\t\t      POSITION\n\t\t\t      POSITIONS\n\t\t\t      )], @args);\n    \n    if ($name) { $self->name($name); } \n    else {$self->name('Unnamed marker'); }\n    \n    $map         && $self->default_map($map);\n\t$default_map && $self->default_map($default_map);\n    $position    && $self->position($position); \n    $positions   && $self->positions($positions);\n \n    return $self;\n}\n\n=head2 default_map\n\n Title   : default_map\n Usage   : my $map = $marker->default_map();\n Function: Get/Set the default map for the marker.\n Returns : L<Bio::Map::MapI>\n Args    : [optional] new L<Bio::Map::MapI>\n\n\nsub default_map {\n\tmy ($self, $map) = @_;\n\tif (defined $map) {\n\t\t$self->thow(\"This is [$map], not Bio::Map::MapI object\") unless $map->isa('Bio::Map::MapI');\n\t\t$self->{'_default_map'} = $map;\n\t}\n\treturn $self->{'_default_map'} || return;\n}\n\n=head2 map\n\n Title   : map\n Function: This is a synonym of the default_map() method\n\n\t\t   *** does not actually add this marker to the map! ***\n\n Status  : deprecated, will be removed in next version\n\n\n*map = \\&default_map;\n\n=head2 get_position_object\n\n Title   : get_position_class\n Usage   : my $position = $marker->get_position_object();\n Function: To get an object of the default Position class\n           for this Marker. Subclasses should redefine this method.\n           The Position returned needs to be a L<Bio::Map::PositionI> with\n\t\t   -element set to self.\n Returns : L<Bio::Map::PositionI>\n Args    : none for an 'empty' PositionI object, optionally\n           Bio::Map::MapI and value string to set the Position's -map and -value\n           attributes.\n\n\nsub get_position_object {\n\tmy ($self, $map, $value) = @_;\n\t$map ||= $self->default_map;\n\tif ($value) {\n\t\t$self->throw(\"Value better be scalar, not [$value]\") unless ref($value) eq '';\n\t}\n\t\n\tmy $pos = Bio::Map::Position->new();\n\t$pos->map($map) if $map;\n    $pos->value($value) if defined($value);\n    $pos->element($self);\n\treturn $pos;\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position();\n\t\t   $mappable->position($position);\n Function: Get/Set the Position of this Marker (where it is on which map),\n           purging all other positions before setting.\n Returns : L<Bio::Map::PositionI>\n Args    : Bio::Map::PositionI\n            OR\n           Bio::Map::MapI AND\n           scalar\n            OR\n           scalar, but only if the marker has a default map"},"detail":"($self,$pos,$pos_actual)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"position","line":255,"kind":13},{"name":"$pos","containerName":"position","line":255,"kind":13},{"name":"$pos_actual","containerName":"position","line":255,"kind":13},{"containerName":"position","name":"$pos","kind":13,"line":257},{"containerName":"position","name":"$self","kind":13,"line":258},{"name":"purge_positions","containerName":"position","kind":12,"line":258},{"name":"$self","containerName":"position","line":259,"kind":13},{"kind":12,"line":259,"containerName":"position","name":"add_position"},{"kind":13,"line":259,"name":"$pos","containerName":"position"},{"containerName":"position","name":"$pos_actual","line":259,"kind":13},{"line":262,"kind":13,"localvar":"my","definition":"my","name":"@positions","containerName":"position"},{"containerName":"position","name":"$self","kind":13,"line":262},{"containerName":"position","name":"each_position","line":262,"kind":12},{"name":"$self","containerName":"position","kind":13,"line":263},{"name":"warn","containerName":"position","line":263,"kind":12},{"name":"@positions","containerName":"position","line":263,"kind":13},{"containerName":"position","name":"@positions","kind":13,"line":264}],"line":254},{"name":"add_position","range":{"start":{"character":0,"line":282},"end":{"character":9999,"line":309}},"kind":12,"line":282,"children":[{"localvar":"my","containerName":"add_position","definition":"my","name":"$self","line":283,"kind":13},{"containerName":"add_position","name":"$pos","line":283,"kind":13},{"kind":13,"line":283,"containerName":"add_position","name":"$pos_actual"},{"kind":13,"line":284,"containerName":"add_position","name":"$self"},{"line":284,"kind":12,"name":"throw","containerName":"add_position"},{"kind":13,"line":284,"name":"$pos","containerName":"add_position"},{"localvar":"my","containerName":"add_position","name":"$map","definition":"my","line":286,"kind":13},{"line":286,"kind":13,"name":"$self","containerName":"add_position"},{"kind":12,"line":286,"containerName":"add_position","name":"default_map"},{"definition":"my","name":"$pos_map","containerName":"add_position","localvar":"my","kind":13,"line":287},{"containerName":"add_position","name":"$pos","line":288,"kind":13},{"containerName":"add_position","name":"$pos","line":289,"kind":13},{"line":290,"kind":13,"name":"$pos","containerName":"add_position"},{"kind":13,"line":290,"name":"$pos_actual","containerName":"add_position"},{"kind":13,"line":290,"containerName":"add_position","name":"$pos"},{"containerName":"add_position","name":"$pos","kind":13,"line":291},{"name":"$pos_actual","containerName":"add_position","kind":13,"line":291},{"name":"$pos","containerName":"add_position","kind":13,"line":291},{"name":"$self","containerName":"add_position","kind":13,"line":292},{"name":"throw","containerName":"add_position","line":292,"kind":12},{"line":296,"kind":13,"name":"$pos","containerName":"add_position"},{"containerName":"add_position","name":"isa","line":296,"kind":12},{"line":297,"kind":13,"name":"$pos_map","containerName":"add_position"},{"name":"$pos","containerName":"add_position","line":297,"kind":13},{"kind":12,"line":297,"containerName":"add_position","name":"map"},{"name":"$self","containerName":"add_position","kind":13,"line":298},{"name":"default_map","containerName":"add_position","kind":12,"line":298},{"name":"$pos_map","containerName":"add_position","kind":13,"line":298},{"containerName":"add_position","name":"$map","kind":13,"line":298},{"line":299,"kind":13,"name":"$map","containerName":"add_position"},{"line":299,"kind":13,"name":"$pos_map","containerName":"add_position"},{"name":"$pos_map","containerName":"add_position","kind":13,"line":299},{"containerName":"add_position","name":"$pos","kind":13,"line":301},{"name":"isa","containerName":"add_position","kind":12,"line":301},{"kind":13,"line":302,"containerName":"add_position","name":"$self"},{"containerName":"add_position","name":"default_map","kind":12,"line":302},{"kind":13,"line":302,"containerName":"add_position","name":"$pos"},{"containerName":"add_position","name":"$map","line":302,"kind":13},{"containerName":"add_position","name":"$map","line":303,"kind":13},{"line":303,"kind":13,"name":"$pos","containerName":"add_position"},{"name":"$pos","containerName":"add_position","kind":13,"line":304},{"containerName":"add_position","name":"$pos_actual","line":304,"kind":13},{"line":307,"kind":13,"name":"$self","containerName":"add_position"},{"containerName":"add_position","name":"throw","kind":12,"line":307}],"containerName":"main::","definition":"sub","detail":"($self,$pos,$pos_actual)","signature":{"parameters":[{"label":"$self"},{"label":"$pos"},{"label":"$pos_actual"}],"documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Marker - An central map object representing a generic marker\nthat can have multiple location in several maps.\n\n=head1 SYNOPSIS\n\n  # get map objects somehow\n\n  # a marker with complex localisation\n  $o_usat = Bio::Map::Marker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t  -positions => [ [$map1, $position1], \n                                                  [$map1, $position2] \n\t\t\t\t\t\t] );\n\n  # The markers deal with Bio::Map::Position objects which can also\n  # be explicitely created and passed on to markers as an array ref:\n  $o_usat2 = Bio::Map::Marker->new(-name=>'Chad Super Marker 3',\n\t\t\t\t  -positions => [ $pos1, \n                                                  $pos2 \n\t\t\t\t\t\t] );\n\n  # a marker with unique position in a map\n  $marker1 = Bio::Map::Marker->new(-name=>'hypervariable1',\n\t\t\t\t   -map => $map1,\n\t\t\t\t   -position => 100\n\t\t\t\t   );\n\n  # an other way of creating a marker with unique position in a map:\n  $marker2 = Bio::Map::Marker->new(-name=>'hypervariable2');\n  $map1->add_element($marker2);\n  $marker2->position(100);\n\n  # position method is a short cut for get/setting unique positions\n  # which overwrites previous values\n  # to place a marker to other maps or to have multiple positions \n  # for a map within the same map use add_position()\n\n  $marker2->add_position(200);\t# new position in the same map\n  $marker2->add_position($map2,200); # new map\n\n  # setting a map() in a marker or adding a marker into a map are\n  # identical mathods. Both set the bidirectional connection which is\n  # used by the marker to remember its latest, default map.\n\n  # Regardes of how marker positions are created, they are stored and\n  # returned as Bio::Map::PositionI objects:\n\n  # unique position\n  print $marker1->position->value, \"\\n\";\n  # several positions\n  foreach $pos ($marker2->each_position($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nA Marker is a Bio::Map::Mappable with some properties particular to markers.\nIt also offers a number of convienience methods to make dealing with map\nelements easier.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Marker;\nuse strict;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::Mappable Bio::Map::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $marker = Bio::Map::Marker->new( -name => 'Whizzy marker',\n\t                                          -position => $position);\n Function: Builds a new Bio::Map::Marker object\n Returns : Bio::Map::Marker\n Args    :\n           -name    => name of this microsatellite \n                       [optional], string,default 'Unknown'\n           -default_map => the default map for this marker, a Bio::Map::MapI\n           -position => map position for this marker, a Bio::Map::PositionI\n           -positions => array ref of Bio::Map::PositionI objects\n\n           position and positions can also take as values anything the\n           corresponding methods can take\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\tbless($self, ref $class || $class);\n\t\n    my ($name, $default_map, $map, $position, $positions) = \n\t$self->_rearrange([qw(NAME\n\t\t\t\t  DEFAULT_MAP\n\t\t\t      MAP\n\t\t\t      POSITION\n\t\t\t      POSITIONS\n\t\t\t      )], @args);\n    \n    if ($name) { $self->name($name); } \n    else {$self->name('Unnamed marker'); }\n    \n    $map         && $self->default_map($map);\n\t$default_map && $self->default_map($default_map);\n    $position    && $self->position($position); \n    $positions   && $self->positions($positions);\n \n    return $self;\n}\n\n=head2 default_map\n\n Title   : default_map\n Usage   : my $map = $marker->default_map();\n Function: Get/Set the default map for the marker.\n Returns : L<Bio::Map::MapI>\n Args    : [optional] new L<Bio::Map::MapI>\n\n\nsub default_map {\n\tmy ($self, $map) = @_;\n\tif (defined $map) {\n\t\t$self->thow(\"This is [$map], not Bio::Map::MapI object\") unless $map->isa('Bio::Map::MapI');\n\t\t$self->{'_default_map'} = $map;\n\t}\n\treturn $self->{'_default_map'} || return;\n}\n\n=head2 map\n\n Title   : map\n Function: This is a synonym of the default_map() method\n\n\t\t   *** does not actually add this marker to the map! ***\n\n Status  : deprecated, will be removed in next version\n\n\n*map = \\&default_map;\n\n=head2 get_position_object\n\n Title   : get_position_class\n Usage   : my $position = $marker->get_position_object();\n Function: To get an object of the default Position class\n           for this Marker. Subclasses should redefine this method.\n           The Position returned needs to be a L<Bio::Map::PositionI> with\n\t\t   -element set to self.\n Returns : L<Bio::Map::PositionI>\n Args    : none for an 'empty' PositionI object, optionally\n           Bio::Map::MapI and value string to set the Position's -map and -value\n           attributes.\n\n\nsub get_position_object {\n\tmy ($self, $map, $value) = @_;\n\t$map ||= $self->default_map;\n\tif ($value) {\n\t\t$self->throw(\"Value better be scalar, not [$value]\") unless ref($value) eq '';\n\t}\n\t\n\tmy $pos = Bio::Map::Position->new();\n\t$pos->map($map) if $map;\n    $pos->value($value) if defined($value);\n    $pos->element($self);\n\treturn $pos;\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position();\n\t\t   $mappable->position($position);\n Function: Get/Set the Position of this Marker (where it is on which map),\n           purging all other positions before setting.\n Returns : L<Bio::Map::PositionI>\n Args    : Bio::Map::PositionI\n            OR\n           Bio::Map::MapI AND\n           scalar\n            OR\n           scalar, but only if the marker has a default map\n\n\nsub position {\n    my ($self, $pos, $pos_actual) = @_;\n    \n\tif ($pos) {\n\t\t$self->purge_positions;\n\t\t$self->add_position($pos, $pos_actual);\n\t}\n    \n    my @positions = $self->each_position;\n    $self->warn('This marker has more than one Position, returning the most recently added') if scalar @positions > 1;\n    return pop(@positions);\n}\n\n=head2 add_position\n\n Title   : add_position\n Usage   : $marker->add_position($position);\n Function: Add a Position to this marker\n Returns : n/a\n Args    : Bio::Map::PositionI\n            OR\n           Bio::Map::MapI AND\n           scalar\n            OR\n           scalar, but only if the marker has a default map","label":"add_position($self,$pos,$pos_actual)"}},{"name":"$self","containerName":null,"kind":13,"line":311},{"name":"throw","containerName":"main::","kind":12,"line":311},{"containerName":null,"name":"$map","kind":13,"line":311},{"name":"$pos","containerName":null,"kind":13,"line":313},{"line":313,"kind":13,"name":"$pos","containerName":null},{"kind":12,"line":313,"containerName":"main::","name":"isa"},{"name":"$pos","containerName":null,"kind":13,"line":314},{"name":"map","containerName":"main::","kind":12,"line":314},{"name":"$map","containerName":null,"kind":13,"line":314},{"line":314,"kind":13,"name":"$pos_map","containerName":null},{"line":315,"kind":13,"containerName":null,"name":"$self"},{"line":315,"kind":12,"containerName":"add_position","name":"SUPER"},{"name":"%pos","containerName":null,"line":315,"kind":13},{"kind":13,"line":318,"name":"$self","containerName":null},{"name":"get_position_object","containerName":"main::","kind":12,"line":318},{"kind":13,"line":318,"containerName":null,"name":"$map"},{"containerName":null,"name":"$pos","kind":13,"line":318},{"name":"positions","range":{"end":{"line":335,"character":9999},"start":{"character":0,"line":332}},"kind":12,"line":332,"children":[{"definition":"my","name":"$self","containerName":"positions","localvar":"my","kind":13,"line":333},{"line":333,"kind":13,"containerName":"positions","name":"$args_ref"},{"kind":13,"line":335,"name":"$arg","definition":"my","containerName":"positions","localvar":"my"},{"containerName":"positions","name":"$args_ref","line":335,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$args_ref)","signature":{"label":"positions($self,$args_ref)","documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Marker - An central map object representing a generic marker\nthat can have multiple location in several maps.\n\n=head1 SYNOPSIS\n\n  # get map objects somehow\n\n  # a marker with complex localisation\n  $o_usat = Bio::Map::Marker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t  -positions => [ [$map1, $position1], \n                                                  [$map1, $position2] \n\t\t\t\t\t\t] );\n\n  # The markers deal with Bio::Map::Position objects which can also\n  # be explicitely created and passed on to markers as an array ref:\n  $o_usat2 = Bio::Map::Marker->new(-name=>'Chad Super Marker 3',\n\t\t\t\t  -positions => [ $pos1, \n                                                  $pos2 \n\t\t\t\t\t\t] );\n\n  # a marker with unique position in a map\n  $marker1 = Bio::Map::Marker->new(-name=>'hypervariable1',\n\t\t\t\t   -map => $map1,\n\t\t\t\t   -position => 100\n\t\t\t\t   );\n\n  # an other way of creating a marker with unique position in a map:\n  $marker2 = Bio::Map::Marker->new(-name=>'hypervariable2');\n  $map1->add_element($marker2);\n  $marker2->position(100);\n\n  # position method is a short cut for get/setting unique positions\n  # which overwrites previous values\n  # to place a marker to other maps or to have multiple positions \n  # for a map within the same map use add_position()\n\n  $marker2->add_position(200);\t# new position in the same map\n  $marker2->add_position($map2,200); # new map\n\n  # setting a map() in a marker or adding a marker into a map are\n  # identical mathods. Both set the bidirectional connection which is\n  # used by the marker to remember its latest, default map.\n\n  # Regardes of how marker positions are created, they are stored and\n  # returned as Bio::Map::PositionI objects:\n\n  # unique position\n  print $marker1->position->value, \"\\n\";\n  # several positions\n  foreach $pos ($marker2->each_position($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nA Marker is a Bio::Map::Mappable with some properties particular to markers.\nIt also offers a number of convienience methods to make dealing with map\nelements easier.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Marker;\nuse strict;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::Mappable Bio::Map::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $marker = Bio::Map::Marker->new( -name => 'Whizzy marker',\n\t                                          -position => $position);\n Function: Builds a new Bio::Map::Marker object\n Returns : Bio::Map::Marker\n Args    :\n           -name    => name of this microsatellite \n                       [optional], string,default 'Unknown'\n           -default_map => the default map for this marker, a Bio::Map::MapI\n           -position => map position for this marker, a Bio::Map::PositionI\n           -positions => array ref of Bio::Map::PositionI objects\n\n           position and positions can also take as values anything the\n           corresponding methods can take\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\tbless($self, ref $class || $class);\n\t\n    my ($name, $default_map, $map, $position, $positions) = \n\t$self->_rearrange([qw(NAME\n\t\t\t\t  DEFAULT_MAP\n\t\t\t      MAP\n\t\t\t      POSITION\n\t\t\t      POSITIONS\n\t\t\t      )], @args);\n    \n    if ($name) { $self->name($name); } \n    else {$self->name('Unnamed marker'); }\n    \n    $map         && $self->default_map($map);\n\t$default_map && $self->default_map($default_map);\n    $position    && $self->position($position); \n    $positions   && $self->positions($positions);\n \n    return $self;\n}\n\n=head2 default_map\n\n Title   : default_map\n Usage   : my $map = $marker->default_map();\n Function: Get/Set the default map for the marker.\n Returns : L<Bio::Map::MapI>\n Args    : [optional] new L<Bio::Map::MapI>\n\n\nsub default_map {\n\tmy ($self, $map) = @_;\n\tif (defined $map) {\n\t\t$self->thow(\"This is [$map], not Bio::Map::MapI object\") unless $map->isa('Bio::Map::MapI');\n\t\t$self->{'_default_map'} = $map;\n\t}\n\treturn $self->{'_default_map'} || return;\n}\n\n=head2 map\n\n Title   : map\n Function: This is a synonym of the default_map() method\n\n\t\t   *** does not actually add this marker to the map! ***\n\n Status  : deprecated, will be removed in next version\n\n\n*map = \\&default_map;\n\n=head2 get_position_object\n\n Title   : get_position_class\n Usage   : my $position = $marker->get_position_object();\n Function: To get an object of the default Position class\n           for this Marker. Subclasses should redefine this method.\n           The Position returned needs to be a L<Bio::Map::PositionI> with\n\t\t   -element set to self.\n Returns : L<Bio::Map::PositionI>\n Args    : none for an 'empty' PositionI object, optionally\n           Bio::Map::MapI and value string to set the Position's -map and -value\n           attributes.\n\n\nsub get_position_object {\n\tmy ($self, $map, $value) = @_;\n\t$map ||= $self->default_map;\n\tif ($value) {\n\t\t$self->throw(\"Value better be scalar, not [$value]\") unless ref($value) eq '';\n\t}\n\t\n\tmy $pos = Bio::Map::Position->new();\n\t$pos->map($map) if $map;\n    $pos->value($value) if defined($value);\n    $pos->element($self);\n\treturn $pos;\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position();\n\t\t   $mappable->position($position);\n Function: Get/Set the Position of this Marker (where it is on which map),\n           purging all other positions before setting.\n Returns : L<Bio::Map::PositionI>\n Args    : Bio::Map::PositionI\n            OR\n           Bio::Map::MapI AND\n           scalar\n            OR\n           scalar, but only if the marker has a default map\n\n\nsub position {\n    my ($self, $pos, $pos_actual) = @_;\n    \n\tif ($pos) {\n\t\t$self->purge_positions;\n\t\t$self->add_position($pos, $pos_actual);\n\t}\n    \n    my @positions = $self->each_position;\n    $self->warn('This marker has more than one Position, returning the most recently added') if scalar @positions > 1;\n    return pop(@positions);\n}\n\n=head2 add_position\n\n Title   : add_position\n Usage   : $marker->add_position($position);\n Function: Add a Position to this marker\n Returns : n/a\n Args    : Bio::Map::PositionI\n            OR\n           Bio::Map::MapI AND\n           scalar\n            OR\n           scalar, but only if the marker has a default map\n\n\nsub add_position  {\n    my ($self, $pos, $pos_actual) = @_;\n    $self->throw(\"Must give a Position\") unless defined $pos;\n    \n    my $map = $self->default_map;\n\tmy $pos_map;\n\tif (ref($pos)) {\n\t\tif (ref($pos) eq 'ARRAY') {\n\t\t\t($pos, $pos_actual) = @{$pos};\n\t\t\tunless ($pos && $pos_actual && ref($pos)) {\n\t\t\t\t$self->throw(\"Supplied an array ref but did not contain two values, the first an object\");\n\t\t\t}\n\t\t}\n\t\t\n\t\tif ($pos->isa('Bio::Map::PositionI')) {\n\t\t\t$pos_map = $pos->map;\n\t\t\t$self->default_map($pos_map) unless $map;\n\t\t\t$map = $pos_map if $pos_map;\n\t\t}\n\t\telsif ($pos->isa('Bio::Map::MapI')) {\n\t\t\t$self->default_map($pos) unless $map;\n\t\t\t$map = $pos;\n\t\t\t$pos = $pos_actual;\n\t\t}\n\t\telse {\n\t\t\t$self->throw(\"This is [$pos], not a Bio::Map::PositionI or Bio::Map::MapI object\");\n\t\t}\n\t}\n\t\n\t$self->throw(\"You need to give a marker a default map before you can set positions without explicit map!\" ) unless $map;\n\t\n\tif (ref($pos) && $pos->isa('Bio::Map::PositionI')) {\n\t\t$pos->map($map) unless $pos_map;\n\t\t$self->SUPER::add_position($pos);\n\t}\n\telse {\n\t\t$self->get_position_object($map, $pos); # adds position to us\n\t}\n}\n\n=head2 positions\n\n Title   : positions\n Usage   : $marker->positions([$pos1, $pos2, $pos3]);\n Function: Add multiple Bio::Map::PositionI to this marker\n Returns : n/a\n Args    : array ref of $map/value tuples or array ref of Bio::Map::PositionI","parameters":[{"label":"$self"},{"label":"$args_ref"}]}},{"line":336,"kind":13,"containerName":null,"name":"%arg"},{"line":337,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"add_position","kind":12,"line":337},{"containerName":null,"name":"%arg","line":337,"kind":13},{"line":340,"kind":13,"name":"$self","containerName":null},{"line":340,"kind":12,"name":"add_position","containerName":"main::"},{"containerName":null,"name":"$arg","line":340,"kind":13},{"detail":"($self,$query)","signature":{"label":"in_map($self,$query)","parameters":[{"label":"$self"},{"label":"$query"}],"documentation":"1;\n# $Id: Marker.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Map::Marker\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Chad Matsalla\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Marker - An central map object representing a generic marker\nthat can have multiple location in several maps.\n\n=head1 SYNOPSIS\n\n  # get map objects somehow\n\n  # a marker with complex localisation\n  $o_usat = Bio::Map::Marker->new(-name=>'Chad Super Marker 2',\n\t\t\t\t  -positions => [ [$map1, $position1], \n                                                  [$map1, $position2] \n\t\t\t\t\t\t] );\n\n  # The markers deal with Bio::Map::Position objects which can also\n  # be explicitely created and passed on to markers as an array ref:\n  $o_usat2 = Bio::Map::Marker->new(-name=>'Chad Super Marker 3',\n\t\t\t\t  -positions => [ $pos1, \n                                                  $pos2 \n\t\t\t\t\t\t] );\n\n  # a marker with unique position in a map\n  $marker1 = Bio::Map::Marker->new(-name=>'hypervariable1',\n\t\t\t\t   -map => $map1,\n\t\t\t\t   -position => 100\n\t\t\t\t   );\n\n  # an other way of creating a marker with unique position in a map:\n  $marker2 = Bio::Map::Marker->new(-name=>'hypervariable2');\n  $map1->add_element($marker2);\n  $marker2->position(100);\n\n  # position method is a short cut for get/setting unique positions\n  # which overwrites previous values\n  # to place a marker to other maps or to have multiple positions \n  # for a map within the same map use add_position()\n\n  $marker2->add_position(200);\t# new position in the same map\n  $marker2->add_position($map2,200); # new map\n\n  # setting a map() in a marker or adding a marker into a map are\n  # identical mathods. Both set the bidirectional connection which is\n  # used by the marker to remember its latest, default map.\n\n  # Regardes of how marker positions are created, they are stored and\n  # returned as Bio::Map::PositionI objects:\n\n  # unique position\n  print $marker1->position->value, \"\\n\";\n  # several positions\n  foreach $pos ($marker2->each_position($map1)) {\n     print $pos->value, \"\\n\";\n  }\n\nSee L<Bio::Map::Position> and L<Bio::Map::PositionI> for more information.\n\n=head1 DESCRIPTION\n\nA Marker is a Bio::Map::Mappable with some properties particular to markers.\nIt also offers a number of convienience methods to make dealing with map\nelements easier.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Chad Matsalla\n\nEmail bioinformatics1@dieselwurks.com\n\n=head1 CONTRIBUTORS\n\nHeikki Lehvaslaiho heikki-at-bioperl-dot-org\nLincoln Stein      lstein@cshl.org\nJason Stajich      jason@bioperl.org\nSendu Bala         bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Marker;\nuse strict;\nuse Bio::Map::Position;\n\nuse base qw(Bio::Map::Mappable Bio::Map::MarkerI);\n\n=head2 new\n\n Title   : new\n Usage   : my $marker = Bio::Map::Marker->new( -name => 'Whizzy marker',\n\t                                          -position => $position);\n Function: Builds a new Bio::Map::Marker object\n Returns : Bio::Map::Marker\n Args    :\n           -name    => name of this microsatellite \n                       [optional], string,default 'Unknown'\n           -default_map => the default map for this marker, a Bio::Map::MapI\n           -position => map position for this marker, a Bio::Map::PositionI\n           -positions => array ref of Bio::Map::PositionI objects\n\n           position and positions can also take as values anything the\n           corresponding methods can take\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n\tbless($self, ref $class || $class);\n\t\n    my ($name, $default_map, $map, $position, $positions) = \n\t$self->_rearrange([qw(NAME\n\t\t\t\t  DEFAULT_MAP\n\t\t\t      MAP\n\t\t\t      POSITION\n\t\t\t      POSITIONS\n\t\t\t      )], @args);\n    \n    if ($name) { $self->name($name); } \n    else {$self->name('Unnamed marker'); }\n    \n    $map         && $self->default_map($map);\n\t$default_map && $self->default_map($default_map);\n    $position    && $self->position($position); \n    $positions   && $self->positions($positions);\n \n    return $self;\n}\n\n=head2 default_map\n\n Title   : default_map\n Usage   : my $map = $marker->default_map();\n Function: Get/Set the default map for the marker.\n Returns : L<Bio::Map::MapI>\n Args    : [optional] new L<Bio::Map::MapI>\n\n\nsub default_map {\n\tmy ($self, $map) = @_;\n\tif (defined $map) {\n\t\t$self->thow(\"This is [$map], not Bio::Map::MapI object\") unless $map->isa('Bio::Map::MapI');\n\t\t$self->{'_default_map'} = $map;\n\t}\n\treturn $self->{'_default_map'} || return;\n}\n\n=head2 map\n\n Title   : map\n Function: This is a synonym of the default_map() method\n\n\t\t   *** does not actually add this marker to the map! ***\n\n Status  : deprecated, will be removed in next version\n\n\n*map = \\&default_map;\n\n=head2 get_position_object\n\n Title   : get_position_class\n Usage   : my $position = $marker->get_position_object();\n Function: To get an object of the default Position class\n           for this Marker. Subclasses should redefine this method.\n           The Position returned needs to be a L<Bio::Map::PositionI> with\n\t\t   -element set to self.\n Returns : L<Bio::Map::PositionI>\n Args    : none for an 'empty' PositionI object, optionally\n           Bio::Map::MapI and value string to set the Position's -map and -value\n           attributes.\n\n\nsub get_position_object {\n\tmy ($self, $map, $value) = @_;\n\t$map ||= $self->default_map;\n\tif ($value) {\n\t\t$self->throw(\"Value better be scalar, not [$value]\") unless ref($value) eq '';\n\t}\n\t\n\tmy $pos = Bio::Map::Position->new();\n\t$pos->map($map) if $map;\n    $pos->value($value) if defined($value);\n    $pos->element($self);\n\treturn $pos;\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position();\n\t\t   $mappable->position($position);\n Function: Get/Set the Position of this Marker (where it is on which map),\n           purging all other positions before setting.\n Returns : L<Bio::Map::PositionI>\n Args    : Bio::Map::PositionI\n            OR\n           Bio::Map::MapI AND\n           scalar\n            OR\n           scalar, but only if the marker has a default map\n\n\nsub position {\n    my ($self, $pos, $pos_actual) = @_;\n    \n\tif ($pos) {\n\t\t$self->purge_positions;\n\t\t$self->add_position($pos, $pos_actual);\n\t}\n    \n    my @positions = $self->each_position;\n    $self->warn('This marker has more than one Position, returning the most recently added') if scalar @positions > 1;\n    return pop(@positions);\n}\n\n=head2 add_position\n\n Title   : add_position\n Usage   : $marker->add_position($position);\n Function: Add a Position to this marker\n Returns : n/a\n Args    : Bio::Map::PositionI\n            OR\n           Bio::Map::MapI AND\n           scalar\n            OR\n           scalar, but only if the marker has a default map\n\n\nsub add_position  {\n    my ($self, $pos, $pos_actual) = @_;\n    $self->throw(\"Must give a Position\") unless defined $pos;\n    \n    my $map = $self->default_map;\n\tmy $pos_map;\n\tif (ref($pos)) {\n\t\tif (ref($pos) eq 'ARRAY') {\n\t\t\t($pos, $pos_actual) = @{$pos};\n\t\t\tunless ($pos && $pos_actual && ref($pos)) {\n\t\t\t\t$self->throw(\"Supplied an array ref but did not contain two values, the first an object\");\n\t\t\t}\n\t\t}\n\t\t\n\t\tif ($pos->isa('Bio::Map::PositionI')) {\n\t\t\t$pos_map = $pos->map;\n\t\t\t$self->default_map($pos_map) unless $map;\n\t\t\t$map = $pos_map if $pos_map;\n\t\t}\n\t\telsif ($pos->isa('Bio::Map::MapI')) {\n\t\t\t$self->default_map($pos) unless $map;\n\t\t\t$map = $pos;\n\t\t\t$pos = $pos_actual;\n\t\t}\n\t\telse {\n\t\t\t$self->throw(\"This is [$pos], not a Bio::Map::PositionI or Bio::Map::MapI object\");\n\t\t}\n\t}\n\t\n\t$self->throw(\"You need to give a marker a default map before you can set positions without explicit map!\" ) unless $map;\n\t\n\tif (ref($pos) && $pos->isa('Bio::Map::PositionI')) {\n\t\t$pos->map($map) unless $pos_map;\n\t\t$self->SUPER::add_position($pos);\n\t}\n\telse {\n\t\t$self->get_position_object($map, $pos); # adds position to us\n\t}\n}\n\n=head2 positions\n\n Title   : positions\n Usage   : $marker->positions([$pos1, $pos2, $pos3]);\n Function: Add multiple Bio::Map::PositionI to this marker\n Returns : n/a\n Args    : array ref of $map/value tuples or array ref of Bio::Map::PositionI\n\n\nsub positions {\n    my ($self, $args_ref) = @_;\n    \n    foreach my $arg (@{$args_ref}) {\n        if (ref($arg) eq 'ARRAY') {\n            $self->add_position(@{$arg});\n        }\n        else {\n            $self->add_position($arg);\n        }\n    }\n}\n\n=head2 in_map\n\n Title   : in_map\n Usage   : if ( $marker->in_map($map) ) {}\n Function: Tests if this marker is found on a specific map\n Returns : boolean\n Args    : a map unique id OR Bio::Map::MapI"},"containerName":"main::","definition":"sub","line":355,"children":[{"kind":13,"line":356,"containerName":"in_map","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":356,"containerName":"in_map","name":"$query"},{"name":"$self","containerName":"in_map","kind":13,"line":357},{"kind":12,"line":357,"name":"throw","containerName":"in_map"},{"name":"$query","containerName":"in_map","line":357,"kind":13},{"line":359,"kind":13,"containerName":"in_map","name":"$query"},{"containerName":"in_map","definition":"my","name":"$map","localvar":"my","kind":13,"line":360},{"name":"$self","containerName":"in_map","kind":13,"line":360},{"kind":12,"line":360,"name":"known_maps","containerName":"in_map"},{"kind":13,"line":361,"containerName":"in_map","name":"$uid","definition":"my","localvar":"my"},{"kind":13,"line":361,"containerName":"in_map","name":"$map"},{"name":"unique_id","containerName":"in_map","line":361,"kind":12},{"containerName":"in_map","name":"$uid","line":362,"kind":13},{"containerName":"in_map","name":"$uid","kind":13,"line":363},{"containerName":"in_map","name":"$query","kind":13,"line":363},{"line":368,"kind":13,"name":"$self","containerName":"in_map"},{"name":"$query","containerName":"in_map","kind":13,"line":368}],"kind":12,"range":{"start":{"character":0,"line":355},"end":{"character":9999,"line":372}},"name":"in_map"},{"containerName":"in_map","name":"SUPER","line":368,"kind":12}],"version":5}