{"version":5,"vars":[{"kind":2,"line":105,"containerName":"","name":"base"},{"kind":13,"line":107,"definition":"our","name":"$USE_ENSEMBL","containerName":"main::"},{"line":108,"kind":13,"containerName":"main::","name":"%GENES","definition":"our"},{"containerName":"main::","name":"%SET_FROM_DB","definition":"our","kind":13,"line":109},{"line":115,"kind":13,"name":"$USE_ENSEMBL","containerName":null},{"containerName":"Tools::Run::Ensembl","name":"Bio","kind":12,"line":115},{"name":"new","range":{"start":{"line":131,"character":0},"end":{"line":142,"character":9999}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene"},"kind":12,"line":131,"children":[{"kind":13,"line":132,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"line":132,"kind":13,"name":"@args","containerName":"new"},{"line":133,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"kind":13,"line":133,"name":"$class","containerName":"new"},{"line":133,"kind":13,"name":"@args","containerName":"new"},{"kind":13,"line":135,"name":"$u_name","definition":"my","containerName":"new","localvar":"my"},{"kind":13,"line":135,"name":"$desc","containerName":"new"},{"kind":13,"line":135,"name":"$self","containerName":"new"},{"containerName":"new","name":"_rearrange","line":135,"kind":12},{"containerName":"new","name":"@args","kind":13,"line":135},{"name":"$u_name","containerName":"new","line":136,"kind":13},{"name":"$self","containerName":"new","kind":13,"line":136},{"name":"throw","containerName":"new","kind":12,"line":136},{"kind":13,"line":137,"name":"$self","containerName":"new"},{"containerName":"new","name":"universal_name","line":137,"kind":12},{"name":"$u_name","containerName":"new","line":137,"kind":13},{"kind":13,"line":139,"name":"$desc","containerName":"new"},{"name":"$self","containerName":"new","line":139,"kind":13},{"line":139,"kind":12,"name":"description","containerName":"new"},{"kind":13,"line":139,"containerName":"new","name":"$desc"},{"kind":13,"line":141,"name":"$self","containerName":"new"}]},{"kind":12,"line":133,"name":"SUPER","containerName":"new"},{"signature":{"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene","parameters":[{"label":"$class"},{"label":"@args"}],"label":"get($class,@args)"},"detail":"($class,@args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":159,"containerName":"get","name":"$class","definition":"my","localvar":"my"},{"name":"@args","containerName":"get","line":159,"kind":13},{"localvar":"my","containerName":"get","definition":"my","name":"$u_name","line":160,"kind":13},{"kind":13,"line":160,"name":"$desc","containerName":"get"},{"line":160,"kind":12,"name":"_rearrange","containerName":"get"},{"line":160,"kind":13,"name":"@args","containerName":"get"},{"kind":13,"line":162,"name":"$u_name","containerName":"get"},{"name":"$GENES","containerName":"get","kind":13,"line":162},{"kind":13,"line":162,"name":"$u_name","containerName":"get"},{"kind":13,"line":163,"name":"$GENES","containerName":"get"},{"line":163,"kind":13,"name":"$u_name","containerName":"get"},{"kind":12,"line":163,"name":"description","containerName":"get"},{"line":163,"kind":13,"name":"$desc","containerName":"get"},{"kind":13,"line":163,"name":"$desc","containerName":"get"},{"line":164,"kind":13,"containerName":"get","name":"$GENES"},{"line":164,"kind":13,"containerName":"get","name":"$u_name"},{"line":167,"kind":13,"containerName":"get","name":"$class"},{"containerName":"get","name":"new","line":167,"kind":12},{"containerName":"get","name":"@args","kind":13,"line":167}],"line":158,"kind":12,"range":{"start":{"character":0,"line":158},"end":{"character":9999,"line":168}},"name":"get"},{"containerName":"Root::Root","name":"Bio","line":160,"kind":12},{"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set","label":"universal_name($self,$value)"},"containerName":"main::","definition":"sub","line":182,"children":[{"name":"$self","definition":"my","containerName":"universal_name","localvar":"my","kind":13,"line":183},{"containerName":"universal_name","name":"$value","line":183,"kind":13},{"line":184,"kind":13,"name":"$value","containerName":"universal_name"},{"line":185,"kind":13,"name":"$GENES","containerName":"universal_name"},{"name":"$self","containerName":"universal_name","line":185,"kind":13},{"containerName":"universal_name","name":"$self","kind":13,"line":185},{"containerName":"universal_name","name":"$self","kind":13,"line":186},{"kind":13,"line":186,"name":"$value","containerName":"universal_name"},{"containerName":"universal_name","name":"$GENES","line":187,"kind":13},{"kind":13,"line":187,"containerName":"universal_name","name":"$value"},{"kind":13,"line":187,"name":"$self","containerName":"universal_name"},{"kind":13,"line":189,"name":"$self","containerName":"universal_name"}],"kind":12,"range":{"end":{"character":9999,"line":190},"start":{"line":182,"character":0}},"name":"universal_name"},{"range":{"end":{"character":9999,"line":210},"start":{"character":0,"line":207}},"definition":"sub","name":"description","containerName":"main::","children":[{"localvar":"my","containerName":"description","definition":"my","name":"$self","line":208,"kind":13},{"name":"$self","containerName":"description","line":209,"kind":13},{"line":209,"kind":12,"containerName":"description","name":"_gene_data"}],"line":207,"kind":12},{"range":{"start":{"character":0,"line":227},"end":{"line":230,"character":9999}},"definition":"sub","name":"display_id","containerName":"main::","children":[{"localvar":"my","containerName":"display_id","definition":"my","name":"$self","line":228,"kind":13},{"line":229,"kind":13,"name":"$self","containerName":"display_id"},{"containerName":"display_id","name":"_gene_data","kind":12,"line":229}],"line":227,"kind":12},{"kind":12,"line":247,"children":[{"line":248,"kind":13,"localvar":"my","containerName":"display_xref","name":"$self","definition":"my"},{"kind":13,"line":249,"name":"$self","containerName":"display_xref"},{"kind":12,"line":249,"containerName":"display_xref","name":"_gene_data"}],"containerName":"main::","definition":"sub","name":"display_xref","range":{"end":{"line":250,"character":9999},"start":{"character":0,"line":247}}},{"range":{"end":{"line":270,"character":9999},"start":{"line":267,"character":0}},"name":"external_db","definition":"sub","containerName":"main::","children":[{"line":268,"kind":13,"localvar":"my","containerName":"external_db","name":"$self","definition":"my"},{"name":"$self","containerName":"external_db","line":269,"kind":13},{"containerName":"external_db","name":"_gene_data","kind":12,"line":269}],"line":267,"kind":12},{"containerName":"main::","definition":"sub","name":"external_name","range":{"start":{"line":288,"character":0},"end":{"character":9999,"line":291}},"kind":12,"line":288,"children":[{"containerName":"external_name","name":"$self","definition":"my","localvar":"my","kind":13,"line":289},{"kind":13,"line":290,"name":"$self","containerName":"external_name"},{"name":"_gene_data","containerName":"external_name","kind":12,"line":290}]},{"range":{"end":{"character":9999,"line":311},"start":{"character":0,"line":308}},"containerName":"main::","definition":"sub","name":"biotype","line":308,"children":[{"localvar":"my","containerName":"biotype","definition":"my","name":"$self","line":309,"kind":13},{"line":310,"kind":13,"containerName":"biotype","name":"$self"},{"line":310,"kind":12,"containerName":"biotype","name":"_gene_data"}],"kind":12},{"children":[{"localvar":"my","containerName":"source","definition":"my","name":"$self","line":329,"kind":13},{"name":"$self","containerName":"source","line":330,"kind":13},{"line":330,"kind":12,"name":"_gene_data","containerName":"source"}],"line":328,"kind":12,"range":{"end":{"character":9999,"line":331},"start":{"character":0,"line":328}},"definition":"sub","name":"source","containerName":"main::"},{"name":"position","range":{"end":{"character":9999,"line":359},"start":{"line":348,"character":0}},"kind":12,"line":348,"children":[{"kind":13,"line":349,"containerName":"position","definition":"my","name":"$self","localvar":"my"},{"line":349,"kind":13,"name":"$map","containerName":"position"},{"line":350,"kind":13,"name":"$map","containerName":"position"},{"kind":13,"line":350,"name":"$self","containerName":"position"},{"containerName":"position","name":"in_map","line":350,"kind":12},{"name":"$map","containerName":"position","kind":13,"line":350},{"localvar":"my","containerName":"position","definition":"my","name":"$pos","line":352,"kind":13},{"containerName":"position","name":"$self","line":352,"kind":13},{"kind":12,"line":352,"containerName":"position","name":"get_positions"},{"kind":13,"line":352,"containerName":"position","name":"$map"},{"containerName":"position","name":"$pos","kind":13,"line":353},{"containerName":"position","name":"isa","line":353,"kind":12},{"line":354,"kind":13,"name":"$pos","containerName":"position"}],"containerName":"main::","definition":"sub","detail":"($self,$map)","signature":{"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.","parameters":[{"label":"$self"},{"label":"$map"}],"label":"position($self,$map)"}},{"kind":12,"line":378,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"add_transcript_position","line":379,"kind":13},{"line":379,"kind":13,"containerName":"add_transcript_position","name":"$pos"},{"line":380,"kind":13,"name":"$pos","containerName":"add_transcript_position"},{"kind":13,"line":380,"containerName":"add_transcript_position","name":"$pos"},{"containerName":"add_transcript_position","name":"isa","kind":12,"line":380},{"name":"$map","definition":"my","containerName":"add_transcript_position","localvar":"my","kind":13,"line":382},{"line":382,"kind":13,"containerName":"add_transcript_position","name":"$pos"},{"line":382,"kind":12,"name":"map","containerName":"add_transcript_position"},{"line":382,"kind":13,"name":"$self","containerName":"add_transcript_position"},{"line":382,"kind":12,"name":"throw","containerName":"add_transcript_position"},{"name":"$self","containerName":"add_transcript_position","kind":13,"line":383},{"kind":12,"line":383,"name":"in_map","containerName":"add_transcript_position"},{"line":383,"kind":13,"containerName":"add_transcript_position","name":"$map"},{"name":"$self","containerName":"add_transcript_position","line":383,"kind":13},{"kind":12,"line":383,"containerName":"add_transcript_position","name":"throw"},{"localvar":"my","containerName":"add_transcript_position","definition":"my","name":"@transcripts","line":384,"kind":13},{"kind":13,"line":384,"containerName":"add_transcript_position","name":"$self"},{"containerName":"add_transcript_position","name":"get_transcript_positions","kind":12,"line":384},{"name":"$map","containerName":"add_transcript_position","kind":13,"line":384},{"containerName":"add_transcript_position","name":"@transcripts","line":385,"kind":13},{"line":387,"kind":13,"containerName":"add_transcript_position","name":"$pos"},{"name":"start","containerName":"add_transcript_position","kind":12,"line":387},{"line":388,"kind":13,"name":"$self","containerName":"add_transcript_position"},{"line":388,"kind":12,"name":"warn","containerName":"add_transcript_position"},{"containerName":"add_transcript_position","name":"$pos","line":393,"kind":13},{"name":"type","containerName":"add_transcript_position","kind":12,"line":393},{"name":"$pos","containerName":"add_transcript_position","line":394,"kind":13},{"name":"relative","containerName":"add_transcript_position","kind":12,"line":394},{"containerName":"add_transcript_position","name":"gene","line":394,"kind":12},{"name":"$self","containerName":"add_transcript_position","kind":13,"line":395},{"name":"$pos","containerName":"add_transcript_position","line":395,"kind":13},{"name":"$self","containerName":"add_transcript_position","line":399,"kind":13},{"name":"$map","containerName":"add_transcript_position","line":399,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$pos)","signature":{"label":"add_transcript_position($self,$pos)","parameters":[{"label":"$self"},{"label":"$pos"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)"},"name":"add_transcript_position","range":{"start":{"character":0,"line":378},"end":{"character":9999,"line":399}}},{"line":395,"kind":12,"name":"SUPER","containerName":"add_position"},{"name":"t_order","kind":12,"line":399},{"name":"$pos","containerName":null,"line":399,"kind":13},{"localvar":"my","definition":"my","name":"$main_pos","containerName":null,"line":402,"kind":13},{"kind":13,"line":402,"containerName":null,"name":"$self"},{"containerName":"main::","name":"position","line":402,"kind":12},{"containerName":null,"name":"$map","kind":13,"line":402},{"kind":13,"line":403,"containerName":null,"definition":"my","name":"$increase","localvar":"my"},{"line":403,"kind":13,"containerName":null,"name":"$pos"},{"line":403,"kind":12,"name":"length","containerName":"main::"},{"name":"$pos","containerName":null,"kind":13,"line":403},{"line":403,"kind":12,"name":"start","containerName":"main::"},{"containerName":null,"name":"$pos","kind":13,"line":403},{"line":403,"kind":12,"name":"absolute_relative","containerName":"main::"},{"containerName":null,"name":"$main_pos","kind":13,"line":403},{"containerName":"main::","name":"end","kind":12,"line":403},{"kind":13,"line":404,"containerName":null,"name":"%increase"},{"line":405,"kind":13,"name":"$main_pos","containerName":null},{"name":"end","containerName":"main::","kind":12,"line":405},{"kind":13,"line":405,"containerName":null,"name":"$main_pos"},{"name":"end","containerName":"main::","line":405,"kind":12},{"line":405,"kind":13,"name":"$increase","containerName":null},{"kind":13,"line":409,"name":"$self","containerName":null},{"name":"active_transcript","containerName":"main::","kind":12,"line":409},{"containerName":null,"name":"$map","kind":13,"line":409},{"name":"@transcripts","containerName":null,"kind":13,"line":409},{"name":"active_transcript","range":{"end":{"line":459,"character":9999},"start":{"character":0,"line":430}},"containerName":"main::","definition":"sub","detail":"($self,$map,$int)","signature":{"parameters":[{"label":"$self"},{"label":"$map"},{"label":"$int"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set","label":"active_transcript($self,$map,$int)"},"kind":12,"line":430,"children":[{"line":431,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"active_transcript"},{"name":"$map","containerName":"active_transcript","line":431,"kind":13},{"line":431,"kind":13,"name":"$int","containerName":"active_transcript"},{"line":432,"kind":13,"containerName":"active_transcript","name":"$map"},{"localvar":"my","name":"@transcripts","definition":"my","containerName":"active_transcript","line":434,"kind":13},{"line":434,"kind":13,"name":"$self","containerName":"active_transcript"},{"name":"get_transcript_positions","containerName":"active_transcript","kind":12,"line":434},{"containerName":"active_transcript","name":"$map","line":434,"kind":13},{"kind":13,"line":435,"containerName":"active_transcript","name":"@transcripts"},{"name":"$int","containerName":"active_transcript","line":436,"kind":13},{"kind":13,"line":437,"containerName":"active_transcript","name":"$int"},{"kind":13,"line":437,"name":"$int","containerName":"active_transcript"},{"kind":13,"line":437,"name":"@transcripts","containerName":"active_transcript"},{"containerName":"active_transcript","name":"$self","kind":13,"line":438},{"name":"$map","containerName":"active_transcript","kind":13,"line":438},{"kind":13,"line":438,"name":"$int","containerName":"active_transcript"},{"name":"$int","containerName":"active_transcript","line":439,"kind":13},{"containerName":"active_transcript","name":"$self","line":442,"kind":13},{"containerName":"active_transcript","name":"warn","kind":12,"line":442},{"name":"$self","containerName":"active_transcript","kind":13,"line":447},{"kind":13,"line":447,"name":"$map","containerName":"active_transcript"},{"kind":13,"line":448,"containerName":"active_transcript","name":"$self"},{"name":"$map","containerName":"active_transcript","line":448,"kind":13},{"line":453,"kind":13,"name":"$self","containerName":"active_transcript"},{"kind":13,"line":453,"containerName":"active_transcript","name":"$map"},{"line":453,"kind":13,"name":"@transcripts","containerName":"active_transcript"},{"kind":13,"line":454,"name":"$self","containerName":"active_transcript"},{"containerName":"active_transcript","name":"$map","line":454,"kind":13}]},{"name":"active_transcript","kind":12,"line":438},{"name":"active_transcript","kind":12,"line":447},{"name":"active_transcript","line":448,"kind":12},{"kind":12,"line":453,"name":"active_transcript"},{"name":"active_transcript","line":454,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$map)","signature":{"parameters":[{"label":"$self"},{"label":"$map"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap","label":"get_transcript_positions($self,$map)"},"kind":12,"line":472,"children":[{"kind":13,"line":473,"definition":"my","name":"$self","containerName":"get_transcript_positions","localvar":"my"},{"containerName":"get_transcript_positions","name":"$map","line":473,"kind":13},{"line":474,"kind":13,"name":"$map","containerName":"get_transcript_positions"},{"containerName":"get_transcript_positions","name":"$map","line":475,"kind":13},{"name":"isa","containerName":"get_transcript_positions","line":475,"kind":12},{"name":"$self","containerName":"get_transcript_positions","line":476,"kind":13},{"line":476,"kind":12,"containerName":"get_transcript_positions","name":"_get_typed_positions"},{"containerName":"get_transcript_positions","name":"$map","line":476,"kind":13}],"name":"get_transcript_positions","range":{"end":{"character":9999,"line":477},"start":{"line":472,"character":0}}},{"name":"get_transcript_position","range":{"start":{"line":493,"character":0},"end":{"character":9999,"line":502}},"containerName":"main::","definition":"sub","detail":"($self,$map,$value)","signature":{"label":"get_transcript_position($self,$map,$value)","documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$value"}]},"kind":12,"line":493,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"get_transcript_position","line":494,"kind":13},{"containerName":"get_transcript_position","name":"$map","kind":13,"line":494},{"kind":13,"line":494,"name":"$value","containerName":"get_transcript_position"},{"kind":13,"line":495,"containerName":"get_transcript_position","name":"$map"},{"name":"$value","containerName":"get_transcript_position","kind":13,"line":496},{"line":496,"kind":13,"containerName":"get_transcript_position","name":"$self"},{"line":496,"kind":12,"name":"active_transcript","containerName":"get_transcript_position"},{"name":"$map","containerName":"get_transcript_position","kind":13,"line":496},{"kind":13,"line":497,"name":"@transcripts","definition":"my","containerName":"get_transcript_position","localvar":"my"},{"containerName":"get_transcript_position","name":"$self","kind":13,"line":497},{"containerName":"get_transcript_position","name":"get_transcript_positions","kind":12,"line":497},{"line":497,"kind":13,"name":"$map","containerName":"get_transcript_position"},{"containerName":"get_transcript_position","name":"@transcripts","line":498,"kind":13},{"containerName":"get_transcript_position","name":"$value","line":498,"kind":13},{"name":"$self","containerName":"get_transcript_position","kind":13,"line":499},{"containerName":"get_transcript_position","name":"position","kind":12,"line":499},{"containerName":"get_transcript_position","name":"$map","line":499,"kind":13},{"kind":13,"line":501,"containerName":"get_transcript_position","name":"$self"},{"kind":12,"line":501,"containerName":"get_transcript_position","name":"_get_list_element"},{"name":"$value","containerName":"get_transcript_position","line":501,"kind":13},{"name":"@transcripts","containerName":"get_transcript_position","kind":13,"line":501}]},{"definition":"sub","containerName":"main::","signature":{"label":"coding_position($self,$thing,$transcript_num)","parameters":[{"label":"$self"},{"label":"$thing"},{"label":"$transcript_num"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map"},"detail":"($self,$thing,$transcript_num)","kind":12,"children":[{"localvar":"my","containerName":"coding_position","name":"$self","definition":"my","line":533,"kind":13},{"containerName":"coding_position","name":"$thing","line":533,"kind":13},{"name":"$transcript_num","containerName":"coding_position","kind":13,"line":533},{"line":534,"kind":13,"name":"$thing","containerName":"coding_position"},{"line":535,"kind":13,"containerName":"coding_position","name":"$transcript_num"},{"kind":13,"line":539,"name":"$thing","containerName":"coding_position"},{"line":539,"kind":12,"name":"isa","containerName":"coding_position"},{"localvar":"my","containerName":"coding_position","name":"$map","definition":"my","line":540,"kind":13},{"name":"$thing","containerName":"coding_position","kind":13,"line":540},{"name":"map","containerName":"coding_position","line":540,"kind":12},{"localvar":"my","definition":"my","name":"$existing_pos","containerName":"coding_position","line":541,"kind":13},{"containerName":"coding_position","name":"$self","kind":13,"line":541},{"containerName":"coding_position","name":"_get_typed_positions","line":541,"kind":12},{"containerName":"coding_position","name":"$map","line":541,"kind":13},{"kind":13,"line":541,"name":"$transcript_num","containerName":"coding_position"},{"line":542,"kind":13,"name":"$existing_pos","containerName":"coding_position"},{"containerName":"coding_position","name":"$self","kind":13,"line":544},{"line":544,"kind":12,"name":"purge_positions","containerName":"coding_position"},{"name":"$existing_pos","containerName":"coding_position","line":544,"kind":13},{"kind":13,"line":546,"containerName":"coding_position","name":"$self"},{"kind":12,"line":546,"name":"_add_type_position","containerName":"coding_position"},{"line":546,"kind":13,"name":"$thing","containerName":"coding_position"},{"kind":13,"line":546,"containerName":"coding_position","name":"$transcript_num"},{"line":547,"kind":13,"containerName":"coding_position","name":"$thing"},{"kind":13,"line":547,"containerName":"coding_position","name":"$map"},{"line":550,"kind":13,"localvar":"my","containerName":"coding_position","name":"$pos","definition":"my"},{"kind":13,"line":550,"name":"$self","containerName":"coding_position"},{"containerName":"coding_position","name":"_get_typed_positions","kind":12,"line":550},{"kind":13,"line":550,"name":"$thing","containerName":"coding_position"},{"name":"$transcript_num","containerName":"coding_position","kind":13,"line":550},{"name":"$pos","containerName":"coding_position","kind":13,"line":551},{"name":"$self","containerName":"coding_position","kind":13,"line":551},{"kind":12,"line":551,"containerName":"coding_position","name":"get_transcript_position"},{"containerName":"coding_position","name":"$thing","kind":13,"line":551},{"line":551,"kind":13,"name":"$transcript_num","containerName":"coding_position"}],"line":532,"name":"coding_position","range":{"end":{"character":9999,"line":552},"start":{"character":0,"line":532}}},{"kind":12,"line":570,"children":[{"containerName":"add_exon_position","name":"$self","definition":"my","localvar":"my","kind":13,"line":571},{"containerName":"add_exon_position","name":"$self","kind":13,"line":572},{"kind":12,"line":572,"name":"_add_type_position","containerName":"add_exon_position"}],"containerName":"main::","name":"add_exon_position","definition":"sub","range":{"end":{"character":9999,"line":573},"start":{"character":0,"line":570}}},{"line":588,"children":[{"name":"$self","definition":"my","containerName":"get_exon_positions","localvar":"my","kind":13,"line":589},{"kind":13,"line":589,"name":"$map","containerName":"get_exon_positions"},{"line":589,"kind":13,"name":"$value","containerName":"get_exon_positions"},{"name":"$map","containerName":"get_exon_positions","kind":13,"line":590},{"containerName":"get_exon_positions","name":"$value","kind":13,"line":591},{"containerName":"get_exon_positions","name":"$self","line":592,"kind":13},{"name":"_get_typed_positions","containerName":"get_exon_positions","line":592,"kind":12},{"name":"$map","containerName":"get_exon_positions","line":592,"kind":13},{"line":592,"kind":13,"name":"$value","containerName":"get_exon_positions"}],"kind":12,"detail":"($self,$map,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$map"},{"label":"$value"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)","label":"get_exon_positions($self,$map,$value)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":588},"end":{"character":9999,"line":593}},"name":"get_exon_positions"},{"name":"get_exon_position","range":{"end":{"character":9999,"line":620},"start":{"character":0,"line":613}},"containerName":"main::","definition":"sub","detail":"($self,$map,$exon_num,$value)","signature":{"label":"get_exon_position($self,$map,$exon_num,$value)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$exon_num"},{"label":"$value"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_exon_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'exon', $value);\n}\n\n=head2 get_exon_position\n\n Title   : get_exon_position\n Usage   : my $position = $gene->get_exon_position($map, $exon_num, $int);\n Function: Get the $exon_num'th exon position that is relative to the $int'th\n           transcript position added to the map. Exons are numbered in Position\n           order, not the order they were added to the map. If no exons have\n           been added to the map, and the first exon was requested,\n           $gene->get_transcript_position($map, $int) is returned, as that will\n           have the same start as the first exon, and could have the same end\n           for a single exon gene.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the exon you want) AND int (the transcript\n           number; if second int not supplied, or 0, considers the currently\n           active transcript)"},"kind":12,"line":613,"children":[{"line":614,"kind":13,"localvar":"my","containerName":"get_exon_position","definition":"my","name":"$self"},{"name":"$map","containerName":"get_exon_position","line":614,"kind":13},{"kind":13,"line":614,"name":"$exon_num","containerName":"get_exon_position"},{"name":"$value","containerName":"get_exon_position","kind":13,"line":614},{"line":615,"kind":13,"localvar":"my","definition":"my","name":"@exons","containerName":"get_exon_position"},{"containerName":"get_exon_position","name":"$self","kind":13,"line":615},{"containerName":"get_exon_position","name":"get_exon_positions","kind":12,"line":615},{"containerName":"get_exon_position","name":"$map","line":615,"kind":13},{"kind":13,"line":615,"containerName":"get_exon_position","name":"$value"},{"kind":13,"line":616,"containerName":"get_exon_position","name":"@exons"},{"containerName":"get_exon_position","name":"$exon_num","line":616,"kind":13},{"line":617,"kind":13,"name":"$self","containerName":"get_exon_position"},{"kind":12,"line":617,"containerName":"get_exon_position","name":"get_transcript_position"},{"containerName":"get_exon_position","name":"$map","kind":13,"line":617},{"line":617,"kind":13,"containerName":"get_exon_position","name":"$value"},{"containerName":"get_exon_position","name":"$self","line":619,"kind":13},{"containerName":"get_exon_position","name":"_get_list_element","kind":12,"line":619},{"line":619,"kind":13,"name":"$exon_num","containerName":"get_exon_position"},{"kind":13,"line":619,"name":"@exons","containerName":"get_exon_position"}]},{"line":638,"children":[{"containerName":"add_intron_position","name":"$self","definition":"my","localvar":"my","kind":13,"line":639},{"containerName":"add_intron_position","name":"$self","line":640,"kind":13},{"kind":12,"line":640,"containerName":"add_intron_position","name":"_add_type_position"}],"kind":12,"range":{"start":{"character":0,"line":638},"end":{"character":9999,"line":641}},"containerName":"main::","definition":"sub","name":"add_intron_position"},{"definition":"sub","containerName":"main::","signature":{"label":"get_intron_positions($self,$map,$value)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$value"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_exon_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'exon', $value);\n}\n\n=head2 get_exon_position\n\n Title   : get_exon_position\n Usage   : my $position = $gene->get_exon_position($map, $exon_num, $int);\n Function: Get the $exon_num'th exon position that is relative to the $int'th\n           transcript position added to the map. Exons are numbered in Position\n           order, not the order they were added to the map. If no exons have\n           been added to the map, and the first exon was requested,\n           $gene->get_transcript_position($map, $int) is returned, as that will\n           have the same start as the first exon, and could have the same end\n           for a single exon gene.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the exon you want) AND int (the transcript\n           number; if second int not supplied, or 0, considers the currently\n           active transcript)\n\n\nsub get_exon_position {\n    my ($self, $map, $exon_num, $value) = @_;\n    my @exons = $self->get_exon_positions($map, $value);\n    if (@exons == 0 && $exon_num == 1) {\n        return $self->get_transcript_position($map, $value);\n    }\n    return $self->_get_list_element($exon_num, @exons);\n}\n\n=head2 add_intron_position\n\n Title   : add_intron_position\n Usage   : $gene->add_intron_position($position, $transcript_number);\n Function: Set the bounds of an intron of a given transcript on a map (that of\n           the supplied position). Coordinates must be relative to the\n           transcript start. The supplied position will be given a type 'intron'\n           and a relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_intron_position {\n    my $self = shift;\n    $self->_add_type_position('intron', @_);\n}\n\n=head2 get_intron_positions\n\n Title   : get_intron_positions\n Usage   : my @positions = $gene->get_intron_positions($map, $int);\n Function: Get all the intron positions that are relative to the $int'th\n           transcript position added to the map. Introns are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)"},"detail":"($self,$map,$value)","kind":12,"children":[{"containerName":"get_intron_positions","name":"$self","definition":"my","localvar":"my","kind":13,"line":657},{"kind":13,"line":657,"containerName":"get_intron_positions","name":"$map"},{"name":"$value","containerName":"get_intron_positions","line":657,"kind":13},{"containerName":"get_intron_positions","name":"$map","kind":13,"line":658},{"name":"$value","containerName":"get_intron_positions","kind":13,"line":659},{"name":"$self","containerName":"get_intron_positions","line":660,"kind":13},{"containerName":"get_intron_positions","name":"_get_typed_positions","line":660,"kind":12},{"kind":13,"line":660,"name":"$map","containerName":"get_intron_positions"},{"name":"$value","containerName":"get_intron_positions","kind":13,"line":660}],"line":656,"name":"get_intron_positions","range":{"end":{"character":9999,"line":661},"start":{"character":0,"line":656}}},{"signature":{"label":"get_intron_position($self,$map,$intron_num,$value)","documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_exon_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'exon', $value);\n}\n\n=head2 get_exon_position\n\n Title   : get_exon_position\n Usage   : my $position = $gene->get_exon_position($map, $exon_num, $int);\n Function: Get the $exon_num'th exon position that is relative to the $int'th\n           transcript position added to the map. Exons are numbered in Position\n           order, not the order they were added to the map. If no exons have\n           been added to the map, and the first exon was requested,\n           $gene->get_transcript_position($map, $int) is returned, as that will\n           have the same start as the first exon, and could have the same end\n           for a single exon gene.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the exon you want) AND int (the transcript\n           number; if second int not supplied, or 0, considers the currently\n           active transcript)\n\n\nsub get_exon_position {\n    my ($self, $map, $exon_num, $value) = @_;\n    my @exons = $self->get_exon_positions($map, $value);\n    if (@exons == 0 && $exon_num == 1) {\n        return $self->get_transcript_position($map, $value);\n    }\n    return $self->_get_list_element($exon_num, @exons);\n}\n\n=head2 add_intron_position\n\n Title   : add_intron_position\n Usage   : $gene->add_intron_position($position, $transcript_number);\n Function: Set the bounds of an intron of a given transcript on a map (that of\n           the supplied position). Coordinates must be relative to the\n           transcript start. The supplied position will be given a type 'intron'\n           and a relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_intron_position {\n    my $self = shift;\n    $self->_add_type_position('intron', @_);\n}\n\n=head2 get_intron_positions\n\n Title   : get_intron_positions\n Usage   : my @positions = $gene->get_intron_positions($map, $int);\n Function: Get all the intron positions that are relative to the $int'th\n           transcript position added to the map. Introns are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_intron_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'intron', $value);\n}\n\n=head2 get_intron_position\n\n Title   : get_intron_position\n Usage   : my $position = $gene->get_intron_position($map, $intron_num, $int);\n Function: Get the $intron_num'th intron position that is relative to the\n           $int'th transcript position added to the map. Introns are numbered in\n           Position order, not the order they were added to the map.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the intron you want) AND int (the\n           transcript number; if second int not supplied, or 0, considers the\n           currently active transcript)","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$intron_num"},{"label":"$value"}]},"detail":"($self,$map,$intron_num,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_intron_position","line":678,"kind":13},{"name":"$map","containerName":"get_intron_position","line":678,"kind":13},{"line":678,"kind":13,"name":"$intron_num","containerName":"get_intron_position"},{"kind":13,"line":678,"containerName":"get_intron_position","name":"$value"},{"kind":13,"line":679,"containerName":"get_intron_position","name":"@introns","definition":"my","localvar":"my"},{"containerName":"get_intron_position","name":"$self","line":679,"kind":13},{"containerName":"get_intron_position","name":"get_intron_positions","kind":12,"line":679},{"kind":13,"line":679,"containerName":"get_intron_position","name":"$map"},{"kind":13,"line":679,"containerName":"get_intron_position","name":"$value"},{"name":"$self","containerName":"get_intron_position","kind":13,"line":680},{"kind":12,"line":680,"containerName":"get_intron_position","name":"_get_list_element"},{"containerName":"get_intron_position","name":"$intron_num","kind":13,"line":680},{"containerName":"get_intron_position","name":"@introns","line":680,"kind":13}],"line":677,"kind":12,"range":{"end":{"line":681,"character":9999},"start":{"line":677,"character":0}},"name":"get_intron_position"},{"range":{"end":{"character":9999,"line":726},"start":{"character":0,"line":707}},"name":"set_from_db","line":707,"children":[{"kind":13,"line":708,"containerName":"set_from_db","name":"$self","definition":"my","localvar":"my"},{"name":"$bool","containerName":"set_from_db","line":708,"kind":13},{"name":"$USE_ENSEMBL","containerName":"set_from_db","line":709,"kind":13},{"kind":12,"line":710,"containerName":"set_from_db","name":"registry_setup"},{"name":"$bool","containerName":"set_from_db","kind":13,"line":711},{"containerName":"set_from_db","name":"$bool","kind":13,"line":711},{"kind":13,"line":713,"name":"$self","containerName":"set_from_db"},{"containerName":"set_from_db","name":"$SET_FROM_DB","kind":13,"line":714},{"line":714,"kind":13,"containerName":"set_from_db","name":"$bool"},{"kind":13,"line":718,"name":"$self","containerName":"set_from_db"},{"name":"$bool","containerName":"set_from_db","kind":13,"line":718},{"localvar":"my","containerName":"set_from_db","name":"$success","definition":"my","line":720,"kind":13},{"kind":13,"line":721,"definition":"my","name":"$map","containerName":"set_from_db","localvar":"my"},{"name":"$self","containerName":"set_from_db","kind":13,"line":721},{"line":721,"kind":12,"containerName":"set_from_db","name":"known_maps"},{"line":722,"kind":13,"name":"$success","containerName":"set_from_db"},{"containerName":"set_from_db","name":"$self","line":722,"kind":13},{"name":"_set_from_db","containerName":"set_from_db","kind":12,"line":722},{"line":722,"kind":13,"name":"$map","containerName":"set_from_db"},{"name":"$success","containerName":"set_from_db","kind":13,"line":725}],"kind":12,"detail":"($self,$bool)","signature":{"parameters":[{"label":"$self"},{"label":"$bool"}],"documentation":"1;\n# $Id: Gene.pm,v 1.6 2006/07/17 14:16:53 sendu Exp $\n#\n# BioPerl module for Bio::Map::Gene\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Sendu Bala <bix@sendu.me.uk>\n#\n# Copyright Sendu Bala\n# \n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Map::Gene - An gene modelled as a mappable element.\n\n=head1 SYNOPSIS\n\n  use Bio::Map::Gene;\n\n  my $gene = Bio::Map::Gene->get(-universal_name => 'BRCA2',\n                                 -description => 'breast cancer 2, early onset');\n\n  # Normally you get Gene objects from GeneMaps\n  use Bio::Map::GeneMap;\n\n  # Model a gene with its orthologous versions found in different species,\n  # but at abstract locations within each genome\n  my $map1 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $human);\n  my $map2 = Bio::Map::GeneMap->get(-universal_name => 'BRCA2', -species => $mouse);\n\n  $gene = $map1->gene;\n\n  # Genes can have special kinds of positions (Bio::Map::GenePosition) that\n  # define where various sub-regions of the gene are, relative to one of the\n  # normal Positions the gene has placing it on a map.\n  my $trans = Bio::Map::GenePosition->new(-start => 0, -length => 700,\n                                          -map => $map1, -type => 'transcript');\n  $gene->add_transcript_position($trans);\n  my $exon = Bio::Map::GenePosition->new(-start => 0, -length => 100,\n                                         -map => $map1, -type => 'exon');\n  $gene->add_exon_position($exon, 1);\n  # (so now the gene has 1 transcript 700bp long which starts at the beginning\n  #  of the gene, and we've defined the first of many exons which starts at the\n  #  start of the transcript and is 100bp long)\n\n=head1 DESCRIPTION\n\nModel a gene as an abstract mappable element. This is for when you don't care\nexactly where a gene is in a genome, but just want to model other things (like\ntranscription factor binding sites) that are near it so you can answer questions\nlike \"what binds near this gene?\", or \"which genes does this bind near?\".\n\nSee t/Map/Map.t for more example usage.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Sendu Bala\n\nEmail bix@sendu.me.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Map::Gene;\nuse strict;\n\nuse Bio::Map::GenePosition;\n\nuse base qw(Bio::Map::Mappable);\n\nour $USE_ENSEMBL;\nour $GENES = {};\nour $SET_FROM_DB = 0;\n\nBEGIN {\n    # Bio::Tools::Run::Ensembl is in bioperl-run package which may not be\n    # installed, but its functionality is only optional here\n    eval {require Bio::Tools::Run::Ensembl;};\n    $USE_ENSEMBL = ! $@;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $gene = Bio::Map::Gene->new();\n Function: Builds a new Bio::Map::Gene object\n Returns : Bio::Map::Gene\n Args    : -universal_name => string : name of the gene (in a form common to all\n                                       species that have the gene, but unique\n                                       amongst non-orthologous genes), REQUIRED\n           -description => string    : free text description of the gene\n\n\nsub new {\n    my ($class, @args) = @_;\n    my $self = $class->SUPER::new(@args);\n    \n    my ($u_name, $desc) = $self->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    $u_name || $self->throw(\"You must supply a -universal_name\");\n    $self->universal_name($u_name);\n    \n    defined $desc && $self->description($desc);\n    \n    return $self;\n}\n\n=head2 get\n\n Title   : get\n Usage   : my $gene = Bio::Map::Gene->get();\n Function: Builds a new Bio::Map::Gene object (like new()), or gets a\n           pre-existing one that shares the same universal_name.\n Returns : Bio::Map::Gene\n Args    : -universal_name => string, name of the gene (in a form common to all\n                              species that have the gene, but unique amongst\n                              non-orthologous genes), REQUIRED\n           -description    => string, free text description of the gene\n\n\nsub get {\n    my ($class, @args) = @_;\n    my ($u_name, $desc) = Bio::Root::Root->_rearrange([qw(UNIVERSAL_NAME DESCRIPTION)], @args);\n    \n    if ($u_name && defined $GENES->{$u_name}) {\n        $GENES->{$u_name}->description($desc) if $desc;\n        return $GENES->{$u_name};\n    }\n    \n    return $class->new(@args);\n}\n\n=head2 universal_name\n\n Title   : universal_name\n Usage   : my $name = $gene->universal_name\n Function: Get/Set Mappable name, corresponding to the name of the gene in a\n           form shared by orthologous versions of the gene in different species,\n           but otherwise unique.\n Returns : string\n Args    : none to get, OR string to set\n\n\nsub universal_name {\n    my ($self, $value) = @_;\n    if (defined $value) {\n        delete $GENES->{$self->{'_uname'}} if $self->{'_uname'};\n        $self->{'_uname'} = $value;\n        $GENES->{$value} = $self;\n    }\n    return $self->{'_uname'};\n}\n\n=head2 description\n\n Title   : description\n Usage   : my $description = $gene->description();\n           $gene->description($description);\n Function: Get/set information relating to the gene, in this case the\n           description (eg. 'full name of gene')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub description {\n    my $self = shift;\n    return $self->_gene_data('description', @_);\n}\n\n=head2 display_id\n\n Title   : display_id\n Usage   : my $display_id = $gene->display_id();\n           $gene->display_id($display_id);\n Function: Get/set information relating to the gene, in this case the\n           display_id (eg. 'ENSG00000155287')\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_id {\n    my $self = shift;\n    return $self->_gene_data('display_id', @_);\n}\n\n=head2 display_xref\n\n Title   : display_xref\n Usage   : my $display_xref = $gene->display_xref();\n           $gene->display_xref($display_xref);\n Function: Get/set information relating to the gene, in this case the\n           display_xref (eg. 'HUGO:23472').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub display_xref {\n    my $self = shift;\n    return $self->_gene_data('display_xref', @_);\n}\n\n=head2 external_db\n\n Title   : external_db\n Usage   : my $external_db = $gene->external_db();\n           $gene->external_db($external_db);\n Function: Get/set information relating to the gene, in this case the\n           external_db (eg. 'HUGO').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_db {\n    my $self = shift;\n    return $self->_gene_data('external_db', @_);\n}\n\n=head2 external_name\n\n Title   : external_name\n Usage   : my $external_name = $gene->external_name();\n           $gene->external_name($external_name);\n Function: Get/set information relating to the gene, in this case the (eg.\n           'gene_name', probably the same as or similar to what you set\n           universal_name() to, but could be a species-specific alternative).\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub external_name {\n    my $self = shift;\n    return $self->_gene_data('external_name', @_);\n}\n\n=head2 biotype\n\n Title   : biotype\n Usage   : my $biotype = $gene->biotype();\n           $gene->biotype($biotype);\n Function: Get/set information relating to the gene, in this case the biotype\n           (eg. 'protein_coding').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub biotype {\n    my $self = shift;\n    return $self->_gene_data('biotype', @_);\n}\n\n=head2 source\n\n Title   : source\n Usage   : my $source = $gene->source();\n           $gene->source($source);\n Function: Get/set information relating to the gene, in this case the source\n           (eg. '??').\n Returns : string (empty string if not defined)\n Args    : none to get general version, OR Bio::Map::GeneMap to get map-specific\n           version.\n           string to set general version, optionally AND Bio::Map::GeneMap to\n           set map-specific version\n\n\nsub source {\n    my $self = shift;\n    return $self->_gene_data('source', @_);\n}\n\n=head2 position\n\n Title   : position\n Usage   : my $position = $mappable->position($map);\n Function: Get the main Position of this Mappable on a given map. (A gene may\n           have many positions on a map, but all but one of them are\n           Bio::Map::GenePosition objects that describe sub-regions of the gene\n           which are relative to the 'main' Bio::Map::Position position, which\n           is the only one that is directly relative to the map - this is the\n           Position returned by this method.)\n Returns : Bio::Map::Position\n Args    : L<Bio::Map::MapI> object.\n\n\nsub position {\n    my ($self, $map) = @_;\n    ($map && $self->in_map($map)) || return;\n    \n    foreach my $pos ($self->get_positions($map, 1)) {\n        next if $pos->isa('Bio::Map::GenePosition');\n        return $pos;\n        #*** could do sanity checking; there should only be 1 non-GenePosition\n        #    object here, and it should have a relative of type 'map', and it\n        #    should sort before or equal to all other positions\n    }\n}\n\n=head2 add_transcript_position\n\n Title   : add_transcript_position\n Usage   : $gene->add_transcript_position($position);\n Function: Set the bounds of a transcript on a map (that of the supplied\n           position). All transcript positions added this way must have\n           coordinates relative to the main position of the 'gene' mappable on\n           this transcript's map. The first position added using this method\n           must have a start of 0. The supplied Position will be given a type of\n           'transcript' and relative of (gene => 0). The active_transcript for\n           the Position's map will be set to this one.\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on)\n\n\nsub add_transcript_position {\n    my ($self, $pos) = @_;\n    ($pos && $pos->isa('Bio::Map::GenePosition')) || return;\n    \n    my $map = $pos->map || $self->throw(\"Supplied GenePosition has no map\");\n    $self->in_map($map) || $self->throw(\"Supplied GenePosition is not on a map that this gene belong to\");\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0) {\n        # first transcript needs start of 0\n        if ($pos->start != 0) {\n            $self->warn(\"The first transcript position added to a map needs a start of 0, not adding\");\n            return;\n        }\n    }\n    \n    $pos->type('transcript');\n    $pos->relative->gene(0);\n    $self->SUPER::add_position($pos);\n    \n    # need to remember the order these were added, but remember what we store\n    # here could become invalid if positions are purged outside of this class\n    push(@{$self->{t_order}->{$map}}, $pos);\n    \n    # adjust main position's length to hold this transcript\n    my $main_pos = $self->position($map);\n    my $increase = ($pos->length + $pos->start($pos->absolute_relative)) - ($main_pos->end + 1);\n    if ($increase > 0) {\n        $main_pos->end($main_pos->end + $increase);\n    }\n    \n    # make this new transcript the active one\n    $self->active_transcript($map, scalar(@transcripts) + 1);\n}\n\n=head2 active_transcript\n\n Title   : active_transcript\n Usage   : my $active = $gene->active_transcript($map);\n           $gene->active_transcript($map, $int);\n Function: Get/set the active transcript number (an int of 1 would mean the 1st\n           transcript position added to the object for the given map, ie. would\n           correspond to the the 1st Position object in the list returned by\n           get_transcript_positions($map)). The active transcript is the one\n           considered by other methods and objects when dealing with positions\n           relative to 'the' transcript.\n Returns : int, 0 means there were no transcript positions on the given map,\n           undef is some other problem\n Args    : Just Bio::Map::GeneMap to get\n           Bio::Map::GeneMap AND int to set\n\n\nsub active_transcript {\n    my ($self, $map, $int) = @_;\n    $map or return;\n    \n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts > 0) {\n        if (defined($int)) {\n            if ($int > 0 && $int <= @transcripts) {\n                $self->{active_transcript}->{$map} = $int;\n                return $int;\n            }\n            else {\n                $self->warn(\"Supplied int '$int' not a good number (higher than the number of transcripts on the map?)\");\n                return;\n            }\n        }\n        else {\n            if (defined $self->{active_transcript}->{$map}) {\n                return $self->{active_transcript}->{$map};\n            }\n            else {\n                # default to the total number of transcripts on the map, ie. the\n                # most recently added\n                $self->{active_transcript}->{$map} = @transcripts;\n                return $self->{active_transcript}->{$map};\n            }\n        }\n    }\n    return 0;\n}\n\n=head2 get_transcript_positions\n\n Title   : get_transcript_positions\n Usage   : my @transcript_positions = $gene->get_transcript_positions($map);\n Function: Get all the transcript positions of this gene on the given map, in\n           the order they were added to the map.\n Returns : list of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap\n\n\nsub get_transcript_positions {\n    my ($self, $map) = @_;\n    $map or return;\n    $map->isa('Bio::Map::GeneMap') or return;\n    return $self->_get_typed_positions($map, 'transcript');\n}\n\n=head2 get_transcript_position\n\n Title   : get_transcript_position\n Usage   : my $position = $gene->get_transcript_position($map, $int);\n Function: Get the $int'th transcript position added to the map. If no\n           transcripts have been added to the map, and the default transcript\n           was requested, $gene->position is returned, as that will have the\n           same start and end as the first transcript.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (if int not supplied, or 0, returns\n           the currently active transcript position)\n\n\nsub get_transcript_position {\n    my ($self, $map, $value) = @_;\n    $map or return;\n    $value ||= $self->active_transcript($map);\n    my @transcripts = $self->get_transcript_positions($map);\n    if (@transcripts == 0 && $value == 0) {\n        return $self->position($map);\n    }\n    return $self->_get_list_element($value, @transcripts);\n}\n\n=head2 coding_position\n\n Title   : coding_position\n Usage   : $gene->coding_position($position, $transcript_number);\n           $gene->coding_position($map, $transcript_number);\n Function: Get/set the bounds of a coding region of a given transcript on a map\n           (that of the supplied position).\n\n           When setting, coordinates must be relative to the transcript start.\n           The supplied position will be given a type 'coding' and a relative\n           (-transcript => $transcript_number). There can be only one coding\n           position per transcript (hence this is a get/set).\n\n           When getting, if a coding region has not been defined for the\n           requested transcript, $gene->get_transcript_position($map,\n           $transcript_number) is returned, as if assuming the entirety of the\n           transcript is coding.\n\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number) to get, OR to set:\n           Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number)\n           In both cases, if transcript number not supplied or 0 this will be\n           resolved to the current active transcript number - there must be at\n           least one transcript on the map\n\n\nsub coding_position {\n    my ($self, $thing, $transcript_num) = @_;\n    ref($thing) || return;\n    $transcript_num ||= 0;\n    \n    # deliberate test for PositionI so _add_type_position can do nothing if\n    # its not a GenePosition\n    if ($thing->isa('Bio::Map::PositionI')) {\n        my $map = $thing->map || return;\n        my ($existing_pos) = $self->_get_typed_positions($map, 'coding', $transcript_num);\n        if ($existing_pos) {\n            # purge it\n            $self->purge_positions($existing_pos);\n        }\n        $self->_add_type_position('coding', $thing, $transcript_num);\n        $thing = $map;\n    }\n    \n    my ($pos) = $self->_get_typed_positions($thing, 'coding', $transcript_num);\n    return $pos || $self->get_transcript_position($thing, $transcript_num);\n}\n\n=head2 add_exon_position\n\n Title   : add_exon_position\n Usage   : $gene->add_exon_position($position, $transcript_number);\n Function: Set the bounds of an exon of a given transcript on a map (that of the\n           supplied position). Coordinates must be relative to the transcript\n           start. The supplied position will be given a type 'exon' and a\n           relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_exon_position {\n    my $self = shift;\n    $self->_add_type_position('exon', @_);\n}\n\n=head2 get_exon_positions\n\n Title   : get_exon_positions\n Usage   : my @positions = $gene->get_exon_positions($map, $int);\n Function: Get all the exon positions that are relative to the $int'th\n           transcript position added to the map. Exons are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_exon_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'exon', $value);\n}\n\n=head2 get_exon_position\n\n Title   : get_exon_position\n Usage   : my $position = $gene->get_exon_position($map, $exon_num, $int);\n Function: Get the $exon_num'th exon position that is relative to the $int'th\n           transcript position added to the map. Exons are numbered in Position\n           order, not the order they were added to the map. If no exons have\n           been added to the map, and the first exon was requested,\n           $gene->get_transcript_position($map, $int) is returned, as that will\n           have the same start as the first exon, and could have the same end\n           for a single exon gene.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the exon you want) AND int (the transcript\n           number; if second int not supplied, or 0, considers the currently\n           active transcript)\n\n\nsub get_exon_position {\n    my ($self, $map, $exon_num, $value) = @_;\n    my @exons = $self->get_exon_positions($map, $value);\n    if (@exons == 0 && $exon_num == 1) {\n        return $self->get_transcript_position($map, $value);\n    }\n    return $self->_get_list_element($exon_num, @exons);\n}\n\n=head2 add_intron_position\n\n Title   : add_intron_position\n Usage   : $gene->add_intron_position($position, $transcript_number);\n Function: Set the bounds of an intron of a given transcript on a map (that of\n           the supplied position). Coordinates must be relative to the\n           transcript start. The supplied position will be given a type 'intron'\n           and a relative (-transcript => $transcript_number).\n Returns : n/a\n Args    : Bio::Map::GenePosition (which must have its map() defined, and be for\n           a map this gene is on) AND int (the transcript number; if not\n           supplied or 0 this will be resolved to the current active transcript\n           number - there must be at least one transcript on the map)\n\n\nsub add_intron_position {\n    my $self = shift;\n    $self->_add_type_position('intron', @_);\n}\n\n=head2 get_intron_positions\n\n Title   : get_intron_positions\n Usage   : my @positions = $gene->get_intron_positions($map, $int);\n Function: Get all the intron positions that are relative to the $int'th\n           transcript position added to the map. Introns are returned sorted by\n           their start positions.\n Returns : array of Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the transcript number; if second int not\n           supplied, or 0, considers the currently active transcript)\n\n\nsub get_intron_positions {\n    my ($self, $map, $value) = @_;\n    $map || return;\n    $value ||= 0;\n    return $self->_get_typed_positions($map, 'intron', $value);\n}\n\n=head2 get_intron_position\n\n Title   : get_intron_position\n Usage   : my $position = $gene->get_intron_position($map, $intron_num, $int);\n Function: Get the $intron_num'th intron position that is relative to the\n           $int'th transcript position added to the map. Introns are numbered in\n           Position order, not the order they were added to the map.\n Returns : Bio::Map::GenePosition\n Args    : Bio::Map::GeneMap AND int (the intron you want) AND int (the\n           transcript number; if second int not supplied, or 0, considers the\n           currently active transcript)\n\n\nsub get_intron_position {\n    my ($self, $map, $intron_num, $value) = @_;\n    my @introns = $self->get_intron_positions($map, $value);\n    return $self->_get_list_element($intron_num, @introns);\n}\n\n=head2 set_from_db\n\n Title   : set_from_db\n Usage   : $gene->set_from_db(); # for an instance only\n           Bio::Map::Gene->set_from_db(); # decide that all future genes added\n                                          # to maps will be set from db\n Function: Creates all the various types of positions (transcripts, coding,\n           exons, introns) for this gene on all its maps. The information comes\n           from an Ensembl database via Bio::Tools::Run::Ensembl. NB: will\n           purge any existing Bio::Map::GenePosition objects that were\n           previously on the maps this gene is one.\n Returns : undef on failure, otherwise the number of maps that successfully\n           had positions added to them\n Args    : boolean (no argument/undef is treated as 1, ie. do set from db;\n           supply 0 to turn off)\n\n           NB: Bio::Tools::Run::Ensembl is available in the bioperl-run package;\n           see it for details on setting up a database to use.\n\n           Once set, any new maps (species) this gene is added to will\n           automatically also have their positions set_from_db","label":"set_from_db($self,$bool)"},"containerName":"main::","definition":"sub"},{"kind":12,"line":710,"name":"Bio","containerName":"Tools::Run::Ensembl"},{"name":"_set_from_db","kind":12,"line":718},{"line":729,"children":[{"kind":13,"line":730,"name":"$self","definition":"my","containerName":"_set_from_db","localvar":"my"},{"line":730,"kind":13,"name":"$map","containerName":"_set_from_db"},{"kind":13,"line":731,"containerName":"_set_from_db","name":"$gene_name","definition":"my","localvar":"my"},{"kind":13,"line":731,"containerName":"_set_from_db","name":"$self"},{"name":"universal_name","containerName":"_set_from_db","kind":12,"line":731},{"kind":13,"line":732,"name":"$SET_FROM_DB","containerName":"_set_from_db"},{"line":732,"kind":13,"containerName":"_set_from_db","name":"$self"},{"containerName":"_set_from_db","definition":"my","name":"$species","localvar":"my","kind":13,"line":734},{"line":734,"kind":13,"name":"$map","containerName":"_set_from_db"},{"line":734,"kind":12,"containerName":"_set_from_db","name":"species"},{"localvar":"my","name":"$slice_adaptor","definition":"my","containerName":"_set_from_db","line":736,"kind":13},{"kind":12,"line":736,"containerName":"_set_from_db","name":"get_adaptor"},{"containerName":"_set_from_db","name":"$species","line":736,"kind":13},{"definition":"my","name":"$gene","containerName":"_set_from_db","localvar":"my","kind":13,"line":737},{"name":"get_gene_by_name","containerName":"_set_from_db","line":737,"kind":12},{"kind":13,"line":737,"name":"$species","containerName":"_set_from_db"},{"kind":13,"line":738,"name":"$gene_name","containerName":"_set_from_db"},{"name":"$self","containerName":"_set_from_db","kind":13,"line":744},{"containerName":"_set_from_db","name":"description","line":744,"kind":12},{"name":"$gene","containerName":"_set_from_db","kind":13,"line":744},{"name":"description","containerName":"_set_from_db","kind":12,"line":744},{"kind":13,"line":744,"containerName":"_set_from_db","name":"$map"},{"containerName":"_set_from_db","name":"$self","kind":13,"line":745},{"line":745,"kind":12,"containerName":"_set_from_db","name":"display_id"},{"containerName":"_set_from_db","name":"$gene","line":745,"kind":13},{"containerName":"_set_from_db","name":"display_id","line":745,"kind":12},{"containerName":"_set_from_db","name":"$map","line":745,"kind":13},{"line":746,"kind":13,"name":"$self","containerName":"_set_from_db"},{"name":"display_xref","containerName":"_set_from_db","line":746,"kind":12},{"kind":13,"line":746,"name":"$gene","containerName":"_set_from_db"},{"kind":12,"line":746,"name":"display_xref","containerName":"_set_from_db"},{"name":"display_id","containerName":"_set_from_db","kind":12,"line":746},{"line":746,"kind":13,"name":"$map","containerName":"_set_from_db"},{"containerName":"_set_from_db","name":"$self","kind":13,"line":747},{"containerName":"_set_from_db","name":"external_db","kind":12,"line":747},{"line":747,"kind":13,"name":"$gene","containerName":"_set_from_db"},{"kind":12,"line":747,"containerName":"_set_from_db","name":"external_db"},{"name":"$map","containerName":"_set_from_db","kind":13,"line":747},{"kind":13,"line":748,"name":"$self","containerName":"_set_from_db"},{"containerName":"_set_from_db","name":"external_name","kind":12,"line":748},{"kind":13,"line":748,"containerName":"_set_from_db","name":"$gene"},{"line":748,"kind":12,"name":"external_name","containerName":"_set_from_db"},{"line":748,"kind":13,"containerName":"_set_from_db","name":"$map"},{"name":"$self","containerName":"_set_from_db","kind":13,"line":749},{"line":749,"kind":12,"name":"biotype","containerName":"_set_from_db"},{"kind":13,"line":749,"name":"$gene","containerName":"_set_from_db"},{"line":749,"kind":12,"containerName":"_set_from_db","name":"biotype"},{"kind":13,"line":749,"containerName":"_set_from_db","name":"$map"},{"line":750,"kind":13,"containerName":"_set_from_db","name":"$self"},{"name":"source","containerName":"_set_from_db","kind":12,"line":750},{"line":750,"kind":13,"containerName":"_set_from_db","name":"$gene"},{"line":750,"kind":12,"name":"source","containerName":"_set_from_db"},{"containerName":"_set_from_db","name":"$map","kind":13,"line":750},{"containerName":"_set_from_db","name":"$trans_ref","definition":"my","localvar":"my","kind":13,"line":753},{"line":753,"kind":13,"name":"$gene","containerName":"_set_from_db"},{"line":753,"kind":12,"containerName":"_set_from_db","name":"get_all_Transcripts"},{"line":754,"kind":13,"name":"$trans_ref","containerName":"_set_from_db"},{"line":754,"kind":13,"containerName":"_set_from_db","name":"$trans_ref"}],"kind":12,"detail":"($self,$map)","signature":{"parameters":[{"label":"$self"},{"label":"$map"}],"documentation":" set from db for a particular map (species)","label":"_set_from_db($self,$map)"},"containerName":"main::","definition":"sub","range":{"start":{"line":729,"character":0},"end":{"line":754,"character":9999}},"name":"_set_from_db"},{"line":732,"kind":12,"name":"_set_from_db"},{"kind":12,"line":736,"containerName":"Tools::Run::Ensembl","name":"Bio"},{"kind":12,"line":737,"containerName":"Tools::Run::Ensembl","name":"Bio"},{"containerName":null,"name":"$handler","definition":"my","localvar":"my","kind":13,"line":759},{"line":759,"kind":13,"name":"$map","containerName":null},{"containerName":"main::","name":"get_position_handler","kind":12,"line":759},{"definition":"my","name":"$pos","containerName":null,"localvar":"my","kind":13,"line":760},{"name":"$map","containerName":null,"line":760,"kind":13},{"containerName":"main::","name":"get_positions","kind":12,"line":760},{"containerName":null,"name":"$pos","kind":13,"line":761},{"name":"isa","containerName":"main::","kind":12,"line":761},{"containerName":null,"name":"$handler","line":762,"kind":13},{"containerName":"main::","name":"purge_positions","line":762,"kind":12},{"name":"$pos","containerName":null,"kind":13,"line":762},{"line":767,"kind":13,"localvar":"my","containerName":null,"name":"$strand","definition":"my"},{"kind":13,"line":767,"containerName":null,"name":"@trans_ref"},{"line":767,"kind":12,"containerName":"main::","name":"strand"},{"line":768,"kind":13,"localvar":"my","definition":"my","name":"@transcripts","containerName":null},{"kind":13,"line":768,"name":"$strand","containerName":null},{"name":"$b","containerName":null,"line":768,"kind":13},{"name":"end","containerName":"main::","line":768,"kind":12},{"kind":13,"line":768,"containerName":null,"name":"$a"},{"line":768,"kind":12,"name":"end","containerName":"main::"},{"line":768,"kind":13,"name":"$a","containerName":null},{"containerName":"main::","name":"start","line":768,"kind":12},{"line":768,"kind":13,"containerName":null,"name":"$b"},{"line":768,"kind":12,"name":"start","containerName":"main::"},{"line":768,"kind":13,"containerName":null,"name":"$trans_ref"},{"kind":13,"line":772,"name":"$primary_slice","definition":"my","containerName":null,"localvar":"my"},{"name":"$slice_adaptor","containerName":null,"kind":13,"line":772},{"containerName":"main::","name":"fetch_by_transcript_stable_id","kind":12,"line":772},{"name":"@transcripts","containerName":null,"line":772,"kind":13},{"name":"stable_id","containerName":"main::","kind":12,"line":772},{"kind":13,"line":773,"definition":"my","name":"$uid","containerName":null,"localvar":"my"},{"line":773,"kind":13,"name":"$map","containerName":null},{"containerName":"main::","name":"unique_id","kind":12,"line":773},{"name":"%self","containerName":null,"kind":13,"line":774},{"name":"_ensembl","line":774,"kind":12},{"name":"$uid","containerName":null,"line":774,"kind":13},{"kind":13,"line":774,"containerName":null,"name":"$slice_adaptor"},{"kind":13,"line":774,"name":"$primary_slice","containerName":null},{"line":774,"kind":13,"name":"$strand","containerName":null},{"containerName":null,"name":"$adjust","definition":"my","localvar":"my","kind":13,"line":784},{"name":"$strand","containerName":null,"kind":13,"line":784},{"line":784,"kind":13,"containerName":null,"name":"@transcripts"},{"containerName":"main::","name":"end","line":784,"kind":12},{"name":"@transcripts","containerName":null,"kind":13,"line":784},{"name":"start","containerName":"main::","kind":12,"line":784},{"localvar":"my","containerName":null,"name":"$orig_adjust","definition":"my","line":785,"kind":13},{"kind":13,"line":785,"containerName":null,"name":"$adjust"},{"containerName":null,"name":"%adjustment","definition":"my","localvar":"my","kind":13,"line":786},{"name":"$strand","containerName":null,"line":786,"kind":13},{"kind":13,"line":786,"name":"$adjust","containerName":null},{"name":"$adjust","containerName":null,"kind":13,"line":786},{"localvar":"my","name":"$longest_trans","definition":"my","containerName":null,"line":789,"kind":13},{"localvar":"my","name":"$longest","definition":"my","containerName":null,"line":790,"kind":13},{"containerName":null,"name":"$count","definition":"my","localvar":"my","kind":13,"line":791},{"localvar":"my","name":"$transcript","definition":"my","containerName":null,"line":792,"kind":13},{"kind":13,"line":792,"name":"@transcripts","containerName":null},{"localvar":"my","name":"$length","definition":"my","containerName":null,"line":794,"kind":13},{"line":794,"kind":13,"name":"$transcript","containerName":null},{"kind":12,"line":794,"containerName":"main::","name":"length"},{"containerName":null,"name":"$length","line":795,"kind":13},{"kind":13,"line":795,"containerName":null,"name":"%longest_trans"},{"name":"$longest_trans","containerName":null,"line":796,"kind":13},{"line":796,"kind":13,"containerName":null,"name":"$length"},{"name":"$longest","containerName":null,"kind":13,"line":797},{"containerName":null,"name":"$count","kind":13,"line":797},{"localvar":"my","name":"$slice","definition":"my","containerName":null,"line":801,"kind":13},{"kind":13,"line":801,"containerName":null,"name":"$slice_adaptor"},{"containerName":"main::","name":"fetch_by_transcript_stable_id","kind":12,"line":801},{"line":801,"kind":13,"name":"$transcript","containerName":null},{"name":"stable_id","containerName":"main::","line":801,"kind":12},{"kind":13,"line":802,"containerName":null,"name":"$start","definition":"my","localvar":"my"},{"name":"adjustment","kind":12,"line":802},{"name":"$slice","containerName":null,"kind":13,"line":802},{"containerName":"main::","name":"start","kind":12,"line":802},{"localvar":"my","containerName":null,"name":"$end","definition":"my","line":803,"kind":13},{"name":"adjustment","line":803,"kind":12},{"line":803,"kind":13,"containerName":null,"name":"$slice"},{"line":803,"kind":12,"name":"end","containerName":"main::"},{"kind":13,"line":804,"containerName":null,"name":"$start"},{"name":"$end","containerName":null,"kind":13,"line":804},{"containerName":null,"name":"$end","kind":13,"line":804},{"line":804,"kind":13,"name":"$start","containerName":null},{"line":804,"kind":13,"name":"$start","containerName":null},{"name":"$end","containerName":null,"kind":13,"line":804},{"line":806,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$trans_pos"},{"kind":12,"line":806,"name":"Bio","containerName":"Map::GenePosition"},{"line":806,"kind":12,"name":"new","containerName":"main::"},{"kind":13,"line":806,"name":"$map","containerName":null},{"line":806,"kind":13,"name":"$start","containerName":null},{"kind":13,"line":806,"name":"$end","containerName":null},{"kind":13,"line":807,"containerName":null,"name":"$self"},{"line":807,"kind":12,"name":"add_transcript_position","containerName":"main::"},{"kind":13,"line":807,"containerName":null,"name":"$trans_pos"},{"containerName":null,"name":"$adjust","kind":13,"line":811},{"containerName":null,"name":"$strand","kind":13,"line":811},{"name":"$slice","containerName":null,"line":811,"kind":13},{"line":811,"kind":12,"containerName":"main::","name":"end"},{"kind":13,"line":811,"containerName":null,"name":"$slice"},{"line":811,"kind":12,"name":"start","containerName":"main::"},{"containerName":null,"name":"$transcript","line":814,"kind":13},{"containerName":"main::","name":"coding_region_start","kind":12,"line":814},{"kind":13,"line":815,"containerName":null,"definition":"my","name":"$atg","localvar":"my"},{"kind":12,"line":815,"name":"adjustment"},{"containerName":null,"name":"$transcript","kind":13,"line":815},{"kind":12,"line":815,"name":"coding_region_start","containerName":"main::"},{"localvar":"my","containerName":null,"definition":"my","name":"$stop","line":816,"kind":13},{"name":"adjustment","line":816,"kind":12},{"kind":13,"line":816,"containerName":null,"name":"$transcript"},{"kind":12,"line":816,"containerName":"main::","name":"coding_region_end"},{"name":"$atg","containerName":null,"line":817,"kind":13},{"line":817,"kind":13,"name":"$stop","containerName":null},{"containerName":null,"name":"$stop","kind":13,"line":817},{"line":817,"kind":13,"name":"$atg","containerName":null},{"kind":13,"line":817,"containerName":null,"name":"$atg"},{"name":"$stop","containerName":null,"line":817,"kind":13},{"line":819,"kind":13,"localvar":"my","definition":"my","name":"$cod_pos","containerName":null},{"kind":12,"line":819,"containerName":"Map::GenePosition","name":"Bio"},{"line":819,"kind":12,"containerName":"main::","name":"new"},{"name":"$map","containerName":null,"line":819,"kind":13},{"name":"$atg","containerName":null,"line":819,"kind":13},{"line":819,"kind":13,"name":"$stop","containerName":null},{"kind":13,"line":820,"containerName":null,"name":"$self"},{"line":820,"kind":12,"name":"coding_position","containerName":"main::"},{"kind":13,"line":820,"containerName":null,"name":"$cod_pos"},{"kind":13,"line":824,"containerName":null,"definition":"my","name":"$exon","localvar":"my"},{"kind":13,"line":824,"containerName":null,"name":"$transcript"},{"name":"get_all_Exons","containerName":"main::","kind":12,"line":824},{"kind":13,"line":825,"name":"$start","definition":"my","containerName":null,"localvar":"my"},{"line":825,"kind":12,"name":"adjustment"},{"kind":13,"line":825,"containerName":null,"name":"$exon"},{"name":"start","containerName":"main::","line":825,"kind":12},{"kind":13,"line":826,"containerName":null,"name":"$end","definition":"my","localvar":"my"},{"line":826,"kind":12,"name":"adjustment"},{"line":826,"kind":13,"containerName":null,"name":"$exon"},{"line":826,"kind":12,"name":"end","containerName":"main::"},{"containerName":null,"name":"$start","line":827,"kind":13},{"kind":13,"line":827,"containerName":null,"name":"$end"},{"containerName":null,"name":"$end","line":827,"kind":13},{"name":"$start","containerName":null,"line":827,"kind":13},{"kind":13,"line":827,"name":"$start","containerName":null},{"kind":13,"line":827,"containerName":null,"name":"$end"},{"localvar":"my","containerName":null,"name":"$throw_species","definition":"my","line":829,"kind":13},{"containerName":null,"name":"$species","kind":13,"line":829},{"kind":13,"line":829,"name":"$species","containerName":null},{"line":829,"kind":12,"containerName":"main::","name":"scientific_name"},{"name":"$species","containerName":null,"line":829,"kind":13},{"kind":13,"line":830,"containerName":null,"name":"$end"},{"line":830,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"throw","line":830,"kind":12},{"containerName":null,"name":"$gene","kind":13,"line":830},{"line":830,"kind":12,"containerName":"main::","name":"display_id"},{"name":"$pos","definition":"my","containerName":null,"localvar":"my","kind":13,"line":831},{"containerName":"Map::GenePosition","name":"Bio","kind":12,"line":831},{"line":831,"kind":12,"containerName":"main::","name":"new"},{"name":"$map","containerName":null,"line":831,"kind":13},{"kind":13,"line":831,"containerName":null,"name":"$start"},{"kind":13,"line":831,"containerName":null,"name":"$end"},{"name":"$self","containerName":null,"kind":13,"line":832},{"kind":12,"line":832,"name":"add_exon_position","containerName":"main::"},{"kind":13,"line":832,"name":"$pos","containerName":null},{"line":836,"kind":13,"localvar":"my","containerName":null,"name":"$intron","definition":"my"},{"name":"$transcript","containerName":null,"line":836,"kind":13},{"kind":12,"line":836,"name":"get_all_Introns","containerName":"main::"},{"localvar":"my","definition":"my","name":"$start","containerName":null,"line":837,"kind":13},{"name":"adjustment","line":837,"kind":12},{"line":837,"kind":13,"containerName":null,"name":"$intron"},{"kind":12,"line":837,"containerName":"main::","name":"start"},{"localvar":"my","definition":"my","name":"$end","containerName":null,"line":838,"kind":13},{"name":"adjustment","line":838,"kind":12},{"kind":13,"line":838,"containerName":null,"name":"$intron"},{"containerName":"main::","name":"end","line":838,"kind":12},{"kind":13,"line":839,"containerName":null,"name":"$start"},{"kind":13,"line":839,"name":"$end","containerName":null},{"containerName":null,"name":"$end","line":839,"kind":13},{"name":"$start","containerName":null,"line":839,"kind":13},{"containerName":null,"name":"$start","kind":13,"line":839},{"name":"$end","containerName":null,"kind":13,"line":839},{"name":"$pos","definition":"my","containerName":null,"localvar":"my","kind":13,"line":841},{"line":841,"kind":12,"name":"Bio","containerName":"Map::GenePosition"},{"kind":12,"line":841,"containerName":"main::","name":"new"},{"containerName":null,"name":"$map","line":841,"kind":13},{"kind":13,"line":841,"containerName":null,"name":"$start"},{"line":841,"kind":13,"name":"$end","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":842},{"line":842,"kind":12,"name":"add_intron_position","containerName":"main::"},{"kind":13,"line":842,"containerName":null,"name":"$pos"},{"name":"$adjust","containerName":null,"kind":13,"line":845},{"name":"%orig_adjust","containerName":null,"line":845,"kind":13},{"name":"$count","containerName":null,"kind":13,"line":846},{"line":848,"kind":13,"name":"$self","containerName":null},{"containerName":"main::","name":"active_transcript","kind":12,"line":848},{"name":"$map","containerName":null,"kind":13,"line":848},{"kind":13,"line":848,"name":"$longest","containerName":null},{"children":[{"containerName":"_get_typed_positions","name":"$self","definition":"my","localvar":"my","kind":13,"line":855},{"containerName":"_get_typed_positions","name":"$map","kind":13,"line":855},{"line":855,"kind":13,"name":"$type","containerName":"_get_typed_positions"},{"line":855,"kind":13,"name":"$transcript_number","containerName":"_get_typed_positions"},{"containerName":"_get_typed_positions","name":"$transcript_number","line":856,"kind":13},{"kind":13,"line":856,"containerName":"_get_typed_positions","name":"$transcript_number"},{"containerName":"_get_typed_positions","name":"$transcript_number","kind":13,"line":857},{"kind":13,"line":857,"name":"$self","containerName":"_get_typed_positions"},{"containerName":"_get_typed_positions","name":"active_transcript","kind":12,"line":857},{"kind":13,"line":857,"containerName":"_get_typed_positions","name":"$map"},{"containerName":"_get_typed_positions","name":"@positions","definition":"my","localvar":"my","kind":13,"line":860},{"line":861,"kind":13,"localvar":"my","definition":"my","name":"$pos","containerName":"_get_typed_positions"},{"name":"$self","containerName":"_get_typed_positions","kind":13,"line":861},{"line":861,"kind":12,"containerName":"_get_typed_positions","name":"get_positions"},{"containerName":"_get_typed_positions","name":"$map","line":861,"kind":13},{"kind":13,"line":862,"name":"$pos","containerName":"_get_typed_positions"},{"containerName":"_get_typed_positions","name":"isa","line":862,"kind":12},{"name":"$pos","containerName":"_get_typed_positions","line":863,"kind":13},{"containerName":"_get_typed_positions","name":"type","kind":12,"line":863},{"kind":13,"line":863,"name":"$type","containerName":"_get_typed_positions"},{"containerName":"_get_typed_positions","name":"$transcript_number","line":865,"kind":13},{"line":866,"kind":13,"localvar":"my","containerName":"_get_typed_positions","name":"$rel","definition":"my"},{"containerName":"_get_typed_positions","name":"$pos","line":866,"kind":13},{"kind":12,"line":866,"name":"relative","containerName":"_get_typed_positions"},{"name":"$rel","containerName":"_get_typed_positions","line":867,"kind":13},{"kind":12,"line":867,"containerName":"_get_typed_positions","name":"type"},{"name":"$rel_transcript_num","definition":"my","containerName":"_get_typed_positions","localvar":"my","kind":13,"line":868},{"containerName":"_get_typed_positions","name":"$rel","line":868,"kind":13},{"kind":12,"line":868,"name":"transcript","containerName":"_get_typed_positions"},{"line":868,"kind":13,"name":"$self","containerName":"_get_typed_positions"},{"containerName":"_get_typed_positions","name":"active_transcript","kind":12,"line":868},{"containerName":"_get_typed_positions","name":"$map","line":868,"kind":13},{"kind":13,"line":869,"containerName":"_get_typed_positions","name":"$rel_transcript_num"},{"name":"$transcript_number","containerName":"_get_typed_positions","kind":13,"line":869},{"name":"@positions","containerName":"_get_typed_positions","line":872,"kind":13},{"containerName":"_get_typed_positions","name":"$pos","line":872,"kind":13},{"kind":13,"line":879,"containerName":"_get_typed_positions","name":"$transcript_number"},{"containerName":"_get_typed_positions","definition":"my","name":"@sort","localvar":"my","kind":13,"line":882},{"kind":13,"line":883,"containerName":"_get_typed_positions","name":"$a"},{"kind":13,"line":883,"containerName":"_get_typed_positions","name":"$b"},{"line":884,"kind":12,"containerName":"_get_typed_positions","name":"start"},{"containerName":"_get_typed_positions","name":"relative","line":884,"kind":12},{"containerName":"_get_typed_positions","name":"@positions","line":885,"kind":13},{"line":886,"kind":13,"name":"@sort","containerName":"_get_typed_positions"},{"kind":13,"line":889,"containerName":"_get_typed_positions","name":"@known_order","definition":"my","localvar":"my"},{"containerName":"_get_typed_positions","name":"$self","kind":13,"line":889},{"kind":13,"line":889,"containerName":"_get_typed_positions","name":"$map"},{"name":"@known_order","containerName":"_get_typed_positions","kind":13,"line":890},{"line":893,"kind":13,"containerName":"_get_typed_positions","name":"@known_order"},{"name":"@known_order","containerName":"_get_typed_positions","line":893,"kind":13},{"name":"@positions","containerName":"_get_typed_positions","line":893,"kind":13},{"containerName":"_get_typed_positions","definition":"my","name":"%exists","localvar":"my","kind":13,"line":894},{"kind":13,"line":894,"containerName":"_get_typed_positions","name":"@positions"},{"kind":13,"line":895,"containerName":"_get_typed_positions","name":"@new_order","definition":"my","localvar":"my"},{"localvar":"my","definition":"my","name":"$pos","containerName":"_get_typed_positions","line":896,"kind":13},{"line":896,"kind":13,"containerName":"_get_typed_positions","name":"@known_order"},{"containerName":"_get_typed_positions","name":"$exists","kind":13,"line":897},{"kind":13,"line":897,"name":"$pos","containerName":"_get_typed_positions"},{"containerName":"_get_typed_positions","name":"@new_order","kind":13,"line":898},{"containerName":"_get_typed_positions","name":"$pos","kind":13,"line":898},{"line":900,"kind":13,"name":"$self","containerName":"_get_typed_positions"},{"containerName":"_get_typed_positions","name":"$map","line":900,"kind":13}],"line":854,"kind":12,"signature":{"documentation":" get safely sorted positions of a certain type","parameters":[{"label":"$self"},{"label":"$map"},{"label":"$type"},{"label":"$transcript_number"}],"label":"_get_typed_positions($self,$map,$type,$transcript_number)"},"detail":"($self,$map,$type,$transcript_number)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":854},"end":{"line":900,"character":9999}},"name":"_get_typed_positions"},{"kind":12,"line":889,"name":"t_order"},{"line":900,"kind":12,"name":"t_order"},{"line":900,"kind":13,"name":"@new_order","containerName":null},{"name":"@new_order","containerName":null,"line":901,"kind":13},{"name":"_get_list_element","range":{"start":{"character":0,"line":906},"end":{"line":915,"character":9999}},"kind":12,"children":[{"name":"$self","definition":"my","containerName":"_get_list_element","localvar":"my","kind":13,"line":907},{"line":907,"kind":13,"name":"$wanted","containerName":"_get_list_element"},{"containerName":"_get_list_element","name":"@list","kind":13,"line":907},{"kind":13,"line":908,"containerName":"_get_list_element","name":"$wanted"},{"line":908,"kind":13,"containerName":"_get_list_element","name":"$wanted"},{"containerName":"_get_list_element","name":"@list","line":909,"kind":13},{"kind":13,"line":910,"containerName":"_get_list_element","definition":"my","name":"$index","localvar":"my"},{"containerName":"_get_list_element","name":"$wanted","kind":13,"line":910},{"containerName":"_get_list_element","name":"$index","line":911,"kind":13},{"name":"$index","containerName":"_get_list_element","kind":13,"line":911},{"kind":13,"line":912,"name":"$list","containerName":"_get_list_element"},{"containerName":"_get_list_element","name":"$index","kind":13,"line":912}],"line":906,"definition":"sub","containerName":"main::","signature":{"label":"_get_list_element($self,$wanted,@list)","parameters":[{"label":"$self"},{"label":"$wanted"},{"label":"@list"}],"documentation":" get a certain element from an array, checking the array has that element"},"detail":"($self,$wanted,@list)"},{"name":"list","kind":12,"line":911},{"detail":"($self,$type,$pos,$transcript_num)","signature":{"documentation":" add a certain type of posiiton","parameters":[{"label":"$self"},{"label":"$type"},{"label":"$pos"},{"label":"$transcript_num"}],"label":"_add_type_position($self,$type,$pos,$transcript_num)"},"containerName":"main::","definition":"sub","line":918,"children":[{"line":919,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_add_type_position"},{"containerName":"_add_type_position","name":"$type","line":919,"kind":13},{"kind":13,"line":919,"containerName":"_add_type_position","name":"$pos"},{"line":919,"kind":13,"name":"$transcript_num","containerName":"_add_type_position"},{"line":920,"kind":13,"name":"$pos","containerName":"_add_type_position"},{"name":"$pos","containerName":"_add_type_position","kind":13,"line":920},{"name":"isa","containerName":"_add_type_position","line":920,"kind":12},{"containerName":"_add_type_position","definition":"my","name":"$map","localvar":"my","kind":13,"line":922},{"name":"$pos","containerName":"_add_type_position","kind":13,"line":922},{"kind":12,"line":922,"name":"map","containerName":"_add_type_position"},{"line":922,"kind":13,"containerName":"_add_type_position","name":"$self"},{"line":922,"kind":12,"name":"throw","containerName":"_add_type_position"},{"kind":13,"line":923,"containerName":"_add_type_position","name":"$self"},{"line":923,"kind":12,"containerName":"_add_type_position","name":"in_map"},{"kind":13,"line":923,"name":"$map","containerName":"_add_type_position"},{"line":923,"kind":13,"name":"$self","containerName":"_add_type_position"},{"name":"throw","containerName":"_add_type_position","kind":12,"line":923},{"line":925,"kind":13,"containerName":"_add_type_position","name":"$transcript_num"},{"containerName":"_add_type_position","name":"$self","line":925,"kind":13},{"name":"active_transcript","containerName":"_add_type_position","kind":12,"line":925},{"line":925,"kind":13,"name":"$map","containerName":"_add_type_position"},{"line":925,"kind":13,"containerName":"_add_type_position","name":"$self"},{"name":"throw","containerName":"_add_type_position","kind":12,"line":925},{"kind":13,"line":928,"name":"$transcript_pos","definition":"my","containerName":"_add_type_position","localvar":"my"},{"name":"$self","containerName":"_add_type_position","line":928,"kind":13},{"kind":12,"line":928,"name":"get_transcript_position","containerName":"_add_type_position"},{"name":"$map","containerName":"_add_type_position","line":928,"kind":13},{"name":"$transcript_num","containerName":"_add_type_position","kind":13,"line":928},{"containerName":"_add_type_position","name":"$self","line":928,"kind":13},{"name":"throw","containerName":"_add_type_position","kind":12,"line":928},{"kind":13,"line":929,"name":"$transcript_pos","containerName":"_add_type_position"},{"kind":12,"line":929,"containerName":"_add_type_position","name":"end"},{"line":929,"kind":13,"name":"$self","containerName":"_add_type_position"},{"kind":12,"line":929,"containerName":"_add_type_position","name":"warn"},{"name":"$self","containerName":"_add_type_position","line":929,"kind":13},{"kind":12,"line":929,"containerName":"_add_type_position","name":"universal_name"},{"line":929,"kind":13,"name":"$pos","containerName":"_add_type_position"},{"kind":12,"line":929,"containerName":"_add_type_position","name":"map"},{"name":"$pos","containerName":"_add_type_position","line":930,"kind":13},{"containerName":"_add_type_position","name":"end","line":930,"kind":12},{"line":930,"kind":13,"containerName":"_add_type_position","name":"$self"},{"line":930,"kind":12,"name":"warn","containerName":"_add_type_position"},{"kind":13,"line":930,"name":"$self","containerName":"_add_type_position"},{"name":"universal_name","containerName":"_add_type_position","kind":12,"line":930},{"line":930,"kind":13,"name":"$pos","containerName":"_add_type_position"},{"line":930,"kind":12,"name":"map","containerName":"_add_type_position"},{"line":931,"kind":13,"name":"$transcript_pos","containerName":"_add_type_position"},{"containerName":"_add_type_position","name":"contains","line":931,"kind":12},{"kind":13,"line":931,"name":"$pos","containerName":"_add_type_position"},{"line":932,"kind":13,"containerName":"_add_type_position","name":"$self"},{"name":"warn","containerName":"_add_type_position","line":932,"kind":12},{"containerName":"_add_type_position","name":"$pos","line":936,"kind":13},{"containerName":"_add_type_position","name":"type","line":936,"kind":12},{"name":"$type","containerName":"_add_type_position","kind":13,"line":936},{"line":937,"kind":13,"name":"$pos","containerName":"_add_type_position"},{"name":"relative","containerName":"_add_type_position","kind":12,"line":937},{"line":937,"kind":12,"name":"transcript","containerName":"_add_type_position"},{"name":"$transcript_num","containerName":"_add_type_position","line":937,"kind":13},{"name":"$self","containerName":"_add_type_position","kind":13,"line":938},{"line":938,"kind":13,"name":"$pos","containerName":"_add_type_position"}],"kind":12,"range":{"start":{"character":0,"line":918},"end":{"line":939,"character":9999}},"name":"_add_type_position"},{"line":929,"kind":12,"name":"species"},{"name":"species","line":930,"kind":12},{"kind":12,"line":938,"containerName":"add_position","name":"SUPER"},{"detail":"($self,$type,$thing,$map)","signature":{"parameters":[{"label":"$self"},{"label":"$type"},{"label":"$thing"},{"label":"$map"}],"documentation":" get/setter for general/map-specific data","label":"_gene_data($self,$type,$thing,$map)"},"containerName":"main::","definition":"sub","line":942,"children":[{"line":943,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_gene_data"},{"kind":13,"line":943,"containerName":"_gene_data","name":"$type"},{"name":"$thing","containerName":"_gene_data","line":943,"kind":13},{"line":943,"kind":13,"name":"$map","containerName":"_gene_data"},{"line":944,"kind":13,"containerName":"_gene_data","name":"$thing"},{"kind":13,"line":944,"name":"$self","containerName":"_gene_data"},{"kind":13,"line":944,"name":"$type","containerName":"_gene_data"},{"name":"$thing","containerName":"_gene_data","kind":13,"line":946},{"kind":13,"line":946,"name":"$thing","containerName":"_gene_data"},{"containerName":"_gene_data","name":"isa","kind":12,"line":946},{"name":"$self","containerName":"_gene_data","line":947,"kind":13},{"kind":13,"line":947,"name":"$type","containerName":"_gene_data"},{"containerName":"_gene_data","name":"$thing","kind":13,"line":947},{"name":"$map","containerName":"_gene_data","line":950,"kind":13},{"containerName":"_gene_data","name":"$map","kind":13,"line":950},{"kind":12,"line":950,"containerName":"_gene_data","name":"isa"},{"line":951,"kind":13,"name":"$self","containerName":"_gene_data"},{"kind":13,"line":951,"containerName":"_gene_data","name":"$type"},{"kind":13,"line":951,"name":"$map","containerName":"_gene_data"},{"line":951,"kind":13,"name":"$thing","containerName":"_gene_data"},{"kind":13,"line":954,"name":"$self","containerName":"_gene_data"},{"line":954,"kind":13,"name":"$type","containerName":"_gene_data"},{"name":"$thing","containerName":"_gene_data","kind":13,"line":954},{"line":956,"kind":13,"containerName":"_gene_data","name":"$thing"}],"kind":12,"range":{"start":{"character":0,"line":942},"end":{"character":9999,"line":957}},"name":"_gene_data"},{"name":"general","kind":12,"line":944},{"kind":12,"line":954,"name":"general"},{"definition":"sub","containerName":"main::","signature":{"documentation":" for exclusive use by GeneMap so it can get sequence data","parameters":[{"label":"$self"},{"label":"$map"}],"label":"_get_slice($self,$map)"},"detail":"($self,$map)","kind":12,"children":[{"containerName":"_get_slice","name":"$self","definition":"my","localvar":"my","kind":13,"line":961},{"line":961,"kind":13,"containerName":"_get_slice","name":"$map"},{"name":"$map","containerName":"_get_slice","line":962,"kind":13},{"localvar":"my","name":"$uid","definition":"my","containerName":"_get_slice","line":963,"kind":13},{"containerName":"_get_slice","name":"$map","line":963,"kind":13},{"kind":12,"line":963,"name":"unique_id","containerName":"_get_slice"},{"name":"$self","containerName":"_get_slice","line":964,"kind":13},{"containerName":"_get_slice","name":"$uid","line":964,"kind":13},{"name":"$self","containerName":"_get_slice","kind":13,"line":965},{"line":965,"kind":13,"name":"$uid","containerName":"_get_slice"}],"line":960,"name":"_get_slice","range":{"end":{"character":9999,"line":966},"start":{"line":960,"character":0}}},{"line":964,"kind":12,"name":"_ensembl"},{"name":"_ensembl","kind":12,"line":965}]}