{"vars":[{"containerName":"","name":"base","kind":2,"line":78},{"name":"location_type","range":{"start":{"character":0,"line":92},"end":{"line":95,"character":9999}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: FuzzyLocationI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Location::FuzzyLocationI\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Location::FuzzyLocationI - Abstract interface of a Location on a Sequence\nwhich has unclear start/end location\n\n=head1 SYNOPSIS\n\n    # Get a FuzzyLocationI object somehow\n    print \"Fuzzy FT location string is \", $location->to_FTstring();\n    print \"location is of the type \", $location->loc_type, \"\\n\";\n\n=head1 DESCRIPTION\n\nThis interface encapsulates the necessary methods for representing a\nFuzzy Location, one that does not have clear start and/or end points.\nThis will initially serve to handle features from Genbank/EMBL feature\ntables that are written as 1^100 meaning between bases 1 and 100 or\nE<lt>100..300 meaning it starts somewhere before 100.  Advanced\nimplementations of this interface may be able to handle the necessary\nlogic of overlaps/intersection/contains/union.  It was constructed to\nhandle fuzzy locations that can be represented in Genbank/EMBL.\n\n=head1 FEEDBACK\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\n\npackage Bio::Location::FuzzyLocationI;\nuse strict;\n\nuse base qw(Bio::LocationI);\n\n=head1 LocationI methods\n\n=head2 location_type\n\n  Title   : loc_type\n  Usage   : my $location_type = $location->location_type();\n  Function: Get location type encoded as text\n  Returns : string ('EXACT', 'WITHIN', 'IN-BETWEEN')\n  Args    : none","label":"location_type($self)"},"detail":"($self)","kind":12,"children":[{"containerName":"location_type","name":"$self","definition":"my","localvar":"my","kind":13,"line":93},{"name":"$self","containerName":"location_type","line":94,"kind":13},{"containerName":"location_type","name":"throw_not_implemented","line":94,"kind":12}],"line":92}],"version":5}