{"vars":[{"kind":2,"line":44,"name":"Carp","containerName":""},{"range":{"start":{"character":0,"line":74},"end":{"character":9999,"line":91}},"name":"entry2liveseq","signature":{"parameters":[{"label":"$self"},{"label":"%args"}],"documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended","label":"entry2liveseq($self,%args)"},"detail":"($self,%args)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":75,"definition":"my","name":"$self","containerName":"entry2liveseq","localvar":"my"},{"line":75,"kind":13,"name":"%args","containerName":"entry2liveseq"},{"localvar":"my","definition":"my","name":"$getswissprotinfo","containerName":"entry2liveseq","line":76,"kind":13},{"name":"$args","containerName":"entry2liveseq","kind":13,"line":76},{"name":"$getswissprotinfo","containerName":"entry2liveseq","line":77,"kind":13},{"name":"$getswissprotinfo","containerName":"entry2liveseq","kind":13,"line":78},{"name":"$getswissprotinfo","containerName":"entry2liveseq","line":78,"kind":13},{"name":"$getswissprotinfo","containerName":"entry2liveseq","line":80,"kind":13},{"line":83,"kind":13,"containerName":"entry2liveseq","name":"$getswissprotinfo"},{"line":85,"kind":13,"localvar":"my","definition":"my","name":"$hashref","containerName":"entry2liveseq"},{"kind":13,"line":85,"containerName":"entry2liveseq","name":"$self"},{"kind":13,"line":86,"containerName":"entry2liveseq","name":"$hashref"},{"localvar":"my","containerName":"entry2liveseq","definition":"my","name":"@translationobjects","line":87,"kind":13},{"containerName":"entry2liveseq","name":"$self","kind":13,"line":87},{"containerName":"entry2liveseq","name":"hash2liveseq","line":87,"kind":12},{"kind":13,"line":87,"name":"$hashref","containerName":"entry2liveseq"},{"kind":13,"line":87,"containerName":"entry2liveseq","name":"$getswissprotinfo"},{"localvar":"my","definition":"my","name":"$test_transl","containerName":"entry2liveseq","line":88,"kind":13},{"line":89,"kind":13,"containerName":"entry2liveseq","name":"$test_transl"},{"line":89,"kind":13,"name":"$self","containerName":"entry2liveseq"},{"line":89,"kind":12,"name":"test_transl","containerName":"entry2liveseq"},{"name":"$hashref","containerName":"entry2liveseq","kind":13,"line":89},{"containerName":"entry2liveseq","name":"@translationobjects","kind":13,"line":89},{"containerName":"entry2liveseq","name":"@translationobjects","line":90,"kind":13}],"line":74,"kind":12},{"kind":2,"line":75,"name":"CodonTable","containerName":"Bio::LiveSeq::DNA::Bio::LiveSeq::Exon::Bio::LiveSeq::Transcript::Bio::LiveSeq::Translation::Bio::LiveSeq::Gene::Bio::LiveSeq::Intron::Bio::LiveSeq::Prim_Transcript::Bio::LiveSeq::Repeat_Region::Bio::LiveSeq::Repeat_Unit::Bio::LiveSeq::AARange::Bio::Tools"},{"line":79,"kind":12,"name":"carp"},{"range":{"start":{"character":0,"line":147},"end":{"character":9999,"line":189}},"name":"gene2liveseq","detail":"($self,%args)","signature":{"parameters":[{"label":"$self"},{"label":"%args"}],"documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended\n\n\nsub entry2liveseq {\n  my ($self, %args) = @_;\n  my ($getswissprotinfo)=($args{-getswissprotinfo});\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my @translationobjects=$self->hash2liveseq($hashref,$getswissprotinfo);\n  my $test_transl=0;\n  if ($test_transl) { $self->test_transl($hashref,\\@translationobjects);}\n  return @translationobjects;\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n                                             -taxon => 9606,\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage database to choose codons according to\n            relative frequencies.\n            If a taxon ID is not specified, the default is to use the human\n            one (taxonomy ID 9606).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n            integer (optional) with a taxonomy ID\n            string specifying a gene name\n\n\n=head2 gene2liveseq\n\n  Title   : gene2liveseq\n  Usage   : $gene=$loader->gene2liveseq(-gene_name => \"gene name\");\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -flanking => 64);\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -getswissprotinfo => 0);\n          : $gene=$loader->gene2liveseq(-position => 4);\n\n  Function: creates LiveSeq objects from an entry previously loaded\n            It is a \"light weight\" creation because it creates\n            a LiveSequence just for the interesting region in an entry\n            (instead than for the total entry, like in entry2liveseq) and for\n            the flanking regions up to 500 nucleotides (default) or up to\n            the specified amount of nucleotides (given as argument) around the\n            Gene.\n  Returns : reference to a Gene object containing possibly alternative\n            Transcripts.\n  Errorcode 0\n  Args    : string containing the gene name as in the EMBL feature qualifier\n            integer (optional) \"flanking\": amount of flanking bases to be kept\n            boolean (optional) \"getswissprotinfo\": if set to \"0\" it will avoid\n             trying to fetch information from a crossreference to a SwissProt\n             entry, avoding the process of creation of AARange objects\n             It is \"1\" (on) by default\n\n            Alternative to a gene_name, a position can be given: an\n            integer (1-) containing the position of the desired CDS in the\n            loaded entry","label":"gene2liveseq($self,%args)"},"containerName":"main::","definition":"sub","line":147,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"gene2liveseq","line":148,"kind":13},{"kind":13,"line":148,"containerName":"gene2liveseq","name":"%args"},{"localvar":"my","definition":"my","name":"$gene_name","containerName":"gene2liveseq","line":149,"kind":13},{"kind":13,"line":149,"name":"$flanking","containerName":"gene2liveseq"},{"name":"$getswissprotinfo","containerName":"gene2liveseq","kind":13,"line":149},{"name":"$cds_position","containerName":"gene2liveseq","line":149,"kind":13},{"name":"$args","containerName":"gene2liveseq","kind":13,"line":149},{"name":"$args","containerName":"gene2liveseq","line":149,"kind":13},{"containerName":"gene2liveseq","name":"$args","kind":13,"line":149},{"containerName":"gene2liveseq","name":"$args","line":149,"kind":13},{"definition":"my","name":"$input","containerName":"gene2liveseq","localvar":"my","kind":13,"line":150},{"line":151,"kind":13,"containerName":"gene2liveseq","name":"$gene_name"},{"kind":13,"line":151,"name":"$cds_position","containerName":"gene2liveseq"},{"line":155,"kind":13,"containerName":"gene2liveseq","name":"$gene_name"},{"name":"$cds_position","containerName":"gene2liveseq","kind":13,"line":155},{"kind":13,"line":158,"containerName":"gene2liveseq","name":"$gene_name"},{"line":159,"kind":13,"containerName":"gene2liveseq","name":"$input"},{"kind":13,"line":159,"name":"$gene_name","containerName":"gene2liveseq"},{"containerName":"gene2liveseq","name":"$input","line":161,"kind":13},{"containerName":"gene2liveseq","name":"$cds_position","kind":13,"line":161},{"containerName":"gene2liveseq","name":"$getswissprotinfo","line":164,"kind":13},{"containerName":"gene2liveseq","name":"$getswissprotinfo","kind":13,"line":165},{"line":165,"kind":13,"name":"$getswissprotinfo","containerName":"gene2liveseq"},{"kind":13,"line":167,"name":"$getswissprotinfo","containerName":"gene2liveseq"},{"containerName":"gene2liveseq","name":"$getswissprotinfo","line":170,"kind":13},{"containerName":"gene2liveseq","name":"$flanking","kind":13,"line":173},{"kind":13,"line":174,"name":"$flanking","containerName":"gene2liveseq"},{"kind":13,"line":179,"containerName":"gene2liveseq","name":"$flanking"},{"line":181,"kind":13,"localvar":"my","containerName":"gene2liveseq","definition":"my","name":"$hashref"},{"kind":13,"line":181,"containerName":"gene2liveseq","name":"$self"},{"line":182,"kind":13,"containerName":"gene2liveseq","name":"$hashref"},{"kind":13,"line":183,"definition":"my","name":"$gene","containerName":"gene2liveseq","localvar":"my"},{"kind":13,"line":183,"name":"$self","containerName":"gene2liveseq"},{"containerName":"gene2liveseq","name":"hash2gene","kind":12,"line":183},{"kind":13,"line":183,"name":"$hashref","containerName":"gene2liveseq"},{"containerName":"gene2liveseq","name":"$input","kind":13,"line":183},{"kind":13,"line":183,"name":"$flanking","containerName":"gene2liveseq"},{"line":183,"kind":13,"containerName":"gene2liveseq","name":"$getswissprotinfo"},{"kind":13,"line":184,"name":"$gene","containerName":"gene2liveseq"},{"line":188,"kind":13,"name":"$gene","containerName":"gene2liveseq"}],"kind":12},{"line":152,"kind":12,"name":"carp"},{"line":156,"kind":12,"name":"carp"},{"kind":12,"line":166,"name":"carp"},{"name":"carp","line":175,"kind":12},{"line":185,"kind":12,"name":"carp"},{"range":{"start":{"line":193,"character":0},"end":{"character":9999,"line":195}},"name":"test_transl","detail":"($self,$entry)","signature":{"label":"test_transl($self,$entry)","documentation":" TODO: update so that it will work even if CDS is not only accepted FEATURE!!\n this method is for now deprecated and not supported","parameters":[{"label":"$self"},{"label":"$entry"}]},"containerName":"main::","definition":"sub","line":193,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"test_transl","line":194,"kind":13},{"name":"$entry","containerName":"test_transl","line":194,"kind":13},{"localvar":"my","name":"@features","definition":"my","containerName":"test_transl","line":195,"kind":13},{"line":195,"kind":13,"containerName":"test_transl","name":"$entry"}],"kind":12},{"name":"@translationobjects","definition":"my","containerName":null,"localvar":"my","kind":13,"line":196},{"line":197,"kind":13,"localvar":"my","name":"$i","definition":"my","containerName":null},{"kind":13,"line":197,"containerName":null,"name":"$translation"},{"name":"$obj_transl","definition":"my","containerName":null,"localvar":"my","kind":13,"line":198},{"name":"$hash_transl","containerName":null,"line":198,"kind":13},{"line":199,"kind":13,"localvar":"my","definition":"my","name":"@cds","containerName":null},{"line":199,"kind":13,"name":"%entry","containerName":null},{"line":200,"kind":13,"name":"$translation","containerName":null},{"name":"@translationobjects","containerName":null,"line":200,"kind":13},{"kind":13,"line":201,"containerName":null,"name":"$obj_transl"},{"name":"$translation","containerName":null,"kind":13,"line":201},{"line":201,"kind":12,"name":"seq","containerName":"main::"},{"kind":13,"line":202,"containerName":null,"name":"$hash_transl"},{"containerName":null,"name":"@cds","kind":13,"line":202},{"kind":13,"line":202,"name":"%i","containerName":null},{"kind":13,"line":204,"containerName":null,"name":"$obj_transl"},{"name":"%hash_transl","containerName":null,"kind":13,"line":204},{"kind":12,"line":205,"name":"cluck"},{"kind":12,"line":206,"name":"carp"},{"name":"$hash_transl","containerName":null,"kind":13,"line":206},{"line":207,"kind":12,"name":"carp"},{"line":207,"kind":13,"containerName":null,"name":"$obj_transl"},{"line":210,"kind":13,"containerName":null,"name":"$i"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$getswissprotinfo"}],"documentation":" argument: hashref containing the EMBL entry datas,\n           getswissprotinfo boolean flag\n creates the liveseq objects\n returns: an array of Translation object references","label":"hash2liveseq($self,$entry,$getswissprotinfo)"},"detail":"($self,$entry,$getswissprotinfo)","kind":12,"children":[{"localvar":"my","containerName":"hash2liveseq","name":"$self","definition":"my","line":219,"kind":13},{"line":219,"kind":13,"containerName":"hash2liveseq","name":"$entry"},{"kind":13,"line":219,"name":"$getswissprotinfo","containerName":"hash2liveseq"},{"kind":13,"line":220,"name":"$i","definition":"my","containerName":"hash2liveseq","localvar":"my"},{"line":221,"kind":13,"localvar":"my","definition":"my","name":"@transcripts","containerName":"hash2liveseq"},{"line":222,"kind":13,"localvar":"my","name":"$dna","definition":"my","containerName":"hash2liveseq"},{"line":222,"kind":12,"containerName":"hash2liveseq","name":"new"},{"containerName":"hash2liveseq","name":"$entry","line":222,"kind":13},{"containerName":"hash2liveseq","name":"$dna","kind":13,"line":223},{"kind":12,"line":223,"containerName":"hash2liveseq","name":"alphabet"},{"name":"$entry","containerName":"hash2liveseq","line":223,"kind":13},{"line":224,"kind":13,"name":"$dna","containerName":"hash2liveseq"},{"line":224,"kind":12,"containerName":"hash2liveseq","name":"display_id"},{"name":"$entry","containerName":"hash2liveseq","kind":13,"line":224},{"kind":13,"line":225,"name":"$dna","containerName":"hash2liveseq"},{"line":225,"kind":12,"name":"accession_number","containerName":"hash2liveseq"},{"name":"$entry","containerName":"hash2liveseq","kind":13,"line":225},{"kind":13,"line":226,"containerName":"hash2liveseq","name":"$dna"},{"containerName":"hash2liveseq","name":"desc","kind":12,"line":226},{"line":226,"kind":13,"containerName":"hash2liveseq","name":"$entry"},{"kind":13,"line":227,"name":"@cds","definition":"my","containerName":"hash2liveseq","localvar":"my"},{"kind":13,"line":227,"name":"$entry","containerName":"hash2liveseq"}],"line":218,"name":"hash2liveseq","range":{"end":{"character":9999,"line":227},"start":{"line":218,"character":0}}},{"containerName":"LiveSeq::DNA","name":"Bio","kind":12,"line":222},{"localvar":"my","containerName":null,"definition":"my","name":"$swissacc","line":228,"kind":13},{"kind":13,"line":228,"containerName":null,"name":"$swisshash"},{"line":228,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@swisshashes"},{"containerName":null,"name":"$i","kind":13,"line":229},{"name":"cds","line":229,"kind":12},{"name":"@transcripts","containerName":null,"kind":13,"line":233},{"kind":13,"line":233,"name":"@cds","containerName":null},{"containerName":null,"name":"%i","line":233,"kind":13},{"kind":13,"line":234,"containerName":null,"name":"%getswissprotinfo"},{"kind":13,"line":235,"containerName":null,"name":"$swissacc"},{"name":"@cds","containerName":null,"line":235,"kind":13},{"containerName":null,"name":"%i","kind":13,"line":235},{"name":"$swisshash","containerName":null,"line":236,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":236},{"line":236,"kind":12,"containerName":"main::","name":"get_swisshash"},{"line":236,"kind":13,"name":"$swissacc","containerName":null},{"kind":13,"line":238,"name":"@swisshashes","containerName":null},{"line":238,"kind":13,"name":"$swisshash","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"@translations","line":241,"kind":13},{"kind":13,"line":241,"name":"$self","containerName":null},{"kind":12,"line":241,"containerName":"main::","name":"transexonscreation"},{"kind":13,"line":241,"containerName":null,"name":"$dna"},{"kind":13,"line":241,"containerName":null,"name":"@transcripts"},{"kind":13,"line":242,"name":"$translation","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"$j","definition":"my","localvar":"my","kind":13,"line":242},{"name":"$translation","containerName":null,"line":243,"kind":13},{"containerName":null,"name":"@translations","kind":13,"line":243},{"name":"@swisshashes","containerName":null,"kind":13,"line":244},{"kind":13,"line":244,"name":"%j","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":245},{"containerName":"main::","name":"swisshash2liveseq","line":245,"kind":12},{"line":245,"kind":13,"containerName":null,"name":"@swisshashes"},{"kind":13,"line":245,"containerName":null,"name":"$j"},{"kind":13,"line":245,"containerName":null,"name":"$translation"},{"containerName":null,"name":"$j","kind":13,"line":247},{"name":"@translations","containerName":null,"kind":13,"line":249},{"signature":{"documentation":" only features pertaining to a specified gene are created\n only the sequence of the gene and appropriate context flanking regions\n are created as chain\n arguments: hashref, gene_name (OR: cds_position), length_of_flanking_sequences, getswissprotinfo boolean flag\n returns: reference to Gene object\n\n Note: if entry contains just one CDS, all the features get added\n       this is useful because often the features in these entries do not\n       carry the /gene qualifier\n\n errorcode: 0","parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$input"},{"label":"$flanking"},{"label":"$getswissprotinfo"}],"label":"hash2gene($self,$entry,$input,$flanking,$getswissprotinfo)"},"detail":"($self,$entry,$input,$flanking,$getswissprotinfo)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":264,"name":"$self","definition":"my","containerName":"hash2gene","localvar":"my"},{"name":"$entry","containerName":"hash2gene","line":264,"kind":13},{"kind":13,"line":264,"containerName":"hash2gene","name":"$input"},{"name":"$flanking","containerName":"hash2gene","kind":13,"line":264},{"name":"$getswissprotinfo","containerName":"hash2gene","line":264,"kind":13},{"kind":13,"line":265,"name":"$entryfeature","definition":"my","containerName":"hash2gene","localvar":"my"},{"kind":13,"line":266,"definition":"my","name":"$genefeatureshash","containerName":"hash2gene","localvar":"my"},{"localvar":"my","containerName":"hash2gene","name":"@cds","definition":"my","line":268,"kind":13},{"line":268,"kind":13,"name":"$entry","containerName":"hash2gene"}],"line":263,"kind":12,"range":{"end":{"character":9999,"line":268},"start":{"line":263,"character":0}},"name":"hash2gene"},{"name":"%input","containerName":null,"kind":13,"line":271},{"line":272,"kind":13,"localvar":"my","definition":"my","name":"$cds_position","containerName":null},{"kind":13,"line":272,"name":"$input","containerName":null},{"containerName":null,"name":"$cds_position","kind":13,"line":273},{"containerName":null,"name":"$cds_position","kind":13,"line":273},{"containerName":null,"name":"@cds","line":273,"kind":13},{"line":274,"kind":13,"containerName":null,"name":"$genefeatureshash"},{"name":"$self","containerName":null,"kind":13,"line":274},{"line":274,"kind":12,"name":"_findgenefeatures","containerName":"main::"},{"line":274,"kind":13,"containerName":null,"name":"$entry"},{"name":"$cds_position","containerName":null,"kind":13,"line":274},{"line":274,"kind":13,"containerName":null,"name":"%getswissprotinfo"},{"kind":13,"line":277,"containerName":null,"name":"$genefeatureshash"},{"kind":13,"line":277,"name":"$self","containerName":null},{"name":"_findgenefeatures","containerName":"main::","kind":12,"line":277},{"containerName":null,"name":"$entry","line":277,"kind":13},{"kind":13,"line":277,"containerName":null,"name":"$input"},{"line":277,"kind":13,"name":"$getswissprotinfo","containerName":null},{"containerName":null,"name":"$genefeatureshash","line":280,"kind":13},{"name":"%genefeatureshash","containerName":null,"kind":13,"line":280},{"kind":13,"line":281,"containerName":null,"definition":"my","name":"@genes","localvar":"my"},{"line":281,"kind":13,"containerName":null,"name":"$self"},{"containerName":"main::","name":"genes","line":281,"kind":12},{"kind":13,"line":281,"containerName":null,"name":"$entry"},{"localvar":"my","name":"$cds_number","definition":"my","containerName":null,"line":282,"kind":13},{"containerName":null,"name":"@cds","line":282,"kind":13},{"containerName":null,"definition":"my","name":"$min","localvar":"my","kind":13,"line":290},{"line":290,"kind":13,"name":"$max","containerName":null},{"line":290,"kind":13,"name":"$self","containerName":null},{"kind":12,"line":290,"containerName":"main::","name":"rangeofarray"},{"name":"%genefeatureshash","containerName":null,"kind":13,"line":290},{"line":291,"kind":13,"localvar":"my","name":"$seqlength","definition":"my","containerName":null},{"name":"%entry","containerName":null,"line":291,"kind":13},{"containerName":null,"definition":"my","name":"$mindna","localvar":"my","kind":13,"line":292},{"kind":13,"line":292,"containerName":null,"name":"$maxdna"},{"kind":13,"line":293,"name":"$min","containerName":null},{"name":"%flanking","containerName":null,"line":293,"kind":13},{"containerName":null,"name":"%mindna","kind":13,"line":294},{"name":"$mindna","containerName":null,"kind":13,"line":296},{"line":296,"kind":13,"containerName":null,"name":"$min"},{"name":"$flanking","containerName":null,"line":296,"kind":13},{"line":298,"kind":13,"name":"$max","containerName":null},{"containerName":null,"name":"$flanking","kind":13,"line":298},{"line":298,"kind":13,"containerName":null,"name":"%seqlength"},{"containerName":null,"name":"$maxdna","kind":13,"line":299},{"line":299,"kind":13,"containerName":null,"name":"%seqlength"},{"line":301,"kind":13,"containerName":null,"name":"$maxdna"},{"line":301,"kind":13,"name":"$max","containerName":null},{"containerName":null,"name":"$flanking","line":301,"kind":13},{"line":303,"kind":13,"localvar":"my","containerName":null,"name":"$subseq","definition":"my"},{"containerName":null,"name":"%entry","line":303,"kind":13},{"containerName":null,"name":"$mindna","kind":13,"line":303},{"name":"$maxdna","containerName":null,"kind":13,"line":303},{"containerName":null,"name":"$mindna","kind":13,"line":303},{"containerName":null,"name":"$dna","definition":"my","localvar":"my","kind":13,"line":308},{"kind":12,"line":308,"containerName":"LiveSeq::DNA","name":"Bio"},{"line":308,"kind":12,"name":"new","containerName":"main::"},{"containerName":null,"name":"$subseq","line":308,"kind":13},{"line":308,"kind":13,"name":"$mindna","containerName":null},{"line":309,"kind":13,"name":"$dna","containerName":null},{"containerName":"main::","name":"alphabet","line":309,"kind":12},{"kind":13,"line":309,"name":"%entry","containerName":null},{"line":310,"kind":13,"name":"$dna","containerName":null},{"name":"source","containerName":"main::","line":310,"kind":12},{"line":310,"kind":13,"containerName":null,"name":"%entry"},{"containerName":null,"name":"$dna","kind":13,"line":311},{"name":"display_id","containerName":"main::","line":311,"kind":12},{"line":311,"kind":13,"containerName":null,"name":"%entry"},{"containerName":null,"name":"$dna","kind":13,"line":312},{"kind":12,"line":312,"name":"accession_number","containerName":"main::"},{"name":"%entry","containerName":null,"kind":13,"line":312},{"name":"$dna","containerName":null,"kind":13,"line":313},{"containerName":"main::","name":"desc","kind":12,"line":313},{"name":"%entry","containerName":null,"line":313,"kind":13},{"line":315,"kind":13,"localvar":"my","containerName":null,"name":"@transcripts","definition":"my"},{"line":315,"kind":13,"containerName":null,"name":"%genefeatureshash"},{"containerName":null,"name":"@transcripts","kind":13,"line":317},{"line":318,"kind":12,"name":"cluck"},{"localvar":"my","name":"@translationobjs","definition":"my","containerName":null,"line":321,"kind":13},{"line":321,"kind":13,"name":"$self","containerName":null},{"line":321,"kind":12,"containerName":"main::","name":"transexonscreation"},{"containerName":null,"name":"$dna","kind":13,"line":321},{"line":321,"kind":13,"containerName":null,"name":"@transcripts"},{"line":322,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@transcriptobjs"},{"containerName":null,"definition":"my","name":"$translation","localvar":"my","kind":13,"line":325},{"kind":13,"line":326,"definition":"my","name":"$j","containerName":null,"localvar":"my"},{"localvar":"my","containerName":null,"name":"@ttables","definition":"my","line":327,"kind":13},{"name":"%genefeatureshash","containerName":null,"line":327,"kind":13},{"kind":13,"line":328,"name":"@swisshashes","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":328},{"kind":13,"line":329,"name":"$translation","containerName":null},{"containerName":null,"name":"@translationobjs","line":329,"kind":13},{"name":"@transcriptobjs","containerName":null,"line":330,"kind":13},{"kind":13,"line":330,"name":"$translation","containerName":null},{"name":"get_Transcript","containerName":"main::","kind":12,"line":330},{"line":331,"kind":13,"name":"@ttables","containerName":null},{"kind":13,"line":331,"containerName":null,"name":"%j"},{"kind":13,"line":332,"name":"$translation","containerName":null},{"line":332,"kind":12,"name":"get_Transcript","containerName":"main::"},{"name":"translation_table","containerName":"main::","kind":12,"line":332},{"line":332,"kind":13,"containerName":null,"name":"@ttables"},{"containerName":null,"name":"$j","kind":13,"line":332},{"kind":13,"line":336,"name":"@swisshashes","containerName":null},{"name":"%j","containerName":null,"line":336,"kind":13},{"name":"$self","containerName":null,"kind":13,"line":337},{"name":"swisshash2liveseq","containerName":"main::","kind":12,"line":337},{"kind":13,"line":337,"containerName":null,"name":"@swisshashes"},{"line":337,"kind":13,"name":"$j","containerName":null},{"line":337,"kind":13,"containerName":null,"name":"$translation"},{"kind":13,"line":339,"containerName":null,"name":"$j"},{"localvar":"my","containerName":null,"name":"%gene","definition":"my","line":342,"kind":13},{"containerName":null,"name":"%gene","line":343,"kind":13},{"kind":12,"line":343,"name":"DNA"},{"kind":13,"line":343,"name":"$dna","containerName":null},{"line":344,"kind":13,"containerName":null,"name":"%gene"},{"line":344,"kind":12,"name":"Transcripts"},{"containerName":null,"name":"@transcriptobjs","kind":13,"line":344},{"kind":13,"line":345,"name":"%gene","containerName":null},{"line":345,"kind":12,"name":"Translations"},{"line":345,"kind":13,"name":"@translationobjs","containerName":null},{"localvar":"my","definition":"my","name":"@exonobjs","containerName":null,"line":347,"kind":13},{"containerName":null,"definition":"my","name":"@intronobjs","localvar":"my","kind":13,"line":347},{"localvar":"my","definition":"my","name":"@repeatunitobjs","containerName":null,"line":348,"kind":13},{"localvar":"my","containerName":null,"name":"@repeatregionobjs","definition":"my","line":348,"kind":13},{"kind":13,"line":349,"definition":"my","name":"@primtranscriptobjs","containerName":null,"localvar":"my"},{"kind":13,"line":351,"definition":"my","name":"$object","containerName":null,"localvar":"my"},{"containerName":null,"name":"$range","kind":13,"line":351},{"kind":13,"line":351,"containerName":null,"name":"$start"},{"kind":13,"line":351,"name":"$end","containerName":null},{"line":351,"kind":13,"name":"$strand","containerName":null},{"localvar":"my","name":"@exons","definition":"my","containerName":null,"line":353,"kind":13},{"kind":13,"line":353,"name":"%genefeatureshash","containerName":null},{"kind":13,"line":354,"containerName":null,"name":"@exondescs","definition":"my","localvar":"my"},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":354},{"name":"@exons","containerName":null,"kind":13,"line":355},{"name":"$exoncount","definition":"my","containerName":null,"localvar":"my","kind":13,"line":356},{"name":"$range","containerName":null,"kind":13,"line":357},{"name":"@exons","containerName":null,"kind":13,"line":357},{"containerName":null,"name":"$start","line":358,"kind":13},{"kind":13,"line":358,"containerName":null,"name":"$end"},{"kind":13,"line":358,"containerName":null,"name":"$strand"},{"name":"$range","containerName":null,"kind":13,"line":358},{"containerName":null,"name":"$object","line":359,"kind":13},{"line":359,"kind":12,"name":"Bio","containerName":"LiveSeq::Exon"},{"name":"new","containerName":"main::","kind":12,"line":359},{"name":"$dna","containerName":null,"line":359,"kind":13},{"name":"$start","containerName":null,"kind":13,"line":359},{"name":"$end","containerName":null,"line":359,"kind":13},{"kind":13,"line":359,"containerName":null,"name":"$strand"},{"kind":13,"line":360,"name":"%object","containerName":null},{"containerName":null,"name":"$object","kind":13,"line":361},{"line":361,"kind":12,"containerName":"main::","name":"desc"},{"line":361,"kind":13,"name":"@exondescs","containerName":null},{"line":361,"kind":13,"containerName":null,"name":"$exoncount"},{"kind":13,"line":361,"containerName":null,"name":"@exondescs"},{"line":361,"kind":13,"name":"$exoncount","containerName":null},{"containerName":null,"name":"$exoncount","line":362,"kind":13},{"line":363,"kind":13,"containerName":null,"name":"@exonobjs"},{"kind":13,"line":363,"name":"%object","containerName":null},{"kind":13,"line":365,"name":"$exoncount","containerName":null},{"containerName":null,"name":"%gene","line":368,"kind":13},{"name":"Exons","kind":12,"line":368},{"name":"@exonobjs","containerName":null,"line":368,"kind":13},{"localvar":"my","containerName":null,"name":"@introns","definition":"my","line":370,"kind":13},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":370},{"kind":13,"line":371,"name":"@introndescs","definition":"my","containerName":null,"localvar":"my"},{"name":"%genefeatureshash","containerName":null,"line":371,"kind":13},{"line":372,"kind":13,"containerName":null,"name":"@introns"},{"localvar":"my","definition":"my","name":"$introncount","containerName":null,"line":373,"kind":13},{"kind":13,"line":374,"name":"$range","containerName":null},{"kind":13,"line":374,"containerName":null,"name":"@introns"},{"name":"$start","containerName":null,"line":375,"kind":13},{"name":"$end","containerName":null,"line":375,"kind":13},{"line":375,"kind":13,"containerName":null,"name":"$strand"},{"line":375,"kind":13,"containerName":null,"name":"$range"},{"kind":13,"line":376,"name":"$object","containerName":null},{"name":"Bio","containerName":"LiveSeq::Intron","line":376,"kind":12},{"name":"new","containerName":"main::","line":376,"kind":12},{"name":"$dna","containerName":null,"line":376,"kind":13},{"kind":13,"line":376,"containerName":null,"name":"$start"},{"containerName":null,"name":"$end","line":376,"kind":13},{"kind":13,"line":376,"containerName":null,"name":"$strand"},{"containerName":null,"name":"%object","kind":13,"line":377},{"containerName":null,"name":"$object","kind":13,"line":378},{"containerName":"main::","name":"desc","line":378,"kind":12},{"line":378,"kind":13,"name":"@introndescs","containerName":null},{"line":378,"kind":13,"containerName":null,"name":"$introncount"},{"name":"$introncount","containerName":null,"kind":13,"line":379},{"containerName":null,"name":"@intronobjs","line":380,"kind":13},{"containerName":null,"name":"%object","line":380,"kind":13},{"line":382,"kind":13,"name":"$introncount","containerName":null},{"kind":13,"line":385,"containerName":null,"name":"%gene"},{"line":385,"kind":12,"name":"Introns"},{"containerName":null,"name":"@intronobjs","line":385,"kind":13},{"containerName":null,"definition":"my","name":"@prim_transcripts","localvar":"my","kind":13,"line":387},{"kind":13,"line":387,"containerName":null,"name":"%genefeatureshash"},{"line":388,"kind":13,"containerName":null,"name":"@prim_transcripts"},{"kind":13,"line":389,"containerName":null,"name":"$range"},{"line":389,"kind":13,"containerName":null,"name":"@prim_transcripts"},{"containerName":null,"name":"$start","line":390,"kind":13},{"containerName":null,"name":"$end","kind":13,"line":390},{"name":"$strand","containerName":null,"kind":13,"line":390},{"name":"$range","containerName":null,"kind":13,"line":390},{"line":391,"kind":13,"containerName":null,"name":"$object"},{"line":391,"kind":12,"name":"Bio","containerName":"LiveSeq::Prim_Transcript"},{"containerName":"main::","name":"new","line":391,"kind":12},{"kind":13,"line":391,"name":"$dna","containerName":null},{"name":"$start","containerName":null,"kind":13,"line":391},{"kind":13,"line":391,"name":"$end","containerName":null},{"kind":13,"line":391,"name":"$strand","containerName":null},{"line":392,"kind":13,"containerName":null,"name":"%object"},{"containerName":null,"name":"@primtranscriptobjs","kind":13,"line":392},{"name":"$object","containerName":null,"line":392,"kind":13},{"line":394,"kind":13,"name":"%gene","containerName":null},{"line":394,"kind":12,"name":"Prim_Transcripts"},{"line":394,"kind":13,"name":"@primtranscriptobjs","containerName":null},{"kind":13,"line":396,"name":"@repeat_regions","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%genefeatureshash","line":396,"kind":13},{"localvar":"my","definition":"my","name":"@repeat_regions_family","containerName":null,"line":397,"kind":13},{"kind":13,"line":397,"name":"%genefeatureshash","containerName":null},{"containerName":null,"name":"@repeat_regions","kind":13,"line":398},{"localvar":"my","name":"$k","definition":"my","containerName":null,"line":399,"kind":13},{"name":"$range","containerName":null,"line":400,"kind":13},{"containerName":null,"name":"@repeat_regions","line":400,"kind":13},{"line":401,"kind":13,"name":"$start","containerName":null},{"kind":13,"line":401,"containerName":null,"name":"$end"},{"kind":13,"line":401,"name":"$strand","containerName":null},{"name":"$range","containerName":null,"line":401,"kind":13},{"containerName":null,"name":"$object","kind":13,"line":402},{"line":402,"kind":12,"name":"Bio","containerName":"LiveSeq::Repeat_Region"},{"name":"new","containerName":"main::","line":402,"kind":12},{"kind":13,"line":402,"containerName":null,"name":"$dna"},{"containerName":null,"name":"$start","line":402,"kind":13},{"line":402,"kind":13,"name":"$end","containerName":null},{"name":"$strand","containerName":null,"kind":13,"line":402},{"line":403,"kind":13,"name":"%object","containerName":null},{"name":"$object","containerName":null,"kind":13,"line":404},{"name":"desc","containerName":"main::","kind":12,"line":404},{"name":"@repeat_regions_family","containerName":null,"line":404,"kind":13},{"name":"$k","containerName":null,"kind":13,"line":404},{"kind":13,"line":405,"name":"$k","containerName":null},{"kind":13,"line":406,"name":"@repeatregionobjs","containerName":null},{"containerName":null,"name":"%object","kind":13,"line":406},{"name":"$k","containerName":null,"line":408,"kind":13},{"name":"%gene","containerName":null,"kind":13,"line":411},{"name":"Repeat_Regions","line":411,"kind":12},{"line":411,"kind":13,"name":"@repeatregionobjs","containerName":null},{"line":413,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@repeat_units"},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":413},{"line":414,"kind":13,"localvar":"my","definition":"my","name":"@repeat_units_family","containerName":null},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":414},{"line":415,"kind":13,"name":"@repeat_units","containerName":null},{"line":416,"kind":13,"localvar":"my","name":"$k","definition":"my","containerName":null},{"kind":13,"line":417,"containerName":null,"name":"$range"},{"kind":13,"line":417,"name":"@repeat_units","containerName":null},{"name":"$start","containerName":null,"kind":13,"line":418},{"containerName":null,"name":"$end","line":418,"kind":13},{"name":"$strand","containerName":null,"line":418,"kind":13},{"containerName":null,"name":"$range","kind":13,"line":418},{"line":419,"kind":13,"name":"$object","containerName":null},{"line":419,"kind":12,"name":"Bio","containerName":"LiveSeq::Repeat_Unit"},{"line":419,"kind":12,"name":"new","containerName":"main::"},{"name":"$dna","containerName":null,"kind":13,"line":419},{"containerName":null,"name":"$start","line":419,"kind":13},{"name":"$end","containerName":null,"line":419,"kind":13},{"line":419,"kind":13,"containerName":null,"name":"$strand"},{"kind":13,"line":420,"containerName":null,"name":"%object"},{"line":421,"kind":13,"name":"$object","containerName":null},{"kind":12,"line":421,"containerName":"main::","name":"desc"},{"containerName":null,"name":"@repeat_units_family","kind":13,"line":421},{"kind":13,"line":421,"containerName":null,"name":"$k"},{"name":"$k","containerName":null,"kind":13,"line":422},{"kind":13,"line":423,"name":"@repeatunitobjs","containerName":null},{"containerName":null,"name":"%object","kind":13,"line":423},{"containerName":null,"name":"$k","kind":13,"line":425},{"name":"%gene","containerName":null,"line":428,"kind":13},{"name":"Repeat_Units","kind":12,"line":428},{"line":428,"kind":13,"containerName":null,"name":"@repeatunitobjs"},{"line":432,"kind":13,"localvar":"my","definition":"my","name":"$gene_name","containerName":null},{"containerName":null,"name":"%genefeatureshash","line":432,"kind":13},{"containerName":"LiveSeq::Gene","name":"Bio","kind":12,"line":433},{"kind":12,"line":433,"containerName":"main::","name":"new"},{"containerName":null,"name":"$gene_name","line":433,"kind":13},{"name":"%gene","containerName":null,"kind":13,"line":433},{"containerName":null,"name":"$min","line":434,"kind":13},{"kind":13,"line":434,"containerName":null,"name":"$max"},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"rangeofarray","line":441,"kind":13},{"kind":13,"line":442,"containerName":"rangeofarray","name":"@array","definition":"my","localvar":"my"},{"kind":13,"line":444,"name":"$max","definition":"my","containerName":"rangeofarray","localvar":"my"},{"containerName":"rangeofarray","name":"$min","kind":13,"line":444},{"containerName":"rangeofarray","name":"$element","line":444,"kind":13},{"containerName":"rangeofarray","name":"$min","kind":13,"line":445},{"name":"$max","containerName":"rangeofarray","line":445,"kind":13},{"kind":13,"line":445,"containerName":"rangeofarray","name":"@array"},{"name":"$element","containerName":"rangeofarray","line":446,"kind":13},{"name":"@array","containerName":"rangeofarray","kind":13,"line":446},{"line":447,"kind":13,"containerName":"rangeofarray","name":"$element"},{"name":"$element","containerName":"rangeofarray","kind":13,"line":447},{"containerName":"rangeofarray","name":"$element","kind":13,"line":448},{"line":448,"kind":13,"containerName":"rangeofarray","name":"$min"},{"containerName":"rangeofarray","name":"$min","kind":13,"line":449},{"containerName":"rangeofarray","name":"$element","kind":13,"line":449},{"kind":13,"line":451,"containerName":"rangeofarray","name":"$element"},{"name":"$max","containerName":"rangeofarray","kind":13,"line":451},{"line":452,"kind":13,"name":"$max","containerName":"rangeofarray"},{"line":452,"kind":13,"containerName":"rangeofarray","name":"$element"},{"name":"$min","containerName":"rangeofarray","line":456,"kind":13},{"name":"$max","containerName":"rangeofarray","line":456,"kind":13}],"line":440,"kind":12,"range":{"end":{"character":9999,"line":457},"start":{"character":0,"line":440}},"definition":"sub","name":"rangeofarray","containerName":"main::"},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"transexonscreation","line":463,"kind":13},{"name":"$dna","definition":"my","containerName":"transexonscreation","localvar":"my","kind":13,"line":464},{"line":465,"kind":13,"localvar":"my","definition":"my","name":"@transcripts","containerName":"transexonscreation"}],"line":462,"definition":"sub","name":"transexonscreation","containerName":"main::","range":{"start":{"line":462,"character":0},"end":{"line":465,"character":9999}}},{"localvar":"my","name":"@transexons","definition":"my","containerName":null,"line":467,"kind":13},{"line":467,"kind":13,"containerName":null,"name":"$start"},{"line":467,"kind":13,"containerName":null,"name":"$end"},{"line":467,"kind":13,"containerName":null,"name":"$strand"},{"kind":13,"line":467,"containerName":null,"name":"$exonref"},{"kind":13,"line":467,"name":"$exonobj","containerName":null},{"containerName":null,"name":"$transcript","kind":13,"line":467},{"line":467,"kind":13,"name":"$transcriptobj","containerName":null},{"name":"$translationobj","definition":"my","containerName":null,"localvar":"my","kind":13,"line":468},{"line":469,"kind":13,"localvar":"my","name":"@translationobjects","definition":"my","containerName":null},{"kind":13,"line":470,"containerName":null,"name":"$transcript"},{"containerName":null,"name":"@transcripts","kind":13,"line":470},{"line":471,"kind":13,"containerName":null,"name":"$exonref"},{"kind":13,"line":471,"containerName":null,"name":"%transcript"},{"line":472,"kind":13,"containerName":null,"name":"$start"},{"line":472,"kind":13,"containerName":null,"name":"$end"},{"line":472,"kind":13,"containerName":null,"name":"$strand"},{"line":472,"kind":13,"name":"$exonref","containerName":null},{"kind":13,"line":474,"containerName":null,"name":"$exonobj"},{"kind":12,"line":474,"name":"Bio","containerName":"LiveSeq::Exon"},{"containerName":"main::","name":"new","kind":12,"line":474},{"containerName":null,"name":"$dna","line":474,"kind":13},{"line":474,"kind":13,"name":"$start","containerName":null},{"name":"$end","containerName":null,"line":474,"kind":13},{"kind":13,"line":474,"name":"$strand","containerName":null},{"containerName":null,"name":"@transexons","line":476,"kind":13},{"name":"$exonobj","containerName":null,"line":476,"kind":13},{"line":478,"kind":13,"name":"$transcriptobj","containerName":null},{"containerName":"LiveSeq::Transcript","name":"Bio","line":478,"kind":12},{"containerName":"main::","name":"new","line":478,"kind":12},{"kind":13,"line":478,"name":"@transexons","containerName":null},{"line":479,"kind":13,"containerName":null,"name":"%transcriptobj"},{"line":480,"kind":13,"name":"$translationobj","containerName":null},{"name":"Bio","containerName":"LiveSeq::Translation","line":480,"kind":12},{"containerName":"main::","name":"new","line":480,"kind":12},{"name":"$transcriptobj","containerName":null,"kind":13,"line":480},{"kind":13,"line":481,"containerName":null,"name":"@transexons"},{"kind":13,"line":483,"containerName":null,"name":"@translationobjects"},{"containerName":null,"name":"$translationobj","line":483,"kind":13},{"containerName":null,"name":"@translationobjects","line":486,"kind":13},{"range":{"start":{"line":507,"character":0},"end":{"character":9999,"line":534}},"name":"printswissprot","children":[{"line":508,"kind":13,"localvar":"my","containerName":"printswissprot","name":"$self","definition":"my"},{"line":508,"kind":13,"name":"$entry","containerName":"printswissprot"},{"name":"$entry","containerName":"printswissprot","line":509,"kind":13},{"name":"$entry","containerName":"printswissprot","line":513,"kind":13},{"line":515,"kind":13,"containerName":"printswissprot","name":"$entry"},{"line":517,"kind":13,"name":"$entry","containerName":"printswissprot"},{"containerName":"printswissprot","name":"$entry","line":519,"kind":13},{"name":"$entry","containerName":"printswissprot","kind":13,"line":521},{"containerName":"printswissprot","name":"$entry","kind":13,"line":523},{"line":525,"kind":13,"containerName":"printswissprot","name":"$entry"},{"containerName":"printswissprot","name":"$entry","kind":13,"line":526},{"line":527,"kind":13,"localvar":"my","containerName":"printswissprot","definition":"my","name":"@features"},{"line":527,"kind":13,"containerName":"printswissprot","name":"$entry"},{"containerName":"printswissprot","definition":"my","name":"$i","localvar":"my","kind":13,"line":528},{"line":529,"kind":13,"name":"$i","containerName":"printswissprot"},{"name":"$features","containerName":"printswissprot","line":530,"kind":13},{"line":530,"kind":13,"name":"$i","containerName":"printswissprot"},{"line":531,"kind":13,"name":"$features","containerName":"printswissprot"},{"kind":13,"line":531,"name":"$i","containerName":"printswissprot"},{"name":"$features","containerName":"printswissprot","line":532,"kind":13},{"kind":13,"line":532,"name":"$i","containerName":"printswissprot"}],"line":507,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$entry"}],"documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended\n\n\nsub entry2liveseq {\n  my ($self, %args) = @_;\n  my ($getswissprotinfo)=($args{-getswissprotinfo});\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my @translationobjects=$self->hash2liveseq($hashref,$getswissprotinfo);\n  my $test_transl=0;\n  if ($test_transl) { $self->test_transl($hashref,\\@translationobjects);}\n  return @translationobjects;\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n                                             -taxon => 9606,\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage database to choose codons according to\n            relative frequencies.\n            If a taxon ID is not specified, the default is to use the human\n            one (taxonomy ID 9606).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n            integer (optional) with a taxonomy ID\n            string specifying a gene name\n\n\n=head2 gene2liveseq\n\n  Title   : gene2liveseq\n  Usage   : $gene=$loader->gene2liveseq(-gene_name => \"gene name\");\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -flanking => 64);\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -getswissprotinfo => 0);\n          : $gene=$loader->gene2liveseq(-position => 4);\n\n  Function: creates LiveSeq objects from an entry previously loaded\n            It is a \"light weight\" creation because it creates\n            a LiveSequence just for the interesting region in an entry\n            (instead than for the total entry, like in entry2liveseq) and for\n            the flanking regions up to 500 nucleotides (default) or up to\n            the specified amount of nucleotides (given as argument) around the\n            Gene.\n  Returns : reference to a Gene object containing possibly alternative\n            Transcripts.\n  Errorcode 0\n  Args    : string containing the gene name as in the EMBL feature qualifier\n            integer (optional) \"flanking\": amount of flanking bases to be kept\n            boolean (optional) \"getswissprotinfo\": if set to \"0\" it will avoid\n             trying to fetch information from a crossreference to a SwissProt\n             entry, avoding the process of creation of AARange objects\n             It is \"1\" (on) by default\n\n            Alternative to a gene_name, a position can be given: an\n            integer (1-) containing the position of the desired CDS in the\n            loaded entry\n\n\nsub gene2liveseq {\n  my ($self, %args) = @_;\n  my ($gene_name,$flanking,$getswissprotinfo,$cds_position)=($args{-gene_name},$args{-flanking},$args{-getswissprotinfo},$args{-position});\n  my $input;\n  unless (($gene_name)||($cds_position)) {\n    carp \"Gene_Name or Position not specified for gene2liveseq loading function\";\n    return (0);\n  }\n  if (($gene_name)&&($cds_position)) {\n    carp \"Gene_Name and Position cannot be given together\";\n    return (0);\n  } elsif ($gene_name) {\n    $input=$gene_name;\n  } else {\n    $input=\"cds-position:\".$cds_position;\n  }\n\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n\n  if (defined($flanking)) {\n    unless ($flanking >= 0) {\n      carp \"No sense in specifying a number < 0 for flanking regions to be created for gene2liveseq loading function\";\n      return (0);\n    }\n  } else {\n    $flanking=500; # the default flanking length\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my $gene=$self->hash2gene($hashref,$input,$flanking,$getswissprotinfo);\n  unless ($gene) { # if $gene == 0 it means problems in hash2gene\n    carp \"gene2liveseq produced error\";\n    return (0);\n  }\n  return $gene;\n}\n\n# TODO: update so that it will work even if CDS is not only accepted FEATURE!!\n# this method is for now deprecated and not supported\nsub test_transl {\n  my ($self,$entry)=@_;\n  my @features=@{$entry->{'Features'}};\n  my @translationobjects=@{$_[1]};\n  my ($i,$translation);\n  my ($obj_transl,$hash_transl);\n  my @cds=@{$entry->{'CDS'}};\n  foreach $translation (@translationobjects) {\n    $obj_transl=$translation->seq;\n    $hash_transl=$cds[$i]->{'qualifiers'}->{'translation'};\n    #before seq was changed in Translation 1.4# chop $obj_transl; # to remove trailing \"*\"\n    unless ($obj_transl eq $hash_transl) {\n      cluck \"Serious error: Translation from the Entry does not match Translation from object's seq for CDS at position $i\";\n      carp \"\\nEntry's transl: \",$hash_transl,\"\\n\";\n      carp \"\\nObject's transl: \",$obj_transl,\"\\n\";\n      exit;\n    }\n    $i++;\n  }\n}\n\n# argument: hashref containing the EMBL entry datas,\n#           getswissprotinfo boolean flag\n# creates the liveseq objects\n# returns: an array of Translation object references\nsub hash2liveseq {\n  my ($self,$entry,$getswissprotinfo)=@_;\n  my $i;\n  my @transcripts;\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $entry->{'Sequence'} );\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n  my @cds=@{$entry->{'CDS'}};\n  my ($swissacc,$swisshash); my @swisshashes;\n  for $i (0..$#cds) {\n    #my @transcript=@{$cds[$i]->{'range'}};\n    #$transcript=\\@transcript;\n    #push (@transcripts,$transcript);\n    push (@transcripts,$cds[$i]->{'range'});\n    if ($getswissprotinfo) {\n      $swissacc=$cds[$i]->{'qualifiers'}->{'db_xref'};\n      $swisshash=$self->get_swisshash($swissacc);\n      #$self->printswissprot($swisshash); # DEBUG\n      push (@swisshashes,$swisshash);\n    }\n  }\n  my @translations=($self->transexonscreation($dna,\\@transcripts));\n  my $translation; my $j=0;\n  foreach $translation (@translations) {\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n  return (@translations);\n}\n\n# only features pertaining to a specified gene are created\n# only the sequence of the gene and appropriate context flanking regions\n# are created as chain\n# arguments: hashref, gene_name (OR: cds_position), length_of_flanking_sequences, getswissprotinfo boolean flag\n# returns: reference to Gene object\n#\n# Note: if entry contains just one CDS, all the features get added\n#       this is useful because often the features in these entries do not\n#       carry the /gene qualifier\n#\n# errorcode: 0\nsub hash2gene {\n  my ($self,$entry,$input,$flanking,$getswissprotinfo)=@_;\n  my $entryfeature;\n  my $genefeatureshash;\n\n  my @cds=@{$entry->{'CDS'}};\n\n  # checking if a position has been given instead than a gene_name\n  if (index($input,\"cds-position:\") == 0 ) {\n    my $cds_position=substr($input,13); # extracting the cds position\n    if (($cds_position >= 1)&&($cds_position <= scalar(@cds))) {\n      $genefeatureshash=$self->_findgenefeatures($entry,undef,$cds_position,$getswissprotinfo);\n    }\n  } else {\n    $genefeatureshash=$self->_findgenefeatures($entry,$input,undef,$getswissprotinfo);\n  }\n\n  unless (($genefeatureshash)&&(scalar(@{$genefeatureshash->{'genefeatures'}}))) { # array empty, no gene features found\n    my @genes=$self->genes($entry);\n    my $cds_number=scalar(@cds);\n    warn \"Warning! Not even one genefeature found for /$input/....\n    The genes present in this entry are:\\n\\t@genes\\n\n    The number of CDS in this entry is:\\n\\t$cds_number\\n\";\n    return(0);\n  }\n\n  # get max and min, check flankings\n  my ($min,$max)=$self->rangeofarray(@{$genefeatureshash->{'labels'}}); # gene \"boundaries\"\n  my $seqlength=$entry->{'SeqLength'};\n  my ($mindna,$maxdna); # some flanking region next to the gene \"boundaries\"\n  if ($min-$flanking < 1) {\n    $mindna=1;\n  } else {\n    $mindna=$min-$flanking;\n  }\n  if ($max+$flanking > $seqlength) {\n    $maxdna=$seqlength;\n  } else {\n    $maxdna=$max+$flanking;\n  }\n  my $subseq=substr($entry->{'Sequence'},$mindna-1,$maxdna-$mindna+1);\n\n  # create LiveSeq objects\n\n  # create DNA\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $subseq, -offset => $mindna);\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->source($entry->{'Organism'});\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n\n  my @transcripts=@{$genefeatureshash->{'transcripts'}};\n  # create Translations, Transcripts, Exons out of the CDS\n  unless (@transcripts) {\n    cluck \"no CDS feature found for /$input/....\";\n    return(0);\n  }\n  my @translationobjs=$self->transexonscreation($dna,\\@transcripts);\n  my @transcriptobjs;\n\n  # get the Transcript obj_refs\n  my $translation;\n  my $j=0;\n  my @ttables=@{$genefeatureshash->{'ttables'}};\n  my @swisshashes=@{$genefeatureshash->{'swisshashes'}};\n  foreach $translation (@translationobjs) {\n    push(@transcriptobjs,$translation->get_Transcript);\n    if ($ttables[$j]) { # if not undef\n      $translation->get_Transcript->translation_table($ttables[$j]);\n    #} else { # DEBUG\n    #  print \"\\n\\t\\tno translation table information....\\n\";\n    }\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n\n  my %gene; # this is the hash to store created object references\n  $gene{DNA}=$dna;\n  $gene{Transcripts}=\\@transcriptobjs;\n  $gene{Translations}=\\@translationobjs;\n\n  my @exonobjs; my @intronobjs;\n  my @repeatunitobjs; my @repeatregionobjs;\n  my @primtranscriptobjs;\n\n  my ($object,$range,$start,$end,$strand);\n\n  my @exons=@{$genefeatureshash->{'exons'}};\n  my @exondescs=@{$genefeatureshash->{'exondescs'}};\n  if (@exons) {\n    my $exoncount = 0;\n    foreach $range (@exons) {\n      ($start,$end,$strand)=@{$range};\n      $object = Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($exondescs[$exoncount]) if defined $exondescs[$exoncount];\n\t$exoncount++;\n\tpush (@exonobjs,$object);\n      } else {\n\t$exoncount++;\n      }\n    }\n    $gene{Exons}=\\@exonobjs;\n  }\n  my @introns=@{$genefeatureshash->{'introns'}};\n  my @introndescs=@{$genefeatureshash->{'introndescs'}};\n  if (@introns) {\n    my $introncount = 0;\n    foreach $range (@introns) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Intron->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($introndescs[$introncount]);\n\t$introncount++;\n\tpush (@intronobjs,$object);\n      } else {\n\t$introncount++;\n      }\n    }\n    $gene{Introns}=\\@intronobjs;\n  }\n  my @prim_transcripts=@{$genefeatureshash->{'prim_transcripts'}};\n  if (@prim_transcripts) {\n    foreach $range (@prim_transcripts) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Prim_Transcript->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) { push (@primtranscriptobjs,$object); }\n    }\n    $gene{Prim_Transcripts}=\\@primtranscriptobjs;\n  }\n  my @repeat_regions=@{$genefeatureshash->{'repeat_regions'}};\n  my @repeat_regions_family=@{$genefeatureshash->{'repeat_regions_family'}};\n  if (@repeat_regions) {\n    my $k=0;\n    foreach $range (@repeat_regions) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Region->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_regions_family[$k]);\n\t$k++;\n\tpush (@repeatregionobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Regions}=\\@repeatregionobjs;\n  }\n  my @repeat_units=@{$genefeatureshash->{'repeat_units'}};\n  my @repeat_units_family=@{$genefeatureshash->{'repeat_units_family'}};\n  if (@repeat_units) {\n    my $k=0;\n    foreach $range (@repeat_units) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Unit->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_units_family[$k]);\n\t$k++;\n\tpush (@repeatunitobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Units}=\\@repeatunitobjs;\n  }\n\n  # create the Gene\n  my $gene_name=$genefeatureshash->{'gene_name'}; # either a name or a cdspos\n  return (Bio::LiveSeq::Gene->new(-name=>$gene_name,-features=>\\%gene,\n                                  -upbound=>$min,-downbound=>$max));\n}\n\n# maybe this function will be moved to general utility package\n# argument: array of numbers\n# returns: (min,max) numbers in the array\nsub rangeofarray {\n  my $self=shift;\n  my @array=@_;\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=array: @array\\n\";\n  my ($max,$min,$element);\n  $min=$max=shift(@array);\n  foreach $element (@array) {\n      $element = 0 unless defined $element;\n    if ($element < $min) {\n      $min=$element;\n    }\n    if ($element > $max) {\n      $max=$element;\n    }\n  }\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=min: $min\\tmax: $max\\n\";\n  return ($min,$max);\n}\n\n\n# argument: reference to DNA object, reference to array of transcripts\n# returns: an array of Translation object references\nsub transexonscreation {\n  my $self=shift;\n  my $dna=$_[0];\n  my @transcripts=@{$_[1]};\n\n  my (@transexons,$start,$end,$strand,$exonref,$exonobj,$transcript,$transcriptobj);\n  my $translationobj;\n  my @translationobjects;\n  foreach $transcript (@transcripts) {\n    foreach $exonref (@{$transcript}) {\n      ($start,$end,$strand)=@{$exonref};\n      #print \"Creating Exon: start $start end $end strand $strand\\n\";\n      $exonobj=Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      #push (@exonobjects,$exonobj);\n      push (@transexons,$exonobj);\n    }\n    $transcriptobj=Bio::LiveSeq::Transcript->new(-exons => \\@transexons );\n    if ($transcriptobj != -1) {\n      $translationobj=Bio::LiveSeq::Translation->new(-transcript=>$transcriptobj);\n      @transexons=(); # cleans it\n      #push (@transcriptobjects,$transcriptobj);\n      push (@translationobjects,$translationobj);\n    }\n  }\n  return (@translationobjects);\n}\n\n#sub printgene {\n# deleted. Some functionality placed in Gene->printfeaturesnum\n\n=head2 printswissprot\n\n  Title   : printswissprot\n  Usage   : $loader->printswissprot($hashref);\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : a hashref containing the SWISSPROT entry datas\n  Note    : the hashref can be obtained with a call to the method\n               $loader->get_swisshash()      (BioPerl via Bio::DB::EMBL.pm)\n\t    that takes as argument a string like \"SWISS-PROT:P10275\"\n\n argument: hashref containing the SWISSPROT entry datas\n prints out that hash, showing the informations loaded","label":"printswissprot($self,$entry)"},"detail":"($self,$entry)","definition":"sub","containerName":"main::"},{"line":529,"kind":12,"name":"features"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$entry"}],"documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended\n\n\nsub entry2liveseq {\n  my ($self, %args) = @_;\n  my ($getswissprotinfo)=($args{-getswissprotinfo});\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my @translationobjects=$self->hash2liveseq($hashref,$getswissprotinfo);\n  my $test_transl=0;\n  if ($test_transl) { $self->test_transl($hashref,\\@translationobjects);}\n  return @translationobjects;\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n                                             -taxon => 9606,\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage database to choose codons according to\n            relative frequencies.\n            If a taxon ID is not specified, the default is to use the human\n            one (taxonomy ID 9606).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n            integer (optional) with a taxonomy ID\n            string specifying a gene name\n\n\n=head2 gene2liveseq\n\n  Title   : gene2liveseq\n  Usage   : $gene=$loader->gene2liveseq(-gene_name => \"gene name\");\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -flanking => 64);\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -getswissprotinfo => 0);\n          : $gene=$loader->gene2liveseq(-position => 4);\n\n  Function: creates LiveSeq objects from an entry previously loaded\n            It is a \"light weight\" creation because it creates\n            a LiveSequence just for the interesting region in an entry\n            (instead than for the total entry, like in entry2liveseq) and for\n            the flanking regions up to 500 nucleotides (default) or up to\n            the specified amount of nucleotides (given as argument) around the\n            Gene.\n  Returns : reference to a Gene object containing possibly alternative\n            Transcripts.\n  Errorcode 0\n  Args    : string containing the gene name as in the EMBL feature qualifier\n            integer (optional) \"flanking\": amount of flanking bases to be kept\n            boolean (optional) \"getswissprotinfo\": if set to \"0\" it will avoid\n             trying to fetch information from a crossreference to a SwissProt\n             entry, avoding the process of creation of AARange objects\n             It is \"1\" (on) by default\n\n            Alternative to a gene_name, a position can be given: an\n            integer (1-) containing the position of the desired CDS in the\n            loaded entry\n\n\nsub gene2liveseq {\n  my ($self, %args) = @_;\n  my ($gene_name,$flanking,$getswissprotinfo,$cds_position)=($args{-gene_name},$args{-flanking},$args{-getswissprotinfo},$args{-position});\n  my $input;\n  unless (($gene_name)||($cds_position)) {\n    carp \"Gene_Name or Position not specified for gene2liveseq loading function\";\n    return (0);\n  }\n  if (($gene_name)&&($cds_position)) {\n    carp \"Gene_Name and Position cannot be given together\";\n    return (0);\n  } elsif ($gene_name) {\n    $input=$gene_name;\n  } else {\n    $input=\"cds-position:\".$cds_position;\n  }\n\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n\n  if (defined($flanking)) {\n    unless ($flanking >= 0) {\n      carp \"No sense in specifying a number < 0 for flanking regions to be created for gene2liveseq loading function\";\n      return (0);\n    }\n  } else {\n    $flanking=500; # the default flanking length\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my $gene=$self->hash2gene($hashref,$input,$flanking,$getswissprotinfo);\n  unless ($gene) { # if $gene == 0 it means problems in hash2gene\n    carp \"gene2liveseq produced error\";\n    return (0);\n  }\n  return $gene;\n}\n\n# TODO: update so that it will work even if CDS is not only accepted FEATURE!!\n# this method is for now deprecated and not supported\nsub test_transl {\n  my ($self,$entry)=@_;\n  my @features=@{$entry->{'Features'}};\n  my @translationobjects=@{$_[1]};\n  my ($i,$translation);\n  my ($obj_transl,$hash_transl);\n  my @cds=@{$entry->{'CDS'}};\n  foreach $translation (@translationobjects) {\n    $obj_transl=$translation->seq;\n    $hash_transl=$cds[$i]->{'qualifiers'}->{'translation'};\n    #before seq was changed in Translation 1.4# chop $obj_transl; # to remove trailing \"*\"\n    unless ($obj_transl eq $hash_transl) {\n      cluck \"Serious error: Translation from the Entry does not match Translation from object's seq for CDS at position $i\";\n      carp \"\\nEntry's transl: \",$hash_transl,\"\\n\";\n      carp \"\\nObject's transl: \",$obj_transl,\"\\n\";\n      exit;\n    }\n    $i++;\n  }\n}\n\n# argument: hashref containing the EMBL entry datas,\n#           getswissprotinfo boolean flag\n# creates the liveseq objects\n# returns: an array of Translation object references\nsub hash2liveseq {\n  my ($self,$entry,$getswissprotinfo)=@_;\n  my $i;\n  my @transcripts;\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $entry->{'Sequence'} );\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n  my @cds=@{$entry->{'CDS'}};\n  my ($swissacc,$swisshash); my @swisshashes;\n  for $i (0..$#cds) {\n    #my @transcript=@{$cds[$i]->{'range'}};\n    #$transcript=\\@transcript;\n    #push (@transcripts,$transcript);\n    push (@transcripts,$cds[$i]->{'range'});\n    if ($getswissprotinfo) {\n      $swissacc=$cds[$i]->{'qualifiers'}->{'db_xref'};\n      $swisshash=$self->get_swisshash($swissacc);\n      #$self->printswissprot($swisshash); # DEBUG\n      push (@swisshashes,$swisshash);\n    }\n  }\n  my @translations=($self->transexonscreation($dna,\\@transcripts));\n  my $translation; my $j=0;\n  foreach $translation (@translations) {\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n  return (@translations);\n}\n\n# only features pertaining to a specified gene are created\n# only the sequence of the gene and appropriate context flanking regions\n# are created as chain\n# arguments: hashref, gene_name (OR: cds_position), length_of_flanking_sequences, getswissprotinfo boolean flag\n# returns: reference to Gene object\n#\n# Note: if entry contains just one CDS, all the features get added\n#       this is useful because often the features in these entries do not\n#       carry the /gene qualifier\n#\n# errorcode: 0\nsub hash2gene {\n  my ($self,$entry,$input,$flanking,$getswissprotinfo)=@_;\n  my $entryfeature;\n  my $genefeatureshash;\n\n  my @cds=@{$entry->{'CDS'}};\n\n  # checking if a position has been given instead than a gene_name\n  if (index($input,\"cds-position:\") == 0 ) {\n    my $cds_position=substr($input,13); # extracting the cds position\n    if (($cds_position >= 1)&&($cds_position <= scalar(@cds))) {\n      $genefeatureshash=$self->_findgenefeatures($entry,undef,$cds_position,$getswissprotinfo);\n    }\n  } else {\n    $genefeatureshash=$self->_findgenefeatures($entry,$input,undef,$getswissprotinfo);\n  }\n\n  unless (($genefeatureshash)&&(scalar(@{$genefeatureshash->{'genefeatures'}}))) { # array empty, no gene features found\n    my @genes=$self->genes($entry);\n    my $cds_number=scalar(@cds);\n    warn \"Warning! Not even one genefeature found for /$input/....\n    The genes present in this entry are:\\n\\t@genes\\n\n    The number of CDS in this entry is:\\n\\t$cds_number\\n\";\n    return(0);\n  }\n\n  # get max and min, check flankings\n  my ($min,$max)=$self->rangeofarray(@{$genefeatureshash->{'labels'}}); # gene \"boundaries\"\n  my $seqlength=$entry->{'SeqLength'};\n  my ($mindna,$maxdna); # some flanking region next to the gene \"boundaries\"\n  if ($min-$flanking < 1) {\n    $mindna=1;\n  } else {\n    $mindna=$min-$flanking;\n  }\n  if ($max+$flanking > $seqlength) {\n    $maxdna=$seqlength;\n  } else {\n    $maxdna=$max+$flanking;\n  }\n  my $subseq=substr($entry->{'Sequence'},$mindna-1,$maxdna-$mindna+1);\n\n  # create LiveSeq objects\n\n  # create DNA\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $subseq, -offset => $mindna);\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->source($entry->{'Organism'});\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n\n  my @transcripts=@{$genefeatureshash->{'transcripts'}};\n  # create Translations, Transcripts, Exons out of the CDS\n  unless (@transcripts) {\n    cluck \"no CDS feature found for /$input/....\";\n    return(0);\n  }\n  my @translationobjs=$self->transexonscreation($dna,\\@transcripts);\n  my @transcriptobjs;\n\n  # get the Transcript obj_refs\n  my $translation;\n  my $j=0;\n  my @ttables=@{$genefeatureshash->{'ttables'}};\n  my @swisshashes=@{$genefeatureshash->{'swisshashes'}};\n  foreach $translation (@translationobjs) {\n    push(@transcriptobjs,$translation->get_Transcript);\n    if ($ttables[$j]) { # if not undef\n      $translation->get_Transcript->translation_table($ttables[$j]);\n    #} else { # DEBUG\n    #  print \"\\n\\t\\tno translation table information....\\n\";\n    }\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n\n  my %gene; # this is the hash to store created object references\n  $gene{DNA}=$dna;\n  $gene{Transcripts}=\\@transcriptobjs;\n  $gene{Translations}=\\@translationobjs;\n\n  my @exonobjs; my @intronobjs;\n  my @repeatunitobjs; my @repeatregionobjs;\n  my @primtranscriptobjs;\n\n  my ($object,$range,$start,$end,$strand);\n\n  my @exons=@{$genefeatureshash->{'exons'}};\n  my @exondescs=@{$genefeatureshash->{'exondescs'}};\n  if (@exons) {\n    my $exoncount = 0;\n    foreach $range (@exons) {\n      ($start,$end,$strand)=@{$range};\n      $object = Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($exondescs[$exoncount]) if defined $exondescs[$exoncount];\n\t$exoncount++;\n\tpush (@exonobjs,$object);\n      } else {\n\t$exoncount++;\n      }\n    }\n    $gene{Exons}=\\@exonobjs;\n  }\n  my @introns=@{$genefeatureshash->{'introns'}};\n  my @introndescs=@{$genefeatureshash->{'introndescs'}};\n  if (@introns) {\n    my $introncount = 0;\n    foreach $range (@introns) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Intron->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($introndescs[$introncount]);\n\t$introncount++;\n\tpush (@intronobjs,$object);\n      } else {\n\t$introncount++;\n      }\n    }\n    $gene{Introns}=\\@intronobjs;\n  }\n  my @prim_transcripts=@{$genefeatureshash->{'prim_transcripts'}};\n  if (@prim_transcripts) {\n    foreach $range (@prim_transcripts) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Prim_Transcript->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) { push (@primtranscriptobjs,$object); }\n    }\n    $gene{Prim_Transcripts}=\\@primtranscriptobjs;\n  }\n  my @repeat_regions=@{$genefeatureshash->{'repeat_regions'}};\n  my @repeat_regions_family=@{$genefeatureshash->{'repeat_regions_family'}};\n  if (@repeat_regions) {\n    my $k=0;\n    foreach $range (@repeat_regions) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Region->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_regions_family[$k]);\n\t$k++;\n\tpush (@repeatregionobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Regions}=\\@repeatregionobjs;\n  }\n  my @repeat_units=@{$genefeatureshash->{'repeat_units'}};\n  my @repeat_units_family=@{$genefeatureshash->{'repeat_units_family'}};\n  if (@repeat_units) {\n    my $k=0;\n    foreach $range (@repeat_units) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Unit->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_units_family[$k]);\n\t$k++;\n\tpush (@repeatunitobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Units}=\\@repeatunitobjs;\n  }\n\n  # create the Gene\n  my $gene_name=$genefeatureshash->{'gene_name'}; # either a name or a cdspos\n  return (Bio::LiveSeq::Gene->new(-name=>$gene_name,-features=>\\%gene,\n                                  -upbound=>$min,-downbound=>$max));\n}\n\n# maybe this function will be moved to general utility package\n# argument: array of numbers\n# returns: (min,max) numbers in the array\nsub rangeofarray {\n  my $self=shift;\n  my @array=@_;\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=array: @array\\n\";\n  my ($max,$min,$element);\n  $min=$max=shift(@array);\n  foreach $element (@array) {\n      $element = 0 unless defined $element;\n    if ($element < $min) {\n      $min=$element;\n    }\n    if ($element > $max) {\n      $max=$element;\n    }\n  }\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=min: $min\\tmax: $max\\n\";\n  return ($min,$max);\n}\n\n\n# argument: reference to DNA object, reference to array of transcripts\n# returns: an array of Translation object references\nsub transexonscreation {\n  my $self=shift;\n  my $dna=$_[0];\n  my @transcripts=@{$_[1]};\n\n  my (@transexons,$start,$end,$strand,$exonref,$exonobj,$transcript,$transcriptobj);\n  my $translationobj;\n  my @translationobjects;\n  foreach $transcript (@transcripts) {\n    foreach $exonref (@{$transcript}) {\n      ($start,$end,$strand)=@{$exonref};\n      #print \"Creating Exon: start $start end $end strand $strand\\n\";\n      $exonobj=Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      #push (@exonobjects,$exonobj);\n      push (@transexons,$exonobj);\n    }\n    $transcriptobj=Bio::LiveSeq::Transcript->new(-exons => \\@transexons );\n    if ($transcriptobj != -1) {\n      $translationobj=Bio::LiveSeq::Translation->new(-transcript=>$transcriptobj);\n      @transexons=(); # cleans it\n      #push (@transcriptobjects,$transcriptobj);\n      push (@translationobjects,$translationobj);\n    }\n  }\n  return (@translationobjects);\n}\n\n#sub printgene {\n# deleted. Some functionality placed in Gene->printfeaturesnum\n\n=head2 printswissprot\n\n  Title   : printswissprot\n  Usage   : $loader->printswissprot($hashref);\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : a hashref containing the SWISSPROT entry datas\n  Note    : the hashref can be obtained with a call to the method\n               $loader->get_swisshash()      (BioPerl via Bio::DB::EMBL.pm)\n\t    that takes as argument a string like \"SWISS-PROT:P10275\"\n\n\n# argument: hashref containing the SWISSPROT entry datas\n# prints out that hash, showing the informations loaded\nsub printswissprot {\n  my ($self,$entry)=@_;\n  unless ($entry) {\n    return;\n  }\n  printf \"ID: %s\\n\",\n      $entry->{'ID'};\n  printf \"ACC: %s\\n\",\n      $entry->{'AccNumber'};\n  printf \"GENE: %s\\n\",\n      $entry->{'Gene'};\n  printf \"DES: %s\\n\",\n      $entry->{'Description'};\n  printf \"ORG: %s\\n\",\n      $entry->{'Organism'};\n  printf \"SEQLN: %s\\n\",\n      $entry->{'SeqLength'};\n  printf \"SEQ: %s\\n\",\n      substr($entry->{'Sequence'},0,64);\n  if ($entry->{'Features'}) {\n    my @features=@{$entry->{'Features'}};\n    my $i;\n    for $i (0..$#features) {\n      print \"|\",$features[$i]->{'name'},\"|\";\n      print \" at \",$features[$i]->{'location'},\": \";\n      print \"\",$features[$i]->{'desc'},\"\\n\";\n    }\n  }\n}\n\n=head2 printembl\n\n  Title   : printembl\n  Usage   : $loader->printembl();\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : none\n\n argument: hashref containing the EMBL entry datas\n prints out that hash, showing the informations loaded","label":"printembl($self,$entry)"},"detail":"($self,$entry)","kind":12,"children":[{"localvar":"my","containerName":"printembl","name":"$self","definition":"my","line":550,"kind":13},{"containerName":"printembl","name":"$entry","line":550,"kind":13},{"containerName":"printembl","name":"$entry","kind":13,"line":551},{"kind":13,"line":552,"name":"$entry","containerName":"printembl"},{"line":552,"kind":13,"containerName":"printembl","name":"$self"},{"kind":13,"line":554,"containerName":"printembl","definition":"my","name":"$i","localvar":"my"},{"kind":13,"line":554,"name":"$featurename","containerName":"printembl"},{"kind":13,"line":556,"name":"$entry","containerName":"printembl"},{"kind":13,"line":558,"name":"$entry","containerName":"printembl"},{"kind":13,"line":560,"containerName":"printembl","name":"$entry"},{"kind":13,"line":562,"containerName":"printembl","name":"$entry"},{"line":564,"kind":13,"containerName":"printembl","name":"$entry"},{"name":"$entry","containerName":"printembl","kind":13,"line":566},{"name":"$entry","containerName":"printembl","kind":13,"line":568},{"containerName":"printembl","name":"$entry","line":570,"kind":13},{"kind":13,"line":571,"definition":"my","name":"@features","containerName":"printembl","localvar":"my"},{"name":"$entry","containerName":"printembl","kind":13,"line":571}],"line":549,"name":"printembl","range":{"end":{"line":571,"character":9999},"start":{"line":549,"character":0}}},{"kind":13,"line":572,"name":"@cds","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"%entry","line":572,"kind":13},{"name":"@cds","containerName":null,"kind":13,"line":573},{"name":"%entry","containerName":null,"line":573,"kind":13},{"kind":13,"line":574,"containerName":null,"definition":"my","name":"$exonref","localvar":"my"},{"kind":13,"line":574,"name":"$transcript","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"$qualifiernumber","line":575,"kind":13},{"kind":13,"line":575,"name":"$qualifiers","containerName":null},{"line":575,"kind":13,"name":"$key","containerName":null},{"definition":"my","name":"$start","containerName":null,"localvar":"my","kind":13,"line":576},{"line":576,"kind":13,"name":"$end","containerName":null},{"line":576,"kind":13,"containerName":null,"name":"$strand"},{"name":"$j","definition":"my","containerName":null,"localvar":"my","kind":13,"line":577},{"kind":13,"line":578,"name":"$i","containerName":null},{"kind":12,"line":578,"name":"features"},{"containerName":null,"name":"$featurename","line":579,"kind":13},{"containerName":null,"name":"@features","kind":13,"line":579},{"containerName":null,"name":"%i","line":579,"kind":13},{"containerName":null,"name":"%featurename","line":580,"kind":13},{"containerName":null,"name":"$transcript","line":583,"kind":13},{"containerName":null,"name":"@features","line":583,"kind":13},{"kind":13,"line":583,"containerName":null,"name":"%i"},{"name":"$exonref","containerName":null,"line":584,"kind":13},{"line":584,"kind":13,"containerName":null,"name":"%transcript"},{"name":"$start","containerName":null,"kind":13,"line":585},{"name":"$end","containerName":null,"kind":13,"line":585},{"kind":13,"line":585,"name":"$strand","containerName":null},{"line":585,"kind":13,"name":"$exonref","containerName":null},{"containerName":null,"name":"%j","kind":13,"line":588},{"containerName":null,"name":"@features","line":592,"kind":13},{"kind":13,"line":592,"name":"%i","containerName":null},{"line":595,"kind":13,"containerName":null,"name":"$qualifiernumber"},{"line":595,"kind":13,"name":"@features","containerName":null},{"line":595,"kind":13,"containerName":null,"name":"%i"},{"line":596,"kind":13,"name":"$qualifiers","containerName":null},{"line":596,"kind":13,"containerName":null,"name":"@features"},{"name":"%i","containerName":null,"kind":13,"line":596},{"line":597,"kind":13,"containerName":null,"name":"$key"},{"line":597,"kind":13,"name":"%qualifiers","containerName":null},{"line":598,"kind":13,"containerName":null,"name":"$key"},{"line":599,"kind":13,"name":"%qualifiers","containerName":null},{"containerName":null,"name":"$key","line":599,"kind":13},{"range":{"start":{"character":0,"line":616},"end":{"line":621,"character":9999}},"name":"genes","line":616,"children":[{"localvar":"my","containerName":"genes","name":"$self","definition":"my","line":617,"kind":13},{"kind":13,"line":617,"name":"$entry","containerName":"genes"},{"line":618,"kind":13,"containerName":"genes","name":"$entry"},{"containerName":"genes","name":"$entry","kind":13,"line":619},{"kind":13,"line":619,"name":"$self","containerName":"genes"},{"definition":"my","name":"@entryfeatures","containerName":"genes","localvar":"my","kind":13,"line":621},{"containerName":"genes","name":"$entry","kind":13,"line":621}],"kind":12,"detail":"($self,$entry)","signature":{"parameters":[{"label":"$self"},{"label":"$entry"}],"documentation":"1;\n# $Id: Loader.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::Loader\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::Loader - Parent Loader for LiveSeq\n\n=head1 SYNOPSIS\n\n  #documentation needed\n\n=head1 DESCRIPTION\n\nThis package holds common methods used by BioPerl and file loaders.\nIt contains methods to create LiveSeq objects out of entire entries or from a\nlocalized sequence region surrounding a particular gene.\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::Loader;\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse Bio::LiveSeq::DNA;\nuse Bio::LiveSeq::Exon;\nuse Bio::LiveSeq::Transcript ;\nuse Bio::LiveSeq::Translation;\nuse Bio::LiveSeq::Gene;\nuse Bio::LiveSeq::Intron;\nuse Bio::LiveSeq::Prim_Transcript;\nuse Bio::LiveSeq::Repeat_Region;\nuse Bio::LiveSeq::Repeat_Unit;\nuse Bio::LiveSeq::AARange;\nuse Bio::Tools::CodonTable;\n\n=head2 entry2liveseq\n\n  Title   : entry2liveseq\n  Usage   : @translationobjects=$loader->entry2liveseq();\n          : @translationobjects=$loader->entry2liveseq(-getswissprotinfo => 0);\n  Function: creates LiveSeq objects from an entry previously loaded\n  Returns : array of references to objects of class Translation\n  Errorcode 0\n  Args    : optional boolean flag to avoid the retrieval of SwissProt\n            informations for all Transcripts containing SwissProt x-reference\n            default is 1 (to retrieve those informations and create AARange\n            LiveSeq objects)\n  Note    : this method can get really slow for big entries. The lightweight\n            gene2liveseq method is recommended\n\n\nsub entry2liveseq {\n  my ($self, %args) = @_;\n  my ($getswissprotinfo)=($args{-getswissprotinfo});\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my @translationobjects=$self->hash2liveseq($hashref,$getswissprotinfo);\n  my $test_transl=0;\n  if ($test_transl) { $self->test_transl($hashref,\\@translationobjects);}\n  return @translationobjects;\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=$loader->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n                                             -taxon => 9606,\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage database to choose codons according to\n            relative frequencies.\n            If a taxon ID is not specified, the default is to use the human\n            one (taxonomy ID 9606).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n            integer (optional) with a taxonomy ID\n            string specifying a gene name\n\n\n=head2 gene2liveseq\n\n  Title   : gene2liveseq\n  Usage   : $gene=$loader->gene2liveseq(-gene_name => \"gene name\");\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -flanking => 64);\n          : $gene=$loader->gene2liveseq(-gene_name => \"gene name\",\n                                        -getswissprotinfo => 0);\n          : $gene=$loader->gene2liveseq(-position => 4);\n\n  Function: creates LiveSeq objects from an entry previously loaded\n            It is a \"light weight\" creation because it creates\n            a LiveSequence just for the interesting region in an entry\n            (instead than for the total entry, like in entry2liveseq) and for\n            the flanking regions up to 500 nucleotides (default) or up to\n            the specified amount of nucleotides (given as argument) around the\n            Gene.\n  Returns : reference to a Gene object containing possibly alternative\n            Transcripts.\n  Errorcode 0\n  Args    : string containing the gene name as in the EMBL feature qualifier\n            integer (optional) \"flanking\": amount of flanking bases to be kept\n            boolean (optional) \"getswissprotinfo\": if set to \"0\" it will avoid\n             trying to fetch information from a crossreference to a SwissProt\n             entry, avoding the process of creation of AARange objects\n             It is \"1\" (on) by default\n\n            Alternative to a gene_name, a position can be given: an\n            integer (1-) containing the position of the desired CDS in the\n            loaded entry\n\n\nsub gene2liveseq {\n  my ($self, %args) = @_;\n  my ($gene_name,$flanking,$getswissprotinfo,$cds_position)=($args{-gene_name},$args{-flanking},$args{-getswissprotinfo},$args{-position});\n  my $input;\n  unless (($gene_name)||($cds_position)) {\n    carp \"Gene_Name or Position not specified for gene2liveseq loading function\";\n    return (0);\n  }\n  if (($gene_name)&&($cds_position)) {\n    carp \"Gene_Name and Position cannot be given together\";\n    return (0);\n  } elsif ($gene_name) {\n    $input=$gene_name;\n  } else {\n    $input=\"cds-position:\".$cds_position;\n  }\n\n  if (defined($getswissprotinfo)) {\n    if (($getswissprotinfo ne 0)&&($getswissprotinfo ne 1)) {\n      carp \"-getswissprotinfo argument can take only boolean (1 or 0) values. Setting it to 0, i.e. not trying to retrieve SwissProt information....\";\n      $getswissprotinfo=0;\n    }\n  } else {\n    $getswissprotinfo=1;\n  }\n\n  if (defined($flanking)) {\n    unless ($flanking >= 0) {\n      carp \"No sense in specifying a number < 0 for flanking regions to be created for gene2liveseq loading function\";\n      return (0);\n    }\n  } else {\n    $flanking=500; # the default flanking length\n  }\n  my $hashref=$self->{'hash'};\n  unless ($hashref) { return (0); }\n  my $gene=$self->hash2gene($hashref,$input,$flanking,$getswissprotinfo);\n  unless ($gene) { # if $gene == 0 it means problems in hash2gene\n    carp \"gene2liveseq produced error\";\n    return (0);\n  }\n  return $gene;\n}\n\n# TODO: update so that it will work even if CDS is not only accepted FEATURE!!\n# this method is for now deprecated and not supported\nsub test_transl {\n  my ($self,$entry)=@_;\n  my @features=@{$entry->{'Features'}};\n  my @translationobjects=@{$_[1]};\n  my ($i,$translation);\n  my ($obj_transl,$hash_transl);\n  my @cds=@{$entry->{'CDS'}};\n  foreach $translation (@translationobjects) {\n    $obj_transl=$translation->seq;\n    $hash_transl=$cds[$i]->{'qualifiers'}->{'translation'};\n    #before seq was changed in Translation 1.4# chop $obj_transl; # to remove trailing \"*\"\n    unless ($obj_transl eq $hash_transl) {\n      cluck \"Serious error: Translation from the Entry does not match Translation from object's seq for CDS at position $i\";\n      carp \"\\nEntry's transl: \",$hash_transl,\"\\n\";\n      carp \"\\nObject's transl: \",$obj_transl,\"\\n\";\n      exit;\n    }\n    $i++;\n  }\n}\n\n# argument: hashref containing the EMBL entry datas,\n#           getswissprotinfo boolean flag\n# creates the liveseq objects\n# returns: an array of Translation object references\nsub hash2liveseq {\n  my ($self,$entry,$getswissprotinfo)=@_;\n  my $i;\n  my @transcripts;\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $entry->{'Sequence'} );\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n  my @cds=@{$entry->{'CDS'}};\n  my ($swissacc,$swisshash); my @swisshashes;\n  for $i (0..$#cds) {\n    #my @transcript=@{$cds[$i]->{'range'}};\n    #$transcript=\\@transcript;\n    #push (@transcripts,$transcript);\n    push (@transcripts,$cds[$i]->{'range'});\n    if ($getswissprotinfo) {\n      $swissacc=$cds[$i]->{'qualifiers'}->{'db_xref'};\n      $swisshash=$self->get_swisshash($swissacc);\n      #$self->printswissprot($swisshash); # DEBUG\n      push (@swisshashes,$swisshash);\n    }\n  }\n  my @translations=($self->transexonscreation($dna,\\@transcripts));\n  my $translation; my $j=0;\n  foreach $translation (@translations) {\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n  return (@translations);\n}\n\n# only features pertaining to a specified gene are created\n# only the sequence of the gene and appropriate context flanking regions\n# are created as chain\n# arguments: hashref, gene_name (OR: cds_position), length_of_flanking_sequences, getswissprotinfo boolean flag\n# returns: reference to Gene object\n#\n# Note: if entry contains just one CDS, all the features get added\n#       this is useful because often the features in these entries do not\n#       carry the /gene qualifier\n#\n# errorcode: 0\nsub hash2gene {\n  my ($self,$entry,$input,$flanking,$getswissprotinfo)=@_;\n  my $entryfeature;\n  my $genefeatureshash;\n\n  my @cds=@{$entry->{'CDS'}};\n\n  # checking if a position has been given instead than a gene_name\n  if (index($input,\"cds-position:\") == 0 ) {\n    my $cds_position=substr($input,13); # extracting the cds position\n    if (($cds_position >= 1)&&($cds_position <= scalar(@cds))) {\n      $genefeatureshash=$self->_findgenefeatures($entry,undef,$cds_position,$getswissprotinfo);\n    }\n  } else {\n    $genefeatureshash=$self->_findgenefeatures($entry,$input,undef,$getswissprotinfo);\n  }\n\n  unless (($genefeatureshash)&&(scalar(@{$genefeatureshash->{'genefeatures'}}))) { # array empty, no gene features found\n    my @genes=$self->genes($entry);\n    my $cds_number=scalar(@cds);\n    warn \"Warning! Not even one genefeature found for /$input/....\n    The genes present in this entry are:\\n\\t@genes\\n\n    The number of CDS in this entry is:\\n\\t$cds_number\\n\";\n    return(0);\n  }\n\n  # get max and min, check flankings\n  my ($min,$max)=$self->rangeofarray(@{$genefeatureshash->{'labels'}}); # gene \"boundaries\"\n  my $seqlength=$entry->{'SeqLength'};\n  my ($mindna,$maxdna); # some flanking region next to the gene \"boundaries\"\n  if ($min-$flanking < 1) {\n    $mindna=1;\n  } else {\n    $mindna=$min-$flanking;\n  }\n  if ($max+$flanking > $seqlength) {\n    $maxdna=$seqlength;\n  } else {\n    $maxdna=$max+$flanking;\n  }\n  my $subseq=substr($entry->{'Sequence'},$mindna-1,$maxdna-$mindna+1);\n\n  # create LiveSeq objects\n\n  # create DNA\n  my $dna=Bio::LiveSeq::DNA->new(-seq => $subseq, -offset => $mindna);\n  $dna->alphabet(lc($entry->{'Molecule'}));\n  $dna->source($entry->{'Organism'});\n  $dna->display_id($entry->{'ID'});\n  $dna->accession_number($entry->{'AccNumber'});\n  $dna->desc($entry->{'Description'});\n\n  my @transcripts=@{$genefeatureshash->{'transcripts'}};\n  # create Translations, Transcripts, Exons out of the CDS\n  unless (@transcripts) {\n    cluck \"no CDS feature found for /$input/....\";\n    return(0);\n  }\n  my @translationobjs=$self->transexonscreation($dna,\\@transcripts);\n  my @transcriptobjs;\n\n  # get the Transcript obj_refs\n  my $translation;\n  my $j=0;\n  my @ttables=@{$genefeatureshash->{'ttables'}};\n  my @swisshashes=@{$genefeatureshash->{'swisshashes'}};\n  foreach $translation (@translationobjs) {\n    push(@transcriptobjs,$translation->get_Transcript);\n    if ($ttables[$j]) { # if not undef\n      $translation->get_Transcript->translation_table($ttables[$j]);\n    #} else { # DEBUG\n    #  print \"\\n\\t\\tno translation table information....\\n\";\n    }\n    if ($swisshashes[$j]) { # if not 0\n      $self->swisshash2liveseq($swisshashes[$j],$translation);\n    }\n    $j++;\n  }\n\n  my %gene; # this is the hash to store created object references\n  $gene{DNA}=$dna;\n  $gene{Transcripts}=\\@transcriptobjs;\n  $gene{Translations}=\\@translationobjs;\n\n  my @exonobjs; my @intronobjs;\n  my @repeatunitobjs; my @repeatregionobjs;\n  my @primtranscriptobjs;\n\n  my ($object,$range,$start,$end,$strand);\n\n  my @exons=@{$genefeatureshash->{'exons'}};\n  my @exondescs=@{$genefeatureshash->{'exondescs'}};\n  if (@exons) {\n    my $exoncount = 0;\n    foreach $range (@exons) {\n      ($start,$end,$strand)=@{$range};\n      $object = Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($exondescs[$exoncount]) if defined $exondescs[$exoncount];\n\t$exoncount++;\n\tpush (@exonobjs,$object);\n      } else {\n\t$exoncount++;\n      }\n    }\n    $gene{Exons}=\\@exonobjs;\n  }\n  my @introns=@{$genefeatureshash->{'introns'}};\n  my @introndescs=@{$genefeatureshash->{'introndescs'}};\n  if (@introns) {\n    my $introncount = 0;\n    foreach $range (@introns) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Intron->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($introndescs[$introncount]);\n\t$introncount++;\n\tpush (@intronobjs,$object);\n      } else {\n\t$introncount++;\n      }\n    }\n    $gene{Introns}=\\@intronobjs;\n  }\n  my @prim_transcripts=@{$genefeatureshash->{'prim_transcripts'}};\n  if (@prim_transcripts) {\n    foreach $range (@prim_transcripts) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Prim_Transcript->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) { push (@primtranscriptobjs,$object); }\n    }\n    $gene{Prim_Transcripts}=\\@primtranscriptobjs;\n  }\n  my @repeat_regions=@{$genefeatureshash->{'repeat_regions'}};\n  my @repeat_regions_family=@{$genefeatureshash->{'repeat_regions_family'}};\n  if (@repeat_regions) {\n    my $k=0;\n    foreach $range (@repeat_regions) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Region->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_regions_family[$k]);\n\t$k++;\n\tpush (@repeatregionobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Regions}=\\@repeatregionobjs;\n  }\n  my @repeat_units=@{$genefeatureshash->{'repeat_units'}};\n  my @repeat_units_family=@{$genefeatureshash->{'repeat_units_family'}};\n  if (@repeat_units) {\n    my $k=0;\n    foreach $range (@repeat_units) {\n      ($start,$end,$strand)=@{$range};\n      $object=Bio::LiveSeq::Repeat_Unit->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      if ($object != -1) {\n\t$object->desc($repeat_units_family[$k]);\n\t$k++;\n\tpush (@repeatunitobjs,$object);\n      } else {\n\t$k++;\n      }\n    }\n    $gene{Repeat_Units}=\\@repeatunitobjs;\n  }\n\n  # create the Gene\n  my $gene_name=$genefeatureshash->{'gene_name'}; # either a name or a cdspos\n  return (Bio::LiveSeq::Gene->new(-name=>$gene_name,-features=>\\%gene,\n                                  -upbound=>$min,-downbound=>$max));\n}\n\n# maybe this function will be moved to general utility package\n# argument: array of numbers\n# returns: (min,max) numbers in the array\nsub rangeofarray {\n  my $self=shift;\n  my @array=@_;\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=array: @array\\n\";\n  my ($max,$min,$element);\n  $min=$max=shift(@array);\n  foreach $element (@array) {\n      $element = 0 unless defined $element;\n    if ($element < $min) {\n      $min=$element;\n    }\n    if ($element > $max) {\n      $max=$element;\n    }\n  }\n  #print \"\\n-=-=-=-=-=-=-=-=-=-=min: $min\\tmax: $max\\n\";\n  return ($min,$max);\n}\n\n\n# argument: reference to DNA object, reference to array of transcripts\n# returns: an array of Translation object references\nsub transexonscreation {\n  my $self=shift;\n  my $dna=$_[0];\n  my @transcripts=@{$_[1]};\n\n  my (@transexons,$start,$end,$strand,$exonref,$exonobj,$transcript,$transcriptobj);\n  my $translationobj;\n  my @translationobjects;\n  foreach $transcript (@transcripts) {\n    foreach $exonref (@{$transcript}) {\n      ($start,$end,$strand)=@{$exonref};\n      #print \"Creating Exon: start $start end $end strand $strand\\n\";\n      $exonobj=Bio::LiveSeq::Exon->new(-seq=>$dna,-start=>$start,-end=>$end,-strand=>$strand);\n      #push (@exonobjects,$exonobj);\n      push (@transexons,$exonobj);\n    }\n    $transcriptobj=Bio::LiveSeq::Transcript->new(-exons => \\@transexons );\n    if ($transcriptobj != -1) {\n      $translationobj=Bio::LiveSeq::Translation->new(-transcript=>$transcriptobj);\n      @transexons=(); # cleans it\n      #push (@transcriptobjects,$transcriptobj);\n      push (@translationobjects,$translationobj);\n    }\n  }\n  return (@translationobjects);\n}\n\n#sub printgene {\n# deleted. Some functionality placed in Gene->printfeaturesnum\n\n=head2 printswissprot\n\n  Title   : printswissprot\n  Usage   : $loader->printswissprot($hashref);\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : a hashref containing the SWISSPROT entry datas\n  Note    : the hashref can be obtained with a call to the method\n               $loader->get_swisshash()      (BioPerl via Bio::DB::EMBL.pm)\n\t    that takes as argument a string like \"SWISS-PROT:P10275\"\n\n\n# argument: hashref containing the SWISSPROT entry datas\n# prints out that hash, showing the informations loaded\nsub printswissprot {\n  my ($self,$entry)=@_;\n  unless ($entry) {\n    return;\n  }\n  printf \"ID: %s\\n\",\n      $entry->{'ID'};\n  printf \"ACC: %s\\n\",\n      $entry->{'AccNumber'};\n  printf \"GENE: %s\\n\",\n      $entry->{'Gene'};\n  printf \"DES: %s\\n\",\n      $entry->{'Description'};\n  printf \"ORG: %s\\n\",\n      $entry->{'Organism'};\n  printf \"SEQLN: %s\\n\",\n      $entry->{'SeqLength'};\n  printf \"SEQ: %s\\n\",\n      substr($entry->{'Sequence'},0,64);\n  if ($entry->{'Features'}) {\n    my @features=@{$entry->{'Features'}};\n    my $i;\n    for $i (0..$#features) {\n      print \"|\",$features[$i]->{'name'},\"|\";\n      print \" at \",$features[$i]->{'location'},\": \";\n      print \"\",$features[$i]->{'desc'},\"\\n\";\n    }\n  }\n}\n\n=head2 printembl\n\n  Title   : printembl\n  Usage   : $loader->printembl();\n  Function: prints out all informations loaded from a database entry into the\n            loader. Mainly used for testing purposes.\n  Args    : none\n\n\n# argument: hashref containing the EMBL entry datas\n# prints out that hash, showing the informations loaded\nsub printembl {\n  my ($self,$entry)=@_;\n  unless ($entry) {\n    $entry=$self->{'hash'};\n  }\n  my ($i,$featurename);\n  printf \"ID: %s\\n\",\n      $entry->{'ID'};\n  printf \"ACC: %s\\n\",\n      $entry->{'AccNumber'};\n  printf \"MOL: %s\\n\",\n      $entry->{'Molecule'};\n  printf \"DIV: %s\\n\",\n      $entry->{'Division'};\n  printf \"DES: %s\\n\",\n      $entry->{'Description'};\n  printf \"ORG: %s\\n\",\n      $entry->{'Organism'};\n  printf \"SEQLN: %s\\n\",\n      $entry->{'SeqLength'};\n  printf \"SEQ: %s\\n\",\n      substr($entry->{'Sequence'},0,64);\n  my @features=@{$entry->{'Features'}};\n  my @cds=@{$entry->{'CDS'}};\n  print \"\\nFEATURES\\nNumber of CDS: \",scalar(@cds),\" (out of \",$entry->{'FeaturesNumber'}, \" total features)\\n\";\n  my ($exonref,$transcript);\n  my ($qualifiernumber,$qualifiers,$key);\n  my ($start,$end,$strand);\n  my $j=0;\n  for $i (0..$#features) {\n    $featurename=$features[$i]->{'name'};\n    if ($featurename eq \"CDS\") {\n      print \"|CDS| number $j at feature position: $i\\n\";\n      #print $features[$i]->{'location'},\"\\n\";\n      $transcript=$features[$i]->{'range'};\n      foreach $exonref (@{$transcript}) {\n\t($start,$end,$strand)=@{$exonref};\n\tprint \"\\tExon: start $start end $end strand $strand\\n\";\n      }\n      $j++;\n    } else {\n      print \"|$featurename| at feature position: $i\\n\";\n      print \"\\trange: \";\n      print join(\"\\t\",@{$features[$i]->{'range'}}),\"\\n\";\n      #print $features[$i]->{'location'},\"\\n\";\n    }\n    $qualifiernumber=$features[$i]->{'qual_number'};\n    $qualifiers=$features[$i]->{'qualifiers'}; # hash\n    foreach $key (keys (%{$qualifiers})) {\n    print \"\\t\\t\",$key,\": \";\n      print $qualifiers->{$key},\"\\n\";\n    }\n  }\n}\n\n=head2 genes\n\n  Title   : genes\n  Usage   : $loader->genes();\n  Function: Returns an array of gene_names (strings) contained in the loaded\n            entry.\n  Args    : none\n\n argument: entryhashref\n returns: array of genenames found in the entry","label":"genes($self,$entry)"},"containerName":"main::","definition":"sub"},{"kind":13,"line":622,"definition":"my","name":"$genename","containerName":null,"localvar":"my"},{"kind":13,"line":622,"name":"$genenames","containerName":null},{"containerName":null,"name":"$entryfeature","kind":13,"line":622},{"kind":13,"line":623,"name":"$entryfeature","containerName":null},{"name":"@entryfeatures","containerName":null,"kind":13,"line":623},{"line":624,"kind":13,"containerName":null,"name":"$genename"},{"name":"%entryfeature","containerName":null,"kind":13,"line":624},{"kind":13,"line":625,"name":"%genename","containerName":null},{"containerName":null,"name":"$genenames","line":626,"kind":13},{"kind":13,"line":626,"name":"%genename","containerName":null},{"name":"$genenames","containerName":null,"line":627,"kind":13},{"kind":13,"line":627,"name":"$genename","containerName":null},{"containerName":null,"name":"$genenames","kind":13,"line":631},{"range":{"end":{"character":9999,"line":650},"start":{"line":637,"character":0}},"name":"swisshash2liveseq","signature":{"parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$translation"}],"documentation":" arguments: swisshash, translation objref\n adds information to the Translation, creates AARange objects, sets the\n aa_range attribute on the Translation, pointing to those objects","label":"swisshash2liveseq($self,$entry,$translation)"},"detail":"($self,$entry,$translation)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":638,"name":"$self","definition":"my","containerName":"swisshash2liveseq","localvar":"my"},{"kind":13,"line":638,"name":"$entry","containerName":"swisshash2liveseq"},{"kind":13,"line":638,"name":"$translation","containerName":"swisshash2liveseq"},{"line":639,"kind":13,"localvar":"my","definition":"my","name":"$translength","containerName":"swisshash2liveseq"},{"containerName":"swisshash2liveseq","name":"$translation","kind":13,"line":639},{"containerName":"swisshash2liveseq","name":"length","line":639,"kind":12},{"line":640,"kind":13,"name":"$translation","containerName":"swisshash2liveseq"},{"name":"desc","containerName":"swisshash2liveseq","kind":12,"line":640},{"line":640,"kind":13,"name":"$translation","containerName":"swisshash2liveseq"},{"containerName":"swisshash2liveseq","name":"desc","line":640,"kind":12},{"name":"$entry","containerName":"swisshash2liveseq","line":640,"kind":13},{"containerName":"swisshash2liveseq","name":"$translation","kind":13,"line":641},{"kind":12,"line":641,"containerName":"swisshash2liveseq","name":"display_id"},{"name":"$entry","containerName":"swisshash2liveseq","line":641,"kind":13},{"kind":13,"line":642,"containerName":"swisshash2liveseq","name":"$translation"},{"line":642,"kind":12,"name":"accession_number","containerName":"swisshash2liveseq"},{"line":642,"kind":13,"name":"$entry","containerName":"swisshash2liveseq"},{"kind":13,"line":643,"containerName":"swisshash2liveseq","name":"$translation"},{"name":"name","containerName":"swisshash2liveseq","kind":12,"line":643},{"containerName":"swisshash2liveseq","name":"$entry","line":643,"kind":13},{"kind":13,"line":644,"containerName":"swisshash2liveseq","name":"$translation"},{"kind":12,"line":644,"containerName":"swisshash2liveseq","name":"source"},{"name":"$entry","containerName":"swisshash2liveseq","line":644,"kind":13},{"localvar":"my","containerName":"swisshash2liveseq","name":"@aarangeobjects","definition":"my","line":645,"kind":13},{"line":646,"kind":13,"localvar":"my","containerName":"swisshash2liveseq","name":"$start","definition":"my"},{"containerName":"swisshash2liveseq","name":"$end","line":646,"kind":13},{"kind":13,"line":646,"containerName":"swisshash2liveseq","name":"$aarangeobj"},{"containerName":"swisshash2liveseq","name":"$feature","line":646,"kind":13},{"localvar":"my","containerName":"swisshash2liveseq","definition":"my","name":"@features","line":647,"kind":13},{"kind":13,"line":647,"definition":"my","name":"@newfeatures","containerName":"swisshash2liveseq","localvar":"my"},{"line":648,"kind":13,"containerName":"swisshash2liveseq","name":"$entry"},{"kind":13,"line":649,"containerName":"swisshash2liveseq","name":"@features"},{"line":649,"kind":13,"name":"$entry","containerName":"swisshash2liveseq"}],"line":637,"kind":12},{"kind":13,"line":651,"definition":"my","name":"$cleavedmet","containerName":null,"localvar":"my"},{"name":"$feature","containerName":null,"kind":13,"line":653},{"line":653,"kind":13,"name":"@features","containerName":null},{"containerName":null,"name":"%feature","kind":13,"line":654},{"name":"%feature","containerName":null,"line":654,"kind":13},{"kind":13,"line":655,"name":"$cleavedmet","containerName":null},{"line":656,"kind":13,"containerName":null,"name":"%translation"},{"name":"@newfeatures","containerName":null,"kind":13,"line":658},{"name":"$feature","containerName":null,"line":658,"kind":13},{"containerName":null,"definition":"my","name":"$swissseq","localvar":"my","kind":13,"line":662},{"kind":13,"line":662,"containerName":null,"name":"%entry"},{"kind":13,"line":663,"definition":"my","name":"$liveseqtransl","containerName":null,"localvar":"my"},{"line":663,"kind":13,"containerName":null,"name":"$translation"},{"containerName":"main::","name":"seq","line":663,"kind":12},{"line":664,"kind":13,"containerName":null,"name":"$liveseqtransl"},{"containerName":null,"definition":"my","name":"$translated","localvar":"my","kind":13,"line":665},{"kind":13,"line":665,"containerName":null,"name":"$liveseqtransl"},{"name":"$cleavedmet","containerName":null,"line":665,"kind":13},{"line":667,"kind":13,"localvar":"my","name":"$liveseq_aa","definition":"my","containerName":null},{"kind":13,"line":667,"name":"$swiss_aa","containerName":null},{"name":"$codes_aa","containerName":null,"line":667,"kind":13},{"name":"$self","containerName":null,"line":667,"kind":13},{"containerName":"main::","name":"_get_alignment","line":667,"kind":12},{"kind":13,"line":667,"containerName":null,"name":"$translated"},{"containerName":null,"name":"$swissseq","line":667,"kind":13},{"name":"$liveseq_aa","containerName":null,"line":669,"kind":13},{"containerName":null,"name":"%swiss_aa","kind":13,"line":669},{"name":"carp","line":671,"kind":12},{"line":676,"kind":13,"name":"@features","containerName":null},{"name":"@newfeatures","containerName":null,"line":676,"kind":13},{"kind":13,"line":677,"name":"$feature","containerName":null},{"line":677,"kind":13,"containerName":null,"name":"@features"},{"name":"$start","containerName":null,"kind":13,"line":679},{"containerName":null,"name":"$end","line":679,"kind":13},{"kind":13,"line":679,"containerName":null,"name":"%feature"},{"name":"$aarangeobj","containerName":null,"kind":13,"line":681},{"name":"Bio","containerName":"LiveSeq::AARange","kind":12,"line":681},{"containerName":"main::","name":"new","line":681,"kind":12},{"name":"$start","containerName":null,"line":681,"kind":13},{"name":"$cleavedmet","containerName":null,"line":681,"kind":13},{"line":681,"kind":13,"name":"$end","containerName":null},{"name":"$cleavedmet","containerName":null,"kind":13,"line":681},{"containerName":null,"name":"%feature","kind":13,"line":681},{"name":"%feature","containerName":null,"line":681,"kind":13},{"name":"$translation","containerName":null,"kind":13,"line":681},{"name":"$translength","containerName":null,"kind":13,"line":681},{"line":682,"kind":13,"name":"%aarangeobj","containerName":null},{"containerName":null,"name":"@aarangeobjects","line":683,"kind":13},{"name":"$aarangeobj","containerName":null,"kind":13,"line":683},{"containerName":null,"name":"%translation","kind":13,"line":687},{"line":687,"kind":13,"name":"@aarangeobjects","containerName":null},{"range":{"end":{"character":9999,"line":694},"start":{"character":0,"line":692}},"name":"get_swisshash","definition":"sub","containerName":"main::","children":[],"line":692,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self,$entry,$gene_name,$cds_position,$getswissprotinfo)","signature":{"label":"_findgenefeatures($self,$entry,$gene_name,$cds_position,$getswissprotinfo)","parameters":[{"label":"$self"},{"label":"$entry"},{"label":"$gene_name"},{"label":"$cds_position"},{"label":"$getswissprotinfo"}],"documentation":" Args: $entry hashref, gene_name OR cds_position (undef is used to\n choose between the two), getswissprotinfo boolean flag\n Returns: an hash holding various arrayref used in the hash2gene method\n Function: examines the nucleotide entry, identifying features belonging\n to the gene (defined either by its name or by the position of its CDS in\n the entry)"},"kind":12,"line":703,"children":[{"kind":13,"line":704,"definition":"my","name":"$self","containerName":"_findgenefeatures","localvar":"my"},{"name":"$entry","containerName":"_findgenefeatures","line":704,"kind":13},{"name":"$gene_name","containerName":"_findgenefeatures","kind":13,"line":704},{"kind":13,"line":704,"containerName":"_findgenefeatures","name":"$cds_position"},{"kind":13,"line":704,"containerName":"_findgenefeatures","name":"$getswissprotinfo"},{"line":706,"kind":13,"localvar":"my","containerName":"_findgenefeatures","name":"@entryfeatures","definition":"my"},{"line":706,"kind":13,"containerName":"_findgenefeatures","name":"$entry"}],"name":"_findgenefeatures","range":{"start":{"line":703,"character":0},"end":{"character":9999,"line":706}}},{"kind":13,"line":707,"containerName":null,"definition":"my","name":"@exons","localvar":"my"},{"kind":13,"line":707,"definition":"my","name":"@introns","containerName":null,"localvar":"my"},{"line":707,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@prim_transcripts"},{"localvar":"my","definition":"my","name":"@transcripts","containerName":null,"line":707,"kind":13},{"localvar":"my","containerName":null,"definition":"my","name":"@repeat_units","line":708,"kind":13},{"definition":"my","name":"@repeat_regions","containerName":null,"localvar":"my","kind":13,"line":708},{"line":709,"kind":13,"localvar":"my","definition":"my","name":"@repeat_units_family","containerName":null},{"localvar":"my","definition":"my","name":"@repeat_regions_family","containerName":null,"line":709,"kind":13},{"containerName":null,"name":"$rpt_family","definition":"my","localvar":"my","kind":13,"line":709},{"localvar":"my","name":"$entryfeature","definition":"my","containerName":null,"line":710,"kind":13},{"name":"@genefeatures","definition":"my","containerName":null,"localvar":"my","kind":13,"line":710},{"containerName":null,"name":"$desc","definition":"my","localvar":"my","kind":13,"line":711},{"containerName":null,"name":"@exondescs","definition":"my","localvar":"my","kind":13,"line":711},{"kind":13,"line":711,"name":"@introndescs","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"definition":"my","name":"$swissacc","localvar":"my","kind":13,"line":714},{"name":"$swisshash","containerName":null,"line":714,"kind":13},{"containerName":null,"definition":"my","name":"@swisshashes","localvar":"my","kind":13,"line":714},{"line":717,"kind":13,"localvar":"my","containerName":null,"name":"@ttables","definition":"my"},{"line":720,"kind":13,"localvar":"my","name":"$name","definition":"my","containerName":null},{"line":720,"kind":13,"containerName":null,"name":"$exon"},{"localvar":"my","containerName":null,"name":"@range","definition":"my","line":721,"kind":13},{"line":721,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@cdsexons"},{"name":"@labels","definition":"my","containerName":null,"localvar":"my","kind":13,"line":721},{"line":727,"kind":13,"localvar":"my","containerName":null,"name":"@cds","definition":"my"},{"name":"%entry","containerName":null,"line":727,"kind":13},{"line":729,"kind":13,"localvar":"my","name":"$skipgenematch","definition":"my","containerName":null},{"kind":13,"line":730,"containerName":null,"name":"@cds"},{"line":732,"kind":13,"containerName":null,"name":"$skipgenematch"},{"line":735,"kind":13,"localvar":"my","containerName":null,"name":"$cds_begin","definition":"my"},{"name":"$cds_end","containerName":null,"kind":13,"line":735},{"line":735,"kind":13,"name":"$proximity","containerName":null},{"name":"%cds_position","containerName":null,"kind":13,"line":736},{"name":"@cds_exons","definition":"my","containerName":null,"localvar":"my","kind":13,"line":737},{"name":"@cds","containerName":null,"kind":13,"line":737},{"kind":13,"line":737,"containerName":null,"name":"%cds_position"},{"name":"$cds_begin","containerName":null,"kind":13,"line":738},{"kind":13,"line":738,"containerName":null,"name":"$cds_end"},{"kind":13,"line":738,"containerName":null,"name":"@cds_exons"},{"containerName":null,"name":"@cds_exons","line":738,"kind":13},{"kind":13,"line":739,"name":"$gene_name","containerName":null},{"line":739,"kind":13,"containerName":null,"name":"@cds"},{"kind":13,"line":739,"name":"%cds_position","containerName":null},{"name":"%skipgenematch","containerName":null,"kind":13,"line":741},{"kind":12,"line":742,"name":"carp"},{"containerName":null,"name":"$proximity","line":744,"kind":13},{"line":747,"kind":13,"containerName":null,"name":"$entryfeature"},{"containerName":null,"name":"@entryfeatures","kind":13,"line":747},{"kind":13,"line":748,"name":"$skipgenematch","containerName":null},{"containerName":null,"name":"$cds_position","kind":13,"line":748},{"containerName":null,"name":"$self","line":748,"kind":13},{"kind":12,"line":748,"containerName":"main::","name":"_checkfeatureproximity"},{"containerName":null,"name":"%entryfeature","line":748,"kind":13},{"name":"$cds_begin","containerName":null,"kind":13,"line":748},{"containerName":null,"name":"$cds_end","line":748,"kind":13},{"kind":13,"line":748,"name":"$proximity","containerName":null},{"name":"$cds_position","containerName":null,"line":748,"kind":13},{"name":"%entryfeature","containerName":null,"line":748,"kind":13},{"line":749,"kind":13,"containerName":null,"name":"@genefeatures"},{"line":749,"kind":13,"name":"$entryfeature","containerName":null},{"localvar":"my","containerName":null,"name":"@range","definition":"my","line":751,"kind":13},{"name":"%entryfeature","containerName":null,"kind":13,"line":751},{"name":"$name","containerName":null,"line":752,"kind":13},{"kind":13,"line":752,"containerName":null,"name":"%entryfeature"},{"containerName":null,"name":"%qualifierhash","definition":"my","localvar":"my","kind":13,"line":753},{"line":753,"kind":13,"containerName":null,"name":"%entryfeature"},{"name":"%name","containerName":null,"line":754,"kind":13},{"containerName":null,"name":"%getswissprotinfo","kind":13,"line":758},{"name":"$swissacc","containerName":null,"line":759,"kind":13},{"containerName":null,"name":"%entryfeature","line":759,"kind":13},{"containerName":null,"name":"$swisshash","line":760,"kind":13},{"name":"$self","containerName":null,"line":760,"kind":13},{"containerName":"main::","name":"get_swisshash","line":760,"kind":12},{"line":760,"kind":13,"name":"$swissacc","containerName":null},{"kind":13,"line":762,"containerName":null,"name":"@swisshashes"},{"name":"$swisshash","containerName":null,"line":762,"kind":13},{"name":"@ttables","containerName":null,"line":765,"kind":13},{"containerName":null,"name":"%entryfeature","line":765,"kind":13},{"containerName":null,"name":"$exon","line":768,"kind":13},{"kind":13,"line":768,"name":"@range","containerName":null},{"kind":13,"line":769,"containerName":null,"name":"@labels"},{"containerName":null,"name":"@exon","line":769,"kind":13},{"line":769,"kind":13,"name":"@exon","containerName":null},{"kind":13,"line":771,"containerName":null,"name":"@transcripts"},{"kind":13,"line":771,"containerName":null,"name":"%entryfeature"},{"kind":13,"line":777,"containerName":null,"name":"%entryfeature"},{"name":"%entryfeature","containerName":null,"kind":13,"line":777},{"name":"@range","containerName":null,"kind":13,"line":778},{"kind":13,"line":778,"containerName":null,"name":"@range"},{"kind":13,"line":778,"containerName":null,"name":"@range"},{"line":780,"kind":13,"name":"@labels","containerName":null},{"name":"@range","containerName":null,"line":780,"kind":13},{"containerName":null,"name":"@range","line":780,"kind":13},{"name":"%name","containerName":null,"kind":13,"line":781},{"kind":13,"line":782,"name":"$desc","containerName":null},{"containerName":null,"name":"%entryfeature","kind":13,"line":782},{"containerName":null,"name":"%entryfeature","line":783,"kind":13},{"containerName":null,"name":"%desc","kind":13,"line":784},{"kind":13,"line":785,"name":"$desc","containerName":null},{"name":"%entryfeature","containerName":null,"line":785,"kind":13},{"kind":13,"line":787,"containerName":null,"name":"$desc"},{"containerName":null,"name":"%entryfeature","kind":13,"line":787},{"name":"@exondescs","containerName":null,"line":790,"kind":13},{"containerName":null,"name":"$desc","line":790,"kind":13},{"containerName":null,"name":"@exons","kind":13,"line":791},{"containerName":null,"name":"@range","kind":13,"line":791},{"name":"%name","containerName":null,"line":793,"kind":13},{"line":794,"kind":13,"name":"$desc","containerName":null},{"line":794,"kind":13,"name":"%entryfeature","containerName":null},{"line":795,"kind":13,"name":"%desc","containerName":null},{"containerName":null,"name":"$desc","kind":13,"line":796},{"containerName":null,"name":"%entryfeature","line":796,"kind":13},{"name":"$desc","containerName":null,"kind":13,"line":798},{"containerName":null,"name":"%entryfeature","kind":13,"line":798},{"containerName":null,"name":"@introndescs","kind":13,"line":800},{"name":"$desc","containerName":null,"kind":13,"line":800},{"kind":13,"line":801,"name":"@introns","containerName":null},{"name":"@range","containerName":null,"line":801,"kind":13},{"containerName":null,"name":"$name","line":803,"kind":13},{"containerName":null,"name":"%name","line":803,"kind":13},{"containerName":null,"name":"@prim_transcripts","kind":13,"line":803},{"kind":13,"line":803,"containerName":null,"name":"@range"},{"kind":13,"line":804,"name":"%name","containerName":null},{"name":"@repeat_units","containerName":null,"line":804,"kind":13},{"name":"@range","containerName":null,"line":804,"kind":13},{"kind":13,"line":805,"containerName":null,"name":"$rpt_family"},{"name":"%entryfeature","containerName":null,"kind":13,"line":805},{"containerName":null,"name":"@repeat_units_family","line":806,"kind":13},{"containerName":null,"name":"$rpt_family","kind":13,"line":806},{"containerName":null,"name":"%name","line":808,"kind":13},{"name":"@repeat_regions","containerName":null,"kind":13,"line":808},{"name":"@range","containerName":null,"kind":13,"line":808},{"containerName":null,"name":"$rpt_family","line":809,"kind":13},{"containerName":null,"name":"%entryfeature","line":809,"kind":13},{"line":810,"kind":13,"name":"@repeat_regions_family","containerName":null},{"kind":13,"line":810,"containerName":null,"name":"$rpt_family"},{"containerName":null,"name":"%gene_name","kind":13,"line":815},{"line":815,"kind":13,"name":"$gene_name","containerName":null},{"kind":13,"line":815,"containerName":null,"name":"$cds_position"},{"line":816,"kind":13,"localvar":"my","name":"%genefeatureshash","definition":"my","containerName":null},{"line":817,"kind":13,"containerName":null,"name":"%genefeatureshash"},{"line":817,"kind":12,"name":"gene_name"},{"line":817,"kind":13,"name":"$gene_name","containerName":null},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":818},{"kind":12,"line":818,"name":"genefeatures"},{"kind":13,"line":818,"containerName":null,"name":"@genefeatures"},{"kind":13,"line":819,"name":"%genefeatureshash","containerName":null},{"name":"labels","kind":12,"line":819},{"kind":13,"line":819,"name":"@labels","containerName":null},{"kind":13,"line":820,"containerName":null,"name":"%genefeatureshash"},{"name":"ttables","line":820,"kind":12},{"containerName":null,"name":"@ttables","kind":13,"line":820},{"containerName":null,"name":"%genefeatureshash","line":821,"kind":13},{"name":"swisshashes","line":821,"kind":12},{"containerName":null,"name":"@swisshashes","kind":13,"line":821},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":822},{"line":822,"kind":12,"name":"transcripts"},{"kind":13,"line":822,"name":"@transcripts","containerName":null},{"kind":13,"line":823,"containerName":null,"name":"%genefeatureshash"},{"name":"exons","line":823,"kind":12},{"containerName":null,"name":"@exons","line":823,"kind":13},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":824},{"line":824,"kind":12,"name":"exondescs"},{"kind":13,"line":824,"name":"@exondescs","containerName":null},{"containerName":null,"name":"%genefeatureshash","kind":13,"line":825},{"name":"introns","kind":12,"line":825},{"name":"@introns","containerName":null,"kind":13,"line":825},{"line":826,"kind":13,"containerName":null,"name":"%genefeatureshash"},{"name":"introndescs","line":826,"kind":12},{"name":"@introndescs","containerName":null,"kind":13,"line":826},{"containerName":null,"name":"%genefeatureshash","line":827,"kind":13},{"name":"prim_transcripts","line":827,"kind":12},{"line":827,"kind":13,"name":"@prim_transcripts","containerName":null},{"line":828,"kind":13,"containerName":null,"name":"%genefeatureshash"},{"line":828,"kind":12,"name":"repeat_units"},{"containerName":null,"name":"@repeat_units","kind":13,"line":828},{"name":"%genefeatureshash","containerName":null,"line":829,"kind":13},{"kind":12,"line":829,"name":"repeat_regions"},{"line":829,"kind":13,"name":"@repeat_regions","containerName":null},{"kind":13,"line":830,"containerName":null,"name":"%genefeatureshash"},{"kind":12,"line":830,"name":"repeat_units_family"},{"line":830,"kind":13,"containerName":null,"name":"@repeat_units_family"},{"line":831,"kind":13,"containerName":null,"name":"%genefeatureshash"},{"name":"repeat_regions_family","kind":12,"line":831},{"kind":13,"line":831,"containerName":null,"name":"@repeat_regions_family"},{"kind":13,"line":832,"name":"%genefeatureshash","containerName":null},{"detail":"($self,$range,$cds_begin,$cds_end,$proximity)","signature":{"label":"_checkfeatureproximity($self,$range,$cds_begin,$cds_end,$proximity)","documentation":" used by _findgenefeatures, when a CDS at a certain position is requested,\n to retrieve only features quite close to the wanted CDS.\n Args: range hashref, begin and end positions of the CDS, $proximity\n $proximity holds the maximum distance between the extremes of the CDS\n and of the feature under exam.\n Returns: boolean","parameters":[{"label":"$self"},{"label":"$range"},{"label":"$cds_begin"},{"label":"$cds_end"},{"label":"$proximity"}]},"containerName":"main::","definition":"sub","line":842,"children":[{"localvar":"my","containerName":"_checkfeatureproximity","name":"$self","definition":"my","line":843,"kind":13},{"line":843,"kind":13,"name":"$range","containerName":"_checkfeatureproximity"},{"line":843,"kind":13,"name":"$cds_begin","containerName":"_checkfeatureproximity"},{"kind":13,"line":843,"name":"$cds_end","containerName":"_checkfeatureproximity"},{"kind":13,"line":843,"containerName":"_checkfeatureproximity","name":"$proximity"},{"kind":13,"line":844,"containerName":"_checkfeatureproximity","definition":"my","name":"@range","localvar":"my"},{"line":844,"kind":13,"containerName":"_checkfeatureproximity","name":"$range"}],"kind":12,"range":{"end":{"line":844,"character":9999},"start":{"line":842,"character":0}},"name":"_checkfeatureproximity"},{"localvar":"my","name":"$begin","definition":"my","containerName":null,"line":845,"kind":13},{"kind":13,"line":845,"containerName":null,"name":"$end"},{"line":845,"kind":13,"containerName":null,"name":"$strand"},{"line":846,"kind":13,"name":"@range","containerName":null},{"kind":13,"line":847,"name":"$begin","containerName":null},{"kind":13,"line":847,"containerName":null,"name":"$end"},{"line":847,"kind":13,"name":"$strand","containerName":null},{"kind":13,"line":847,"containerName":null,"name":"@range"},{"kind":13,"line":847,"name":"@range","containerName":null},{"kind":13,"line":847,"containerName":null,"name":"@range"},{"name":"$begin","containerName":null,"line":849,"kind":13},{"kind":13,"line":849,"name":"$end","containerName":null},{"kind":13,"line":849,"containerName":null,"name":"$strand"},{"kind":13,"line":849,"containerName":null,"name":"@range"},{"name":"$cds_begin","containerName":null,"kind":13,"line":851},{"kind":13,"line":851,"name":"%cds_end","containerName":null},{"kind":13,"line":852,"name":"$cds_begin","containerName":null},{"containerName":null,"name":"$cds_end","kind":13,"line":852},{"name":"$cds_end","containerName":null,"kind":13,"line":852},{"containerName":null,"name":"$cds_begin","kind":13,"line":852},{"containerName":null,"name":"%strand","kind":13,"line":854},{"line":855,"kind":13,"containerName":null,"name":"$begin"},{"containerName":null,"name":"$end","line":855,"kind":13},{"kind":13,"line":855,"name":"$end","containerName":null},{"kind":13,"line":855,"containerName":null,"name":"$begin"},{"containerName":null,"name":"$cds_begin","kind":13,"line":857},{"name":"$end","containerName":null,"kind":13,"line":857},{"kind":13,"line":857,"containerName":null,"name":"%proximity"},{"name":"carp","kind":12,"line":858},{"kind":13,"line":861,"name":"$begin","containerName":null},{"name":"$cds_end","containerName":null,"kind":13,"line":861},{"line":861,"kind":13,"containerName":null,"name":"%proximity"},{"name":"carp","line":862,"kind":12},{"name":"carp","kind":12,"line":865},{"name":"_get_alignment","range":{"end":{"character":9999,"line":895},"start":{"line":874,"character":0}},"kind":12,"line":874,"children":[{"localvar":"my","containerName":"_get_alignment","definition":"my","name":"$self","line":875,"kind":13},{"kind":13,"line":875,"name":"$seq1","containerName":"_get_alignment"},{"kind":13,"line":875,"containerName":"_get_alignment","name":"$seq2"},{"definition":"my","name":"$fastafile1","containerName":"_get_alignment","localvar":"my","kind":13,"line":876},{"localvar":"my","containerName":"_get_alignment","name":"$fastafile2","definition":"my","line":877,"kind":13},{"localvar":"my","definition":"my","name":"$grepcut","containerName":"_get_alignment","line":878,"kind":13},{"line":879,"kind":13,"localvar":"my","name":"$alignprogram","definition":"my","containerName":"_get_alignment"},{"kind":13,"line":880,"containerName":"_get_alignment","name":"$TMPFASTAFILE1","definition":"my","localvar":"my"},{"line":881,"kind":13,"localvar":"my","containerName":"_get_alignment","definition":"my","name":"$TMPFASTAFILE2"},{"name":"$TMPFASTAFILE1","containerName":"_get_alignment","line":882,"kind":13},{"containerName":"_get_alignment","name":"$TMPFASTAFILE2","kind":13,"line":883},{"kind":13,"line":884,"name":"$TMPFASTAFILE1","containerName":"_get_alignment"},{"name":"$TMPFASTAFILE2","containerName":"_get_alignment","line":885,"kind":13},{"line":886,"kind":13,"localvar":"my","containerName":"_get_alignment","name":"$alignment","definition":"my"},{"line":887,"kind":13,"localvar":"my","containerName":"_get_alignment","definition":"my","name":"@alignlines"},{"line":887,"kind":13,"containerName":"_get_alignment","name":"$alignment"},{"kind":13,"line":888,"definition":"my","name":"$linecount","containerName":"_get_alignment","localvar":"my"},{"name":"$seq1_aligned","containerName":"_get_alignment","kind":13,"line":888},{"containerName":"_get_alignment","name":"$seq2_aligned","line":888,"kind":13},{"name":"$codes","containerName":"_get_alignment","kind":13,"line":888},{"kind":13,"line":889,"containerName":"_get_alignment","name":"$linecount"},{"kind":13,"line":889,"name":"$linecount","containerName":"_get_alignment"},{"name":"@alignlines","containerName":"_get_alignment","kind":13,"line":889},{"name":"$linecount","containerName":"_get_alignment","line":889,"kind":13},{"kind":13,"line":890,"containerName":"_get_alignment","name":"$seq1_aligned"},{"kind":13,"line":890,"containerName":"_get_alignment","name":"$alignlines"},{"kind":13,"line":890,"name":"$linecount","containerName":"_get_alignment"},{"line":891,"kind":13,"containerName":"_get_alignment","name":"$codes"},{"line":891,"kind":13,"name":"$alignlines","containerName":"_get_alignment"},{"kind":13,"line":891,"containerName":"_get_alignment","name":"$linecount"},{"kind":13,"line":892,"containerName":"_get_alignment","name":"$seq2_aligned"},{"line":892,"kind":13,"containerName":"_get_alignment","name":"$alignlines"},{"kind":13,"line":892,"containerName":"_get_alignment","name":"$linecount"},{"containerName":"_get_alignment","name":"$seq1_aligned","line":894,"kind":13},{"kind":13,"line":894,"name":"$seq2_aligned","containerName":"_get_alignment"},{"kind":13,"line":894,"name":"$codes","containerName":"_get_alignment"}],"containerName":"main::","definition":"sub","detail":"($self,$seq1,$seq2)","signature":{"label":"_get_alignment($self,$seq1,$seq2)","parameters":[{"label":"$self"},{"label":"$seq1"},{"label":"$seq2"}],"documentation":" function that calls the external program \"align\" (on the fasta2 package)\n to create an alignment between two sequences, returning the aligned\n strings and the codes for the identity (:: ::::)"}},{"name":"croak","line":880,"kind":12},{"name":"croak","kind":12,"line":881},{"name":"_common_novelaasequence2gene","range":{"start":{"character":0,"line":900},"end":{"character":9999,"line":902}},"containerName":"main::","definition":"sub","detail":"($species_codon_usage,$ttabid,$aasequence,$gene_name)","signature":{"label":"_common_novelaasequence2gene($species_codon_usage,$ttabid,$aasequence,$gene_name)","documentation":" common part of the function to create a novel liveseq gene structure\n from an amino acid sequence, using codon usage frequencies\n args: codon_usage_array transltableid aasequence gene_name","parameters":[{"label":"$species_codon_usage"},{"label":"$ttabid"},{"label":"$aasequence"},{"label":"$gene_name"}]},"kind":12,"line":900,"children":[{"localvar":"my","containerName":"_common_novelaasequence2gene","name":"$species_codon_usage","definition":"my","line":901,"kind":13},{"name":"$ttabid","containerName":"_common_novelaasequence2gene","line":901,"kind":13},{"containerName":"_common_novelaasequence2gene","name":"$aasequence","kind":13,"line":901},{"name":"$gene_name","containerName":"_common_novelaasequence2gene","kind":13,"line":901},{"kind":13,"line":902,"definition":"my","name":"@species_codon_usage","containerName":"_common_novelaasequence2gene","localvar":"my"},{"containerName":"_common_novelaasequence2gene","name":"$species_codon_usage","line":902,"kind":13}]},{"containerName":null,"name":"@codon_usage_label","definition":"my","localvar":"my","kind":13,"line":903},{"line":909,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":null},{"containerName":null,"name":"$j","line":909,"kind":13},{"line":910,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%codon_usage_value"},{"line":911,"kind":13,"localvar":"my","containerName":null,"name":"$aa_codon_total","definition":"my"},{"name":"$i","containerName":null,"kind":13,"line":912},{"line":912,"kind":13,"name":"$i","containerName":null},{"kind":13,"line":912,"name":"%i","containerName":null},{"name":"%codon_usage_value","containerName":null,"kind":13,"line":913},{"containerName":null,"name":"@codon_usage_label","line":913,"kind":13},{"name":"$i","containerName":null,"line":913,"kind":13},{"name":"@species_codon_usage","containerName":null,"kind":13,"line":913},{"kind":13,"line":913,"containerName":null,"name":"$i"},{"containerName":null,"name":"$CodonTable","definition":"my","localvar":"my","kind":13,"line":916},{"name":"Bio","containerName":"Tools::CodonTable","kind":12,"line":916},{"name":"new","containerName":"main::","line":916,"kind":12},{"kind":13,"line":916,"name":"$ttabid","containerName":null},{"line":917,"kind":13,"localvar":"my","containerName":null,"name":"@aminoacids","definition":"my"},{"name":"$aasequence","containerName":null,"kind":13,"line":917},{"containerName":null,"name":"@alt_codons","definition":"my","localvar":"my","kind":13,"line":918},{"localvar":"my","containerName":null,"definition":"my","name":"$relativeusage","line":918,"kind":13},{"line":918,"kind":13,"containerName":null,"name":"$dnasequence"},{"containerName":null,"name":"$chosen_codon","kind":13,"line":918},{"name":"$dice","containerName":null,"line":918,"kind":13},{"containerName":null,"name":"$partial","kind":13,"line":918},{"name":"$thiscodon","containerName":null,"kind":13,"line":918},{"name":"$i","containerName":null,"line":919,"kind":13},{"name":"@aminoacids","containerName":null,"line":919,"kind":13},{"name":"@alt_codons","containerName":null,"kind":13,"line":920},{"line":920,"kind":13,"containerName":null,"name":"$CodonTable"},{"name":"revtranslate","containerName":"main::","line":920,"kind":12},{"containerName":null,"name":"$i","kind":13,"line":920},{"name":"@alt_codons","containerName":null,"line":921,"kind":13},{"name":"carp","line":922,"kind":12},{"kind":13,"line":923,"name":"%dnasequence","containerName":null},{"line":925,"kind":13,"name":"$aa_codon_total","containerName":null},{"containerName":null,"name":"$j","line":926,"kind":13},{"line":926,"kind":13,"containerName":null,"name":"@alt_codons"},{"containerName":null,"name":"$aa_codon_total","kind":13,"line":927},{"containerName":null,"name":"%codon_usage_value","kind":13,"line":927},{"kind":13,"line":927,"containerName":null,"name":"$j"},{"name":"$dice","containerName":null,"line":936,"kind":13},{"line":938,"kind":13,"name":"$partial","containerName":null},{"containerName":null,"name":"$chosen_codon","kind":13,"line":939},{"kind":12,"line":940,"name":"CODONCHOICE"},{"containerName":null,"name":"$j","line":941,"kind":13},{"kind":13,"line":941,"name":"@alt_codons","containerName":null},{"name":"$thiscodon","containerName":null,"kind":13,"line":942},{"line":942,"kind":13,"name":"@alt_codons","containerName":null},{"name":"$j","containerName":null,"line":942,"kind":13},{"name":"$relativeusage","containerName":null,"line":943,"kind":13},{"line":943,"kind":13,"containerName":null,"name":"%codon_usage_value"},{"name":"$thiscodon","containerName":null,"line":943,"kind":13},{"kind":13,"line":943,"name":"$aa_codon_total","containerName":null},{"line":944,"kind":13,"name":"$dice","containerName":null},{"kind":13,"line":944,"containerName":null,"name":"$relativeusage"},{"containerName":null,"name":"%partial","kind":13,"line":944},{"line":945,"kind":13,"containerName":null,"name":"$chosen_codon"},{"kind":13,"line":945,"containerName":null,"name":"$thiscodon"},{"line":946,"kind":12,"name":"CODONCHOICE"},{"line":948,"kind":13,"containerName":null,"name":"$partial"},{"containerName":null,"name":"$relativeusage","line":948,"kind":13},{"line":951,"kind":13,"name":"%chosen_codon","containerName":null},{"name":"$chosen_codon","containerName":null,"line":952,"kind":13},{"kind":13,"line":952,"name":"@alt_codons","containerName":null},{"line":955,"kind":13,"containerName":null,"name":"$dnasequence"},{"kind":13,"line":955,"containerName":null,"name":"$chosen_codon"},{"line":959,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$dna"},{"containerName":"LiveSeq::DNA","name":"Bio","line":959,"kind":12},{"containerName":"main::","name":"new","line":959,"kind":12},{"name":"$dnasequence","containerName":null,"kind":13,"line":959},{"localvar":"my","name":"$min","definition":"my","containerName":null,"line":960,"kind":13},{"kind":13,"line":961,"name":"$max","definition":"my","containerName":null,"localvar":"my"},{"containerName":null,"name":"$dnasequence","line":961,"kind":13},{"containerName":null,"name":"$exon","definition":"my","localvar":"my","kind":13,"line":962},{"name":"Bio","containerName":"LiveSeq::Exon","kind":12,"line":962},{"containerName":"main::","name":"new","line":962,"kind":12},{"line":962,"kind":13,"containerName":null,"name":"$dna"},{"line":962,"kind":13,"name":"$min","containerName":null},{"line":962,"kind":13,"name":"$max","containerName":null},{"localvar":"my","containerName":null,"definition":"my","name":"@exons","line":963,"kind":13},{"kind":13,"line":963,"name":"$exon","containerName":null},{"line":964,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$transcript"},{"kind":12,"line":964,"name":"Bio","containerName":"LiveSeq::Transcript"},{"kind":12,"line":964,"containerName":"main::","name":"new"},{"containerName":null,"name":"@exons","kind":13,"line":964},{"kind":13,"line":965,"name":"$transcript","containerName":null},{"line":965,"kind":12,"name":"translation_table","containerName":"main::"},{"containerName":null,"name":"$ttabid","line":965,"kind":13},{"localvar":"my","name":"@transcripts","definition":"my","containerName":null,"line":966,"kind":13},{"line":966,"kind":13,"containerName":null,"name":"$transcript"},{"localvar":"my","definition":"my","name":"$translation","containerName":null,"line":967,"kind":13},{"containerName":"LiveSeq::Translation","name":"Bio","line":967,"kind":12},{"name":"new","containerName":"main::","kind":12,"line":967},{"containerName":null,"name":"$transcript","kind":13,"line":967},{"kind":13,"line":968,"containerName":null,"definition":"my","name":"@translations","localvar":"my"},{"line":968,"kind":13,"containerName":null,"name":"$translation"},{"localvar":"my","name":"%features","definition":"my","containerName":null,"line":969,"kind":13},{"line":969,"kind":12,"name":"DNA"},{"name":"$dna","containerName":null,"kind":13,"line":969},{"name":"Transcripts","kind":12,"line":969},{"containerName":null,"name":"@transcripts","kind":13,"line":969},{"kind":12,"line":969,"name":"Translations"},{"name":"@translations","containerName":null,"line":969,"kind":13},{"line":970,"kind":13,"localvar":"my","containerName":null,"name":"$gene","definition":"my"},{"containerName":"LiveSeq::Gene","name":"Bio","kind":12,"line":970},{"name":"new","containerName":"main::","line":970,"kind":12},{"name":"$gene_name","containerName":null,"kind":13,"line":970},{"name":"%features","containerName":null,"line":970,"kind":13},{"kind":13,"line":970,"name":"$min","containerName":null},{"line":970,"kind":13,"name":"$max","containerName":null},{"name":"%gene","containerName":null,"line":973,"kind":13},{"kind":12,"line":974,"name":"carp"},{"line":977,"kind":13,"name":"$gene","containerName":null}],"version":5}