{"version":5,"vars":[{"line":87,"kind":2,"containerName":"","name":"Carp"},{"line":88,"kind":2,"name":"vars","containerName":""},{"line":95,"kind":13,"containerName":null,"name":"$DBEMBLLOADED"},{"line":95,"kind":2,"containerName":"Bio::SeqIO::Bio::DB","name":"EMBL"},{"kind":2,"line":99,"name":"base","containerName":""},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: BioPerl.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::BioPerl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::BioPerl - Loader for LiveSeq from EMBL entries with BioPerl\n\n=head1 SYNOPSIS\n\n  my $db=\"EMBL\";\n  my $file=\"../data/M20132\";\n  my $id=\"HSANDREC\";\n\n  my $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"$db\", -file=>\"$file\");\n  #                      or\n  my $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"$db\", -id=>\"$id\");\n\n  my @translationobjects=$loader->entry2liveseq();\n\n  my $genename=\"AR\";\n  my $gene=$loader->gene2liveseq(-gene_name => \"$genename\",\n                                    -getswissprotinfo => 0);\n\n  #NOTE1: The only -db now supported is EMBL. Hence it defaults to EMBL.\n  #NOTE2: -file requires a filename (and path if necessary) containing an\n  #             EMBL entry\n  #       -id will use Bio::DB::EMBL.pm to fetch the sequence from the web,\n  #             (bioperl wraparound to [w]getz from SRS)\n  #NOTE3: To retrieve the swissprot (if possible) attached to the embl entry\n  #             (to get protein domains at dna level), only Bio::DB::EMBL.pm\n  #             is supported under BioPerl. Refer to Bio::LiveSeq::IO::SRS\n  #             otherwise.\n  #NOTE4: NOTE3 is not implemented yet for bioperl, working on it\n\n\n=head1 DESCRIPTION\n\nThis package uses BioPerl (SeqIO) to fetch a sequence database entry,\nanalyse it and create LiveSeq objects out of it.\n\nA filename (or an ID that will fetch entry through the web) has to be passed\nto this package which will return references to all translation objects\ncreated from the EMBL entry. References to Transcription, DNA and Exon\nobjects can all be retrieved departing from these.\n\nAlternatively, a specific \"gene\" name can be specified, together with\nthe embl-acc ID. This will create a LiveSeq::Gene object with all\nrelevant gene features attached/created.\n\nATTENTION: if web fetching is requested, the package HTTP::Request needs\nto be installed.\n\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::BioPerl;\n\n# TODO->TOCHECK\n# each_secondary_access not working\n# why array from each_tag_value($qual) ? When will there be more than one\n#                                        element in such array?\n# what is the annotation object? ($seqobj->annotation)\n# unsatisfied by both BioPerl binomial and SRS \"org\" to retrieve Organism info\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse vars qw($DBEMBLLOADED);\nuse Bio::SeqIO; # for -file entry loading\n\n# Note, the following requires HTTP::Request. If the modules are not installed\n# uncomment the following and use only -filename and don't request swissprotinfo\neval { \n    require Bio::DB::EMBL; # for -id entry loading\n    $DBEMBLLOADED = 1;\n};\n\n\nuse base qw(Bio::LiveSeq::IO::Loader);\n\n# This package can in the future host other databases loading subroutines.\n# e.g. ensembl2hash\n\n=head2 load\n\n  Title   : load\n  Usage   : my $filename=\"../data/M20132\";\n            $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"EMBL\", -file=>\"$filename\");\n                                   or\n            $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"EMBL\", -id=>\"HSANDREC\");\n\n  Function: loads an entry with BioPerl from a database into a hash\n  Returns : reference to a new object of class IO::BioPerl holding an entry\n  Errorcode 0\n  Args    : an filename containing an EMBL entry OR an ID or ACCESSION code","parameters":[{"label":"$thing"},{"label":"%args"}],"label":"load($thing,%args)"},"detail":"($thing,%args)","kind":12,"children":[{"kind":13,"line":120,"containerName":"load","name":"$thing","definition":"my","localvar":"my"},{"containerName":"load","name":"%args","line":120,"kind":13},{"kind":13,"line":121,"containerName":"load","definition":"my","name":"$class","localvar":"my"},{"line":121,"kind":13,"containerName":"load","name":"$thing"},{"kind":13,"line":121,"containerName":"load","name":"$thing"},{"localvar":"my","containerName":"load","name":"$obj","definition":"my","line":122,"kind":13},{"kind":13,"line":122,"containerName":"load","name":"%loader"},{"definition":"my","name":"$db","containerName":"load","localvar":"my","kind":13,"line":124},{"containerName":"load","name":"$filename","line":124,"kind":13},{"line":124,"kind":13,"containerName":"load","name":"$id"},{"kind":13,"line":124,"containerName":"load","name":"$args"},{"containerName":"load","name":"$args","line":124,"kind":13},{"name":"$args","containerName":"load","kind":13,"line":124},{"name":"$db","containerName":"load","line":126,"kind":13},{"name":"$db","containerName":"load","line":127,"kind":13},{"containerName":"load","name":"$db","line":132,"kind":13},{"kind":13,"line":135,"containerName":"load","name":"$id"},{"name":"$filename","containerName":"load","line":135,"kind":13},{"containerName":"load","name":"$id","kind":13,"line":140},{"containerName":"load","name":"$filename","kind":13,"line":140},{"localvar":"my","name":"$hashref","definition":"my","containerName":"load","line":145,"kind":13},{"name":"$db","containerName":"load","line":146,"kind":13},{"localvar":"my","containerName":"load","name":"$test_transl","definition":"my","line":147,"kind":13},{"localvar":"my","containerName":"load","definition":"my","name":"@embl_valid_feature_names","line":150,"kind":13},{"line":151,"kind":13,"localvar":"my","containerName":"load","definition":"my","name":"@embl_valid_qual_names"},{"kind":13,"line":155,"containerName":"load","name":"$test_transl"},{"line":156,"kind":13,"containerName":"load","name":"@embl_valid_qual_names"},{"line":159,"kind":13,"localvar":"my","definition":"my","name":"$seqobj","containerName":"load"},{"line":161,"kind":13,"name":"$filename","containerName":"load"},{"localvar":"my","definition":"my","name":"$stream","containerName":"load","line":162,"kind":13},{"containerName":"load","name":"new","line":162,"kind":12},{"kind":13,"line":162,"containerName":"load","name":"$filename"},{"kind":13,"line":163,"containerName":"load","name":"$seqobj"},{"containerName":"load","name":"$stream","kind":13,"line":163},{"containerName":"load","name":"next_seq","line":163,"kind":12},{"line":166,"kind":13,"name":"$DBEMBLLOADED","containerName":"load"},{"containerName":"load","definition":"my","name":"$embl","localvar":"my","kind":13,"line":167},{"name":"new","containerName":"load","kind":12,"line":167},{"name":"$seqobj","containerName":"load","kind":13,"line":168},{"containerName":"load","name":"$embl","kind":13,"line":168},{"line":168,"kind":12,"containerName":"load","name":"get_Seq_by_id"},{"kind":13,"line":168,"name":"$id","containerName":"load"},{"kind":13,"line":170,"name":"$root","definition":"my","containerName":"load","localvar":"my"},{"line":170,"kind":12,"name":"new","containerName":"load"},{"kind":13,"line":171,"containerName":"load","name":"$root"},{"containerName":"load","name":"warn","line":171,"kind":12},{"containerName":"load","name":"$hashref","kind":13,"line":176},{"line":176,"kind":13,"name":"$seqobj","containerName":"load"},{"name":"@embl_valid_feature_names","containerName":"load","kind":13,"line":176},{"containerName":"load","name":"@embl_valid_qual_names","kind":13,"line":176},{"line":178,"kind":13,"name":"$hashref","containerName":"load"},{"name":"%loader","containerName":"load","line":180,"kind":13},{"kind":13,"line":180,"containerName":"load","name":"$db"},{"containerName":"load","name":"$filename","kind":13,"line":180},{"kind":13,"line":180,"containerName":"load","name":"$id"},{"line":180,"kind":13,"containerName":"load","name":"$hashref"},{"containerName":"load","name":"$obj","kind":13,"line":181},{"containerName":"load","name":"%loader","line":181,"kind":13},{"name":"$obj","containerName":"load","line":182,"kind":13},{"kind":13,"line":182,"containerName":"load","name":"$obj"},{"kind":13,"line":182,"name":"$class","containerName":"load"},{"kind":13,"line":183,"name":"$obj","containerName":"load"}],"line":119,"name":"load","range":{"end":{"line":184,"character":9999},"start":{"line":119,"character":0}}},{"line":128,"kind":12,"name":"carp"},{"name":"carp","kind":12,"line":136},{"name":"carp","line":141,"kind":12},{"line":162,"kind":12,"name":"Bio","containerName":"SeqIO"},{"containerName":"DB::EMBL","name":"Bio","kind":12,"line":167},{"name":"Bio","containerName":"Root::Root","line":170,"kind":12},{"name":"embl2hash","line":176,"kind":12},{"name":"db","kind":12,"line":180},{"line":180,"kind":12,"name":"filename"},{"name":"id","line":180,"kind":12},{"name":"hash","line":180,"kind":12},{"line":207,"children":[{"localvar":"my","containerName":"embl2hash","definition":"my","name":"$seqobj","line":208,"kind":13},{"line":209,"kind":13,"localvar":"my","containerName":"embl2hash","name":"%valid_features","definition":"my"},{"kind":13,"line":209,"name":"%valid_names","definition":"my","containerName":"embl2hash","localvar":"my"},{"line":211,"kind":13,"containerName":"embl2hash","name":"%valid_features"}],"kind":12,"range":{"end":{"line":212,"character":9999},"start":{"line":207,"character":0}},"containerName":"main::","name":"embl2hash","definition":"sub"},{"containerName":null,"name":"%valid_names","kind":13,"line":214},{"kind":13,"line":217,"definition":"my","name":"$annobj","containerName":null,"localvar":"my"},{"name":"$seqobj","containerName":null,"kind":13,"line":217},{"kind":12,"line":217,"name":"annotation","containerName":"main::"},{"localvar":"my","containerName":null,"definition":"my","name":"$entry_Sequence","line":219,"kind":13},{"line":219,"kind":13,"name":"$seqobj","containerName":null},{"containerName":"main::","name":"seq","kind":12,"line":219},{"containerName":null,"definition":"my","name":"$entry_ID","localvar":"my","kind":13,"line":221},{"name":"$seqobj","containerName":null,"kind":13,"line":221},{"line":221,"kind":12,"name":"display_id","containerName":"main::"},{"line":222,"kind":13,"localvar":"my","name":"$entry_AccNumber","definition":"my","containerName":null},{"line":222,"kind":13,"containerName":null,"name":"$seqobj"},{"containerName":"main::","name":"accession","kind":12,"line":222},{"localvar":"my","containerName":null,"definition":"my","name":"$secondary_acc","line":223,"kind":13},{"containerName":null,"name":"$secondary_acc","line":224,"kind":13},{"kind":13,"line":224,"name":"$seqobj","containerName":null},{"containerName":"main::","name":"get_secondary_accessions","line":224,"kind":12},{"line":225,"kind":13,"name":"$entry_AccNumber","containerName":null},{"line":227,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$entry_Molecule"},{"line":227,"kind":13,"name":"$seqobj","containerName":null},{"line":227,"kind":12,"name":"molecule","containerName":"main::"},{"localvar":"my","definition":"my","name":"$entry_Division","containerName":null,"line":228,"kind":13},{"containerName":null,"name":"$seqobj","line":228,"kind":13},{"containerName":"main::","name":"division","line":228,"kind":12},{"line":233,"kind":13,"localvar":"my","name":"$entry_Description","definition":"my","containerName":null},{"name":"$seqobj","containerName":null,"line":233,"kind":13},{"name":"desc","containerName":"main::","line":233,"kind":12},{"name":"$speciesobj","definition":"my","containerName":null,"localvar":"my","kind":13,"line":235},{"containerName":null,"name":"$seqobj","line":235,"kind":13},{"name":"species","containerName":"main::","kind":12,"line":235},{"line":236,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$entry_Organism"},{"containerName":null,"name":"$speciesobj","kind":13,"line":236},{"containerName":"main::","name":"binomial","kind":12,"line":236},{"kind":13,"line":238,"containerName":null,"definition":"my","name":"$entry_SeqLength","localvar":"my"},{"containerName":null,"name":"$seqobj","kind":13,"line":238},{"line":238,"kind":12,"containerName":"main::","name":"length"},{"kind":13,"line":241,"definition":"my","name":"%entryhash","containerName":null,"localvar":"my"},{"line":242,"kind":13,"containerName":null,"name":"%entryhash"},{"line":242,"kind":12,"name":"ID"},{"name":"$entry_ID","containerName":null,"kind":13,"line":242},{"kind":13,"line":243,"name":"%entryhash","containerName":null},{"line":243,"kind":12,"name":"AccNumber"},{"kind":13,"line":243,"containerName":null,"name":"$entry_AccNumber"},{"line":244,"kind":13,"containerName":null,"name":"%entryhash"},{"line":244,"kind":12,"name":"Molecule"},{"containerName":null,"name":"$entry_Molecule","kind":13,"line":244},{"line":245,"kind":13,"name":"%entryhash","containerName":null},{"line":245,"kind":12,"name":"Division"},{"name":"$entry_Division","containerName":null,"kind":13,"line":245},{"kind":13,"line":246,"name":"%entryhash","containerName":null},{"kind":12,"line":246,"name":"Description"},{"line":246,"kind":13,"name":"$entry_Description","containerName":null},{"kind":13,"line":247,"containerName":null,"name":"%entryhash"},{"name":"Organism","line":247,"kind":12},{"kind":13,"line":247,"name":"$entry_Organism","containerName":null},{"containerName":null,"name":"%entryhash","kind":13,"line":248},{"line":248,"kind":12,"name":"Sequence"},{"kind":13,"line":248,"containerName":null,"name":"$entry_Sequence"},{"kind":13,"line":249,"containerName":null,"name":"%entryhash"},{"name":"SeqLength","line":249,"kind":12},{"containerName":null,"name":"$entry_SeqLength","kind":13,"line":249},{"localvar":"my","containerName":null,"name":"@topfeatures","definition":"my","line":251,"kind":13},{"kind":13,"line":251,"name":"$seqobj","containerName":null},{"containerName":"main::","name":"top_SeqFeatures","kind":12,"line":251},{"line":253,"kind":13,"localvar":"my","containerName":null,"name":"$featuresnumber","definition":"my"},{"line":253,"kind":13,"containerName":null,"name":"@topfeatures"},{"line":254,"kind":13,"name":"%entryhash","containerName":null},{"kind":12,"line":254,"name":"FeaturesNumber"},{"line":254,"kind":13,"name":"$featuresnumber","containerName":null},{"containerName":null,"name":"$feature_name","definition":"my","localvar":"my","kind":13,"line":255},{"containerName":null,"definition":"my","name":"@feature_qual_names","localvar":"my","kind":13,"line":256},{"localvar":"my","definition":"my","name":"@feature_qual_value","containerName":null,"line":256,"kind":13},{"line":257,"kind":13,"localvar":"my","definition":"my","name":"$feature_qual_name","containerName":null},{"containerName":null,"name":"$feature_qual_number","kind":13,"line":257},{"containerName":null,"definition":"my","name":"@features","localvar":"my","kind":13,"line":258},{"localvar":"my","name":"$feat","definition":"my","containerName":null,"line":260,"kind":13},{"name":"$qual","containerName":null,"line":260,"kind":13},{"name":"$subfeat","containerName":null,"kind":13,"line":260},{"line":261,"kind":13,"localvar":"my","containerName":null,"name":"@subfeat","definition":"my"},{"line":262,"kind":13,"localvar":"my","definition":"my","name":"$i","containerName":null},{"containerName":null,"name":"$feat","kind":13,"line":263},{"containerName":null,"name":"@topfeatures","line":263,"kind":13},{"line":264,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"%feature"},{"name":"$feature_name","containerName":null,"kind":13,"line":265},{"kind":13,"line":265,"name":"$feat","containerName":null},{"line":265,"kind":12,"containerName":"main::","name":"primary_tag"},{"line":266,"kind":13,"containerName":null,"name":"%valid_features"},{"kind":13,"line":266,"name":"%feature_name","containerName":null},{"kind":13,"line":273,"containerName":null,"definition":"my","name":"$featlocation","localvar":"my"},{"kind":13,"line":273,"name":"$feat","containerName":null},{"kind":12,"line":273,"name":"location","containerName":"main::"},{"kind":13,"line":274,"containerName":null,"name":"$feature_name"},{"kind":13,"line":274,"name":"$featlocation","containerName":null},{"containerName":"main::","name":"isa","kind":12,"line":274},{"name":"@subfeat","containerName":null,"line":276,"kind":13},{"containerName":null,"name":"$featlocation","kind":13,"line":276},{"line":276,"kind":12,"name":"sub_Location","containerName":"main::"},{"localvar":"my","name":"@transcript","definition":"my","containerName":null,"line":277,"kind":13},{"containerName":null,"name":"$subfeat","kind":13,"line":278},{"containerName":null,"name":"@subfeat","kind":13,"line":278},{"localvar":"my","containerName":null,"name":"@range","definition":"my","line":279,"kind":13},{"line":280,"kind":13,"containerName":null,"name":"$subfeat"},{"line":280,"kind":12,"containerName":"main::","name":"strand"},{"kind":13,"line":281,"name":"@range","containerName":null},{"line":281,"kind":13,"containerName":null,"name":"$subfeat"},{"line":281,"kind":12,"name":"end","containerName":"main::"},{"containerName":null,"name":"$subfeat","kind":13,"line":281},{"kind":12,"line":281,"name":"start","containerName":"main::"},{"containerName":null,"name":"$subfeat","line":281,"kind":13},{"kind":12,"line":281,"name":"strand","containerName":"main::"},{"line":283,"kind":13,"containerName":null,"name":"@range"},{"kind":13,"line":283,"containerName":null,"name":"$subfeat"},{"containerName":"main::","name":"start","kind":12,"line":283},{"name":"$subfeat","containerName":null,"kind":13,"line":283},{"containerName":"main::","name":"end","line":283,"kind":12},{"kind":13,"line":283,"name":"$subfeat","containerName":null},{"kind":12,"line":283,"containerName":"main::","name":"strand"},{"containerName":null,"name":"@transcript","line":285,"kind":13},{"kind":13,"line":285,"containerName":null,"name":"@range"},{"containerName":null,"name":"%feature","line":287,"kind":13},{"kind":12,"line":287,"name":"range"},{"kind":13,"line":287,"containerName":null,"name":"@transcript"},{"kind":13,"line":289,"definition":"my","name":"@range","containerName":null,"localvar":"my"},{"kind":13,"line":290,"containerName":null,"name":"$feat"},{"line":290,"kind":12,"name":"strand","containerName":"main::"},{"kind":13,"line":290,"name":"@range","containerName":null},{"line":290,"kind":13,"name":"$feat","containerName":null},{"containerName":"main::","name":"end","line":290,"kind":12},{"line":290,"kind":13,"containerName":null,"name":"$feat"},{"containerName":"main::","name":"start","kind":12,"line":290},{"kind":13,"line":290,"containerName":null,"name":"$feat"},{"name":"strand","containerName":"main::","kind":12,"line":290},{"containerName":null,"name":"@range","line":291,"kind":13},{"name":"$feat","containerName":null,"line":291,"kind":13},{"containerName":"main::","name":"start","line":291,"kind":12},{"name":"$feat","containerName":null,"kind":13,"line":291},{"name":"end","containerName":"main::","line":291,"kind":12},{"kind":13,"line":291,"containerName":null,"name":"$feat"},{"kind":12,"line":291,"containerName":"main::","name":"strand"},{"name":"%feature_name","containerName":null,"kind":13,"line":293},{"line":294,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@transcript"},{"containerName":null,"name":"@range","line":294,"kind":13},{"name":"%feature","containerName":null,"line":295,"kind":13},{"name":"range","line":295,"kind":12},{"kind":13,"line":295,"containerName":null,"name":"@transcript"},{"line":297,"kind":13,"containerName":null,"name":"%feature"},{"line":297,"kind":12,"name":"range"},{"name":"@range","containerName":null,"kind":13,"line":297},{"line":300,"kind":13,"containerName":null,"name":"%feature"},{"name":"location","kind":12,"line":300},{"containerName":null,"name":"%feature","line":302,"kind":13},{"name":"position","kind":12,"line":302},{"line":302,"kind":13,"name":"$i","containerName":null},{"line":303,"kind":13,"name":"%feature","containerName":null},{"kind":12,"line":303,"name":"name"},{"line":303,"kind":13,"name":"$feature_name","containerName":null},{"containerName":null,"name":"@feature_qual_names","line":305,"kind":13},{"name":"$feat","containerName":null,"kind":13,"line":305},{"containerName":"main::","name":"all_tags","kind":12,"line":305},{"name":"$feature_qual_number","containerName":null,"line":306,"kind":13},{"line":306,"kind":13,"containerName":null,"name":"@feature_qual_names"},{"line":308,"kind":13,"containerName":null,"name":"%feature"},{"name":"qual_number","kind":12,"line":308},{"kind":13,"line":308,"name":"$feature_qual_number","containerName":null},{"kind":13,"line":310,"name":"%feature_qualifiers","definition":"my","containerName":null,"localvar":"my"},{"line":311,"kind":13,"containerName":null,"name":"$qual"},{"containerName":null,"name":"@feature_qual_names","kind":13,"line":311},{"line":312,"kind":13,"name":"$feature_qual_name","containerName":null},{"kind":13,"line":312,"containerName":null,"name":"$qual"},{"kind":13,"line":313,"containerName":null,"name":"%valid_names"},{"kind":13,"line":313,"name":"%feature_qual_name","containerName":null},{"line":316,"kind":13,"containerName":null,"name":"@feature_qual_value"},{"containerName":null,"name":"$feat","line":316,"kind":13},{"name":"each_tag_value","containerName":"main::","line":316,"kind":12},{"containerName":null,"name":"$qual","line":316,"kind":13},{"kind":13,"line":318,"containerName":null,"name":"%feature_qualifiers"},{"kind":13,"line":318,"name":"$feature_qual_name","containerName":null},{"name":"@feature_qual_value","containerName":null,"kind":13,"line":318},{"containerName":null,"name":"%feature","line":322,"kind":13},{"name":"qualifiers","line":322,"kind":12},{"kind":13,"line":322,"containerName":null,"name":"%feature_qualifiers"},{"name":"@features","containerName":null,"kind":13,"line":323},{"containerName":null,"name":"%feature","line":323,"kind":13},{"kind":13,"line":324,"name":"$i","containerName":null},{"name":"%entryhash","containerName":null,"kind":13,"line":326},{"name":"Features","kind":12,"line":326},{"name":"@features","containerName":null,"line":326,"kind":13},{"kind":13,"line":328,"containerName":null,"definition":"my","name":"@cds","localvar":"my"},{"line":329,"kind":13,"name":"$i","containerName":null},{"name":"features","line":329,"kind":12},{"line":330,"kind":13,"containerName":null,"name":"@features"},{"name":"%i","containerName":null,"kind":13,"line":330},{"kind":13,"line":331,"name":"@cds","containerName":null},{"kind":13,"line":331,"containerName":null,"name":"@features"},{"name":"$i","containerName":null,"kind":13,"line":331},{"containerName":null,"name":"%entryhash","line":334,"kind":13},{"line":334,"kind":12,"name":"CDS"},{"line":334,"kind":13,"containerName":null,"name":"@cds"},{"name":"%entryhash","containerName":null,"kind":13,"line":335},{"line":365,"children":[{"definition":"my","name":"$self","containerName":"novelaasequence2gene","localvar":"my","kind":13,"line":366},{"kind":13,"line":366,"name":"%args","containerName":"novelaasequence2gene"},{"containerName":"novelaasequence2gene","name":"$gene_name","definition":"my","localvar":"my","kind":13,"line":367},{"name":"$cusg_data","containerName":"novelaasequence2gene","line":367,"kind":13},{"line":367,"kind":13,"name":"$aasequence","containerName":"novelaasequence2gene"},{"kind":13,"line":367,"containerName":"novelaasequence2gene","name":"$ttabid"},{"name":"$args","containerName":"novelaasequence2gene","kind":13,"line":367},{"name":"$args","containerName":"novelaasequence2gene","line":367,"kind":13},{"kind":13,"line":367,"containerName":"novelaasequence2gene","name":"$args"},{"containerName":"novelaasequence2gene","name":"$args","kind":13,"line":367},{"line":369,"kind":13,"localvar":"my","name":"@species_codon_usage","definition":"my","containerName":"novelaasequence2gene"},{"containerName":"novelaasequence2gene","name":"$aasequence","line":370,"kind":13},{"line":374,"kind":13,"containerName":"novelaasequence2gene","name":"$gene_name"},{"kind":13,"line":375,"name":"$gene_name","containerName":"novelaasequence2gene"},{"name":"$ttabid","containerName":"novelaasequence2gene","line":377,"kind":13},{"line":378,"kind":13,"name":"$ttabid","containerName":"novelaasequence2gene"},{"line":380,"kind":13,"containerName":"novelaasequence2gene","name":"$cusg_data"},{"containerName":"novelaasequence2gene","name":"@species_codon_usage","line":381,"kind":13},{"kind":13,"line":391,"containerName":"novelaasequence2gene","name":"@species_codon_usage"},{"name":"$cusg_data","containerName":"novelaasequence2gene","line":391,"kind":13},{"kind":13,"line":394,"containerName":"novelaasequence2gene","definition":"my","name":"$gene","localvar":"my"},{"kind":13,"line":394,"containerName":"novelaasequence2gene","name":"@species_codon_usage"},{"name":"$ttabid","containerName":"novelaasequence2gene","line":394,"kind":13},{"containerName":"novelaasequence2gene","name":"$aasequence","line":394,"kind":13},{"containerName":"novelaasequence2gene","name":"$gene_name","kind":13,"line":394},{"containerName":"novelaasequence2gene","name":"$gene","line":395,"kind":13}],"kind":12,"detail":"($self,%args)","signature":{"label":"novelaasequence2gene($self,%args)","parameters":[{"label":"$self"},{"label":"%args"}],"documentation":"1;\n# $Id: BioPerl.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# bioperl module for Bio::LiveSeq::IO::BioPerl\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Joseph Insana <insana@ebi.ac.uk> <jinsana@gmx.net>\n#\n# Copyright Joseph Insana\n#\n# You may distribute this module under the same terms as perl itself\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::LiveSeq::IO::BioPerl - Loader for LiveSeq from EMBL entries with BioPerl\n\n=head1 SYNOPSIS\n\n  my $db=\"EMBL\";\n  my $file=\"../data/M20132\";\n  my $id=\"HSANDREC\";\n\n  my $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"$db\", -file=>\"$file\");\n  #                      or\n  my $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"$db\", -id=>\"$id\");\n\n  my @translationobjects=$loader->entry2liveseq();\n\n  my $genename=\"AR\";\n  my $gene=$loader->gene2liveseq(-gene_name => \"$genename\",\n                                    -getswissprotinfo => 0);\n\n  #NOTE1: The only -db now supported is EMBL. Hence it defaults to EMBL.\n  #NOTE2: -file requires a filename (and path if necessary) containing an\n  #             EMBL entry\n  #       -id will use Bio::DB::EMBL.pm to fetch the sequence from the web,\n  #             (bioperl wraparound to [w]getz from SRS)\n  #NOTE3: To retrieve the swissprot (if possible) attached to the embl entry\n  #             (to get protein domains at dna level), only Bio::DB::EMBL.pm\n  #             is supported under BioPerl. Refer to Bio::LiveSeq::IO::SRS\n  #             otherwise.\n  #NOTE4: NOTE3 is not implemented yet for bioperl, working on it\n\n\n=head1 DESCRIPTION\n\nThis package uses BioPerl (SeqIO) to fetch a sequence database entry,\nanalyse it and create LiveSeq objects out of it.\n\nA filename (or an ID that will fetch entry through the web) has to be passed\nto this package which will return references to all translation objects\ncreated from the EMBL entry. References to Transcription, DNA and Exon\nobjects can all be retrieved departing from these.\n\nAlternatively, a specific \"gene\" name can be specified, together with\nthe embl-acc ID. This will create a LiveSeq::Gene object with all\nrelevant gene features attached/created.\n\nATTENTION: if web fetching is requested, the package HTTP::Request needs\nto be installed.\n\n\n=head1 AUTHOR - Joseph A.L. Insana\n\nEmail:  Insana@ebi.ac.uk, jinsana@gmx.net\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::LiveSeq::IO::BioPerl;\n\n# TODO->TOCHECK\n# each_secondary_access not working\n# why array from each_tag_value($qual) ? When will there be more than one\n#                                        element in such array?\n# what is the annotation object? ($seqobj->annotation)\n# unsatisfied by both BioPerl binomial and SRS \"org\" to retrieve Organism info\n\nuse strict;\nuse Carp qw(cluck croak carp);\nuse vars qw($DBEMBLLOADED);\nuse Bio::SeqIO; # for -file entry loading\n\n# Note, the following requires HTTP::Request. If the modules are not installed\n# uncomment the following and use only -filename and don't request swissprotinfo\neval { \n    require Bio::DB::EMBL; # for -id entry loading\n    $DBEMBLLOADED = 1;\n};\n\n\nuse base qw(Bio::LiveSeq::IO::Loader);\n\n# This package can in the future host other databases loading subroutines.\n# e.g. ensembl2hash\n\n=head2 load\n\n  Title   : load\n  Usage   : my $filename=\"../data/M20132\";\n            $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"EMBL\", -file=>\"$filename\");\n                                   or\n            $loader=Bio::LiveSeq::IO::BioPerl->load(-db=>\"EMBL\", -id=>\"HSANDREC\");\n\n  Function: loads an entry with BioPerl from a database into a hash\n  Returns : reference to a new object of class IO::BioPerl holding an entry\n  Errorcode 0\n  Args    : an filename containing an EMBL entry OR an ID or ACCESSION code\n\n\nsub load {\n  my ($thing, %args) = @_;\n  my $class = ref($thing) || $thing;\n  my ($obj,%loader);\n\n  my ($db,$filename,$id)=($args{-db},$args{-file},$args{-id});\n\n  if (defined($db)) {\n    unless ($db eq \"EMBL\") {\n      carp \"Note: only EMBL now supported!\";\n      return(0);\n    }\n  } else {\n    $db=\"EMBL\";\n  }\n\n  if (defined($id) && defined($filename)) {\n    carp \"You can either specify a -id or a -filename!\";\n    return(0);\n  }\n\n  unless (defined($id) || defined($filename)) {\n    carp \"You must specify either a -id or a -filename!\";\n    return(0);\n  }\n\n  my $hashref;\n  if ($db eq \"EMBL\") {\n    my $test_transl=0; # change to 0 to avoid comparison of translation\n\n    # these can be changed for future needs\n    my @embl_valid_feature_names=qw(CDS CDS_span exon prim_transcript intron repeat_unit repeat_region mRNA);\n    my @embl_valid_qual_names=qw(gene codon_start db_xref product note number rpt_family transl_table);\n\n    # dunno yet how to implement test_transl again....\n    # probably on a one-on-one basis with each translation?\n    if ($test_transl) {\n      push (@embl_valid_qual_names,\"translation\"); # needed for test_transl\n    }\n\n    my $seqobj; # bioperl sequence object, to be passed to embl2hash\n\n    if (defined($filename)) {\n      my $stream = Bio::SeqIO->new('-file' => $filename, '-format' => 'EMBL');\n      $seqobj = $stream->next_seq();\n    } else { # i.e. if -id\n\t\n\tif( $DBEMBLLOADED ) {\n\t    my $embl = Bio::DB::EMBL->new();\n\t    $seqobj = $embl->get_Seq_by_id($id); # EMBL ID or ACC\n\t} else { \n\t    my $root = Bio::Root::Root->new();\n\t    $root->warn(\"Must have HTTP::Request::Common installed, cannot run load without the -filename option specified, see docs for Bio::LiveSeq::IO::BioPerl\");\n\t    return;\n\t}\n    }\n\n    $hashref=&embl2hash($seqobj,\\@embl_valid_feature_names,\\@embl_valid_qual_names);\n  }\n  unless ($hashref) { return (0); }\n\n  %loader = (db => $db, filename => $filename, id => $id, hash => $hashref);\n  $obj = \\%loader;\n  $obj = bless $obj, $class;\n  return $obj;\n}\n\n=head2 embl2hash\n\n  Title   : embl2hash\n  Function: retrieves with BioPerl an EMBL entry, parses it and creates\n            a hash that contains all the information.\n  Returns : a reference to a hash\n  Errorcode: 0\n  Args    : a BioPerl Sequence Object (from file or web fetching)\n\t    two array references to skip features and qualifiers (for\n\t    performance)\n  Example: @valid_features=qw(CDS exon prim_transcript mRNA);\n           @valid_qualifiers=qw(gene codon_start db_xref product rpt_family);\n           $hashref=&embl2hash($seqobj,\\@valid_features,\\@valid_qualifiers);\n\n\n# arguments: Bioperl $seqobj\n# to skip features and qualifiers (for performance), two array\n# references must be passed (this can change into string arguments to\n# be passed....)\n# returns: a reference to a hash containing the important features requested\nsub embl2hash {\n  my $seqobj=$_[0];\n  my %valid_features; my %valid_names;\n  if ($_[1]) {\n    %valid_features = map {$_, 1} @{$_[1]}; # to skip features\n  }\n  if ($_[2]) {\n    %valid_names = map {$_, 1} @{$_[2]}; # to skip qualifiers\n  }\n\n  my $annobj = $seqobj->annotation(); # what's this?\n\n  my $entry_Sequence = lc($seqobj->seq()); # SRS returns lowercase\n\n  my $entry_ID = $seqobj->display_id;\n  my $entry_AccNumber = $seqobj->accession; # or maybe accession_number ?\n  my $secondary_acc; # to fetch the other acc numbers\n  foreach $secondary_acc ($seqobj->get_secondary_accessions) { # not working!\n    $entry_AccNumber .= \" $secondary_acc\";\n  }\n  my $entry_Molecule = $seqobj->molecule; # this alone returns molec+division\n  my $entry_Division = $seqobj->division;\n  # fixed: now Molecule works in BioPerl, no need for next lines\n  #my @Molecule=split(\" \",$entry_Molecule);\n  #my $entry_Division = pop(@Molecule); # only division\n  #$entry_Molecule = join(\" \",@Molecule); # only molecule\n  my $entry_Description = $seqobj->desc;\n\n  my $speciesobj = $seqobj->species;\n  my $entry_Organism = $speciesobj->binomial;\n\n  my $entry_SeqLength = $seqobj->length;\n  \n  # put into the hash\n  my %entryhash;\n  $entryhash{ID}=$entry_ID;\n  $entryhash{AccNumber}=$entry_AccNumber;\n  $entryhash{Molecule}=$entry_Molecule;\n  $entryhash{Division}=$entry_Division;\n  $entryhash{Description}=$entry_Description;\n  $entryhash{Organism}=$entry_Organism;\n  $entryhash{Sequence}=$entry_Sequence;\n  $entryhash{SeqLength}=$entry_SeqLength;\n\n  my @topfeatures=$seqobj->top_SeqFeatures();\n  # create features array\n  my $featuresnumber= scalar(@topfeatures);\n  $entryhash{FeaturesNumber}=$featuresnumber;\n  my $feature_name;\n  my @feature_qual_names; my @feature_qual_value;\n  my ($feature_qual_name,$feature_qual_number);\n  my @features;\n\n  my ($feat,$qual,$subfeat);\n  my @subfeat;\n  my $i=0;\n  foreach $feat (@topfeatures) {\n      my %feature;\n      $feature_name = $feat->primary_tag;\n      unless ($valid_features{$feature_name}) {\n\t  #print \"skipping $feature_name\\n\";\n\t  next;\n      }\n# works ok with 0.6.2\n#    if ($feature_name eq \"CDS_span\") { # case of CDS with various exons 0.6.2\n#      $feature_name=\"CDS\"; # 0.6.2\n      my $featlocation=$feat->location; # 0.7\n      if (($feature_name eq \"CDS\")&&($featlocation->isa('Bio::Location::SplitLocationI'))) { # case of CDS with various exons BioPerl 0.7\n#      @subfeat=$feat->sub_SeqFeature; # 0.6.2\n\t  @subfeat=$featlocation->sub_Location(); # 0.7\n\t  my @transcript;\n\t  foreach $subfeat (@subfeat) {\n\t      my @range;\n\t      if ($subfeat->strand == -1) {\n\t\t  @range=($subfeat->end,$subfeat->start,$subfeat->strand);\n\t      } else {\n\t\t  @range=($subfeat->start,$subfeat->end,$subfeat->strand);\n\t      }\n\t      push (@transcript,\\@range);\n\t  }\n\t  $feature{range}=\\@transcript;\n      } else {\n\t  my @range;\n\t  ($feat->strand == -1) ? (@range = ($feat->end, $feat->start, $feat->strand) ) :\n\t      (@range = ( $feat->start,$feat->end,$feat->strand) );\n# works ok with 0.6.2\n\t  if ($feature_name eq \"CDS\") { # case of single exon CDS (CDS name but not split location)\n\t      my @transcript=(\\@range);\n\t      $feature{range}=\\@transcript;\n\t  } else { # all other range features\n\t      $feature{range}=\\@range;\n\t  }\n      }\n      $feature{location}=\"deprecated\";\n      \n      $feature{position}=$i;\n      $feature{name}=$feature_name;\n      \n      @feature_qual_names= $feat->all_tags();\n      $feature_qual_number= scalar(@feature_qual_names);\n      \n      $feature{qual_number}=$feature_qual_number;\n      \n      my %feature_qualifiers;\n      for $qual (@feature_qual_names) {\n\t  $feature_qual_name=$qual;\n\t  unless ($valid_names{$feature_qual_name}) {\n\t      next;\n\t  }\n      @feature_qual_value=$feat->each_tag_value($qual);\n\t  #print \"$qual => @feature_qual_value \\n\";\n\t  $feature_qualifiers{$feature_qual_name}=$feature_qual_value[0]; # ?\n      # maybe the whole array should be entered, not just the 1st element?\n\t  # what could be the other elements? TOCHECK!\n      }\n      $feature{qualifiers}=\\%feature_qualifiers;\n      push (@features,\\%feature); # array of features\n      $i++;\n  }\n  $entryhash{Features}=\\@features; # put this also into the hash\n  \n  my @cds; # array just of CDSs\n  for $i (0..$#features) {\n      if ($features[$i]->{'name'} eq \"CDS\") {\n\t  push(@cds,$features[$i]);\n      }\n  }\n  $entryhash{CDS}=\\@cds; # put this also into the hash\n  return (\\%entryhash);\n}\n\n=head2 novelaasequence2gene\n\n  Title   : novelaasequence2gene\n  Usage   : $gene=Bio::LiveSeq::IO::BioPerl->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\");\n          : $gene=Bio::LiveSeq::IO::BioPerl->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\",\n                                             -cusg_data => \"58 44 7 29 3 3 480 267 105 143 122 39 144 162 14 59 53 25 233 292 19 113 88 246 28 68 161 231 27 102 128 151 67 60 138 131 48 61 153 19 233 73 150 31 129 38 147 71 138 43 181 81 44 15 255 118 312 392 236 82 20 10 14 141\");\n          : $gene=Bio::LiveSeq::IO::BioPerl->novelaasequence2gene(-aasequence => \"MGLAAPTRS*\",\n                                             -cusg_data => \"58 44 7 29 3 3 480 267 105 143 122 39 144 162 14 59 53 25 233 292 19 113 88 246 28 68 161 231 27 102 128 151 67 60 138 131 48 61 153 19 233 73 150 31 129 38 147 71 138 43 181 81 44 15 255 118 312 392 236 82 20 10 14 141\",\n                                             -translation_table => \"2\",\n                                             -gene_name => \"tyr-kinase\");\n\n  Function: creates LiveSeq objects from a novel amino acid sequence,\n            using codon usage information (loaded from a file) to choose\n            codons according to relative frequencies.\n            If a codon_usage information is not specified,\n            the default is to use Homo sapiens data (taxonomy ID 9606).\n            If a translation_table ID is not specified, it will default to 1\n            (standard code).\n  Returns : reference to a Gene object containing references to LiveSeq objects\n  Errorcode 0\n  Args    : string containing an amino acid sequence\n\t    string (optional) with codon usage data (64 integer numbers)\n            string (optional) specifying a gene_name\n            integer (optional) specifying a translation_table ID"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":365},"end":{"character":9999,"line":396}},"name":"novelaasequence2gene"},{"name":"carp","line":371,"kind":12},{"containerName":"LiveSeq::IO::Loader::_common_novelaasequence2gene","name":"Bio","line":394,"kind":12}]}