{"version":5,"vars":[{"name":"base","containerName":"","kind":2,"line":105},{"containerName":"main::","definition":"sub","name":"_version","range":{"start":{"character":0,"line":107},"end":{"character":9999,"line":109}},"kind":12,"line":107,"children":[]},{"range":{"end":{"character":9999,"line":169},"start":{"character":0,"line":124}},"name":"_index_file","detail":"($self,$file,$i)","signature":{"documentation":"1;\n#\n# $Id: SwissPfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::SwissPfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::SwissPfam - Interface for indexing swisspfam files\n\n=head1 SYNOPSIS\n\n    use Bio::Index::SwissPfam;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::SwissPfam->new('-filename' => $Index_File_Name, \n                         \t\t\t\t\t '-write_flag' => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    use Bio::Index::SwissPfam;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::SwissPfam->new('-filename' => $Index_File_Name);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns stream\n\t     while( <$seq> ) {\n\t         if(/^>/) {\n\t    \t       print;\n\t\t          last;\n\t         }\n\t     }\n    }\n\n\n=head1 DESCRIPTION\n\nSwissPfam is one of the flat files released with Pfam. This modules\nprovides a way of indexing this module.\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm, and \nprovides the basic funtionallity for indexing SwissPfam files.  Only \nretrieves FileStreams at the moment. Once we have something better \n(ie, an object!), will use that. Heavily snaffled from Index::Fasta system of \nJames Gilbert. Note: for best results 'use strict'.\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let's begin the code...\n\n\npackage Bio::Index::SwissPfam;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::Abstract);\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index swisspfam format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"label":"_index_file($self,$file,$i)"},"containerName":"main::","definition":"sub","line":124,"children":[{"localvar":"my","containerName":"_index_file","definition":"my","name":"$self","line":125,"kind":13},{"name":"$file","containerName":"_index_file","kind":13,"line":126},{"line":127,"kind":13,"name":"$i","containerName":"_index_file"},{"containerName":"_index_file","definition":"my","name":"$begin","localvar":"my","kind":13,"line":130},{"line":132,"kind":13,"containerName":"_index_file","name":"$end"},{"kind":13,"line":134,"name":"$id","containerName":"_index_file"},{"line":135,"kind":13,"name":"$acc","containerName":"_index_file"},{"name":"$nid","containerName":"_index_file","line":136,"kind":13},{"line":136,"kind":13,"name":"$nacc","containerName":"_index_file"},{"line":139,"kind":13,"containerName":"_index_file","name":"$begin"},{"line":140,"kind":13,"containerName":"_index_file","name":"$end"},{"kind":13,"line":142,"name":"$SP","definition":"my","containerName":"_index_file","localvar":"my"},{"kind":13,"line":142,"name":"$file","containerName":"_index_file"},{"kind":13,"line":142,"containerName":"_index_file","name":"$self"},{"kind":12,"line":142,"containerName":"_index_file","name":"throw"},{"line":145,"kind":13,"name":"$SP","containerName":"_index_file"},{"containerName":"_index_file","name":"$nid","line":147,"kind":13},{"line":148,"kind":13,"containerName":"_index_file","name":"$nacc"},{"kind":13,"line":149,"definition":"my","name":"$new_begin","containerName":"_index_file","localvar":"my"},{"line":149,"kind":13,"containerName":"_index_file","name":"$SP"},{"kind":13,"line":150,"name":"$end","containerName":"_index_file"},{"kind":13,"line":150,"name":"$new_begin","containerName":"_index_file"},{"name":"$id","containerName":"_index_file","kind":13,"line":152},{"name":"$self","containerName":"_index_file","line":153,"kind":13},{"line":153,"kind":12,"containerName":"_index_file","name":"add_record"},{"kind":13,"line":153,"name":"$id","containerName":"_index_file"},{"kind":13,"line":153,"containerName":"_index_file","name":"$i"},{"name":"$begin","containerName":"_index_file","kind":13,"line":153},{"line":153,"kind":13,"name":"$end","containerName":"_index_file"},{"kind":13,"line":154,"containerName":"_index_file","name":"$acc"},{"kind":13,"line":154,"name":"$id","containerName":"_index_file"},{"line":155,"kind":13,"name":"$self","containerName":"_index_file"},{"kind":12,"line":155,"containerName":"_index_file","name":"add_record"},{"kind":13,"line":155,"name":"$acc","containerName":"_index_file"},{"kind":13,"line":155,"name":"$i","containerName":"_index_file"},{"kind":13,"line":155,"containerName":"_index_file","name":"$begin"},{"kind":13,"line":155,"containerName":"_index_file","name":"$end"},{"kind":13,"line":158,"name":"$begin","containerName":"_index_file"},{"line":158,"kind":13,"containerName":"_index_file","name":"$new_begin"},{"name":"$id","containerName":"_index_file","kind":13,"line":159},{"containerName":"_index_file","name":"$nid","line":159,"kind":13},{"name":"$acc","containerName":"_index_file","kind":13,"line":160},{"containerName":"_index_file","name":"$nacc","kind":13,"line":160},{"line":164,"kind":13,"name":"$end","containerName":"_index_file"},{"line":164,"kind":13,"containerName":"_index_file","name":"$SP"},{"containerName":"_index_file","name":"$self","kind":13,"line":165},{"name":"add_record","containerName":"_index_file","kind":12,"line":165},{"name":"$id","containerName":"_index_file","kind":13,"line":165},{"kind":13,"line":165,"containerName":"_index_file","name":"$i"},{"name":"$begin","containerName":"_index_file","line":165,"kind":13},{"kind":13,"line":165,"name":"$end","containerName":"_index_file"},{"kind":13,"line":165,"name":"$id","containerName":"_index_file"},{"containerName":"_index_file","name":"$SP","kind":13,"line":167}],"kind":12},{"signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n#\n# $Id: SwissPfam.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::SwissPfam\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::SwissPfam - Interface for indexing swisspfam files\n\n=head1 SYNOPSIS\n\n    use Bio::Index::SwissPfam;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::SwissPfam->new('-filename' => $Index_File_Name, \n                         \t\t\t\t\t '-write_flag' => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    use Bio::Index::SwissPfam;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::SwissPfam->new('-filename' => $Index_File_Name);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns stream\n\t     while( <$seq> ) {\n\t         if(/^>/) {\n\t    \t       print;\n\t\t          last;\n\t         }\n\t     }\n    }\n\n\n=head1 DESCRIPTION\n\nSwissPfam is one of the flat files released with Pfam. This modules\nprovides a way of indexing this module.\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm, and \nprovides the basic funtionallity for indexing SwissPfam files.  Only \nretrieves FileStreams at the moment. Once we have something better \n(ie, an object!), will use that. Heavily snaffled from Index::Fasta system of \nJames Gilbert. Note: for best results 'use strict'.\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let's begin the code...\n\n\npackage Bio::Index::SwissPfam;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::Abstract);\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index swisspfam format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n        $file, # File name\n        $i     # Index-number of file being indexed\n        ) = @_;\n    \n    my( $begin, # Offset from start of file of the start\n                # of the last found record.\n        $end,   # Offset from start of file of the end\n                # of the last found record.\n        $id,    # ID of last found record.\n\t$acc,   # accession of last record. Also put into the index\n\t$nid, $nacc, # new ids for the record just found\n        );\n\n    $begin = 0;\n    $end   = 0;\n\n    open my $SP, '<', $file or $self->throw(\"Can't open file for read : $file\");\n\n    # Main indexing loop\n    while (<$SP>) {\n        if (/^>(\\S+)\\s+\\|=*\\|\\s+(\\S+)/) {\n\t    $nid = $1;\n\t    $nacc = $2;\n            my $new_begin = tell($SP) - length( $_ );\n            $end = $new_begin - 1;\n\n\t    if( $id ) {\n\t\t$self->add_record($id, $i, $begin, $end);\n\t\tif( $acc ne $id ) {\n\t\t    $self->add_record($acc, $i, $begin, $end);\n\t\t}\n\t    }\n            $begin = $new_begin;\n\t    $id = $nid;\n\t    $acc = $nacc;\n        }\n    }\n    # Don't forget to add the last record\n    $end = tell($SP);\n    $self->add_record($id, $i, $begin, $end) if $id;\n\n    close $SP;\n    return 1;\n}\n\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID","label":"fetch($self,$id)"},"detail":"($self,$id)","definition":"sub","containerName":"main::","children":[{"containerName":"fetch","name":"$self","definition":"my","localvar":"my","kind":13,"line":184},{"kind":13,"line":184,"name":"$id","containerName":"fetch"},{"name":"$desc","definition":"my","containerName":"fetch","localvar":"my","kind":13,"line":185},{"localvar":"my","definition":"my","name":"$db","containerName":"fetch","line":186,"kind":13},{"kind":13,"line":186,"name":"$self","containerName":"fetch"},{"name":"db","containerName":"fetch","kind":12,"line":186},{"containerName":"fetch","definition":"my","name":"$rec","localvar":"my","kind":13,"line":187},{"kind":13,"line":187,"name":"$db","containerName":"fetch"},{"containerName":"fetch","name":"$id","kind":13,"line":187},{"localvar":"my","name":"@record","definition":"my","containerName":"fetch","line":188,"kind":13},{"definition":"my","name":"$file","containerName":"fetch","localvar":"my","kind":13,"line":190},{"line":190,"kind":13,"name":"$begin","containerName":"fetch"},{"name":"$end","containerName":"fetch","line":190,"kind":13},{"name":"$self","containerName":"fetch","kind":13,"line":190},{"containerName":"fetch","name":"unpack_record","line":190,"kind":12},{"line":190,"kind":13,"containerName":"fetch","name":"$rec"},{"kind":13,"line":193,"definition":"my","name":"$fh","containerName":"fetch","localvar":"my"},{"containerName":"fetch","name":"$self","kind":13,"line":193},{"name":"_file_handle","containerName":"fetch","kind":12,"line":193},{"line":193,"kind":13,"containerName":"fetch","name":"$file"},{"kind":13,"line":196,"containerName":"fetch","name":"$fh"},{"containerName":"fetch","name":"$begin","kind":13,"line":196},{"containerName":"fetch","name":"$fh","line":198,"kind":13},{"kind":13,"line":200,"name":"$self","containerName":"fetch"},{"containerName":"fetch","name":"throw","kind":12,"line":200}],"line":183,"kind":12,"range":{"end":{"line":202,"character":9999},"start":{"line":183,"character":0}},"name":"fetch"}]}