{"vars":[{"line":110,"kind":2,"containerName":"","name":"base"},{"name":"_type_stamp","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":112},"end":{"character":9999,"line":114}},"kind":12,"children":[],"line":112},{"kind":12,"children":[],"line":117,"name":"_version","definition":"sub","containerName":"main::","range":{"start":{"line":117,"character":0},"end":{"character":9999,"line":119}}},{"line":134,"children":[{"line":135,"kind":13,"localvar":"my","containerName":"_index_file","definition":"my","name":"$self"},{"containerName":"_index_file","name":"$file","kind":13,"line":136},{"containerName":"_index_file","name":"$i","kind":13,"line":137},{"line":140,"kind":13,"localvar":"my","name":"$begin","definition":"my","containerName":"_index_file"},{"containerName":"_index_file","name":"$id","line":142,"kind":13},{"name":"@accs","containerName":"_index_file","kind":13,"line":143},{"line":146,"kind":13,"name":"$begin","containerName":"_index_file"},{"localvar":"my","containerName":"_index_file","definition":"my","name":"$EMBL","line":148,"kind":13},{"name":"$file","containerName":"_index_file","kind":13,"line":148},{"line":148,"kind":13,"containerName":"_index_file","name":"$self"},{"line":148,"kind":12,"name":"throw","containerName":"_index_file"},{"containerName":"_index_file","name":"$id","kind":13,"line":151},{"containerName":"_index_file","name":"@accs","kind":13,"line":152},{"kind":13,"line":153,"containerName":"_index_file","name":"$EMBL"},{"name":"$id","containerName":"_index_file","line":155,"kind":13},{"kind":13,"line":156,"containerName":"_index_file","name":"$self"},{"line":156,"kind":12,"containerName":"_index_file","name":"throw"},{"line":159,"kind":13,"containerName":"_index_file","name":"@accs"},{"line":160,"kind":13,"containerName":"_index_file","name":"$self"},{"containerName":"_index_file","name":"warn","line":160,"kind":12},{"name":"$self","containerName":"_index_file","line":163,"kind":13},{"line":163,"kind":12,"name":"add_record","containerName":"_index_file"},{"kind":13,"line":163,"containerName":"_index_file","name":"$id"},{"containerName":"_index_file","name":"$i","line":163,"kind":13},{"name":"$begin","containerName":"_index_file","line":163,"kind":13},{"containerName":"_index_file","name":"$acc","definition":"my","localvar":"my","kind":13,"line":165},{"line":165,"kind":13,"name":"@accs","containerName":"_index_file"},{"kind":13,"line":166,"name":"$acc","containerName":"_index_file"},{"kind":13,"line":166,"name":"$id","containerName":"_index_file"},{"kind":13,"line":167,"name":"$self","containerName":"_index_file"},{"line":167,"kind":12,"name":"add_record","containerName":"_index_file"},{"containerName":"_index_file","name":"$acc","line":167,"kind":13},{"line":167,"kind":13,"name":"$i","containerName":"_index_file"},{"line":167,"kind":13,"containerName":"_index_file","name":"$begin"},{"containerName":"_index_file","name":"$id","line":171,"kind":13},{"line":174,"kind":13,"name":"$begin","containerName":"_index_file"},{"containerName":"_index_file","name":"$EMBL","kind":13,"line":174},{"line":177,"kind":13,"containerName":"_index_file","name":"@accs"},{"line":183,"kind":13,"name":"$EMBL","containerName":"_index_file"}],"kind":12,"detail":"($self,$file,$i)","signature":{"documentation":"1;\n# $Id: EMBL.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::EMBL\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::EMBL - Interface for indexing (multiple) EMBL/Swissprot\n.dat files (i.e. flat file EMBL/Swissprot format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for several\n    # EMBL files\n    use Bio::Index::EMBL;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::EMBL->new(-filename => $Index_File_Name,\n\t\t\t\t    -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out several sequences present in the index\n    # in Fasta format\n    use Bio::Index::EMBL;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::EMBL->new(-filename => $Index_File_Name);\n    my $out = Bio::SeqIO->new(-format => 'Fasta',-fh => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n\t$out->write_seq($seq);\n    }\n\n    # alternatively\n    my ($id, $acc);\n    my $seq1 = $inx->get_Seq_by_id($id);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing EMBL files, and\nretrieving the sequence from them. Heavily snaffled from James Gilbert\nand his Fasta system. Note: for best results 'use strict'.\n\nThe keys are the identifiers in the ID and AC lines.\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let's begin the code...\n\n\npackage Bio::Index::EMBL;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__EMBL_FLAT__'; # What kind of index are we?\n}\n\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index EMBL format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : ","parameters":[{"label":"$self"},{"label":"$file"},{"label":"$i"}],"label":"_index_file($self,$file,$i)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":134},"end":{"line":185,"character":9999}},"name":"_index_file"},{"detail":"($self,@args)","signature":{"label":"_file_format($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: EMBL.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::EMBL\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@sanger.ac.uk>\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::EMBL - Interface for indexing (multiple) EMBL/Swissprot\n.dat files (i.e. flat file EMBL/Swissprot format).\n\n=head1 SYNOPSIS\n\n    # Complete code for making an index for several\n    # EMBL files\n    use Bio::Index::EMBL;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::EMBL->new(-filename => $Index_File_Name,\n\t\t\t\t    -write_flag => 'WRITE');\n    $inx->make_index(@ARGV);\n\n    # Print out several sequences present in the index\n    # in Fasta format\n    use Bio::Index::EMBL;\n    use strict;\n\n    my $Index_File_Name = shift;\n    my $inx = Bio::Index::EMBL->new(-filename => $Index_File_Name);\n    my $out = Bio::SeqIO->new(-format => 'Fasta',-fh => \\*STDOUT);\n\n    foreach my $id (@ARGV) {\n        my $seq = $inx->fetch($id); # Returns Bio::Seq object\n\t$out->write_seq($seq);\n    }\n\n    # alternatively\n    my ($id, $acc);\n    my $seq1 = $inx->get_Seq_by_id($id);\n    my $seq2 = $inx->get_Seq_by_acc($acc);\n\n=head1 DESCRIPTION\n\nInherits functions for managing dbm files from Bio::Index::Abstract.pm,\nand provides the basic funtionallity for indexing EMBL files, and\nretrieving the sequence from them. Heavily snaffled from James Gilbert\nand his Fasta system. Note: for best results 'use strict'.\n\nThe keys are the identifiers in the ID and AC lines.\n\n=head1 FEED_BACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail - birney@sanger.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let's begin the code...\n\n\npackage Bio::Index::EMBL;\n\nuse strict;\n\nuse Bio::Seq;\n\nuse base qw(Bio::Index::AbstractSeq);\n\nsub _type_stamp {\n    return '__EMBL_FLAT__'; # What kind of index are we?\n}\n\n\nsub _version {\n    return 0.1;\n}\n\n=head2 _index_file\n\n  Title   : _index_file\n  Usage   : $index->_index_file( $file_name, $i )\n  Function: Specialist function to index EMBL format files.\n            Is provided with a filename and an integer\n            by make_index in its SUPER class.\n  Example : \n  Returns : \n  Args    : \n\n\nsub _index_file {\n    my( $self,\n        $file, # File name\n        $i     # Index-number of file being indexed\n        ) = @_;\n\n    my( $begin, # Offset from start of file of the start\n                # of the last found record.\n        $id,    # ID of last found record.\n\t@accs,   # accession of last record. Also put into the index\n        );\n\n    $begin = 0;\n\n    open my $EMBL, '<', $file or $self->throw(\"Can't open file for read : $file\");\n\n    # Main indexing loop\n    $id = undef;\n    @accs = ();\n    while (<$EMBL>) {\n\tif( m{^//} ) {\n\t    if( ! defined $id ) {\n\t\t$self->throw(\"Got to a end of entry line for an EMBL flat file with no parsed ID. Considering this a problem!\");\n\t\tnext;\n\t    }\n\t    if( ! @accs ) {\n\t\t$self->warn(\"For id [$id] in embl flat file, got no accession number. Storing id index anyway\");\n\t    }\n\n\t    $self->add_record($id, $i, $begin);\n\n\t    foreach my $acc (@accs) {\n\t\tif( $acc ne $id ) {\n\t\t    $self->add_record($acc, $i, $begin);\n\t\t}\n\t    }\n\t} elsif (/^ID\\s+(\\S+)/) {\n\t    $id = $1;\n\t    # not sure if I like this. Assummes tell is in bytes.\n\t    # we could tell before each line and save it.\n            $begin = tell($EMBL) - length( $_ );\n\t\n\t} elsif (/^AC\\s+(.*)?/) {\n            push @accs , split (/[; ]+/, $1);\n\t} else {\n\t    # do nothing\n\t}\n    }\n\n    close $EMBL;\n    return 1;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : Internal function for indexing system\n Function: Provides file format for this database\n Example :\n Returns : \n Args    :"},"containerName":"main::","definition":"sub","line":199,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_file_format","line":200,"kind":13},{"line":200,"kind":13,"name":"@args","containerName":"_file_format"}],"kind":12,"range":{"start":{"line":199,"character":0},"end":{"character":9999,"line":203}},"name":"_file_format"}],"version":5}