{"vars":[{"line":89,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"start":{"line":91,"character":0},"end":{"character":9999,"line":97}},"kind":12,"line":91,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":92},{"line":92,"kind":13,"name":"@args","containerName":"new"},{"line":93,"kind":13,"localvar":"my","containerName":"new","definition":"my","name":"$self"},{"name":"$class","containerName":"new","line":93,"kind":13},{"line":93,"kind":13,"name":"@args","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":95},{"line":96,"kind":13,"name":"$self","containerName":"new"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"","label":"new($class,@args)"}},{"containerName":"new","name":"SUPER","kind":12,"line":93},{"definition":"sub","containerName":"main::","signature":{"label":"_file_format($self,@args)","documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"localvar":"my","containerName":"_file_format","name":"$self","definition":"my","line":113,"kind":13},{"kind":13,"line":113,"name":"@args","containerName":"_file_format"},{"kind":13,"line":115,"definition":"my","name":"$pkg","containerName":"_file_format","localvar":"my"},{"name":"$self","containerName":"_file_format","line":115,"kind":13},{"line":116,"kind":13,"name":"$self","containerName":"_file_format"},{"name":"throw","containerName":"_file_format","kind":12,"line":116}],"line":112,"name":"_file_format","range":{"end":{"line":117,"character":9999},"start":{"line":112,"character":0}}},{"children":[{"kind":13,"line":131,"containerName":"fetch","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":131,"name":"$id","containerName":"fetch"},{"localvar":"my","containerName":"fetch","definition":"my","name":"$db","line":132,"kind":13},{"name":"$self","containerName":"fetch","line":132,"kind":13},{"name":"db","containerName":"fetch","line":132,"kind":12},{"kind":13,"line":133,"containerName":"fetch","name":"$seq","definition":"my","localvar":"my"},{"kind":13,"line":135,"containerName":"fetch","definition":"my","name":"$rec","localvar":"my"},{"containerName":"fetch","name":"$db","line":135,"kind":13},{"name":"$id","containerName":"fetch","kind":13,"line":135},{"containerName":"fetch","definition":"my","name":"$file","localvar":"my","kind":13,"line":136},{"name":"$begin","containerName":"fetch","kind":13,"line":136},{"line":136,"kind":13,"name":"$self","containerName":"fetch"},{"line":136,"kind":12,"containerName":"fetch","name":"unpack_record"},{"line":136,"kind":13,"containerName":"fetch","name":"$rec"},{"line":139,"kind":13,"localvar":"my","containerName":"fetch","definition":"my","name":"$seqio"},{"containerName":"fetch","name":"$self","kind":13,"line":139},{"line":139,"kind":12,"name":"_get_SeqIO_object","containerName":"fetch"},{"line":139,"kind":13,"name":"$file","containerName":"fetch"},{"definition":"my","name":"$fh","containerName":"fetch","localvar":"my","kind":13,"line":140},{"containerName":"fetch","name":"$seqio","kind":13,"line":140},{"kind":12,"line":140,"containerName":"fetch","name":"_fh"},{"containerName":"fetch","name":"$fh","kind":13,"line":144},{"line":144,"kind":13,"containerName":"fetch","name":"$begin"},{"line":146,"kind":13,"containerName":"fetch","name":"$seq"},{"kind":13,"line":146,"name":"$seqio","containerName":"fetch"},{"kind":12,"line":146,"containerName":"fetch","name":"next_seq"},{"containerName":"fetch","name":"$seq","line":151,"kind":13},{"containerName":"fetch","name":"$seq","kind":13,"line":151},{"line":151,"kind":12,"name":"isa","containerName":"fetch"},{"kind":13,"line":152,"name":"$seq","containerName":"fetch"},{"kind":12,"line":152,"name":"primary_id","containerName":"fetch"},{"kind":13,"line":153,"name":"$seq","containerName":"fetch"},{"kind":12,"line":153,"name":"primary_id","containerName":"fetch"},{"line":153,"kind":13,"containerName":"fetch","name":"$seq"},{"kind":12,"line":153,"name":"display_id","containerName":"fetch"},{"containerName":"fetch","name":"$seq","line":155,"kind":13}],"line":130,"kind":12,"signature":{"label":"fetch($self,$id)","parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID"},"detail":"($self,$id)","definition":"sub","containerName":"main::","range":{"end":{"line":156,"character":9999},"start":{"line":130,"character":0}},"name":"fetch"},{"range":{"start":{"line":169,"character":0},"end":{"line":180,"character":9999}},"name":"_get_SeqIO_object","line":169,"children":[{"definition":"my","name":"$self","containerName":"_get_SeqIO_object","localvar":"my","kind":13,"line":170},{"name":"$i","containerName":"_get_SeqIO_object","line":170,"kind":13},{"kind":13,"line":172,"containerName":"_get_SeqIO_object","name":"$self"},{"kind":13,"line":172,"name":"$i","containerName":"_get_SeqIO_object"},{"line":173,"kind":13,"localvar":"my","name":"$fh","definition":"my","containerName":"_get_SeqIO_object"},{"line":173,"kind":13,"containerName":"_get_SeqIO_object","name":"$self"},{"line":173,"kind":12,"name":"_file_handle","containerName":"_get_SeqIO_object"},{"containerName":"_get_SeqIO_object","name":"$i","line":173,"kind":13},{"kind":13,"line":175,"containerName":"_get_SeqIO_object","definition":"my","name":"$seqio","localvar":"my"},{"containerName":"_get_SeqIO_object","name":"new","line":175,"kind":12},{"name":"$self","containerName":"_get_SeqIO_object","kind":13,"line":175},{"kind":12,"line":175,"containerName":"_get_SeqIO_object","name":"_file_format"},{"containerName":"_get_SeqIO_object","name":"$fh","kind":13,"line":176},{"name":"$self","containerName":"_get_SeqIO_object","line":177,"kind":13},{"name":"$i","containerName":"_get_SeqIO_object","line":177,"kind":13},{"containerName":"_get_SeqIO_object","name":"$seqio","line":177,"kind":13},{"containerName":"_get_SeqIO_object","name":"$self","kind":13,"line":179},{"kind":13,"line":179,"containerName":"_get_SeqIO_object","name":"$i"}],"kind":12,"detail":"($self,$i)","signature":{"label":"_get_SeqIO_object($self,$i)","documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)","parameters":[{"label":"$self"},{"label":"$i"}]},"containerName":"main::","definition":"sub"},{"line":175,"kind":12,"containerName":"SeqIO","name":"Bio"},{"kind":12,"line":194,"children":[{"line":195,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"get_Seq_by_id"},{"kind":13,"line":195,"containerName":"get_Seq_by_id","name":"$id"},{"line":197,"kind":13,"containerName":"get_Seq_by_id","name":"$self"},{"line":197,"kind":12,"containerName":"get_Seq_by_id","name":"fetch"},{"kind":13,"line":197,"name":"$id","containerName":"get_Seq_by_id"}],"containerName":"main::","definition":"sub","detail":"($self,$id)","signature":{"label":"get_Seq_by_id($self,$id)","documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)\n\n\nsub _get_SeqIO_object {\n    my( $self, $i ) = @_;\n    \n    unless ($self->{'_seqio_cache'}[$i]) {\n        my $fh = $self->_file_handle($i);\n        # make a new SeqIO object\n        my $seqio = Bio::SeqIO->new( -Format => $self->_file_format,\n\t\t\t\t     -fh     => $fh);\n        $self->{'_seqio_cache'}[$i] = $seqio;\n    }\n    return $self->{'_seqio_cache'}[$i];\n}\n\n=head2 get_Seq_by_id\n\n Title   : get_Seq_by_id\n Usage   : $seq = $db->get_Seq_by_id()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the id","parameters":[{"label":"$self"},{"label":"$id"}]},"name":"get_Seq_by_id","range":{"end":{"character":9999,"line":198},"start":{"character":0,"line":194}}},{"detail":"($self,$id)","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)\n\n\nsub _get_SeqIO_object {\n    my( $self, $i ) = @_;\n    \n    unless ($self->{'_seqio_cache'}[$i]) {\n        my $fh = $self->_file_handle($i);\n        # make a new SeqIO object\n        my $seqio = Bio::SeqIO->new( -Format => $self->_file_format,\n\t\t\t\t     -fh     => $fh);\n        $self->{'_seqio_cache'}[$i] = $seqio;\n    }\n    return $self->{'_seqio_cache'}[$i];\n}\n\n=head2 get_Seq_by_id\n\n Title   : get_Seq_by_id\n Usage   : $seq = $db->get_Seq_by_id()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the id\n\n\n\nsub get_Seq_by_id {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_Seq_by_acc\n\n Title   : get_Seq_by_acc\n Usage   : $seq = $db->get_Seq_by_acc()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the accession number","label":"get_Seq_by_acc($self,$id)"},"containerName":"main::","definition":"sub","line":212,"children":[{"line":213,"kind":13,"localvar":"my","containerName":"get_Seq_by_acc","definition":"my","name":"$self"},{"name":"$id","containerName":"get_Seq_by_acc","kind":13,"line":213},{"kind":13,"line":215,"containerName":"get_Seq_by_acc","name":"$self"},{"containerName":"get_Seq_by_acc","name":"fetch","kind":12,"line":215},{"line":215,"kind":13,"containerName":"get_Seq_by_acc","name":"$id"}],"kind":12,"range":{"start":{"character":0,"line":212},"end":{"character":9999,"line":216}},"name":"get_Seq_by_acc"},{"children":[{"kind":13,"line":231,"name":"$self","definition":"my","containerName":"get_PrimarySeq_stream","localvar":"my"},{"line":232,"kind":13,"localvar":"my","definition":"my","name":"$num","containerName":"get_PrimarySeq_stream"},{"line":232,"kind":13,"name":"$self","containerName":"get_PrimarySeq_stream"},{"kind":12,"line":232,"name":"_file_count","containerName":"get_PrimarySeq_stream"},{"kind":13,"line":233,"containerName":"get_PrimarySeq_stream","name":"@file","definition":"my","localvar":"my"},{"containerName":"get_PrimarySeq_stream","definition":"my","name":"$i","localvar":"my","kind":13,"line":235},{"containerName":"get_PrimarySeq_stream","name":"$i","kind":13,"line":235},{"name":"$num","containerName":"get_PrimarySeq_stream","kind":13,"line":235},{"line":235,"kind":13,"containerName":"get_PrimarySeq_stream","name":"$i"},{"containerName":"get_PrimarySeq_stream","definition":"my","name":"$file","localvar":"my","kind":13,"line":236},{"containerName":"get_PrimarySeq_stream","name":"$stored_size","kind":13,"line":236},{"containerName":"get_PrimarySeq_stream","name":"$self","kind":13,"line":236},{"containerName":"get_PrimarySeq_stream","name":"unpack_record","kind":12,"line":236},{"kind":13,"line":236,"name":"$self","containerName":"get_PrimarySeq_stream"},{"containerName":"get_PrimarySeq_stream","name":"db","kind":12,"line":236},{"line":237,"kind":13,"containerName":"get_PrimarySeq_stream","name":"@file"},{"name":"$file","containerName":"get_PrimarySeq_stream","kind":13,"line":237},{"line":240,"kind":13,"localvar":"my","name":"$out","definition":"my","containerName":"get_PrimarySeq_stream"},{"kind":12,"line":240,"name":"new","containerName":"get_PrimarySeq_stream"},{"line":240,"kind":13,"containerName":"get_PrimarySeq_stream","name":"$self"},{"kind":12,"line":240,"name":"_file_format","containerName":"get_PrimarySeq_stream"},{"kind":13,"line":240,"name":"@file","containerName":"get_PrimarySeq_stream"},{"name":"$out","containerName":"get_PrimarySeq_stream","line":241,"kind":13}],"line":230,"kind":12,"range":{"end":{"character":9999,"line":242},"start":{"character":0,"line":230}},"name":"get_PrimarySeq_stream","definition":"sub","containerName":"main::"},{"line":240,"kind":12,"name":"Bio","containerName":"SeqIO::MultiFile"},{"range":{"end":{"line":288,"character":9999},"start":{"character":0,"line":261}},"name":"get_all_primary_ids","children":[{"line":262,"kind":13,"localvar":"my","containerName":"get_all_primary_ids","definition":"my","name":"$self"},{"kind":13,"line":262,"name":"@args","containerName":"get_all_primary_ids"},{"name":"$db","definition":"my","containerName":"get_all_primary_ids","localvar":"my","kind":13,"line":263},{"kind":13,"line":263,"name":"$self","containerName":"get_all_primary_ids"},{"line":263,"kind":12,"containerName":"get_all_primary_ids","name":"db"},{"name":"%bytepos","definition":"my","containerName":"get_all_primary_ids","localvar":"my","kind":13,"line":276},{"localvar":"my","containerName":"get_all_primary_ids","definition":"my","name":"$id","line":277,"kind":13},{"line":277,"kind":13,"containerName":"get_all_primary_ids","name":"$rec"},{"kind":13,"line":277,"containerName":"get_all_primary_ids","name":"$db"},{"line":278,"kind":13,"name":"$id","containerName":"get_all_primary_ids"},{"localvar":"my","name":"$file","definition":"my","containerName":"get_all_primary_ids","line":282,"kind":13},{"containerName":"get_all_primary_ids","name":"$begin","kind":13,"line":282},{"kind":13,"line":282,"containerName":"get_all_primary_ids","name":"$self"},{"line":282,"kind":12,"containerName":"get_all_primary_ids","name":"unpack_record"},{"line":282,"kind":13,"containerName":"get_all_primary_ids","name":"$rec"},{"line":284,"kind":13,"containerName":"get_all_primary_ids","name":"$bytepos"},{"containerName":"get_all_primary_ids","name":"$id","line":284,"kind":13},{"kind":13,"line":287,"name":"%bytepos","containerName":"get_all_primary_ids"}],"line":261,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)\n\n\nsub _get_SeqIO_object {\n    my( $self, $i ) = @_;\n    \n    unless ($self->{'_seqio_cache'}[$i]) {\n        my $fh = $self->_file_handle($i);\n        # make a new SeqIO object\n        my $seqio = Bio::SeqIO->new( -Format => $self->_file_format,\n\t\t\t\t     -fh     => $fh);\n        $self->{'_seqio_cache'}[$i] = $seqio;\n    }\n    return $self->{'_seqio_cache'}[$i];\n}\n\n=head2 get_Seq_by_id\n\n Title   : get_Seq_by_id\n Usage   : $seq = $db->get_Seq_by_id()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the id\n\n\n\nsub get_Seq_by_id {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_Seq_by_acc\n\n Title   : get_Seq_by_acc\n Usage   : $seq = $db->get_Seq_by_acc()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the accession number\n\n\n\nsub get_Seq_by_acc {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_PrimarySeq_stream\n\n Title   : get_PrimarySeq_stream\n Usage   : $stream = get_PrimarySeq_stream\n Function: Makes a Bio::DB::SeqStreamI compliant object\n           which provides a single method, next_primary_seq\n Returns : Bio::DB::SeqStreamI\n Args    : none\n\n\n\nsub get_PrimarySeq_stream {\n    my $self = shift;\n    my $num  = $self->_file_count() || 0;\n    my @file;\n    \n    for (my $i = 0; $i < $num; $i++) {\n        my( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\tpush(@file,$file);\n    }\n   \n    my $out = Bio::SeqIO::MultiFile->new( '-format' => $self->_file_format , -files => \\@file);\n    return $out;\n}\n\n=head2 get_all_primary_ids\n\n Title   : get_all_primary_ids\n Usage   : @ids = $seqdb->get_all_primary_ids()\n Function: gives an array of all the primary_ids of the \n           sequence objects in the database. These\n           maybe ids (display style) or accession numbers\n           or something else completely different - they\n           *are not* meaningful outside of this database\n           implementation.\n Example :\n Returns : an array of strings\n Args    : none","label":"get_all_primary_ids($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"detail":"($self,$id)","signature":{"parameters":[{"label":"$self"},{"label":"$id"}],"documentation":"1;\n# $Id: AbstractSeq.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Index::AbstractSeq\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Index::AbstractSeq - base class for AbstractSeq\n\n=head1 SYNOPSIS\n\n  # Make a new sequence file indexing package\n\n  package MyShinyNewIndexer;\n\n  use base qw(Bio::Index::AbstractSeq);\n\n  # Now provide the necessary methods...\n\n=head1 DESCRIPTION\n\nProvides a common base class for multiple sequence files built using \nthe Bio::Index::Abstract system, and provides a Bio::DB::SeqI \ninterface.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions \npreferably to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. \nInternal methods are usually preceded with a _\n\n=head1 SEE ALSO\n\nL<Bio::Index::Abstract>, which provides dbm indexing for flat files of \nany type, containing sequence or not. L<Bio::Index::AbstractSeq> inherits \nfrom L<Bio::Index::Abstract>\n\n\n# Let's begin the code ...\n\npackage Bio::Index::AbstractSeq;\nuse strict;\n\nuse Bio::SeqIO::MultiFile;\n\nuse base qw(Bio::Index::Abstract Bio::DB::SeqI);\n\nsub new {\n\tmy ($class, @args) = @_;\n\tmy $self = $class->SUPER::new(@args);\n    \n\t$self->{'_seqio_cache'} = [];\n\treturn $self;\n}\n\n=head2 _file_format\n\n Title   : _file_format\n Usage   : $self->_file_format\n Function: Derived classes should override this\n           method (it throws an exception here)\n           to give the file format of the files used\n Example :\n Returns : \n Args    :\n\n\nsub _file_format {\n   my ($self,@args) = @_;\n\n   my $pkg = ref($self);\n   $self->throw(\"Class '$pkg' must provide a file format method correctly\");\n}\n\n=head2 fetch\n\n  Title   : fetch\n  Usage   : $index->fetch( $id )\n  Function: Returns a Bio::Seq object from the index\n  Example : $seq = $index->fetch( 'dJ67B12' )\n  Returns : Bio::Seq object\n  Args    : ID\n\n\nsub fetch {\n\tmy( $self, $id ) = @_;\n\tmy $db = $self->db();\n\tmy $seq;\n\n\tif (my $rec = $db->{ $id }) {\n\t\tmy ($file, $begin) = $self->unpack_record( $rec );\n        \n\t\t# Get the (possibly cached) SeqIO object\n\t\tmy $seqio = $self->_get_SeqIO_object( $file );\n\t\tmy $fh = $seqio->_fh();\n\n\t\t# move to start of record\n\t\t# $begin-- if( $^O =~ /mswin/i); # workaround for Win DB_File bug\n\t\tseek($fh, $begin, 0);\n\t\n\t\t$seq = $seqio->next_seq();\t\n\t}\n\n\t# we essentially assumme that the primary_id for the database\n\t# is the display_id\n\tif (ref($seq) && $seq->isa('Bio::PrimarySeqI') &&\n\t\t $seq->primary_id =~ /^\\D+$/) {\n\t\t$seq->primary_id( $seq->display_id() );\n\t}\n\treturn $seq;\n}\n\n=head2 _get_SeqIO_object\n\n  Title   : _get_SeqIO_object\n  Usage   : $index->_get_SeqIO_object( $file )\n  Function: Returns a Bio::SeqIO object for the file\n  Example : $seq = $index->_get_SeqIO_object( 0 )\n  Returns : Bio::SeqIO object\n  Args    : File number (an integer)\n\n\nsub _get_SeqIO_object {\n    my( $self, $i ) = @_;\n    \n    unless ($self->{'_seqio_cache'}[$i]) {\n        my $fh = $self->_file_handle($i);\n        # make a new SeqIO object\n        my $seqio = Bio::SeqIO->new( -Format => $self->_file_format,\n\t\t\t\t     -fh     => $fh);\n        $self->{'_seqio_cache'}[$i] = $seqio;\n    }\n    return $self->{'_seqio_cache'}[$i];\n}\n\n=head2 get_Seq_by_id\n\n Title   : get_Seq_by_id\n Usage   : $seq = $db->get_Seq_by_id()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the id\n\n\n\nsub get_Seq_by_id {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_Seq_by_acc\n\n Title   : get_Seq_by_acc\n Usage   : $seq = $db->get_Seq_by_acc()\n Function: retrieves a sequence object, identically to\n           ->fetch, but here behaving as a Bio::DB::BioSeqI\n Returns : new Bio::Seq object\n Args    : string represents the accession number\n\n\n\nsub get_Seq_by_acc {\n   my ($self,$id) = @_;\n\n   return $self->fetch($id);\n}\n\n=head2 get_PrimarySeq_stream\n\n Title   : get_PrimarySeq_stream\n Usage   : $stream = get_PrimarySeq_stream\n Function: Makes a Bio::DB::SeqStreamI compliant object\n           which provides a single method, next_primary_seq\n Returns : Bio::DB::SeqStreamI\n Args    : none\n\n\n\nsub get_PrimarySeq_stream {\n    my $self = shift;\n    my $num  = $self->_file_count() || 0;\n    my @file;\n    \n    for (my $i = 0; $i < $num; $i++) {\n        my( $file, $stored_size ) = $self->unpack_record( $self->db->{\"__FILE_$i\"} );\n\tpush(@file,$file);\n    }\n   \n    my $out = Bio::SeqIO::MultiFile->new( '-format' => $self->_file_format , -files => \\@file);\n    return $out;\n}\n\n=head2 get_all_primary_ids\n\n Title   : get_all_primary_ids\n Usage   : @ids = $seqdb->get_all_primary_ids()\n Function: gives an array of all the primary_ids of the \n           sequence objects in the database. These\n           maybe ids (display style) or accession numbers\n           or something else completely different - they\n           *are not* meaningful outside of this database\n           implementation.\n Example :\n Returns : an array of strings\n Args    : none\n\n\n\nsub get_all_primary_ids {\n   my ($self,@args) = @_;\n    my $db = $self->db;\n   \n   # the problem is here that we have indexed things both on\n   # accession number and name. \n\n   # We could take two options\n   # here - loop over the database, returning only one copy of each\n   # id that points to the same byte position, or we rely on semantics\n   # of accession numbers.\n\n   # someone is going to index a database with no accession numbers.\n   # doh!. We have to uniquify the index...\n\n   my( %bytepos );\n   while (my($id, $rec) = each %$db) {\n       if( $id =~ /^__/ ) {\n           # internal info\n           next;\n       }\n       my ($file, $begin) = $self->unpack_record( $rec );\n       \n       $bytepos{\"$file:$begin\"} = $id;\n   }\n\n   return values %bytepos;\n}\n\n\n=head2 get_Seq_by_primary_id\n\n Title   : get_Seq_by_primary_id\n Usage   : $seq = $db->get_Seq_by_primary_id($primary_id_string);\n Function: Gets a Bio::Seq object by the primary id. The primary\n           id in these cases has to come from $db->get_all_primary_ids.\n           There is no other way to get (or guess) the primary_ids\n           in a database.\n\n           The other possibility is to get Bio::PrimarySeqI objects\n           via the get_PrimarySeq_stream and the primary_id field\n           on these objects are specified as the ids to use here.\n Returns : A Bio::Seq object\n Args    : primary id (as a string)\n Throws  : \"acc does not exist\" exception","label":"get_Seq_by_primary_id($self,$id)"},"containerName":"main::","definition":"sub","line":310,"children":[{"kind":13,"line":311,"containerName":"get_Seq_by_primary_id","name":"$self","definition":"my","localvar":"my"},{"name":"$id","containerName":"get_Seq_by_primary_id","line":311,"kind":13},{"kind":13,"line":312,"name":"$self","containerName":"get_Seq_by_primary_id"},{"line":312,"kind":12,"containerName":"get_Seq_by_primary_id","name":"fetch"},{"name":"$id","containerName":"get_Seq_by_primary_id","line":312,"kind":13}],"kind":12,"range":{"start":{"line":310,"character":0},"end":{"line":313,"character":9999}},"name":"get_Seq_by_primary_id"}],"version":5}