{"version":5,"vars":[{"kind":12,"line":1,"name":"pod"},{"kind":2,"line":93,"name":"base","containerName":""},{"line":95,"kind":14,"containerName":"main::","name":"DEFAULT_VERSION","definition":1},{"line":96,"kind":13,"localvar":"my","name":"$RESERVED_TAGS","definition":"my","containerName":null},{"range":{"end":{"character":9999,"line":123},"start":{"line":98,"character":0}},"name":"_initialize","line":98,"children":[{"name":"$self","definition":"my","containerName":"_initialize","localvar":"my","kind":13,"line":99},{"containerName":"_initialize","name":"%arg","line":99,"kind":13},{"kind":13,"line":101,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"%arg","line":101,"kind":13},{"name":"$self","containerName":"_initialize","line":103,"kind":13},{"line":103,"kind":12,"name":"version","containerName":"_initialize"},{"kind":13,"line":103,"name":"$arg","containerName":"_initialize"},{"kind":13,"line":104,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"validate","line":104,"kind":12},{"name":"$arg","containerName":"_initialize","line":104,"kind":13},{"containerName":"_initialize","name":"$arg","line":106,"kind":13},{"line":107,"kind":13,"containerName":"_initialize","name":"$self"},{"line":107,"kind":12,"name":"_print","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":107,"kind":13},{"containerName":"_initialize","name":"version","line":107,"kind":12},{"kind":13,"line":110,"containerName":"_initialize","definition":"my","name":"$directive","localvar":"my"},{"containerName":"_initialize","name":"$directive","kind":13,"line":111},{"name":"$self","containerName":"_initialize","line":111,"kind":13},{"kind":12,"line":111,"name":"_readline","containerName":"_initialize"},{"name":"$directive","containerName":"_initialize","kind":13,"line":111},{"kind":13,"line":112,"containerName":"_initialize","name":"$self"},{"kind":12,"line":112,"containerName":"_initialize","name":"_handle_directive"},{"kind":13,"line":112,"containerName":"_initialize","name":"$directive"},{"name":"$self","containerName":"_initialize","line":114,"kind":13},{"containerName":"_initialize","name":"_pushback","kind":12,"line":114},{"line":114,"kind":13,"name":"$directive","containerName":"_initialize"},{"line":118,"kind":13,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"validate","line":118,"kind":12},{"containerName":"_initialize","name":"$self","kind":13,"line":119},{"kind":12,"line":119,"name":"so","containerName":"_initialize"},{"name":"get_ontology","containerName":"_initialize","line":120,"kind":12}],"kind":12,"detail":"($self,%arg)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"%arg"}],"label":"_initialize($self,%arg)"},"containerName":"main::","definition":"sub"},{"name":"SUPER","containerName":"_initialize","kind":12,"line":101},{"kind":12,"line":103,"name":"DEFAULT_VERSION"},{"kind":12,"line":120,"containerName":"Ontology::OntologyStore","name":"Bio"},{"kind":12,"children":[{"kind":13,"line":135,"containerName":"next_feature","name":"$self","definition":"my","localvar":"my"},{"containerName":"next_feature","definition":"my","name":"$gff_string","localvar":"my","kind":13,"line":136},{"localvar":"my","containerName":"next_feature","definition":"my","name":"$f","line":138,"kind":13},{"kind":13,"line":138,"name":"$self","containerName":"next_feature"},{"containerName":"next_feature","name":"_buffer_feature","line":138,"kind":12},{"name":"$f","containerName":"next_feature","kind":13,"line":139},{"name":"$f","containerName":"next_feature","kind":13,"line":140},{"line":143,"kind":13,"name":"$self","containerName":"next_feature"},{"kind":12,"line":143,"containerName":"next_feature","name":"fasta_mode"},{"line":147,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"kind":13,"line":147,"name":"$self","containerName":"next_feature"},{"name":"_readline","containerName":"next_feature","line":147,"kind":12},{"name":"$gff_string","containerName":"next_feature","kind":13,"line":147},{"name":"$gff_string","containerName":"next_feature","kind":13,"line":148},{"kind":13,"line":149,"name":"$gff_string","containerName":"next_feature"},{"line":153,"kind":13,"name":"$gff_string","containerName":"next_feature"},{"line":156,"kind":13,"name":"$gff_string","containerName":"next_feature"},{"name":"$self","containerName":"next_feature","kind":13,"line":157},{"line":157,"kind":12,"name":"_pushback","containerName":"next_feature"},{"name":"$gff_string","containerName":"next_feature","kind":13,"line":157},{"name":"$self","containerName":"next_feature","kind":13,"line":158},{"kind":12,"line":158,"name":"fasta_mode","containerName":"next_feature"},{"line":163,"kind":13,"containerName":"next_feature","name":"$gff_string"},{"line":164,"kind":13,"name":"$self","containerName":"next_feature"},{"kind":12,"line":164,"name":"_handle_directive","containerName":"next_feature"},{"name":"$gff_string","containerName":"next_feature","line":164,"kind":13},{"line":166,"kind":13,"name":"$self","containerName":"next_feature"},{"line":166,"kind":12,"containerName":"next_feature","name":"next_feature"},{"line":171,"kind":13,"name":"$self","containerName":"next_feature"},{"kind":12,"line":171,"name":"_handle_feature","containerName":"next_feature"},{"kind":13,"line":171,"name":"$gff_string","containerName":"next_feature"}],"line":134,"name":"next_feature","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":173},"start":{"line":134,"character":0}}},{"line":197,"children":[{"line":198,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_feature_group"},{"containerName":"next_feature_group","definition":"my","name":"$feat","localvar":"my","kind":13,"line":200},{"containerName":"next_feature_group","definition":"my","name":"%seen_ids","localvar":"my","kind":13,"line":201},{"line":202,"kind":13,"localvar":"my","containerName":"next_feature_group","name":"@all_feats","definition":"my"},{"kind":13,"line":203,"definition":"my","name":"@toplevel_feats","containerName":"next_feature_group","localvar":"my"},{"line":205,"kind":13,"containerName":"next_feature_group","name":"$self"},{"line":207,"kind":13,"name":"$self","containerName":"next_feature_group"},{"containerName":"next_feature_group","name":"$feat","kind":13,"line":207},{"containerName":"next_feature_group","name":"$self","line":207,"kind":13},{"name":"next_feature","containerName":"next_feature_group","line":207,"kind":12},{"name":"$feat","containerName":"next_feature_group","line":207,"kind":13},{"line":210,"kind":13,"localvar":"my","containerName":"next_feature_group","name":"$anno_ID","definition":"my"},{"name":"$feat","containerName":"next_feature_group","line":210,"kind":13},{"name":"get_Annotations","containerName":"next_feature_group","line":210,"kind":12},{"line":211,"kind":13,"containerName":"next_feature_group","name":"$anno_ID"},{"localvar":"my","definition":"my","name":"$attr_ID","containerName":"next_feature_group","line":212,"kind":13},{"name":"$anno_ID","containerName":"next_feature_group","line":212,"kind":13},{"line":212,"kind":12,"containerName":"next_feature_group","name":"value"},{"name":"$self","containerName":"next_feature_group","line":213,"kind":13},{"line":213,"kind":12,"name":"throw","containerName":"next_feature_group"},{"kind":13,"line":214,"name":"$seen_ids","containerName":"next_feature_group"},{"kind":13,"line":214,"name":"$attr_ID","containerName":"next_feature_group"},{"name":"$seen_ids","containerName":"next_feature_group","kind":13,"line":215},{"kind":13,"line":215,"containerName":"next_feature_group","name":"$attr_ID"},{"name":"$feat","containerName":"next_feature_group","line":215,"kind":13},{"line":217,"kind":13,"containerName":"next_feature_group","name":"@all_feats"},{"line":217,"kind":13,"name":"$feat","containerName":"next_feature_group"},{"containerName":"next_feature_group","name":"$feat","kind":13,"line":221},{"line":221,"kind":13,"name":"@all_feats","containerName":"next_feature_group"},{"kind":13,"line":222,"containerName":"next_feature_group","name":"@parents","definition":"my","localvar":"my"},{"line":222,"kind":13,"containerName":"next_feature_group","name":"$feat"},{"name":"get_Annotations","containerName":"next_feature_group","kind":12,"line":222},{"line":223,"kind":13,"containerName":"next_feature_group","name":"@parents"},{"kind":13,"line":224,"name":"$parent","definition":"my","containerName":"next_feature_group","localvar":"my"},{"containerName":"next_feature_group","name":"@parents","kind":13,"line":224},{"localvar":"my","definition":"my","name":"$parent_id","containerName":"next_feature_group","line":225,"kind":13},{"name":"$parent","containerName":"next_feature_group","line":225,"kind":13},{"containerName":"next_feature_group","name":"value","line":225,"kind":12},{"name":"$self","containerName":"next_feature_group","kind":13,"line":226},{"line":226,"kind":12,"name":"throw","containerName":"next_feature_group"},{"line":226,"kind":13,"containerName":"next_feature_group","name":"$seen_ids"},{"kind":13,"line":226,"name":"$parent_id","containerName":"next_feature_group"},{"line":227,"kind":13,"containerName":"next_feature_group","name":"$seen_ids"},{"kind":13,"line":227,"name":"$parent_id","containerName":"next_feature_group"},{"name":"add_SeqFeature","containerName":"next_feature_group","kind":12,"line":227},{"containerName":"next_feature_group","name":"$feat","line":227,"kind":13},{"name":"@toplevel_feats","containerName":"next_feature_group","kind":13,"line":230},{"kind":13,"line":230,"containerName":"next_feature_group","name":"$feat"},{"containerName":"next_feature_group","name":"@toplevel_feats","kind":13,"line":234}],"kind":12,"range":{"end":{"line":235,"character":9999},"start":{"line":197,"character":0}},"containerName":"main::","name":"next_feature_group","definition":"sub"},{"line":205,"kind":12,"name":"group_not_done"},{"name":"group_not_done","kind":12,"line":207},{"name":"next_seq","range":{"end":{"line":253,"character":9999},"start":{"line":244,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled","parameters":[],"label":"next_seq()"},"detail":"()","kind":12,"children":[{"localvar":"my","containerName":"next_seq","definition":"my","name":"$self","line":245,"kind":13},{"line":246,"kind":13,"containerName":"next_seq","name":"$self"},{"line":246,"kind":12,"name":"fasta_mode","containerName":"next_seq"},{"name":"$self","containerName":"next_seq","kind":13,"line":249},{"containerName":"next_seq","name":"seqio","kind":12,"line":249},{"containerName":"next_seq","name":"$self","line":250,"kind":13},{"containerName":"next_seq","name":"seqio","kind":12,"line":250},{"containerName":"next_seq","name":"new","line":250,"kind":12},{"kind":13,"line":250,"name":"$self","containerName":"next_seq"},{"name":"_fh","containerName":"next_seq","line":250,"kind":12},{"line":252,"kind":13,"name":"$self","containerName":"next_seq"},{"line":252,"kind":12,"containerName":"next_seq","name":"seqio"},{"containerName":"next_seq","name":"next_seq","kind":12,"line":252}],"line":244},{"line":250,"kind":12,"name":"Bio","containerName":"SeqIO"},{"kind":12,"children":[{"containerName":"write_feature","definition":"my","name":"$self","localvar":"my","kind":13,"line":267},{"containerName":"write_feature","name":"$feature","line":267,"kind":13},{"line":268,"kind":13,"name":"$feature","containerName":"write_feature"},{"line":269,"kind":13,"containerName":"write_feature","name":"$self"},{"line":269,"kind":12,"containerName":"write_feature","name":"throw"},{"line":271,"kind":13,"name":"$self","containerName":"write_feature"},{"containerName":"write_feature","name":"throw","kind":12,"line":271},{"line":271,"kind":13,"name":"$feature","containerName":"write_feature"},{"kind":12,"line":271,"containerName":"write_feature","name":"isa"},{"name":"$self","containerName":"write_feature","kind":13,"line":273},{"name":"version","containerName":"write_feature","line":273,"kind":12},{"kind":13,"line":274,"name":"$self","containerName":"write_feature"},{"kind":12,"line":274,"containerName":"write_feature","name":"_write_feature_1"},{"line":274,"kind":13,"containerName":"write_feature","name":"$feature"},{"kind":13,"line":275,"name":"$self","containerName":"write_feature"},{"containerName":"write_feature","name":"version","kind":12,"line":275},{"line":276,"kind":13,"containerName":"write_feature","name":"$self"},{"containerName":"write_feature","name":"_write_feature_2","kind":12,"line":276},{"line":276,"kind":13,"name":"$feature","containerName":"write_feature"},{"name":"$self","containerName":"write_feature","kind":13,"line":277},{"line":277,"kind":12,"containerName":"write_feature","name":"version"},{"line":278,"kind":13,"name":"$self","containerName":"write_feature"},{"line":278,"kind":12,"containerName":"write_feature","name":"_write_feature_25"},{"containerName":"write_feature","name":"$feature","kind":13,"line":278},{"name":"$self","containerName":"write_feature","kind":13,"line":279},{"kind":12,"line":279,"name":"version","containerName":"write_feature"},{"containerName":"write_feature","name":"$self","kind":13,"line":280},{"line":280,"kind":12,"name":"_write_feature_3","containerName":"write_feature"},{"name":"$feature","containerName":"write_feature","line":280,"kind":13},{"line":282,"kind":13,"containerName":"write_feature","name":"$self"},{"containerName":"write_feature","name":"throw","kind":12,"line":282},{"containerName":"write_feature","name":"$self","line":282,"kind":13},{"line":282,"kind":12,"name":"version","containerName":"write_feature"}],"line":266,"definition":"sub","containerName":"main::","signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.","parameters":[{"label":"$self"},{"label":"$feature"}],"label":"write_feature($self,$feature)"},"detail":"($self,$feature)","name":"write_feature","range":{"start":{"character":0,"line":266},"end":{"line":284,"character":9999}}},{"line":303,"children":[{"containerName":"fasta_mode","name":"$self","definition":"my","localvar":"my","kind":13,"line":304},{"line":304,"kind":13,"name":"$val","containerName":"fasta_mode"},{"name":"$self","containerName":"fasta_mode","kind":13,"line":305},{"kind":13,"line":305,"name":"$val","containerName":"fasta_mode"},{"name":"$val","containerName":"fasta_mode","line":305,"kind":13},{"kind":13,"line":306,"name":"$self","containerName":"fasta_mode"}],"kind":12,"detail":"($self,$val)","signature":{"label":"fasta_mode($self,$val)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":303},"end":{"character":9999,"line":307}},"name":"fasta_mode"},{"detail":"($self,$val)","signature":{"label":"seqio($self,$val)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","line":319,"children":[{"kind":13,"line":320,"containerName":"seqio","name":"$self","definition":"my","localvar":"my"},{"containerName":"seqio","name":"$val","line":320,"kind":13},{"containerName":"seqio","name":"$self","kind":13,"line":321},{"line":321,"kind":13,"containerName":"seqio","name":"$val"},{"name":"$val","containerName":"seqio","kind":13,"line":321},{"kind":13,"line":322,"name":"$self","containerName":"seqio"}],"kind":12,"range":{"start":{"line":319,"character":0},"end":{"character":9999,"line":323}},"name":"seqio"},{"kind":12,"line":335,"children":[{"containerName":"sequence_region","definition":"my","name":"$self","localvar":"my","kind":13,"line":336},{"name":"$k","containerName":"sequence_region","kind":13,"line":336},{"line":336,"kind":13,"name":"$v","containerName":"sequence_region"},{"line":337,"kind":13,"containerName":"sequence_region","name":"$k"},{"name":"$v","containerName":"sequence_region","line":337,"kind":13},{"line":338,"kind":13,"containerName":"sequence_region","name":"$self"},{"line":338,"kind":13,"name":"$k","containerName":"sequence_region"},{"line":338,"kind":13,"containerName":"sequence_region","name":"$v"},{"name":"$v","containerName":"sequence_region","kind":13,"line":339},{"kind":13,"line":341,"containerName":"sequence_region","name":"$k"},{"line":342,"kind":13,"containerName":"sequence_region","name":"$self"},{"line":342,"kind":13,"name":"$k","containerName":"sequence_region"}],"containerName":"main::","definition":"sub","detail":"($self,$k,$v)","signature":{"parameters":[{"label":"$self"},{"label":"$k"},{"label":"$v"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :","label":"sequence_region($self,$k,$v)"},"name":"sequence_region","range":{"start":{"character":0,"line":335},"end":{"character":9999,"line":347}}},{"children":[{"line":360,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"so"},{"localvar":"my","containerName":"so","definition":"my","name":"$val","line":361,"kind":13},{"name":"$self","containerName":"so","kind":13,"line":363},{"name":"$val","containerName":"so","line":363,"kind":13},{"kind":13,"line":363,"name":"$val","containerName":"so"},{"containerName":"so","name":"$self","kind":13,"line":364}],"line":359,"kind":12,"range":{"start":{"line":359,"character":0},"end":{"character":9999,"line":365}},"definition":"sub","name":"so","containerName":"main::"},{"name":"so","kind":12,"line":363},{"line":364,"kind":12,"name":"so"},{"detail":"($self,$val)","signature":{"label":"validate($self,$val)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","parameters":[{"label":"$self"},{"label":"$val"}]},"containerName":"main::","definition":"sub","line":378,"children":[{"localvar":"my","containerName":"validate","definition":"my","name":"$self","line":379,"kind":13},{"name":"$val","containerName":"validate","kind":13,"line":379},{"kind":13,"line":380,"name":"$self","containerName":"validate"},{"containerName":"validate","name":"$val","kind":13,"line":380},{"line":380,"kind":13,"name":"$val","containerName":"validate"},{"line":381,"kind":13,"containerName":"validate","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":378},"end":{"line":382,"character":9999}},"name":"validate"},{"range":{"start":{"line":393,"character":0},"end":{"line":404,"character":9999}},"containerName":"main::","name":"version","definition":"sub","line":393,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"version","line":394,"kind":13},{"kind":13,"line":395,"containerName":"version","name":"$val","definition":"my","localvar":"my"},{"line":396,"kind":13,"localvar":"my","containerName":"version","definition":"my","name":"%valid"},{"kind":13,"line":397,"name":"$val","containerName":"version"},{"line":397,"kind":13,"containerName":"version","name":"$valid"},{"name":"$val","containerName":"version","kind":13,"line":397},{"name":"$self","containerName":"version","line":398,"kind":13},{"containerName":"version","name":"$val","kind":13,"line":398},{"name":"$val","containerName":"version","line":400,"kind":13},{"name":"$self","containerName":"version","line":401,"kind":13},{"name":"throw","containerName":"version","kind":12,"line":401},{"kind":13,"line":401,"containerName":"version","name":"%valid"},{"kind":13,"line":403,"containerName":"version","name":"$self"}],"kind":12},{"line":421,"children":[{"line":422,"kind":13,"localvar":"my","containerName":"_buffer_feature","definition":"my","name":"$self"},{"containerName":"_buffer_feature","name":"$f","kind":13,"line":422},{"name":"$f","containerName":"_buffer_feature","line":424,"kind":13},{"containerName":"_buffer_feature","name":"$self","kind":13,"line":425},{"name":"$f","containerName":"_buffer_feature","kind":13,"line":425},{"containerName":"_buffer_feature","name":"$f","line":426,"kind":13}],"kind":12,"detail":"($self,$f)","signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$f"}],"label":"_buffer_feature($self,$f)"},"containerName":"main::","definition":"sub","range":{"start":{"line":421,"character":0},"end":{"character":9999,"line":427}},"name":"_buffer_feature"},{"kind":13,"line":428,"containerName":null,"name":"%self"},{"name":"%self","containerName":null,"kind":13,"line":429},{"children":[{"line":444,"kind":13,"localvar":"my","containerName":"_handle_directive","definition":"my","name":"$self"},{"line":444,"kind":13,"name":"$directive_string","containerName":"_handle_directive"},{"containerName":"_handle_directive","name":"$directive_string","kind":13,"line":446},{"containerName":"_handle_directive","name":"$directive","definition":"my","localvar":"my","kind":13,"line":447},{"line":447,"kind":13,"containerName":"_handle_directive","name":"@arg"},{"line":447,"kind":13,"containerName":"_handle_directive","name":"$directive_string"},{"containerName":"_handle_directive","name":"$directive","kind":13,"line":449},{"line":450,"kind":13,"localvar":"my","definition":"my","name":"$version","containerName":"_handle_directive"},{"containerName":"_handle_directive","name":"$arg","kind":13,"line":450},{"containerName":"_handle_directive","name":"$version","kind":13,"line":451},{"name":"$self","containerName":"_handle_directive","kind":13,"line":452},{"name":"throw","containerName":"_handle_directive","kind":12,"line":452},{"containerName":"_handle_directive","name":"$directive","line":456,"kind":13},{"kind":13,"line":461,"name":"$self","containerName":"_handle_directive"},{"line":461,"kind":12,"containerName":"_handle_directive","name":"throw"},{"line":462,"kind":13,"name":"$arg","containerName":"_handle_directive"},{"name":"$arg","containerName":"_handle_directive","line":462,"kind":13},{"localvar":"my","name":"$fta","definition":"my","containerName":"_handle_directive","line":463,"kind":13},{"kind":12,"line":463,"name":"new","containerName":"_handle_directive"},{"containerName":"_handle_directive","name":"$fta","line":464,"kind":13},{"containerName":"_handle_directive","name":"name","kind":12,"line":464},{"kind":13,"line":466,"containerName":"_handle_directive","definition":"my","name":"$f","localvar":"my"},{"kind":12,"line":466,"name":"new","containerName":"_handle_directive"},{"name":"$f","containerName":"_handle_directive","line":467,"kind":13},{"kind":12,"line":467,"name":"seq_id","containerName":"_handle_directive"},{"containerName":"_handle_directive","name":"$arg","line":467,"kind":13},{"kind":13,"line":468,"containerName":"_handle_directive","name":"$f"},{"kind":12,"line":468,"name":"start","containerName":"_handle_directive"},{"containerName":"_handle_directive","name":"$arg","kind":13,"line":468},{"name":"$f","containerName":"_handle_directive","line":469,"kind":13},{"name":"end","containerName":"_handle_directive","kind":12,"line":469},{"line":469,"kind":13,"containerName":"_handle_directive","name":"$arg"},{"containerName":"_handle_directive","name":"$f","kind":13,"line":471},{"line":471,"kind":12,"name":"type","containerName":"_handle_directive"},{"name":"$fta","containerName":"_handle_directive","line":471,"kind":13},{"kind":13,"line":474,"name":"$self","containerName":"_handle_directive"},{"name":"sequence_region","containerName":"_handle_directive","line":474,"kind":12},{"line":474,"kind":13,"containerName":"_handle_directive","name":"$f"},{"kind":12,"line":474,"name":"seq_id","containerName":"_handle_directive"},{"line":474,"kind":13,"containerName":"_handle_directive","name":"$f"},{"kind":13,"line":478,"containerName":"_handle_directive","name":"$self"},{"line":478,"kind":12,"name":"_buffer_feature","containerName":"_handle_directive"},{"containerName":"_handle_directive","name":"$f","line":478,"kind":13},{"kind":13,"line":481,"name":"$directive","containerName":"_handle_directive"},{"containerName":"_handle_directive","name":"$self","kind":13,"line":482},{"line":482,"kind":12,"name":"warn","containerName":"_handle_directive"},{"name":"$directive","containerName":"_handle_directive","kind":13,"line":485},{"line":486,"kind":13,"containerName":"_handle_directive","name":"$self"},{"line":486,"kind":12,"containerName":"_handle_directive","name":"warn"},{"name":"$directive","containerName":"_handle_directive","kind":13,"line":489},{"name":"$self","containerName":"_handle_directive","line":490,"kind":13},{"line":490,"kind":12,"name":"warn","containerName":"_handle_directive"},{"containerName":"_handle_directive","name":"$directive","kind":13,"line":493},{"name":"$directive","containerName":"_handle_directive","line":493,"kind":13},{"line":495,"kind":13,"name":"$self","containerName":"_handle_directive"},{"kind":12,"line":495,"name":"fasta_mode","containerName":"_handle_directive"},{"kind":13,"line":499,"containerName":"_handle_directive","name":"$directive"},{"kind":13,"line":501,"containerName":"_handle_directive","name":"$self"},{"line":504,"kind":13,"containerName":"_handle_directive","name":"$directive"},{"containerName":"_handle_directive","definition":"my","name":"$organism","localvar":"my","kind":13,"line":505},{"name":"$arg","containerName":"_handle_directive","line":505,"kind":13},{"line":506,"kind":13,"containerName":"_handle_directive","name":"$self"},{"name":"organism","containerName":"_handle_directive","kind":12,"line":506},{"kind":13,"line":506,"containerName":"_handle_directive","name":"$organism"},{"line":510,"kind":13,"name":"$self","containerName":"_handle_directive"},{"kind":12,"line":510,"name":"throw","containerName":"_handle_directive"},{"kind":13,"line":510,"name":"$directive","containerName":"_handle_directive"}],"line":443,"kind":12,"signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.","parameters":[{"label":"$self"},{"label":"$directive_string"}],"label":"_handle_directive($self,$directive_string)"},"detail":"($self,$directive_string)","definition":"sub","containerName":"main::","range":{"start":{"line":443,"character":0},"end":{"line":512,"character":9999}},"name":"_handle_directive"},{"line":463,"kind":12,"name":"Bio","containerName":"Annotation::OntologyTerm"},{"name":"Bio","containerName":"SeqFeature::Annotated","kind":12,"line":466},{"kind":12,"line":501,"name":"group_not_done"},{"signature":{"label":"_handle_feature($self,$feature_string)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.","parameters":[{"label":"$self"},{"label":"$feature_string"}]},"detail":"($self,$feature_string)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"_handle_feature","localvar":"my","kind":13,"line":522},{"kind":13,"line":522,"name":"$feature_string","containerName":"_handle_feature"},{"line":524,"kind":13,"localvar":"my","containerName":"_handle_feature","name":"$feat","definition":"my"},{"containerName":"_handle_feature","name":"new","line":524,"kind":12},{"localvar":"my","containerName":"_handle_feature","definition":"my","name":"$seq","line":526,"kind":13},{"kind":13,"line":526,"name":"$source","containerName":"_handle_feature"},{"line":526,"kind":13,"name":"$type","containerName":"_handle_feature"},{"name":"$start","containerName":"_handle_feature","line":526,"kind":13},{"name":"$end","containerName":"_handle_feature","line":526,"kind":13},{"line":526,"kind":13,"name":"$score","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$strand","kind":13,"line":526},{"kind":13,"line":526,"containerName":"_handle_feature","name":"$phase"},{"containerName":"_handle_feature","name":"$attribute_string","line":526,"kind":13},{"kind":13,"line":526,"name":"$feature_string","containerName":"_handle_feature"},{"line":528,"kind":13,"containerName":"_handle_feature","name":"$feat"},{"kind":12,"line":528,"containerName":"_handle_feature","name":"seq_id"},{"kind":13,"line":528,"name":"$seq","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$feat","line":529,"kind":13},{"kind":12,"line":529,"containerName":"_handle_feature","name":"source_tag"},{"containerName":"_handle_feature","name":"$source","line":529,"kind":13},{"line":530,"kind":13,"containerName":"_handle_feature","name":"$feat"},{"line":530,"kind":12,"name":"start","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$start","kind":13,"line":530},{"containerName":"_handle_feature","name":"$start","line":530,"kind":13},{"containerName":"_handle_feature","name":"$feat","kind":13,"line":531},{"containerName":"_handle_feature","name":"end","line":531,"kind":12},{"containerName":"_handle_feature","name":"$end","kind":13,"line":531},{"kind":13,"line":531,"name":"$end","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$feat","line":532,"kind":13},{"containerName":"_handle_feature","name":"strand","kind":12,"line":532},{"containerName":"_handle_feature","name":"$strand","line":532,"kind":13},{"containerName":"_handle_feature","name":"$strand","kind":13,"line":532},{"containerName":"_handle_feature","name":"$feat","line":533,"kind":13},{"containerName":"_handle_feature","name":"score","kind":12,"line":533},{"containerName":"_handle_feature","name":"$score","line":533,"kind":13},{"line":534,"kind":13,"name":"$feat","containerName":"_handle_feature"},{"kind":12,"line":534,"name":"phase","containerName":"_handle_feature"},{"name":"$phase","containerName":"_handle_feature","line":534,"kind":13},{"line":536,"kind":13,"localvar":"my","containerName":"_handle_feature","name":"$fta","definition":"my"},{"kind":12,"line":536,"containerName":"_handle_feature","name":"new"},{"kind":13,"line":538,"name":"$self","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"validate","line":538,"kind":12},{"containerName":"_handle_feature","name":"$seq","line":541,"kind":13},{"name":"$self","containerName":"_handle_feature","kind":13,"line":542},{"name":"throw","containerName":"_handle_feature","kind":12,"line":542},{"name":"$seq","containerName":"_handle_feature","line":545,"kind":13},{"name":"$self","containerName":"_handle_feature","line":546,"kind":13},{"line":546,"kind":12,"name":"throw","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$seq","kind":13,"line":550},{"line":551,"kind":13,"containerName":"_handle_feature","name":"$self"},{"kind":12,"line":551,"containerName":"_handle_feature","name":"throw"},{"containerName":"_handle_feature","name":"$start","line":557,"kind":13},{"containerName":"_handle_feature","name":"$end","kind":13,"line":557},{"kind":13,"line":558,"containerName":"_handle_feature","name":"$self"},{"line":558,"kind":12,"containerName":"_handle_feature","name":"throw"},{"line":561,"kind":13,"localvar":"my","definition":"my","name":"$region","containerName":"_handle_feature"},{"line":561,"kind":13,"containerName":"_handle_feature","name":"$self"},{"line":561,"kind":12,"name":"sequence_region","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$seq","line":561,"kind":13},{"name":"$region","containerName":"_handle_feature","kind":13,"line":565},{"name":"$start","containerName":"_handle_feature","line":565,"kind":13},{"containerName":"_handle_feature","name":"$region","kind":13,"line":565},{"line":565,"kind":12,"name":"start","containerName":"_handle_feature"},{"line":565,"kind":13,"containerName":"_handle_feature","name":"$end"},{"name":"$region","containerName":"_handle_feature","kind":13,"line":565},{"kind":12,"line":565,"containerName":"_handle_feature","name":"end"},{"name":"$self","containerName":"_handle_feature","line":566,"kind":13},{"containerName":"_handle_feature","name":"throw","kind":12,"line":566},{"name":"$self","containerName":"_handle_feature","line":571,"kind":13},{"line":571,"kind":12,"containerName":"_handle_feature","name":"throw"},{"name":"$strand","containerName":"_handle_feature","line":571,"kind":13},{"kind":13,"line":574,"name":"$self","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"throw","line":574,"kind":12},{"name":"$phase","containerName":"_handle_feature","line":574,"kind":13},{"containerName":"_handle_feature","definition":"my","name":"$feature_type","localvar":"my","kind":13,"line":576},{"kind":13,"line":577,"containerName":"_handle_feature","name":"$type"},{"line":579,"kind":13,"containerName":"_handle_feature","name":"$feature_type"},{"containerName":"_handle_feature","name":"$self","line":579,"kind":13},{"line":579,"kind":12,"name":"so","containerName":"_handle_feature"},{"name":"find_terms","containerName":"_handle_feature","line":579,"kind":12},{"containerName":"_handle_feature","name":"$type","kind":13,"line":579},{"name":"$feature_type","containerName":"_handle_feature","line":582,"kind":13},{"containerName":"_handle_feature","name":"$self","line":582,"kind":13},{"name":"so","containerName":"_handle_feature","line":582,"kind":12},{"kind":12,"line":582,"containerName":"_handle_feature","name":"find_terms"},{"name":"$type","containerName":"_handle_feature","kind":13,"line":582},{"name":"$feature_type","containerName":"_handle_feature","kind":13,"line":585},{"containerName":"_handle_feature","name":"$self","line":586,"kind":13},{"name":"throw","containerName":"_handle_feature","kind":12,"line":586},{"containerName":"_handle_feature","name":"$fta","kind":13,"line":588},{"containerName":"_handle_feature","name":"term","line":588,"kind":12},{"containerName":"_handle_feature","name":"$feature_type","kind":13,"line":588},{"containerName":"_handle_feature","name":"$type","line":591,"kind":13},{"line":593,"kind":13,"containerName":"_handle_feature","name":"$fta"},{"containerName":"_handle_feature","name":"identifier","line":593,"kind":12},{"name":"$type","containerName":"_handle_feature","line":593,"kind":13},{"name":"$fta","containerName":"_handle_feature","line":595,"kind":13},{"name":"name","containerName":"_handle_feature","line":595,"kind":12},{"containerName":"_handle_feature","name":"$type","kind":13,"line":595},{"name":"$feat","containerName":"_handle_feature","line":599,"kind":13},{"kind":12,"line":599,"name":"type","containerName":"_handle_feature"},{"line":599,"kind":13,"name":"$fta","containerName":"_handle_feature"},{"line":601,"kind":13,"localvar":"my","definition":"my","name":"%attr","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$attribute_string","kind":13,"line":602},{"name":"$attribute_string","containerName":"_handle_feature","kind":13,"line":604},{"localvar":"my","containerName":"_handle_feature","definition":"my","name":"@attributes","line":605,"kind":13},{"line":605,"kind":13,"name":"$attribute_string","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$attribute","definition":"my","localvar":"my","kind":13,"line":606},{"name":"@attributes","containerName":"_handle_feature","line":606,"kind":13},{"kind":13,"line":607,"name":"$key","definition":"my","containerName":"_handle_feature","localvar":"my"},{"kind":13,"line":607,"name":"$values","containerName":"_handle_feature"},{"kind":13,"line":607,"name":"$attribute","containerName":"_handle_feature"},{"kind":13,"line":610,"containerName":"_handle_feature","name":"$values"},{"line":611,"kind":13,"containerName":"_handle_feature","name":"$values"},{"localvar":"my","name":"@values","definition":"my","containerName":"_handle_feature","line":613,"kind":13},{"kind":13,"line":613,"containerName":"_handle_feature","name":"$values"},{"containerName":"_handle_feature","name":"$attr","kind":13,"line":616},{"containerName":"_handle_feature","name":"$key","line":616,"kind":13},{"line":617,"kind":13,"localvar":"my","name":"@tmparray","definition":"my","containerName":"_handle_feature"},{"containerName":"_handle_feature","name":"$attr","kind":13,"line":617},{"containerName":"_handle_feature","name":"$key","kind":13,"line":617},{"kind":13,"line":618,"name":"@tmparray","containerName":"_handle_feature"},{"kind":13,"line":618,"name":"@values","containerName":"_handle_feature"},{"name":"$attr","containerName":"_handle_feature","line":619,"kind":13},{"kind":13,"line":619,"name":"$key","containerName":"_handle_feature"},{"line":619,"kind":13,"containerName":"_handle_feature","name":"@tmparray"},{"line":621,"kind":13,"containerName":"_handle_feature","name":"$attr"},{"line":621,"kind":13,"name":"$key","containerName":"_handle_feature"},{"name":"@values","containerName":"_handle_feature","line":621,"kind":13}],"line":521,"kind":12,"range":{"start":{"character":0,"line":521},"end":{"line":624,"character":9999}},"name":"_handle_feature"},{"kind":12,"line":524,"containerName":"SeqFeature::Annotated","name":"Bio"},{"containerName":"Annotation::OntologyTerm","name":"Bio","kind":12,"line":536},{"kind":12,"line":613,"name":"uri_unescape"},{"name":"%attr","containerName":null,"kind":13,"line":627},{"name":"Dbxref","line":627,"kind":12},{"name":"%attr","containerName":null,"line":627,"kind":13},{"name":"dbxref","kind":12,"line":627},{"kind":13,"line":628,"containerName":null,"definition":"my","name":"$value","localvar":"my"},{"kind":13,"line":628,"containerName":null,"name":"%attr"},{"name":"Dbxref","kind":12,"line":628},{"kind":13,"line":628,"containerName":null,"name":"%attr"},{"name":"dbxref","line":628,"kind":12},{"localvar":"my","definition":"my","name":"$a","containerName":null,"line":629,"kind":13},{"containerName":"Annotation::DBLink","name":"Bio","line":629,"kind":12},{"kind":12,"line":629,"containerName":"main::","name":"new"},{"localvar":"my","containerName":null,"name":"$db","definition":"my","line":630,"kind":13},{"containerName":null,"name":"$accession","line":630,"kind":13},{"name":"$value","containerName":null,"kind":13,"line":630},{"kind":13,"line":632,"name":"$db","containerName":null},{"containerName":null,"name":"%accession","kind":13,"line":632},{"kind":13,"line":633,"containerName":null,"name":"$self"},{"name":"throw","containerName":"main::","line":633,"kind":12},{"containerName":null,"name":"$a","line":637,"kind":13},{"name":"database","containerName":"main::","kind":12,"line":637},{"containerName":null,"name":"$db","kind":13,"line":637},{"containerName":null,"name":"$a","line":638,"kind":13},{"kind":12,"line":638,"containerName":"main::","name":"primary_id"},{"containerName":null,"name":"$accession","kind":13,"line":638},{"name":"$feat","containerName":null,"line":639,"kind":13},{"name":"add_Annotation","containerName":"main::","kind":12,"line":639},{"name":"$a","containerName":null,"kind":13,"line":639},{"containerName":null,"name":"%attr","kind":13,"line":644},{"line":644,"kind":12,"name":"Ontology_term"},{"line":645,"kind":13,"localvar":"my","definition":"my","name":"$id","containerName":null},{"containerName":null,"name":"%attr","kind":13,"line":645},{"name":"Ontology_term","line":645,"kind":12},{"line":646,"kind":13,"localvar":"my","definition":"my","name":"$a","containerName":null},{"line":646,"kind":12,"containerName":"Annotation::OntologyTerm","name":"Bio"},{"line":646,"kind":12,"name":"new","containerName":"main::"},{"line":648,"kind":13,"name":"$self","containerName":null},{"name":"validate","containerName":"main::","line":648,"kind":12},{"kind":13,"line":649,"definition":"my","name":"$ont_name","containerName":null,"localvar":"my"},{"containerName":"Ontology::OntologyStore","name":"Bio","line":649,"kind":12},{"line":649,"kind":12,"name":"guess_ontology","containerName":"main::"},{"name":"$id","containerName":null,"line":649,"kind":13},{"line":650,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$ont"},{"kind":12,"line":650,"containerName":"Ontology::OntologyStore","name":"Bio"},{"containerName":"main::","name":"get_ontology","kind":12,"line":650},{"line":650,"kind":13,"containerName":null,"name":"$ont_name"},{"line":651,"kind":13,"localvar":"my","containerName":null,"name":"$term","definition":"my"},{"line":651,"kind":13,"containerName":null,"name":"$ont"},{"line":651,"kind":12,"name":"find_terms","containerName":"main::"},{"name":"$id","containerName":null,"line":651,"kind":13},{"name":"$a","containerName":null,"line":652,"kind":13},{"name":"term","containerName":"main::","kind":12,"line":652},{"name":"%term","containerName":null,"line":652,"kind":13},{"name":"$a","containerName":null,"line":654,"kind":13},{"name":"identifier","containerName":"main::","kind":12,"line":654},{"kind":13,"line":654,"containerName":null,"name":"$id"},{"line":657,"kind":13,"containerName":null,"name":"$feat"},{"name":"add_Annotation","containerName":"main::","kind":12,"line":657},{"name":"$a","containerName":null,"line":657,"kind":13},{"kind":13,"line":662,"name":"%attr","containerName":null},{"name":"Gap","kind":12,"line":662},{"kind":13,"line":663,"containerName":null,"name":"$value","definition":"my","localvar":"my"},{"containerName":null,"name":"%attr","line":663,"kind":13},{"name":"Gap","kind":12,"line":663},{"kind":13,"line":664,"containerName":null,"name":"$a","definition":"my","localvar":"my"},{"name":"Bio","containerName":"Annotation::SimpleValue","kind":12,"line":664},{"name":"new","containerName":"main::","kind":12,"line":664},{"line":665,"kind":13,"name":"$a","containerName":null},{"containerName":"main::","name":"value","kind":12,"line":665},{"line":665,"kind":13,"containerName":null,"name":"$value"},{"line":666,"kind":13,"containerName":null,"name":"$feat"},{"containerName":"main::","name":"add_Annotation","kind":12,"line":666},{"containerName":null,"name":"$a","line":666,"kind":13},{"line":671,"kind":13,"containerName":null,"name":"%attr"},{"name":"Target","kind":12,"line":671},{"localvar":"my","definition":"my","name":"$target_collection","containerName":null,"line":672,"kind":13},{"line":672,"kind":12,"name":"Bio","containerName":"Annotation::Collection"},{"line":672,"kind":12,"containerName":"main::","name":"new"},{"localvar":"my","containerName":null,"name":"$target_string","definition":"my","line":674,"kind":13},{"containerName":null,"name":"%attr","kind":13,"line":674},{"kind":12,"line":674,"name":"Target"},{"name":"$target_string","containerName":null,"line":681,"kind":13},{"name":"$target_string","containerName":null,"line":681,"kind":13},{"line":683,"kind":13,"localvar":"my","containerName":null,"name":"$t_id","definition":"my"},{"kind":13,"line":683,"containerName":null,"name":"$tstart"},{"name":"$tend","containerName":null,"line":683,"kind":13},{"line":683,"kind":13,"containerName":null,"name":"$strand"},{"line":683,"kind":13,"name":"$extra","containerName":null},{"name":"$target_string","containerName":null,"kind":13,"line":683},{"kind":13,"line":684,"containerName":null,"name":"$tend"},{"name":"%extra","containerName":null,"kind":13,"line":684},{"name":"$self","containerName":null,"kind":13,"line":685},{"name":"throw","containerName":"main::","line":685,"kind":12},{"localvar":"my","containerName":null,"definition":"my","name":"$a","line":688,"kind":13},{"containerName":"Annotation::Target","name":"Bio","line":688,"kind":12},{"line":688,"kind":12,"containerName":"main::","name":"new"},{"line":689,"kind":13,"containerName":null,"name":"$t_id"},{"line":690,"kind":13,"containerName":null,"name":"$tstart"},{"line":691,"kind":13,"containerName":null,"name":"$tend"},{"line":694,"kind":13,"containerName":null,"name":"$strand"},{"kind":13,"line":694,"name":"%strand","containerName":null},{"kind":13,"line":695,"name":"$strand","containerName":null},{"containerName":null,"name":"$strand","kind":13,"line":696},{"name":"%strand","containerName":null,"line":696,"kind":13},{"kind":13,"line":697,"name":"%strand","containerName":null},{"kind":13,"line":699,"name":"$strand","containerName":null},{"kind":13,"line":702,"name":"$a","containerName":null},{"name":"strand","containerName":"main::","kind":12,"line":702},{"kind":13,"line":702,"name":"$strand","containerName":null},{"line":702,"kind":13,"containerName":null,"name":"$strand"},{"name":"$feat","containerName":null,"line":703,"kind":13},{"containerName":"main::","name":"add_Annotation","kind":12,"line":703},{"kind":13,"line":703,"name":"$a","containerName":null},{"name":"%attr","containerName":null,"line":709,"kind":13},{"name":"ID","kind":12,"line":709},{"name":"%attr","containerName":null,"kind":13,"line":710},{"name":"ID","kind":12,"line":710},{"name":"$self","containerName":null,"line":711,"kind":13},{"name":"throw","containerName":"main::","line":711,"kind":12},{"containerName":null,"name":"%self","line":715,"kind":13},{"containerName":null,"name":"%attr","line":715,"kind":13},{"name":"ID","line":715,"kind":12},{"name":"$self","containerName":null,"kind":13,"line":715},{"line":715,"kind":12,"containerName":"main::","name":"validate"},{"containerName":null,"name":"$self","kind":13,"line":716},{"line":716,"kind":12,"containerName":"main::","name":"throw"},{"name":"%self","containerName":null,"line":718,"kind":13},{"containerName":null,"name":"%attr","line":718,"kind":13},{"name":"ID","line":718,"kind":12},{"kind":13,"line":721,"containerName":null,"definition":"my","name":"$a","localvar":"my"},{"line":721,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"line":721,"kind":12,"containerName":"main::","name":"new"},{"kind":13,"line":722,"containerName":null,"name":"$a"},{"name":"value","containerName":"main::","kind":12,"line":722},{"line":722,"kind":13,"name":"%attr","containerName":null},{"name":"ID","kind":12,"line":722},{"name":"$feat","containerName":null,"kind":13,"line":723},{"kind":12,"line":723,"containerName":"main::","name":"add_Annotation"},{"line":723,"kind":13,"containerName":null,"name":"$a"},{"containerName":null,"name":"%attr","line":727,"kind":13},{"kind":12,"line":727,"name":"Name"},{"containerName":null,"name":"%attr","kind":13,"line":728},{"line":728,"kind":12,"name":"Name"},{"name":"$self","containerName":null,"line":729,"kind":13},{"line":729,"kind":12,"containerName":"main::","name":"throw"},{"kind":13,"line":732,"containerName":null,"name":"$a","definition":"my","localvar":"my"},{"name":"Bio","containerName":"Annotation::SimpleValue","line":732,"kind":12},{"kind":12,"line":732,"containerName":"main::","name":"new"},{"kind":13,"line":733,"name":"$a","containerName":null},{"line":733,"kind":12,"containerName":"main::","name":"value"},{"kind":13,"line":733,"name":"%attr","containerName":null},{"kind":12,"line":733,"name":"Name"},{"containerName":null,"name":"$feat","line":734,"kind":13},{"containerName":"main::","name":"add_Annotation","line":734,"kind":12},{"name":"$a","containerName":null,"kind":13,"line":734},{"kind":13,"line":737,"containerName":null,"name":"%other_canonical","definition":"my","localvar":"my"},{"name":"%attr","containerName":null,"kind":13,"line":738},{"kind":13,"line":738,"name":"%other_canonical","containerName":null},{"kind":13,"line":739,"containerName":null,"definition":"my","name":"$value","localvar":"my"},{"containerName":null,"name":"%attr","line":739,"kind":13},{"containerName":null,"name":"%other_canonical","kind":13,"line":739},{"kind":13,"line":740,"definition":"my","name":"$a","containerName":null,"localvar":"my"},{"kind":12,"line":740,"name":"Bio","containerName":"Annotation::SimpleValue"},{"kind":12,"line":740,"name":"new","containerName":"main::"},{"line":741,"kind":13,"name":"$a","containerName":null},{"containerName":"main::","name":"value","kind":12,"line":741},{"name":"$value","containerName":null,"line":741,"kind":13},{"containerName":null,"name":"$feat","kind":13,"line":742},{"name":"add_Annotation","containerName":"main::","kind":12,"line":742},{"line":742,"kind":13,"containerName":null,"name":"$other_canonical"},{"kind":13,"line":742,"containerName":null,"name":"$a"},{"kind":13,"line":747,"name":"@non_reserved_tags","definition":"my","containerName":null,"localvar":"my"},{"kind":13,"line":747,"containerName":null,"name":"%attr"},{"kind":13,"line":748,"containerName":null,"definition":"my","name":"$non_reserved_tag","localvar":"my"},{"containerName":null,"name":"@non_reserved_tags","kind":13,"line":748},{"name":"$non_reserved_tag","containerName":null,"line":749,"kind":13},{"name":"$value","definition":"my","containerName":null,"localvar":"my","kind":13,"line":750},{"containerName":null,"name":"%attr","kind":13,"line":750},{"name":"%non_reserved_tag","containerName":null,"line":750,"kind":13},{"line":751,"kind":13,"containerName":null,"name":"$feat"},{"kind":13,"line":751,"containerName":null,"name":"$self"},{"line":751,"kind":12,"containerName":"main::","name":"_handle_non_reserved_tag"},{"name":"$feat","containerName":null,"line":751,"kind":13},{"line":751,"kind":13,"name":"$non_reserved_tag","containerName":null},{"containerName":null,"name":"$value","kind":13,"line":751},{"containerName":null,"name":"@illegal_tags","definition":"my","localvar":"my","kind":13,"line":755},{"containerName":null,"name":"%attr","line":757,"kind":13},{"line":759,"kind":13,"containerName":null,"name":"@illegal_tags"},{"line":760,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"$tags"},{"kind":13,"line":760,"name":"@illegal_tags","containerName":null},{"name":"$self","containerName":null,"kind":13,"line":761},{"name":"throw","containerName":"main::","line":761,"kind":12},{"line":764,"kind":13,"containerName":null,"name":"$feat"},{"kind":12,"children":[{"kind":13,"line":780,"definition":"my","name":"$self","containerName":"_handle_non_reserved_tag","localvar":"my"},{"kind":13,"line":781,"name":"$feat","definition":"my","containerName":"_handle_non_reserved_tag","localvar":"my"},{"containerName":"_handle_non_reserved_tag","name":"$tag","line":781,"kind":13},{"containerName":"_handle_non_reserved_tag","name":"$value","kind":13,"line":781},{"line":788,"kind":13,"localvar":"my","name":"$a","definition":"my","containerName":"_handle_non_reserved_tag"},{"line":789,"kind":13,"containerName":"_handle_non_reserved_tag","name":"$tag"},{"name":"$a","containerName":"_handle_non_reserved_tag","kind":13,"line":790},{"line":790,"kind":12,"containerName":"_handle_non_reserved_tag","name":"new"},{"containerName":"_handle_non_reserved_tag","name":"$a","line":793,"kind":13},{"kind":12,"line":793,"name":"new","containerName":"_handle_non_reserved_tag"},{"line":795,"kind":13,"name":"$a","containerName":"_handle_non_reserved_tag"},{"kind":12,"line":795,"containerName":"_handle_non_reserved_tag","name":"value"},{"containerName":"_handle_non_reserved_tag","name":"$value","line":795,"kind":13},{"name":"$feat","containerName":"_handle_non_reserved_tag","kind":13,"line":796},{"kind":12,"line":796,"name":"add_Annotation","containerName":"_handle_non_reserved_tag"},{"kind":13,"line":796,"containerName":"_handle_non_reserved_tag","name":"$tag"},{"containerName":"_handle_non_reserved_tag","name":"$a","kind":13,"line":796},{"name":"$feat","containerName":"_handle_non_reserved_tag","line":798,"kind":13}],"line":779,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$feat"},{"label":"$tag"},{"label":"$value"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.","label":"_handle_non_reserved_tag($feat,$tag,$value)"},"detail":"($feat,$tag,$value)","name":"_handle_non_reserved_tag","range":{"start":{"line":779,"character":0},"end":{"character":9999,"line":799}}},{"line":790,"kind":12,"containerName":"Annotation::Comment","name":"Bio"},{"containerName":"Annotation::SimpleValue","name":"Bio","kind":12,"line":793},{"name":"organism","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":812},"start":{"line":807,"character":0}},"kind":12,"children":[{"line":808,"kind":13,"localvar":"my","containerName":"organism","definition":"my","name":"$self"},{"containerName":"organism","definition":"my","name":"$organism","localvar":"my","kind":13,"line":809},{"name":"$self","containerName":"organism","line":810,"kind":13},{"containerName":"organism","name":"$organism","line":810,"kind":13},{"line":810,"kind":13,"name":"$organism","containerName":"organism"},{"name":"$self","containerName":"organism","kind":13,"line":811}],"line":807},{"name":"_write_feature_1","range":{"start":{"line":821,"character":0},"end":{"line":824,"character":9999}},"kind":12,"line":821,"children":[{"line":822,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_write_feature_1"},{"containerName":"_write_feature_1","name":"$feature","kind":13,"line":822},{"containerName":"_write_feature_1","name":"$self","line":823,"kind":13},{"line":823,"kind":12,"containerName":"_write_feature_1","name":"throw"},{"line":823,"kind":13,"containerName":"_write_feature_1","name":"$self"},{"kind":12,"line":823,"name":"version","containerName":"_write_feature_1"}],"containerName":"main::","definition":"sub","detail":"($self,$feature)","signature":{"parameters":[{"label":"$self"},{"label":"$feature"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.\n\n\nsub _handle_non_reserved_tag {\n  my $self = shift;\n  my ($feat,$tag,$value) = @_;\n\n  # to customize through subclassing and overriding:\n  #if ($tag eq 'someTagOfInterest') {\n  #  do something different\n  # else { do what is below\n\n  my $a;\n  if ($tag eq 'comment') {\n    $a = Bio::Annotation::Comment->new();\n  }\n  else {\n    $a = Bio::Annotation::SimpleValue->new();\n  }\n  $a->value($value); \n  $feat->add_Annotation($tag,$a);\n  \n  return $feat;\n}\n\n=head1 organims\n\nGets/sets the organims from the organism directive\n\n\nsub organism {\n    my $self = shift;\n    my $organism = shift if defined(@_);\n    return $self->{'organism'} = $organism if defined($organism);\n    return $self->{'organism'};\n}\n\n\n=head1 _write_feature_1()\n\nwrite a feature in GFF v1 format.  currently not implemented.","label":"_write_feature_1($self,$feature)"}},{"name":"_write_feature_2","range":{"end":{"line":835,"character":9999},"start":{"line":832,"character":0}},"kind":12,"children":[{"containerName":"_write_feature_2","definition":"my","name":"$self","localvar":"my","kind":13,"line":833},{"kind":13,"line":833,"containerName":"_write_feature_2","name":"$feature"},{"line":834,"kind":13,"name":"$self","containerName":"_write_feature_2"},{"containerName":"_write_feature_2","name":"throw","line":834,"kind":12},{"line":834,"kind":13,"containerName":"_write_feature_2","name":"$self"},{"kind":12,"line":834,"name":"version","containerName":"_write_feature_2"}],"line":832,"definition":"sub","containerName":"main::","signature":{"label":"_write_feature_2($self,$feature)","documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.\n\n\nsub _handle_non_reserved_tag {\n  my $self = shift;\n  my ($feat,$tag,$value) = @_;\n\n  # to customize through subclassing and overriding:\n  #if ($tag eq 'someTagOfInterest') {\n  #  do something different\n  # else { do what is below\n\n  my $a;\n  if ($tag eq 'comment') {\n    $a = Bio::Annotation::Comment->new();\n  }\n  else {\n    $a = Bio::Annotation::SimpleValue->new();\n  }\n  $a->value($value); \n  $feat->add_Annotation($tag,$a);\n  \n  return $feat;\n}\n\n=head1 organims\n\nGets/sets the organims from the organism directive\n\n\nsub organism {\n    my $self = shift;\n    my $organism = shift if defined(@_);\n    return $self->{'organism'} = $organism if defined($organism);\n    return $self->{'organism'};\n}\n\n\n=head1 _write_feature_1()\n\nwrite a feature in GFF v1 format.  currently not implemented.\n\n\nsub _write_feature_1 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_2()\n\nwrite a feature in GFF v2 format.  currently not implemented.","parameters":[{"label":"$self"},{"label":"$feature"}]},"detail":"($self,$feature)"},{"signature":{"parameters":[{"label":"$self"},{"label":"$feature"},{"label":"$group"}],"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.\n\n\nsub _handle_non_reserved_tag {\n  my $self = shift;\n  my ($feat,$tag,$value) = @_;\n\n  # to customize through subclassing and overriding:\n  #if ($tag eq 'someTagOfInterest') {\n  #  do something different\n  # else { do what is below\n\n  my $a;\n  if ($tag eq 'comment') {\n    $a = Bio::Annotation::Comment->new();\n  }\n  else {\n    $a = Bio::Annotation::SimpleValue->new();\n  }\n  $a->value($value); \n  $feat->add_Annotation($tag,$a);\n  \n  return $feat;\n}\n\n=head1 organims\n\nGets/sets the organims from the organism directive\n\n\nsub organism {\n    my $self = shift;\n    my $organism = shift if defined(@_);\n    return $self->{'organism'} = $organism if defined($organism);\n    return $self->{'organism'};\n}\n\n\n=head1 _write_feature_1()\n\nwrite a feature in GFF v1 format.  currently not implemented.\n\n\nsub _write_feature_1 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_2()\n\nwrite a feature in GFF v2 format.  currently not implemented.\n\n\nsub _write_feature_2 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_25()\n\nwrite a feature in GFF v2.5 (aka GTF) format.","label":"_write_feature_25($self,$feature,$group)"},"detail":"($self,$feature,$group)","definition":"sub","containerName":"main::","children":[{"containerName":"_write_feature_25","definition":"my","name":"$self","localvar":"my","kind":13,"line":844},{"containerName":"_write_feature_25","name":"$feature","kind":13,"line":844},{"line":844,"kind":13,"containerName":"_write_feature_25","name":"$group"},{"line":847,"kind":13,"localvar":"my","containerName":"_write_feature_25","name":"$transcript_id","definition":"my"},{"name":"$gene_id","containerName":"_write_feature_25","line":847,"kind":13},{"line":847,"kind":13,"containerName":"_write_feature_25","name":"$feature"},{"kind":12,"line":847,"containerName":"_write_feature_25","name":"get_Annotations"},{"name":"$feature","containerName":"_write_feature_25","line":847,"kind":13},{"containerName":"_write_feature_25","name":"get_Annotations","line":847,"kind":12},{"line":848,"kind":13,"containerName":"_write_feature_25","name":"$group"},{"line":849,"kind":13,"name":"$group","containerName":"_write_feature_25"},{"line":849,"kind":13,"name":"$feature","containerName":"_write_feature_25"},{"kind":12,"line":849,"containerName":"_write_feature_25","name":"get_Annotations"},{"containerName":"_write_feature_25","name":"$transcript_id","line":850,"kind":13},{"line":850,"kind":13,"containerName":"_write_feature_25","name":"$group"},{"containerName":"_write_feature_25","name":"$gene_id","line":851,"kind":13},{"name":"$group","containerName":"_write_feature_25","kind":13,"line":851},{"containerName":"_write_feature_25","name":"$seq","definition":"my","localvar":"my","kind":13,"line":855},{"containerName":"_write_feature_25","name":"$feature","kind":13,"line":855},{"containerName":"_write_feature_25","name":"seq_id","kind":12,"line":855},{"containerName":"_write_feature_25","name":"$feature","line":855,"kind":13},{"containerName":"_write_feature_25","name":"seq_id","line":855,"kind":12},{"line":855,"kind":12,"containerName":"_write_feature_25","name":"value"},{"kind":13,"line":855,"containerName":"_write_feature_25","name":"$feature"},{"containerName":"_write_feature_25","name":"seq_id","kind":12,"line":855},{"line":856,"kind":13,"localvar":"my","containerName":"_write_feature_25","name":"$source","definition":"my"},{"kind":13,"line":856,"name":"$feature","containerName":"_write_feature_25"},{"kind":12,"line":856,"containerName":"_write_feature_25","name":"source"},{"name":"value","containerName":"_write_feature_25","kind":12,"line":856},{"name":"$type","definition":"my","containerName":"_write_feature_25","localvar":"my","kind":13,"line":857},{"kind":13,"line":857,"containerName":"_write_feature_25","name":"$feature"},{"kind":12,"line":857,"name":"type","containerName":"_write_feature_25"},{"kind":12,"line":857,"name":"name","containerName":"_write_feature_25"},{"kind":13,"line":858,"name":"$type","containerName":"_write_feature_25"},{"containerName":"_write_feature_25","name":"$type","kind":13,"line":858},{"kind":13,"line":859,"definition":"my","name":"$min","containerName":"_write_feature_25","localvar":"my"},{"containerName":"_write_feature_25","name":"$feature","line":859,"kind":13},{"kind":12,"line":859,"name":"start","containerName":"_write_feature_25"},{"line":860,"kind":13,"localvar":"my","name":"$max","definition":"my","containerName":"_write_feature_25"},{"kind":13,"line":860,"containerName":"_write_feature_25","name":"$feature"},{"kind":12,"line":860,"name":"end","containerName":"_write_feature_25"},{"kind":13,"line":861,"containerName":"_write_feature_25","definition":"my","name":"$strand","localvar":"my"},{"name":"$feature","containerName":"_write_feature_25","line":861,"kind":13},{"name":"strand","containerName":"_write_feature_25","line":861,"kind":12},{"line":861,"kind":13,"name":"$feature","containerName":"_write_feature_25"},{"line":861,"kind":12,"containerName":"_write_feature_25","name":"strand"},{"line":862,"kind":13,"localvar":"my","containerName":"_write_feature_25","definition":"my","name":"$score"},{"containerName":"_write_feature_25","name":"$feature","line":862,"kind":13},{"name":"score","containerName":"_write_feature_25","kind":12,"line":862},{"name":"$feature","containerName":"_write_feature_25","kind":13,"line":862},{"containerName":"_write_feature_25","name":"score","kind":12,"line":862},{"line":862,"kind":13,"name":"$feature","containerName":"_write_feature_25"},{"line":862,"kind":12,"name":"score","containerName":"_write_feature_25"},{"line":862,"kind":12,"name":"value","containerName":"_write_feature_25"},{"name":"$feature","containerName":"_write_feature_25","kind":13,"line":862},{"containerName":"_write_feature_25","name":"score","line":862,"kind":12},{"kind":13,"line":863,"containerName":"_write_feature_25","definition":"my","name":"$frame","localvar":"my"},{"kind":13,"line":863,"containerName":"_write_feature_25","name":"$feature"},{"name":"frame","containerName":"_write_feature_25","line":863,"kind":12},{"kind":13,"line":863,"name":"$feature","containerName":"_write_feature_25"},{"line":863,"kind":12,"containerName":"_write_feature_25","name":"frame"},{"line":863,"kind":13,"name":"$feature","containerName":"_write_feature_25"},{"name":"frame","containerName":"_write_feature_25","line":863,"kind":12},{"containerName":"_write_feature_25","name":"value","line":863,"kind":12},{"kind":13,"line":863,"containerName":"_write_feature_25","name":"$feature"},{"containerName":"_write_feature_25","name":"frame","kind":12,"line":863},{"containerName":"_write_feature_25","name":"$feature","kind":13,"line":863},{"name":"phase","containerName":"_write_feature_25","line":863,"kind":12},{"kind":13,"line":863,"name":"$feature","containerName":"_write_feature_25"},{"containerName":"_write_feature_25","name":"phase","kind":12,"line":863},{"name":"value","containerName":"_write_feature_25","line":863,"kind":12},{"kind":13,"line":863,"containerName":"_write_feature_25","name":"$feature"},{"kind":12,"line":863,"containerName":"_write_feature_25","name":"phase"},{"containerName":"_write_feature_25","name":"$type","kind":13,"line":866},{"kind":13,"line":866,"containerName":"_write_feature_25","name":"$type"},{"name":"$type","containerName":"_write_feature_25","kind":13,"line":866},{"kind":13,"line":866,"containerName":"_write_feature_25","name":"$type"},{"kind":13,"line":867,"containerName":"_write_feature_25","definition":"my","name":"$attr","localvar":"my"},{"kind":13,"line":867,"containerName":"_write_feature_25","name":"$gene_id"},{"containerName":"_write_feature_25","name":"$gene_id","line":867,"kind":13},{"line":867,"kind":12,"containerName":"_write_feature_25","name":"value"},{"containerName":"_write_feature_25","name":"$transcript_id","kind":13,"line":867},{"kind":13,"line":867,"name":"$transcript_id","containerName":"_write_feature_25"},{"kind":12,"line":867,"containerName":"_write_feature_25","name":"value"},{"line":868,"kind":13,"localvar":"my","containerName":"_write_feature_25","definition":"my","name":"$outstring"},{"kind":13,"line":869,"containerName":"_write_feature_25","name":"$seq"},{"line":869,"kind":13,"name":"$source","containerName":"_write_feature_25"},{"containerName":"_write_feature_25","name":"$type","line":869,"kind":13},{"line":869,"kind":13,"containerName":"_write_feature_25","name":"$min"},{"kind":13,"line":869,"containerName":"_write_feature_25","name":"$max"},{"name":"$score","containerName":"_write_feature_25","kind":13,"line":869},{"name":"$strand","containerName":"_write_feature_25","line":869,"kind":13},{"line":869,"kind":13,"name":"$frame","containerName":"_write_feature_25"},{"containerName":"_write_feature_25","name":"$frame","kind":13,"line":869},{"containerName":"_write_feature_25","name":"$attr","kind":13,"line":869},{"containerName":"_write_feature_25","name":"$self","line":871,"kind":13},{"name":"_print","containerName":"_write_feature_25","line":871,"kind":12},{"kind":13,"line":871,"containerName":"_write_feature_25","name":"$outstring"},{"definition":"my","name":"$subfeat","containerName":"_write_feature_25","localvar":"my","kind":13,"line":874},{"line":874,"kind":13,"name":"$feature","containerName":"_write_feature_25"},{"kind":12,"line":874,"name":"get_SeqFeatures","containerName":"_write_feature_25"},{"kind":13,"line":875,"containerName":"_write_feature_25","name":"$self"},{"containerName":"_write_feature_25","name":"_write_feature_25","kind":12,"line":875},{"line":875,"kind":13,"containerName":"_write_feature_25","name":"$subfeat"},{"containerName":"_write_feature_25","name":"$group","line":875,"kind":13}],"line":843,"kind":12,"range":{"end":{"character":9999,"line":877},"start":{"line":843,"character":0}},"name":"_write_feature_25"},{"range":{"start":{"line":885,"character":0},"end":{"line":948,"character":9999}},"name":"_write_feature_3","line":885,"children":[{"kind":13,"line":886,"containerName":"_write_feature_3","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":886,"name":"$feature","containerName":"_write_feature_3"},{"definition":"my","name":"$seq","containerName":"_write_feature_3","localvar":"my","kind":13,"line":887},{"kind":13,"line":887,"containerName":"_write_feature_3","name":"$feature"},{"name":"seq_id","containerName":"_write_feature_3","line":887,"kind":12},{"kind":13,"line":887,"containerName":"_write_feature_3","name":"$feature"},{"containerName":"_write_feature_3","name":"seq_id","kind":12,"line":887},{"line":887,"kind":12,"name":"value","containerName":"_write_feature_3"},{"line":887,"kind":13,"name":"$feature","containerName":"_write_feature_3"},{"line":887,"kind":12,"name":"seq_id","containerName":"_write_feature_3"},{"line":888,"kind":13,"localvar":"my","containerName":"_write_feature_3","name":"$source","definition":"my"},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":889},{"line":889,"kind":12,"containerName":"_write_feature_3","name":"source"},{"line":890,"kind":13,"name":"$source","containerName":"_write_feature_3"},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":890},{"name":"source","containerName":"_write_feature_3","kind":12,"line":890},{"kind":12,"line":890,"name":"value","containerName":"_write_feature_3"},{"kind":13,"line":893,"name":"$source","containerName":"_write_feature_3"},{"containerName":"_write_feature_3","name":"$feature","line":893,"kind":13},{"containerName":"_write_feature_3","name":"source","kind":12,"line":893},{"localvar":"my","name":"$type","definition":"my","containerName":"_write_feature_3","line":895,"kind":13},{"kind":13,"line":896,"containerName":"_write_feature_3","name":"$feature"},{"containerName":"_write_feature_3","name":"type","line":896,"kind":12},{"name":"$type","containerName":"_write_feature_3","kind":13,"line":896},{"kind":13,"line":896,"containerName":"_write_feature_3","name":"$feature"},{"line":896,"kind":12,"name":"type","containerName":"_write_feature_3"},{"name":"name","containerName":"_write_feature_3","kind":12,"line":896},{"name":"$type","containerName":"_write_feature_3","kind":13,"line":897},{"kind":13,"line":898,"containerName":"_write_feature_3","definition":"my","name":"$min","localvar":"my"},{"name":"$feature","containerName":"_write_feature_3","line":898,"kind":13},{"line":898,"kind":12,"name":"start","containerName":"_write_feature_3"},{"line":899,"kind":13,"localvar":"my","containerName":"_write_feature_3","name":"$max","definition":"my"},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":899},{"containerName":"_write_feature_3","name":"end","line":899,"kind":12},{"containerName":"_write_feature_3","name":"$strand","definition":"my","localvar":"my","kind":13,"line":900},{"kind":13,"line":900,"name":"$feature","containerName":"_write_feature_3"},{"name":"strand","containerName":"_write_feature_3","line":900,"kind":12},{"containerName":"_write_feature_3","name":"$feature","line":900,"kind":13},{"kind":12,"line":900,"containerName":"_write_feature_3","name":"strand"},{"containerName":"_write_feature_3","name":"$score","definition":"my","localvar":"my","kind":13,"line":901},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":901},{"containerName":"_write_feature_3","name":"score","kind":12,"line":901},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":901},{"kind":12,"line":901,"name":"score","containerName":"_write_feature_3"},{"line":901,"kind":13,"containerName":"_write_feature_3","name":"$feature"},{"line":901,"kind":12,"containerName":"_write_feature_3","name":"score"},{"line":901,"kind":12,"name":"value","containerName":"_write_feature_3"},{"name":"$feature","containerName":"_write_feature_3","line":901,"kind":13},{"containerName":"_write_feature_3","name":"score","line":901,"kind":12},{"line":902,"kind":13,"localvar":"my","containerName":"_write_feature_3","name":"$phase","definition":"my"},{"line":902,"kind":13,"name":"$feature","containerName":"_write_feature_3"},{"line":902,"kind":12,"name":"phase","containerName":"_write_feature_3"},{"name":"value","containerName":"_write_feature_3","line":902,"kind":12},{"localvar":"my","definition":"my","name":"@attr","containerName":"_write_feature_3","line":904,"kind":13},{"kind":13,"line":905,"definition":"my","name":"@v","containerName":"_write_feature_3","localvar":"my"},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":905},{"containerName":"_write_feature_3","name":"get_Annotations","kind":12,"line":905},{"kind":13,"line":906,"containerName":"_write_feature_3","definition":"my","name":"$vstring","localvar":"my"},{"containerName":"_write_feature_3","name":"value","kind":12,"line":906},{"containerName":"_write_feature_3","name":"@v","kind":13,"line":906},{"kind":13,"line":907,"name":"@attr","containerName":"_write_feature_3"},{"line":909,"kind":13,"localvar":"my","containerName":"_write_feature_3","name":"@v","definition":"my"},{"containerName":"_write_feature_3","name":"$feature","line":909,"kind":13},{"kind":12,"line":909,"name":"get_Annotations","containerName":"_write_feature_3"},{"name":"$vstring","definition":"my","containerName":"_write_feature_3","localvar":"my","kind":13,"line":910},{"line":910,"kind":12,"name":"value","containerName":"_write_feature_3"},{"name":"@v","containerName":"_write_feature_3","kind":13,"line":910},{"name":"@attr","containerName":"_write_feature_3","line":911,"kind":13},{"line":912,"kind":13,"name":"$self","containerName":"_write_feature_3"},{"containerName":"_write_feature_3","name":"throw","line":912,"kind":12},{"line":912,"kind":13,"name":"$vstring","containerName":"_write_feature_3"},{"containerName":"_write_feature_3","name":"@v","kind":13,"line":912},{"line":914,"kind":13,"localvar":"my","name":"@v","definition":"my","containerName":"_write_feature_3"},{"name":"$feature","containerName":"_write_feature_3","line":914,"kind":13},{"kind":12,"line":914,"name":"get_Annotations","containerName":"_write_feature_3"},{"line":915,"kind":13,"localvar":"my","containerName":"_write_feature_3","definition":"my","name":"$vstring"},{"name":"value","containerName":"_write_feature_3","kind":12,"line":915},{"line":915,"kind":13,"name":"@v","containerName":"_write_feature_3"},{"containerName":"_write_feature_3","name":"@attr","kind":13,"line":916},{"name":"@v","definition":"my","containerName":"_write_feature_3","localvar":"my","kind":13,"line":918},{"kind":13,"line":918,"containerName":"_write_feature_3","name":"$feature"},{"line":918,"kind":12,"name":"get_Annotations","containerName":"_write_feature_3"},{"name":"$vstring","definition":"my","containerName":"_write_feature_3","localvar":"my","kind":13,"line":919},{"name":"database","containerName":"_write_feature_3","kind":12,"line":919},{"line":919,"kind":12,"name":"primary_id","containerName":"_write_feature_3"},{"kind":13,"line":919,"containerName":"_write_feature_3","name":"@v"},{"kind":13,"line":920,"name":"@attr","containerName":"_write_feature_3"},{"localvar":"my","containerName":"_write_feature_3","definition":"my","name":"@v","line":922,"kind":13},{"name":"$feature","containerName":"_write_feature_3","line":922,"kind":13},{"name":"get_Annotations","containerName":"_write_feature_3","line":922,"kind":12},{"kind":13,"line":923,"containerName":"_write_feature_3","definition":"my","name":"$vstring","localvar":"my"},{"name":"identifier","containerName":"_write_feature_3","line":923,"kind":12},{"containerName":"_write_feature_3","name":"@v","kind":13,"line":923},{"line":924,"kind":13,"containerName":"_write_feature_3","name":"@attr"},{"kind":13,"line":926,"name":"@v","definition":"my","containerName":"_write_feature_3","localvar":"my"},{"containerName":"_write_feature_3","name":"$feature","kind":13,"line":926},{"containerName":"_write_feature_3","name":"get_Annotations","kind":12,"line":926},{"line":927,"kind":13,"localvar":"my","definition":"my","name":"$vstring","containerName":"_write_feature_3"},{"kind":12,"line":927,"containerName":"_write_feature_3","name":"text"},{"containerName":"_write_feature_3","name":"@v","line":927,"kind":13},{"kind":13,"line":928,"containerName":"_write_feature_3","name":"@attr"},{"localvar":"my","definition":"my","name":"@v","containerName":"_write_feature_3","line":930,"kind":13},{"containerName":"_write_feature_3","name":"$feature","line":930,"kind":13},{"name":"get_Annotations","containerName":"_write_feature_3","line":930,"kind":12},{"name":"%strand_map","definition":"my","containerName":"_write_feature_3","localvar":"my","kind":13,"line":931},{"localvar":"my","containerName":"_write_feature_3","name":"$vstring","definition":"my","line":932,"kind":13},{"name":"target_id","containerName":"_write_feature_3","kind":12,"line":933},{"name":"start","containerName":"_write_feature_3","kind":12,"line":933},{"line":933,"kind":12,"containerName":"_write_feature_3","name":"end"},{"name":"strand","containerName":"_write_feature_3","line":933,"kind":12},{"line":933,"kind":13,"name":"$strand_map","containerName":"_write_feature_3"},{"kind":12,"line":933,"containerName":"_write_feature_3","name":"strand"},{"containerName":"_write_feature_3","name":"@v","line":934,"kind":13},{"name":"@attr","containerName":"_write_feature_3","line":935,"kind":13},{"line":938,"kind":13,"localvar":"my","containerName":"_write_feature_3","definition":"my","name":"$attr"},{"line":938,"kind":13,"name":"@attr","containerName":"_write_feature_3"},{"line":940,"kind":13,"localvar":"my","containerName":"_write_feature_3","definition":"my","name":"$outstring"},{"kind":13,"line":941,"name":"$seq","containerName":"_write_feature_3"},{"line":941,"kind":13,"name":"$source","containerName":"_write_feature_3"},{"line":941,"kind":13,"containerName":"_write_feature_3","name":"$type"},{"containerName":"_write_feature_3","name":"$min","line":941,"kind":13},{"containerName":"_write_feature_3","name":"$max","kind":13,"line":941},{"kind":13,"line":941,"name":"$score","containerName":"_write_feature_3"},{"kind":13,"line":941,"name":"$strand","containerName":"_write_feature_3"},{"containerName":"_write_feature_3","name":"$phase","line":941,"kind":13},{"name":"$attr","containerName":"_write_feature_3","kind":13,"line":941},{"name":"$self","containerName":"_write_feature_3","kind":13,"line":943},{"line":943,"kind":12,"name":"_print","containerName":"_write_feature_3"},{"line":943,"kind":13,"containerName":"_write_feature_3","name":"$outstring"},{"containerName":"_write_feature_3","name":"$subfeat","definition":"my","localvar":"my","kind":13,"line":945},{"name":"$feature","containerName":"_write_feature_3","kind":13,"line":945},{"kind":12,"line":945,"name":"get_SeqFeatures","containerName":"_write_feature_3"},{"name":"$self","containerName":"_write_feature_3","kind":13,"line":946},{"kind":12,"line":946,"containerName":"_write_feature_3","name":"_write_feature_3"},{"name":"$subfeat","containerName":"_write_feature_3","line":946,"kind":13}],"kind":12,"detail":"($self,$feature)","signature":{"documentation":"=head1 NAME\n\nBio::FeatureIO::gff - read/write GFF feature files\n\n=head1 SYNOPSIS\n\n  my $feature; #get a Bio::SeqFeature::Annotated somehow\n  my $featureOut = Bio::FeatureIO->new(\n    -format => 'gff',\n    -version => 3,\n    -fh => \\*STDOUT,\n    -validate_terms => 1, #boolean. validate ontology terms online?  default 0 (false).\n  );\n  $featureOut->write_feature($feature);\n\n=head1 DESCRIPTION\n\n Currently implemented:\n\n version         read?   write?\n ------------------------------\n GFF 1             N       N\n GFF 2             N       N\n GFF 2.5 (GTF)     N       Y\n GFF 3             Y       Y\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                 - General discussion\n  http://bioperl.org/wiki/Mailing_list  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR\n\n Allen Day, <allenday@ucla.edu>\n\n=head1 CONTRIBUTORS\n\n Steffen Grossmann, <grossman@molgen.mpg.de>\n Scott Cain, <cain@cshl.edu>\n Rob Edwards <rob@salmonella.org>\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::FeatureIO::gff;\nuse strict;\n\n#these are alphabetical, keep them that way.\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::OntologyTerm;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Annotation::Target;\nuse Bio::FeatureIO;\nuse Bio::Ontology::OntologyStore;\nuse Bio::OntologyIO;\nuse Bio::SeqFeature::Annotated;\nuse Bio::SeqIO;\nuse URI::Escape;\n\nuse base qw(Bio::FeatureIO);\n\nuse constant DEFAULT_VERSION => 3;\nmy $RESERVED_TAGS   = \"ID|Name|Alias|Parent|Target|Gap|Derives_from|Note|Dbxref|dbxref|Ontology_term|Index|CRUD\";\n\nsub _initialize {\n  my($self,%arg) = @_;\n\n  $self->SUPER::_initialize(%arg);\n\n  $self->version( $arg{-version}        || DEFAULT_VERSION);\n  $self->validate($arg{-validate_terms} || 0);\n\n  if ($arg{-file} =~ /^>.*/ ) {\n    $self->_print(\"##gff-version \" . $self->version() . \"\\n\");\n  }\n  else {\n    my $directive;\n    while(($directive = $self->_readline()) && ($directive =~ /^##/) ){\n      $self->_handle_directive($directive);\n    }\n    $self->_pushback($directive);\n  }\n  \n  #need to validate against SOFA, no SO\n  if ($self->validate) {\n    $self->so(\n              Bio::Ontology::OntologyStore->get_ontology('Sequence Ontology Feature Annotation')\n              );\n  }\n}\n\n=head2 next_feature()\n\n Usage   : my $feature = $featureio->next_feature();\n Function: reads a feature record from a GFF stream and returns it as an object.\n Returns : a Bio::SeqFeature::Annotated object\n Args    : N/A\n\n\nsub next_feature {\n  my $self = shift;\n  my $gff_string;\n\n  my($f) = $self->_buffer_feature();\n  if($f){\n    return $f;\n  }\n\n  return if $self->fasta_mode();\n\n  # be graceful about empty lines or comments, and make sure we return undef\n  # if the input is consumed\n  while(($gff_string = $self->_readline()) && defined($gff_string)) {\n    next if $gff_string =~ /^\\s*$/;   #skip blank lines\n    next if $gff_string =~ /^\\#[^#]/; #skip comments, but not directives\n    last;\n  }\n\n  return unless $gff_string;\n\n  # looks like we went into FASTA mode without a directive.\n  if($gff_string =~ /^>/){\n    $self->_pushback($gff_string);\n    $self->fasta_mode(1);\n    return;\n  }\n\n  # got a directive\n  elsif($gff_string =~ /^##/){\n    $self->_handle_directive($gff_string);\n    # recurse down to  the next line.  this will bottom out on finding a real feature or EOF\n    return $self->next_feature();\n  }\n\n  # got a feature\n  else {\n    return $self->_handle_feature($gff_string);\n  }\n}\n\n=head2 next_feature_group\n\n Title   : next_feature_group\n Usage   : @feature_group = $stream->next_feature_group\n Function: Reads the next feature_group from $stream and returns it.\n\n           Feature groups in GFF3 files are separated by '###' directives. The\n           features in a group might form a hierarchical structure. The\n           complete hierarchy of features is returned, i.e. the returned array\n           represents only the top-level features.  Lower-level features can\n           be accessed using the 'get_SeqFeatures' method recursively.\n\n Example : # getting the complete hierarchy of features in a GFF3 file\n           my @toplevel_features;\n           while (my @fg = $stream->next_feature_group) {\n               push(@toplevel_features, @fg);\n           }\n Returns : an array of Bio::SeqFeature::Annotated objects\n Args    : none\n\n\nsub next_feature_group {\n  my $self = shift;\n\n  my $feat;\n  my %seen_ids;\n  my @all_feats;\n  my @toplevel_feats;\n\n  $self->{group_not_done} = 1;\n\n  while ($self->{group_not_done} && ($feat = $self->next_feature()) && defined($feat)) {\n\t# we start by collecting all features in the group and\n\t# memorizing those which have an ID attribute\n    my $anno_ID = $feat->get_Annotations('ID');\n\tif(ref($anno_ID)) {\n      my $attr_ID = $anno_ID->value;\n      $self->throw(\"Oops! ID $attr_ID exists more than once in your file!\")\n\t\tif (exists($seen_ids{$attr_ID}));\n      $seen_ids{$attr_ID} = $feat;\n\t}\n\tpush(@all_feats, $feat);\n  }\n\n  # assemble the top-level features\n  foreach $feat (@all_feats) {\n\tmy @parents = $feat->get_Annotations('Parent');\n\tif (@parents) {\n      foreach my $parent (@parents) {\n\t\tmy $parent_id = $parent->value;\n\t\t$self->throw(\"Parent with ID $parent_id not found!\") unless (exists($seen_ids{$parent_id}));\n\t\t$seen_ids{$parent_id}->add_SeqFeature($feat);\n      }\n\t} else {\n\t    push(@toplevel_feats, $feat);\n      }\n  }\n\n  return @toplevel_feats;\n}\n\n=head2 next_seq()\n\naccess the FASTA section (if any) at the end of the GFF stream.  note that this method\nwill return undef if not all features in the stream have been handled\n\n\nsub next_seq() {\n  my $self = shift;\n  return unless $self->fasta_mode();\n\n  #first time next_seq has been called.  initialize Bio::SeqIO instance\n  if(!$self->seqio){\n    $self->seqio( Bio::SeqIO->new(-format => 'fasta', -fh => $self->_fh()) );\n  }\n  return $self->seqio->next_seq();\n}\n\n=head2 write_feature()\n\n Usage   : $featureio->write_feature( Bio::SeqFeature::Annotated->new(...) );\n Function: writes a feature in GFF format.  the GFF version used is governed by the\n           '-version' argument passed to Bio::FeatureIO->new(), and defaults to GFF\n           version 3.\n Returns : ###FIXME\n Args    : a Bio::SeqFeature::Annotated object.\n\n\nsub write_feature {\n  my($self,$feature) = @_;\n  if (!$feature) {\n    $self->throw(\"gff.pm cannot write_feature unless you give a feature to write.\\n\");\n  }\n  $self->throw(\"only Bio::SeqFeature::Annotated objects are writeable\") unless $feature->isa('Bio::SeqFeature::Annotated');\n\n  if($self->version == 1){\n    return $self->_write_feature_1($feature);\n  } elsif($self->version == 2){\n    return $self->_write_feature_2($feature);\n  } elsif($self->version == 2.5){\n    return $self->_write_feature_25($feature);\n  } elsif($self->version == 3){\n    return $self->_write_feature_3($feature);\n  } else {\n    $self->throw(sprintf(\"don't know how to write GFF version %s\",$self->version));\n  }\n}\n\n################################################################################\n\n=head1 ACCESSORS\n\n\n=head2 fasta_mode()\n\n Usage   : $obj->fasta_mode($newval)\n Function: \n Example : \n Returns : value of fasta_mode (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub fasta_mode {\n  my($self,$val) = @_;\n  $self->{'fasta_mode'} = $val if defined($val);\n  return $self->{'fasta_mode'};\n}\n\n=head2 seqio()\n\n Usage   : $obj->seqio($newval)\n Function: holds a Bio::SeqIO instance for handling the GFF3 ##FASTA section.\n Returns : value of seqio (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub seqio {\n  my($self,$val) = @_;\n  $self->{'seqio'} = $val if defined($val);\n  return $self->{'seqio'};\n}\n\n=head2 sequence_region()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\n\nsub sequence_region {\n  my ($self,$k,$v) = @_;\n  if(defined($k) && defined($v)){\n    $self->{'sequence_region'}{$k} = $v;\n    return $v;\n  }\n  elsif(defined($k)){\n    return $self->{'sequence_region'}{$k};\n  }\n  else {\n    return;\n  }\n}\n\n\n=head2 so()\n\n Usage   : $obj->so($newval)\n Function: holds a Sequence Ontology instance\n Returns : value of so (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub so {\n  my $self = shift;\n  my $val = shift;\n  ###FIXME validate $val object's type\n  $self->{so} = $val if defined($val);\n  return $self->{so};\n}\n\n=head2 validate()\n\n Usage   : $obj->validate($newval)\n Function: true if encountered ontology terms in next_feature()\n           mode should be validated.\n Returns : value of validate (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub validate {\n  my($self,$val) = @_;\n  $self->{'validate'} = $val if defined($val);\n  return $self->{'validate'};\n}\n\n=head2 version()\n\n Usage   : $obj->version($newval)\n Function: version of GFF to read/write.  valid values are 1, 2, 2.5, and 3.\n Returns : value of version (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\nsub version {\n  my $self = shift;\n  my $val = shift;\n  my %valid = map {$_=>1} (1, 2, 2.5, 3);\n  if(defined $val && $valid{$val}){\n    return $self->{'version'} = $val;\n  }\n  elsif(defined($val)){\n    $self->throw('invalid version.  valid versions: '.join(' ', sort keys %valid));\n  }\n  return $self->{'version'};\n}\n\n################################################################################\n\n=head1 INTERNAL METHODS\n\n\n=head2 _buffer_feature()\n\n Usage   :\n Function: ###FIXME\n Returns : \n Args    :\n\n\nsub _buffer_feature {\n  my ($self,$f) = @_;\n\n  if ( $f ) {\n    push @{ $self->{'buffer'} }, $f;\n    return $f;\n  }\n  elsif ( $self->{'buffer'} ) {\n    return shift @{ $self->{'buffer'} };\n  }\n  else {\n    return;\n  }\n}\n\n\n=head1 _handle_directive()\n\nthis method is called for lines beginning with '##'.\n\n\nsub _handle_directive {\n  my($self,$directive_string) = @_;\n\n  $directive_string =~ s/^##//; #remove escape\n  my($directive,@arg) = split /\\s+/, $directive_string;\n\n  if($directive eq 'gff-version'){\n    my $version = $arg[0];\n    if($version != 3){\n      $self->throw(\"this is not a gff version 3 document, it is version '$version'\");\n    }\n  }\n\n  elsif($directive eq 'sequence-region'){\n    # RAE: Sequence regions are in the format sequence-region seqid start end\n    # for these we want to store the seqid, start, and end. Then when we validate\n    # we want to make sure that the features are within the seqid/start/end\n\n    $self->throw('Both start and end for sequence region should be defined')\n      unless $arg[1] && $arg[2];\n    my $fta = Bio::Annotation::OntologyTerm->new();\n    $fta->name( 'region');\n\n    my $f = Bio::SeqFeature::Annotated->new();\n    $f->seq_id( $arg[0] );\n    $f->start(  $arg[1] );\n    $f->end(    $arg[2] );\n\n    $f->type(   $fta    );\n\n    #cache this in sequence_region(), we may need it for validation later.\n    $self->sequence_region($f->seq_id => $f);\n\n    #NOTE: is this the right thing to do -- treat this as a feature? -allenday\n    #buffer it to be returned by next_feature()\n    $self->_buffer_feature($f);\n  }\n\n  elsif($directive eq 'feature-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'attribute-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'source-ontology'){\n    $self->warn(\"'##$directive' directive handling not yet implemented\");\n  }\n\n  elsif($directive eq 'FASTA' or $directive =~ /^>/){\n    #next_seq() will take care of this.\n    $self->fasta_mode(1);\n    return;\n  }\n\n  elsif($directive eq '#'){\n    #all forward references resolved\n    $self->{group_not_done} = 0;\n  }\n\n  elsif($directive eq 'organism') {\n    my $organism = $arg[0];\n    $self->organism($organism);\n  }\n\n  else {\n    $self->throw(\"don't know what do do with directive: '##\".$directive.\"'\");\n  }\n}\n\n=head1 _handle_feature()\n\nthis method is called for each line not beginning with '#'.  it parses the line and returns a\nBio::SeqFeature::Annotated object.\n\n\nsub _handle_feature {\n  my($self,$feature_string) = @_;\n\n  my $feat = Bio::SeqFeature::Annotated->new();\n\n  my($seq,$source,$type,$start,$end,$score,$strand,$phase,$attribute_string) = split /\\t/, $feature_string;\n\n  $feat->seq_id($seq);\n  $feat->source_tag($source);\n  $feat->start($start) unless $start eq '.';\n  $feat->end($end) unless $end eq '.';\n  $feat->strand($strand eq '+' ? 1 : $strand eq '-' ? -1 : 0);\n  $feat->score($score);\n  $feat->phase($phase);\n\n  my $fta = Bio::Annotation::OntologyTerm->new();\n\n  if($self->validate()){\n    # RAE Added a couple of validations based on the GFF3 spec at http://song.sourceforge.net/gff3.shtml\n    # 1. Validate the id\n    if ($seq =~ /[^a-zA-Z0-9\\.\\-\\:\\^\\*\\$\\@\\!\\+\\_\\?]/) { # I just escaped everything.\n      $self->throw(\"Validation Error: seqid ($seq) contains characters that are not [a-zA-Z0-9.:^*\\$\\@!+_?\\-] and not escaped\");\n    }\n\n    if ($seq =~ /\\s/) {\n      $self->throw(\"Validation Error: seqid ($seq) contains unescaped whitespace\")\n    }\n\n    # NOTE i think we're handling this in as a directive, and this test may be removed -allenday\n    if ($seq =~ /^>/) {\n      $self->throw(\"Validation Error: seqid ($seq) begins with a >\")\n    }\n\n    # 2. Validate the starts and stops.\n    # these need to be within the region's bounds, and\n    # also start <= end.  bail out if either is not true.\n    if ($start > $end) {\n      $self->throw(\"Validation Error: start ($start) must be less than or equal to end in $seq\");\n    }\n\n    my $region = $self->sequence_region($seq);\n    # NOTE: we can only validate against sequence-region that are declared in the file.\n    # if i reference some region from elsewhere, can't validate.  if we want to be really strict\n    # we should bail out here. -allenday\n    if ( defined($region) && $start < $region->start() || $end > $region->end() ) {\n      $self->throw(\"Validation Error: sequence location ($seq from $start to $end) does not appear to lie within a defined sequence-region\")\n    }\n\n    # 3. Validate the strand.\n    # In the unvalidated version +=1 and -=-1. Everything else is 0. We just need to warn when it is not [+-.?]\n    $self->throw(\"Validation Error: strand is not one of [+-.?] at $seq\") if ($strand =~ /^[^\\+\\-\\.\\?]$/);\n\n    # 4. Validate the phase to be one of [.012]\n    $self->throw(\"Validation Error: phase is not one of [.012] at $seq\") if ($phase =~ /^[^\\.012]$/);\n\n    my $feature_type;\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      ($feature_type) = $self->so->find_terms(-identifier => $type);\n    } else {\n      #looks like a name\n      ($feature_type) = $self->so->find_terms(-name => $type);\n    }\n\n    if(!$feature_type){\n      $self->throw(\"Validation Error: couldn't find ontology term for '$type'.\");\n    }\n    $fta->term($feature_type);\n  } else {\n\n    if($type =~ /^\\D+:\\d+$/){\n      #looks like an identifier\n      $fta->identifier($type)\n    } else {\n      $fta->name($type);\n    }\n  }\n\n  $feat->type($fta);\n\n  my %attr = ();\n  chomp $attribute_string;\n\n  unless ( $attribute_string eq '.' ) {\n    my @attributes = split ';', $attribute_string;\n    foreach my $attribute (@attributes){\n      my($key,$values) = split '=', $attribute;\n\n      # remove leading and trailing quotes from values\n      $values =~ s/^[\"']//;\n      $values =~ s/[\"']$//; #' terminate the quote for emacs\n\n      my @values = map{uri_unescape($_)} split ',', $values;\n\n     #minor hack to allow for multiple instances of the same tag\n      if ($attr{$key}) {\n        my @tmparray = @{$attr{$key}};\n        push @tmparray, @values;\n        $attr{$key} = [@tmparray];\n      } else {\n        $attr{$key} = [@values];\n      }\n    }\n  }\n\n  #Handle Dbxref attributes\n  if($attr{Dbxref} or $attr{dbxref}){\n    foreach my $value (@{ $attr{Dbxref} }, @{ $attr{dbxref} }){\n      my $a = Bio::Annotation::DBLink->new();\n      my($db,$accession) = $value =~ /^(.+?):(.+)$/;\n\n      if(!$db or !$accession){ #dbxref malformed\n        $self->throw(\"Error in line:\\n$feature_string\\nDbxref value '$value' did not conform to GFF3 specification\");\n        next;\n      }\n\n      $a->database($db);\n      $a->primary_id($accession);\n      $feat->add_Annotation('Dbxref',$a);\n    }\n  }\n\n  #Handle Ontology_term attributes\n  if($attr{Ontology_term}){\n    foreach my $id (@{ $attr{Ontology_term} }){\n      my $a = Bio::Annotation::OntologyTerm->new();\n\n      if($self->validate()){\n        my $ont_name = Bio::Ontology::OntologyStore->guess_ontology($id);\n        my $ont = Bio::Ontology::OntologyStore->get_ontology($ont_name);\n        my($term) = $ont->find_terms(-identifier => $id);\n        $a->term($term);\n      } else {\n        $a->identifier($id);\n      }\n\n      $feat->add_Annotation('Ontology_term',$a);\n    }\n  }\n\n  #Handle Gap attributes\n  if($attr{Gap}){\n     for my $value (@{ $attr{Gap} }) {\n       my $a = Bio::Annotation::SimpleValue->new();\n       $a->value($value);\n       $feat->add_Annotation('Gap',$a);\n     }\n  }\n\n  #Handle Target attributes\n  if($attr{Target}){\n    my $target_collection = Bio::Annotation::Collection->new();\n\n    foreach my $target_string (@{ $attr{Target} } ) {\n\n      #only replace + for space if + has been used in place of it\n      #that is, + could also mean plus strand, and we don't want\n      #to accidentally remove it\n \n      #presumably you can't use + for space and + for strand in the same string.      \n      $target_string =~ s/\\+/ /g unless $target_string =~ / /; \n\n      my ($t_id,$tstart,$tend,$strand,$extra) = split /\\s+/, $target_string; \n      if (!$tend || $extra) { # too much or too little stuff in the string\n        $self->throw(\"The value in the Target string, $target_string, does not conform to the GFF3 specification\");\n      }\n\n      my $a = Bio::Annotation::Target->new(\n           -target_id => $t_id,\n           -start     => $tstart,\n           -end       => $tend,\n      );\n\n      if ($strand && $strand eq '+') {\n        $strand = 1;\n      } elsif ($strand && $strand eq '-') {\n        $strand = -1;\n      } else {\n        $strand = '';\n      }\n\n      $a->strand($strand) if $strand;\n      $feat->add_Annotation('Target',$a); \n    }\n  }\n\n  #Handle ID attribute.  May only have one ID, throw error otherwise\n\n  if($attr{ID}){\n    if(scalar( @{ $attr{ID} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one ID value\");\n    }\n\n    #ID's must be unique in the file\n    if ($self->{'allIDs'}->{${$attr{ID}}[0]} && $self->validate()) {\n      $self->throw(\"Validation Error: The ID ${$attr{ID}}[0] occurs more than once in the file, but should be unique\");\n    }\n    $self->{'allIDs'}->{${$attr{ID}}[0]} = 1;\n\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{ID} }[0] );\n    $feat->add_Annotation('ID',$a);\n  }\n\n  #Handle Name attribute.  May only have one Name, throw error otherwise\n  if($attr{Name}){\n    if(scalar( @{ $attr{Name} } ) > 1){\n      $self->throw(\"Error in line:\\n$feature_string\\nA feature may have at most one Name value\");\n    }\n\n    my $a = Bio::Annotation::SimpleValue->new();\n    $a->value( @{ $attr{Name} }[0] );\n    $feat->add_Annotation('Name',$a);\n  }\n\n  foreach my $other_canonical (qw(Alias Parent Note Derives_from Index CRUD)){\n    if($attr{$other_canonical}){\n      foreach my $value (@{ $attr{$other_canonical} }){\n        my $a = Bio::Annotation::SimpleValue->new();\n        $a->value($value);\n        $feat->add_Annotation($other_canonical,$a);\n      }\n    }\n  }\n\n  my @non_reserved_tags = grep {/^[a-z]/} keys %attr;\n  foreach my $non_reserved_tag (@non_reserved_tags) {\n    next if ($non_reserved_tag eq 'dbxref');\n    foreach my $value (@{ $attr{$non_reserved_tag} }){\n      $feat = $self->_handle_non_reserved_tag($feat,$non_reserved_tag,$value);\n    }\n  }\n\n  my @illegal_tags = grep \n {!/($RESERVED_TAGS)/} \n grep {/^[A-Z]/} keys %attr;\n\n  if (@illegal_tags > 0) {\n      my $tags = join(\", \", @illegal_tags);\n      $self->throw(\"The following tag(s) are illegal and are causing this parser to die: $tags\");\n  }\n\n  return $feat;\n}\n\n=head2 _handle_non_reserved_tag()\n\n Usage   : $self->_handle_non_reserved_tag($feature,$tag,$value)\n Function: Deal with non-reserved word tags in the ninth column\n Returns : An updated Bio::SeqFeature::Annotated object\n Args    : A Bio::SeqFeature::Annotated and a tag/value pair\n\nNote that this method can be overridden in a subclass to provide\nspecial handling of non-reserved word tags.\n\n\nsub _handle_non_reserved_tag {\n  my $self = shift;\n  my ($feat,$tag,$value) = @_;\n\n  # to customize through subclassing and overriding:\n  #if ($tag eq 'someTagOfInterest') {\n  #  do something different\n  # else { do what is below\n\n  my $a;\n  if ($tag eq 'comment') {\n    $a = Bio::Annotation::Comment->new();\n  }\n  else {\n    $a = Bio::Annotation::SimpleValue->new();\n  }\n  $a->value($value); \n  $feat->add_Annotation($tag,$a);\n  \n  return $feat;\n}\n\n=head1 organims\n\nGets/sets the organims from the organism directive\n\n\nsub organism {\n    my $self = shift;\n    my $organism = shift if defined(@_);\n    return $self->{'organism'} = $organism if defined($organism);\n    return $self->{'organism'};\n}\n\n\n=head1 _write_feature_1()\n\nwrite a feature in GFF v1 format.  currently not implemented.\n\n\nsub _write_feature_1 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_2()\n\nwrite a feature in GFF v2 format.  currently not implemented.\n\n\nsub _write_feature_2 {\n  my($self,$feature) = @_;\n  $self->throw(sprintf(\"write_feature unimplemented for GFF version %s\",$self->version));\n}\n\n=head1 _write_feature_25()\n\nwrite a feature in GFF v2.5 (aka GTF) format.\n\n\nsub _write_feature_25 {\n  my($self,$feature,$group) = @_;\n\n  #the top-level feature is an aggregate of all subfeatures\n  my ($transcript_id, $gene_id) = (($feature->get_Annotations('transcript_id'))[0], ($feature->get_Annotations('gene_id'))[0]);\n  if(!defined($group)){\n    $group = ($feature->get_Annotations('ID'))[0];\n    $transcript_id ||= $group;\n    $gene_id ||= $group;\n  }\n  \n\n  my $seq    = ref($feature->seq_id) ? $feature->seq_id->value : $feature->seq_id;\n  my $source = $feature->source->value;\n  my $type   = $feature->type->name;\n  $type = 'EXON' if $type eq 'exon'; #a GTF peculiarity, incosistent with the sequence ontology.\n  my $min    = $feature->start   || '.';\n  my $max    = $feature->end     || '.';\n  my $strand = $feature->strand == 1 ? '+' : $feature->strand == -1 ? '-' : '.';\n  my $score  = defined($feature->score) ? (ref($feature->score) ? $feature->score->value : $feature->score) : '.'; # score is optional\n  my $frame  = defined($feature->frame) ? (ref($feature->frame) ? $feature->frame->value : $feature->frame) : (ref($feature->phase) ? $feature->phase->value : $feature->phase);\n\n  #these are the only valid types in a GTF document\n  if($type eq 'EXON' or $type eq 'CDS' or $type eq 'start_codon' or $type eq 'stop_codon'){\n    my $attr = sprintf('gene_id \"%s\"; transcript_id \"%s\";',$gene_id ? $gene_id->value : '',$transcript_id ? $transcript_id->value : '');\n    my $outstring = sprintf(\"%s\\t%s\\t%s\\t%s\\t%s\\t%s\\t%s\\t%s\\t%s\\n\",\n                            $seq,$source,$type,$min,$max,$score,$strand,$frame eq '.' ? 0 : $frame,$attr);\n\n    $self->_print($outstring);\n  }\n\n  foreach my $subfeat ($feature->get_SeqFeatures){\n    $self->_write_feature_25($subfeat,$group);\n  }\n}\n\n=head1 _write_feature_3()\n\nwrite a feature in GFF v3 format.","parameters":[{"label":"$self"},{"label":"$feature"}],"label":"_write_feature_3($self,$feature)"},"containerName":"main::","definition":"sub"},{"name":"uri_escape","kind":12,"line":906},{"name":"uri_escape","kind":12,"line":910},{"kind":12,"line":915,"name":"uri_escape"},{"name":"uri_escape","line":919,"kind":12},{"line":923,"kind":12,"name":"uri_escape"},{"name":"uri_escape","line":927,"kind":12},{"line":933,"kind":12,"name":"uri_escape"}]}