{"version":5,"vars":[{"kind":2,"line":85,"containerName":"","name":"base"},{"name":"next_tree","range":{"start":{"character":0,"line":97},"end":{"character":9999,"line":100}},"kind":12,"line":97,"children":[{"localvar":"my","containerName":"next_tree","name":"$self","definition":"my","line":98,"kind":13},{"containerName":"next_tree","name":"@args","kind":13,"line":98},{"containerName":"next_tree","name":"$self","line":99,"kind":13},{"line":99,"kind":12,"containerName":"next_tree","name":"throw_not_implemented"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"next_tree($self,@args)","documentation":"1;\n# $Id: TreeFactoryI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::TreeFactoryI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::TreeFactoryI - Factory Interface for getting and writing trees\n  from/to a data stream\n\n=head1 SYNOPSIS\n\n  # get a $factory from somewhere Bio::TreeIO likely\n  my $treeio = Bio::TreeIO->new(-format => 'newick', #this is phylip/newick format\n  \t\t\t       -file   => 'file.tre');\n  my $treeout = Bio::TreeIO->new(-format => 'nexus',\n  \t\t\t\t-file   => \">file.nexus\");\n\n  # convert tree formats from newick/phylip to nexus\n  while(my $tree = $treeio->next_tree) {\n      $treeout->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the minimal functions needed to get and write\ntrees from a data stream.  It is implemented by the L<Bio::TreeIO> factory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Factory::TreeFactoryI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree;\n Function: Get a tree from the factory\n Returns : L<Bio::Tree::TreeI>\n Args    : none","parameters":[{"label":"$self"},{"label":"@args"}]}},{"range":{"start":{"character":0,"line":113},"end":{"character":9999,"line":116}},"name":"write_tree","detail":"($self,@args)","signature":{"label":"write_tree($self,@args)","documentation":"1;\n# $Id: TreeFactoryI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::TreeFactoryI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::TreeFactoryI - Factory Interface for getting and writing trees\n  from/to a data stream\n\n=head1 SYNOPSIS\n\n  # get a $factory from somewhere Bio::TreeIO likely\n  my $treeio = Bio::TreeIO->new(-format => 'newick', #this is phylip/newick format\n  \t\t\t       -file   => 'file.tre');\n  my $treeout = Bio::TreeIO->new(-format => 'nexus',\n  \t\t\t\t-file   => \">file.nexus\");\n\n  # convert tree formats from newick/phylip to nexus\n  while(my $tree = $treeio->next_tree) {\n      $treeout->write_tree($tree);\n  }\n\n=head1 DESCRIPTION\n\nThis interface describes the minimal functions needed to get and write\ntrees from a data stream.  It is implemented by the L<Bio::TreeIO> factory.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Factory::TreeFactoryI;\nuse strict;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 next_tree\n\n Title   : next_tree\n Usage   : my $tree = $factory->next_tree;\n Function: Get a tree from the factory\n Returns : L<Bio::Tree::TreeI>\n Args    : none\n\n\nsub next_tree{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 write_tree\n\n Title   : write_tree\n Usage   : $treeio->write_tree($tree);\n Function: Writes a tree onto the stream\n Returns : none\n Args    : L<Bio::Tree::TreeI>","parameters":[{"label":"$self"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":113,"children":[{"localvar":"my","containerName":"write_tree","definition":"my","name":"$self","line":114,"kind":13},{"line":114,"kind":13,"name":"@args","containerName":"write_tree"},{"kind":13,"line":115,"name":"$self","containerName":"write_tree"},{"kind":12,"line":115,"containerName":"write_tree","name":"throw_not_implemented"}],"kind":12}]}