{"vars":[{"name":"base","containerName":"","kind":2,"line":80},{"definition":"sub","containerName":"main::","signature":{"label":"create($self,@args)","documentation":"1;\n# $Id: ObjectFactoryI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::ObjectFactoryI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::ObjectFactoryI - A General object creator factory\n\n=head1 SYNOPSIS\n\n# see the implementations of this interface for details but\n# basically\n\n    my $obj = $factory->create(%args);\n\n=head1 DESCRIPTION\n\nThis interface is the basic structure for a factory which creates new\nobjects.  In this case it is up to the implementer to check arguments\nand initialize whatever new object the implementing class is designed for.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Factory::ObjectFactoryI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 create\n\n Title   : create\n Usage   : $factory->create(%args)\n Function: Create a new object  \n Returns : a new object\n Args    : hash of initialization parameters","parameters":[{"label":"$self"},{"label":"@args"}]},"detail":"($self,@args)","kind":12,"children":[{"containerName":"create","name":"$self","definition":"my","localvar":"my","kind":13,"line":94},{"containerName":"create","name":"@args","kind":13,"line":94},{"line":95,"kind":13,"name":"$self","containerName":"create"},{"kind":12,"line":95,"name":"throw_not_implemented","containerName":"create"}],"line":93,"name":"create","range":{"start":{"character":0,"line":93},"end":{"line":96,"character":9999}}},{"signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: ObjectFactoryI.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::ObjectFactoryI\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason@bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::ObjectFactoryI - A General object creator factory\n\n=head1 SYNOPSIS\n\n# see the implementations of this interface for details but\n# basically\n\n    my $obj = $factory->create(%args);\n\n=head1 DESCRIPTION\n\nThis interface is the basic structure for a factory which creates new\nobjects.  In this case it is up to the implementer to check arguments\nand initialize whatever new object the implementing class is designed for.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason@bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Factory::ObjectFactoryI;\nuse strict;\nuse Carp;\n\nuse base qw(Bio::Root::RootI);\n\n=head2 create\n\n Title   : create\n Usage   : $factory->create(%args)\n Function: Create a new object  \n Returns : a new object\n Args    : hash of initialization parameters\n\n\n\nsub create{\n   my ($self,@args) = @_;\n   $self->throw_not_implemented();\n}\n\n=head2 create_object\n\n Title   : create_object\n Usage   : $obj = $factory->create_object(%args)\n Function: Create a new object.\n\n           This is supposed to supercede create(). Right now it only delegates\n           to create().\n Returns : a new object\n Args    : hash of initialization parameters","label":"create_object($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::","children":[{"line":113,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"create_object"},{"line":113,"kind":13,"containerName":"create_object","name":"@args"},{"containerName":"create_object","name":"$self","kind":13,"line":114},{"name":"create","containerName":"create_object","kind":12,"line":114},{"line":114,"kind":13,"name":"@args","containerName":"create_object"}],"line":112,"kind":12,"range":{"start":{"character":0,"line":112},"end":{"line":115,"character":9999}},"name":"create_object"}],"version":5}