{"vars":[{"name":"vars","containerName":"","line":92,"kind":2},{"kind":2,"line":102,"containerName":"","name":"base"},{"line":106,"kind":13,"containerName":null,"name":"$LOCREG"},{"children":[{"kind":13,"line":143,"containerName":"from_string","definition":"my","name":"$self","localvar":"my"},{"line":143,"kind":13,"containerName":"from_string","name":"$locstr"},{"kind":13,"line":143,"containerName":"from_string","name":"$op"},{"kind":13,"line":144,"name":"$loc","definition":"my","containerName":"from_string","localvar":"my"},{"line":152,"kind":13,"name":"$op","containerName":"from_string"},{"name":"$locstr","containerName":"from_string","line":154,"kind":13},{"containerName":"from_string","name":"$locstr","line":157,"kind":13},{"name":"$locstr","containerName":"from_string","kind":13,"line":160},{"line":162,"kind":13,"localvar":"my","containerName":"from_string","definition":"my","name":"$beg"},{"name":"$mid","containerName":"from_string","kind":13,"line":162},{"line":162,"kind":13,"name":"$end","containerName":"from_string"},{"kind":13,"line":163,"name":"@sublocs","definition":"my","containerName":"from_string","localvar":"my"},{"line":163,"kind":13,"containerName":"from_string","name":"$beg"},{"kind":13,"line":163,"containerName":"from_string","name":"$mid"},{"containerName":"from_string","name":"$end","line":163,"kind":13},{"line":165,"kind":13,"localvar":"my","definition":"my","name":"@loc_objs","containerName":"from_string"},{"kind":13,"line":166,"containerName":"from_string","name":"$loc_obj","definition":"my","localvar":"my"},{"containerName":"from_string","name":"@sublocs","kind":13,"line":169},{"kind":13,"line":170,"containerName":"from_string","name":"$subloc","definition":"my","localvar":"my"},{"containerName":"from_string","name":"@sublocs","kind":13,"line":170},{"containerName":"from_string","name":"$subloc","line":171,"kind":13},{"name":"$oparg","definition":"my","containerName":"from_string","localvar":"my","kind":13,"line":172},{"name":"$subloc","containerName":"from_string","line":172,"kind":13},{"line":172,"kind":13,"containerName":"from_string","name":"$subloc"},{"line":173,"kind":13,"name":"$subloc","containerName":"from_string"},{"containerName":"from_string","name":"$subloc","line":173,"kind":13},{"line":173,"kind":13,"name":"$subloc","containerName":"from_string"},{"line":175,"kind":13,"name":"$oparg","containerName":"from_string"},{"line":176,"kind":13,"localvar":"my","name":"$sub","definition":"my","containerName":"from_string"},{"name":"@sublocs","containerName":"from_string","kind":13,"line":176},{"containerName":"from_string","name":"$oparg","kind":13,"line":178},{"containerName":"from_string","name":"$oparg","line":178,"kind":13},{"name":"$oparg","containerName":"from_string","line":178,"kind":13},{"containerName":"from_string","name":"$sub","line":179,"kind":13},{"localvar":"my","containerName":"from_string","name":"@splitlocs","definition":"my","line":180,"kind":13},{"line":180,"kind":13,"name":"$sub","containerName":"from_string"},{"containerName":"from_string","name":"$loc_obj","line":181,"kind":13},{"line":181,"kind":12,"name":"new","containerName":"from_string"},{"containerName":"from_string","name":"$oparg","line":182,"kind":13},{"containerName":"from_string","name":"$splitloc","definition":"my","localvar":"my","kind":13,"line":183},{"name":"@splitlocs","containerName":"from_string","line":183,"kind":13},{"name":"$splitloc","containerName":"from_string","line":184,"kind":13},{"containerName":"from_string","definition":"my","name":"$sobj","localvar":"my","kind":13,"line":185},{"line":186,"kind":13,"containerName":"from_string","name":"$splitloc"},{"containerName":"from_string","definition":"my","name":"$comploc","localvar":"my","kind":13,"line":187},{"line":188,"kind":13,"containerName":"from_string","name":"$sobj"},{"kind":13,"line":188,"name":"$self","containerName":"from_string"},{"line":188,"kind":12,"name":"_parse_location","containerName":"from_string"},{"kind":13,"line":188,"containerName":"from_string","name":"$comploc"},{"kind":13,"line":189,"containerName":"from_string","name":"$sobj"},{"line":189,"kind":12,"containerName":"from_string","name":"strand"},{"containerName":"from_string","name":"$sobj","line":191,"kind":13},{"line":191,"kind":13,"name":"$self","containerName":"from_string"},{"name":"_parse_location","containerName":"from_string","line":191,"kind":12},{"line":191,"kind":13,"containerName":"from_string","name":"$splitloc"},{"name":"$loc_obj","containerName":"from_string","kind":13,"line":193},{"kind":12,"line":193,"containerName":"from_string","name":"add_sub_Location"},{"containerName":"from_string","name":"$sobj","kind":13,"line":193},{"containerName":"from_string","name":"$loc_obj","kind":13,"line":196},{"name":"$self","containerName":"from_string","line":196,"kind":13},{"kind":12,"line":196,"name":"from_string","containerName":"from_string"},{"containerName":"from_string","name":"$sub","kind":13,"line":196},{"line":196,"kind":13,"containerName":"from_string","name":"$oparg"},{"line":199,"kind":13,"containerName":"from_string","name":"$loc_obj"},{"kind":12,"line":199,"containerName":"from_string","name":"splittype"},{"kind":13,"line":199,"name":"$oparg","containerName":"from_string"},{"line":199,"kind":13,"name":"$oparg","containerName":"from_string"},{"containerName":"from_string","name":"$loc_obj","line":204,"kind":13},{"line":204,"kind":13,"name":"$self","containerName":"from_string"},{"name":"from_string","containerName":"from_string","kind":12,"line":204},{"containerName":"from_string","name":"$subloc","kind":13,"line":204},{"name":"$loc_obj","containerName":"from_string","kind":13,"line":206},{"line":206,"kind":12,"containerName":"from_string","name":"strand"},{"containerName":"from_string","name":"$op","kind":13,"line":206},{"name":"$op","containerName":"from_string","line":206,"kind":13},{"kind":13,"line":207,"name":"@loc_objs","containerName":"from_string"},{"line":207,"kind":13,"name":"$loc_obj","containerName":"from_string"},{"containerName":"from_string","definition":"my","name":"$ct","localvar":"my","kind":13,"line":209},{"kind":13,"line":209,"containerName":"from_string","name":"@loc_objs"},{"containerName":"from_string","name":"$op","line":210,"kind":13},{"containerName":"from_string","name":"$op","kind":13,"line":210},{"containerName":"from_string","name":"$op","line":210,"kind":13},{"containerName":"from_string","name":"$op","kind":13,"line":210},{"containerName":"from_string","name":"$ct","line":211,"kind":13},{"line":212,"kind":13,"name":"$self","containerName":"from_string"},{"kind":12,"line":212,"name":"throw","containerName":"from_string"},{"line":213,"kind":13,"name":"@loc_objs","containerName":"from_string"},{"line":215,"kind":13,"containerName":"from_string","name":"$ct"},{"name":"$loc","containerName":"from_string","line":216,"kind":13},{"kind":12,"line":216,"containerName":"from_string","name":"new"},{"line":217,"kind":13,"name":"$loc","containerName":"from_string"},{"name":"add_sub_Location","containerName":"from_string","line":217,"kind":12},{"kind":13,"line":217,"containerName":"from_string","name":"@loc_objs"},{"containerName":"from_string","name":"@loc_objs","line":217,"kind":13},{"containerName":"from_string","name":"$loc","line":218,"kind":13},{"kind":13,"line":220,"name":"$loc","containerName":"from_string"},{"line":220,"kind":13,"name":"@loc_objs","containerName":"from_string"},{"kind":13,"line":221,"name":"$loc","containerName":"from_string"},{"kind":13,"line":224,"containerName":"from_string","name":"$loc"},{"name":"$self","containerName":"from_string","kind":13,"line":224},{"kind":12,"line":224,"name":"_parse_location","containerName":"from_string"},{"name":"$locstr","containerName":"from_string","line":224,"kind":13},{"containerName":"from_string","name":"$loc","line":225,"kind":13},{"line":225,"kind":12,"containerName":"from_string","name":"strand"},{"kind":13,"line":225,"containerName":"from_string","name":"$op"},{"line":225,"kind":13,"containerName":"from_string","name":"$op"},{"name":"$loc","containerName":"from_string","line":227,"kind":13}],"line":142,"kind":12,"signature":{"documentation":"1;\n# $Id: FTLocationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::FTLocationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n#\n# (c) Hilmar Lapp, hlapp at gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::FTLocationFactory - A FeatureTable Location Parser\n\n=head1 SYNOPSIS\n\n    # parse a string into a location object\n    $loc = Bio::Factory::FTLocationFactory->from_string(\"join(100..200, \n                                                         400..500\");\n\n=head1 DESCRIPTION\n\nImplementation of string-encoded location parsing for the Genbank feature\ntable encoding of locations.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\nChris Fields, cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Factory::FTLocationFactory;\nuse vars qw($LOCREG);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Location::Fuzzy;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::LocationFactoryI);\n\nBEGIN {\n    # the below is an optimized regex obj. from J. Freidl's Mastering Reg Exp.\n    $LOCREG = qr{\n                (?>\n                [^()]+\n                |\n                \\(\n                (??{$LOCREG})\n                \\)\n                )*\n                }x;     \n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Factory::FTLocationFactory->new();\n Function: Builds a new Bio::Factory::FTLocationFactory object \n Returns : an instance of Bio::Factory::FTLocationFactory\n Args    :\n\n\n=head2 from_string\n\n Title   : from_string\n Usage   : $loc = $locfactory->from_string(\"100..200\");\n Function: Parses the given string and returns a Bio::LocationI implementing\n           object representing the location encoded by the string.\n\n           This implementation parses the Genbank feature table\n           encoding of locations.\n Example :\n Returns : A Bio::LocationI implementing object.\n Args    : A string.","parameters":[{"label":"$self"},{"label":"$locstr"},{"label":"$op"}],"label":"from_string($self,$locstr,$op)"},"detail":"($self,$locstr,$op)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":228},"start":{"line":142,"character":0}},"name":"from_string"},{"name":"SUBLOCS","line":168,"kind":12},{"kind":12,"line":181,"name":"Bio","containerName":"Location::Split"},{"line":216,"kind":12,"name":"Bio","containerName":"Location::Split"},{"kind":12,"line":243,"children":[{"line":244,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"_parse_location"},{"containerName":"_parse_location","name":"$locstr","line":244,"kind":13},{"line":245,"kind":13,"localvar":"my","name":"$loc","definition":"my","containerName":"_parse_location"},{"name":"$seqid","containerName":"_parse_location","line":245,"kind":13},{"kind":13,"line":248,"name":"$locstr","containerName":"_parse_location"},{"kind":13,"line":250,"containerName":"_parse_location","name":"$seqid"},{"name":"$locstr","containerName":"_parse_location","line":251,"kind":13},{"containerName":"_parse_location","definition":"my","name":"$start","localvar":"my","kind":13,"line":255},{"name":"$end","containerName":"_parse_location","line":255,"kind":13},{"containerName":"_parse_location","name":"$locstr","line":255,"kind":13},{"name":"$start","containerName":"_parse_location","kind":13,"line":260},{"containerName":"_parse_location","name":"$start","line":260,"kind":13},{"line":261,"kind":13,"name":"$end","containerName":"_parse_location"},{"containerName":"_parse_location","name":"$end","kind":13,"line":261},{"line":265,"kind":13,"localvar":"my","containerName":"_parse_location","definition":"my","name":"$loctype"},{"name":"$loctype","containerName":"_parse_location","kind":13,"line":267},{"name":"$locstr","containerName":"_parse_location","kind":13,"line":267},{"name":"$locstr","containerName":"_parse_location","kind":13,"line":267},{"localvar":"my","definition":"my","name":"$locclass","containerName":"_parse_location","line":269,"kind":13},{"line":270,"kind":13,"name":"$end","containerName":"_parse_location"},{"kind":13,"line":271,"name":"$locstr","containerName":"_parse_location"},{"kind":13,"line":272,"name":"$start","containerName":"_parse_location"},{"name":"$end","containerName":"_parse_location","line":273,"kind":13},{"containerName":"_parse_location","name":"$loctype","line":274,"kind":13},{"kind":13,"line":275,"containerName":"_parse_location","name":"$locclass"},{"name":"$end","containerName":"_parse_location","kind":13,"line":276},{"containerName":"_parse_location","name":"$start","kind":13,"line":276},{"name":"$loctype","containerName":"_parse_location","line":276,"kind":13},{"kind":13,"line":278,"containerName":"_parse_location","name":"$end"},{"kind":13,"line":278,"containerName":"_parse_location","name":"$start"},{"kind":13,"line":284,"containerName":"_parse_location","name":"$start_num","definition":"my","localvar":"my"},{"containerName":"_parse_location","name":"$end_num","kind":13,"line":284},{"kind":13,"line":284,"containerName":"_parse_location","name":"$start"},{"containerName":"_parse_location","name":"$end","line":284,"kind":13},{"name":"$start","containerName":"_parse_location","line":285,"kind":13},{"name":"$end","containerName":"_parse_location","line":285,"kind":13},{"name":"$locclass","containerName":"_parse_location","line":286,"kind":13},{"kind":13,"line":287,"name":"$start","containerName":"_parse_location"},{"containerName":"_parse_location","name":"$start_num","kind":13,"line":288},{"line":290,"kind":13,"containerName":"_parse_location","name":"$start_num"},{"kind":13,"line":292,"containerName":"_parse_location","name":"$end"},{"line":293,"kind":13,"containerName":"_parse_location","name":"$end_num"},{"containerName":"_parse_location","name":"$end_num","line":294,"kind":13},{"line":296,"kind":13,"localvar":"my","name":"$strand","definition":"my","containerName":"_parse_location"},{"name":"$start_num","containerName":"_parse_location","line":298,"kind":13},{"name":"$end_num","containerName":"_parse_location","line":298,"kind":13},{"line":298,"kind":13,"containerName":"_parse_location","name":"$loctype"},{"name":"$start","containerName":"_parse_location","line":299,"kind":13},{"kind":13,"line":299,"containerName":"_parse_location","name":"$end"},{"containerName":"_parse_location","name":"$strand","line":299,"kind":13},{"kind":13,"line":299,"containerName":"_parse_location","name":"$end"},{"name":"$start","containerName":"_parse_location","kind":13,"line":299},{"containerName":"_parse_location","name":"$loc","kind":13,"line":302},{"name":"$locclass","containerName":"_parse_location","line":302,"kind":13},{"kind":12,"line":302,"name":"new","containerName":"_parse_location"},{"line":302,"kind":13,"containerName":"_parse_location","name":"$self"},{"name":"verbose","containerName":"_parse_location","line":302,"kind":12},{"containerName":"_parse_location","name":"$start","line":303,"kind":13},{"name":"$end","containerName":"_parse_location","line":304,"kind":13},{"kind":13,"line":305,"containerName":"_parse_location","name":"$strand"},{"kind":13,"line":306,"name":"$loctype","containerName":"_parse_location"},{"kind":13,"line":308,"containerName":"_parse_location","name":"$seqid"},{"line":309,"kind":13,"name":"$loc","containerName":"_parse_location"},{"containerName":"_parse_location","name":"is_remote","kind":12,"line":309},{"kind":13,"line":310,"containerName":"_parse_location","name":"$loc"},{"containerName":"_parse_location","name":"seq_id","line":310,"kind":12},{"kind":13,"line":310,"name":"$seqid","containerName":"_parse_location"},{"line":314,"kind":13,"containerName":"_parse_location","name":"$loc"}],"containerName":"main::","definition":"sub","detail":"($self,$locstr)","signature":{"label":"_parse_location($self,$locstr)","documentation":"1;\n# $Id: FTLocationFactory.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Factory::FTLocationFactory\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Hilmar Lapp <hlapp at gmx.net>\n#\n# Copyright Hilmar Lapp\n#\n# You may distribute this module under the same terms as perl itself\n#\n# (c) Hilmar Lapp, hlapp at gnf.org, 2002.\n# (c) GNF, Genomics Institute of the Novartis Research Foundation, 2002.\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n# \n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Factory::FTLocationFactory - A FeatureTable Location Parser\n\n=head1 SYNOPSIS\n\n    # parse a string into a location object\n    $loc = Bio::Factory::FTLocationFactory->from_string(\"join(100..200, \n                                                         400..500\");\n\n=head1 DESCRIPTION\n\nImplementation of string-encoded location parsing for the Genbank feature\ntable encoding of locations.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Hilmar Lapp\n\nEmail hlapp at gmx.net\n\n=head1 CONTRIBUTORS\n\nJason Stajich, jason-at-bioperl-dot-org\nChris Fields, cjfields-at-uiuc-dot-edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Factory::FTLocationFactory;\nuse vars qw($LOCREG);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Location::Simple;\nuse Bio::Location::Split;\nuse Bio::Location::Fuzzy;\n\n\nuse base qw(Bio::Root::Root Bio::Factory::LocationFactoryI);\n\nBEGIN {\n    # the below is an optimized regex obj. from J. Freidl's Mastering Reg Exp.\n    $LOCREG = qr{\n                (?>\n                [^()]+\n                |\n                \\(\n                (??{$LOCREG})\n                \\)\n                )*\n                }x;     \n}\n\n=head2 new\n\n Title   : new\n Usage   : my $obj = Bio::Factory::FTLocationFactory->new();\n Function: Builds a new Bio::Factory::FTLocationFactory object \n Returns : an instance of Bio::Factory::FTLocationFactory\n Args    :\n\n\n=head2 from_string\n\n Title   : from_string\n Usage   : $loc = $locfactory->from_string(\"100..200\");\n Function: Parses the given string and returns a Bio::LocationI implementing\n           object representing the location encoded by the string.\n\n           This implementation parses the Genbank feature table\n           encoding of locations.\n Example :\n Returns : A Bio::LocationI implementing object.\n Args    : A string.\n\n\nsub from_string {\n    my ($self,$locstr,$op) = @_;\n    my $loc;\n    \n    #$self->debug(\"$locstr\\n\");\n    \n    # $op for operator (error handling)\n    \n    # run on first pass only\n    # Note : These location types are now deprecated in GenBank (Oct. 2006)\n    if (!defined($op)) {\n        # convert all (X.Y) to [X.Y]\n        $locstr =~ s{\\((\\d+\\.\\d+)\\)}{\\[$1\\]}g;\n        # convert ABC123:(X..Y) to ABC123:[X..Y]\n        # we should never see the above\n        $locstr =~ s{:\\((\\d+\\.{2}\\d+)\\)}{:\\[$1\\]}g;\n    }\n    \n    if ($locstr =~ m{(.*?)\\(($LOCREG)\\)(.*)}o) { # any matching parentheses?\n\n        my ($beg, $mid, $end) = ($1, $2, $3);\n        my (@sublocs) = (split(q(,),$beg), $mid, split(q(,),$end));\n        \n        my @loc_objs;\n        my $loc_obj;\n        \n        SUBLOCS:\n        while (@sublocs) {\n            my $subloc = shift @sublocs;\n            next if !$subloc;\n            my $oparg = ($subloc eq 'join'   || $subloc eq 'bond' ||\n                         $subloc eq 'order'  || $subloc eq 'complement') ? $subloc : undef;\n            # has operator, requires further work (recurse)\n            if ($oparg) {\n                my $sub = shift @sublocs;\n                # simple split operators (no recursive calls needed)\n                if (($oparg eq 'join' || $oparg eq 'order' || $oparg eq 'bond' )\n                     && $sub !~ m{(?:join|order|bond)}) {\n                    my @splitlocs = split(q(,), $sub);\n                    $loc_obj = Bio::Location::Split->new(-verbose => 1,\n                                                         -splittype => $oparg);\n                    while (my $splitloc = shift @splitlocs) {\n                        next unless $splitloc;\n                        my $sobj;\n                        if ($splitloc =~ m{\\(($LOCREG)\\)}) {\n                            my $comploc = $1;\n                            $sobj = $self->_parse_location($comploc);\n                            $sobj->strand(-1);\n                        } else {\n                            $sobj = $self->_parse_location($splitloc);\n                        }\n                        $loc_obj->add_sub_Location($sobj);\n                    }\n                } else {\n                    $loc_obj = $self->from_string($sub, $oparg);\n                    # reinsure the operator is set correctly for this level\n                    # unless it is complement\n                    $loc_obj->splittype($oparg) unless $oparg eq 'complement';\n                }\n            }\n            # no operator, simple or fuzzy \n            else {\n                $loc_obj = $self->from_string($subloc,1);\n            }\n            $loc_obj->strand(-1) if ($op && $op eq 'complement');\n            push @loc_objs, $loc_obj;\n        }\n        my $ct = @loc_objs;\n        if ($op && !($op eq 'join' || $op eq 'order' || $op eq 'bond')\n                && $ct > 1 ) {\n            $self->throw(\"Bad operator $op: had multiple locations \".\n                         scalar(@loc_objs).\", should be SplitLocationI\");\n        }\n        if ($ct > 1) {\n            $loc = Bio::Location::Split->new();\n            $loc->add_sub_Location(shift @loc_objs) while (@loc_objs);\n            return $loc;\n        } else {\n            $loc = shift @loc_objs;\n            return $loc;\n        }\n    } else { # simple location(s)\n        $loc = $self->_parse_location($locstr);\n        $loc->strand(-1) if ($op && $op eq 'complement');\n    }\n    return $loc;\n}\n\n=head2 _parse_location\n\n Title   : _parse_location\n Usage   : $loc = $locfactory->_parse_location( $loc_string)\n\n Function: Parses the given location string and returns a location object \n           with start() and end() and strand() set appropriately.\n           Note that this method is private.\n Returns : A Bio::LocationI implementing object or undef on failure\n Args    : location string","parameters":[{"label":"$self"},{"label":"$locstr"}]},"name":"_parse_location","range":{"start":{"line":243,"character":0},"end":{"line":315,"character":9999}}}],"version":5}