{"version":5,"vars":[{"name":"vars","containerName":"","kind":2,"line":155},{"kind":2,"line":168,"name":"base","containerName":""},{"line":172,"kind":13,"name":"%COORDINATE_SYSTEMS","containerName":null},{"name":"peptide","line":173,"kind":12},{"line":174,"kind":12,"name":"propeptide"},{"name":"frame","kind":12,"line":175},{"name":"cds","kind":12,"line":176},{"name":"negative_intron","line":177,"kind":12},{"kind":12,"line":178,"name":"intron"},{"name":"exon","line":179,"kind":12},{"line":180,"kind":12,"name":"inex"},{"line":181,"kind":12,"name":"gene"},{"name":"chr","line":182,"kind":12},{"name":"%COORDINATE_INTS","containerName":null,"line":185,"kind":13},{"kind":13,"line":198,"name":"$TRANSLATION","containerName":null},{"kind":13,"line":198,"name":"%COORDINATE_SYSTEMS","containerName":null},{"name":"%COORDINATE_SYSTEMS","containerName":null,"line":199,"kind":13},{"name":"%DAG","containerName":null,"line":201,"kind":13},{"name":"%NOZERO_VALUES","containerName":null,"line":214,"kind":13},{"name":"%NOZERO_KEYS","containerName":null,"kind":13,"line":215},{"detail":"($class,@args)","signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"containerName":"main::","definition":"sub","line":218,"children":[{"kind":13,"line":219,"containerName":"new","definition":"my","name":"$class","localvar":"my"},{"line":219,"kind":13,"containerName":"new","name":"@args"},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":220,"kind":13},{"containerName":"new","name":"$class","kind":13,"line":220},{"containerName":"new","name":"@args","line":220,"kind":13},{"localvar":"my","containerName":"new","name":"$graph","definition":"my","line":223,"kind":13},{"line":223,"kind":12,"name":"new","containerName":"new"},{"containerName":"new","name":"$graph","kind":13,"line":224},{"containerName":"new","name":"hash_of_arrays","kind":12,"line":224},{"name":"$DAG","containerName":"new","line":224,"kind":13},{"line":225,"kind":13,"name":"$self","containerName":"new"},{"name":"graph","containerName":"new","kind":12,"line":225},{"line":225,"kind":13,"name":"$graph","containerName":"new"},{"localvar":"my","containerName":"new","definition":"my","name":"$in","line":227,"kind":13},{"kind":13,"line":227,"containerName":"new","name":"$out"},{"line":227,"kind":13,"containerName":"new","name":"$peptide_offset"},{"containerName":"new","name":"$exons","line":227,"kind":13},{"containerName":"new","name":"$cds","kind":13,"line":228},{"containerName":"new","name":"$nozero","line":228,"kind":13},{"kind":13,"line":228,"containerName":"new","name":"$strict"},{"kind":13,"line":229,"containerName":"new","name":"$self"},{"line":229,"kind":12,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","line":237,"kind":13},{"containerName":"new","name":"$self","line":240,"kind":13},{"containerName":"new","name":"$in","line":242,"kind":13},{"name":"$self","containerName":"new","line":242,"kind":13},{"name":"in","containerName":"new","line":242,"kind":12},{"kind":13,"line":242,"name":"$in","containerName":"new"},{"name":"$out","containerName":"new","kind":13,"line":243},{"containerName":"new","name":"$self","line":243,"kind":13},{"kind":12,"line":243,"name":"out","containerName":"new"},{"line":243,"kind":13,"name":"$out","containerName":"new"},{"name":"$cds","containerName":"new","line":244,"kind":13},{"line":244,"kind":13,"name":"$self","containerName":"new"},{"name":"cds","containerName":"new","line":244,"kind":12},{"kind":13,"line":244,"name":"$cds","containerName":"new"},{"line":245,"kind":13,"name":"$exons","containerName":"new"},{"line":245,"kind":13,"containerName":"new","name":"$exons"},{"line":245,"kind":13,"name":"$self","containerName":"new"},{"name":"exons","containerName":"new","kind":12,"line":245},{"kind":13,"line":245,"containerName":"new","name":"$exons"},{"kind":13,"line":246,"name":"$peptide_offset","containerName":"new"},{"name":"$self","containerName":"new","line":246,"kind":13},{"line":246,"kind":12,"name":"peptide_offset","containerName":"new"},{"kind":13,"line":246,"name":"$peptide_offset","containerName":"new"},{"containerName":"new","name":"$nozero","kind":13,"line":247},{"name":"$self","containerName":"new","kind":13,"line":247},{"kind":12,"line":247,"containerName":"new","name":"nozero"},{"containerName":"new","name":"$nozero","line":247,"kind":13},{"kind":13,"line":248,"name":"$strict","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":248},{"line":248,"kind":12,"containerName":"new","name":"strict"},{"name":"$strict","containerName":"new","line":248,"kind":13},{"kind":13,"line":250,"name":"$self","containerName":"new"}],"kind":12,"range":{"start":{"line":218,"character":0},"end":{"line":251,"character":9999}},"name":"new"},{"containerName":"new","name":"SUPER","kind":12,"line":220},{"name":"Bio","containerName":"Coordinate::Graph","line":223,"kind":12},{"name":"_direction","line":240,"kind":12},{"detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)","label":"in($self,$value)"},"containerName":"main::","definition":"sub","line":264,"children":[{"kind":13,"line":265,"definition":"my","name":"$self","containerName":"in","localvar":"my"},{"kind":13,"line":265,"containerName":"in","name":"$value"},{"name":"$value","containerName":"in","kind":13,"line":266},{"kind":13,"line":267,"name":"$self","containerName":"in"},{"name":"throw","containerName":"in","kind":12,"line":267},{"containerName":"in","name":"%COORDINATE_SYSTEMS","kind":13,"line":268},{"name":"$COORDINATE_SYSTEMS","containerName":"in","kind":13,"line":269},{"name":"$value","containerName":"in","line":269,"kind":13},{"line":271,"kind":13,"containerName":"in","name":"$self"},{"name":"$COORDINATE_SYSTEMS","containerName":"in","kind":13,"line":271},{"line":271,"kind":13,"name":"$value","containerName":"in"},{"name":"$COORDINATE_INTS","containerName":"in","kind":13,"line":273},{"line":273,"kind":13,"name":"$self","containerName":"in"}],"kind":12,"range":{"end":{"line":274,"character":9999},"start":{"character":0,"line":264}},"name":"in"},{"range":{"end":{"line":298,"character":9999},"start":{"character":0,"line":288}},"name":"out","detail":"($self,$value)","signature":{"label":"out($self,$value)","documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":288,"children":[{"line":289,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"out"},{"containerName":"out","name":"$value","kind":13,"line":289},{"name":"$value","containerName":"out","kind":13,"line":290},{"kind":13,"line":291,"name":"$self","containerName":"out"},{"containerName":"out","name":"throw","line":291,"kind":12},{"line":292,"kind":13,"name":"%COORDINATE_SYSTEMS","containerName":"out"},{"containerName":"out","name":"$COORDINATE_SYSTEMS","line":293,"kind":13},{"containerName":"out","name":"$value","line":293,"kind":13},{"name":"$self","containerName":"out","kind":13,"line":295},{"line":295,"kind":13,"containerName":"out","name":"$COORDINATE_SYSTEMS"},{"name":"$value","containerName":"out","kind":13,"line":295},{"containerName":"out","name":"$COORDINATE_INTS","kind":13,"line":297},{"containerName":"out","name":"$self","kind":13,"line":297}],"kind":12},{"name":"strict","range":{"end":{"line":320,"character":9999},"start":{"line":313,"character":0}},"kind":12,"line":313,"children":[{"containerName":"strict","definition":"my","name":"$self","localvar":"my","kind":13,"line":314},{"kind":13,"line":314,"containerName":"strict","name":"$value"},{"name":"$value","containerName":"strict","line":315,"kind":13},{"name":"$value","containerName":"strict","kind":13,"line":316},{"containerName":"strict","name":"$self","kind":13,"line":316},{"containerName":"strict","name":"$self","kind":13,"line":316},{"name":"$self","containerName":"strict","line":319,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"strict($self,$value)"}},{"kind":12,"line":337,"children":[{"kind":13,"line":338,"containerName":"nozero","definition":"my","name":"$self","localvar":"my"},{"containerName":"nozero","name":"$value","line":338,"kind":13},{"line":340,"kind":13,"name":"$value","containerName":"nozero"},{"line":341,"kind":13,"name":"$self","containerName":"nozero"},{"kind":12,"line":341,"name":"throw","containerName":"nozero"},{"line":342,"kind":13,"containerName":"nozero","name":"$NOZERO_VALUES"},{"containerName":"nozero","name":"$NOZERO_VALUES","kind":13,"line":343},{"containerName":"nozero","name":"$value","kind":13,"line":343},{"name":"$self","containerName":"nozero","line":344,"kind":13},{"containerName":"nozero","name":"$NOZERO_VALUES","kind":13,"line":344},{"line":344,"kind":13,"containerName":"nozero","name":"$value"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'","label":"nozero($self,$value)"},"name":"nozero","range":{"end":{"line":345,"character":9999},"start":{"character":0,"line":337}}},{"containerName":null,"name":"$res","definition":"my","localvar":"my","kind":13,"line":347},{"name":"%self","containerName":null,"kind":13,"line":347},{"name":"%NOZERO_KEYS","containerName":null,"line":348,"kind":13},{"kind":13,"line":348,"containerName":null,"name":"$res"},{"detail":"($self,$value)","signature":{"label":"graph($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)"},"containerName":"main::","definition":"sub","line":363,"children":[{"containerName":"graph","name":"$self","definition":"my","localvar":"my","kind":13,"line":364},{"line":364,"kind":13,"containerName":"graph","name":"$value"},{"line":365,"kind":13,"containerName":"graph","name":"$value"},{"name":"$self","containerName":"graph","kind":13,"line":366},{"line":366,"kind":12,"containerName":"graph","name":"throw"},{"name":"$value","containerName":"graph","kind":13,"line":367},{"kind":12,"line":367,"containerName":"graph","name":"isa"},{"kind":13,"line":368,"name":"$self","containerName":"graph"},{"name":"$value","containerName":"graph","kind":13,"line":368},{"line":370,"kind":13,"containerName":"graph","name":"$self"}],"kind":12,"range":{"start":{"character":0,"line":363},"end":{"line":371,"character":9999}},"name":"graph"},{"detail":"($self,$value)","signature":{"label":"peptide($self,$value)","documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":384,"children":[{"containerName":"peptide","name":"$self","definition":"my","localvar":"my","kind":13,"line":385},{"kind":13,"line":385,"containerName":"peptide","name":"$value"},{"kind":13,"line":386,"name":"$value","containerName":"peptide"},{"name":"$self","containerName":"peptide","line":387,"kind":13},{"line":387,"kind":12,"name":"throw","containerName":"peptide"},{"kind":13,"line":387,"containerName":"peptide","name":"$value"},{"containerName":"peptide","name":"$value","kind":13,"line":388},{"kind":12,"line":388,"name":"isa","containerName":"peptide"},{"containerName":"peptide","name":"$self","kind":13,"line":390},{"name":"throw","containerName":"peptide","kind":12,"line":390},{"name":"$value","containerName":"peptide","kind":13,"line":391},{"line":391,"kind":12,"containerName":"peptide","name":"start"},{"name":"$self","containerName":"peptide","kind":13,"line":392},{"containerName":"peptide","name":"$value","line":392,"kind":13},{"name":"start","containerName":"peptide","kind":12,"line":392},{"line":394,"kind":13,"name":"$self","containerName":"peptide"},{"line":394,"kind":12,"containerName":"peptide","name":"throw"},{"name":"$value","containerName":"peptide","kind":13,"line":395},{"name":"end","containerName":"peptide","line":395,"kind":12},{"line":396,"kind":13,"name":"$self","containerName":"peptide"},{"containerName":"peptide","name":"$value","kind":13,"line":396},{"name":"end","containerName":"peptide","line":396,"kind":12},{"kind":13,"line":396,"containerName":"peptide","name":"$self"},{"localvar":"my","containerName":"peptide","name":"$a","definition":"my","line":399,"kind":13},{"containerName":"peptide","name":"$self","line":399,"kind":13},{"kind":12,"line":400,"containerName":"peptide","name":"_create_pair"},{"kind":13,"line":400,"name":"$self","containerName":"peptide"},{"line":400,"kind":12,"name":"strict","containerName":"peptide"},{"containerName":"peptide","name":"$self","kind":13,"line":401},{"kind":13,"line":401,"containerName":"peptide","name":"$self"},{"localvar":"my","name":"$mapper","definition":"my","containerName":"peptide","line":402,"kind":13},{"kind":13,"line":402,"containerName":"peptide","name":"$COORDINATE_SYSTEMS"},{"kind":13,"line":402,"containerName":"peptide","name":"$COORDINATE_SYSTEMS"},{"name":"$self","containerName":"peptide","kind":13,"line":403},{"line":403,"kind":13,"name":"$mapper","containerName":"peptide"},{"kind":13,"line":403,"name":"$a","containerName":"peptide"},{"kind":12,"line":406,"name":"new","containerName":"peptide"},{"name":"$self","containerName":"peptide","kind":13,"line":407},{"name":"$self","containerName":"peptide","kind":13,"line":408},{"line":408,"kind":13,"containerName":"peptide","name":"$self"},{"name":"$self","containerName":"peptide","line":410,"kind":13},{"kind":12,"line":410,"containerName":"peptide","name":"verbose"}],"kind":12,"range":{"start":{"character":0,"line":384},"end":{"line":412,"character":9999}},"name":"peptide"},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":405},{"children":[{"line":425,"kind":13,"localvar":"my","containerName":"peptide_offset","name":"$self","definition":"my"},{"containerName":"peptide_offset","name":"$offset","kind":13,"line":425},{"line":425,"kind":13,"containerName":"peptide_offset","name":"$len"},{"containerName":"peptide_offset","name":"$offset","line":426,"kind":13},{"line":427,"kind":13,"containerName":"peptide_offset","name":"$self"},{"containerName":"peptide_offset","name":"throw","kind":12,"line":427},{"containerName":"peptide_offset","name":"$offset","line":428,"kind":13},{"line":429,"kind":13,"containerName":"peptide_offset","name":"$self"},{"kind":13,"line":429,"name":"$offset","containerName":"peptide_offset"},{"kind":13,"line":431,"name":"$len","containerName":"peptide_offset"},{"line":432,"kind":13,"containerName":"peptide_offset","name":"$self"},{"line":432,"kind":12,"containerName":"peptide_offset","name":"throw"},{"kind":13,"line":433,"containerName":"peptide_offset","name":"$len"},{"line":434,"kind":13,"containerName":"peptide_offset","name":"$self"},{"line":434,"kind":13,"containerName":"peptide_offset","name":"$len"},{"localvar":"my","containerName":"peptide_offset","name":"$a","definition":"my","line":437,"kind":13},{"line":437,"kind":13,"containerName":"peptide_offset","name":"$self"},{"name":"_create_pair","containerName":"peptide_offset","kind":12,"line":438},{"line":438,"kind":13,"containerName":"peptide_offset","name":"$self"},{"name":"strict","containerName":"peptide_offset","kind":12,"line":438},{"containerName":"peptide_offset","name":"$offset","line":438,"kind":13},{"line":438,"kind":13,"name":"$self","containerName":"peptide_offset"},{"containerName":"peptide_offset","definition":"my","name":"$mapper","localvar":"my","kind":13,"line":439},{"kind":13,"line":439,"name":"$COORDINATE_SYSTEMS","containerName":"peptide_offset"},{"kind":13,"line":439,"name":"$COORDINATE_SYSTEMS","containerName":"peptide_offset"},{"name":"$self","containerName":"peptide_offset","line":440,"kind":13},{"name":"$mapper","containerName":"peptide_offset","line":440,"kind":13},{"containerName":"peptide_offset","name":"$a","kind":13,"line":440},{"kind":13,"line":442,"name":"$self","containerName":"peptide_offset"}],"line":424,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$offset"},{"label":"$len"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)","label":"peptide_offset($self,$offset,$len)"},"detail":"($self,$offset,$len)","definition":"sub","containerName":"main::","range":{"end":{"line":443,"character":9999},"start":{"character":0,"line":424}},"name":"peptide_offset"},{"range":{"start":{"character":0,"line":456},"end":{"character":9999,"line":464}},"name":"peptide_length","detail":"($self,$len)","signature":{"parameters":[{"label":"$self"},{"label":"$len"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)","label":"peptide_length($self,$len)"},"containerName":"main::","definition":"sub","line":456,"children":[{"line":457,"kind":13,"localvar":"my","containerName":"peptide_length","name":"$self","definition":"my"},{"name":"$len","containerName":"peptide_length","line":457,"kind":13},{"name":"$len","containerName":"peptide_length","line":458,"kind":13},{"kind":13,"line":459,"name":"$self","containerName":"peptide_length"},{"name":"throw","containerName":"peptide_length","kind":12,"line":459},{"name":"$len","containerName":"peptide_length","line":460,"kind":13},{"containerName":"peptide_length","name":"$len","line":460,"kind":13},{"containerName":"peptide_length","name":"$self","line":461,"kind":13},{"containerName":"peptide_length","name":"$len","line":461,"kind":13},{"kind":13,"line":463,"containerName":"peptide_length","name":"$self"}],"kind":12},{"range":{"start":{"character":0,"line":481},"end":{"character":9999,"line":712}},"name":"exons","line":481,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"exons","line":482,"kind":13},{"kind":13,"line":482,"name":"@value","containerName":"exons"},{"line":483,"kind":13,"localvar":"my","definition":"my","name":"$cds_mapper","containerName":"exons"},{"kind":13,"line":483,"name":"$COORDINATE_SYSTEMS","containerName":"exons"},{"line":483,"kind":13,"name":"$COORDINATE_SYSTEMS","containerName":"exons"},{"name":"$inex_mapper","definition":"my","containerName":"exons","localvar":"my","kind":13,"line":484},{"containerName":"exons","name":"$COORDINATE_SYSTEMS","kind":13,"line":485},{"containerName":"exons","name":"$COORDINATE_SYSTEMS","kind":13,"line":485},{"localvar":"my","name":"$exon_mapper","definition":"my","containerName":"exons","line":486,"kind":13},{"line":487,"kind":13,"name":"$COORDINATE_SYSTEMS","containerName":"exons"},{"name":"$COORDINATE_SYSTEMS","containerName":"exons","line":487,"kind":13},{"kind":13,"line":488,"containerName":"exons","definition":"my","name":"$intron_mapper","localvar":"my"},{"line":489,"kind":13,"containerName":"exons","name":"$COORDINATE_SYSTEMS"},{"containerName":"exons","name":"$COORDINATE_SYSTEMS","kind":13,"line":489},{"localvar":"my","containerName":"exons","name":"$negative_intron_mapper","definition":"my","line":490,"kind":13},{"containerName":"exons","name":"$COORDINATE_SYSTEMS","kind":13,"line":491},{"kind":13,"line":491,"containerName":"exons","name":"$COORDINATE_SYSTEMS"},{"line":492,"kind":13,"localvar":"my","definition":"my","name":"$exon_cds_mapper","containerName":"exons"},{"containerName":"exons","name":"$COORDINATE_SYSTEMS","line":492,"kind":13},{"line":492,"kind":13,"containerName":"exons","name":"$COORDINATE_SYSTEMS"},{"name":"@value","containerName":"exons","line":494,"kind":13},{"line":495,"kind":13,"containerName":"exons","name":"$value"},{"name":"$value","containerName":"exons","kind":13,"line":496},{"containerName":"exons","name":"isa","line":496,"kind":12},{"name":"$value","containerName":"exons","kind":13,"line":497},{"name":"location","containerName":"exons","line":497,"kind":12},{"kind":12,"line":497,"name":"isa","containerName":"exons"},{"containerName":"exons","name":"@value","line":498,"kind":13},{"line":498,"kind":13,"containerName":"exons","name":"$value"},{"name":"location","containerName":"exons","kind":12,"line":498},{"kind":12,"line":498,"containerName":"exons","name":"each_Location"},{"containerName":"exons","name":"$self","kind":13,"line":500},{"name":"throw","containerName":"exons","line":500,"kind":12},{"line":501,"kind":13,"name":"@value","containerName":"exons"},{"line":502,"kind":13,"name":"$self","containerName":"exons"},{"name":"throw","containerName":"exons","line":502,"kind":12},{"line":503,"kind":13,"containerName":"exons","name":"$value"},{"containerName":"exons","name":"$value","kind":13,"line":504},{"name":"$value","containerName":"exons","line":504,"kind":13},{"name":"isa","containerName":"exons","line":504,"kind":12},{"name":"$value","containerName":"exons","kind":13,"line":511},{"containerName":"exons","name":"strand","line":511,"kind":12},{"name":"$value","containerName":"exons","line":512,"kind":13},{"kind":12,"line":512,"name":"strand","containerName":"exons"},{"line":513,"kind":13,"containerName":"exons","name":"@value"},{"line":514,"kind":13,"name":"$b","containerName":"exons"},{"line":514,"kind":13,"containerName":"exons","name":"$a"},{"kind":12,"line":515,"containerName":"exons","name":"start"},{"containerName":"exons","name":"@value","line":516,"kind":13},{"name":"$self","containerName":"exons","kind":13,"line":518},{"containerName":"exons","name":"cds","line":518,"kind":12},{"name":"$self","containerName":"exons","line":519,"kind":13},{"containerName":"exons","name":"cds","kind":12,"line":519},{"containerName":"exons","name":"new","kind":12,"line":520},{"line":520,"kind":13,"containerName":"exons","name":"$value"},{"kind":12,"line":520,"containerName":"exons","name":"start"},{"kind":13,"line":521,"name":"$value","containerName":"exons"},{"containerName":"exons","name":"end","kind":12,"line":521},{"kind":13,"line":522,"containerName":"exons","name":"$value"},{"kind":12,"line":522,"name":"strand","containerName":"exons"},{"name":"$value","containerName":"exons","line":523,"kind":13},{"containerName":"exons","name":"seq_id","line":523,"kind":12},{"line":524,"kind":13,"containerName":"exons","name":"$self"},{"containerName":"exons","name":"verbose","kind":12,"line":524},{"name":"@value","containerName":"exons","kind":13,"line":529},{"name":"$a","containerName":"exons","line":530,"kind":13},{"line":530,"kind":13,"name":"$b","containerName":"exons"},{"kind":12,"line":531,"containerName":"exons","name":"start"},{"name":"@value","containerName":"exons","kind":13,"line":532},{"line":533,"kind":13,"name":"$self","containerName":"exons"},{"kind":12,"line":533,"containerName":"exons","name":"cds"},{"name":"$self","containerName":"exons","line":534,"kind":13},{"name":"cds","containerName":"exons","kind":12,"line":534},{"kind":12,"line":535,"name":"new","containerName":"exons"},{"name":"$value","containerName":"exons","line":535,"kind":13},{"kind":12,"line":535,"containerName":"exons","name":"start"},{"line":536,"kind":13,"name":"$value","containerName":"exons"},{"line":536,"kind":12,"name":"end","containerName":"exons"},{"line":537,"kind":13,"containerName":"exons","name":"$value"},{"name":"strand","containerName":"exons","line":537,"kind":12},{"containerName":"exons","name":"$value","line":538,"kind":13},{"containerName":"exons","name":"seq_id","kind":12,"line":538},{"containerName":"exons","name":"$self","kind":13,"line":539},{"containerName":"exons","name":"verbose","line":539,"kind":12},{"kind":13,"line":546,"containerName":"exons","name":"$self"},{"containerName":"exons","name":"@value","kind":13,"line":546},{"line":550,"kind":13,"localvar":"my","name":"@exons","definition":"my","containerName":"exons"},{"line":552,"kind":13,"localvar":"my","containerName":"exons","name":"$gene_mapper","definition":"my"},{"line":553,"kind":13,"containerName":"exons","name":"$self"},{"line":553,"kind":13,"name":"$gene_mapper","containerName":"exons"},{"localvar":"my","containerName":"exons","definition":"my","name":"$tmp_in","line":555,"kind":13},{"line":555,"kind":13,"name":"$self","containerName":"exons"},{"line":556,"kind":13,"localvar":"my","containerName":"exons","definition":"my","name":"$tmp_out"},{"containerName":"exons","name":"$self","kind":13,"line":556},{"localvar":"my","containerName":"exons","name":"$tmp_verb","definition":"my","line":557,"kind":13},{"containerName":"exons","name":"$self","line":557,"kind":13},{"kind":12,"line":557,"name":"verbose","containerName":"exons"},{"name":"$self","containerName":"exons","kind":13,"line":558},{"line":558,"kind":12,"name":"verbose","containerName":"exons"},{"name":"$self","containerName":"exons","line":560,"kind":13},{"line":560,"kind":12,"containerName":"exons","name":"in"},{"kind":13,"line":561,"name":"$self","containerName":"exons"},{"line":561,"kind":12,"containerName":"exons","name":"out"},{"containerName":"exons","name":"@exons","kind":13,"line":562},{"kind":13,"line":562,"name":"$self","containerName":"exons"},{"kind":12,"line":562,"containerName":"exons","name":"map"},{"kind":13,"line":562,"name":"@value","containerName":"exons"},{"line":564,"kind":13,"name":"$self","containerName":"exons"},{"kind":13,"line":564,"name":"$tmp_in","containerName":"exons"},{"line":565,"kind":13,"name":"$self","containerName":"exons"},{"line":565,"kind":13,"name":"$tmp_out","containerName":"exons"},{"kind":13,"line":566,"name":"$self","containerName":"exons"},{"kind":12,"line":566,"containerName":"exons","name":"verbose"},{"line":566,"kind":13,"containerName":"exons","name":"$tmp_verb"},{"name":"@exons","containerName":"exons","kind":13,"line":568},{"line":568,"kind":13,"containerName":"exons","name":"@value"},{"line":571,"kind":13,"localvar":"my","containerName":"exons","name":"$cds_map","definition":"my"},{"kind":12,"line":571,"name":"new","containerName":"exons"},{"localvar":"my","definition":"my","name":"$inex_map","containerName":"exons","line":572,"kind":13},{"kind":12,"line":572,"containerName":"exons","name":"new"},{"kind":13,"line":573,"containerName":"exons","name":"$exon_map","definition":"my","localvar":"my"},{"name":"new","containerName":"exons","kind":12,"line":573},{"localvar":"my","definition":"my","name":"$exon_cds_map","containerName":"exons","line":574,"kind":13},{"name":"new","containerName":"exons","kind":12,"line":574},{"name":"$intron_map","definition":"my","containerName":"exons","localvar":"my","kind":13,"line":575},{"containerName":"exons","name":"new","line":575,"kind":12},{"localvar":"my","definition":"my","name":"$negative_intron_map","containerName":"exons","line":576,"kind":13},{"name":"new","containerName":"exons","kind":12,"line":576},{"localvar":"my","containerName":"exons","name":"$tr_end","definition":"my","line":578,"kind":13},{"kind":13,"line":579,"containerName":"exons","name":"$coffset","definition":"my","localvar":"my"},{"definition":"my","name":"$exon_counter","containerName":"exons","localvar":"my","kind":13,"line":580},{"localvar":"my","containerName":"exons","definition":"my","name":"$prev_exon_end","line":581,"kind":13},{"containerName":"exons","definition":"my","name":"$exon","localvar":"my","kind":13,"line":583},{"line":583,"kind":13,"containerName":"exons","name":"@exons"},{"containerName":"exons","name":"$exon_counter","kind":13,"line":584},{"kind":13,"line":590,"containerName":"exons","name":"$match1","definition":"my","localvar":"my"},{"containerName":"exons","name":"new","line":591,"kind":12},{"containerName":"exons","name":"$exon","line":592,"kind":13},{"name":"start","containerName":"exons","kind":12,"line":592},{"line":593,"kind":13,"containerName":"exons","name":"$exon"},{"line":593,"kind":12,"containerName":"exons","name":"end"},{"containerName":"exons","name":"$self","line":595,"kind":13},{"line":595,"kind":12,"containerName":"exons","name":"verbose"},{"containerName":"exons","definition":"my","name":"$match2","localvar":"my","kind":13,"line":597},{"containerName":"exons","name":"new","kind":12,"line":598},{"name":"$tr_end","containerName":"exons","kind":13,"line":599},{"containerName":"exons","name":"$tr_end","kind":13,"line":600},{"line":600,"kind":13,"containerName":"exons","name":"$exon"},{"containerName":"exons","name":"end","line":600,"kind":12},{"containerName":"exons","name":"$exon","line":600,"kind":13},{"kind":12,"line":600,"name":"start","containerName":"exons"},{"kind":13,"line":601,"name":"$exon","containerName":"exons"},{"containerName":"exons","name":"strand","kind":12,"line":601},{"containerName":"exons","name":"$self","line":602,"kind":13},{"name":"verbose","containerName":"exons","line":602,"kind":12},{"name":"$cds_map","containerName":"exons","line":604,"kind":13},{"containerName":"exons","name":"add_mapper","line":604,"kind":12},{"name":"new","containerName":"exons","kind":12,"line":605},{"containerName":"exons","name":"$match1","line":605,"kind":13},{"line":606,"kind":13,"name":"$match2","containerName":"exons"},{"containerName":"exons","name":"$exon","kind":13,"line":610},{"containerName":"exons","name":"start","line":610,"kind":12},{"containerName":"exons","name":"$exon","line":610,"kind":13},{"name":"end","containerName":"exons","line":610,"kind":12},{"containerName":"exons","name":"$coffset","line":611,"kind":13},{"name":"$tr_end","containerName":"exons","kind":13,"line":611},{"kind":13,"line":611,"name":"$exon","containerName":"exons"},{"containerName":"exons","name":"start","line":611,"kind":12},{"kind":13,"line":613,"name":"$tr_end","containerName":"exons"},{"line":613,"kind":13,"containerName":"exons","name":"$tr_end"},{"name":"$exon","containerName":"exons","kind":13,"line":613},{"line":613,"kind":12,"name":"end","containerName":"exons"},{"line":613,"kind":13,"name":"$exon","containerName":"exons"},{"line":613,"kind":12,"containerName":"exons","name":"start"},{"line":619,"kind":13,"name":"$prev_exon_end","containerName":"exons"},{"localvar":"my","containerName":"exons","name":"$match3","definition":"my","line":620,"kind":13},{"containerName":"exons","name":"new","kind":12,"line":621},{"containerName":"exons","name":"$prev_exon_end","line":622,"kind":13},{"name":"$exon","containerName":"exons","kind":13,"line":623},{"kind":12,"line":623,"containerName":"exons","name":"start"},{"line":624,"kind":13,"containerName":"exons","name":"$exon"},{"line":624,"kind":12,"containerName":"exons","name":"strand"},{"containerName":"exons","name":"$self","kind":13,"line":625},{"kind":12,"line":625,"name":"verbose","containerName":"exons"},{"localvar":"my","definition":"my","name":"$match4","containerName":"exons","line":627,"kind":13},{"containerName":"exons","name":"new","line":628,"kind":12},{"containerName":"exons","name":"$exon_counter","kind":13,"line":628},{"name":"$exon","containerName":"exons","kind":13,"line":630},{"name":"start","containerName":"exons","line":630,"kind":12},{"kind":13,"line":630,"containerName":"exons","name":"$prev_exon_end"},{"kind":13,"line":631,"name":"$exon","containerName":"exons"},{"kind":12,"line":631,"containerName":"exons","name":"strand"},{"containerName":"exons","name":"$self","kind":13,"line":632},{"line":632,"kind":12,"containerName":"exons","name":"verbose"},{"kind":13,"line":635,"definition":"my","name":"$match5","containerName":"exons","localvar":"my"},{"line":636,"kind":12,"containerName":"exons","name":"new"},{"containerName":"exons","name":"$exon_counter","kind":13,"line":636},{"containerName":"exons","name":"$exon","line":637,"kind":13},{"line":637,"kind":12,"name":"start","containerName":"exons"},{"kind":13,"line":637,"containerName":"exons","name":"$prev_exon_end"},{"name":"$exon","containerName":"exons","line":639,"kind":13},{"containerName":"exons","name":"strand","line":639,"kind":12},{"line":640,"kind":13,"name":"$self","containerName":"exons"},{"name":"verbose","containerName":"exons","line":640,"kind":12},{"kind":13,"line":642,"containerName":"exons","name":"$inex_map"},{"line":642,"kind":12,"containerName":"exons","name":"add_mapper"},{"containerName":"exons","name":"new","line":643,"kind":12},{"containerName":"exons","name":"$match3","kind":13,"line":643},{"containerName":"exons","name":"$match4","line":645,"kind":13},{"kind":13,"line":647,"name":"$intron_map","containerName":"exons"},{"line":647,"kind":12,"name":"add_mapper","containerName":"exons"},{"kind":12,"line":648,"containerName":"exons","name":"new"},{"containerName":"exons","name":"$self","line":648,"kind":13},{"kind":12,"line":648,"containerName":"exons","name":"_clone_loc"},{"name":"$match3","containerName":"exons","line":648,"kind":13},{"name":"$self","containerName":"exons","line":649,"kind":13},{"line":649,"kind":12,"containerName":"exons","name":"_clone_loc"},{"kind":13,"line":649,"name":"$match4","containerName":"exons"},{"kind":13,"line":652,"name":"$negative_intron_map","containerName":"exons"},{"line":652,"kind":12,"containerName":"exons","name":"add_mapper"},{"name":"new","containerName":"exons","kind":12,"line":653},{"line":653,"kind":13,"containerName":"exons","name":"$self"},{"name":"_clone_loc","containerName":"exons","line":653,"kind":12},{"containerName":"exons","name":"$match4","line":653,"kind":13},{"kind":13,"line":655,"name":"$match5","containerName":"exons"},{"line":660,"kind":13,"containerName":"exons","name":"$prev_exon_end"},{"line":660,"kind":13,"name":"$exon","containerName":"exons"},{"kind":12,"line":660,"name":"end","containerName":"exons"},{"localvar":"my","name":"$match6","definition":"my","containerName":"exons","line":665,"kind":13},{"line":666,"kind":12,"name":"new","containerName":"exons"},{"line":666,"kind":13,"containerName":"exons","name":"$exon_counter"},{"containerName":"exons","name":"$exon","line":668,"kind":13},{"line":668,"kind":12,"name":"end","containerName":"exons"},{"containerName":"exons","name":"$exon","line":668,"kind":13},{"line":668,"kind":12,"name":"start","containerName":"exons"},{"containerName":"exons","name":"$exon","kind":13,"line":669},{"name":"strand","containerName":"exons","line":669,"kind":12},{"containerName":"exons","name":"$self","line":670,"kind":13},{"kind":12,"line":670,"containerName":"exons","name":"verbose"},{"kind":13,"line":672,"definition":"my","name":"$pair2","containerName":"exons","localvar":"my"},{"kind":12,"line":672,"name":"new","containerName":"exons"},{"line":672,"kind":13,"name":"$self","containerName":"exons"},{"name":"_clone_loc","containerName":"exons","line":672,"kind":12},{"line":672,"kind":13,"name":"$match1","containerName":"exons"},{"name":"$match6","containerName":"exons","kind":13,"line":674},{"kind":13,"line":675,"containerName":"exons","name":"$pair3","definition":"my","localvar":"my"},{"line":675,"kind":12,"name":"new","containerName":"exons"},{"containerName":"exons","name":"$self","kind":13,"line":675},{"containerName":"exons","name":"_clone_loc","kind":12,"line":675},{"containerName":"exons","name":"$match6","line":675,"kind":13},{"kind":13,"line":676,"name":"$self","containerName":"exons"},{"name":"_clone_loc","containerName":"exons","kind":12,"line":676},{"containerName":"exons","name":"$match2","line":676,"kind":13},{"name":"$inex_map","containerName":"exons","kind":13,"line":678},{"kind":12,"line":678,"name":"add_mapper","containerName":"exons"},{"name":"new","containerName":"exons","kind":12,"line":679},{"containerName":"exons","name":"$self","line":679,"kind":13},{"kind":12,"line":679,"containerName":"exons","name":"_clone_loc"},{"name":"$match1","containerName":"exons","kind":13,"line":679},{"containerName":"exons","name":"$match6","line":681,"kind":13},{"line":683,"kind":13,"containerName":"exons","name":"$exon_map"},{"line":683,"kind":12,"containerName":"exons","name":"add_mapper"},{"name":"new","containerName":"exons","kind":12,"line":684},{"name":"$self","containerName":"exons","line":684,"kind":13},{"containerName":"exons","name":"_clone_loc","line":684,"kind":12},{"line":684,"kind":13,"name":"$match1","containerName":"exons"},{"containerName":"exons","name":"$self","kind":13,"line":685},{"line":685,"kind":12,"name":"_clone_loc","containerName":"exons"},{"kind":13,"line":685,"name":"$match6","containerName":"exons"},{"name":"$exon_cds_map","containerName":"exons","line":688,"kind":13},{"kind":12,"line":688,"containerName":"exons","name":"add_mapper"},{"line":689,"kind":12,"containerName":"exons","name":"new"},{"line":689,"kind":13,"containerName":"exons","name":"$self"},{"line":689,"kind":12,"name":"_clone_loc","containerName":"exons"},{"kind":13,"line":689,"name":"$match6","containerName":"exons"},{"name":"$self","containerName":"exons","line":690,"kind":13},{"kind":12,"line":690,"containerName":"exons","name":"_clone_loc"},{"line":690,"kind":13,"name":"$match2","containerName":"exons"},{"kind":13,"line":697,"containerName":"exons","name":"$coffset"},{"localvar":"my","containerName":"exons","name":"$m","definition":"my","line":698,"kind":13},{"containerName":"exons","name":"$cds_map","line":698,"kind":13},{"name":"each_mapper","containerName":"exons","kind":12,"line":698},{"name":"$m","containerName":"exons","kind":13,"line":699},{"kind":12,"line":699,"containerName":"exons","name":"out"},{"name":"start","containerName":"exons","kind":12,"line":699},{"name":"$m","containerName":"exons","line":699,"kind":13},{"name":"out","containerName":"exons","kind":12,"line":699},{"kind":12,"line":699,"name":"start","containerName":"exons"},{"containerName":"exons","name":"$coffset","kind":13,"line":699},{"kind":13,"line":700,"containerName":"exons","name":"$m"},{"kind":12,"line":700,"containerName":"exons","name":"out"},{"kind":12,"line":700,"containerName":"exons","name":"end"},{"containerName":"exons","name":"$m","kind":13,"line":700},{"containerName":"exons","name":"out","line":700,"kind":12},{"containerName":"exons","name":"end","line":700,"kind":12},{"containerName":"exons","name":"$coffset","kind":13,"line":700},{"kind":13,"line":705,"name":"$self","containerName":"exons"},{"name":"$cds_mapper","containerName":"exons","line":705,"kind":13},{"kind":13,"line":705,"name":"$cds_map","containerName":"exons"},{"containerName":"exons","name":"$self","line":706,"kind":13},{"name":"$exon_cds_mapper","containerName":"exons","kind":13,"line":706},{"kind":13,"line":706,"name":"$exon_cds_map","containerName":"exons"},{"name":"$self","containerName":"exons","kind":13,"line":707},{"line":707,"kind":13,"name":"$inex_mapper","containerName":"exons"},{"name":"$inex_map","containerName":"exons","line":707,"kind":13},{"kind":13,"line":708,"name":"$self","containerName":"exons"},{"line":708,"kind":13,"containerName":"exons","name":"$exon_mapper"},{"containerName":"exons","name":"$exon_map","line":708,"kind":13},{"kind":13,"line":709,"containerName":"exons","name":"$self"},{"containerName":"exons","name":"$intron_mapper","line":709,"kind":13},{"containerName":"exons","name":"$intron_map","kind":13,"line":709},{"containerName":"exons","name":"$self","kind":13,"line":710},{"name":"$negative_intron_mapper","containerName":"exons","kind":13,"line":710},{"containerName":"exons","name":"$negative_intron_map","kind":13,"line":710},{"name":"$self","containerName":"exons","kind":13,"line":712}],"kind":12,"detail":"($self,@value)","signature":{"label":"exons($self,@value)","parameters":[{"label":"$self"},{"label":"@value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates"},"containerName":"main::","definition":"sub"},{"line":519,"kind":12,"name":"Bio","containerName":"Location::Simple"},{"kind":12,"line":534,"name":"Bio","containerName":"Location::Simple"},{"containerName":"Coordinate::Collection","name":"Bio","kind":12,"line":571},{"containerName":"Coordinate::Collection","name":"Bio","line":572,"kind":12},{"containerName":"Coordinate::Collection","name":"Bio","line":573,"kind":12},{"name":"Bio","containerName":"Coordinate::Collection","kind":12,"line":574},{"name":"Bio","containerName":"Coordinate::Collection","kind":12,"line":575},{"kind":12,"line":576,"name":"Bio","containerName":"Coordinate::Collection"},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":590},{"containerName":"Location::Simple","name":"Bio","line":597,"kind":12},{"containerName":"Coordinate::Pair","name":"Bio","kind":12,"line":604},{"line":620,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":627},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":635},{"name":"Bio","containerName":"Coordinate::Pair","line":642,"kind":12},{"name":"Bio","containerName":"Coordinate::Pair","line":647,"kind":12},{"kind":12,"line":652,"containerName":"Coordinate::Pair","name":"Bio"},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":665},{"containerName":"Coordinate::Pair","name":"Bio","line":672,"kind":12},{"line":675,"kind":12,"containerName":"Coordinate::Pair","name":"Bio"},{"containerName":"Coordinate::Pair","name":"Bio","line":678,"kind":12},{"containerName":"Coordinate::Pair","name":"Bio","kind":12,"line":683},{"containerName":"Coordinate::Pair","name":"Bio","kind":12,"line":688},{"definition":"sub","containerName":"main::","signature":{"label":"_clone_loc($self,$loc)","documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned","parameters":[{"label":"$self"},{"label":"$loc"}]},"detail":"($self,$loc)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"_clone_loc","localvar":"my","kind":13,"line":727},{"kind":13,"line":727,"containerName":"_clone_loc","name":"$loc"},{"name":"$self","containerName":"_clone_loc","line":729,"kind":13},{"kind":12,"line":729,"name":"throw","containerName":"_clone_loc"},{"kind":13,"line":729,"containerName":"_clone_loc","name":"$loc"},{"line":730,"kind":13,"containerName":"_clone_loc","name":"$loc"},{"name":"isa","containerName":"_clone_loc","line":730,"kind":12},{"line":733,"kind":12,"containerName":"_clone_loc","name":"new"},{"line":733,"kind":13,"containerName":"_clone_loc","name":"$self"},{"containerName":"_clone_loc","name":"verbose","line":733,"kind":12},{"line":734,"kind":13,"containerName":"_clone_loc","name":"$loc"},{"line":734,"kind":12,"containerName":"_clone_loc","name":"seq_id"},{"containerName":"_clone_loc","name":"$loc","line":735,"kind":13},{"name":"start","containerName":"_clone_loc","kind":12,"line":735},{"kind":13,"line":736,"name":"$loc","containerName":"_clone_loc"},{"line":736,"kind":12,"name":"end","containerName":"_clone_loc"},{"containerName":"_clone_loc","name":"$loc","line":737,"kind":13},{"kind":12,"line":737,"name":"strand","containerName":"_clone_loc"},{"line":738,"kind":13,"name":"$loc","containerName":"_clone_loc"},{"containerName":"_clone_loc","name":"location_type","line":739,"kind":12}],"line":726,"name":"_clone_loc","range":{"end":{"character":9999,"line":740},"start":{"character":0,"line":726}}},{"line":732,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"name":"cds","range":{"end":{"character":9999,"line":793},"start":{"character":0,"line":761}},"kind":12,"children":[{"kind":13,"line":762,"containerName":"cds","name":"$self","definition":"my","localvar":"my"},{"containerName":"cds","name":"$value","line":762,"kind":13},{"containerName":"cds","name":"$value","kind":13,"line":763},{"name":"$value","containerName":"cds","kind":13,"line":764},{"line":765,"kind":13,"localvar":"my","containerName":"cds","definition":"my","name":"$loc"},{"line":765,"kind":12,"containerName":"cds","name":"new"},{"name":"$value","containerName":"cds","line":765,"kind":13},{"name":"$value","containerName":"cds","line":765,"kind":13},{"kind":13,"line":766,"containerName":"cds","name":"$self"},{"containerName":"cds","name":"verbose","line":766,"kind":12},{"kind":13,"line":767,"containerName":"cds","name":"$self"},{"name":"$loc","containerName":"cds","kind":13,"line":767},{"name":"$value","containerName":"cds","line":769,"kind":13},{"line":769,"kind":13,"name":"$value","containerName":"cds"},{"containerName":"cds","name":"isa","kind":12,"line":769},{"name":"$self","containerName":"cds","kind":13,"line":770},{"kind":13,"line":770,"containerName":"cds","name":"$value"},{"line":772,"kind":13,"containerName":"cds","name":"$self"},{"line":772,"kind":12,"name":"throw","containerName":"cds"},{"name":"$len","definition":"my","containerName":"cds","localvar":"my","kind":13,"line":775},{"name":"$len","containerName":"cds","kind":13,"line":777},{"kind":13,"line":777,"name":"$self","containerName":"cds"},{"name":"end","containerName":"cds","line":777,"kind":12},{"kind":13,"line":777,"name":"$self","containerName":"cds"},{"line":777,"kind":12,"containerName":"cds","name":"start"},{"name":"$self","containerName":"cds","line":778,"kind":13},{"name":"end","containerName":"cds","kind":12,"line":778},{"kind":13,"line":780,"name":"$a","definition":"my","containerName":"cds","localvar":"my"},{"kind":13,"line":780,"name":"$self","containerName":"cds"},{"containerName":"cds","name":"_create_pair","kind":12,"line":781},{"line":782,"kind":13,"name":"$self","containerName":"cds"},{"line":782,"kind":12,"containerName":"cds","name":"start"},{"name":"$len","containerName":"cds","kind":13,"line":783},{"containerName":"cds","name":"$self","kind":13,"line":784},{"name":"strand","containerName":"cds","line":784,"kind":12},{"line":785,"kind":13,"localvar":"my","definition":"my","name":"$mapper","containerName":"cds"},{"kind":13,"line":785,"containerName":"cds","name":"$COORDINATE_SYSTEMS"},{"kind":13,"line":785,"containerName":"cds","name":"$COORDINATE_SYSTEMS"},{"kind":13,"line":786,"name":"$self","containerName":"cds"},{"line":786,"kind":13,"name":"$mapper","containerName":"cds"},{"kind":13,"line":786,"containerName":"cds","name":"$a"},{"containerName":"cds","name":"$self","line":789,"kind":13},{"containerName":"cds","name":"$self","kind":13,"line":790},{"containerName":"cds","name":"exons","kind":12,"line":790},{"containerName":"cds","name":"$self","kind":13,"line":790}],"line":761,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"cds($self,$value)"},"detail":"($self,$value)"},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":765},{"name":"%self","containerName":null,"kind":13,"line":794},{"kind":12,"children":[{"kind":13,"line":811,"name":"$self","definition":"my","containerName":"map","localvar":"my"},{"name":"$value","containerName":"map","kind":13,"line":811},{"line":812,"kind":13,"localvar":"my","definition":"my","name":"$res","containerName":"map"},{"kind":13,"line":813,"containerName":"map","name":"$self"},{"containerName":"map","name":"throw","line":813,"kind":12},{"line":815,"kind":13,"name":"$value","containerName":"map"},{"line":816,"kind":13,"containerName":"map","name":"$value"},{"kind":13,"line":816,"containerName":"map","name":"$value"},{"containerName":"map","name":"isa","line":816,"kind":12},{"containerName":"map","name":"$value","line":817,"kind":13},{"containerName":"map","name":"isa","line":817,"kind":12},{"kind":13,"line":818,"name":"$value","containerName":"map"},{"name":"isa","containerName":"map","line":818,"kind":12},{"line":819,"kind":13,"containerName":"map","name":"$self"},{"containerName":"map","name":"throw","kind":12,"line":819},{"containerName":"map","name":"$self","kind":13,"line":820},{"name":"$self","containerName":"map","kind":13,"line":821},{"line":821,"kind":12,"name":"throw","containerName":"map"},{"line":822,"kind":13,"containerName":"map","name":"$self"},{"name":"$self","containerName":"map","kind":13,"line":823},{"name":"throw","containerName":"map","kind":12,"line":823},{"name":"$self","containerName":"map","line":825,"kind":13},{"name":"$self","containerName":"map","kind":13,"line":825},{"kind":13,"line":827,"containerName":"map","name":"$self"},{"line":827,"kind":12,"containerName":"map","name":"_check_direction"},{"kind":13,"line":829,"containerName":"map","name":"$value"},{"line":829,"kind":13,"containerName":"map","name":"$value"},{"name":"location","containerName":"map","kind":12,"line":829},{"kind":13,"line":829,"name":"$value","containerName":"map"},{"kind":12,"line":829,"containerName":"map","name":"isa"},{"kind":13,"line":830,"containerName":"map","name":"$self"},{"line":830,"kind":12,"containerName":"map","name":"debug"},{"line":830,"kind":13,"containerName":"map","name":"$value"},{"kind":12,"line":830,"name":"start","containerName":"map"},{"kind":13,"line":831,"containerName":"map","name":"$value"},{"kind":12,"line":831,"name":"end","containerName":"map"},{"containerName":"map","name":"$value","line":831,"kind":13},{"containerName":"map","name":"strand","line":831,"kind":12},{"containerName":"map","name":"$self","line":834,"kind":13},{"containerName":"map","name":"$self","kind":13,"line":835},{"name":"$self","containerName":"map","line":835,"kind":13},{"kind":13,"line":836,"containerName":"map","name":"$value"},{"line":836,"kind":12,"containerName":"map","name":"start"},{"name":"$value","containerName":"map","line":836,"kind":13},{"kind":12,"line":836,"name":"start","containerName":"map"},{"name":"$value","containerName":"map","kind":13,"line":837},{"line":837,"kind":12,"name":"start","containerName":"map"},{"line":837,"kind":13,"name":"$value","containerName":"map"},{"kind":12,"line":837,"name":"start","containerName":"map"},{"kind":13,"line":838,"containerName":"map","name":"$value"},{"kind":12,"line":838,"name":"end","containerName":"map"},{"containerName":"map","name":"$value","kind":13,"line":838},{"line":838,"kind":12,"containerName":"map","name":"end"},{"containerName":"map","name":"$value","kind":13,"line":839},{"line":839,"kind":12,"containerName":"map","name":"end"},{"line":839,"kind":13,"name":"$value","containerName":"map"},{"kind":12,"line":839,"name":"end","containerName":"map"},{"line":842,"kind":13,"localvar":"my","definition":"my","name":"@steps","containerName":"map"},{"kind":13,"line":842,"name":"$self","containerName":"map"},{"line":842,"kind":12,"name":"_get_path","containerName":"map"},{"line":843,"kind":13,"name":"$self","containerName":"map"},{"kind":12,"line":843,"containerName":"map","name":"debug"},{"kind":13,"line":843,"containerName":"map","name":"$self"},{"containerName":"map","name":"$self","kind":13,"line":843},{"line":844,"kind":13,"name":"@steps","containerName":"map"},{"kind":13,"line":846,"definition":"my","name":"$mapper","containerName":"map","localvar":"my"},{"kind":13,"line":846,"containerName":"map","name":"@steps"},{"name":"$mapper","containerName":"map","kind":13,"line":847},{"kind":13,"line":847,"containerName":"map","name":"$TRANSLATION"},{"name":"$self","containerName":"map","line":848,"kind":13},{"kind":12,"line":848,"name":"direction","containerName":"map"},{"kind":13,"line":850,"name":"$value","containerName":"map"},{"name":"$self","containerName":"map","line":850,"kind":13},{"kind":12,"line":850,"name":"_translate","containerName":"map"},{"containerName":"map","name":"$value","line":850,"kind":13},{"kind":13,"line":851,"containerName":"map","name":"$self"},{"containerName":"map","name":"debug","kind":12,"line":851},{"kind":13,"line":853,"containerName":"map","name":"$value"},{"kind":13,"line":853,"name":"$self","containerName":"map"},{"containerName":"map","name":"_reverse_translate","line":853,"kind":12},{"name":"$value","containerName":"map","line":853,"kind":13},{"containerName":"map","name":"$self","line":854,"kind":13},{"line":854,"kind":12,"containerName":"map","name":"debug"},{"name":"$self","containerName":"map","kind":13,"line":859},{"line":859,"kind":13,"name":"$mapper","containerName":"map"},{"line":861,"kind":13,"containerName":"map","name":"$mapper"},{"line":861,"kind":13,"localvar":"my","containerName":"map","name":"$counter","definition":"my"},{"line":862,"kind":13,"containerName":"map","name":"$value"},{"name":"seq_id","containerName":"map","line":862,"kind":12},{"name":"$COORDINATE_INTS","containerName":"map","kind":13,"line":862},{"line":862,"kind":13,"containerName":"map","name":"$counter"},{"name":"$self","containerName":"map","line":863,"kind":13},{"kind":12,"line":863,"name":"debug","containerName":"map"},{"containerName":"map","name":"$value","line":869,"kind":13},{"line":869,"kind":13,"containerName":"map","name":"$self"},{"kind":13,"line":869,"name":"$mapper","containerName":"map"},{"name":"map","containerName":"map","kind":12,"line":869},{"name":"$value","containerName":"map","kind":13,"line":869},{"kind":13,"line":871,"name":"$value","containerName":"map"},{"containerName":"map","name":"purge_gaps","line":872,"kind":12},{"kind":13,"line":872,"containerName":"map","name":"$value"},{"kind":13,"line":872,"containerName":"map","name":"$value"},{"kind":12,"line":872,"containerName":"map","name":"isa"},{"line":873,"kind":13,"containerName":"map","name":"$value"},{"name":"can","containerName":"map","line":873,"kind":12},{"kind":13,"line":875,"name":"$self","containerName":"map"},{"line":875,"kind":12,"containerName":"map","name":"debug"},{"line":875,"kind":13,"containerName":"map","name":"$self"},{"containerName":"map","name":"direction","kind":12,"line":875},{"name":"$value","containerName":"map","line":876,"kind":13},{"kind":12,"line":876,"name":"start","containerName":"map"},{"line":876,"kind":13,"name":"$value","containerName":"map"},{"name":"end","containerName":"map","line":876,"kind":12},{"name":"$value","containerName":"map","kind":13,"line":877},{"kind":13,"line":877,"name":"$self","containerName":"map"},{"containerName":"map","name":"verbose","line":877,"kind":12},{"name":"$value","containerName":"map","line":882,"kind":13},{"kind":13,"line":882,"name":"$self","containerName":"map"},{"containerName":"map","name":"$self","line":883,"kind":13},{"line":883,"kind":13,"containerName":"map","name":"$self"},{"kind":13,"line":885,"containerName":"map","name":"$value"},{"containerName":"map","name":"start","kind":12,"line":885},{"kind":13,"line":885,"containerName":"map","name":"$value"},{"name":"start","containerName":"map","kind":12,"line":885},{"kind":13,"line":886,"containerName":"map","name":"$value"},{"containerName":"map","name":"start","kind":12,"line":886},{"line":886,"kind":13,"containerName":"map","name":"$value"},{"containerName":"map","name":"start","kind":12,"line":886},{"line":887,"kind":13,"containerName":"map","name":"$value"},{"containerName":"map","name":"end","line":887,"kind":12},{"name":"$value","containerName":"map","line":887,"kind":13},{"containerName":"map","name":"end","kind":12,"line":887},{"kind":13,"line":888,"name":"$value","containerName":"map"},{"containerName":"map","name":"end","line":888,"kind":12},{"kind":13,"line":888,"name":"$value","containerName":"map"},{"containerName":"map","name":"end","kind":12,"line":888},{"kind":13,"line":893,"name":"$value","containerName":"map"},{"containerName":"map","name":"$value","kind":13,"line":893},{"line":893,"kind":12,"name":"each_match","containerName":"map"},{"localvar":"my","containerName":"map","name":"$prevloc","definition":"my","line":894,"kind":13},{"line":895,"kind":13,"localvar":"my","containerName":"map","definition":"my","name":"$merging"},{"line":896,"kind":13,"localvar":"my","name":"$newvalue","definition":"my","containerName":"map"},{"containerName":"map","name":"@matches","definition":"my","localvar":"my","kind":13,"line":897},{"kind":13,"line":898,"containerName":"map","definition":"my","name":"$loc","localvar":"my"},{"kind":13,"line":898,"name":"$value","containerName":"map"},{"name":"each_Location","containerName":"map","line":898,"kind":12},{"line":899,"kind":13,"containerName":"map","name":"$prevloc"},{"name":"$prevloc","containerName":"map","line":900,"kind":13},{"containerName":"map","name":"$loc","kind":13,"line":900},{"kind":13,"line":901,"name":"@matches","containerName":"map"},{"containerName":"map","name":"$prevloc","line":901,"kind":13},{"kind":13,"line":904,"containerName":"map","name":"$prevloc"},{"name":"end","containerName":"map","kind":12,"line":904},{"containerName":"map","name":"$loc","kind":13,"line":904},{"containerName":"map","name":"start","line":904,"kind":12},{"containerName":"map","name":"$prevloc","line":905,"kind":13},{"kind":12,"line":905,"name":"seq_id","containerName":"map"},{"line":905,"kind":13,"containerName":"map","name":"$loc"},{"name":"seq_id","containerName":"map","kind":12,"line":905},{"kind":13,"line":906,"name":"$prevloc","containerName":"map"},{"containerName":"map","name":"end","line":906,"kind":12},{"containerName":"map","name":"$loc","line":906,"kind":13},{"containerName":"map","name":"end","line":906,"kind":12},{"kind":13,"line":907,"name":"$merging","containerName":"map"},{"containerName":"map","name":"@matches","kind":13,"line":909},{"name":"$loc","containerName":"map","kind":13,"line":909},{"containerName":"map","name":"$prevloc","kind":13,"line":910},{"kind":13,"line":910,"name":"$loc","containerName":"map"},{"containerName":"map","name":"$merging","kind":13,"line":913},{"line":914,"kind":13,"name":"@matches","containerName":"map"},{"containerName":"map","name":"$newvalue","kind":13,"line":915},{"name":"new","containerName":"map","line":915,"kind":12},{"name":"$newvalue","containerName":"map","kind":13,"line":916},{"name":"add_sub_Location","containerName":"map","line":916,"kind":12},{"line":916,"kind":13,"containerName":"map","name":"@matches"},{"name":"$newvalue","containerName":"map","line":918,"kind":13},{"name":"new","containerName":"map","line":919,"kind":12},{"kind":13,"line":919,"name":"$matches","containerName":"map"},{"kind":12,"line":919,"containerName":"map","name":"seq_id"},{"containerName":"map","name":"$matches","kind":13,"line":920},{"name":"start","containerName":"map","kind":12,"line":920},{"kind":13,"line":921,"name":"$matches","containerName":"map"},{"kind":12,"line":921,"containerName":"map","name":"end"},{"name":"$matches","containerName":"map","line":922,"kind":13},{"kind":12,"line":922,"name":"strand","containerName":"map"},{"name":"$self","containerName":"map","kind":13,"line":923},{"line":923,"kind":12,"name":"verbose","containerName":"map"},{"line":925,"kind":13,"name":"$value","containerName":"map"},{"containerName":"map","name":"$newvalue","line":925,"kind":13},{"line":928,"kind":13,"containerName":"map","name":"$value"},{"kind":13,"line":929,"name":"$value","containerName":"map"},{"line":929,"kind":12,"containerName":"map","name":"each_match"},{"name":"$value","containerName":"map","kind":13,"line":930},{"name":"$value","containerName":"map","line":930,"kind":13},{"kind":12,"line":930,"name":"match","containerName":"map"},{"kind":13,"line":933,"containerName":"map","name":"$value"}],"line":810,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple","label":"map($self,$value)"},"detail":"($self,$value)","name":"map","range":{"end":{"line":934,"character":9999},"start":{"character":0,"line":810}}},{"line":915,"kind":12,"name":"Bio","containerName":"Coordinate::Result"},{"kind":12,"line":918,"containerName":"Coordinate::Result::Match","name":"Bio"},{"kind":12,"line":948,"children":[{"kind":13,"line":949,"containerName":"direction","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":950,"containerName":"direction","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"direction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)"},"name":"direction","range":{"start":{"character":0,"line":948},"end":{"character":9999,"line":951}}},{"range":{"start":{"line":966,"character":0},"end":{"character":9999,"line":970}},"name":"swap","detail":"($self,$value)","signature":{"label":"swap($self,$value)","documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","line":966,"children":[{"kind":13,"line":967,"name":"$self","definition":"my","containerName":"swap","localvar":"my"},{"containerName":"swap","name":"$value","line":967,"kind":13},{"kind":13,"line":969,"name":"$self","containerName":"swap"},{"containerName":"swap","name":"$self","kind":13,"line":969},{"kind":13,"line":969,"containerName":"swap","name":"$self"},{"line":969,"kind":13,"containerName":"swap","name":"$self"},{"line":970,"kind":13,"containerName":"swap","name":"$self"},{"containerName":"swap","name":"swap","line":970,"kind":12},{"containerName":"swap","name":"$self","line":970,"kind":13}],"kind":12},{"line":973,"kind":13,"name":"%self","containerName":null},{"name":"_direction","kind":12,"line":973},{"containerName":"main::","definition":"sub","name":"to_string","range":{"end":{"character":9999,"line":1079},"start":{"line":990,"character":0}},"kind":12,"line":990,"children":[{"containerName":"to_string","name":"$self","definition":"my","localvar":"my","kind":13,"line":991},{"name":"$mapper_str","definition":"my","containerName":"to_string","localvar":"my","kind":13,"line":996},{"containerName":"to_string","name":"$mapper","definition":"my","localvar":"my","kind":13,"line":997},{"name":"$self","containerName":"to_string","line":997,"kind":13},{"kind":12,"line":997,"containerName":"to_string","name":"_mapper_string2code"},{"kind":13,"line":997,"containerName":"to_string","name":"$mapper_str"},{"kind":13,"line":999,"containerName":"to_string","name":"$mapper_str"},{"containerName":"to_string","name":"$mapper","line":999,"kind":13},{"name":"$self","containerName":"to_string","kind":13,"line":1000},{"kind":12,"line":1000,"containerName":"to_string","name":"cds"},{"kind":13,"line":1001,"definition":"my","name":"$end","containerName":"to_string","localvar":"my"},{"line":1001,"kind":13,"name":"$self","containerName":"to_string"},{"kind":12,"line":1001,"name":"cds","containerName":"to_string"},{"line":1001,"kind":12,"containerName":"to_string","name":"end"},{"name":"$self","containerName":"to_string","kind":13,"line":1001},{"name":"cds","containerName":"to_string","kind":12,"line":1001},{"line":1001,"kind":12,"name":"end","containerName":"to_string"},{"kind":13,"line":1002,"name":"$self","containerName":"to_string"},{"line":1002,"kind":12,"containerName":"to_string","name":"cds"},{"line":1002,"kind":12,"name":"start","containerName":"to_string"},{"kind":13,"line":1002,"name":"$end","containerName":"to_string"},{"containerName":"to_string","name":"$self","kind":13,"line":1003},{"name":"cds","containerName":"to_string","kind":12,"line":1003},{"line":1003,"kind":12,"containerName":"to_string","name":"strand"},{"name":"$mapper_str","containerName":"to_string","line":1007,"kind":13},{"kind":13,"line":1008,"containerName":"to_string","name":"$mapper"},{"name":"$self","containerName":"to_string","line":1008,"kind":13},{"name":"_mapper_string2code","containerName":"to_string","line":1008,"kind":12},{"containerName":"to_string","name":"$mapper_str","kind":13,"line":1008},{"line":1009,"kind":13,"containerName":"to_string","name":"$mapper_str"},{"kind":13,"line":1009,"containerName":"to_string","name":"$mapper"},{"kind":13,"line":1011,"definition":"my","name":"$i","containerName":"to_string","localvar":"my"},{"kind":13,"line":1012,"containerName":"to_string","definition":"my","name":"$pair","localvar":"my"},{"name":"$self","containerName":"to_string","line":1012,"kind":13},{"containerName":"to_string","name":"$mapper","kind":13,"line":1012},{"line":1012,"kind":12,"name":"each_mapper","containerName":"to_string"},{"containerName":"to_string","name":"$i","kind":13,"line":1013},{"containerName":"to_string","name":"$pair","line":1013,"kind":13},{"name":"in","containerName":"to_string","kind":12,"line":1013},{"line":1013,"kind":12,"containerName":"to_string","name":"start"},{"name":"$pair","containerName":"to_string","line":1013,"kind":13},{"name":"out","containerName":"to_string","kind":12,"line":1013},{"name":"start","containerName":"to_string","kind":12,"line":1013},{"kind":13,"line":1014,"name":"$pair","containerName":"to_string"},{"line":1014,"kind":12,"name":"in","containerName":"to_string"},{"name":"end","containerName":"to_string","kind":12,"line":1014},{"containerName":"to_string","name":"$pair","kind":13,"line":1014},{"line":1014,"kind":12,"containerName":"to_string","name":"out"},{"kind":12,"line":1014,"name":"end","containerName":"to_string"},{"kind":13,"line":1015,"name":"$i","containerName":"to_string"},{"kind":13,"line":1019,"name":"$mapper_str","containerName":"to_string"},{"name":"$mapper","containerName":"to_string","kind":13,"line":1020},{"containerName":"to_string","name":"$self","line":1020,"kind":13},{"name":"_mapper_string2code","containerName":"to_string","kind":12,"line":1020},{"name":"$mapper_str","containerName":"to_string","line":1020,"kind":13},{"kind":13,"line":1021,"containerName":"to_string","name":"$mapper_str"},{"line":1021,"kind":13,"name":"$mapper","containerName":"to_string"},{"line":1023,"kind":13,"name":"$i","containerName":"to_string"},{"kind":13,"line":1024,"containerName":"to_string","name":"$pair","definition":"my","localvar":"my"},{"line":1024,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"$mapper","line":1024,"kind":13},{"kind":12,"line":1024,"containerName":"to_string","name":"each_mapper"},{"line":1025,"kind":13,"containerName":"to_string","name":"$i"},{"line":1025,"kind":13,"containerName":"to_string","name":"$pair"},{"name":"in","containerName":"to_string","kind":12,"line":1025},{"containerName":"to_string","name":"start","line":1025,"kind":12},{"name":"$pair","containerName":"to_string","kind":13,"line":1025},{"name":"out","containerName":"to_string","kind":12,"line":1025},{"containerName":"to_string","name":"start","line":1025,"kind":12},{"kind":13,"line":1026,"name":"$pair","containerName":"to_string"},{"name":"in","containerName":"to_string","kind":12,"line":1026},{"line":1026,"kind":12,"name":"end","containerName":"to_string"},{"kind":13,"line":1026,"containerName":"to_string","name":"$pair"},{"name":"out","containerName":"to_string","kind":12,"line":1026},{"containerName":"to_string","name":"end","kind":12,"line":1026},{"line":1027,"kind":13,"containerName":"to_string","name":"$i"},{"name":"$mapper_str","containerName":"to_string","line":1032,"kind":13},{"name":"$mapper","containerName":"to_string","line":1033,"kind":13},{"line":1033,"kind":13,"containerName":"to_string","name":"$self"},{"containerName":"to_string","name":"_mapper_string2code","kind":12,"line":1033},{"kind":13,"line":1033,"name":"$mapper_str","containerName":"to_string"},{"containerName":"to_string","name":"$mapper_str","line":1034,"kind":13},{"containerName":"to_string","name":"$mapper","kind":13,"line":1034},{"name":"$i","containerName":"to_string","kind":13,"line":1036},{"kind":13,"line":1037,"name":"$pair","definition":"my","containerName":"to_string","localvar":"my"},{"name":"$self","containerName":"to_string","line":1037,"kind":13},{"kind":13,"line":1037,"containerName":"to_string","name":"$mapper"},{"kind":12,"line":1037,"name":"each_mapper","containerName":"to_string"},{"kind":13,"line":1038,"name":"$i","containerName":"to_string"},{"line":1038,"kind":13,"name":"$pair","containerName":"to_string"},{"kind":12,"line":1038,"containerName":"to_string","name":"in"},{"kind":12,"line":1038,"containerName":"to_string","name":"start"},{"line":1038,"kind":13,"containerName":"to_string","name":"$pair"},{"containerName":"to_string","name":"out","line":1038,"kind":12},{"containerName":"to_string","name":"start","kind":12,"line":1038},{"line":1039,"kind":13,"name":"$pair","containerName":"to_string"},{"kind":12,"line":1039,"containerName":"to_string","name":"in"},{"line":1039,"kind":12,"name":"end","containerName":"to_string"},{"kind":13,"line":1039,"containerName":"to_string","name":"$pair"},{"containerName":"to_string","name":"out","line":1039,"kind":12},{"containerName":"to_string","name":"end","line":1039,"kind":12},{"line":1040,"kind":13,"name":"$i","containerName":"to_string"},{"containerName":"to_string","name":"$mapper_str","kind":13,"line":1045},{"line":1046,"kind":13,"containerName":"to_string","name":"$mapper"},{"name":"$self","containerName":"to_string","kind":13,"line":1046},{"name":"_mapper_string2code","containerName":"to_string","kind":12,"line":1046},{"name":"$mapper_str","containerName":"to_string","kind":13,"line":1046},{"line":1047,"kind":13,"name":"$mapper_str","containerName":"to_string"},{"containerName":"to_string","name":"$mapper","line":1047,"kind":13},{"line":1049,"kind":13,"name":"$i","containerName":"to_string"},{"name":"$pair","definition":"my","containerName":"to_string","localvar":"my","kind":13,"line":1050},{"containerName":"to_string","name":"$self","kind":13,"line":1050},{"containerName":"to_string","name":"$mapper","kind":13,"line":1050},{"line":1050,"kind":12,"name":"each_mapper","containerName":"to_string"},{"containerName":"to_string","name":"$i","kind":13,"line":1051},{"containerName":"to_string","name":"$pair","kind":13,"line":1051},{"containerName":"to_string","name":"in","line":1051,"kind":12},{"kind":12,"line":1051,"containerName":"to_string","name":"start"},{"name":"$pair","containerName":"to_string","line":1051,"kind":13},{"kind":12,"line":1051,"containerName":"to_string","name":"out"},{"line":1051,"kind":12,"name":"start","containerName":"to_string"},{"containerName":"to_string","name":"$pair","kind":13,"line":1052},{"name":"in","containerName":"to_string","line":1052,"kind":12},{"containerName":"to_string","name":"end","kind":12,"line":1052},{"line":1052,"kind":13,"containerName":"to_string","name":"$pair"},{"kind":12,"line":1052,"name":"out","containerName":"to_string"},{"line":1052,"kind":12,"containerName":"to_string","name":"end"},{"kind":13,"line":1053,"name":"$i","containerName":"to_string"},{"kind":13,"line":1057,"name":"$mapper_str","containerName":"to_string"},{"name":"$mapper","containerName":"to_string","line":1058,"kind":13},{"name":"$self","containerName":"to_string","kind":13,"line":1058},{"line":1058,"kind":12,"containerName":"to_string","name":"_mapper_string2code"},{"line":1058,"kind":13,"containerName":"to_string","name":"$mapper_str"},{"containerName":"to_string","name":"$mapper_str","line":1059,"kind":13},{"name":"$mapper","containerName":"to_string","line":1059,"kind":13},{"name":"$mapper_str","containerName":"to_string","kind":13,"line":1064},{"kind":13,"line":1065,"containerName":"to_string","name":"$mapper"},{"kind":13,"line":1065,"name":"$self","containerName":"to_string"},{"kind":12,"line":1065,"name":"_mapper_string2code","containerName":"to_string"},{"kind":13,"line":1065,"name":"$mapper_str","containerName":"to_string"},{"name":"$mapper_str","containerName":"to_string","kind":13,"line":1066},{"line":1066,"kind":13,"name":"$mapper","containerName":"to_string"},{"kind":13,"line":1067,"containerName":"to_string","name":"$self"},{"name":"peptide_offset","containerName":"to_string","kind":12,"line":1067},{"kind":13,"line":1071,"name":"$self","containerName":"to_string"},{"name":"in","containerName":"to_string","line":1071,"kind":12},{"line":1072,"kind":13,"containerName":"to_string","name":"$self"},{"kind":12,"line":1072,"name":"out","containerName":"to_string"},{"line":1073,"kind":13,"localvar":"my","containerName":"to_string","definition":"my","name":"$dir"},{"line":1074,"kind":13,"containerName":"to_string","name":"$self"},{"name":"direction","containerName":"to_string","kind":12,"line":1074},{"containerName":"to_string","name":"$dir","kind":13,"line":1074},{"line":1074,"kind":13,"containerName":"to_string","name":"$dir"},{"containerName":"to_string","name":"$dir","line":1075,"kind":13},{"kind":13,"line":1075,"name":"$self","containerName":"to_string"},{"name":"direction","containerName":"to_string","kind":12,"line":1075}]},{"range":{"start":{"line":1081,"character":0},"end":{"line":1086,"character":9999}},"name":"_mapper_code2string","detail":"($self,$code)","signature":{"label":"_mapper_code2string($self,$code)","parameters":[{"label":"$self"},{"label":"$code"}],"documentation":""},"containerName":"main::","definition":"sub","line":1081,"children":[{"kind":13,"line":1082,"name":"$self","definition":"my","containerName":"_mapper_code2string","localvar":"my"},{"name":"$code","containerName":"_mapper_code2string","line":1082,"kind":13},{"containerName":"_mapper_code2string","definition":"my","name":"$a","localvar":"my","kind":13,"line":1083},{"line":1083,"kind":13,"name":"$b","containerName":"_mapper_code2string"},{"line":1083,"kind":13,"name":"$code","containerName":"_mapper_code2string"},{"name":"$COORDINATE_INTS","containerName":"_mapper_code2string","line":1084,"kind":13},{"line":1084,"kind":13,"containerName":"_mapper_code2string","name":"$a"},{"line":1084,"kind":13,"containerName":"_mapper_code2string","name":"$COORDINATE_INTS"},{"kind":13,"line":1084,"name":"$b","containerName":"_mapper_code2string"}],"kind":12},{"name":"_mapper_string2code","range":{"end":{"line":1092,"character":9999},"start":{"character":0,"line":1088}},"kind":12,"line":1088,"children":[{"localvar":"my","containerName":"_mapper_string2code","definition":"my","name":"$self","line":1089,"kind":13},{"line":1089,"kind":13,"name":"$string","containerName":"_mapper_string2code"},{"localvar":"my","containerName":"_mapper_string2code","definition":"my","name":"$a","line":1090,"kind":13},{"line":1090,"kind":13,"name":"$b","containerName":"_mapper_string2code"},{"line":1090,"kind":13,"containerName":"_mapper_string2code","name":"$string"},{"kind":13,"line":1091,"containerName":"_mapper_string2code","name":"$COORDINATE_SYSTEMS"},{"containerName":"_mapper_string2code","name":"$a","kind":13,"line":1091},{"line":1091,"kind":13,"containerName":"_mapper_string2code","name":"$COORDINATE_SYSTEMS"},{"name":"$b","containerName":"_mapper_string2code","line":1091,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$string)","signature":{"parameters":[{"label":"$self"},{"label":"$string"}],"documentation":"","label":"_mapper_string2code($self,$string)"}},{"name":"_create_pair","range":{"end":{"line":1140,"character":9999},"start":{"line":1111,"character":0}},"kind":12,"line":1111,"children":[{"name":"$self","definition":"my","containerName":"_create_pair","localvar":"my","kind":13,"line":1112},{"name":"$in","containerName":"_create_pair","line":1112,"kind":13},{"containerName":"_create_pair","name":"$out","kind":13,"line":1112},{"line":1112,"kind":13,"containerName":"_create_pair","name":"$strict"},{"name":"$offset","containerName":"_create_pair","kind":13,"line":1112},{"line":1112,"kind":13,"name":"$length","containerName":"_create_pair"},{"kind":13,"line":1112,"containerName":"_create_pair","name":"$strand"},{"containerName":"_create_pair","name":"$strict","kind":13,"line":1113},{"name":"$strand","containerName":"_create_pair","line":1114,"kind":13},{"line":1115,"kind":13,"containerName":"_create_pair","name":"$length"},{"kind":13,"line":1117,"definition":"my","name":"$match1","containerName":"_create_pair","localvar":"my"},{"name":"new","containerName":"_create_pair","line":1118,"kind":12},{"kind":13,"line":1118,"name":"$in","containerName":"_create_pair"},{"line":1119,"kind":13,"containerName":"_create_pair","name":"$offset"},{"kind":13,"line":1120,"containerName":"_create_pair","name":"$offset"},{"containerName":"_create_pair","name":"$length","kind":13,"line":1120},{"kind":13,"line":1122,"containerName":"_create_pair","name":"$self"},{"line":1122,"kind":12,"name":"verbose","containerName":"_create_pair"},{"kind":13,"line":1124,"name":"$match2","definition":"my","containerName":"_create_pair","localvar":"my"},{"containerName":"_create_pair","name":"new","line":1125,"kind":12},{"name":"$out","containerName":"_create_pair","line":1125,"kind":13},{"line":1127,"kind":13,"containerName":"_create_pair","name":"$length"},{"name":"$strand","containerName":"_create_pair","line":1128,"kind":13},{"kind":13,"line":1129,"containerName":"_create_pair","name":"$self"},{"kind":12,"line":1129,"name":"verbose","containerName":"_create_pair"},{"line":1131,"kind":13,"localvar":"my","definition":"my","name":"$pair","containerName":"_create_pair"},{"line":1132,"kind":12,"containerName":"_create_pair","name":"new"},{"kind":13,"line":1132,"name":"$match1","containerName":"_create_pair"},{"name":"$match2","containerName":"_create_pair","line":1133,"kind":13},{"containerName":"_create_pair","name":"$strict","line":1134,"kind":13},{"kind":13,"line":1135,"name":"$self","containerName":"_create_pair"},{"kind":12,"line":1135,"containerName":"_create_pair","name":"verbose"},{"line":1138,"kind":13,"name":"$pair","containerName":"_create_pair"}],"containerName":"main::","definition":"sub","detail":"($self,$in,$out,$strict,$offset,$length,$strand)","signature":{"label":"_create_pair($self,$in,$out,$strict,$offset,$length,$strand)","documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand","parameters":[{"label":"$self"},{"label":"$in"},{"label":"$out"},{"label":"$strict"},{"label":"$offset"},{"label":"$length"},{"label":"$strand"}]}},{"line":1117,"kind":12,"containerName":"Location::Simple","name":"Bio"},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":1124},{"name":"Bio","containerName":"Coordinate::ExtrapolatingPair","kind":12,"line":1131},{"range":{"end":{"line":1187,"character":9999},"start":{"character":0,"line":1155}},"name":"_translate","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand\n\n\nsub _create_pair {\n   my ($self, $in, $out, $strict, $offset, $length, $strand ) = @_;\n   $strict ||= 0;\n   $strand ||= 1;\n   $length ||= 20;\n\n   my $match1 = Bio::Location::Simple->new\n       (-seq_id  => $in,\n\t-start   => $offset+1,\n\t-end     => $offset+$length, \n\t-strand  => 1,\n\t-verbose => $self->verbose);\n\n   my $match2 = Bio::Location::Simple->new\n       (-seq_id  => $out,\n\t-start   => 1,\n\t-end     => $length, \n\t-strand  => $strand,\n\t-verbose => $self->verbose);\n\n   my $pair = Bio::Coordinate::ExtrapolatingPair->new\n       (-in      => $match1,\n        -out     => $match2,\n        -strict  => $strict,\n\t-verbose => $self->verbose,\n       );\n\n   return $pair;\n\n}\n\n\n=head2 _translate\n\n Title   : _translate\n Usage   : $newpos = $obj->_translate($loc);\n Function: Translate the location from the CDS coordinate system\n           to a new value in the propeptide coordinate system.\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI","label":"_translate($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":1156,"name":"$self","definition":"my","containerName":"_translate","localvar":"my"},{"line":1156,"kind":13,"containerName":"_translate","name":"$value"},{"name":"$self","containerName":"_translate","line":1158,"kind":13},{"line":1158,"kind":12,"name":"throw","containerName":"_translate"},{"name":"$value","containerName":"_translate","kind":13,"line":1159},{"containerName":"_translate","name":"$value","line":1160,"kind":13},{"containerName":"_translate","name":"$value","line":1161,"kind":13},{"containerName":"_translate","name":"isa","kind":12,"line":1161},{"containerName":"_translate","name":"$value","kind":13,"line":1161},{"containerName":"_translate","name":"isa","kind":12,"line":1161},{"localvar":"my","containerName":"_translate","definition":"my","name":"$seqid","line":1163,"kind":13},{"line":1165,"kind":13,"name":"$value","containerName":"_translate"},{"containerName":"_translate","name":"isa","line":1165,"kind":12},{"name":"$split","definition":"my","containerName":"_translate","localvar":"my","kind":13,"line":1166},{"line":1166,"kind":12,"containerName":"_translate","name":"new"},{"line":1166,"kind":13,"name":"$seqid","containerName":"_translate"},{"containerName":"_translate","definition":"my","name":"$loc","localvar":"my","kind":13,"line":1167},{"name":"$value","containerName":"_translate","kind":13,"line":1167},{"containerName":"_translate","name":"each_Location","line":1167,"kind":12},{"containerName":"_translate","definition":"my","name":"$match","localvar":"my","kind":13,"line":1168},{"name":"new","containerName":"_translate","kind":12,"line":1169},{"name":"$loc","containerName":"_translate","line":1169,"kind":13},{"kind":12,"line":1169,"containerName":"_translate","name":"start"},{"line":1170,"kind":13,"containerName":"_translate","name":"$loc"},{"name":"end","containerName":"_translate","kind":12,"line":1170},{"kind":13,"line":1171,"containerName":"_translate","name":"$seqid"},{"kind":13,"line":1173,"containerName":"_translate","name":"$self"},{"name":"verbose","containerName":"_translate","line":1173,"kind":12},{"name":"$split","containerName":"_translate","line":1175,"kind":13},{"containerName":"_translate","name":"add_sub_Location","line":1175,"kind":12},{"line":1175,"kind":13,"containerName":"_translate","name":"$match"},{"kind":13,"line":1177,"name":"$split","containerName":"_translate"},{"name":"$value","containerName":"_translate","line":1180,"kind":13},{"containerName":"_translate","name":"start","kind":12,"line":1180},{"kind":13,"line":1181,"containerName":"_translate","name":"$value"},{"name":"end","containerName":"_translate","kind":12,"line":1181},{"name":"$seqid","containerName":"_translate","kind":13,"line":1182},{"line":1184,"kind":13,"containerName":"_translate","name":"$self"},{"kind":12,"line":1184,"containerName":"_translate","name":"verbose"}],"line":1155,"kind":12},{"containerName":"Location::Split","name":"Bio","line":1166,"kind":12},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":1168},{"kind":12,"line":1180,"name":"Bio","containerName":"Location::Simple"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"_frame($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"_frame","localvar":"my","kind":13,"line":1190},{"containerName":"_frame","name":"$value","kind":13,"line":1190},{"name":"$self","containerName":"_frame","line":1192,"kind":13},{"containerName":"_frame","name":"throw","line":1192,"kind":12},{"name":"$value","containerName":"_frame","kind":13,"line":1193},{"name":"$value","containerName":"_frame","line":1194,"kind":13},{"name":"$value","containerName":"_frame","line":1195,"kind":13},{"containerName":"_frame","name":"isa","line":1195,"kind":12},{"kind":13,"line":1195,"name":"$value","containerName":"_frame"},{"kind":12,"line":1195,"containerName":"_frame","name":"isa"},{"localvar":"my","containerName":"_frame","name":"$seqid","definition":"my","line":1197,"kind":13},{"kind":13,"line":1199,"name":"$value","containerName":"_frame"},{"name":"isa","containerName":"_frame","kind":12,"line":1199},{"name":"$split","definition":"my","containerName":"_frame","localvar":"my","kind":13,"line":1200},{"name":"new","containerName":"_frame","kind":12,"line":1200},{"kind":13,"line":1200,"name":"$seqid","containerName":"_frame"},{"kind":13,"line":1201,"containerName":"_frame","name":"$loc","definition":"my","localvar":"my"},{"name":"$value","containerName":"_frame","line":1201,"kind":13},{"kind":12,"line":1201,"containerName":"_frame","name":"each_Location"},{"name":"$match","definition":"my","containerName":"_frame","localvar":"my","kind":13,"line":1203},{"line":1204,"kind":12,"name":"new","containerName":"_frame"},{"name":"$value","containerName":"_frame","kind":13,"line":1204},{"name":"start","containerName":"_frame","line":1204,"kind":12},{"kind":13,"line":1205,"containerName":"_frame","name":"$value"},{"line":1205,"kind":12,"containerName":"_frame","name":"end"},{"kind":13,"line":1208,"containerName":"_frame","name":"$self"},{"name":"verbose","containerName":"_frame","line":1208,"kind":12},{"name":"$split","containerName":"_frame","kind":13,"line":1209},{"containerName":"_frame","name":"add_sub_Location","line":1209,"kind":12},{"containerName":"_frame","name":"$match","kind":13,"line":1209},{"name":"$split","containerName":"_frame","line":1211,"kind":13},{"kind":13,"line":1213,"name":"$value","containerName":"_frame"},{"line":1213,"kind":12,"containerName":"_frame","name":"start"},{"name":"$value","containerName":"_frame","line":1214,"kind":13},{"name":"end","containerName":"_frame","line":1214,"kind":12},{"containerName":"_frame","name":"$self","line":1217,"kind":13},{"kind":12,"line":1217,"containerName":"_frame","name":"verbose"}],"line":1189,"name":"_frame","range":{"start":{"character":0,"line":1189},"end":{"line":1220,"character":9999}}},{"name":"Bio","containerName":"Location::Split","kind":12,"line":1200},{"kind":12,"line":1203,"name":"Bio","containerName":"Location::Simple"},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":1213},{"range":{"end":{"line":1271,"character":9999},"start":{"character":0,"line":1237}},"name":"_reverse_translate","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand\n\n\nsub _create_pair {\n   my ($self, $in, $out, $strict, $offset, $length, $strand ) = @_;\n   $strict ||= 0;\n   $strand ||= 1;\n   $length ||= 20;\n\n   my $match1 = Bio::Location::Simple->new\n       (-seq_id  => $in,\n\t-start   => $offset+1,\n\t-end     => $offset+$length, \n\t-strand  => 1,\n\t-verbose => $self->verbose);\n\n   my $match2 = Bio::Location::Simple->new\n       (-seq_id  => $out,\n\t-start   => 1,\n\t-end     => $length, \n\t-strand  => $strand,\n\t-verbose => $self->verbose);\n\n   my $pair = Bio::Coordinate::ExtrapolatingPair->new\n       (-in      => $match1,\n        -out     => $match2,\n        -strict  => $strict,\n\t-verbose => $self->verbose,\n       );\n\n   return $pair;\n\n}\n\n\n=head2 _translate\n\n Title   : _translate\n Usage   : $newpos = $obj->_translate($loc);\n Function: Translate the location from the CDS coordinate system\n           to a new value in the propeptide coordinate system.\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _translate {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n   \n   if ($value->isa(\"Bio::Location::SplitLocationI\") ) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n           my $match = Bio::Location::Simple->new\n\t       (-start   => int ($loc->start / 3 ) +1,\n\t\t-end     => int ($loc->end / 3 ) +1,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start  => int($value->start / 3 )+1,\n                                        -end    => int($value->end / 3 )+1,\n                                        -seq_id => $seqid,\n                                        -strand => 1,\n\t\t\t\t\t-verbose=> $self->verbose,\n                                       );\n   }\n}\n\nsub _frame {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start  => ($value->start-1) % 3 +1,\n\t\t-end    => ($value->end-1) % 3 +1,\n\t\t-seq_id => 'frame',\n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n   } else {\n       return new Bio::Location::Simple(-start   => ($value->start-1) % 3 +1,\n                                        -end     => ($value->end-1) % 3 +1,\n                                        -seq_id  => 'frame',\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n\t\t\t\t\t);\n   }\n}\n\n\n=head2 _reverse_translate\n\n Title   : _reverse_translate\n Usage   : $newpos = $obj->_reverse_translate(5);\n Function: Reverse translate the location from the propeptide\n           coordinate system to a new value in the CSD.\n           Note that a single peptide location expands to cover\n           the codon triplet\n Example :\n Returns : new location in the CDS coordinate system\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI","label":"_reverse_translate($self,$value)"},"containerName":"main::","definition":"sub","line":1237,"children":[{"kind":13,"line":1238,"name":"$self","definition":"my","containerName":"_reverse_translate","localvar":"my"},{"name":"$value","containerName":"_reverse_translate","line":1238,"kind":13},{"line":1241,"kind":13,"name":"$self","containerName":"_reverse_translate"},{"line":1241,"kind":12,"containerName":"_reverse_translate","name":"throw"},{"line":1242,"kind":13,"name":"$value","containerName":"_reverse_translate"},{"kind":13,"line":1243,"containerName":"_reverse_translate","name":"$value"},{"kind":13,"line":1244,"name":"$value","containerName":"_reverse_translate"},{"kind":12,"line":1244,"containerName":"_reverse_translate","name":"isa"},{"name":"$value","containerName":"_reverse_translate","line":1244,"kind":13},{"containerName":"_reverse_translate","name":"isa","line":1244,"kind":12},{"kind":13,"line":1246,"name":"$seqid","definition":"my","containerName":"_reverse_translate","localvar":"my"},{"kind":13,"line":1248,"name":"$value","containerName":"_reverse_translate"},{"kind":12,"line":1248,"name":"isa","containerName":"_reverse_translate"},{"line":1249,"kind":13,"localvar":"my","definition":"my","name":"$split","containerName":"_reverse_translate"},{"name":"new","containerName":"_reverse_translate","kind":12,"line":1249},{"name":"$seqid","containerName":"_reverse_translate","line":1249,"kind":13},{"localvar":"my","name":"$loc","definition":"my","containerName":"_reverse_translate","line":1250,"kind":13},{"kind":13,"line":1250,"name":"$value","containerName":"_reverse_translate"},{"kind":12,"line":1250,"name":"each_Location","containerName":"_reverse_translate"},{"localvar":"my","definition":"my","name":"$match","containerName":"_reverse_translate","line":1252,"kind":13},{"containerName":"_reverse_translate","name":"new","line":1253,"kind":12},{"name":"$value","containerName":"_reverse_translate","kind":13,"line":1253},{"line":1253,"kind":12,"containerName":"_reverse_translate","name":"start"},{"kind":13,"line":1254,"containerName":"_reverse_translate","name":"$value"},{"name":"end","containerName":"_reverse_translate","kind":12,"line":1254},{"name":"$seqid","containerName":"_reverse_translate","kind":13,"line":1255},{"kind":13,"line":1257,"name":"$self","containerName":"_reverse_translate"},{"containerName":"_reverse_translate","name":"verbose","kind":12,"line":1257},{"containerName":"_reverse_translate","name":"$split","kind":13,"line":1259},{"kind":12,"line":1259,"containerName":"_reverse_translate","name":"add_sub_Location"},{"containerName":"_reverse_translate","name":"$match","line":1259,"kind":13},{"line":1261,"kind":13,"containerName":"_reverse_translate","name":"$split"},{"name":"$value","containerName":"_reverse_translate","line":1264,"kind":13},{"line":1264,"kind":12,"name":"start","containerName":"_reverse_translate"},{"name":"$value","containerName":"_reverse_translate","kind":13,"line":1265},{"containerName":"_reverse_translate","name":"end","line":1265,"kind":12},{"containerName":"_reverse_translate","name":"$seqid","kind":13,"line":1266},{"line":1268,"kind":13,"name":"$self","containerName":"_reverse_translate"},{"name":"verbose","containerName":"_reverse_translate","line":1268,"kind":12}],"kind":12},{"containerName":"Location::Split","name":"Bio","line":1249,"kind":12},{"line":1252,"kind":12,"name":"Bio","containerName":"Location::Simple"},{"containerName":"Location::Simple","name":"Bio","kind":12,"line":1264},{"range":{"start":{"character":0,"line":1286},"end":{"line":1296,"character":9999}},"name":"_check_direction","line":1286,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"_check_direction","line":1287,"kind":13},{"containerName":"_check_direction","definition":"my","name":"$new_direction","localvar":"my","kind":13,"line":1289},{"line":1290,"kind":13,"containerName":"_check_direction","name":"$new_direction"},{"line":1290,"kind":13,"containerName":"_check_direction","name":"$self"},{"name":"$self","containerName":"_check_direction","line":1290,"kind":13},{"name":"$new_direction","containerName":"_check_direction","line":1292,"kind":13},{"kind":13,"line":1292,"containerName":"_check_direction","name":"$self"},{"name":"$self","containerName":"_check_direction","line":1293,"kind":13},{"name":"swap","containerName":"_check_direction","line":1293,"kind":12},{"kind":13,"line":1293,"name":"$self","containerName":"_check_direction"},{"kind":13,"line":1295,"name":"$self","containerName":"_check_direction"}],"kind":12,"detail":"($self)","signature":{"label":"_check_direction($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand\n\n\nsub _create_pair {\n   my ($self, $in, $out, $strict, $offset, $length, $strand ) = @_;\n   $strict ||= 0;\n   $strand ||= 1;\n   $length ||= 20;\n\n   my $match1 = Bio::Location::Simple->new\n       (-seq_id  => $in,\n\t-start   => $offset+1,\n\t-end     => $offset+$length, \n\t-strand  => 1,\n\t-verbose => $self->verbose);\n\n   my $match2 = Bio::Location::Simple->new\n       (-seq_id  => $out,\n\t-start   => 1,\n\t-end     => $length, \n\t-strand  => $strand,\n\t-verbose => $self->verbose);\n\n   my $pair = Bio::Coordinate::ExtrapolatingPair->new\n       (-in      => $match1,\n        -out     => $match2,\n        -strict  => $strict,\n\t-verbose => $self->verbose,\n       );\n\n   return $pair;\n\n}\n\n\n=head2 _translate\n\n Title   : _translate\n Usage   : $newpos = $obj->_translate($loc);\n Function: Translate the location from the CDS coordinate system\n           to a new value in the propeptide coordinate system.\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _translate {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n   \n   if ($value->isa(\"Bio::Location::SplitLocationI\") ) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n           my $match = Bio::Location::Simple->new\n\t       (-start   => int ($loc->start / 3 ) +1,\n\t\t-end     => int ($loc->end / 3 ) +1,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start  => int($value->start / 3 )+1,\n                                        -end    => int($value->end / 3 )+1,\n                                        -seq_id => $seqid,\n                                        -strand => 1,\n\t\t\t\t\t-verbose=> $self->verbose,\n                                       );\n   }\n}\n\nsub _frame {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start  => ($value->start-1) % 3 +1,\n\t\t-end    => ($value->end-1) % 3 +1,\n\t\t-seq_id => 'frame',\n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n   } else {\n       return new Bio::Location::Simple(-start   => ($value->start-1) % 3 +1,\n                                        -end     => ($value->end-1) % 3 +1,\n                                        -seq_id  => 'frame',\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n\t\t\t\t\t);\n   }\n}\n\n\n=head2 _reverse_translate\n\n Title   : _reverse_translate\n Usage   : $newpos = $obj->_reverse_translate(5);\n Function: Reverse translate the location from the propeptide\n           coordinate system to a new value in the CSD.\n           Note that a single peptide location expands to cover\n           the codon triplet\n Example :\n Returns : new location in the CDS coordinate system\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _reverse_translate {\n   my ($self,$value) = @_;\n\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'cds';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start   => $value->start * 3 - 2,\n\t\t-end     => $value->end * 3,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start   => $value->start * 3 - 2,\n                                        -end     => $value->end * 3,\n                                        -seq_id  => $seqid,\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n                                       );\n   }\n}\n\n\n=head2 _check_direction\n\n Title   : _check_direction\n Usage   : $obj->_check_direction();\n Function: Check and swap when needed the direction the location\n           mapping Pairs based on input and output values\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple"},"containerName":"main::","definition":"sub"},{"name":"_direction","kind":12,"line":1292},{"kind":12,"line":1295,"name":"_direction"},{"line":1315,"children":[{"kind":13,"line":1316,"containerName":"_get_path","definition":"my","name":"$self","localvar":"my"},{"containerName":"_get_path","definition":"my","name":"$start","localvar":"my","kind":13,"line":1318},{"line":1318,"kind":13,"name":"$self","containerName":"_get_path"},{"kind":13,"line":1319,"definition":"my","name":"$end","containerName":"_get_path","localvar":"my"},{"line":1319,"kind":13,"name":"$self","containerName":"_get_path"},{"localvar":"my","definition":"my","name":"$reverse","containerName":"_get_path","line":1323,"kind":13},{"name":"$start","containerName":"_get_path","kind":13,"line":1324},{"containerName":"_get_path","name":"$end","kind":13,"line":1324},{"containerName":"_get_path","name":"$start","line":1325,"kind":13},{"name":"$end","containerName":"_get_path","line":1325,"kind":13},{"containerName":"_get_path","name":"$end","kind":13,"line":1325},{"kind":13,"line":1325,"name":"$start","containerName":"_get_path"},{"line":1326,"kind":13,"name":"$reverse","containerName":"_get_path"},{"name":"@mappers","definition":"my","containerName":"_get_path","localvar":"my","kind":13,"line":1329},{"kind":13,"line":1330,"containerName":"_get_path","name":"$self"},{"line":1331,"kind":13,"containerName":"_get_path","name":"$self"},{"kind":13,"line":1333,"name":"@mappers","containerName":"_get_path"},{"containerName":"_get_path","name":"$self","line":1333,"kind":13}],"kind":12,"detail":"($self)","signature":{"label":"_get_path($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: GeneMapper.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::GeneMapper\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::GeneMapper - transformations between gene related coordinate systems\n\n=head1 SYNOPSIS\n\n  use Bio::Coordinate::GeneMapper;\n\n  # get a Bio::RangeI representing the start, end and strand of the CDS\n  # in chromosomal (or entry) coordinates\n  my $cds;\n\n  # get a Bio::Location::Split or an array of Bio::LocationI objects\n  # holding the start, end and strand of all the exons in chromosomal\n  # (or entry) coordinates\n  my $exons;\n\n  # create a gene mapper and set it to map from chromosomal to cds coordinates\n  my $gene = Bio::Coordinate::GeneMapper->new(-in   =>'chr',\n                                              -out  =>'cds',\n                                              -cds  =>$cds,\n                                              -exons=>$exons\n                                             );\n\n  # get a a Bio::Location or sequence feature in input (chr) coordinates\n  my $loc;\n\n  # map the location into output coordinates and get a new location object\n  $newloc = $gene->map($loc);\n\n\n=head1 DESCRIPTION\n\nBio::Coordinate::GeneMapper is a module for simplifying the mappings\nof coodinate locations between various gene related locations in human\ngenetics. It also adds a special human genetics twist to coordinate\nsystems by making it possible to disable the use of zero\n(0). Locations before position one start from -1. See method\nL<nozero>.\n\nIt understands by name the following coordinate systems and mapping\nbetween them:\n\n                          peptide (peptide length)\n                             ^\n                             | -peptide_offset\n                             |\n                    frame  propeptide (propeptide length)\n                        ^    ^\n                         \\   |\n             translate    \\  |\n                           \\ |\n                            cds  (transcript start and end)\n                             ^\n      negative_intron        | \\\n              ^              |  \\  transcribe\n               \\             |   \\\n              intron        exon  \\\n               ^   ^         ^     /\n      splice    \\   \\      / |    /\n                 \\   \\    /  |   /\n                  \\   inex   |  /\n                   \\    ^    | /\n                    \\    \\   |/\n                     ----- gene (gene_length)\n                             ^\n                             | - gene_offset\n                             |\n                            chr (or entry)\n\n\nThis structure is kept in the global variable $DAG which is a\nrepresentation of a Directed Acyclic Graph. The path calculations\ntraversing this graph are done in a helper class. See\nL<Bio::Coordinate::Graph>.\n\nOf these, two operations are special cases, translate and splice.\nTranslating and reverse translating are implemented as internal\nmethods that do the simple 1E<lt>-E<gt>3 conversion. Splicing needs\nadditional information that is provided by method L<exons> which takes\nin an array of Bio::LocationI objects.\n\nMost of the coordinate system names should be selfexplanatory to\nanyone familiar with genes. Negative intron coordinate system is\nstarts counting backwards from -1 as the last nucleotide in the\nintron. This used when only exon and a few flanking intron nucleotides\nare known.\n\n\nThis class models coordinates within one transcript of a gene, so to\ntackle multiple transcripts you need several instances of the\nclass. It is therefore valid to argue that the name of the class\nshould be TranscriptMapper. GeneMapper is a catchier name, so it\nstuck.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::GeneMapper;\nuse vars qw(%COORDINATE_SYSTEMS %COORDINATE_INTS $TRANSLATION $DAG\n            $NOZERO_VALUES $NOZERO_KEYS);\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Coordinate::Result;\nuse Bio::Location::Simple;\nuse Bio::Coordinate::Graph;\nuse Bio::Coordinate::Collection;\nuse Bio::Coordinate::Pair;\nuse Bio::Coordinate::ExtrapolatingPair;\n\nuse base qw(Bio::Root::Root Bio::Coordinate::MapperI);\n\n# first set internal values for all translation tables\n\n%COORDINATE_SYSTEMS = (\n\t\t       peptide          => 10,\n\t\t       propeptide       => 9,\n\t\t       frame            => 8,\n\t\t       cds              => 7,\n\t\t       negative_intron  => 6,\n\t\t       intron           => 5,\n\t\t       exon             => 4,\n\t\t       inex             => 3,\n\t\t       gene             => 2,\n\t\t       chr              => 1\n\t\t      );\n\n%COORDINATE_INTS = (\n\t\t    10 => 'peptide',\n\t\t    9 => 'propeptide',\n\t\t    8 => 'frame',\n\t\t    7 => 'cds',\n\t\t    6 => 'negative_intron',\n\t\t    5 => 'intron',\n\t\t    4 => 'exon',\n\t\t    3 => 'inex',\n\t\t    2 => 'gene',\n\t\t    1 => 'chr'\n\t\t   );\n\n$TRANSLATION = $COORDINATE_SYSTEMS{'cds'}. \"-\".\n    $COORDINATE_SYSTEMS{'propeptide'};\n\n$DAG = {\n\t10 => [],\n\t9  => [10],\n\t8  => [],\n\t7  => [8, 9],\n\t6  => [],\n\t5  => [6],\n\t4  => [7],\n\t3  => [4, 5],\n\t2  => [3, 4, 5, 7],\n\t1  => [2]\n       };\n\n$NOZERO_VALUES = {0 => 0, 'in' => 1, 'out' => 2, 'in&out' => 3 };\n$NOZERO_KEYS = { 0 => 0, 1 => 'in', 2 => 'out', 3 => 'in&out' };\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    # prime the graph\n    my $graph = Bio::Coordinate::Graph->new();\n    $graph->hash_of_arrays($DAG);\n    $self->graph($graph);\n\n    my($in, $out, $peptide_offset, $exons,\n       $cds, $nozero, $strict) =\n\t$self->_rearrange([qw(IN\n                              OUT\n                              PEPTIDE_OFFSET\n                              EXONS\n                              CDS\n                              NOZERO\n                              STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    # direction of mapping when going chr to protein\n    $self->{_direction} = 1;\n\n    $in  && $self->in($in);\n    $out  && $self->out($out);\n    $cds && $self->cds($cds);\n    $exons  && ref($exons) =~ /ARRAY/i && $self->exons(@$exons);\n    $peptide_offset && $self->peptide_offset($peptide_offset);\n    $nozero && $self->nozero($nozero);\n    $strict && $self->strict($strict);\n\n    return $self; # success - we hope!\n}\n\n=head2 in\n\n Title   : in\n Usage   : $obj->in('peptide');\n Function: Set and read the input coordinate system.\n Example :\n Returns : value of input system\n Args    : new value (optional)\n\n\nsub in {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_in'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_in'} };\n}\n\n\n=head2 out\n\n Title   : out\n Usage   : $obj->out('peptide');\n Function: Set and read the output coordinate system.\n Example :\n Returns : value of output system\n Args    : new value (optional)\n\n\nsub out {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid input coordinate system name [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %COORDINATE_SYSTEMS ))\n\t   unless defined $COORDINATE_SYSTEMS{$value};\n\n       $self->{'_out'} = $COORDINATE_SYSTEMS{$value};\n   }\n   return $COORDINATE_INTS{ $self->{'_out'} };\n}\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict('peptide');\n Function: Set and read whether strict boundaried of coordinate\n           systems are enforced.\n           When strict is on, the end of the coordinate range must be defined.\n Example :\n Returns : boolean\n Args    : boolean (optional)\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $value ? ( $self->{'_strict'} = 1 ) : ( $self->{'_strict'} = 0 );\n       ## update in each mapper !!\n   }\n   return $self->{'_strict'} || 0 ;\n}\n\n\n=head2 nozero\n\n Title   : nozero\n Usage   : $obj->nozero(1);\n Function: Flag to disable the use of zero in the input,\n           output or both coordinate systems. Use of coordinate\n           systems without zero is a peculiarity  common in\n           human genetics community.\n Example :\n Returns : 0 (default), or 'in', 'out', 'in&out'\n Args    : 0 (default), or 'in', 'out', 'in&out'\n\n\nsub nozero {\n   my ($self,$value) = @_;\n\n   if (defined $value) {\n       $self->throw(\"Not a valid value for nozero [$value]\\n\".\n\t\t    \"Valid values are \". join(\", \", keys %{$NOZERO_VALUES} ))\n\t   unless defined $NOZERO_VALUES->{$value};\n       $self->{'_nozero'} = $NOZERO_VALUES->{$value};\n   }\n\n   my $res = $self->{'_nozero'} || 0;\n   return $NOZERO_KEYS->{$res};\n}\n\n=head2 graph\n\n Title   : graph\n Usage   : $obj->graph($new_graph);\n Function: Set and read the graph object representing relationships\n           between coordinate systems\n Example :\n Returns : Bio::Coordinate::Graph object\n Args    : new Bio::Coordinate::Graph object (optional)\n\n\nsub graph {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->throw(\"Not a valid graph [$value]\\n\")\n\t   unless $value->isa('Bio::Coordinate::Graph');\n       $self->{'_graph'} = $value;\n   }\n   return $self->{'_graph'};\n}\n\n=head2 peptide\n\n Title   : peptide\n Usage   : $obj->peptide_offset($peptide_coord);\n Function: Read and write the offset of peptide from the start of propeptide\n           and peptide length\n Returns : a Bio::Location::Simple object\n Args    : a Bio::LocationI object\n\n\nsub peptide {\n   my ($self, $value) = @_;\n   if( defined $value) {\n       $self->throw(\"I need a Bio::LocationI, not  [\". $value. \"]\")\n\t   unless $value->isa('Bio::LocationI');\n\n       $self->throw(\"Peptide start not defined\")\n\t   unless defined $value->start;\n       $self->{'_peptide_offset'} = $value->start - 1;\n\n       $self->throw(\"Peptide end not defined\")\n\t   unless defined $value->end;\n       $self->{'_peptide_length'} = $value->end - $self->{'_peptide_offset'};\n\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict,\n\t    $self->{'_peptide_offset'}, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\".  $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return  Bio::Location::Simple->new\n       (-seq_id => 'propeptide',\n\t-start => $self->{'_peptide_offset'} + 1 ,\n\t-end => $self->{'_peptide_length'} + $self->{'_peptide_offset'},\n\t-strand => 1,\n\t-verbose => $self->verbose,\n       );\n}\n\n=head2 peptide_offset\n\n Title   : peptide_offset\n Usage   : $obj->peptide_offset(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub peptide_offset {\n   my ($self,$offset, $len) = @_;\n   if( defined $offset) {\n       $self->throw(\"I need an integer, not [$offset]\")\n\t   unless $offset =~ /^[+-]?\\d+$/;\n       $self->{'_peptide_offset'} = $offset;\n\n       if (defined $len) {\n\t   $self->throw(\"I need an integer, not [$len]\")\n\t       unless $len =~ /^[+-]?\\d+$/;\n\t   $self->{'_peptide_length'} = $len;\n       }\n\n       my $a = $self->_create_pair\n\t   ('propeptide', 'peptide', $self->strict, $offset, $self->{'_peptide_length'} );\n       my $mapper =  $COORDINATE_SYSTEMS{'propeptide'}. \"-\". $COORDINATE_SYSTEMS{'peptide'};\n       $self->{'_mappers'}->{$mapper} = $a;\n   }\n   return $self->{'_peptide_offset'} || 0;\n}\n\n=head2 peptide_length\n\n Title   : peptide_length\n Usage   : $obj->peptide_length(20);\n Function: Set and read the offset of peptide from the start of propeptide\n Returns : set value or 0\n Args    : new value (optional)\n\n\n\nsub peptide_length {\n   my ($self, $len) = @_;\n   if( defined $len) {\n       $self->throw(\"I need an integer, not [$len]\")\n\t   if defined $len && $len !~ /^[+-]?\\d+$/;\n       $self->{'_peptide_length'} = $len;\n   }\n   return $self->{'_peptide_length'};\n}\n\n\n=head2 exons\n\n Title   : exons\n Usage   : $obj->exons(@exons);\n Function: Set and read the offset of CDS from the start of transcript\n           You do not have to sort the exons before calling this method as\n           they will be sorted automatically.\n           If you have not defined the CDS, is will be set to span all\n           exons here.\n Returns : array of Bio::LocationI exons in genome coordinates or 0\n Args    : array of Bio::LocationI exons in genome (or entry) coordinates\n\n\nsub exons {\n   my ($self,@value) = @_;\n   my $cds_mapper =  $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n   my $inex_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'inex'};\n   my $exon_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'exon'};\n   my $intron_mapper =\n       $COORDINATE_SYSTEMS{'gene'}. \"-\". $COORDINATE_SYSTEMS{'intron'};\n   my $negative_intron_mapper =\n       $COORDINATE_SYSTEMS{'intron'}. \"-\". $COORDINATE_SYSTEMS{'negative_intron'};\n   my $exon_cds_mapper =  $COORDINATE_SYSTEMS{'exon'}. \"-\". $COORDINATE_SYSTEMS{'cds'};\n\n   if(@value) {\n       if (ref($value[0]) &&\n\t   $value[0]->isa('Bio::SeqFeatureI') and\n\t   $value[0]->location->isa('Bio::Location::SplitLocationI')) {\n\t   @value = $value[0]->location->each_Location;\n       } else {\n\t   $self->throw(\"I need an array , not [@value]\")\n\t       unless ref \\@value eq 'ARRAY';\n\t   $self->throw(\"I need a reference to an array of Bio::LocationIs, not to [\".\n\t\t\t$value[0]. \"]\")\n\t       unless ref $value[0] and $value[0]->isa('Bio::LocationI');\n       }\n\n       #\n       # sort the input array\n       #\n       # and if the used has not defined CDS assume it is the complete exonic range\n       if (defined $value[0]->strand && \n\t   $value[0]->strand == - 1) {  #reverse strand\n\t   @value = map { $_->[0] }\n\t            sort { $b->[1] <=> $a->[1] }\n\t            map { [ $_, $_->start] }\n                    @value;\n\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[-1]->start,\n\t\t\t   -end     => $value[0]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n\t\t\t  );\n           }\n       } else {               # undef or forward strand\n\t   @value = map { $_->[0] }\n\t            sort { $a->[1] <=> $b->[1] }\n                    map { [ $_, $_->start] }\n                    @value;\n           unless ($self->cds) {\n               $self->cds(Bio::Location::Simple->new\n\t\t\t  (-start   => $value[0]->start,\n\t\t\t   -end     => $value[-1]->end,\n\t\t\t   -strand  => $value[0]->strand,\n\t\t\t   -seq_id  => $value[0]->seq_id,\n\t\t\t   -verbose => $self->verbose,\n\t\t\t   )\n                         );\n           }\n\n       }\n\n       $self->{'_chr_exons'} = \\@value;\n\n       # transform exons from chromosome to gene coordinates\n       # but only if gene coordinate system has been set\n       my @exons ;\n       #my $gene_mapper = $self->$COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       my $gene_mapper = \"1-2\";\n       if (defined $self->{'_mappers'}->{$gene_mapper} ) {\n\n\t   my $tmp_in = $self->{'_in'};\n\t   my $tmp_out = $self->{'_out'};\n\t   my $tmp_verb = $self->verbose;\n\t   $self->verbose(0);\n\n\t   $self->in('chr');\n\t   $self->out('gene');\n\t   @exons = map {$self->map($_) } @value;\n\n\t   $self->{'_in'} = ($tmp_in);\n\t   $self->{'_out'} = ($tmp_out);\n\t   $self->verbose($tmp_verb);\n       } else {\n\t   @exons = @value;\n       }\n\n       my $cds_map = Bio::Coordinate::Collection->new;\n       my $inex_map = Bio::Coordinate::Collection->new;\n       my $exon_map = Bio::Coordinate::Collection->new;\n       my $exon_cds_map = Bio::Coordinate::Collection->new;\n       my $intron_map = Bio::Coordinate::Collection->new;\n       my $negative_intron_map = Bio::Coordinate::Collection->new;\n\n       my $tr_end = 0;\n       my $coffset;\n       my $exon_counter;\n       my $prev_exon_end;\n\n       for my $exon ( @exons ) {\n\t   $exon_counter++;\n\n\t   #\n\t   # gene -> cds\n\t   #\n\n\t   my $match1 = Bio::Location::Simple->new\n\t       (-seq_id =>'gene' ,\n\t\t-start  => $exon->start,\n\t\t-end    => $exon->end, \n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n\n\t   my $match2 = Bio::Location::Simple->new\n\t       (-seq_id => 'cds',\n\t\t-start => $tr_end + 1,\n\t\t-end => $tr_end + $exon->end - $exon->start +1,\n\t\t-strand=>$exon->strand,\n\t\t-verbose=>$self->verbose);\n\n\t   $cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                (-in => $match1,\n                                 -out => $match2,\n                                )\n                               );\n\n\t   if ($exon->start <= 1 and $exon->end >= 1) {\n\t       $coffset = $tr_end - $exon->start + 1;\n\t   }\n\t   $tr_end = $tr_end  + $exon->end - $exon->start + 1;\n\n\t   #\n\t   # gene -> intron\n\t   #\n\n\t   if (defined $prev_exon_end) {\n\t       my $match3 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'gene',\n\t\t    -start   => $prev_exon_end + 1,\n\t\t    -end     => $exon->start -1, \n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       my $match4 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => 1,\n\t\t    -end     => $exon->start - 1 - $prev_exon_end,\n\t\t    -strand  =>$exon->strand,\n\t\t    -verbose => $self->verbose,);\n\n\t       # negative intron coordinates\n\t       my $match5 = Bio::Location::Simple->new\n\t\t   (-seq_id  => 'intron'. ($exon_counter -1),\n\t\t    -start   => -1 * ($exon->start - 2 - $prev_exon_end) -1,\n\t\t    -end     => -1,\n\t\t    -strand  => $exon->strand,\n\t\t    -verbose => $self->verbose);\n\n\t       $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $match3,\n                                      -out => $match4\n                                     )\n                                    );\n\t       $intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                       (-in => $self->_clone_loc($match3),\n                                        -out => $self->_clone_loc($match4)\n                                       )\n                                      );\n\t       $negative_intron_map->add_mapper(Bio::Coordinate::Pair->new\n                                                (-in => $self->_clone_loc($match4),\n                                                 -out => $match5\n                                                ));\n\n\t   }\n\n\t   # store the value\n\t   $prev_exon_end = $exon->end;\n\n\t   #\n\t   # gene -> exon\n\t   #\n\t   my $match6 = Bio::Location::Simple->new\n\t       (-seq_id => 'exon'. $exon_counter,\n\t\t-start  => 1,\n\t\t-end    => $exon->end - $exon->start +1,\n\t\t-strand => $exon->strand,\n\t\t-verbose=> $self->verbose,);\n\n\t   my $pair2 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match1),\n\t\t\t\t\t\t  -out => $match6\n\t\t\t\t\t\t );\n\t   my $pair3 = Bio::Coordinate::Pair->new(-in => $self->_clone_loc($match6),\n\t\t\t\t\t\t  -out => $self->_clone_loc($match2)\n\t\t\t\t\t\t );\n\t   $inex_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $match6\n                                 )\n                                );\n\t   $exon_map->add_mapper(Bio::Coordinate::Pair->new\n                                 (-in => $self->_clone_loc($match1),\n                                  -out => $self->_clone_loc($match6)\n                                 )\n                                );\n           $exon_cds_map->add_mapper(Bio::Coordinate::Pair->new\n                                     (-in => $self->_clone_loc($match6),\n                                      -out => $self->_clone_loc($match2)\n                                     )\n                                    );\n\n       }\n\n       # move coordinate start if exons have negative values\n       if ($coffset) {\n\t   foreach my $m ($cds_map->each_mapper) {\n\t       $m->out->start($m->out->start - $coffset);\n\t       $m->out->end($m->out->end - $coffset);\n\t   }\n\n       }\n\n       $self->{'_mappers'}->{$cds_mapper} = $cds_map;\n       $self->{'_mappers'}->{$exon_cds_mapper} = $exon_cds_map;\n       $self->{'_mappers'}->{$inex_mapper} = $inex_map;\n       $self->{'_mappers'}->{$exon_mapper} = $exon_map;\n       $self->{'_mappers'}->{$intron_mapper} = $intron_map;\n       $self->{'_mappers'}->{$negative_intron_mapper} = $negative_intron_map;\n   }\n   return  @{$self->{'_chr_exons'}}  || 0;\n}\n\n=head2 _clone_loc\n\n Title   : _clone_loc\n Usage   : $copy_of_loc = $obj->_clone_loc($loc);\n Function: Make a deep copy of a simple location\n Returns : a Bio::Location::Simple object\n Args    : a Bio::Location::Simple object to be cloned\n\n\n\nsub _clone_loc { # clone a simple location\n   my ($self,$loc) = @_;\n\n   $self->throw(\"I need a Bio::Location::Simple , not [\". ref $loc. \"]\")\n       unless $loc->isa('Bio::Location::Simple');\n\n   return  Bio::Location::Simple->new\n       (-verbose       => $self->verbose,\n\t-seq_id        => $loc->seq_id,\n        -start         => $loc->start,\n        -end           => $loc->end,\n        -strand        => $loc->strand,\n        -location_type => $loc->location_type\n       );\n}\n\n\n=head2 cds\n\n Title   : cds\n Usage   : $obj->cds(20);\n Function: Set and read the offset of CDS from the start of transcipt\n\n           Simple input can be an integer which gives the start of the\n           coding region in genomic coordinate. If you want to provide\n           the end of the coding region or indicate the use of the\n           opposite strand, you have to pass a Bio::RangeI\n           (e.g. Bio::Location::Simple or Bio::SegFeature::Generic)\n           object to this method.\n\n Returns : set value or 0\n Args    : new value (optional)\n\n\nsub cds {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       if ($value =~ /^[+-]?\\d+$/ ) {\n\t   my $loc = Bio::Location::Simple->new(-start=>$value, -end => $value,\n\t\t\t\t\t\t-verbose=>$self->verbose);\n\t   $self->{'_cds'} = $loc;\n       }\n       elsif (ref $value &&  $value->isa('Bio::RangeI') ) {\n\t   $self->{'_cds'} = $value;\n       } else {\n\t   $self->throw(\"I need an integer or Bio::RangeI, not [$value]\")\n       }\n       # strand !!\n       my $len;\n\n       $len = $self->{'_cds'}->end - $self->{'_cds'}->start +1\n\t   if defined $self->{'_cds'}->end;\n\n       my $a = $self->_create_pair\n\t   ('chr', 'gene', 0,\n\t    $self->{'_cds'}->start-1,\n\t    $len,\n\t    $self->{'_cds'}->strand);\n       my $mapper =  $COORDINATE_SYSTEMS{'chr'}. \"-\". $COORDINATE_SYSTEMS{'gene'};\n       $self->{'_mappers'}->{$mapper} = $a;\n\n       # recalculate exon-based mappers\n       if ( defined $self->{'_chr_exons'} ) {\n\t   $self->exons(@{$self->{'_chr_exons'}});\n       }\n\n   }\n   return $self->{'_cds'} || 0;\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map(5);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n Example :\n Returns : new value in the output coordiante system\n Args    : a Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n   my ($res);\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::Simple or Bio::SeqFeatureI, not [\".\n\t\tref($value). \"]\")\n       unless ref($value) && ($value->isa('Bio::Location::Simple') or\n                              $value->isa('Bio::Location::SplitLocationI') or\n\t\t\t      $value->isa('Bio::SeqFeatureI'));\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->{'_in'};\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->{'_out'};\n   $self->throw(\"Do not be silly. Input and output coordinate \".\n\t\t\"systems are the same!\")\n       unless $self->{'_in'} != $self->{'_out'};\n\n   $self->_check_direction();\n\n   $value = $value->location if $value->isa('Bio::SeqFeatureI');\n   $self->debug( \"=== Start location: \". $value->start. \",\".\n\t\t $value->end. \" (\". ($value->strand || ''). \")\\n\");\n\t       \n   # if nozero coordinate system is used in the input values\n   if ( defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 1 || $self->{'_nozero'} == 3 ) ) {\n       $value->start($value->start + 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end + 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   my @steps = $self->_get_path();\n   $self->debug( \"mapping \". $self->{'_in'}. \"->\". $self->{'_out'}.\n\t\t \"  Mappers: \". join(\", \", @steps). \"\\n\");\n   \n   foreach my $mapper (@steps) {\n       if ($mapper eq $TRANSLATION) {\n\t   if ($self->direction == 1) {\n\n\t       $value = $self->_translate($value);\n\t       $self->debug( \"+   $TRANSLATION cds -> propeptide (translate) \\n\");\n\t   } else {\n\t       $value = $self->_reverse_translate($value);\n\t       $self->debug(\"+   $TRANSLATION propeptide -> cds (reverse translate) \\n\");\n\t   }\n       }\n       # keep the start and end values, and go on to next iteration\n       #  if this mapper is not set\n       elsif ( ! defined $self->{'_mappers'}->{$mapper} ) {\n\t   # update mapper name\n\t   $mapper =~ /\\d+-(\\d+)/;   my ($counter) = $1;\n\t   $value->seq_id($COORDINATE_INTS{$counter});\n\t   $self->debug( \"-   $mapper\\n\");\n       } else {\n           #\n\t   # the DEFAULT : generic mapping\n           #\n\t   \n\t   $value = $self->{'_mappers'}->{$mapper}->map($value);\n           \n\t   $value->purge_gaps\n\t       if ($value && $value->isa('Bio::Location::SplitLocationI') && \n\t\t   $value->can('gap'));\n\t   \n\t   $self->debug( \"+  $mapper (\". $self->direction. \"):  start \".\n\t\t\t $value->start. \" end \". $value->end. \"\\n\")\n\t       if $value && $self->verbose > 0;\n       }\n   }\n\n   # if nozero coordinate system is asked to be used in the output values\n   if ( defined $value && defined $self->{'_nozero'} &&\n\t( $self->{'_nozero'} == 2 || $self->{'_nozero'} == 3 ) ) {\n\n       $value->start($value->start - 1)\n\t   if defined $value->start && $value->start < 1;\n       $value->end($value->end - 1)\n\t   if defined $value->end && $value->end < 1;\n   }\n\n   # handle merging of adjacent split locations!\n\n   if (ref $value eq \"Bio::Coordinate::Result\" && $value->each_match > 1 ) {\n       my $prevloc;\n       my $merging = 0;\n       my $newvalue;\n       my @matches;\n       foreach my $loc ( $value->each_Location(1) ) {\n           unless ($prevloc) {\n               $prevloc = $loc;\n               push @matches, $prevloc;\n               next;\n           }\n           if ($prevloc->end == ($loc->start - 1) && \n\t       $prevloc->seq_id eq $loc->seq_id) {\n               $prevloc->end($loc->end);\n               $merging = 1;\n           } else {\n               push @matches, $loc;\n               $prevloc = $loc;\n           }\n       }\n       if ($merging) {\n           if (@matches > 1 ) {\n               $newvalue = Bio::Coordinate::Result->new;\n               map {$newvalue->add_sub_Location} @matches;\n           } else {\n               $newvalue = Bio::Coordinate::Result::Match->new\n                   (-seq_id   => $matches[0]->seq_id,\n                    -start    => $matches[0]->start,\n                    -end      => $matches[0]->end,\n                    -strand   => $matches[0]->strand,\n\t\t    -verbose  => $self->verbose,);\n           }\n           $value = $newvalue;\n       }\n   } \n   elsif (ref $value eq \"Bio::Coordinate::Result\" && \n\t  $value->each_match == 1 ){\n       $value = $value->match;\n   }\n\n   return $value;\n}\n\n=head2 direction\n\n Title   : direction\n Usage   : $obj->direction('peptide');\n Function: Read-only method for the direction of mapping deduced from\n           predefined input and output coordinate names.\n Example :\n Returns : 1 or -1, mapping direction\n Args    : new value (optional)\n\n\nsub direction {\n   my ($self) = @_;\n   return $self->{'_direction'};\n}\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of transformation\n           (input <-> output)\n Example :\n Returns : 1\n Args    :\n\n\nsub swap {\n   my ($self,$value) = @_;\n\n   ($self->{'_in'}, $self->{'_out'}) = ($self->{'_out'}, $self->{'_in'});\n   map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n\n   # record the changed direction;\n   $self->{_direction} *= -1;\n\n   return 1;\n}\n\n\n=head2 to_string\n\n Title   : to_string\n Usage   : $newpos = $obj->to_string(5);\n Function: Dump the internal mapper values into a human readable format\n Example :\n Returns : string\n Args    :\n\n\nsub to_string {\n   my ($self) = shift;\n\n   print \"-\" x 40, \"\\n\";\n\n   # chr-gene\n   my $mapper_str = 'chr-gene';\n   my $mapper = $self->_mapper_string2code($mapper_str);\n\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   if (defined $self->cds) {\n       my $end = $self->cds->end -1 if defined $self->cds->end;\n       printf \"%16s%s: %s (%s)\\n\", ' ', 'gene offset', $self->cds->start-1 , $end || '';\n       printf \"%16s%s: %s\\n\", ' ', 'gene strand', $self->cds->strand || 0;\n   }\n\n   # gene-intron\n   $mapper_str = 'gene-intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   my $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # intron-negative_intron\n   $mapper_str = 'intron-negative_intron';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-exon\n   $mapper_str = 'gene-exon';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n\n   # gene-cds\n   $mapper_str = 'gene-cds';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n\n   $i = 1;\n   foreach my $pair ( $self->{'_mappers'}->{$mapper}->each_mapper ) {\n       printf \"%8s :%8s -> %-12s\\n\", $i, $pair->in->start, $pair->out->start ;\n       printf \"%8s :%8s -> %-12s\\n\", '', $pair->in->end, $pair->out->end ;\n       $i++;\n   }\n\n   # cds-propeptide\n   $mapper_str = 'cds-propeptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%9s%-12s\\n\", \"\", '\"translate\"';\n\n\n   # propeptide-peptide\n   $mapper_str = 'propeptide-peptide';\n   $mapper = $self->_mapper_string2code($mapper_str);\n   printf \"\\n     %-12s (%s)\\n\", $mapper_str, $mapper ;\n   printf \"%16s%s: %s\\n\", ' ', \"peptide offset\", $self->peptide_offset;\n\n\n\n   print \"\\nin : \", $self->in, \"\\n\";\n   print \"out: \", $self->out, \"\\n\";\n   my $dir;\n   $self->direction ? ($dir='forward') : ($dir='reverse');\n   printf \"direction: %-8s(%s)\\n\",  $dir, $self->direction;\n   print \"\\n\", \"-\" x 40, \"\\n\";\n\n   1;\n}\n\nsub _mapper_code2string {\n    my ($self, $code) = @_;\n    my ($a, $b) = $code =~ /(\\d+)-(\\d+)/;\n    return $COORDINATE_INTS{$a}. '-'.  $COORDINATE_INTS{$b};\n\n}\n\nsub _mapper_string2code {\n    my ($self, $string) =@_;\n    my ($a, $b) = $string =~ /([^-]+)-(.*)/;\n    return $COORDINATE_SYSTEMS{$a}. '-'.  $COORDINATE_SYSTEMS{$b};\n}\n\n\n=head2 _create_pair\n\n Title   : _create_pair\n Usage   : $mapper = $obj->_create_pair('chr', 'gene', 0, 2555, 10000, -1);\n Function: Internal helper method to create a mapper between\n           two coordinate systems\n Returns : a Bio::Coordinate::Pair object\n Args    : string, input coordinate system name,\n           string, output coordinate system name,\n           boolean, strict mapping\n           positive integer, offset\n           positive integer, length\n           1 || -1 , strand\n\n\nsub _create_pair {\n   my ($self, $in, $out, $strict, $offset, $length, $strand ) = @_;\n   $strict ||= 0;\n   $strand ||= 1;\n   $length ||= 20;\n\n   my $match1 = Bio::Location::Simple->new\n       (-seq_id  => $in,\n\t-start   => $offset+1,\n\t-end     => $offset+$length, \n\t-strand  => 1,\n\t-verbose => $self->verbose);\n\n   my $match2 = Bio::Location::Simple->new\n       (-seq_id  => $out,\n\t-start   => 1,\n\t-end     => $length, \n\t-strand  => $strand,\n\t-verbose => $self->verbose);\n\n   my $pair = Bio::Coordinate::ExtrapolatingPair->new\n       (-in      => $match1,\n        -out     => $match2,\n        -strict  => $strict,\n\t-verbose => $self->verbose,\n       );\n\n   return $pair;\n\n}\n\n\n=head2 _translate\n\n Title   : _translate\n Usage   : $newpos = $obj->_translate($loc);\n Function: Translate the location from the CDS coordinate system\n           to a new value in the propeptide coordinate system.\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _translate {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n   \n   if ($value->isa(\"Bio::Location::SplitLocationI\") ) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n           my $match = Bio::Location::Simple->new\n\t       (-start   => int ($loc->start / 3 ) +1,\n\t\t-end     => int ($loc->end / 3 ) +1,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start  => int($value->start / 3 )+1,\n                                        -end    => int($value->end / 3 )+1,\n                                        -seq_id => $seqid,\n                                        -strand => 1,\n\t\t\t\t\t-verbose=> $self->verbose,\n                                       );\n   }\n}\n\nsub _frame {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'propeptide';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start  => ($value->start-1) % 3 +1,\n\t\t-end    => ($value->end-1) % 3 +1,\n\t\t-seq_id => 'frame',\n\t\t-strand => 1,\n\t\t-verbose=> $self->verbose);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n   } else {\n       return new Bio::Location::Simple(-start   => ($value->start-1) % 3 +1,\n                                        -end     => ($value->end-1) % 3 +1,\n                                        -seq_id  => 'frame',\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n\t\t\t\t\t);\n   }\n}\n\n\n=head2 _reverse_translate\n\n Title   : _reverse_translate\n Usage   : $newpos = $obj->_reverse_translate(5);\n Function: Reverse translate the location from the propeptide\n           coordinate system to a new value in the CSD.\n           Note that a single peptide location expands to cover\n           the codon triplet\n Example :\n Returns : new location in the CDS coordinate system\n Args    : a Bio::Location::Simple or Bio::Location::SplitLocationI\n\n\nsub _reverse_translate {\n   my ($self,$value) = @_;\n\n\n   $self->throw(\"Need to pass me a Bio::Location::Simple or \".\n                \"Bio::Location::SplitLocationI, not [\". ref($value). \"]\")\n       unless defined $value &&\n           ($value->isa('Bio::Location::Simple') || $value->isa('Bio::Location::SplitLocationI'));\n\n   my $seqid = 'cds';\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n       my $split = Bio::Location::Split->new(-seq_id=>$seqid);\n       foreach my $loc ( $value->each_Location(1) ) {\n\n           my $match = Bio::Location::Simple->new\n\t       (-start   => $value->start * 3 - 2,\n\t\t-end     => $value->end * 3,\n\t\t-seq_id  => $seqid,\n\t\t-strand  => 1,\n\t\t-verbose => $self->verbose,\n\t\t);\n           $split->add_sub_Location($match);\n       }\n       return $split;\n\n   } else {\n       return new Bio::Location::Simple(-start   => $value->start * 3 - 2,\n                                        -end     => $value->end * 3,\n                                        -seq_id  => $seqid,\n                                        -strand  => 1,\n\t\t\t\t\t-verbose => $self->verbose,\n                                       );\n   }\n}\n\n\n=head2 _check_direction\n\n Title   : _check_direction\n Usage   : $obj->_check_direction();\n Function: Check and swap when needed the direction the location\n           mapping Pairs based on input and output values\n Example :\n Returns : new location\n Args    : a Bio::Location::Simple\n\n\nsub _check_direction {\n   my ($self) = @_;\n\n   my $new_direction = 1;\n   $new_direction = -1 if $self->{'_in'} > $self->{'_out'};\n\n   unless ($new_direction == $self->{_direction} ) {\n       map { $self->{'_mappers'}->{$_}->swap } keys %{$self->{'_mappers'}};\n       # record the changed direction;\n       $self->{_direction} *= -1;\n   }\n   1;\n}\n\n\n=head2 _get_path\n\n Title   : _get_path\n Usage   : $obj->_get_path('peptide');\n Function: internal method for finding that shortest path between\n           input and output coordinate systems.\n           Calculations and caching are handled by the graph class.\n           See L<Bio::Coordinate::Graph>.\n Example :\n Returns : array of the mappers\n Args    : none"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":1315},"end":{"line":1334,"character":9999}},"name":"_get_path"},{"kind":13,"line":1335,"containerName":null,"definition":"my","name":"$mapper","localvar":"my"},{"localvar":"my","definition":"my","name":"$prev_node","containerName":null,"line":1336,"kind":13},{"containerName":null,"name":"@mappers","line":1337,"kind":13},{"kind":13,"line":1338,"name":"$mapper","containerName":null},{"name":"$prev_node","containerName":null,"line":1338,"kind":13},{"containerName":null,"name":"$mapper","line":1338,"kind":13},{"containerName":null,"name":"%self","kind":13,"line":1339},{"containerName":"main::","name":"shortest_path","kind":12,"line":1339},{"kind":13,"line":1339,"containerName":null,"name":"$start"},{"containerName":null,"name":"$end","kind":13,"line":1339},{"kind":13,"line":1340,"containerName":null,"name":"@mappers"},{"kind":13,"line":1342,"containerName":null,"name":"%self"},{"containerName":null,"name":"%self","line":1343,"kind":13},{"line":1343,"kind":13,"containerName":null,"name":"@mappers"},{"kind":13,"line":1346,"name":"$reverse","containerName":null},{"containerName":null,"name":"@mappers","line":1346,"kind":13},{"name":"@mappers","containerName":null,"kind":13,"line":1346}]}