{"vars":[{"name":"base","containerName":"","line":110,"kind":2},{"name":"new","range":{"end":{"line":124,"character":9999},"start":{"character":0,"line":113}},"kind":12,"children":[{"line":114,"kind":13,"localvar":"my","containerName":"new","name":"$class","definition":"my"},{"kind":13,"line":114,"containerName":"new","name":"@args"},{"localvar":"my","definition":"my","name":"$self","containerName":"new","line":115,"kind":13},{"line":115,"kind":13,"name":"$class","containerName":"new"},{"name":"@args","containerName":"new","line":115,"kind":13},{"definition":"my","name":"$strict","containerName":"new","localvar":"my","kind":13,"line":117},{"kind":13,"line":118,"name":"$self","containerName":"new"},{"name":"_rearrange","containerName":"new","kind":12,"line":118},{"containerName":"new","name":"@args","kind":13,"line":120},{"line":122,"kind":13,"containerName":"new","name":"$strict"},{"containerName":"new","name":"$self","kind":13,"line":122},{"kind":12,"line":122,"containerName":"new","name":"strict"},{"kind":13,"line":122,"name":"$strict","containerName":"new"},{"kind":13,"line":123,"containerName":"new","name":"$self"}],"line":113,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"detail":"($class,@args)"},{"line":115,"kind":12,"containerName":"new","name":"SUPER"},{"name":"strict","range":{"end":{"character":9999,"line":144},"start":{"line":138,"character":0}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ExtrapolatingPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::ExtrapolatingPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::ExtrapolatingPair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::ExtrapolatingPair;\n\n\n  $match1 = Bio::Location::Simple->new \n    (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  $match2 = Bio::Location::Simple->new\n    (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n\n  $pair = Bio::Coordinate::ExtrapolatingPair->\n    new(-in => $match1,\n    \t-out => $match2,\n    \t-strict => 1\n       );\n\n  $pos = Bio::Location::Simple->new \n      (-start => 40, -end => 60, -strand=> 1 );\n  $res = $pair->map($pos);\n  $res->start eq 20;\n  $res->end eq 20;\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThis class is an elaboration of Bio::Coordinate::Pair. The map\nfunction returns only matches which is the mode needed most of\ntehtime. By default the matching regions between coordinate systems\nare boundless, so that you can say e.g. that gene starts from here in\nthe chromosomal coordinate system and extends indefinetely in both\ndirections. If you want to define the matching regions exactly, you\ncan do that and set strict() to true.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::ExtrapolatingPair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Root::Root;\nuse Bio::LocationI;\n\nuse base qw(Bio::Coordinate::Pair);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($strict) =\n\t$self->_rearrange([qw(STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    $strict  && $self->strict($strict);\n    return $self;\n}\n\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict(1);\n Function: Set and read the strictness of the coordinate system.\n Example :\n Returns : value of input system\n Args    : boolean","label":"strict($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"containerName":"strict","definition":"my","name":"$self","localvar":"my","kind":13,"line":139},{"line":139,"kind":13,"name":"$value","containerName":"strict"},{"name":"$value","containerName":"strict","line":140,"kind":13},{"name":"$self","containerName":"strict","kind":13,"line":141},{"kind":13,"line":141,"name":"$value","containerName":"strict"},{"name":"$self","containerName":"strict","line":143,"kind":13}],"line":138},{"name":"map","range":{"end":{"character":9999,"line":191},"start":{"line":162,"character":0}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"map($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ExtrapolatingPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::ExtrapolatingPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::ExtrapolatingPair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::ExtrapolatingPair;\n\n\n  $match1 = Bio::Location::Simple->new \n    (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  $match2 = Bio::Location::Simple->new\n    (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n\n  $pair = Bio::Coordinate::ExtrapolatingPair->\n    new(-in => $match1,\n    \t-out => $match2,\n    \t-strict => 1\n       );\n\n  $pos = Bio::Location::Simple->new \n      (-start => 40, -end => 60, -strand=> 1 );\n  $res = $pair->map($pos);\n  $res->start eq 20;\n  $res->end eq 20;\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThis class is an elaboration of Bio::Coordinate::Pair. The map\nfunction returns only matches which is the mode needed most of\ntehtime. By default the matching regions between coordinate systems\nare boundless, so that you can say e.g. that gene starts from here in\nthe chromosomal coordinate system and extends indefinetely in both\ndirections. If you want to define the matching regions exactly, you\ncan do that and set strict() to true.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::ExtrapolatingPair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Root::Root;\nuse Bio::LocationI;\n\nuse base qw(Bio::Coordinate::Pair);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($strict) =\n\t$self->_rearrange([qw(STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    $strict  && $self->strict($strict);\n    return $self;\n}\n\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict(1);\n Function: Set and read the strictness of the coordinate system.\n Example :\n Returns : value of input system\n Args    : boolean\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->{'_strict'} = 1 if $value;\n   }\n   return $self->{'_strict'};\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($loc);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n\n           In extrapolating coodinate system there is no location zero.\n           Locations are...\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple"},"kind":12,"line":162,"children":[{"containerName":"map","name":"$self","definition":"my","localvar":"my","kind":13,"line":163},{"containerName":"map","name":"$value","line":163,"kind":13},{"kind":13,"line":165,"name":"$self","containerName":"map"},{"line":165,"kind":12,"name":"throw","containerName":"map"},{"containerName":"map","name":"$value","kind":13,"line":166},{"containerName":"map","name":"$self","kind":13,"line":167},{"kind":12,"line":167,"name":"throw","containerName":"map"},{"name":"$value","containerName":"map","line":168,"kind":13},{"line":168,"kind":12,"name":"isa","containerName":"map"},{"line":169,"kind":13,"name":"$self","containerName":"map"},{"name":"throw","containerName":"map","line":169,"kind":12},{"name":"$self","containerName":"map","kind":13,"line":170},{"kind":12,"line":170,"containerName":"map","name":"in"},{"kind":13,"line":171,"containerName":"map","name":"$self"},{"containerName":"map","name":"throw","line":171,"kind":12},{"containerName":"map","name":"$self","line":172,"kind":13},{"containerName":"map","name":"out","kind":12,"line":172},{"localvar":"my","containerName":"map","definition":"my","name":"$match","line":174,"kind":13},{"line":176,"kind":13,"containerName":"map","name":"$value"},{"name":"isa","containerName":"map","kind":12,"line":176},{"line":178,"kind":13,"localvar":"my","definition":"my","name":"$split","containerName":"map"},{"kind":12,"line":178,"containerName":"map","name":"new"},{"name":"$self","containerName":"map","line":178,"kind":13},{"containerName":"map","name":"out","kind":12,"line":178},{"name":"seq_id","containerName":"map","kind":12,"line":178},{"localvar":"my","containerName":"map","name":"$loc","definition":"my","line":179,"kind":13},{"containerName":"map","name":"$a","line":179,"kind":13},{"containerName":"map","name":"start","line":179,"kind":12},{"name":"$b","containerName":"map","line":179,"kind":13},{"containerName":"map","name":"start","kind":12,"line":179},{"name":"$value","containerName":"map","line":180,"kind":13},{"name":"sub_Location","containerName":"map","line":180,"kind":12},{"containerName":"map","name":"$match","line":182,"kind":13},{"kind":13,"line":182,"name":"$self","containerName":"map"},{"kind":12,"line":182,"containerName":"map","name":"_map"},{"name":"$loc","containerName":"map","kind":13,"line":182},{"name":"$split","containerName":"map","kind":13,"line":183},{"name":"add_sub_Location","containerName":"map","kind":12,"line":183},{"kind":13,"line":183,"name":"$match","containerName":"map"},{"name":"$match","containerName":"map","kind":13,"line":183},{"name":"$split","containerName":"map","kind":13,"line":186},{"containerName":"map","name":"each_Location","line":186,"kind":12},{"containerName":"map","name":"$split","kind":13,"line":186},{"name":"$self","containerName":"map","kind":13,"line":189},{"containerName":"map","name":"_map","line":189,"kind":12},{"name":"$value","containerName":"map","line":189,"kind":13}]},{"kind":12,"line":178,"name":"Bio","containerName":"Coordinate::Result"},{"signature":{"label":"_map($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: ExtrapolatingPair.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::ExtrapolatingPair\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::ExtrapolatingPair - Continuous match between two coordinate sets\n\n=head1 SYNOPSIS\n\n\n  use Bio::Location::Simple;\n  use Bio::Coordinate::ExtrapolatingPair;\n\n\n  $match1 = Bio::Location::Simple->new \n    (-seq_id => 'propeptide', -start => 21, -end => 40, -strand=>1 );\n  $match2 = Bio::Location::Simple->new\n    (-seq_id => 'peptide', -start => 1, -end => 20, -strand=>1 );\n\n  $pair = Bio::Coordinate::ExtrapolatingPair->\n    new(-in => $match1,\n    \t-out => $match2,\n    \t-strict => 1\n       );\n\n  $pos = Bio::Location::Simple->new \n      (-start => 40, -end => 60, -strand=> 1 );\n  $res = $pair->map($pos);\n  $res->start eq 20;\n  $res->end eq 20;\n\n=head1 DESCRIPTION\n\nThis class represents a one continuous match between two coordinate\nsystems represented by Bio::Location::Simple objects. The relationship\nis directed and reversible. It implements methods to ensure internal\nconsistency, and map continuous and split locations from one\ncoordinate system to another.\n\nThis class is an elaboration of Bio::Coordinate::Pair. The map\nfunction returns only matches which is the mode needed most of\ntehtime. By default the matching regions between coordinate systems\nare boundless, so that you can say e.g. that gene starts from here in\nthe chromosomal coordinate system and extends indefinetely in both\ndirections. If you want to define the matching regions exactly, you\ncan do that and set strict() to true.\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nreport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::ExtrapolatingPair;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Root::Root;\nuse Bio::LocationI;\n\nuse base qw(Bio::Coordinate::Pair);\n\n\nsub new {\n    my($class,@args) = @_;\n    my $self = $class->SUPER::new(@args);\n\n    my($strict) =\n\t$self->_rearrange([qw(STRICT\n\t\t\t     )],\n\t\t\t @args);\n\n    $strict  && $self->strict($strict);\n    return $self;\n}\n\n\n=head2 strict\n\n Title   : strict\n Usage   : $obj->strict(1);\n Function: Set and read the strictness of the coordinate system.\n Example :\n Returns : value of input system\n Args    : boolean\n\n\nsub strict {\n   my ($self,$value) = @_;\n   if( defined $value) {\n       $self->{'_strict'} = 1 if $value;\n   }\n   return $self->{'_strict'};\n}\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($loc);\n Function: Map the location from the input coordinate system\n           to a new value in the output coordinate system.\n\n           In extrapolating coodinate system there is no location zero.\n           Locations are...\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple\n\n\nsub map {\n   my ($self,$value) = @_;\n\n   $self->throw(\"Need to pass me a value.\")\n       unless defined $value;\n   $self->throw(\"I need a Bio::Location, not [$value]\")\n       unless $value->isa('Bio::LocationI');\n   $self->throw(\"Input coordinate system not set\")\n       unless $self->in;\n   $self->throw(\"Output coordinate system not set\")\n       unless $self->out;\n\n   my $match;\n\n   if ($value->isa(\"Bio::Location::SplitLocationI\")) {\n\n       my $split = Bio::Coordinate::Result->new(-seq_id=>$self->out->seq_id);\n       foreach my $loc ( sort { $a->start <=> $b->start }\n                         $value->sub_Location ) {\n\n           $match = $self->_map($loc);\n           $split->add_sub_Location($match) if $match;\n\n       }\n       $split->each_Location ? (return $split) : return ;\n\n   } else {\n       return $self->_map($value);\n   }\n}\n\n\n=head2 _map\n\n Title   : _map\n Usage   : $newpos = $obj->_map($simpleloc);\n Function: Internal method that does the actual mapping. Called\n           multiple times by map() if the location to be mapped is a\n           split location\n\n Example :\n Returns : new location in the output coordinate system or undef\n Args    : Bio::Location::Simple"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_map","line":209,"kind":13},{"line":209,"kind":13,"name":"$value","containerName":"_map"},{"localvar":"my","definition":"my","name":"$offset","containerName":"_map","line":211,"kind":13},{"name":"$start","containerName":"_map","kind":13,"line":211},{"kind":13,"line":211,"containerName":"_map","name":"$end"},{"line":213,"kind":13,"name":"$self","containerName":"_map"},{"containerName":"_map","name":"strand","kind":12,"line":213},{"name":"$offset","containerName":"_map","line":214,"kind":13},{"containerName":"_map","name":"$self","line":214,"kind":13},{"containerName":"_map","name":"in","line":214,"kind":12},{"name":"end","containerName":"_map","kind":12,"line":214},{"line":214,"kind":13,"containerName":"_map","name":"$self"},{"line":214,"kind":12,"containerName":"_map","name":"out"},{"line":214,"kind":12,"containerName":"_map","name":"start"},{"name":"$start","containerName":"_map","kind":13,"line":215},{"line":215,"kind":13,"containerName":"_map","name":"$offset"},{"name":"$value","containerName":"_map","line":215,"kind":13},{"containerName":"_map","name":"end","line":215,"kind":12},{"name":"$end","containerName":"_map","line":216,"kind":13},{"kind":13,"line":216,"containerName":"_map","name":"$offset"},{"line":216,"kind":13,"containerName":"_map","name":"$value"},{"kind":12,"line":216,"containerName":"_map","name":"start"},{"containerName":"_map","name":"$offset","kind":13,"line":218},{"kind":13,"line":218,"name":"$self","containerName":"_map"},{"name":"in","containerName":"_map","kind":12,"line":218},{"kind":12,"line":218,"containerName":"_map","name":"start"},{"kind":13,"line":218,"containerName":"_map","name":"$self"},{"containerName":"_map","name":"out","line":218,"kind":12},{"line":218,"kind":12,"containerName":"_map","name":"start"},{"line":219,"kind":13,"name":"$start","containerName":"_map"},{"containerName":"_map","name":"$value","line":219,"kind":13},{"containerName":"_map","name":"start","kind":12,"line":219},{"name":"$offset","containerName":"_map","kind":13,"line":219},{"line":220,"kind":13,"name":"$end","containerName":"_map"},{"name":"$value","containerName":"_map","kind":13,"line":220},{"name":"end","containerName":"_map","line":220,"kind":12},{"line":220,"kind":13,"containerName":"_map","name":"$offset"},{"name":"$self","containerName":"_map","kind":13,"line":224},{"containerName":"_map","name":"strict","line":224,"kind":12},{"name":"$start","containerName":"_map","line":225,"kind":13},{"line":225,"kind":13,"name":"$end","containerName":"_map"},{"line":226,"kind":13,"containerName":"_map","name":"$start"},{"name":"$self","containerName":"_map","kind":13,"line":226},{"kind":12,"line":226,"containerName":"_map","name":"out"},{"line":226,"kind":12,"name":"end","containerName":"_map"},{"containerName":"_map","name":"$start","kind":13,"line":227},{"containerName":"_map","name":"$start","line":227,"kind":13},{"name":"$end","containerName":"_map","line":228,"kind":13},{"kind":13,"line":228,"name":"$self","containerName":"_map"},{"line":228,"kind":12,"containerName":"_map","name":"out"},{"name":"end","containerName":"_map","line":228,"kind":12},{"line":228,"kind":13,"containerName":"_map","name":"$end"},{"containerName":"_map","name":"$self","line":228,"kind":13},{"kind":12,"line":228,"containerName":"_map","name":"out"},{"kind":12,"line":228,"containerName":"_map","name":"end"},{"kind":13,"line":231,"containerName":"_map","name":"$match","definition":"my","localvar":"my"},{"line":232,"kind":12,"name":"new","containerName":"_map"},{"line":232,"kind":13,"name":"$start","containerName":"_map"},{"kind":13,"line":233,"name":"$end","containerName":"_map"},{"containerName":"_map","name":"$self","line":234,"kind":13},{"kind":12,"line":234,"containerName":"_map","name":"strand"},{"containerName":"_map","name":"$self","kind":13,"line":235},{"containerName":"_map","name":"out","line":235,"kind":12},{"name":"seq_id","containerName":"_map","kind":12,"line":235},{"name":"$value","containerName":"_map","line":236,"kind":13},{"kind":12,"line":237,"containerName":"_map","name":"location_type"},{"name":"$match","containerName":"_map","kind":13,"line":238},{"line":238,"kind":12,"name":"strand","containerName":"_map"},{"name":"$match","containerName":"_map","kind":13,"line":238},{"containerName":"_map","name":"strand","kind":12,"line":238},{"kind":13,"line":238,"containerName":"_map","name":"$value"},{"kind":12,"line":238,"containerName":"_map","name":"strand"},{"containerName":"_map","name":"$value","kind":13,"line":238},{"containerName":"_map","name":"strand","line":238,"kind":12},{"line":239,"kind":13,"name":"$match","containerName":"_map"},{"containerName":"_map","name":"$match","line":241,"kind":13}],"line":208,"kind":12,"range":{"start":{"character":0,"line":208},"end":{"line":242,"character":9999}},"name":"_map"},{"name":"Bio","containerName":"Location::Simple","kind":12,"line":231}],"version":5}