{"version":5,"vars":[{"name":"base","containerName":"","line":111,"kind":2},{"name":"map","range":{"start":{"line":125,"character":0},"end":{"line":145,"character":9999}},"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"map($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Chain.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Chain - Mapping locations through a chain of  coordinate mappers\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs, or any MapperIs, somehow\n  $pair1; $pair2;\n\n  # add them into a Chain\n  $collection = Bio::Coordinate::Chain->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $match = $collection->map($pos);\n  if ($match) {\n      sprintf \"Matches at %d-%d\\n\", $match->start, $match->end,\n  } else {\n      print \"No match\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis class assumes that you have built several mappers and want to\nlink them together so that output from the previous mapper is the next\nmappers input. This way you can build arbitrarily complex mappers from\nsimpler components.\n\nNote that Chain does not do any sanity checking on its mappers. You\nare solely responsible that input and output coordinate systems,\ndirection of mapping and parameters internal to mappers make sense\nwhen chained together.\n\nTo put it bluntly, the present class is just a glorified foreach loop\nover an array of mappers calling the map method.\n\nIt would be neat to an internal function that would generate a new\nsingle step mapper from those included in the chain. It should speed\nthings up considerably. Any volunteers?\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Chain;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Root::Root;\nuse Bio::Coordinate::Result;\n\nuse base qw(Bio::Coordinate::Collection Bio::Coordinate::MapperI);\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location through all the mappers in the chain.\n Example :\n Returns : new Location in the output coordiante system\n Args    : a Bio::Location::Simple object"},"kind":12,"line":125,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"map","line":126,"kind":13},{"name":"$value","containerName":"map","kind":13,"line":126},{"name":"$self","containerName":"map","line":128,"kind":13},{"name":"throw","containerName":"map","kind":12,"line":128},{"name":"$value","containerName":"map","line":129,"kind":13},{"containerName":"map","name":"$self","line":130,"kind":13},{"name":"throw","containerName":"map","line":130,"kind":12},{"line":131,"kind":13,"name":"$value","containerName":"map"},{"line":131,"kind":12,"name":"isa","containerName":"map"},{"containerName":"map","name":"$self","line":132,"kind":13},{"name":"throw","containerName":"map","line":132,"kind":12},{"kind":13,"line":133,"containerName":"map","name":"$self"},{"kind":12,"line":133,"containerName":"map","name":"each_mapper"},{"kind":13,"line":135,"definition":"my","name":"$res","containerName":"map","localvar":"my"},{"name":"new","containerName":"map","line":135,"kind":12},{"line":137,"kind":13,"localvar":"my","name":"$mapper","definition":"my","containerName":"map"},{"containerName":"map","name":"$self","line":137,"kind":13},{"line":137,"kind":12,"name":"each_mapper","containerName":"map"},{"kind":13,"line":139,"containerName":"map","definition":"my","name":"$res","localvar":"my"},{"containerName":"map","name":"$mapper","line":139,"kind":13},{"containerName":"map","name":"map","kind":12,"line":139},{"containerName":"map","name":"$value","kind":13,"line":139},{"name":"$res","containerName":"map","kind":13,"line":140},{"containerName":"map","name":"each_match","kind":12,"line":140},{"name":"$value","containerName":"map","line":141,"kind":13},{"kind":13,"line":141,"containerName":"map","name":"$res"},{"kind":12,"line":141,"name":"match","containerName":"map"},{"name":"$value","containerName":"map","kind":13,"line":144}]},{"containerName":"Coordinate::Result","name":"Bio","line":135,"kind":12},{"line":211,"children":[{"definition":"my","name":"$self","containerName":"sort","localvar":"my","kind":13,"line":212},{"line":213,"kind":13,"containerName":"sort","name":"$self"},{"containerName":"sort","name":"warn","kind":12,"line":213}],"kind":12,"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Chain.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# bioperl module for Bio::Coordinate::Chain\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Heikki Lehvaslaiho <heikki-at-bioperl-dot-org>\n#\n# Copyright Heikki Lehvaslaiho\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Coordinate::Chain - Mapping locations through a chain of  coordinate mappers\n\n=head1 SYNOPSIS\n\n  # create Bio::Coordinate::Pairs, or any MapperIs, somehow\n  $pair1; $pair2;\n\n  # add them into a Chain\n  $collection = Bio::Coordinate::Chain->new;\n  $collection->add_mapper($pair1);\n  $collection->add_mapper($pair2);\n\n  # create a position and map it\n  $pos = Bio::Location::Simple->new (-start => 5, -end => 9 );\n  $match = $collection->map($pos);\n  if ($match) {\n      sprintf \"Matches at %d-%d\\n\", $match->start, $match->end,\n  } else {\n      print \"No match\\n\";\n  }\n\n=head1 DESCRIPTION\n\nThis class assumes that you have built several mappers and want to\nlink them together so that output from the previous mapper is the next\nmappers input. This way you can build arbitrarily complex mappers from\nsimpler components.\n\nNote that Chain does not do any sanity checking on its mappers. You\nare solely responsible that input and output coordinate systems,\ndirection of mapping and parameters internal to mappers make sense\nwhen chained together.\n\nTo put it bluntly, the present class is just a glorified foreach loop\nover an array of mappers calling the map method.\n\nIt would be neat to an internal function that would generate a new\nsingle step mapper from those included in the chain. It should speed\nthings up considerably. Any volunteers?\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to the\nBioperl mailing lists  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Heikki Lehvaslaiho\n\nEmail:  heikki-at-bioperl-dot-org\n\n=head1 CONTRIBUTORS\n\nEwan Birney, birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Coordinate::Chain;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\nuse Bio::Root::Root;\nuse Bio::Coordinate::Result;\n\nuse base qw(Bio::Coordinate::Collection Bio::Coordinate::MapperI);\n\n\n=head2 map\n\n Title   : map\n Usage   : $newpos = $obj->map($pos);\n Function: Map the location through all the mappers in the chain.\n Example :\n Returns : new Location in the output coordiante system\n Args    : a Bio::Location::Simple object\n\n\nsub map {\n    my ($self,$value) = @_;\n\n    $self->throw(\"Need to pass me a value.\")\n\tunless defined $value;\n    $self->throw(\"I need a Bio::Location, not [$value]\")\n\tunless $value->isa('Bio::LocationI');\n    $self->throw(\"No coordinate mappers!\")\n\tunless $self->each_mapper;\n\n    my $res = Bio::Coordinate::Result->new();\n\n    foreach my $mapper ($self->each_mapper) {\n\n\tmy $res = $mapper->map($value);\n\treturn unless $res->each_match;\n\t$value = $res->match;\n    }\n\n   return $value;\n}\n\n\n=head2 Inherited methods\n\n\n=head2 add_mapper\n\n Title   : add_mapper\n Usage   : $obj->add_mapper($mapper)\n Function: Pushes one Bio::Coodinate::MapperI into the list of mappers.\n           Sets _is_sorted() to false.\n Example : \n Returns : 1 when succeeds, 0 for failure.\n Args    : mapper object\n\n\n=head2 mappers\n\n Title   : mappers\n Usage   : $obj->mappers();\n Function: Returns or sets a list of mappers.\n Example : \n Returns : array of mappers\n Args    : array of mappers\n\n\n=head2 each_mapper\n\n Title   : each_mapper\n Usage   : $obj->each_mapper();\n Function: Returns a list of mappers.\n Example : \n Returns : array of mappers\n Args    : none\n\n\n=head2 swap\n\n Title   : swap\n Usage   : $obj->swap;\n Function: Swap the direction of mapping;input <-> output\n Example :\n Returns : 1\n Args    : \n\n\n=head2 test\n\n Title   : test\n Usage   : $obj->test;\n Function: test that both components of all pairs are of the same length.\n           Ran automatically.\n Example :\n Returns : boolean\n Args    :","label":"sort($self)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":211},"end":{"line":214,"character":9999}},"name":"sort"}]}