{"vars":[{"containerName":"","name":"base","line":194,"kind":2},{"kind":13,"line":196,"name":"%species_map","definition":"my","containerName":null,"localvar":"my"},{"name":"new","range":{"start":{"character":0,"line":258},"end":{"character":9999,"line":301}},"kind":12,"line":258,"children":[{"localvar":"my","name":"$caller","definition":"my","containerName":"new","line":260,"kind":13},{"line":260,"kind":13,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":261},{"line":261,"kind":13,"name":"$caller","containerName":"new"},{"kind":13,"line":261,"name":"@args","containerName":"new"},{"localvar":"my","name":"$ugid","definition":"my","containerName":"new","line":263,"kind":13},{"containerName":"new","name":"$desc","kind":13,"line":263},{"name":"$mems","containerName":"new","kind":13,"line":263},{"line":263,"kind":13,"containerName":"new","name":"$size"},{"containerName":"new","name":"$species","line":263,"kind":13},{"kind":13,"line":263,"name":"$dispid","containerName":"new"},{"kind":13,"line":263,"name":"$id","containerName":"new"},{"line":263,"kind":13,"containerName":"new","name":"$ns"},{"containerName":"new","name":"$auth","kind":13,"line":263},{"kind":13,"line":263,"name":"$v","containerName":"new"},{"line":263,"kind":13,"name":"$seqfact","containerName":"new"},{"name":"$self","containerName":"new","line":264,"kind":13},{"containerName":"new","name":"_rearrange","line":264,"kind":12},{"name":"@args","containerName":"new","kind":13,"line":275},{"kind":13,"line":277,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":279},{"containerName":"new","name":"unigene_id","line":279,"kind":12},{"line":279,"kind":13,"name":"$ugid","containerName":"new"},{"line":279,"kind":13,"containerName":"new","name":"$ugid"},{"kind":13,"line":280,"name":"$self","containerName":"new"},{"name":"description","containerName":"new","kind":12,"line":280},{"kind":13,"line":280,"name":"$desc","containerName":"new"},{"line":280,"kind":13,"containerName":"new","name":"$desc"},{"line":281,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"sequences","kind":12,"line":281},{"line":281,"kind":13,"name":"$mems","containerName":"new"},{"line":281,"kind":13,"name":"$mems","containerName":"new"},{"line":282,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":282,"name":"size","containerName":"new"},{"kind":13,"line":282,"containerName":"new","name":"$size"},{"containerName":"new","name":"$size","kind":13,"line":282},{"name":"$self","containerName":"new","line":283,"kind":13},{"kind":12,"line":283,"containerName":"new","name":"display_id"},{"kind":13,"line":283,"name":"$dispid","containerName":"new"},{"kind":13,"line":283,"name":"$dispid","containerName":"new"},{"containerName":"new","name":"$self","line":284,"kind":13},{"line":284,"kind":12,"containerName":"new","name":"object_id"},{"line":284,"kind":13,"name":"$id","containerName":"new"},{"containerName":"new","name":"$id","kind":13,"line":284},{"name":"$self","containerName":"new","kind":13,"line":285},{"kind":12,"line":285,"name":"namespace","containerName":"new"},{"name":"$ns","containerName":"new","line":285,"kind":13},{"kind":13,"line":286,"name":"$self","containerName":"new"},{"name":"authority","containerName":"new","kind":12,"line":286},{"name":"$auth","containerName":"new","line":286,"kind":13},{"name":"$self","containerName":"new","line":287,"kind":13},{"kind":12,"line":287,"name":"version","containerName":"new"},{"line":287,"kind":13,"name":"$v","containerName":"new"},{"name":"$v","containerName":"new","line":287,"kind":13},{"line":288,"kind":13,"name":"$seqfact","containerName":"new"},{"kind":13,"line":289,"containerName":"new","name":"$seqfact"},{"name":"new","containerName":"new","line":290,"kind":12},{"line":290,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"verbose","kind":12,"line":290},{"containerName":"new","name":"$self","line":293,"kind":13},{"kind":12,"line":293,"name":"sequence_factory","containerName":"new"},{"line":293,"kind":13,"name":"$seqfact","containerName":"new"},{"line":294,"kind":13,"name":"$species","containerName":"new"},{"line":294,"kind":13,"containerName":"new","name":"$self"},{"line":294,"kind":12,"containerName":"new","name":"unigene_id"},{"containerName":"new","name":"$self","kind":13,"line":295},{"line":295,"kind":12,"containerName":"new","name":"unigene_id"},{"line":297,"kind":13,"name":"$species","containerName":"new"},{"name":"$species_map","containerName":"new","line":297,"kind":13},{"kind":13,"line":299,"name":"$self","containerName":"new"},{"containerName":"new","name":"species","kind":12,"line":299},{"line":299,"kind":13,"containerName":"new","name":"$species"},{"name":"$self","containerName":"new","line":300,"kind":13}],"containerName":"main::","definition":"sub","detail":"($caller,@args)","signature":{"parameters":[{"label":"$caller"},{"label":"@args"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object","label":"new($caller,@args)"}},{"name":"SUPER","containerName":"new","kind":12,"line":261},{"name":"Bio","containerName":"Seq::SeqFactory","kind":12,"line":289},{"range":{"start":{"character":0,"line":320},"end":{"character":9999,"line":326}},"name":"unigene_id","line":320,"children":[{"name":"$obj","definition":"my","containerName":"unigene_id","localvar":"my","kind":13,"line":321},{"name":"$value","containerName":"unigene_id","kind":13,"line":321},{"name":"$value","containerName":"unigene_id","line":322,"kind":13},{"containerName":"unigene_id","name":"$obj","kind":13,"line":323},{"containerName":"unigene_id","name":"$value","kind":13,"line":323},{"name":"$obj","containerName":"unigene_id","line":325,"kind":13}],"kind":12,"detail":"($obj,$value)","signature":{"parameters":[{"label":"$obj"},{"label":"$value"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id","label":"unigene_id($obj,$value)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title","parameters":[{"label":"$obj"},{"label":"$value"}],"label":"title($obj,$value)"},"detail":"($obj,$value)","kind":12,"children":[{"line":343,"kind":13,"localvar":"my","name":"$obj","definition":"my","containerName":"title"},{"line":343,"kind":13,"name":"$value","containerName":"title"},{"line":344,"kind":13,"name":"$value","containerName":"title"},{"containerName":"title","name":"$obj","kind":13,"line":345},{"containerName":"title","name":"$value","line":345,"kind":13},{"name":"$obj","containerName":"title","kind":13,"line":347}],"line":342,"name":"title","range":{"start":{"line":342,"character":0},"end":{"line":348,"character":9999}}},{"range":{"end":{"character":9999,"line":366},"start":{"line":363,"character":0}},"name":"gene","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"gene","definition":"my","name":"$self","line":364,"kind":13},{"containerName":"gene","name":"$self","line":365,"kind":13},{"containerName":"gene","name":"_annotation_value","kind":12,"line":365}],"line":363,"kind":12},{"kind":12,"line":381,"children":[{"containerName":"cytoband","definition":"my","name":"$self","localvar":"my","kind":13,"line":382},{"containerName":"cytoband","name":"$self","kind":13,"line":383},{"name":"_annotation_value","containerName":"cytoband","kind":12,"line":383}],"containerName":"main::","definition":"sub","name":"cytoband","range":{"start":{"character":0,"line":381},"end":{"character":9999,"line":384}}},{"kind":12,"children":[{"kind":13,"line":399,"name":"$self","definition":"my","containerName":"mgi","localvar":"my"},{"kind":13,"line":400,"definition":"my","name":"$acc","containerName":"mgi","localvar":"my"},{"name":"$self","containerName":"mgi","line":404,"kind":13},{"kind":12,"line":404,"name":"_remove_dblink","containerName":"mgi"},{"name":"$acc","containerName":"mgi","line":406,"kind":13},{"kind":13,"line":407,"containerName":"mgi","name":"$self"},{"kind":12,"line":407,"containerName":"mgi","name":"_annotation_dblink"},{"name":"$acc","containerName":"mgi","line":407,"kind":13},{"containerName":"mgi","name":"$acc","kind":13,"line":410},{"kind":13,"line":410,"name":"$self","containerName":"mgi"},{"name":"_annotation_dblink","containerName":"mgi","kind":12,"line":410},{"name":"$acc","containerName":"mgi","line":412,"kind":13}],"line":398,"name":"mgi","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":413},"start":{"line":398,"character":0}}},{"range":{"end":{"character":9999,"line":441},"start":{"character":0,"line":426}},"name":"locuslink","children":[{"definition":"my","name":"$self","containerName":"locuslink","localvar":"my","kind":13,"line":427},{"kind":13,"line":427,"name":"$ll","containerName":"locuslink"},{"kind":13,"line":429,"containerName":"locuslink","name":"$ll"},{"line":431,"kind":13,"name":"$self","containerName":"locuslink"},{"line":431,"kind":12,"containerName":"locuslink","name":"_remove_dblink"},{"name":"$acc","definition":"my","containerName":"locuslink","localvar":"my","kind":13,"line":433},{"kind":13,"line":433,"name":"$ll","containerName":"locuslink"},{"line":434,"kind":13,"containerName":"locuslink","name":"$self"},{"name":"_annotation_dblink","containerName":"locuslink","line":434,"kind":12},{"line":434,"kind":13,"containerName":"locuslink","name":"$acc"},{"containerName":"locuslink","definition":"my","name":"@accs","localvar":"my","kind":13,"line":437},{"line":437,"kind":13,"containerName":"locuslink","name":"$self"},{"containerName":"locuslink","name":"_annotation_dblink","kind":12,"line":437},{"line":438,"kind":13,"name":"$ll","containerName":"locuslink"},{"line":438,"kind":13,"name":"@accs","containerName":"locuslink"},{"containerName":"locuslink","name":"$ll","kind":13,"line":440}],"line":426,"kind":12,"signature":{"label":"locuslink($self,$ll)","documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference","parameters":[{"label":"$self"},{"label":"$ll"}]},"detail":"($self,$ll)","definition":"sub","containerName":"main::"},{"children":[{"line":456,"kind":13,"localvar":"my","containerName":"homol","definition":"my","name":"$self"},{"containerName":"homol","name":"$self","kind":13,"line":457},{"kind":12,"line":457,"name":"_annotation_value","containerName":"homol"}],"line":455,"kind":12,"range":{"start":{"line":455,"character":0},"end":{"line":458,"character":9999}},"definition":"sub","name":"homol","containerName":"main::"},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"restr_expr","line":473,"kind":13},{"name":"$self","containerName":"restr_expr","line":474,"kind":13},{"name":"_annotation_value","containerName":"restr_expr","line":474,"kind":12}],"line":472,"kind":12,"range":{"start":{"line":472,"character":0},"end":{"line":475,"character":9999}},"name":"restr_expr","definition":"sub","containerName":"main::"},{"containerName":"main::","name":"gnm_terminus","definition":"sub","range":{"end":{"line":493,"character":9999},"start":{"line":490,"character":0}},"kind":12,"line":490,"children":[{"definition":"my","name":"$self","containerName":"gnm_terminus","localvar":"my","kind":13,"line":491},{"kind":13,"line":492,"name":"$self","containerName":"gnm_terminus"},{"containerName":"gnm_terminus","name":"_annotation_value","kind":12,"line":492}]},{"name":"scount","range":{"end":{"line":514,"character":9999},"start":{"character":0,"line":506}},"kind":12,"line":506,"children":[{"name":"$obj","definition":"my","containerName":"scount","localvar":"my","kind":13,"line":507},{"name":"$value","containerName":"scount","line":507,"kind":13},{"name":"$value","containerName":"scount","kind":13,"line":508},{"kind":13,"line":509,"name":"$obj","containerName":"scount"},{"containerName":"scount","name":"$value","kind":13,"line":509},{"name":"$obj","containerName":"scount","kind":13,"line":510},{"kind":13,"line":510,"containerName":"scount","name":"$obj"},{"line":510,"kind":12,"containerName":"scount","name":"sequences"},{"kind":13,"line":511,"name":"$obj","containerName":"scount"},{"containerName":"scount","name":"$obj","line":511,"kind":13},{"containerName":"scount","name":"size","kind":12,"line":511},{"kind":13,"line":513,"containerName":"scount","name":"$obj"}],"containerName":"main::","definition":"sub","detail":"($obj,$value)","signature":{"label":"scount($obj,$value)","documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount","parameters":[{"label":"$obj"},{"label":"$value"}]}},{"kind":12,"line":528,"children":[{"containerName":"express","definition":"my","name":"$self","localvar":"my","kind":13,"line":529},{"line":531,"kind":13,"containerName":"express","name":"$self"},{"line":531,"kind":12,"name":"_annotation_value_ary","containerName":"express"}],"containerName":"main::","name":"express","definition":"sub","range":{"start":{"character":0,"line":528},"end":{"character":9999,"line":532}}},{"containerName":"main::","definition":"sub","name":"chromosome","range":{"end":{"character":9999,"line":550},"start":{"line":546,"character":0}},"kind":12,"line":546,"children":[{"kind":13,"line":547,"definition":"my","name":"$self","containerName":"chromosome","localvar":"my"},{"kind":13,"line":549,"name":"$self","containerName":"chromosome"},{"name":"_annotation_value_ary","containerName":"chromosome","line":549,"kind":12}]},{"kind":12,"line":564,"children":[{"line":565,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"sts"},{"line":567,"kind":13,"containerName":"sts","name":"$self"},{"containerName":"sts","name":"_annotation_value_ary","line":567,"kind":12}],"containerName":"main::","definition":"sub","name":"sts","range":{"end":{"character":9999,"line":568},"start":{"character":0,"line":564}}},{"line":582,"children":[{"kind":13,"line":583,"name":"$self","definition":"my","containerName":"txmap","localvar":"my"},{"name":"$self","containerName":"txmap","kind":13,"line":585},{"containerName":"txmap","name":"_annotation_value_ary","line":585,"kind":12}],"kind":12,"range":{"start":{"line":582,"character":0},"end":{"line":586,"character":9999}},"containerName":"main::","definition":"sub","name":"txmap"},{"kind":12,"children":[{"line":601,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"protsim"},{"line":603,"kind":13,"containerName":"protsim","name":"$self"},{"name":"_annotation_value_ary","containerName":"protsim","kind":12,"line":603}],"line":600,"name":"protsim","definition":"sub","containerName":"main::","range":{"end":{"line":604,"character":9999},"start":{"line":600,"character":0}}},{"range":{"start":{"character":0,"line":623},"end":{"character":9999,"line":628}},"containerName":"main::","name":"sequences","definition":"sub","line":623,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"sequences","line":624,"kind":13},{"name":"$self","containerName":"sequences","line":626,"kind":13},{"kind":13,"line":627,"containerName":"sequences","name":"$self"}],"kind":12},{"range":{"start":{"line":643,"character":0},"end":{"character":9999,"line":655}},"name":"species","definition":"sub","containerName":"main::","children":[{"line":644,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"species"},{"kind":13,"line":647,"name":"$species","definition":"my","containerName":"species","localvar":"my"},{"name":"$species","containerName":"species","kind":13,"line":648},{"kind":13,"line":648,"name":"$species","containerName":"species"},{"containerName":"species","name":"@class","definition":"my","localvar":"my","kind":13,"line":649},{"line":649,"kind":13,"containerName":"species","name":"$species"},{"name":"$species","containerName":"species","kind":13,"line":650},{"name":"new","containerName":"species","kind":12,"line":650},{"name":"@class","containerName":"species","line":650,"kind":13},{"containerName":"species","name":"$self","line":652,"kind":13},{"kind":13,"line":652,"name":"$species","containerName":"species"},{"line":654,"kind":13,"containerName":"species","name":"$self"}],"line":643,"kind":12},{"line":650,"kind":12,"name":"Bio","containerName":"Species"},{"kind":12,"line":675,"children":[{"containerName":"display_id","name":"unigene_id","line":676,"kind":12}],"containerName":"main::","definition":"sub","name":"display_id","range":{"start":{"character":0,"line":675},"end":{"line":677,"character":9999}}},{"containerName":"main::","name":"description","definition":"sub","range":{"end":{"character":9999,"line":694},"start":{"character":0,"line":692}},"kind":12,"line":692,"children":[{"line":693,"kind":12,"containerName":"description","name":"title"}]},{"line":710,"children":[{"localvar":"my","containerName":"size","name":"$self","definition":"my","line":711,"kind":13},{"line":714,"kind":13,"name":"$self","containerName":"size"},{"kind":12,"line":714,"name":"scount","containerName":"size"},{"kind":13,"line":714,"name":"$self","containerName":"size"},{"containerName":"size","name":"sequences","kind":12,"line":714},{"kind":13,"line":716,"definition":"my","name":"$n","containerName":"size","localvar":"my"},{"name":"$self","containerName":"size","line":716,"kind":13},{"line":716,"kind":12,"name":"sequences","containerName":"size"}],"kind":12,"range":{"end":{"character":9999,"line":716},"start":{"character":0,"line":710}},"containerName":"main::","name":"size","definition":"sub"},{"line":717,"kind":13,"containerName":null,"name":"@n"},{"containerName":null,"name":"$self","line":718,"kind":13},{"containerName":"main::","name":"throw","kind":12,"line":718},{"line":721,"kind":13,"containerName":null,"name":"$n"},{"containerName":"main::","definition":"sub","name":"cluster_score","range":{"start":{"line":742,"character":0},"end":{"character":9999,"line":747}},"kind":12,"line":742,"children":[{"containerName":"cluster_score","definition":"my","name":"$self","localvar":"my","kind":13,"line":743},{"name":"$self","containerName":"cluster_score","line":745,"kind":13},{"containerName":"cluster_score","name":"$self","kind":13,"line":746}]},{"range":{"start":{"character":0,"line":765},"end":{"character":9999,"line":782}},"containerName":"main::","definition":"sub","name":"get_members","line":765,"children":[{"line":766,"kind":13,"localvar":"my","containerName":"get_members","name":"$self","definition":"my"},{"line":768,"kind":13,"localvar":"my","containerName":"get_members","definition":"my","name":"$mems"},{"containerName":"get_members","name":"$self","line":768,"kind":13},{"containerName":"get_members","name":"sequences","kind":12,"line":768},{"line":770,"kind":13,"name":"$mems","containerName":"get_members"},{"kind":13,"line":770,"containerName":"get_members","name":"$mems"},{"localvar":"my","definition":"my","name":"@memlist","containerName":"get_members","line":772,"kind":13},{"containerName":"get_members","definition":"my","name":"$seq","localvar":"my","kind":13,"line":773},{"line":773,"kind":13,"name":"$self","containerName":"get_members"},{"containerName":"get_members","name":"next_seq","line":773,"kind":12},{"containerName":"get_members","name":"@memlist","line":774,"kind":13},{"kind":13,"line":774,"containerName":"get_members","name":"$seq"},{"name":"$mems","containerName":"get_members","kind":13,"line":777},{"containerName":"get_members","name":"@memlist","kind":13,"line":777},{"containerName":"get_members","name":"$self","kind":13,"line":778},{"containerName":"get_members","name":"sequences","kind":12,"line":778},{"containerName":"get_members","name":"$mems","line":778,"kind":13},{"name":"$mems","containerName":"get_members","line":781,"kind":13}],"kind":12},{"definition":"sub","name":"annotation","containerName":"main::","range":{"start":{"line":814,"character":0},"end":{"line":823,"character":9999}},"kind":12,"children":[{"line":815,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"annotation"},{"containerName":"annotation","name":"$self","line":818,"kind":13},{"name":"$self","containerName":"annotation","kind":13,"line":819},{"name":"$self","containerName":"annotation","line":820,"kind":13},{"name":"new","containerName":"annotation","line":820,"kind":12},{"containerName":"annotation","name":"$self","line":822,"kind":13}],"line":814},{"line":820,"kind":12,"containerName":"Annotation::Collection","name":"Bio"},{"name":"add_member","range":{"start":{"line":846,"character":0},"end":{"character":9999,"line":861}},"kind":12,"line":846,"children":[{"line":847,"kind":13,"localvar":"my","containerName":"add_member","name":"$self","definition":"my"},{"kind":13,"line":847,"name":"@mems","containerName":"add_member"},{"name":"$memlist","definition":"my","containerName":"add_member","localvar":"my","kind":13,"line":849},{"containerName":"add_member","name":"$self","line":849,"kind":13},{"kind":13,"line":851,"name":"$memlist","containerName":"add_member"},{"containerName":"add_member","name":"$memlist","kind":13,"line":851},{"line":853,"kind":13,"containerName":"add_member","name":"$memlist"},{"name":"$self","containerName":"add_member","kind":13,"line":853},{"line":853,"kind":12,"containerName":"add_member","name":"get_members"},{"line":856,"kind":13,"containerName":"add_member","name":"$memlist"},{"line":856,"kind":13,"containerName":"add_member","name":"@mems"},{"containerName":"add_member","name":"$self","line":858,"kind":13},{"line":858,"kind":12,"containerName":"add_member","name":"sequences"},{"line":858,"kind":13,"name":"$memlist","containerName":"add_member"}],"containerName":"main::","definition":"sub","detail":"($self,@mems)","signature":{"label":"add_member($self,@mems)","documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.","parameters":[{"label":"$self"},{"label":"@mems"}]}},{"kind":12,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"remove_members","line":877,"kind":13},{"localvar":"my","containerName":"remove_members","name":"@mems","definition":"my","line":879,"kind":13},{"line":879,"kind":13,"containerName":"remove_members","name":"$self"},{"name":"get_members","containerName":"remove_members","kind":12,"line":879},{"containerName":"remove_members","name":"$self","kind":13,"line":880},{"containerName":"remove_members","name":"sequences","line":880,"kind":12},{"line":881,"kind":13,"containerName":"remove_members","name":"@mems"}],"line":876,"definition":"sub","name":"remove_members","containerName":"main::","range":{"end":{"line":882,"character":9999},"start":{"line":876,"character":0}}},{"name":"next_locuslink","range":{"end":{"line":909,"character":9999},"start":{"line":905,"character":0}},"kind":12,"line":905,"children":[{"kind":13,"line":906,"containerName":"next_locuslink","definition":"my","name":"$obj","localvar":"my"},{"name":"$obj","containerName":"next_locuslink","line":908,"kind":13},{"line":908,"kind":12,"containerName":"next_locuslink","name":"_next_element"}],"containerName":"main::","definition":"sub","detail":"($obj)","signature":{"label":"next_locuslink($obj)","parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None"}},{"range":{"end":{"character":9999,"line":935},"start":{"character":0,"line":931}},"name":"next_express","detail":"($obj)","signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None","parameters":[{"label":"$obj"}],"label":"next_express($obj)"},"containerName":"main::","definition":"sub","line":931,"children":[{"kind":13,"line":932,"definition":"my","name":"$obj","containerName":"next_express","localvar":"my"},{"kind":13,"line":934,"name":"$obj","containerName":"next_express"},{"name":"_next_element","containerName":"next_express","kind":12,"line":934}],"kind":12},{"name":"next_chromosome","range":{"end":{"character":9999,"line":962},"start":{"line":958,"character":0}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None","parameters":[{"label":"$obj"}],"label":"next_chromosome($obj)"},"detail":"($obj)","kind":12,"children":[{"localvar":"my","containerName":"next_chromosome","name":"$obj","definition":"my","line":959,"kind":13},{"name":"$obj","containerName":"next_chromosome","kind":13,"line":961},{"line":961,"kind":12,"containerName":"next_chromosome","name":"_next_element"}],"line":958},{"name":"next_protsim","range":{"end":{"line":989,"character":9999},"start":{"character":0,"line":985}},"kind":12,"line":985,"children":[{"kind":13,"line":986,"name":"$obj","definition":"my","containerName":"next_protsim","localvar":"my"},{"line":988,"kind":13,"name":"$obj","containerName":"next_protsim"},{"name":"_next_element","containerName":"next_protsim","line":988,"kind":12}],"containerName":"main::","definition":"sub","detail":"($obj)","signature":{"parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None","label":"next_protsim($obj)"}},{"range":{"end":{"character":9999,"line":1016},"start":{"line":1012,"character":0}},"name":"next_sts","line":1012,"children":[{"line":1013,"kind":13,"localvar":"my","containerName":"next_sts","definition":"my","name":"$obj"},{"name":"$obj","containerName":"next_sts","kind":13,"line":1015},{"line":1015,"kind":12,"name":"_next_element","containerName":"next_sts"}],"kind":12,"detail":"($obj)","signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None","parameters":[{"label":"$obj"}],"label":"next_sts($obj)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None","label":"next_txmap($obj)"},"detail":"($obj)","kind":12,"children":[{"kind":13,"line":1040,"name":"$obj","definition":"my","containerName":"next_txmap","localvar":"my"},{"containerName":"next_txmap","name":"$obj","line":1042,"kind":13},{"containerName":"next_txmap","name":"_next_element","kind":12,"line":1042}],"line":1039,"name":"next_txmap","range":{"start":{"character":0,"line":1039},"end":{"line":1043,"character":9999}}},{"kind":12,"children":[{"localvar":"my","containerName":"_next_element","name":"$self","definition":"my","line":1053,"kind":13},{"containerName":"_next_element","name":"$queuename","kind":13,"line":1053},{"kind":13,"line":1053,"containerName":"_next_element","name":"$meth"},{"kind":13,"line":1055,"name":"$queuename","containerName":"_next_element"},{"line":1055,"kind":13,"name":"$queuename","containerName":"_next_element"},{"kind":13,"line":1056,"containerName":"_next_element","name":"$self"},{"line":1056,"kind":13,"containerName":"_next_element","name":"$queuename"},{"kind":13,"line":1058,"name":"$self","containerName":"_next_element"},{"name":"$queuename","containerName":"_next_element","kind":13,"line":1058},{"kind":13,"line":1058,"name":"$self","containerName":"_next_element"},{"containerName":"_next_element","name":"$meth","kind":13,"line":1058}],"line":1052,"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$queuename"},{"label":"$meth"}],"documentation":" private method\n\n args: prefix name for the queue\n       name of the method from which to re-fill\n returns: the next element from that queue, or undef if the queue is empty","label":"_next_element($self,$queuename,$meth)"},"detail":"($self,$queuename,$meth)","name":"_next_element","range":{"start":{"character":0,"line":1052},"end":{"character":9999,"line":1059}}},{"kind":13,"line":1060,"name":"$queue","definition":"my","containerName":null,"localvar":"my"},{"line":1060,"kind":13,"containerName":null,"name":"%self"},{"kind":13,"line":1060,"name":"$queuename","containerName":null},{"containerName":null,"name":"%queue","line":1062,"kind":13},{"kind":13,"line":1064,"containerName":null,"name":"%self"},{"containerName":null,"name":"$queuename","kind":13,"line":1064},{"name":"$queue","containerName":null,"kind":13,"line":1067},{"kind":12,"children":[{"containerName":"object_id","name":"unigene_id","kind":12,"line":1090}],"line":1089,"name":"object_id","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":1091},"start":{"character":0,"line":1089}}},{"line":1111,"children":[{"kind":13,"line":1112,"definition":"my","name":"$self","containerName":"version","localvar":"my"},{"kind":13,"line":1114,"name":"$self","containerName":"version"},{"name":"$self","containerName":"version","kind":13,"line":1115}],"kind":12,"range":{"end":{"line":1116,"character":9999},"start":{"character":0,"line":1111}},"containerName":"main::","definition":"sub","name":"version"},{"children":[{"kind":13,"line":1134,"definition":"my","name":"$self","containerName":"authority","localvar":"my"},{"containerName":"authority","name":"$self","line":1136,"kind":13},{"containerName":"authority","name":"$self","line":1137,"kind":13}],"line":1133,"kind":12,"range":{"end":{"line":1138,"character":9999},"start":{"line":1133,"character":0}},"definition":"sub","name":"authority","containerName":"main::"},{"containerName":"main::","definition":"sub","name":"namespace","range":{"start":{"line":1155,"character":0},"end":{"character":9999,"line":1160}},"kind":12,"line":1155,"children":[{"line":1156,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"namespace"},{"line":1158,"kind":13,"containerName":"namespace","name":"$self"},{"containerName":"namespace","name":"$self","kind":13,"line":1159}]},{"kind":12,"line":1183,"children":[{"name":"unigene_id","containerName":"display_name","kind":12,"line":1184}],"containerName":"main::","definition":"sub","name":"display_name","range":{"start":{"line":1183,"character":0},"end":{"line":1185,"character":9999}}},{"signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None","parameters":[{"label":"$obj"}],"label":"next_seq($obj)"},"detail":"($obj)","definition":"sub","containerName":"main::","children":[{"line":1235,"kind":13,"localvar":"my","name":"$obj","definition":"my","containerName":"next_seq"},{"line":1237,"kind":13,"name":"$obj","containerName":"next_seq"},{"name":"$obj","containerName":"next_seq","kind":13,"line":1239},{"name":"$obj","containerName":"next_seq","kind":13,"line":1239},{"name":"sequences","containerName":"next_seq","line":1239,"kind":12}],"line":1234,"kind":12,"range":{"start":{"line":1234,"character":0},"end":{"line":1240,"character":9999}},"name":"next_seq"},{"line":1241,"kind":13,"localvar":"my","name":"$queue","definition":"my","containerName":null},{"containerName":null,"name":"%obj","kind":13,"line":1241},{"line":1243,"kind":13,"name":"%queue","containerName":null},{"name":"%obj","containerName":null,"kind":13,"line":1245},{"kind":13,"line":1249,"containerName":null,"definition":"my","name":"$seq_h","localvar":"my"},{"containerName":null,"name":"$queue","line":1249,"kind":13},{"name":"$seq_h","containerName":null,"kind":13,"line":1252},{"kind":13,"line":1252,"name":"$seq_h","containerName":null},{"kind":13,"line":1256,"definition":"my","name":"$ac","containerName":null,"localvar":"my"},{"kind":12,"line":1256,"name":"Bio","containerName":"Annotation::Collection"},{"kind":12,"line":1256,"name":"new","containerName":"main::"},{"line":1257,"kind":13,"localvar":"my","containerName":null,"name":"$k","definition":"my"},{"kind":13,"line":1257,"containerName":null,"name":"%seq_h"},{"name":"$k","containerName":null,"kind":13,"line":1258},{"line":1259,"kind":13,"localvar":"my","name":"$ann","definition":"my","containerName":null},{"kind":12,"line":1259,"containerName":"Annotation::SimpleValue","name":"Bio"},{"kind":12,"line":1259,"containerName":"main::","name":"new"},{"kind":13,"line":1259,"containerName":null,"name":"$k"},{"line":1260,"kind":13,"containerName":null,"name":"%seq_h"},{"kind":13,"line":1260,"containerName":null,"name":"$k"},{"line":1261,"kind":13,"containerName":null,"name":"$ac"},{"name":"add_Annotation","containerName":"main::","line":1261,"kind":12},{"kind":13,"line":1261,"containerName":null,"name":"$ann"},{"containerName":null,"name":"$seqobj","definition":"my","localvar":"my","kind":13,"line":1264},{"containerName":null,"name":"$obj","line":1264,"kind":13},{"name":"sequence_factory","containerName":"main::","kind":12,"line":1264},{"containerName":"main::","name":"create","kind":12,"line":1264},{"kind":13,"line":1265,"containerName":null,"name":"%seq_h"},{"kind":12,"line":1265,"name":"acc"},{"name":"%seq_h","containerName":null,"kind":13,"line":1266},{"name":"pid","kind":12,"line":1266},{"name":"%seq_h","containerName":null,"line":1268,"kind":13},{"line":1268,"kind":12,"name":"nid"},{"containerName":null,"name":"%seq_h","line":1268,"kind":13},{"kind":12,"line":1268,"name":"nid"},{"kind":13,"line":1269,"name":"%seq_h","containerName":null},{"name":"nid","line":1269,"kind":12},{"line":1269,"kind":13,"containerName":null,"name":"%seq_h"},{"name":"nid","line":1269,"kind":12},{"kind":13,"line":1270,"containerName":null,"name":"%seq_h"},{"name":"acc","kind":12,"line":1270},{"name":"%seq_h","containerName":null,"kind":13,"line":1271},{"name":"version","kind":12,"line":1271},{"kind":13,"line":1272,"containerName":null,"name":"%obj"},{"line":1273,"kind":13,"name":"%seq_h","containerName":null},{"line":1273,"kind":12,"name":"acc"},{"kind":13,"line":1274,"containerName":null,"name":"$obj"},{"line":1274,"kind":12,"name":"authority","containerName":"main::"},{"line":1275,"kind":13,"containerName":null,"name":"$obj"},{"kind":12,"line":1275,"containerName":"main::","name":"species"},{"containerName":null,"name":"$ac","line":1277,"kind":13},{"line":1278,"kind":13,"containerName":null,"name":"$seqobj"},{"name":"sequence_factory","range":{"start":{"character":0,"line":1292},"end":{"character":9999,"line":1301}},"definition":"sub","containerName":"main::","signature":{"label":"sequence_factory($self,$obj)","parameters":[{"label":"$self"},{"label":"$obj"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None\n\n\nsub next_seq {\n    my ($obj) = @_;\n\n    if(! exists($obj->{'_seq_queue'})) {\n\t# re-initialize from array of sequence data\n\t$obj->{'_seq_queue'} = [@{$obj->sequences()}];\n    }\n    my $queue = $obj->{'_seq_queue'};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $obj->{'_seq_queue'};\n\treturn;\n    }\n    # no, still data in the queue: get the next one from the queue\n    my $seq_h = shift(@$queue);\n    # if this is not a simple hash ref, it's an object already, and we'll\n    # return just that\n    return $seq_h if(ref($seq_h) ne 'HASH');\n    # nope, we need to assemble this object from scratch\n    #\n    # assemble the annotation collection\n    my $ac = Bio::Annotation::Collection->new();\n    foreach my $k (keys %$seq_h) {\n\tnext if $k =~ /acc|pid|nid|version/;\n\tmy $ann = Bio::Annotation::SimpleValue->new(-tagname => $k,\n\t\t\t\t\t\t    -value   => $seq_h->{$k});\n\t$ac->add_Annotation($ann);\n    }\n    # assemble the initialization parameters and create object\n    my $seqobj = $obj->sequence_factory->create(\n\t  -accession_number => $seq_h->{acc},\n\t  -pid              => $seq_h->{pid},\n\t  # why does NCBI prepend a 'g' to its own identifiers??\n\t  -primary_id       => $seq_h->{nid} && $seq_h->{nid} =~ /^g\\d+$/ ?\n\t\t\t\t     substr($seq_h->{nid},1) : $seq_h->{nid},\n\t  -display_id       => $seq_h->{acc},\n\t  -seq_version\t    => $seq_h->{version},\n\t  -alphabet         => $obj->{'_alphabet'},\n\t  -namespace        => $seq_h->{acc} =~ /^NM_/ ? 'RefSeq' : 'GenBank',\n\t  -authority        => $obj->authority(), # default is NCBI\n\t  -species          => $obj->species(),\n\t  -annotation       => $ac\n\t  );\n    return $seqobj;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get/Set the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : [optional] Bio::Factory::SequenceFactoryI"},"detail":"($self,$obj)","kind":12,"children":[{"line":1293,"kind":13,"localvar":"my","containerName":"sequence_factory","definition":"my","name":"$self"},{"name":"$obj","containerName":"sequence_factory","line":1293,"kind":13},{"containerName":"sequence_factory","name":"$obj","kind":13,"line":1294},{"kind":13,"line":1295,"name":"$obj","containerName":"sequence_factory"},{"kind":13,"line":1295,"name":"$obj","containerName":"sequence_factory"},{"name":"isa","containerName":"sequence_factory","line":1295,"kind":12},{"line":1296,"kind":13,"containerName":"sequence_factory","name":"$self"},{"kind":12,"line":1296,"containerName":"sequence_factory","name":"throw"},{"line":1296,"kind":13,"containerName":"sequence_factory","name":"$self"},{"kind":13,"line":1298,"containerName":"sequence_factory","name":"$self"},{"kind":13,"line":1298,"name":"$obj","containerName":"sequence_factory"},{"name":"$self","containerName":"sequence_factory","line":1300,"kind":13}],"line":1292},{"containerName":"main::","name":"_annotation_value","definition":"sub","range":{"start":{"line":1320,"character":0},"end":{"character":9999,"line":1345}},"kind":12,"line":1320,"children":[{"line":1321,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_annotation_value"},{"localvar":"my","containerName":"_annotation_value","definition":"my","name":"$key","line":1322,"kind":13},{"kind":13,"line":1324,"name":"$ann","definition":"my","containerName":"_annotation_value","localvar":"my"},{"containerName":"_annotation_value","name":"$val","line":1324,"kind":13},{"name":"$val","containerName":"_annotation_value","kind":13,"line":1326},{"kind":13,"line":1327,"name":"$val","containerName":"_annotation_value"},{"containerName":"_annotation_value","name":"$ann","kind":13,"line":1328},{"line":1328,"kind":13,"containerName":"_annotation_value","name":"$self"},{"containerName":"_annotation_value","name":"annotation","kind":12,"line":1328},{"line":1328,"kind":12,"containerName":"_annotation_value","name":"remove_Annotations"},{"containerName":"_annotation_value","name":"$key","line":1328,"kind":13},{"line":1329,"kind":13,"containerName":"_annotation_value","name":"$ann"},{"containerName":"_annotation_value","name":"$ann","kind":13,"line":1329},{"line":1329,"kind":12,"name":"value","containerName":"_annotation_value"},{"name":"$ann","containerName":"_annotation_value","kind":13,"line":1332},{"line":1332,"kind":13,"name":"$self","containerName":"_annotation_value"},{"kind":12,"line":1332,"name":"annotation","containerName":"_annotation_value"},{"kind":12,"line":1332,"name":"get_Annotations","containerName":"_annotation_value"},{"kind":13,"line":1332,"containerName":"_annotation_value","name":"$key"},{"kind":13,"line":1333,"containerName":"_annotation_value","name":"$ann"},{"containerName":"_annotation_value","name":"$val","line":1333,"kind":13},{"line":1335,"kind":13,"containerName":"_annotation_value","name":"$val"},{"containerName":"_annotation_value","name":"$ann","kind":13,"line":1335},{"kind":12,"line":1335,"name":"value","containerName":"_annotation_value"},{"kind":13,"line":1336,"containerName":"_annotation_value","name":"$val"},{"name":"$ann","containerName":"_annotation_value","line":1338,"kind":13},{"line":1339,"kind":13,"name":"$ann","containerName":"_annotation_value"},{"kind":12,"line":1339,"containerName":"_annotation_value","name":"new"},{"containerName":"_annotation_value","name":"$key","kind":13,"line":1339},{"containerName":"_annotation_value","name":"$self","line":1340,"kind":13},{"containerName":"_annotation_value","name":"annotation","line":1340,"kind":12},{"kind":12,"line":1340,"containerName":"_annotation_value","name":"add_Annotation"},{"line":1340,"kind":13,"containerName":"_annotation_value","name":"$ann"},{"name":"$ann","containerName":"_annotation_value","kind":13,"line":1342},{"name":"value","containerName":"_annotation_value","line":1342,"kind":12},{"containerName":"_annotation_value","name":"$val","kind":13,"line":1342},{"containerName":"_annotation_value","name":"$val","line":1344,"kind":13}]},{"containerName":"Annotation::SimpleValue","name":"Bio","line":1339,"kind":12},{"signature":{"label":"_annotation_value_ary($self,$key,$arr)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$arr"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None\n\n\nsub next_seq {\n    my ($obj) = @_;\n\n    if(! exists($obj->{'_seq_queue'})) {\n\t# re-initialize from array of sequence data\n\t$obj->{'_seq_queue'} = [@{$obj->sequences()}];\n    }\n    my $queue = $obj->{'_seq_queue'};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $obj->{'_seq_queue'};\n\treturn;\n    }\n    # no, still data in the queue: get the next one from the queue\n    my $seq_h = shift(@$queue);\n    # if this is not a simple hash ref, it's an object already, and we'll\n    # return just that\n    return $seq_h if(ref($seq_h) ne 'HASH');\n    # nope, we need to assemble this object from scratch\n    #\n    # assemble the annotation collection\n    my $ac = Bio::Annotation::Collection->new();\n    foreach my $k (keys %$seq_h) {\n\tnext if $k =~ /acc|pid|nid|version/;\n\tmy $ann = Bio::Annotation::SimpleValue->new(-tagname => $k,\n\t\t\t\t\t\t    -value   => $seq_h->{$k});\n\t$ac->add_Annotation($ann);\n    }\n    # assemble the initialization parameters and create object\n    my $seqobj = $obj->sequence_factory->create(\n\t  -accession_number => $seq_h->{acc},\n\t  -pid              => $seq_h->{pid},\n\t  # why does NCBI prepend a 'g' to its own identifiers??\n\t  -primary_id       => $seq_h->{nid} && $seq_h->{nid} =~ /^g\\d+$/ ?\n\t\t\t\t     substr($seq_h->{nid},1) : $seq_h->{nid},\n\t  -display_id       => $seq_h->{acc},\n\t  -seq_version\t    => $seq_h->{version},\n\t  -alphabet         => $obj->{'_alphabet'},\n\t  -namespace        => $seq_h->{acc} =~ /^NM_/ ? 'RefSeq' : 'GenBank',\n\t  -authority        => $obj->authority(), # default is NCBI\n\t  -species          => $obj->species(),\n\t  -annotation       => $ac\n\t  );\n    return $seqobj;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get/Set the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : [optional] Bio::Factory::SequenceFactoryI\n\n\n\nsub sequence_factory {\n    my ($self,$obj) = @_;   \n    if( defined $obj ) {\n\tif( ! ref($obj) || ! $obj->isa('Bio::Factory::SequenceFactoryI') ) {\n\t    $self->throw(\"Must provide a valid Bio::Factory::SequenceFactoryI object to \".ref($self).\" sequence_factory()\");\n\t}\n\t$self->{'_seqfactory'} = $obj;\n    }\n    $self->{'_seqfactory'};\n}\n\n=head1 Private methods\n\n\n=head2 _annotation_value\n\n Title   : _annotation_value\n Usage   :\n Function: Private method.\n Example :\n Returns : the value (a string)\n Args    : annotation key (a string)\n           on set, annotation value (a string)\n\n\n\nsub _annotation_value{\n    my $self = shift;\n    my $key = shift;\n\n    my ($ann, $val);\n    if(@_) {\n\t$val = shift;\n\tif(! defined($val)) {\n\t    ($ann) = $self->annotation->remove_Annotations($key);\n\t    return $ann ? $ann->value() : undef;\n\t}\n    }\n    ($ann) = $self->annotation->get_Annotations($key);\n    if(defined $ann && (! $val)) {\n\t# get mode and exists\n\t$val = $ann->value();\n    } elsif($val) {\n\t# set mode\n\tif(!defined $ann) {\n\t    $ann = Bio::Annotation::SimpleValue->new(-tagname => $key);\n\t    $self->annotation->add_Annotation($ann);\n\t}\n\t$ann->value($val);\n    }\n    return $val;\n}\n\n\n=head2 _annotation_value_ary\n\n Title   : _annotation_value_ary\n Usage   :\n Function: Private method.\n Example :\n Returns : reference to the array of values\n Args    : annotation key (a string)\n           on set, reference to an array holding the values"},"detail":"($self,$key,$arr)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"_annotation_value_ary","line":1362,"kind":13},{"kind":13,"line":1362,"name":"$key","containerName":"_annotation_value_ary"},{"kind":13,"line":1362,"name":"$arr","containerName":"_annotation_value_ary"},{"kind":13,"line":1364,"name":"$ac","definition":"my","containerName":"_annotation_value_ary","localvar":"my"},{"containerName":"_annotation_value_ary","name":"$self","kind":13,"line":1364},{"kind":12,"line":1364,"name":"annotation","containerName":"_annotation_value_ary"},{"kind":13,"line":1365,"containerName":"_annotation_value_ary","name":"$arr"},{"name":"$ac","containerName":"_annotation_value_ary","line":1367,"kind":13},{"name":"remove_Annotations","containerName":"_annotation_value_ary","line":1367,"kind":12},{"name":"$key","containerName":"_annotation_value_ary","line":1367,"kind":13},{"localvar":"my","containerName":"_annotation_value_ary","definition":"my","name":"$val","line":1369,"kind":13},{"containerName":"_annotation_value_ary","name":"$arr","line":1369,"kind":13},{"containerName":"_annotation_value_ary","name":"$ann","definition":"my","localvar":"my","kind":13,"line":1370},{"line":1370,"kind":12,"name":"new","containerName":"_annotation_value_ary"},{"containerName":"_annotation_value_ary","name":"$val","kind":13,"line":1370},{"containerName":"_annotation_value_ary","name":"$key","kind":13,"line":1372},{"line":1373,"kind":13,"name":"$ac","containerName":"_annotation_value_ary"},{"kind":12,"line":1373,"containerName":"_annotation_value_ary","name":"add_Annotation"},{"name":"$ann","containerName":"_annotation_value_ary","kind":13,"line":1373},{"kind":13,"line":1376,"definition":"my","name":"@vals","containerName":"_annotation_value_ary","localvar":"my"},{"line":1376,"kind":12,"containerName":"_annotation_value_ary","name":"value"},{"name":"$ac","containerName":"_annotation_value_ary","line":1376,"kind":13},{"name":"get_Annotations","containerName":"_annotation_value_ary","kind":12,"line":1376},{"kind":13,"line":1376,"name":"$key","containerName":"_annotation_value_ary"},{"containerName":"_annotation_value_ary","name":"$arr","line":1377,"kind":13},{"kind":13,"line":1377,"containerName":"_annotation_value_ary","name":"@vals"},{"kind":13,"line":1379,"containerName":"_annotation_value_ary","name":"$arr"}],"line":1361,"kind":12,"range":{"end":{"character":9999,"line":1380},"start":{"character":0,"line":1361}},"name":"_annotation_value_ary"},{"line":1370,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"kind":12,"children":[{"kind":13,"line":1398,"definition":"my","name":"$self","containerName":"_annotation_dblink","localvar":"my"},{"name":"$key","containerName":"_annotation_dblink","kind":13,"line":1398},{"name":"$dbname","containerName":"_annotation_dblink","line":1398,"kind":13},{"name":"$acc","containerName":"_annotation_dblink","kind":13,"line":1398},{"name":"$version","containerName":"_annotation_dblink","kind":13,"line":1398},{"name":"$acc","containerName":"_annotation_dblink","line":1400,"kind":13},{"name":"$ann","definition":"my","containerName":"_annotation_dblink","localvar":"my","kind":13,"line":1402},{"line":1402,"kind":12,"containerName":"_annotation_dblink","name":"new"},{"kind":13,"line":1402,"name":"$key","containerName":"_annotation_dblink"},{"name":"$acc","containerName":"_annotation_dblink","kind":13,"line":1403},{"name":"$dbname","containerName":"_annotation_dblink","kind":13,"line":1404},{"name":"$version","containerName":"_annotation_dblink","kind":13,"line":1405},{"line":1406,"kind":13,"containerName":"_annotation_dblink","name":"$self"},{"containerName":"_annotation_dblink","name":"annotation","kind":12,"line":1406},{"kind":12,"line":1406,"name":"add_Annotation","containerName":"_annotation_dblink"},{"line":1406,"kind":13,"containerName":"_annotation_dblink","name":"$ann"},{"localvar":"my","definition":"my","name":"@anns","containerName":"_annotation_dblink","line":1410,"kind":13},{"name":"$self","containerName":"_annotation_dblink","kind":13,"line":1410},{"containerName":"_annotation_dblink","name":"annotation","line":1410,"kind":12},{"kind":12,"line":1410,"containerName":"_annotation_dblink","name":"get_Annotations"},{"line":1410,"kind":13,"name":"$key","containerName":"_annotation_dblink"},{"line":1412,"kind":13,"containerName":"_annotation_dblink","name":"$dbname"},{"containerName":"_annotation_dblink","name":"@anns","line":1413,"kind":13},{"name":"database","containerName":"_annotation_dblink","line":1413,"kind":12},{"containerName":"_annotation_dblink","name":"$dbname","kind":13,"line":1413},{"name":"@anns","containerName":"_annotation_dblink","kind":13,"line":1413},{"line":1415,"kind":12,"containerName":"_annotation_dblink","name":"primary_id"},{"name":"@anns","containerName":"_annotation_dblink","kind":13,"line":1415}],"line":1397,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None\n\n\nsub next_seq {\n    my ($obj) = @_;\n\n    if(! exists($obj->{'_seq_queue'})) {\n\t# re-initialize from array of sequence data\n\t$obj->{'_seq_queue'} = [@{$obj->sequences()}];\n    }\n    my $queue = $obj->{'_seq_queue'};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $obj->{'_seq_queue'};\n\treturn;\n    }\n    # no, still data in the queue: get the next one from the queue\n    my $seq_h = shift(@$queue);\n    # if this is not a simple hash ref, it's an object already, and we'll\n    # return just that\n    return $seq_h if(ref($seq_h) ne 'HASH');\n    # nope, we need to assemble this object from scratch\n    #\n    # assemble the annotation collection\n    my $ac = Bio::Annotation::Collection->new();\n    foreach my $k (keys %$seq_h) {\n\tnext if $k =~ /acc|pid|nid|version/;\n\tmy $ann = Bio::Annotation::SimpleValue->new(-tagname => $k,\n\t\t\t\t\t\t    -value   => $seq_h->{$k});\n\t$ac->add_Annotation($ann);\n    }\n    # assemble the initialization parameters and create object\n    my $seqobj = $obj->sequence_factory->create(\n\t  -accession_number => $seq_h->{acc},\n\t  -pid              => $seq_h->{pid},\n\t  # why does NCBI prepend a 'g' to its own identifiers??\n\t  -primary_id       => $seq_h->{nid} && $seq_h->{nid} =~ /^g\\d+$/ ?\n\t\t\t\t     substr($seq_h->{nid},1) : $seq_h->{nid},\n\t  -display_id       => $seq_h->{acc},\n\t  -seq_version\t    => $seq_h->{version},\n\t  -alphabet         => $obj->{'_alphabet'},\n\t  -namespace        => $seq_h->{acc} =~ /^NM_/ ? 'RefSeq' : 'GenBank',\n\t  -authority        => $obj->authority(), # default is NCBI\n\t  -species          => $obj->species(),\n\t  -annotation       => $ac\n\t  );\n    return $seqobj;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get/Set the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : [optional] Bio::Factory::SequenceFactoryI\n\n\n\nsub sequence_factory {\n    my ($self,$obj) = @_;   \n    if( defined $obj ) {\n\tif( ! ref($obj) || ! $obj->isa('Bio::Factory::SequenceFactoryI') ) {\n\t    $self->throw(\"Must provide a valid Bio::Factory::SequenceFactoryI object to \".ref($self).\" sequence_factory()\");\n\t}\n\t$self->{'_seqfactory'} = $obj;\n    }\n    $self->{'_seqfactory'};\n}\n\n=head1 Private methods\n\n\n=head2 _annotation_value\n\n Title   : _annotation_value\n Usage   :\n Function: Private method.\n Example :\n Returns : the value (a string)\n Args    : annotation key (a string)\n           on set, annotation value (a string)\n\n\n\nsub _annotation_value{\n    my $self = shift;\n    my $key = shift;\n\n    my ($ann, $val);\n    if(@_) {\n\t$val = shift;\n\tif(! defined($val)) {\n\t    ($ann) = $self->annotation->remove_Annotations($key);\n\t    return $ann ? $ann->value() : undef;\n\t}\n    }\n    ($ann) = $self->annotation->get_Annotations($key);\n    if(defined $ann && (! $val)) {\n\t# get mode and exists\n\t$val = $ann->value();\n    } elsif($val) {\n\t# set mode\n\tif(!defined $ann) {\n\t    $ann = Bio::Annotation::SimpleValue->new(-tagname => $key);\n\t    $self->annotation->add_Annotation($ann);\n\t}\n\t$ann->value($val);\n    }\n    return $val;\n}\n\n\n=head2 _annotation_value_ary\n\n Title   : _annotation_value_ary\n Usage   :\n Function: Private method.\n Example :\n Returns : reference to the array of values\n Args    : annotation key (a string)\n           on set, reference to an array holding the values\n\n\n\nsub _annotation_value_ary{\n    my ($self,$key,$arr) = @_;\n\n    my $ac = $self->annotation;\n    if($arr) {\n\t# purge first\n\t$ac->remove_Annotations($key);\n\t# then add as many values as are present\n\tforeach my $val (@$arr) {\n\t    my $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n\t\t\t\t\t\t\t-tagname => $key\n\t\t\t\t\t\t\t);\n\t    $ac->add_Annotation($ann);\n\t}\n    } else {\n\tmy @vals = map { $_->value(); } $ac->get_Annotations($key);\n\t$arr = [@vals];\n    }\n    return $arr;\n}\n\n\n=head2 _annotation_dblink\n\n Title   : _annotation_dblink\n Usage   :\n Function: Private method.\n Example :\n Returns : array of accessions for the given database (namespace)\n Args    : annotation key (a string)\n           dbname (a string) (optional on get, mandatory on set)\n           on set, accession or ID (a string), and version","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$dbname"},{"label":"$acc"},{"label":"$version"}],"label":"_annotation_dblink($self,$key,$dbname,$acc,$version)"},"detail":"($self,$key,$dbname,$acc,$version)","name":"_annotation_dblink","range":{"start":{"line":1397,"character":0},"end":{"line":1417,"character":9999}}},{"containerName":"Annotation::DBLink","name":"Bio","line":1402,"kind":12},{"signature":{"label":"_remove_dblink($self,$key,$dbname)","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$dbname"}],"documentation":"1;\n# $Id: UniGene.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Cluster::UniGene.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Andrew Macgregor <andrew at cbbc.murdoch.edu.au>\n#\n# Copyright Andrew Macgregor, Jo-Ann Stanton, David Green\n# Molecular Embryology Group, Anatomy & Structural Biology, University of Otago\n# http://meg.otago.ac.nz/\n#\n# You may distribute this module under the same terms as perl itself\n#\n# _history\n# April 17, 2002 - Initial implementation by Andrew Macgregor\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Cluster::UniGene - UniGene object\n\n=head1 SYNOPSIS\n\n\tuse Bio::Cluster::UniGene;\n\tuse Bio::ClusterIO;\n\n\t$stream  = Bio::ClusterIO->new('-file' => \"Hs.data\", \n                                       '-format' => \"unigene\");\n\t# note: we quote -format to keep older perl's from complaining.\n\n\twhile ( my $in = $stream->next_cluster() ) {\n\t\tprint $in->unigene_id() . \"\\n\";\n\t\twhile ( my $sequence = $in->next_seq() ) {\n\t\t\tprint $sequence->accession_number() . \"\\n\";\n\t\t}\n       }\n\n=head1 DESCRIPTION\n\nThis UniGene object implements the L<Bio::Cluster::UniGeneI> interface\nfor the representation if UniGene clusters in Bioperl. It is returned\nby the L<Bio::ClusterIO> parser for unigene format and contains all\nthe data associated with one UniGene record.\n\nThis class implements several interfaces and hence can be used\nwherever instances of such interfaces are expected. In particular, the\ninterfaces are L<Bio::ClusterI> as the base interface for all cluster\nrepresentations, and in addition L<Bio::IdentifiableI> and\nL<Bio::DescribableI>.\n\nThe following lists the UniGene specific methods that are available\n(see below for details). Be aware next_XXX iterators take a snapshot\nof the array property when they are first called, and this snapshot is\nnot reset until the iterator is exhausted. Hence, once called you need\nto exhaust the iterator to see any changes that have been made to the\nproperty in the meantime. You will usually want to use the\nnon-iterator equivalents and loop over the elements yourself.\n\nnew() - standard new call\n\nunigene_id() - set/get unigene_id\n\ntitle() - set/get title (description)\n\ngene() - set/get gene\n\ncytoband() - set/get cytoband\n\nmgi() - set/get mgi\n\nlocuslink() - set/get locuslink\n\nhomol() - set/get homologene\n\ngnm_terminus() - set/get gnm_terminus\n\nscount() - set/get scount\n\nexpress() - set/get express, currently takes/returns a reference to an\narray of expressed tissues\n\nnext_express() - returns the next tissue expression from the expressed\ntissue array\n\nchromosome() - set/get chromosome, currently takes/returns a reference\nto an array of chromosome lines\n\nnext_chromosome() - returns the next chromosome line from the array of\nchromosome lines\n\nsts() - set/get sts, currently takes/returns a reference to an array\nof sts lines\n\nnext_sts() - returns the next sts line from the array of sts lines\n\ntxmap() - set/get txmap, currently takes/returns a reference to an\narray of txmap lines\n\nnext_txmap() - returns the next txmap line from the array of txmap\nlines\n\nprotsim() - set/get protsim, currently takes/returns a reference to an\narray of protsim lines\n\nnext_protsim() - returns the next protsim line from the array of\nprotsim lines\n\nsequences() - set/get sequence, currently takes/returns a reference to\nan array of references to seq info\n\nnext_seq() - returns a Seq object that currently only contains an\naccession number\n\n\n=head1 Implemented Interfaces\n\nThis class implementes the following interfaces.\n\n=over 4\n\n* Bio::Cluster::UniGeneI\n\nThis includes implementing Bio::ClusterI.\n\n* Bio::IdentifiableI\n\n* Bio::DescribableI\n\n* Bio::AnnotatableI\n\n* Bio::Factory::SequenceStreamI\n\n\n=head1 FEEDBACK\n\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Andrew Macgregor\n\nEmail andrew at cbbc.murdoch.edu.au\n\n=head1 CONTRIBUTORS\n\nHilmar Lapp, hlapp at gmx.net\n\n=head1 APPENDIX\n\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a \"_\".\n\n\n# Let the code begin...\n\n\npackage Bio::Cluster::UniGene;\nuse strict;\n\nuse Bio::Annotation::Collection;\nuse Bio::Annotation::DBLink;\nuse Bio::Annotation::SimpleValue;\nuse Bio::Species;\nuse Bio::Seq::SeqFactory;\n\nuse base qw(Bio::Root::Root Bio::Cluster::UniGeneI Bio::IdentifiableI Bio::DescribableI Bio::AnnotatableI Bio::Factory::SequenceStreamI);\n\nmy %species_map = (\n\t\t   'Aga' => \"Anopheles gambiae\",\n\t\t   'Ame' => \"Apis mellifera\",\n\t\t   'At'  => \"Arabidopsis thaliana\",\n\t\t   'Bmo' => \"Bombyx mori\",\n\t\t   'Bt'  => \"Bos taurus\",\n\t\t   'Cel' => \"Caenorhabditis elegans\",\n\t\t   'Cfa' => \"Canine familiaris\",\n\t\t   'Cin' => \"Ciona intestinalis\",\n\t\t   'Cre' => \"Chlamydomonas reinhardtii\",\n\t\t   'Csa' => \"Ciona savignyi\",\n\t\t   'Csi' => \"Citrus sinensis\",\n\t\t   'Ddi' => \"Dictyostelium discoideum\",\n\t\t   'Dr'  => \"Danio rerio\",\n\t\t   'Dm'  => \"Drosophila melanogaster\",\n\t\t   'Gga' => \"Gallus gallus\",\n\t\t   'Gma' => \"Glycine max\",\n\t\t   'Han' => \"Helianthus annus\",\n\t\t   'Hs'  => \"Homo sapiens\",\n\t\t   'Hma' => \"Hydra magnipapillata\",\n\t\t   'Hv'  => \"Hordeum vulgare\",\n\t\t   'Lco' => \"Lotus corniculatus\",\n\t\t   'Les' => \"Lycopersicon esculentum\",\n\t\t   'Lsa' => \"Lactuca sativa\",\n\t\t   'Mdo' => \"Malus x domestica\",\n                   'Mgr' => \"Magnaporthe grisea\",\n\t\t   'Mm'  => \"Mus musculus\",\n\t\t   'Mtr' => \"Medicago truncatula\",\n                   'Ncr' => \"Neurospora crassa\",\n\t\t   'Oar' => \"Ovis aries\",\n\t\t   'Omy' => \"Oncorhynchus mykiss\",\n\t\t   'Os'  => \"Oryza sativa\",\n\t\t   'Ola' => \"Oryzias latipes\",\n\t\t   'Ppa' => \"Physcomitrella patens\",\n\t\t   'Pta' => \"Pinus taeda\",\n\t\t   'Ptp' => \"Populus tremula x Populus tremuloides\",\n\t\t   'Rn'  => \"Rattus norvegicus\",\n\t\t   'Sbi' => \"Sorghum bicolor\",\n\t\t   'Sma' => \"Schistosoma mansoni\",\n\t\t   'Sof' => \"Saccharum officinarum\",\n\t\t   'Spu' => \"Strongylocentrotus purpuratus\",\n\t\t   'Ssa' => \"Salmo salar\",\n\t\t   'Ssc' => \"Sus scrofa\",\n\t\t   'Str' => \"Xenopus tropicalis\",\n\t\t   'Stu' => \"Solanum tuberosum\",\n\t\t   'Ta'  => \"Triticum aestivum\",\n\t\t   'Tgo' => \"Toxoplasma gondii\",\n                   'Tru' => \"Takifugu rubripes\",\n\t\t   'Vvi' => \"Vitis vinifera\",\n\t\t   'Xl'  => \"Xenopus laevis\",\n\t\t   'Zm'  => \"Zea mays\",\n\t\t   );\n\n\n=head2 new\n\n Title   : new\n Usage   : used by ClusterIO\n Returns : a new Bio::Cluster::Unigene object\n\n\nsub new {\n    # standard new call..\n    my($caller,@args) = @_;\n    my $self = $caller->SUPER::new(@args);\n\n    my ($ugid,$desc,$mems,$size,$species,$dispid,$id,$ns,$auth,$v,$seqfact) =\n\t$self->_rearrange([qw(UNIGENE_ID\n\t\t\t      DESCRIPTION\n\t\t\t      MEMBERS\n\t\t\t      SIZE\n\t\t\t      SPECIES\n\t\t\t      DISPLAY_ID\n\t\t\t      OBJECT_ID\n\t\t\t      NAMESPACE\n\t\t\t      AUTHORITY\n\t\t\t      VERSION\n\t\t\t      SEQFACTORY\n\t\t\t      )], @args);\n\n    $self->{'_alphabet'} = 'dna';\n\n    $self->unigene_id($ugid) if $ugid;\n    $self->description($desc) if $desc;\n    $self->sequences($mems) if $mems;\n    $self->size($size) if defined($size);\n    $self->display_id($dispid) if $dispid; # overwrites ugid\n    $self->object_id($id) if $id;          # overwrites dispid\n    $self->namespace($ns || 'UniGene');\n    $self->authority($auth || 'NCBI');\n    $self->version($v) if defined($v);\n    if( ! defined $seqfact ) {\n\t$seqfact = Bio::Seq::SeqFactory->new\n\t    (-verbose => $self->verbose(), \n\t     -type => 'Bio::Seq::RichSeq');\n    }\n    $self->sequence_factory($seqfact);\n    if( (! $species) && (defined $self->unigene_id() && \n\t\t\t $self->unigene_id() =~ /^([A-Za-z]+)\\.[0-9]/)) {\n\t# try set a default one depending on the ID\n\t$species = $species_map{$1};\n    }\n    $self->species($species);\n    return $self;\n}\n\n\n=head1 L<Bio::Cluster::UniGeneI> methods\n\n\n=head2 unigene_id\n\n Title   : unigene_id\n Usage   : unigene_id();\n Function: Returns the unigene_id associated with the object.\n Example : $id = $unigene->unigene_id or $unigene->unigene_id($id)\n Returns : A string\n Args    : None or an id\n\n\n\nsub unigene_id {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'unigene_id'} = $value;\n\t}\n\treturn $obj->{'unigene_id'};\n}\n\n\n\n=head2 title\n\n Title   : title\n Usage   : title();\n Function: Returns the title associated with the object.\n Example : $title = $unigene->title or $unigene->title($title)\n Returns : A string\n Args    : None or a title\n\n\n\nsub title {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t\t$obj->{'title'} = $value;\n\t}\n\treturn $obj->{'title'};\n}\n\n\n=head2 gene\n\n Title   : gene\n Usage   : gene();\n Function: Returns the gene associated with the object.\n Example : $gene = $unigene->gene or $unigene->gene($gene)\n Returns : A string\n Args    : None or a gene\n\n\n\nsub gene {\n    my $self = shift;\n    return $self->_annotation_value('gene_name', @_);\n}\n\n\n=head2 cytoband\n\n Title   : cytoband\n Usage   : cytoband();\n Function: Returns the cytoband associated with the object.\n Example : $cytoband = $unigene->cytoband or $unigene->cytoband($cytoband)\n Returns : A string\n Args    : None or a cytoband\n\n\n\nsub cytoband {\n    my $self = shift;\n    return $self->_annotation_value('cyto_band', @_);\n}\n\n=head2 mgi\n\n Title   : mgi\n Usage   : mgi();\n Function: Returns the mgi associated with the object.\n Example : $mgi = $unigene->mgi or $unigene->mgi($mgi)\n Returns : A string\n Args    : None or a mgi\n\n\n\nsub mgi {\n    my $self = shift;\n    my $acc;\n\n    if(@_) {\n\t# purge first\n\t$self->_remove_dblink('dblink','MGI');\n\t# then add if a valid value is present\n\tif($acc = shift) {\n\t    $self->_annotation_dblink('dblink','MGI',$acc);\n\t}\n    } else {\n\t($acc) = $self->_annotation_dblink('dblink','MGI');\n    }\n    return $acc;\n}\n\n\n=head2 locuslink\n\n Title   : locuslink\n Usage   : locuslink();\n Function: Returns or stores a reference to an array containing locuslink data.\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub locuslink {\n    my ($self,$ll) = @_;\n    \n    if($ll) {\n\t# purge first\n\t$self->_remove_dblink('dblink','LocusLink');\n\t# then add as many accessions as are present\n\tforeach my $acc (@$ll) {\n\t    $self->_annotation_dblink('dblink','LocusLink',$acc);\n\t}\n    } else {\n\tmy @accs = $self->_annotation_dblink('dblink','LocusLink');\n\t$ll = [@accs];\n    }\n    return $ll;\n}\n\n\n=head2 homol\n\n Title   : homol\n Usage   : homol();\n Function: Returns the homol entry associated with the object.\n Example : $homol = $unigene->homol or $unigene->homol($homol)\n Returns : A string\n Args    : None or a homol entry\n\n\nsub homol {\n    my $self = shift;\n    return $self->_annotation_value('homol', @_);\n}\n\n\n=head2 restr_expr\n\n Title   : restr_expr\n Usage   : restr_expr();\n Function: Returns the restr_expr entry associated with the object.\n Example : $restr_expr = $unigene->restr_expr or $unigene->restr_expr($restr_expr)\n Returns : A string\n Args    : None or a restr_expr entry\n\n\nsub restr_expr {\n    my $self = shift;\n    return $self->_annotation_value('restr_expr', @_);\n}\n\n\n=head2 gnm_terminus\n\n Title   : gnm_terminus\n Usage   : gnm_terminus();\n Function: Returns the gnm_terminus associated with the object.\n Example : $gnm_terminus = $unigene->gnm_terminus or \n           $unigene->gnm_terminus($gnm_terminus)\n Returns : A string\n Args    : None or a gnm_terminus\n\n\nsub gnm_terminus {\n    my $self = shift;\n    return $self->_annotation_value('gnm_terminus', @_);\n}\n\n=head2 scount\n\n Title   : scount\n Usage   : scount();\n Function: Returns the scount associated with the object.\n Example : $scount = $unigene->scount or $unigene->scount($scount)\n Returns : A string\n Args    : None or a scount\n\n\nsub scount {\n\tmy ($obj,$value) = @_;\n\tif( defined $value) {\n\t    $obj->{'scount'} = $value;\n\t} elsif((! defined($obj->{'scount'})) && defined($obj->sequences())) {\n\t    $obj->{'scount'} = $obj->size();\n\t}\n\treturn $obj->{'scount'};\n}\n\n\n=head2 express\n\n Title   : express\n Usage   : express();\n Function: Returns or stores a reference to an array containing \n           tissue expression data\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub express {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('expressed',@_);\n}\n\n\n=head2 chromosome\n\n Title   : chromosome\n Usage   : chromosome();\n Function: Returns or stores a reference to an array containing\n           chromosome lines\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub chromosome {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('chromosome',@_);\n }\n\n\n=head2 sts\n\n Title   : sts\n Usage   : sts();\n Function: Returns or stores a reference to an array containing sts lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub sts {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('sts',@_);\n}\n\n\n=head2 txmap\n\n Title   : txmap\n Usage   : txmap();\n Function: Returns or stores a reference to an array containing txmap lines\n\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub txmap {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('txmap',@_);\n}\n\n\n=head2 protsim\n\n Title   : protsim\n Usage   : protsim();\n Function: Returns or stores a reference to an array containing protsim lines\n\t   This should really only be used by ClusterIO, not directly\n Returns : An array reference\n Args    : None or an array reference\n\n\nsub protsim {\n    my $self = shift;\n\n    return $self->_annotation_value_ary('protsim',@_);\n}\n\n\n=head2 sequences\n\n Title   : sequences\n Usage   : sequences();\n Function: Returns or stores a reference to an array containing\n           sequence data.\n\n           This is mostly reserved for ClusterIO parsers. You should\n           use get_members() for get and add_member()/remove_members()\n           for set.\n\n Returns : An array reference, or undef\n Args    : None or an array reference or undef\n\n\nsub sequences {\n    my $self = shift;\n\n    return $self->{'members'} = shift if @_;\n    return $self->{'members'};\n}\n\n=head2 species\n\n Title   : species\n Usage   : $obj->species($newval)\n Function: Get/set the species object for this Unigene cluster.\n Example : \n Returns : value of species (a L<Bio::Species> object)\n Args    : on set, new value (a L<Bio::Species> object or \n           the binomial name, or undef, optional)\n\n\n\nsub species{\n    my $self = shift;\n\n    if(@_) {\n\tmy $species = shift;\n\tif($species && (! ref($species))) {\n\t    my @class = reverse(split(' ',$species));\n\t    $species = Bio::Species->new(-classification => \\@class);\n\t}\n\treturn $self->{'species'} = $species;\n    }\n    return $self->{'species'};\n}\n\n\n=head1 L<Bio::ClusterI> methods\n\n\n=head2 display_id\n\n Title   : display_id\n Usage   : \n Function: Get/set the display name or identifier for the cluster\n\n           This is aliased to unigene_id().\n\n Returns : a string\n Args    : optional, on set the display ID ( a string)\n\n\nsub display_id{\n    return shift->unigene_id(@_);\n}\n\n=head2 description\n\n Title   : description\n Usage   : Bio::ClusterI->description(\"POLYUBIQUITIN\")\n Function: get/set for the consensus description of the cluster\n\n           This is aliased to title().\n\n Returns : the description string \n Args    : Optional the description string \n\n\nsub description{\n    return shift->title(@_);\n}\n\n=head2 size\n\n Title   : size\n Usage   : Bio::ClusterI->size();\n Function: get for the size of the family, \n           calculated from the number of members\n\n           This is aliased to scount().\n\n Returns : the size of the cluster\n Args    : \n\n\nsub size {\n    my $self = shift;\n\n    # hard-wiring the size is allowed if there are no sequences\n    return $self->scount(@_) unless defined($self->sequences());\n    # but we can't change the number of members through this method\n    my $n = scalar(@{$self->sequences()});\n    if(@_ && ($n != $_[0])) {\n\t$self->throw(\"Cannot change cluster size using size() from $n to \".\n\t\t     $_[0]);\n    }\n    return $n;\n}\n\n=head2 cluster_score\n\n Title   : cluster_score\n Usage   : $cluster ->cluster_score(100);\n Function: get/set for cluster_score which\n           represent the score in which the clustering\n           algorithm assigns to this cluster.\n\n           For UniGene clusters, there really is no cluster score that\n           would come with the data. However, we provide an\n           implementation here so that you can score UniGene clusters\n           if you want to.\n\n Returns : a number\n Args    : optionally, on set a number\n\n\nsub cluster_score{\n    my $self = shift;\n\n    return $self->{'cluster_score'} = shift if @_;\n    return $self->{'cluster_score'};\n}\n\n=head2 get_members\n\n Title   : get_members\n Usage   : Bio::ClusterI->get_members(($seq1, $seq2));\n Function: retrieve the members of the family by some criteria\n\n           Will return all members if no criteria are provided.\n\n           At this time this implementation does not support\n           specifying criteria and will always return all members.\n\n Returns : the array of members\n Args    : \n\n\nsub get_members {\n    my $self = shift;\n\n    my $mems = $self->sequences() || [];\n    # already objects?\n    if(@$mems && (ref($mems->[0]) eq \"HASH\")) {\n\t# nope, we need to build the object list from scratch\n\tmy @memlist = ();\n\twhile(my $seq = $self->next_seq()) {\n\t    push(@memlist, $seq);\n\t}\n\t# we cache this array of objects as the new member list\n\t$mems = \\@memlist;\n\t$self->sequences($mems);\n    }\n    # done\n    return @$mems;\n}\n\n\n=head1 Annotatable view at the object properties\n\n\n=head2 annotation\n\n Title   : annotation\n Usage   : $obj->annotation($newval)\n Function: Get/set the L<Bio::AnnotationCollectionI> object for\n           this UniGene cluster.\n\n           Many attributes of this class are actually stored within\n           the annotation collection object as L<Bio::AnnotationI>\n           compliant objects, so you can conveniently access them\n           through the same interface as you would e.g. access\n           L<Bio::SeqI> annotation properties.\n\n           If you call this method in set mode and replace the\n           annotation collection with another one you should know\n           exactly what you are doing.\n\n Example : \n Returns : a L<Bio::AnnotationCollectionI> compliant object\n Args    : on set, new value (a L<Bio::AnnotationCollectionI> \n           compliant object or undef, optional)\n\n\n\nsub annotation{\n    my $self = shift;\n\n    if(@_) {\n\treturn $self->{'annotation'} = shift;\n    } elsif(! exists($self->{'annotation'})) {\n\t$self->{'annotation'} = Bio::Annotation::Collection->new();\n    }\n    return $self->{'annotation'};\n}\n\n\n=head1 Implementation specific methods\n\n These are mostly for adding/removing to array properties, and for\n methods with special functionality.\n\n\n=head2 add_member\n\n Title   : add_member\n Usage   :\n Function: Adds a member object to the list of members.\n Example :\n Returns : TRUE if the new member was successfuly added, and FALSE\n           otherwise.\n Args    : The member to add.\n\n\n\nsub add_member{\n    my ($self,@mems) = @_;\n\n    my $memlist = $self->{'members'} || [];\n    # this is an object interface; is the member list already objects?\n    if(@$memlist && (ref($memlist->[0]) eq \"HASH\")) {\n\t# nope, convert to objects\n        $memlist = [$self->get_members()];\n    }\n    # add new member(s)\n    push(@$memlist, @mems);\n    # store if we created this array ref ourselves\n    $self->sequences($memlist);\n    # done\n    return 1;\n}\n\n=head2 remove_members\n\n Title   : remove_members\n Usage   :\n Function: Remove the list of members for this cluster such that the\n           member list is undefined afterwards (as opposed to zero members).\n Example :\n Returns : the previous list of members\n Args    : none\n\n\n\nsub remove_members{\n    my $self = shift;\n\n    my @mems = $self->get_members();\n    $self->sequences(undef);\n    return @mems;\n}\n\n\n=head2 next_locuslink\n\n Title   : next_locuslink\n Usage   : next_locuslink();\n Function: Returns the next locuslink from an array referred \n           to using $obj->{'locuslink'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $locuslink = $in->next_locuslink() ) {\n\t\t\t\tprint \"$locuslink\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_locuslink {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"ll\",\"locuslink\");\n}\n\n=head2 next_express\n\n Title   : next_express\n Usage   : next_express();\n Function: Returns the next tissue from an array referred \n           to using $obj->{'express'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $express = $in->next_express() ) {\n\t\t\t\tprint \"$express\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_express {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"express\",\"express\");\n}\n\n\n=head2 next_chromosome\n\n Title   : next_chromosome\n Usage   : next_chromosome();\n Function: Returns the next chromosome line from an array referred\n           to using $obj->{'chromosome'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $chromosome = $in->next_chromosome() ) {\n\t\t\t\tprint \"$chromosome\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_chromosome {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"chr\",\"chromosome\");\n}\n\n\n=head2 next_protsim\n\n Title   : next_protsim\n Usage   : next_protsim();\n Function: Returns the next protsim line from an array referred \n           to using $obj->{'protsim'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $protsim = $in->next_protsim() ) {\n\t\t\t\tprint \"$protsim\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_protsim {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"protsim\",\"protsim\");\n}\n\n\n=head2 next_sts\n\n Title   : next_sts\n Usage   : next_sts();\n Function: Returns the next sts line from an array referred \n           to using $obj->{'sts'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $sts = $in->next_sts() ) {\n\t\t\t\tprint \"$sts\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_sts {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"sts\",\"sts\");\n}\n\n\n=head2 next_txmap\n\n Title   : next_txmap\n Usage   : next_txmap();\n Function: Returns the next txmap line from an array \n           referred to using $obj->{'txmap'}\n\n           If you call this iterator again after it returned undef, it\n           will re-cycle through the list of elements. Changes in the\n           underlying array property while you loop over this iterator\n           will not be reflected until you exhaust the iterator.\n\n Example : \twhile ( my $tsmap = $in->next_txmap() ) {\n\t\t\t\tprint \"$txmap\\n\";\n\t\t\t}\n Returns : String\n Args    : None\n\n\nsub next_txmap {\n    my ($obj) = @_;\n\n    return $obj->_next_element(\"txmap\",\"txmap\");\n}\n\n###############################\n# private method\n#\n# args: prefix name for the queue\n#       name of the method from which to re-fill\n# returns: the next element from that queue, or undef if the queue is empty\n###############################\nsub _next_element{\n    my ($self,$queuename,$meth) = @_;\n\n    $queuename = \"_\".$queuename.\"_queue\";\n    if(! exists($self->{$queuename})) {\n\t# re-initialize from array of sequence data\n\t$self->{$queuename} = [@{$self->$meth() }];\n    }\n    my $queue = $self->{$queuename};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $self->{$queuename};\n\treturn;\n    }\n    return shift(@$queue);\n}\n\n=head1 L<Bio::IdentifiableI> methods\n\n\n=head2 object_id\n\n Title   : object_id\n Usage   : $string    = $obj->object_id()\n Function: a string which represents the stable primary identifier\n           in this namespace of this object. For DNA sequences this\n           is its accession_number, similarly for protein sequences\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n\n\n\nsub object_id {\n    return shift->unigene_id(@_);\n}\n\n=head2 version\n\n Title   : version\n Usage   : $version    = $obj->version()\n Function: a number which differentiates between versions of\n           the same object. Higher numbers are considered to be\n           later and more relevant, but a single object described\n           the same identifier should represent the same concept\n\n           Unigene clusters usually won't have a version, so this\n           will be mostly undefined.\n\n Returns : A number\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub version {\n    my $self = shift;\n\n    return $self->{'version'} = shift if @_;\n    return $self->{'version'};\n}\n\n\n=head2 authority\n\n Title   : authority\n Usage   : $authority    = $obj->authority()\n Function: a string which represents the organisation which\n           granted the namespace, written as the DNS name for  \n           organisation (eg, wormbase.org)\n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub authority {\n    my $self = shift;\n\n    return $self->{'authority'} = shift if @_;\n    return $self->{'authority'};\n}\n\n\n=head2 namespace\n\n Title   : namespace\n Usage   : $string    = $obj->namespace()\n Function: A string representing the name space this identifier\n           is valid in, often the database name or the name\n           describing the collection \n\n Returns : A scalar\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub namespace {\n    my $self = shift;\n\n    return $self->{'namespace'} = shift if @_;\n    return $self->{'namespace'};\n}\n\n=head1 L<Bio::DescribableI> methods\n\n\n=head2 display_name\n\n Title   : display_name\n Usage   : $string    = $obj->display_name()\n Function: A string which is what should be displayed to the user\n           the string should have no spaces (ideally, though a cautious\n           user of this interface would not assumme this) and should be\n           less than thirty characters (though again, double checking \n           this is a good idea)\n\n           This is aliased to unigene_id().\n\n Returns : A scalar\n Status  : Virtual\n\n\nsub display_name {\n    return shift->unigene_id(@_);\n}\n\n\n=head2 description()\n\n Title   : description\n Usage   : $string    = $obj->description()\n Function: A text string suitable for displaying to the user a \n           description. This string is likely to have spaces, but\n           should not have any newlines or formatting - just plain\n           text. The string should not be greater than 255 characters\n           and clients can feel justified at truncating strings at 255\n           characters for the purposes of display\n\n           This is already demanded by Bio::ClusterI and hence is\n           present anyway.\n\n Returns : A scalar\n\n\n\n\n=head1 L<Bio::Factory::SequenceStreamI> methods\n\n\n=head2 next_seq\n\n Title   : next_seq\n Usage   : next_seq();\n Function: Returns the next seq as a Seq object as defined by \n           $seq->sequence_factory(), \n           at present an empty Bio::Seq::RichSeq object with \n           just the accession_number() and pid() set\n\n           This iterator will not exhaust the array of member\n           sequences. If you call next_seq() again after it returned\n           undef, it will re-cycle through the list of member\n           sequences.\n\n Example :  while ( my $sequence = $in->next_seq() ) {\n             print $sequence->accession_number() . \"\\n\";\n\t    }\n Returns : Bio::PrimarySeqI object\n Args    : None\n\n\nsub next_seq {\n    my ($obj) = @_;\n\n    if(! exists($obj->{'_seq_queue'})) {\n\t# re-initialize from array of sequence data\n\t$obj->{'_seq_queue'} = [@{$obj->sequences()}];\n    }\n    my $queue = $obj->{'_seq_queue'};\n    # is queue exhausted (equivalent to end of stream)?\n    if(! @$queue) {\n\t# yes, remove queue and signal to the caller\n\tdelete $obj->{'_seq_queue'};\n\treturn;\n    }\n    # no, still data in the queue: get the next one from the queue\n    my $seq_h = shift(@$queue);\n    # if this is not a simple hash ref, it's an object already, and we'll\n    # return just that\n    return $seq_h if(ref($seq_h) ne 'HASH');\n    # nope, we need to assemble this object from scratch\n    #\n    # assemble the annotation collection\n    my $ac = Bio::Annotation::Collection->new();\n    foreach my $k (keys %$seq_h) {\n\tnext if $k =~ /acc|pid|nid|version/;\n\tmy $ann = Bio::Annotation::SimpleValue->new(-tagname => $k,\n\t\t\t\t\t\t    -value   => $seq_h->{$k});\n\t$ac->add_Annotation($ann);\n    }\n    # assemble the initialization parameters and create object\n    my $seqobj = $obj->sequence_factory->create(\n\t  -accession_number => $seq_h->{acc},\n\t  -pid              => $seq_h->{pid},\n\t  # why does NCBI prepend a 'g' to its own identifiers??\n\t  -primary_id       => $seq_h->{nid} && $seq_h->{nid} =~ /^g\\d+$/ ?\n\t\t\t\t     substr($seq_h->{nid},1) : $seq_h->{nid},\n\t  -display_id       => $seq_h->{acc},\n\t  -seq_version\t    => $seq_h->{version},\n\t  -alphabet         => $obj->{'_alphabet'},\n\t  -namespace        => $seq_h->{acc} =~ /^NM_/ ? 'RefSeq' : 'GenBank',\n\t  -authority        => $obj->authority(), # default is NCBI\n\t  -species          => $obj->species(),\n\t  -annotation       => $ac\n\t  );\n    return $seqobj;\n}\n\n=head2 sequence_factory\n\n Title   : sequence_factory\n Usage   : $seqio->sequence_factory($seqfactory)\n Function: Get/Set the Bio::Factory::SequenceFactoryI\n Returns : Bio::Factory::SequenceFactoryI\n Args    : [optional] Bio::Factory::SequenceFactoryI\n\n\n\nsub sequence_factory {\n    my ($self,$obj) = @_;   \n    if( defined $obj ) {\n\tif( ! ref($obj) || ! $obj->isa('Bio::Factory::SequenceFactoryI') ) {\n\t    $self->throw(\"Must provide a valid Bio::Factory::SequenceFactoryI object to \".ref($self).\" sequence_factory()\");\n\t}\n\t$self->{'_seqfactory'} = $obj;\n    }\n    $self->{'_seqfactory'};\n}\n\n=head1 Private methods\n\n\n=head2 _annotation_value\n\n Title   : _annotation_value\n Usage   :\n Function: Private method.\n Example :\n Returns : the value (a string)\n Args    : annotation key (a string)\n           on set, annotation value (a string)\n\n\n\nsub _annotation_value{\n    my $self = shift;\n    my $key = shift;\n\n    my ($ann, $val);\n    if(@_) {\n\t$val = shift;\n\tif(! defined($val)) {\n\t    ($ann) = $self->annotation->remove_Annotations($key);\n\t    return $ann ? $ann->value() : undef;\n\t}\n    }\n    ($ann) = $self->annotation->get_Annotations($key);\n    if(defined $ann && (! $val)) {\n\t# get mode and exists\n\t$val = $ann->value();\n    } elsif($val) {\n\t# set mode\n\tif(!defined $ann) {\n\t    $ann = Bio::Annotation::SimpleValue->new(-tagname => $key);\n\t    $self->annotation->add_Annotation($ann);\n\t}\n\t$ann->value($val);\n    }\n    return $val;\n}\n\n\n=head2 _annotation_value_ary\n\n Title   : _annotation_value_ary\n Usage   :\n Function: Private method.\n Example :\n Returns : reference to the array of values\n Args    : annotation key (a string)\n           on set, reference to an array holding the values\n\n\n\nsub _annotation_value_ary{\n    my ($self,$key,$arr) = @_;\n\n    my $ac = $self->annotation;\n    if($arr) {\n\t# purge first\n\t$ac->remove_Annotations($key);\n\t# then add as many values as are present\n\tforeach my $val (@$arr) {\n\t    my $ann = Bio::Annotation::SimpleValue->new(-value => $val,\n\t\t\t\t\t\t\t-tagname => $key\n\t\t\t\t\t\t\t);\n\t    $ac->add_Annotation($ann);\n\t}\n    } else {\n\tmy @vals = map { $_->value(); } $ac->get_Annotations($key);\n\t$arr = [@vals];\n    }\n    return $arr;\n}\n\n\n=head2 _annotation_dblink\n\n Title   : _annotation_dblink\n Usage   :\n Function: Private method.\n Example :\n Returns : array of accessions for the given database (namespace)\n Args    : annotation key (a string)\n           dbname (a string) (optional on get, mandatory on set)\n           on set, accession or ID (a string), and version\n\n\n\nsub _annotation_dblink{\n    my ($self,$key,$dbname,$acc,$version) = @_;\n\n    if($acc) {\n\t# set mode -- this is adding here\n\tmy $ann = Bio::Annotation::DBLink->new(-tagname    => $key,\n\t\t\t\t\t       -primary_id => $acc,\n\t\t\t\t\t       -database   => $dbname,\n\t\t\t\t\t       -version    => $version);\n\t$self->annotation->add_Annotation($ann);\n\treturn 1;\n    } else {\n\t# get mode\n\tmy @anns = $self->annotation->get_Annotations($key);\n\t# filter out those that don't match the requested database\n\tif($dbname) {\n\t    @anns = grep { $_->database() eq $dbname; } @anns;\n\t}\n\treturn map { $_->primary_id(); } @anns;\n    }\n}\n\n=head2 _remove_dblink\n\n Title   : _remove_dblink\n Usage   :\n Function: Private method.\n Example :\n Returns : array of accessions for the given database (namespace)\n Args    : annotation key (a string)\n           dbname (a string) (optional)"},"detail":"($self,$key,$dbname)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"_remove_dblink","definition":"my","name":"$self","line":1433,"kind":13},{"containerName":"_remove_dblink","name":"$key","kind":13,"line":1433},{"containerName":"_remove_dblink","name":"$dbname","kind":13,"line":1433},{"line":1435,"kind":13,"localvar":"my","containerName":"_remove_dblink","name":"$ac","definition":"my"},{"kind":13,"line":1435,"containerName":"_remove_dblink","name":"$self"},{"containerName":"_remove_dblink","name":"annotation","line":1435,"kind":12},{"containerName":"_remove_dblink","name":"@anns","definition":"my","localvar":"my","kind":13,"line":1436},{"containerName":"_remove_dblink","name":"$dbname","kind":13,"line":1437},{"localvar":"my","name":"$ann","definition":"my","containerName":"_remove_dblink","line":1438,"kind":13},{"name":"$ac","containerName":"_remove_dblink","line":1438,"kind":13},{"line":1438,"kind":12,"name":"remove_Annotations","containerName":"_remove_dblink"},{"line":1438,"kind":13,"containerName":"_remove_dblink","name":"$key"},{"containerName":"_remove_dblink","name":"$ann","kind":13,"line":1439},{"containerName":"_remove_dblink","name":"database","line":1439,"kind":12},{"containerName":"_remove_dblink","name":"$dbname","kind":13,"line":1439},{"kind":13,"line":1440,"containerName":"_remove_dblink","name":"@anns"},{"line":1440,"kind":13,"name":"$ann","containerName":"_remove_dblink"},{"line":1442,"kind":13,"name":"$ac","containerName":"_remove_dblink"},{"kind":12,"line":1442,"containerName":"_remove_dblink","name":"add_Annotation"},{"kind":13,"line":1442,"name":"$ann","containerName":"_remove_dblink"},{"containerName":"_remove_dblink","name":"@anns","line":1446,"kind":13},{"kind":13,"line":1446,"name":"$ac","containerName":"_remove_dblink"},{"kind":12,"line":1446,"name":"remove_Annotations","containerName":"_remove_dblink"},{"containerName":"_remove_dblink","name":"$key","kind":13,"line":1446},{"kind":12,"line":1448,"containerName":"_remove_dblink","name":"primary_id"},{"containerName":"_remove_dblink","name":"@anns","kind":13,"line":1448}],"line":1432,"kind":12,"range":{"end":{"line":1449,"character":9999},"start":{"character":0,"line":1432}},"name":"_remove_dblink"}],"version":5}