{"vars":[{"name":"base","containerName":"","line":86,"kind":2},{"kind":12,"line":101,"children":[{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":102},{"line":102,"kind":13,"name":"@args","containerName":"new"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":104},{"name":"$class","containerName":"new","kind":13,"line":104},{"kind":13,"line":104,"containerName":"new","name":"@args"},{"name":"$self","containerName":"new","line":106,"kind":13},{"line":108,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":108,"containerName":"new","name":"_add_type_map"},{"kind":13,"line":109,"containerName":"new","name":"$self"},{"name":"_add_type_map","containerName":"new","line":109,"kind":12},{"line":110,"kind":13,"containerName":"new","name":"$self"},{"line":110,"kind":12,"containerName":"new","name":"_add_type_map"},{"name":"$self","containerName":"new","kind":13,"line":112}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"documentation":"1;\n# $Id: TypeManager.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TypeManager\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TypeManager - Manages types for annotation collections\n\n=head1 SYNOPSIS\n\n    # default type manager\n\n    $tm = Bio::Annotation::TypeManager->new();\n\n    # $key is a string or a Bio::Ontology::TermI compliant object\n    print \"The type for $key is \",$tm->type_for_key($key),\"\\n\";\n\n    if( !$tm->is_valid($key,$object) ) {\n        $self->throw(\"Invalid object for key $key\");\n    }\n\n=head1 DESCRIPTION\n\nManages types for annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::TypeManager;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n# new() can be inherited from Bio::Root::Root\n\n=head2 new\n\n Title   : new\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$class"},{"label":"@args"}],"label":"new($class,@args)"},"name":"new","range":{"end":{"character":9999,"line":113},"start":{"line":101,"character":0}}},{"line":104,"kind":12,"name":"SUPER","containerName":"new"},{"range":{"start":{"line":128,"character":0},"end":{"character":9999,"line":133}},"name":"type_for_key","detail":"($self,$key)","signature":{"parameters":[{"label":"$self"},{"label":"$key"}],"documentation":"1;\n# $Id: TypeManager.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TypeManager\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TypeManager - Manages types for annotation collections\n\n=head1 SYNOPSIS\n\n    # default type manager\n\n    $tm = Bio::Annotation::TypeManager->new();\n\n    # $key is a string or a Bio::Ontology::TermI compliant object\n    print \"The type for $key is \",$tm->type_for_key($key),\"\\n\";\n\n    if( !$tm->is_valid($key,$object) ) {\n        $self->throw(\"Invalid object for key $key\");\n    }\n\n=head1 DESCRIPTION\n\nManages types for annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::TypeManager;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n# new() can be inherited from Bio::Root::Root\n\n=head2 new\n\n Title   : new\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_type'} = {};\n\n   $self->_add_type_map('reference',\"Bio::Annotation::Reference\");\n   $self->_add_type_map('comment',\"Bio::Annotation::Comment\");\n   $self->_add_type_map('dblink',\"Bio::Annotation::DBLink\");\n\n   return $self;\n}\n\n\n=head2 type_for_key\n\n Title   : type_for_key\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"type_for_key($self,$key)"},"containerName":"main::","definition":"sub","line":128,"children":[{"line":129,"kind":13,"localvar":"my","containerName":"type_for_key","definition":"my","name":"$self"},{"line":129,"kind":13,"name":"$key","containerName":"type_for_key"},{"kind":13,"line":131,"name":"$key","containerName":"type_for_key"},{"name":"$key","containerName":"type_for_key","line":131,"kind":13},{"line":131,"kind":12,"name":"name","containerName":"type_for_key"},{"line":131,"kind":13,"name":"$key","containerName":"type_for_key"},{"containerName":"type_for_key","name":"$key","line":131,"kind":13},{"containerName":"type_for_key","name":"isa","line":131,"kind":12},{"name":"$self","containerName":"type_for_key","line":132,"kind":13},{"line":132,"kind":13,"name":"$key","containerName":"type_for_key"}],"kind":12},{"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"is_valid","line":149,"kind":13},{"line":149,"kind":13,"name":"$key","containerName":"is_valid"},{"containerName":"is_valid","name":"$object","kind":13,"line":149},{"kind":13,"line":151,"name":"$object","containerName":"is_valid"},{"kind":13,"line":151,"name":"$object","containerName":"is_valid"},{"name":"$self","containerName":"is_valid","kind":13,"line":152},{"name":"throw","containerName":"is_valid","line":152,"kind":12},{"kind":13,"line":155,"containerName":"is_valid","name":"$object"},{"kind":12,"line":155,"name":"isa","containerName":"is_valid"},{"name":"$self","containerName":"is_valid","kind":13,"line":155},{"name":"type_for_key","containerName":"is_valid","kind":12,"line":155},{"name":"$key","containerName":"is_valid","kind":13,"line":155}],"line":148,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$key"},{"label":"$object"}],"documentation":"1;\n# $Id: TypeManager.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TypeManager\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TypeManager - Manages types for annotation collections\n\n=head1 SYNOPSIS\n\n    # default type manager\n\n    $tm = Bio::Annotation::TypeManager->new();\n\n    # $key is a string or a Bio::Ontology::TermI compliant object\n    print \"The type for $key is \",$tm->type_for_key($key),\"\\n\";\n\n    if( !$tm->is_valid($key,$object) ) {\n        $self->throw(\"Invalid object for key $key\");\n    }\n\n=head1 DESCRIPTION\n\nManages types for annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::TypeManager;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n# new() can be inherited from Bio::Root::Root\n\n=head2 new\n\n Title   : new\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_type'} = {};\n\n   $self->_add_type_map('reference',\"Bio::Annotation::Reference\");\n   $self->_add_type_map('comment',\"Bio::Annotation::Comment\");\n   $self->_add_type_map('dblink',\"Bio::Annotation::DBLink\");\n\n   return $self;\n}\n\n\n=head2 type_for_key\n\n Title   : type_for_key\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub type_for_key{\n   my ($self,$key) = @_;\n\n   $key = $key->name() if ref($key) && $key->isa(\"Bio::Ontology::TermI\");\n   return $self->{'_type'}->{$key};\n}\n\n\n=head2 is_valid\n\n Title   : is_valid\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","label":"is_valid($self,$key,$object)"},"detail":"($self,$key,$object)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":148},"end":{"line":160,"character":9999}},"name":"is_valid"},{"kind":12,"line":175,"children":[{"localvar":"my","containerName":"_add_type_map","name":"$self","definition":"my","line":176,"kind":13},{"name":"$key","containerName":"_add_type_map","kind":13,"line":176},{"containerName":"_add_type_map","name":"$type","line":176,"kind":13},{"line":178,"kind":13,"name":"$key","containerName":"_add_type_map"},{"kind":13,"line":178,"name":"$key","containerName":"_add_type_map"},{"line":178,"kind":12,"containerName":"_add_type_map","name":"name"},{"name":"$key","containerName":"_add_type_map","kind":13,"line":178},{"line":178,"kind":13,"name":"$key","containerName":"_add_type_map"},{"line":178,"kind":12,"name":"isa","containerName":"_add_type_map"},{"name":"$self","containerName":"_add_type_map","line":179,"kind":13},{"name":"$key","containerName":"_add_type_map","kind":13,"line":179},{"kind":13,"line":179,"containerName":"_add_type_map","name":"$type"}],"containerName":"main::","definition":"sub","detail":"($self,$key,$type)","signature":{"label":"_add_type_map($self,$key,$type)","documentation":"1;\n# $Id: TypeManager.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TypeManager\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TypeManager - Manages types for annotation collections\n\n=head1 SYNOPSIS\n\n    # default type manager\n\n    $tm = Bio::Annotation::TypeManager->new();\n\n    # $key is a string or a Bio::Ontology::TermI compliant object\n    print \"The type for $key is \",$tm->type_for_key($key),\"\\n\";\n\n    if( !$tm->is_valid($key,$object) ) {\n        $self->throw(\"Invalid object for key $key\");\n    }\n\n=head1 DESCRIPTION\n\nManages types for annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this\nand other Bioperl modules. Send your comments and suggestions preferably\n to one of the Bioperl mailing lists.\nYour participation is much appreciated.\n\n  bioperl-l@bioperl.org\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.\nBug reports can be submitted via the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::TypeManager;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n\n\nuse base qw(Bio::Root::Root);\n# new() can be inherited from Bio::Root::Root\n\n=head2 new\n\n Title   : new\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_type'} = {};\n\n   $self->_add_type_map('reference',\"Bio::Annotation::Reference\");\n   $self->_add_type_map('comment',\"Bio::Annotation::Comment\");\n   $self->_add_type_map('dblink',\"Bio::Annotation::DBLink\");\n\n   return $self;\n}\n\n\n=head2 type_for_key\n\n Title   : type_for_key\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub type_for_key{\n   my ($self,$key) = @_;\n\n   $key = $key->name() if ref($key) && $key->isa(\"Bio::Ontology::TermI\");\n   return $self->{'_type'}->{$key};\n}\n\n\n=head2 is_valid\n\n Title   : is_valid\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub is_valid{\n   my ($self,$key,$object) = @_;\n\n   if( !defined $object || !ref $object ) {\n       $self->throw(\"Cannot type an object [$object]!\");\n   }\n\n   if( !$object->isa($self->type_for_key($key)) ) {\n       return 0;\n   } else {\n       return 1;\n   }\n}\n\n\n=head2 _add_type_map\n\n Title   : _add_type_map\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$type"}]},"name":"_add_type_map","range":{"end":{"character":9999,"line":180},"start":{"character":0,"line":175}}}],"version":5}