{"version":5,"vars":[{"name":"base","containerName":"","line":121,"kind":2},{"name":"new","range":{"end":{"line":162,"character":9999},"start":{"line":138,"character":0}},"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: TagTree.pm 11693 2007-09-17 20:54:04Z cjfields $\n#\n# BioPerl module for Bio::Annotation::TagTree\n#\n# Cared for Chris Fields\n#\n# You may distribute this module under the same terms as perl itself.\n# Refer to the Perl Artistic License (see the license accompanying this\n# software package, or see http://www.perl.com/language/misc/Artistic.html)\n# for the terms under which you may use, modify, and redistribute this module.\n#\n# THIS PACKAGE IS PROVIDED \"AS IS\" AND WITHOUT ANY EXPRESS OR IMPLIED\n# WARRANTIES, INCLUDING, WITHOUT LIMITATION, THE IMPLIED WARRANTIES OF\n# MERCHANTIBILITY AND FITNESS FOR A PARTICULAR PURPOSE.\n#\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::TagTree - AnnotationI with tree-like hierarchal key-value\nrelationships ('structured tags') that can be represented as simple text.\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::TagTree;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n\n   # data structure can be an array reference with a data structure\n   # corresponding to that defined by Data::Stag:\n\n   my $sv = Bio::Annotation::TagTree->new(-tagname => 'mytag1',\n                                          -value => $data_structure);\n   $col->add_Annotation($sv);\n\n   # regular text passed is parsed based on the tagformat().\n   my $sv2 = Bio::Annotation::TagTree->new(-tagname => 'mytag2',\n                                          -tagformat => 'xml',\n                                          -value => $xmltext);\n   $col->add_Annotation($sv2);\n\n=head1 DESCRIPTION\n\nThis takes tagged data values and stores them in a hierarchal structured\nelement-value hierarchy (complements of Chris Mungall's Data::Stag module). Data\ncan then be represented as text using a variety of output formats (indention,\nitext, xml, spxr). Furthermore, the data structure can be queried using various\nmeans. See L<Data::Stag> for details.\n\nData passed in using value() or the '-value' parameter upon instantiation\ncan either be:\n\n1) an array reference corresponding to the data structure for Data::Stag;\n\n2) a text string in 'xml', 'itext', 'spxr', or 'indent' format. The default\nformat is 'xml'; this can be changed using tagformat() prior to using value() or\nby passing in the proper format using '-tagformat' upon instantiation;\n\n3) another Bio::Annotation::TagTree or Data::Stag node instance.  In both cases\na deep copy (duplicate) of the instance is generated.\n\nBeyond checking for an array reference no format guessing occurs (so, for\nroundtrip tests ensure that the IO formats correspond). For now, we recommend\nwhen using text input to set tagformat() to one of these formats prior to data\nloading to ensure the proper Data::Stag parser is selected. After data loading,\nthe tagformat() can be changed to change the text string format returned by\nvalue(). (this may be rectified in the future)\n\nThis Annotation type is fully BioSQL compatible and could be considered a\ntemporary replacement for nested Bio::Annotation::Collections, at least until\nBioSQL and bioperl-db can support nested annotation collections.\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nor the web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR \n\nChris Fields\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal\nmethods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::Annotation::TagTree;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse base qw(Bio::Annotation::SimpleValue);\nuse Data::Stag;\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::TagTree->new();\n Function: Instantiate a new TagTree object\n Returns : Bio::Annotation::TagTree object\n Args    : -value => $value to initialize the object data field [optional]\n           -tagname => $tag to initialize the tagname [optional]\n           -tagformat => format for output [optional]\n                      (types 'xml', 'itext', 'sxpr', 'indent', default = 'itext')\n           -node => Data::Stag node or Bio::Annotation::TagTree instance"},"kind":12,"line":138,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":139},{"line":139,"kind":13,"containerName":"new","name":"@args"},{"name":"$self","definition":"my","containerName":"new","localvar":"my","kind":13,"line":140},{"name":"$class","containerName":"new","kind":13,"line":140},{"kind":13,"line":141,"containerName":"new","name":"$node","definition":"my","localvar":"my"},{"containerName":"new","name":"$value","line":141,"kind":13},{"line":141,"kind":13,"name":"$tag","containerName":"new"},{"containerName":"new","name":"$format","line":141,"kind":13},{"line":141,"kind":13,"name":"$verbose","containerName":"new"},{"containerName":"new","name":"$self","kind":13,"line":141},{"name":"_rearrange","containerName":"new","line":141,"kind":12},{"line":152,"kind":13,"name":"@args","containerName":"new"},{"line":153,"kind":13,"containerName":"new","name":"$self"},{"containerName":"new","name":"throw","line":153,"kind":12},{"name":"$node","containerName":"new","kind":13,"line":154},{"line":154,"kind":13,"name":"$value","containerName":"new"},{"kind":13,"line":155,"containerName":"new","name":"$tag"},{"line":155,"kind":13,"containerName":"new","name":"$self"},{"kind":12,"line":155,"containerName":"new","name":"tagname"},{"name":"$tag","containerName":"new","kind":13,"line":155},{"kind":13,"line":156,"containerName":"new","name":"$format"},{"name":"$self","containerName":"new","kind":13,"line":157},{"kind":12,"line":157,"containerName":"new","name":"tagformat"},{"line":157,"kind":13,"name":"$format","containerName":"new"},{"name":"$value","containerName":"new","kind":13,"line":158},{"name":"$self","containerName":"new","kind":13,"line":158},{"containerName":"new","name":"value","kind":12,"line":158},{"kind":13,"line":158,"containerName":"new","name":"$value"},{"name":"$node","containerName":"new","kind":13,"line":159},{"containerName":"new","name":"$self","kind":13,"line":159},{"containerName":"new","name":"node","line":159,"kind":12},{"name":"$node","containerName":"new","kind":13,"line":159},{"containerName":"new","name":"$verbose","line":160,"kind":13},{"kind":13,"line":160,"name":"$self","containerName":"new"},{"kind":12,"line":160,"name":"verbose","containerName":"new"},{"name":"$verbose","containerName":"new","kind":13,"line":160},{"name":"$self","containerName":"new","kind":13,"line":161}]},{"line":139,"kind":2,"name":"Stag","containerName":"Data"},{"containerName":"new","name":"SUPER","kind":12,"line":140},{"range":{"end":{"character":9999,"line":181},"start":{"line":178,"character":0}},"name":"as_text","detail":"($self)","signature":{"label":"as_text($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","definition":"sub","line":178,"children":[{"definition":"my","name":"$self","containerName":"as_text","localvar":"my","kind":13,"line":179},{"line":180,"kind":13,"name":"$self","containerName":"as_text"},{"name":"value","containerName":"as_text","kind":12,"line":180}],"kind":12},{"containerName":null,"definition":"my","name":"%DEFAULT_CB","localvar":"my","kind":13,"line":200},{"line":200,"kind":12,"containerName":"main::","name":"value"},{"range":{"end":{"character":9999,"line":207},"start":{"character":0,"line":202}},"name":"display_text","line":202,"children":[{"containerName":"display_text","definition":"my","name":"$self","localvar":"my","kind":13,"line":203},{"kind":13,"line":203,"name":"$cb","containerName":"display_text"},{"containerName":"display_text","name":"$cb","kind":13,"line":204},{"line":204,"kind":13,"containerName":"display_text","name":"$DEFAULT_CB"},{"name":"$self","containerName":"display_text","line":205,"kind":13},{"name":"throw","containerName":"display_text","kind":12,"line":205},{"name":"$cb","containerName":"display_text","kind":13,"line":205},{"line":206,"kind":13,"name":"$cb","containerName":"display_text"},{"line":206,"kind":13,"name":"$self","containerName":"display_text"}],"kind":12,"detail":"($self,$cb)","signature":{"label":"display_text($self,$cb)","documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}]},"containerName":"main::","definition":"sub"},{"children":[{"kind":13,"line":224,"definition":"my","name":"$self","containerName":"hash_tree","localvar":"my"},{"localvar":"my","definition":"my","name":"$h","containerName":"hash_tree","line":225,"kind":13},{"line":226,"kind":13,"containerName":"hash_tree","name":"$h"},{"name":"$self","containerName":"hash_tree","line":226,"kind":13},{"containerName":"hash_tree","name":"value","kind":12,"line":226}],"line":223,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"","label":"hash_tree($self)"},"detail":"($self)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":223},"end":{"character":9999,"line":227}},"name":"hash_tree"},{"range":{"end":{"line":249,"character":9999},"start":{"character":0,"line":243}},"name":"tagname","children":[{"localvar":"my","containerName":"tagname","name":"$self","definition":"my","line":244,"kind":13},{"kind":13,"line":244,"containerName":"tagname","name":"$value"},{"name":"$value","containerName":"tagname","kind":13,"line":245},{"line":246,"kind":13,"containerName":"tagname","name":"$self"},{"name":"$value","containerName":"tagname","line":246,"kind":13},{"name":"$self","containerName":"tagname","kind":13,"line":248}],"line":243,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"","label":"tagname($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"line":265,"children":[{"containerName":"value","definition":"my","name":"$self","localvar":"my","kind":13,"line":266},{"kind":13,"line":266,"containerName":"value","name":"$value"},{"containerName":"value","name":"$format","definition":"my","localvar":"my","kind":13,"line":269},{"line":269,"kind":13,"containerName":"value","name":"$self"},{"name":"tagformat","containerName":"value","line":269,"kind":12},{"name":"$value","containerName":"value","line":270,"kind":13},{"kind":13,"line":271,"containerName":"value","name":"$value"},{"name":"$value","containerName":"value","line":272,"kind":13},{"kind":13,"line":276,"containerName":"value","name":"$self"},{"name":"nodify","containerName":"value","kind":12,"line":276},{"name":"$value","containerName":"value","kind":13,"line":276},{"line":281,"kind":13,"containerName":"value","name":"$self"},{"line":281,"kind":12,"containerName":"value","name":"node"},{"name":"$value","containerName":"value","line":281,"kind":13},{"line":287,"kind":13,"localvar":"my","name":"$h","definition":"my","containerName":"value"},{"name":"getformathandler","containerName":"value","kind":12,"line":287},{"containerName":"value","name":"$format","line":287,"kind":13},{"line":288,"kind":13,"containerName":"value","name":"$self"},{"line":288,"kind":12,"containerName":"value","name":"from"},{"containerName":"value","name":"$format","kind":13,"line":288},{"kind":13,"line":288,"name":"$value","containerName":"value"},{"kind":13,"line":290,"name":"$self","containerName":"value"},{"kind":12,"line":290,"name":"throw","containerName":"value"},{"line":297,"kind":13,"name":"$self","containerName":"value"},{"kind":12,"line":297,"containerName":"value","name":"node"},{"line":297,"kind":13,"containerName":"value","name":"$format"}],"kind":12,"detail":"($self,$value)","signature":{"label":"value($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":""},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":265},"end":{"character":9999,"line":298}},"name":"value"},{"line":276,"kind":12,"name":"db"},{"name":"Data","containerName":"Stag","kind":12,"line":276},{"containerName":"Stag","name":"Data","line":287,"kind":12},{"line":288,"kind":12,"name":"db"},{"kind":12,"line":288,"containerName":"Stag","name":"Data"},{"name":"%IS_VALID_FORMAT","definition":"my","containerName":null,"localvar":"my","kind":13,"line":311},{"line":313,"children":[{"line":314,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"tagformat"},{"kind":13,"line":314,"containerName":"tagformat","name":"$value"},{"kind":13,"line":315,"containerName":"tagformat","name":"$value"},{"line":316,"kind":13,"name":"$self","containerName":"tagformat"},{"kind":12,"line":316,"name":"throw","containerName":"tagformat"},{"kind":13,"line":317,"containerName":"tagformat","name":"%IS_VALID_FORMAT"},{"name":"$IS_VALID_FORMAT","containerName":"tagformat","line":318,"kind":13},{"line":318,"kind":13,"containerName":"tagformat","name":"$value"},{"name":"$self","containerName":"tagformat","line":319,"kind":13},{"containerName":"tagformat","name":"$value","kind":13,"line":319},{"name":"$self","containerName":"tagformat","kind":13,"line":321}],"kind":12,"detail":"($self,$value)","signature":{"label":"tagformat($self,$value)","documentation":"","parameters":[{"label":"$self"},{"label":"$value"}]},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":322},"start":{"line":313,"character":0}},"name":"tagformat"},{"kind":12,"children":[{"localvar":"my","containerName":"node","definition":"my","name":"$self","line":337,"kind":13},{"name":"$value","containerName":"node","kind":13,"line":337},{"kind":13,"line":337,"containerName":"node","name":"$copy"},{"kind":13,"line":338,"name":"$value","containerName":"node"},{"kind":13,"line":338,"name":"$value","containerName":"node"},{"name":"$self","containerName":"node","kind":13,"line":339},{"line":340,"kind":13,"containerName":"node","name":"$value"},{"name":"isa","containerName":"node","kind":12,"line":340},{"kind":13,"line":341,"containerName":"node","name":"$copy"},{"line":341,"kind":13,"name":"$copy","containerName":"node"},{"line":341,"kind":13,"name":"$value","containerName":"node"},{"name":"duplicate","containerName":"node","line":341,"kind":12},{"kind":13,"line":341,"containerName":"node","name":"$value"},{"kind":13,"line":342,"name":"$value","containerName":"node"},{"containerName":"node","name":"isa","line":342,"kind":12},{"containerName":"node","name":"$copy","kind":13,"line":343},{"containerName":"node","name":"$copy","line":343,"kind":13},{"name":"$value","containerName":"node","kind":13,"line":343},{"name":"node","containerName":"node","kind":12,"line":343},{"line":343,"kind":12,"name":"duplicate","containerName":"node"},{"kind":13,"line":343,"containerName":"node","name":"$value"},{"kind":12,"line":343,"name":"node","containerName":"node"},{"line":344,"kind":13,"containerName":"node","name":"$self"},{"kind":12,"line":344,"containerName":"node","name":"throw"},{"name":"$self","containerName":"node","kind":13,"line":349},{"kind":13,"line":350,"name":"$self","containerName":"node"},{"containerName":"node","name":"new","kind":12,"line":350},{"name":"$self","containerName":"node","line":352,"kind":13}],"line":336,"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$value"},{"label":"$copy"}],"label":"node($self,$value,$copy)"},"detail":"($self,$value,$copy)","name":"node","range":{"start":{"line":336,"character":0},"end":{"character":9999,"line":353}}},{"containerName":"Stag","name":"Data","kind":12,"line":350},{"line":378,"children":[{"localvar":"my","containerName":"element","definition":"my","name":"$self","line":379,"kind":13},{"kind":13,"line":380,"name":"$self","containerName":"element"},{"name":"node","containerName":"element","line":380,"kind":12},{"line":380,"kind":12,"name":"element","containerName":"element"}],"kind":12,"range":{"start":{"line":378,"character":0},"end":{"line":381,"character":9999}},"containerName":"main::","definition":"sub","name":"element"},{"children":[{"kind":13,"line":395,"containerName":"data","definition":"my","name":"$self","localvar":"my"},{"containerName":"data","name":"$self","line":396,"kind":13},{"containerName":"data","name":"node","line":396,"kind":12},{"line":396,"kind":12,"containerName":"data","name":"data"}],"line":394,"kind":12,"range":{"start":{"character":0,"line":394},"end":{"line":397,"character":9999}},"definition":"sub","name":"data","containerName":"main::"},{"kind":12,"line":418,"children":[{"localvar":"my","containerName":"children","definition":"my","name":"$self","line":419,"kind":13},{"line":420,"kind":13,"containerName":"children","name":"$self"},{"containerName":"children","name":"node","line":420,"kind":12},{"line":420,"kind":12,"containerName":"children","name":"children"}],"containerName":"main::","definition":"sub","name":"children","range":{"start":{"character":0,"line":418},"end":{"line":421,"character":9999}}},{"containerName":"main::","definition":"sub","name":"subnodes","range":{"end":{"line":439,"character":9999},"start":{"character":0,"line":436}},"kind":12,"line":436,"children":[{"line":437,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"subnodes"},{"containerName":"subnodes","name":"$self","kind":13,"line":438},{"containerName":"subnodes","name":"node","line":438,"kind":12},{"name":"subnodes","containerName":"subnodes","kind":12,"line":438}]},{"detail":"($self,@vals)","signature":{"parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":"","label":"get($self,@vals)"},"containerName":"main::","definition":"sub","line":453,"children":[{"kind":13,"line":454,"name":"$self","definition":"my","containerName":"get","localvar":"my"},{"name":"@vals","containerName":"get","kind":13,"line":454},{"containerName":"get","name":"$self","line":455,"kind":13},{"containerName":"get","name":"node","kind":12,"line":455},{"name":"get","containerName":"get","line":455,"kind":12},{"containerName":"get","name":"@vals","kind":13,"line":455}],"kind":12,"range":{"start":{"character":0,"line":453},"end":{"character":9999,"line":456}},"name":"get"},{"name":"find","range":{"start":{"character":0,"line":470},"end":{"line":473,"character":9999}},"kind":12,"children":[{"localvar":"my","containerName":"find","definition":"my","name":"$self","line":471,"kind":13},{"containerName":"find","name":"@vals","kind":13,"line":471},{"line":472,"kind":13,"containerName":"find","name":"$self"},{"name":"node","containerName":"find","kind":12,"line":472},{"line":472,"kind":12,"name":"find","containerName":"find"},{"line":472,"kind":13,"containerName":"find","name":"@vals"}],"line":470,"definition":"sub","containerName":"main::","signature":{"label":"find($self,@vals)","parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":""},"detail":"($self,@vals)"},{"name":"findnode","range":{"end":{"character":9999,"line":490},"start":{"line":487,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"findnode($self,@vals)","documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}]},"detail":"($self,@vals)","kind":12,"children":[{"containerName":"findnode","definition":"my","name":"$self","localvar":"my","kind":13,"line":488},{"line":488,"kind":13,"name":"@vals","containerName":"findnode"},{"kind":13,"line":489,"containerName":"findnode","name":"$self"},{"name":"node","containerName":"findnode","kind":12,"line":489},{"line":489,"kind":12,"name":"findnode","containerName":"findnode"},{"name":"@vals","containerName":"findnode","kind":13,"line":489}],"line":487},{"signature":{"label":"findval($self,@vals)","parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":""},"detail":"($self,@vals)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"findval","definition":"my","name":"$self","line":504,"kind":13},{"containerName":"findval","name":"@vals","kind":13,"line":504},{"containerName":"findval","name":"$self","line":505,"kind":13},{"name":"node","containerName":"findval","kind":12,"line":505},{"containerName":"findval","name":"findval","kind":12,"line":505},{"line":505,"kind":13,"name":"@vals","containerName":"findval"}],"line":503,"kind":12,"range":{"start":{"line":503,"character":0},"end":{"character":9999,"line":506}},"name":"findval"},{"name":"addchild","range":{"start":{"character":0,"line":526},"end":{"line":544,"character":9999}},"kind":12,"children":[{"line":527,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"addchild"},{"kind":13,"line":527,"name":"@vals","containerName":"addchild"},{"containerName":"addchild","name":"$self","line":530,"kind":13},{"name":"element","containerName":"addchild","line":530,"kind":12},{"name":"@vals","containerName":"addchild","line":533,"kind":13},{"containerName":"addchild","name":"$self","kind":13,"line":533},{"kind":12,"line":533,"name":"value","containerName":"addchild"},{"kind":13,"line":533,"name":"@vals","containerName":"addchild"},{"kind":13,"line":533,"containerName":"addchild","name":"$self"},{"line":533,"kind":12,"name":"value","containerName":"addchild"},{"containerName":"addchild","name":"$vals","kind":13,"line":533},{"kind":13,"line":534,"containerName":"addchild","name":"$self"},{"kind":13,"line":536,"name":"$self","containerName":"addchild"},{"kind":12,"line":536,"containerName":"addchild","name":"node"},{"name":"ntnodes","containerName":"addchild","line":536,"kind":12},{"containerName":"addchild","name":"$self","line":539,"kind":13},{"kind":12,"line":539,"name":"throw","containerName":"addchild"},{"name":"$self","containerName":"addchild","kind":13,"line":542},{"containerName":"addchild","name":"node","kind":12,"line":542},{"line":542,"kind":12,"containerName":"addchild","name":"addchild"},{"name":"@vals","containerName":"addchild","line":542,"kind":13}],"line":526,"definition":"sub","containerName":"main::","signature":{"label":"addchild($self,@vals)","parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":""},"detail":"($self,@vals)"},{"name":"db","kind":12,"line":534},{"detail":"($self,@vals)","signature":{"label":"add($self,@vals)","documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}]},"containerName":"main::","definition":"sub","line":561,"children":[{"line":562,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"add"},{"line":562,"kind":13,"name":"@vals","containerName":"add"},{"line":565,"kind":13,"name":"$self","containerName":"add"},{"name":"node","containerName":"add","kind":12,"line":565},{"kind":12,"line":565,"containerName":"add","name":"element"},{"line":566,"kind":13,"containerName":"add","name":"$self"},{"line":566,"kind":12,"name":"throw","containerName":"add"},{"containerName":"add","name":"$self","kind":13,"line":568},{"containerName":"add","name":"node","kind":12,"line":568},{"kind":12,"line":568,"containerName":"add","name":"add"},{"line":568,"kind":13,"name":"@vals","containerName":"add"}],"kind":12,"range":{"start":{"line":561,"character":0},"end":{"character":9999,"line":569}},"name":"add"},{"containerName":"main::","definition":"sub","detail":"($self,@vals)","signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}],"label":"set($self,@vals)"},"kind":12,"line":583,"children":[{"definition":"my","name":"$self","containerName":"set","localvar":"my","kind":13,"line":584},{"line":584,"kind":13,"containerName":"set","name":"@vals"},{"containerName":"set","name":"$self","line":587,"kind":13},{"kind":12,"line":587,"containerName":"set","name":"node"},{"containerName":"set","name":"element","line":587,"kind":12},{"name":"$self","containerName":"set","kind":13,"line":588},{"name":"throw","containerName":"set","line":588,"kind":12},{"kind":13,"line":590,"containerName":"set","name":"$self"},{"name":"node","containerName":"set","kind":12,"line":590},{"line":590,"kind":12,"name":"set","containerName":"set"},{"name":"@vals","containerName":"set","line":590,"kind":13}],"name":"set","range":{"start":{"character":0,"line":583},"end":{"character":9999,"line":591}}},{"containerName":"main::","definition":"sub","detail":"($self,@vals)","signature":{"label":"unset($self,@vals)","documentation":"","parameters":[{"label":"$self"},{"label":"@vals"}]},"kind":12,"line":604,"children":[{"name":"$self","definition":"my","containerName":"unset","localvar":"my","kind":13,"line":605},{"name":"@vals","containerName":"unset","kind":13,"line":605},{"kind":13,"line":606,"containerName":"unset","name":"$self"},{"containerName":"unset","name":"node","line":606,"kind":12},{"kind":12,"line":606,"name":"unset","containerName":"unset"},{"containerName":"unset","name":"@vals","kind":13,"line":606}],"name":"unset","range":{"end":{"line":607,"character":9999},"start":{"character":0,"line":604}}},{"range":{"end":{"line":622,"character":9999},"start":{"character":0,"line":619}},"name":"free","line":619,"children":[{"localvar":"my","containerName":"free","definition":"my","name":"$self","line":620,"kind":13},{"line":621,"kind":13,"name":"$self","containerName":"free"},{"containerName":"free","name":"node","kind":12,"line":621},{"name":"free","containerName":"free","line":621,"kind":12}],"kind":12,"detail":"($self)","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"free($self)"},"containerName":"main::","definition":"sub"},{"definition":"sub","containerName":"main::","signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"hash($self)"},"detail":"($self)","kind":12,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"hash","line":636,"kind":13},{"containerName":"hash","name":"$self","line":637,"kind":13},{"name":"node","containerName":"hash","line":637,"kind":12},{"line":637,"kind":12,"containerName":"hash","name":"hash"}],"line":635,"name":"hash","range":{"start":{"line":635,"character":0},"end":{"character":9999,"line":638}}},{"line":652,"children":[{"line":653,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"pairs"},{"containerName":"pairs","name":"$self","kind":13,"line":654},{"name":"node","containerName":"pairs","kind":12,"line":654},{"containerName":"pairs","name":"pairs","line":654,"kind":12}],"kind":12,"detail":"($self)","signature":{"label":"pairs($self)","parameters":[{"label":"$self"}],"documentation":""},"containerName":"main::","definition":"sub","range":{"start":{"line":652,"character":0},"end":{"character":9999,"line":655}},"name":"pairs"},{"containerName":"main::","definition":"sub","detail":"($self,@vals)","signature":{"parameters":[{"label":"$self"},{"label":"@vals"}],"documentation":"","label":"qmatch($self,@vals)"},"kind":12,"line":668,"children":[{"localvar":"my","containerName":"qmatch","name":"$self","definition":"my","line":669,"kind":13},{"line":669,"kind":13,"containerName":"qmatch","name":"@vals"},{"name":"$self","containerName":"qmatch","kind":13,"line":670},{"containerName":"qmatch","name":"node","line":670,"kind":12},{"line":670,"kind":12,"containerName":"qmatch","name":"qmatch"},{"name":"@vals","containerName":"qmatch","kind":13,"line":670}],"name":"qmatch","range":{"start":{"line":668,"character":0},"end":{"character":9999,"line":671}}},{"range":{"end":{"character":9999,"line":686},"start":{"character":0,"line":683}},"name":"tnodes","children":[{"kind":13,"line":684,"containerName":"tnodes","name":"$self","definition":"my","localvar":"my"},{"name":"$self","containerName":"tnodes","kind":13,"line":685},{"containerName":"tnodes","name":"node","kind":12,"line":685},{"line":685,"kind":12,"containerName":"tnodes","name":"tnodes"}],"line":683,"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"}],"label":"tnodes($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"label":"ntnodes($self)","parameters":[{"label":"$self"}],"documentation":""},"kind":12,"line":698,"children":[{"definition":"my","name":"$self","containerName":"ntnodes","localvar":"my","kind":13,"line":699},{"name":"$self","containerName":"ntnodes","kind":13,"line":700},{"name":"node","containerName":"ntnodes","line":700,"kind":12},{"containerName":"ntnodes","name":"ntnodes","line":700,"kind":12}],"name":"ntnodes","range":{"start":{"character":0,"line":698},"end":{"line":701,"character":9999}}},{"kind":12,"line":721,"children":[{"localvar":"my","containerName":"get_all_values","name":"$self","definition":"my","line":722,"kind":13},{"localvar":"my","containerName":"get_all_values","definition":"my","name":"@kids","line":723,"kind":13},{"kind":13,"line":723,"name":"$self","containerName":"get_all_values"},{"name":"children","containerName":"get_all_values","kind":12,"line":723},{"kind":13,"line":724,"definition":"my","name":"@vals","containerName":"get_all_values","localvar":"my"},{"kind":13,"line":725,"name":"$val","definition":"my","containerName":"get_all_values","localvar":"my"},{"containerName":"get_all_values","name":"@kids","kind":13,"line":725},{"containerName":"get_all_values","name":"$val","kind":13,"line":726},{"kind":13,"line":726,"containerName":"get_all_values","name":"@kids"},{"line":726,"kind":13,"containerName":"get_all_values","name":"$val"},{"kind":12,"line":726,"containerName":"get_all_values","name":"children"},{"kind":13,"line":726,"containerName":"get_all_values","name":"@vals"},{"kind":13,"line":726,"containerName":"get_all_values","name":"$val"},{"kind":13,"line":728,"containerName":"get_all_values","name":"@vals"}],"containerName":"main::","definition":"sub","name":"get_all_values","range":{"end":{"line":729,"character":9999},"start":{"character":0,"line":721}}}]}