{"version":5,"vars":[{"line":82,"kind":2,"containerName":"","name":"base"},{"name":"new","range":{"start":{"line":96,"character":0},"end":{"character":9999,"line":110}},"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: SimpleValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::SimpleValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::SimpleValue - A simple scalar\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::SimpleValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::SimpleValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::SimpleValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n#use Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::SimpleValue->new();\n Function: Instantiate a new SimpleValue object\n Returns : Bio::Annotation::SimpleValue object\n Args    : -value    => $value to initialize the object data field [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]","label":"new($class,@args)"},"detail":"($class,@args)","kind":12,"children":[{"definition":"my","name":"$class","containerName":"new","localvar":"my","kind":13,"line":97},{"kind":13,"line":97,"containerName":"new","name":"@args"},{"containerName":"new","name":"$self","definition":"my","localvar":"my","kind":13,"line":99},{"name":"$class","containerName":"new","kind":13,"line":99},{"name":"@args","containerName":"new","kind":13,"line":99},{"kind":13,"line":101,"definition":"my","name":"$value","containerName":"new","localvar":"my"},{"name":"$tag","containerName":"new","line":101,"kind":13},{"name":"$term","containerName":"new","line":101,"kind":13},{"name":"$self","containerName":"new","line":102,"kind":13},{"name":"_rearrange","containerName":"new","line":102,"kind":12},{"kind":13,"line":102,"containerName":"new","name":"@args"},{"containerName":"new","name":"$term","kind":13,"line":105},{"containerName":"new","name":"$self","kind":13,"line":105},{"containerName":"new","name":"tag_term","line":105,"kind":12},{"kind":13,"line":105,"name":"$term","containerName":"new"},{"kind":13,"line":106,"containerName":"new","name":"$value"},{"kind":13,"line":106,"name":"$self","containerName":"new"},{"line":106,"kind":12,"name":"value","containerName":"new"},{"name":"$value","containerName":"new","kind":13,"line":106},{"name":"$tag","containerName":"new","line":107,"kind":13},{"line":107,"kind":13,"containerName":"new","name":"$self"},{"name":"tagname","containerName":"new","kind":12,"line":107},{"kind":13,"line":107,"name":"$tag","containerName":"new"},{"line":109,"kind":13,"containerName":"new","name":"$self"}],"line":96},{"line":99,"kind":12,"containerName":"new","name":"SUPER"},{"detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: SimpleValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::SimpleValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::SimpleValue - A simple scalar\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::SimpleValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::SimpleValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::SimpleValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n#use Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::SimpleValue->new();\n Function: Instantiate a new SimpleValue object\n Returns : Bio::Annotation::SimpleValue object\n Args    : -value    => $value to initialize the object data field [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($value,$tag,$term) =\n       $self->_rearrange([qw(VALUE TAGNAME TAG_TERM)], @args);\n\n   # set the term first\n   defined $term   && $self->tag_term($term);\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none","label":"as_text($self)"},"containerName":"main::","definition":"sub","line":128,"children":[{"kind":13,"line":129,"name":"$self","definition":"my","containerName":"as_text","localvar":"my"},{"name":"$self","containerName":"as_text","line":131,"kind":13},{"name":"value","containerName":"as_text","kind":12,"line":131}],"kind":12,"range":{"start":{"character":0,"line":128},"end":{"line":132,"character":9999}},"name":"as_text"},{"containerName":null,"definition":"my","name":"%DEFAULT_CB","localvar":"my","kind":13,"line":151},{"kind":12,"line":151,"containerName":"main::","name":"value"},{"detail":"($self,$cb)","signature":{"label":"display_text($self,$cb)","parameters":[{"label":"$self"},{"label":"$cb"}],"documentation":""},"containerName":"main::","definition":"sub","line":153,"children":[{"name":"$self","definition":"my","containerName":"display_text","localvar":"my","kind":13,"line":154},{"name":"$cb","containerName":"display_text","line":154,"kind":13},{"line":155,"kind":13,"containerName":"display_text","name":"$cb"},{"kind":13,"line":155,"containerName":"display_text","name":"$DEFAULT_CB"},{"kind":13,"line":156,"name":"$self","containerName":"display_text"},{"line":156,"kind":12,"name":"throw","containerName":"display_text"},{"line":156,"kind":13,"containerName":"display_text","name":"$cb"},{"line":157,"kind":13,"name":"$cb","containerName":"display_text"},{"containerName":"display_text","name":"$self","line":157,"kind":13}],"kind":12,"range":{"start":{"character":0,"line":153},"end":{"line":158,"character":9999}},"name":"display_text"},{"kind":12,"line":174,"children":[{"definition":"my","name":"$self","containerName":"hash_tree","localvar":"my","kind":13,"line":175},{"kind":13,"line":177,"name":"$h","definition":"my","containerName":"hash_tree","localvar":"my"},{"containerName":"hash_tree","name":"$h","line":178,"kind":13},{"line":178,"kind":13,"name":"$self","containerName":"hash_tree"},{"line":178,"kind":12,"containerName":"hash_tree","name":"value"},{"kind":13,"line":179,"containerName":"hash_tree","name":"$h"}],"containerName":"main::","definition":"sub","name":"hash_tree","range":{"start":{"line":174,"character":0},"end":{"character":9999,"line":180}}},{"containerName":"main::","definition":"sub","name":"tagname","range":{"end":{"character":9999,"line":211},"start":{"character":0,"line":199}},"kind":12,"line":199,"children":[{"kind":13,"line":200,"name":"$self","definition":"my","containerName":"tagname","localvar":"my"},{"kind":13,"line":203,"name":"$self","containerName":"tagname"},{"containerName":"tagname","name":"$self","line":205,"kind":13},{"kind":13,"line":207,"containerName":"tagname","name":"$self"},{"containerName":"tagname","name":"tag_term","line":207,"kind":12},{"name":"name","containerName":"tagname","line":207,"kind":12},{"kind":13,"line":209,"containerName":"tagname","name":"$self"},{"kind":13,"line":210,"containerName":"tagname","name":"$self"}]},{"kind":12,"line":229,"children":[{"kind":13,"line":230,"name":"$self","definition":"my","containerName":"value","localvar":"my"},{"containerName":"value","name":"$value","kind":13,"line":230},{"containerName":"value","name":"$value","line":232,"kind":13},{"name":"$self","containerName":"value","line":233,"kind":13},{"name":"$value","containerName":"value","kind":13,"line":233},{"name":"$self","containerName":"value","line":235,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: SimpleValue.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::SimpleValue\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by bioperl <bioperl-l@bioperl.org>\n#\n# Copyright bioperl\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::SimpleValue - A simple scalar\n\n=head1 SYNOPSIS\n\n   use Bio::Annotation::SimpleValue;\n   use Bio::Annotation::Collection;\n\n   my $col = Bio::Annotation::Collection->new();\n   my $sv = Bio::Annotation::SimpleValue->new(-value => 'someval');\n   $col->add_Annotation('tagname', $sv);\n\n=head1 DESCRIPTION\n\nScalar value annotation object\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR  - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::SimpleValue;\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\n#use Bio::Ontology::TermI;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : my $sv = Bio::Annotation::SimpleValue->new();\n Function: Instantiate a new SimpleValue object\n Returns : Bio::Annotation::SimpleValue object\n Args    : -value    => $value to initialize the object data field [optional]\n           -tagname  => $tag to initialize the tagname [optional]\n           -tag_term => ontology term representation of the tag [optional]\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   my ($value,$tag,$term) =\n       $self->_rearrange([qw(VALUE TAGNAME TAG_TERM)], @args);\n\n   # set the term first\n   defined $term   && $self->tag_term($term);\n   defined $value  && $self->value($value);\n   defined $tag    && $self->tagname($tag);\n\n   return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   : my $text = $obj->as_text\n Function: return the string \"Value: $v\" where $v is the value\n Returns : string\n Args    : none\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Value: \".$self->value;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->value};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   : my $hashtree = $value->hash_tree\n Function: For supporting the AnnotationI interface just returns the value\n           as a hashref with the key 'value' pointing to the value\n Returns : hashrf\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n\n    my $h = {};\n    $h->{'value'} = $self->value;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to AnnotationCollection when adding this\n           object.\n\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    # check for presence of an ontology term\n    if($self->{'_tag_term'}) {\n\t# keep a copy in case the term is removed later\n\t$self->{'tagname'} = $_[0] if @_;\n\t# delegate to the ontology term object\n\treturn $self->tag_term->name(@_);\n    }\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Specific accessors for SimpleValue\n\n\n=head2 value\n\n Title   : value\n Usage   : $obj->value($newval)\n Function: Get/Set the value for simplevalue\n Returns : value of value\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"value($self,$value)"},"name":"value","range":{"end":{"character":9999,"line":236},"start":{"line":229,"character":0}}},{"children":[{"kind":13,"line":266,"containerName":"tag_term","definition":"my","name":"$self","localvar":"my"},{"kind":13,"line":268,"containerName":"tag_term","name":"$self"},{"name":"$self","containerName":"tag_term","kind":13,"line":269}],"line":265,"kind":12,"range":{"start":{"line":265,"character":0},"end":{"character":9999,"line":270}},"definition":"sub","name":"tag_term","containerName":"main::"}]}