{"vars":[{"kind":2,"line":58,"name":"base","containerName":""},{"range":{"start":{"line":76,"character":0},"end":{"character":9999,"line":108}},"name":"new","detail":"($class,@args)","signature":{"label":"new($class,@args)","documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes","parameters":[{"label":"$class"},{"label":"@args"}]},"containerName":"main::","definition":"sub","line":76,"children":[{"containerName":"new","name":"$class","definition":"my","localvar":"my","kind":13,"line":77},{"containerName":"new","name":"@args","line":77,"kind":13},{"containerName":"new","definition":"my","name":"$self","localvar":"my","kind":13,"line":79},{"kind":13,"line":79,"containerName":"new","name":"$class"},{"kind":13,"line":79,"name":"@args","containerName":"new"},{"containerName":"new","name":"$start","definition":"my","localvar":"my","kind":13,"line":81},{"line":81,"kind":13,"name":"$end","containerName":"new"},{"line":81,"kind":13,"containerName":"new","name":"$authors"},{"containerName":"new","name":"$consortium","line":81,"kind":13},{"kind":13,"line":81,"containerName":"new","name":"$location"},{"kind":13,"line":81,"containerName":"new","name":"$title"},{"kind":13,"line":81,"name":"$medline","containerName":"new"},{"line":82,"kind":13,"name":"$pubmed","containerName":"new"},{"line":82,"kind":13,"name":"$rp","containerName":"new"},{"line":82,"kind":13,"containerName":"new","name":"$rg"},{"line":82,"kind":13,"containerName":"new","name":"$doi"},{"containerName":"new","name":"$self","kind":13,"line":83},{"kind":12,"line":83,"containerName":"new","name":"_rearrange"},{"containerName":"new","name":"@args","line":94,"kind":13},{"line":96,"kind":13,"name":"$start","containerName":"new"},{"kind":13,"line":96,"name":"$self","containerName":"new"},{"kind":12,"line":96,"name":"start","containerName":"new"},{"kind":13,"line":96,"containerName":"new","name":"$start"},{"line":97,"kind":13,"name":"$end","containerName":"new"},{"name":"$self","containerName":"new","line":97,"kind":13},{"name":"end","containerName":"new","line":97,"kind":12},{"name":"$end","containerName":"new","kind":13,"line":97},{"containerName":"new","name":"$authors","kind":13,"line":98},{"kind":13,"line":98,"name":"$self","containerName":"new"},{"kind":12,"line":98,"name":"authors","containerName":"new"},{"line":98,"kind":13,"name":"$authors","containerName":"new"},{"kind":13,"line":99,"name":"$consortium","containerName":"new"},{"containerName":"new","name":"$self","line":99,"kind":13},{"kind":12,"line":99,"containerName":"new","name":"consortium"},{"containerName":"new","name":"$consortium","kind":13,"line":99},{"kind":13,"line":100,"containerName":"new","name":"$location"},{"name":"$self","containerName":"new","kind":13,"line":100},{"containerName":"new","name":"location","kind":12,"line":100},{"line":100,"kind":13,"containerName":"new","name":"$location"},{"line":101,"kind":13,"containerName":"new","name":"$title"},{"containerName":"new","name":"$self","line":101,"kind":13},{"containerName":"new","name":"title","kind":12,"line":101},{"kind":13,"line":101,"containerName":"new","name":"$title"},{"name":"$medline","containerName":"new","kind":13,"line":102},{"line":102,"kind":13,"name":"$self","containerName":"new"},{"containerName":"new","name":"medline","kind":12,"line":102},{"containerName":"new","name":"$medline","line":102,"kind":13},{"line":103,"kind":13,"name":"$pubmed","containerName":"new"},{"name":"$self","containerName":"new","line":103,"kind":13},{"name":"pubmed","containerName":"new","line":103,"kind":12},{"containerName":"new","name":"$pubmed","kind":13,"line":103},{"line":104,"kind":13,"name":"$rp","containerName":"new"},{"name":"$self","containerName":"new","kind":13,"line":104},{"containerName":"new","name":"rp","line":104,"kind":12},{"name":"$rp","containerName":"new","kind":13,"line":104},{"name":"$rg","containerName":"new","line":105,"kind":13},{"containerName":"new","name":"$self","line":105,"kind":13},{"name":"rg","containerName":"new","kind":12,"line":105},{"kind":13,"line":105,"name":"$rg","containerName":"new"},{"containerName":"new","name":"$doi","kind":13,"line":106},{"name":"$self","containerName":"new","line":106,"kind":13},{"line":106,"kind":12,"name":"doi","containerName":"new"},{"line":106,"kind":13,"name":"$doi","containerName":"new"},{"containerName":"new","name":"$self","line":107,"kind":13}],"kind":12},{"kind":12,"line":79,"name":"SUPER","containerName":"new"},{"definition":"sub","containerName":"main::","signature":{"label":"as_text($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :"},"detail":"($self)","kind":12,"children":[{"line":128,"kind":13,"localvar":"my","containerName":"as_text","definition":"my","name":"$self"},{"line":131,"kind":13,"containerName":"as_text","name":"$self"},{"containerName":"as_text","name":"title","kind":12,"line":131}],"line":127,"name":"as_text","range":{"start":{"character":0,"line":127},"end":{"character":9999,"line":132}}},{"kind":13,"line":151,"definition":"my","name":"%DEFAULT_CB","containerName":null,"localvar":"my"},{"kind":12,"line":151,"containerName":"main::","name":"title"},{"children":[{"kind":13,"line":154,"name":"$self","definition":"my","containerName":"display_text","localvar":"my"},{"containerName":"display_text","name":"$cb","kind":13,"line":154},{"kind":13,"line":155,"name":"$cb","containerName":"display_text"},{"containerName":"display_text","name":"$DEFAULT_CB","kind":13,"line":155},{"line":156,"kind":13,"containerName":"display_text","name":"$self"},{"containerName":"display_text","name":"throw","line":156,"kind":12},{"containerName":"display_text","name":"$cb","kind":13,"line":156},{"containerName":"display_text","name":"$cb","line":157,"kind":13},{"line":157,"kind":13,"name":"$self","containerName":"display_text"}],"line":153,"kind":12,"signature":{"documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}],"label":"display_text($self,$cb)"},"detail":"($self,$cb)","definition":"sub","containerName":"main::","range":{"end":{"line":158,"character":9999},"start":{"line":153,"character":0}},"name":"display_text"},{"range":{"end":{"line":193,"character":9999},"start":{"line":174,"character":0}},"name":"hash_tree","signature":{"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"}],"label":"hash_tree($self)"},"detail":"($self)","definition":"sub","containerName":"main::","children":[{"name":"$self","definition":"my","containerName":"hash_tree","localvar":"my","kind":13,"line":175},{"localvar":"my","definition":"my","name":"$h","containerName":"hash_tree","line":177,"kind":13},{"containerName":"hash_tree","name":"$h","kind":13,"line":178},{"kind":13,"line":178,"name":"$self","containerName":"hash_tree"},{"kind":12,"line":178,"containerName":"hash_tree","name":"title"},{"line":179,"kind":13,"name":"$h","containerName":"hash_tree"},{"name":"$self","containerName":"hash_tree","line":179,"kind":13},{"name":"authors","containerName":"hash_tree","line":179,"kind":12},{"containerName":"hash_tree","name":"$h","line":180,"kind":13},{"kind":13,"line":180,"name":"$self","containerName":"hash_tree"},{"kind":12,"line":180,"name":"location","containerName":"hash_tree"},{"name":"$self","containerName":"hash_tree","kind":13,"line":181},{"kind":12,"line":181,"containerName":"hash_tree","name":"start"},{"kind":13,"line":182,"containerName":"hash_tree","name":"$h"},{"containerName":"hash_tree","name":"$self","line":182,"kind":13},{"containerName":"hash_tree","name":"start","line":182,"kind":12},{"name":"$self","containerName":"hash_tree","kind":13,"line":184},{"name":"end","containerName":"hash_tree","kind":12,"line":184},{"name":"$h","containerName":"hash_tree","line":185,"kind":13},{"kind":13,"line":185,"containerName":"hash_tree","name":"$self"},{"line":185,"kind":12,"containerName":"hash_tree","name":"end"},{"name":"$h","containerName":"hash_tree","line":187,"kind":13},{"name":"$self","containerName":"hash_tree","kind":13,"line":187},{"line":187,"kind":12,"containerName":"hash_tree","name":"medline"},{"line":188,"kind":13,"name":"$self","containerName":"hash_tree"},{"name":"pubmed","containerName":"hash_tree","line":188,"kind":12},{"name":"$h","containerName":"hash_tree","line":189,"kind":13},{"kind":13,"line":189,"name":"$self","containerName":"hash_tree"},{"containerName":"hash_tree","name":"pubmed","kind":12,"line":189},{"name":"$h","containerName":"hash_tree","kind":13,"line":192}],"line":174,"kind":12},{"range":{"start":{"line":231,"character":0},"end":{"character":9999,"line":238}},"name":"start","children":[{"localvar":"my","name":"$self","definition":"my","containerName":"start","line":232,"kind":13},{"line":232,"kind":13,"name":"$value","containerName":"start"},{"name":"$value","containerName":"start","line":233,"kind":13},{"kind":13,"line":234,"name":"$self","containerName":"start"},{"line":234,"kind":13,"containerName":"start","name":"$value"},{"name":"$self","containerName":"start","kind":13,"line":236}],"line":231,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)","label":"start($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"end","range":{"start":{"line":252,"character":0},"end":{"line":258,"character":9999}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"end($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"line":253,"kind":13,"localvar":"my","containerName":"end","definition":"my","name":"$self"},{"kind":13,"line":253,"containerName":"end","name":"$value"},{"name":"$value","containerName":"end","kind":13,"line":254},{"line":255,"kind":13,"name":"$self","containerName":"end"},{"line":255,"kind":13,"name":"$value","containerName":"end"},{"containerName":"end","name":"$self","kind":13,"line":257}],"line":252},{"range":{"end":{"line":278,"character":9999},"start":{"line":272,"character":0}},"name":"rp","children":[{"definition":"my","name":"$self","containerName":"rp","localvar":"my","kind":13,"line":273},{"name":"$value","containerName":"rp","line":273,"kind":13},{"line":274,"kind":13,"name":"$value","containerName":"rp"},{"line":275,"kind":13,"containerName":"rp","name":"$self"},{"kind":13,"line":275,"containerName":"rp","name":"$value"},{"line":277,"kind":13,"name":"$self","containerName":"rp"}],"line":272,"kind":12,"signature":{"label":"rp($self,$value)","documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"range":{"start":{"character":0,"line":296},"end":{"character":9999,"line":301}},"containerName":"main::","definition":"sub","name":"rg","line":296,"children":[{"line":297,"kind":13,"localvar":"my","containerName":"rg","definition":"my","name":"$self"},{"name":"$self","containerName":"rg","kind":13,"line":299},{"containerName":"rg","name":"$self","line":300,"kind":13}],"kind":12},{"range":{"start":{"line":315,"character":0},"end":{"character":9999,"line":322}},"name":"authors","children":[{"localvar":"my","containerName":"authors","definition":"my","name":"$self","line":316,"kind":13},{"line":316,"kind":13,"containerName":"authors","name":"$value"},{"name":"$value","containerName":"authors","line":317,"kind":13},{"kind":13,"line":318,"name":"$self","containerName":"authors"},{"containerName":"authors","name":"$value","kind":13,"line":318},{"line":320,"kind":13,"name":"$self","containerName":"authors"}],"line":315,"kind":12,"signature":{"label":"authors($self,$value)","documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"name":"location","range":{"start":{"character":0,"line":336},"end":{"character":9999,"line":343}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"location($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"name":"$self","definition":"my","containerName":"location","localvar":"my","kind":13,"line":337},{"line":337,"kind":13,"containerName":"location","name":"$value"},{"kind":13,"line":338,"name":"$value","containerName":"location"},{"line":339,"kind":13,"name":"$self","containerName":"location"},{"name":"$value","containerName":"location","line":339,"kind":13},{"name":"$self","containerName":"location","kind":13,"line":341}],"line":336},{"range":{"end":{"character":9999,"line":364},"start":{"line":357,"character":0}},"name":"title","children":[{"kind":13,"line":358,"containerName":"title","name":"$self","definition":"my","localvar":"my"},{"line":358,"kind":13,"containerName":"title","name":"$value"},{"line":359,"kind":13,"containerName":"title","name":"$value"},{"name":"$self","containerName":"title","kind":13,"line":360},{"name":"$value","containerName":"title","line":360,"kind":13},{"name":"$self","containerName":"title","kind":13,"line":362}],"line":357,"kind":12,"signature":{"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"title($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"kind":12,"line":378,"children":[{"localvar":"my","containerName":"medline","definition":"my","name":"$self","line":379,"kind":13},{"containerName":"medline","name":"$value","line":379,"kind":13},{"name":"$value","containerName":"medline","kind":13,"line":380},{"line":381,"kind":13,"containerName":"medline","name":"$self"},{"line":381,"kind":13,"name":"$value","containerName":"medline"},{"name":"$self","containerName":"medline","line":383,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"medline($self,$value)","documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"name":"medline","range":{"start":{"character":0,"line":378},"end":{"line":384,"character":9999}}},{"children":[{"line":400,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"pubmed"},{"line":400,"kind":13,"name":"$value","containerName":"pubmed"},{"containerName":"pubmed","name":"$value","kind":13,"line":401},{"containerName":"pubmed","name":"$self","kind":13,"line":402},{"containerName":"pubmed","name":"$value","line":402,"kind":13},{"kind":13,"line":404,"containerName":"pubmed","name":"$self"}],"line":399,"kind":12,"signature":{"label":"pubmed($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":399},"end":{"line":405,"character":9999}},"name":"pubmed"},{"name":"database","range":{"end":{"line":428,"character":9999},"start":{"line":421,"character":0}},"kind":12,"line":421,"children":[{"kind":13,"line":422,"definition":"my","name":"$self","containerName":"database","localvar":"my"},{"kind":13,"line":422,"containerName":"database","name":"@args"},{"localvar":"my","definition":"my","name":"$default","containerName":"database","line":423,"kind":13},{"line":424,"kind":13,"containerName":"database","name":"$self"},{"kind":12,"line":424,"containerName":"database","name":"medline"},{"containerName":"database","name":"$self","kind":13,"line":424},{"line":424,"kind":12,"name":"pubmed","containerName":"database"},{"name":"$default","containerName":"database","kind":13,"line":425},{"line":427,"kind":13,"containerName":"database","name":"$self"},{"line":427,"kind":13,"containerName":"database","name":"@args"},{"name":"$default","containerName":"database","kind":13,"line":427}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"label":"database($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :"}},{"name":"SUPER","containerName":"database","kind":12,"line":427},{"name":"primary_id","range":{"start":{"line":443,"character":0},"end":{"line":452,"character":9999}},"kind":12,"line":443,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"primary_id","line":444,"kind":13},{"kind":13,"line":444,"name":"@args","containerName":"primary_id"},{"containerName":"primary_id","name":"@args","line":445,"kind":13},{"containerName":"primary_id","name":"$self","line":446,"kind":13},{"line":446,"kind":12,"containerName":"primary_id","name":"medline"},{"kind":13,"line":446,"containerName":"primary_id","name":"@args"},{"line":448,"kind":13,"containerName":"primary_id","name":"$self"},{"containerName":"primary_id","name":"medline","kind":12,"line":448},{"line":448,"kind":13,"name":"$self","containerName":"primary_id"},{"name":"pubmed","containerName":"primary_id","line":448,"kind":12},{"name":"$self","containerName":"primary_id","line":449,"kind":13},{"kind":12,"line":449,"containerName":"primary_id","name":"pubmed"},{"containerName":"primary_id","name":"$self","kind":13,"line":451},{"kind":12,"line":451,"containerName":"primary_id","name":"medline"}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :\n\n\n\nsub database{\n    my ($self, @args) = @_;\n    my $default = 'MEDLINE';\n    if (! defined $self->medline && defined $self->pubmed) {\n        $default = 'PUBMED';\n    }\n    return $self->SUPER::database(@args) || $default;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   :\n Function: Overrides DBLink primary_id to provide medline number, or pubmed\n           number if only that has been defined\n Example :\n Returns :\n Args    :","parameters":[{"label":"$self"},{"label":"@args"}],"label":"primary_id($self,@args)"}},{"line":466,"children":[{"containerName":"optional_id","definition":"my","name":"$self","localvar":"my","kind":13,"line":467},{"line":467,"kind":13,"containerName":"optional_id","name":"@args"},{"containerName":"optional_id","name":"$self","line":469,"kind":13},{"line":469,"kind":12,"name":"pubmed","containerName":"optional_id"},{"kind":13,"line":469,"name":"@args","containerName":"optional_id"}],"kind":12,"detail":"($self,@args)","signature":{"parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :\n\n\n\nsub database{\n    my ($self, @args) = @_;\n    my $default = 'MEDLINE';\n    if (! defined $self->medline && defined $self->pubmed) {\n        $default = 'PUBMED';\n    }\n    return $self->SUPER::database(@args) || $default;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   :\n Function: Overrides DBLink primary_id to provide medline number, or pubmed\n           number if only that has been defined\n Example :\n Returns :\n Args    :\n\n\n\nsub primary_id{\n    my ($self, @args) = @_;\n    if (@args) {\n        $self->medline(@args);\n    }\n    if (! defined $self->medline && defined $self->pubmed) {\n        return $self->pubmed;\n    }\n    return $self->medline;\n}\n\n=head2 optional_id\n\n Title   : optional_id\n Usage   :\n Function: Overrides DBLink optional_id to provide the PubMed number.\n Example :\n Returns :\n Args    :","label":"optional_id($self,@args)"},"containerName":"main::","definition":"sub","range":{"end":{"line":470,"character":9999},"start":{"line":466,"character":0}},"name":"optional_id"},{"range":{"start":{"line":484,"character":0},"end":{"character":9999,"line":490}},"name":"publisher","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :\n\n\n\nsub database{\n    my ($self, @args) = @_;\n    my $default = 'MEDLINE';\n    if (! defined $self->medline && defined $self->pubmed) {\n        $default = 'PUBMED';\n    }\n    return $self->SUPER::database(@args) || $default;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   :\n Function: Overrides DBLink primary_id to provide medline number, or pubmed\n           number if only that has been defined\n Example :\n Returns :\n Args    :\n\n\n\nsub primary_id{\n    my ($self, @args) = @_;\n    if (@args) {\n        $self->medline(@args);\n    }\n    if (! defined $self->medline && defined $self->pubmed) {\n        return $self->pubmed;\n    }\n    return $self->medline;\n}\n\n=head2 optional_id\n\n Title   : optional_id\n Usage   :\n Function: Overrides DBLink optional_id to provide the PubMed number.\n Example :\n Returns :\n Args    :\n\n\n\nsub optional_id{\n   my ($self, @args) = @_;\n\n   return $self->pubmed(@args);\n}\n\n=head2 publisher\n\n Title   : publisher\n Usage   : $self->publisher($newval)\n Function: Gives the publisher line. No attempt is made to parse the publisher line\n Example :\n Returns : value of publisher\n Args    : newvalue (optional)","label":"publisher($self,$value)"},"containerName":"main::","definition":"sub","line":484,"children":[{"localvar":"my","containerName":"publisher","name":"$self","definition":"my","line":485,"kind":13},{"kind":13,"line":485,"containerName":"publisher","name":"$value"},{"kind":13,"line":486,"containerName":"publisher","name":"$value"},{"kind":13,"line":487,"containerName":"publisher","name":"$self"},{"kind":13,"line":487,"name":"$value","containerName":"publisher"},{"kind":13,"line":489,"containerName":"publisher","name":"$self"}],"kind":12},{"range":{"end":{"character":9999,"line":511},"start":{"character":0,"line":505}},"name":"editors","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :\n\n\n\nsub database{\n    my ($self, @args) = @_;\n    my $default = 'MEDLINE';\n    if (! defined $self->medline && defined $self->pubmed) {\n        $default = 'PUBMED';\n    }\n    return $self->SUPER::database(@args) || $default;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   :\n Function: Overrides DBLink primary_id to provide medline number, or pubmed\n           number if only that has been defined\n Example :\n Returns :\n Args    :\n\n\n\nsub primary_id{\n    my ($self, @args) = @_;\n    if (@args) {\n        $self->medline(@args);\n    }\n    if (! defined $self->medline && defined $self->pubmed) {\n        return $self->pubmed;\n    }\n    return $self->medline;\n}\n\n=head2 optional_id\n\n Title   : optional_id\n Usage   :\n Function: Overrides DBLink optional_id to provide the PubMed number.\n Example :\n Returns :\n Args    :\n\n\n\nsub optional_id{\n   my ($self, @args) = @_;\n\n   return $self->pubmed(@args);\n}\n\n=head2 publisher\n\n Title   : publisher\n Usage   : $self->publisher($newval)\n Function: Gives the publisher line. No attempt is made to parse the publisher line\n Example :\n Returns : value of publisher\n Args    : newvalue (optional)\n\n\n\nsub publisher {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'publisher'} = $value;\n   }\n   return $self->{'publisher'};\n}\n\n\n=head2 editors\n\n Title   : editors\n Usage   : $self->editors($newval)\n Function: Gives the editors line. No attempt is made to parse the editors line\n Example :\n Returns : value of editors\n Args    : newvalue (optional)","label":"editors($self,$value)"},"containerName":"main::","definition":"sub","line":505,"children":[{"containerName":"editors","name":"$self","definition":"my","localvar":"my","kind":13,"line":506},{"kind":13,"line":506,"containerName":"editors","name":"$value"},{"line":507,"kind":13,"name":"$value","containerName":"editors"},{"containerName":"editors","name":"$self","line":508,"kind":13},{"kind":13,"line":508,"name":"$value","containerName":"editors"},{"line":510,"kind":13,"containerName":"editors","name":"$self"}],"kind":12},{"name":"encoded_ref","range":{"start":{"character":0,"line":528},"end":{"line":534,"character":9999}},"kind":12,"line":528,"children":[{"line":529,"kind":13,"localvar":"my","containerName":"encoded_ref","definition":"my","name":"$self"},{"name":"$value","containerName":"encoded_ref","line":529,"kind":13},{"name":"$value","containerName":"encoded_ref","kind":13,"line":530},{"kind":13,"line":531,"containerName":"encoded_ref","name":"$self"},{"containerName":"encoded_ref","name":"$value","line":531,"kind":13},{"line":533,"kind":13,"name":"$self","containerName":"encoded_ref"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :\n\n\n\nsub database{\n    my ($self, @args) = @_;\n    my $default = 'MEDLINE';\n    if (! defined $self->medline && defined $self->pubmed) {\n        $default = 'PUBMED';\n    }\n    return $self->SUPER::database(@args) || $default;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   :\n Function: Overrides DBLink primary_id to provide medline number, or pubmed\n           number if only that has been defined\n Example :\n Returns :\n Args    :\n\n\n\nsub primary_id{\n    my ($self, @args) = @_;\n    if (@args) {\n        $self->medline(@args);\n    }\n    if (! defined $self->medline && defined $self->pubmed) {\n        return $self->pubmed;\n    }\n    return $self->medline;\n}\n\n=head2 optional_id\n\n Title   : optional_id\n Usage   :\n Function: Overrides DBLink optional_id to provide the PubMed number.\n Example :\n Returns :\n Args    :\n\n\n\nsub optional_id{\n   my ($self, @args) = @_;\n\n   return $self->pubmed(@args);\n}\n\n=head2 publisher\n\n Title   : publisher\n Usage   : $self->publisher($newval)\n Function: Gives the publisher line. No attempt is made to parse the publisher line\n Example :\n Returns : value of publisher\n Args    : newvalue (optional)\n\n\n\nsub publisher {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'publisher'} = $value;\n   }\n   return $self->{'publisher'};\n}\n\n\n=head2 editors\n\n Title   : editors\n Usage   : $self->editors($newval)\n Function: Gives the editors line. No attempt is made to parse the editors line\n Example :\n Returns : value of editors\n Args    : newvalue (optional)\n\n\n\nsub editors {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'editors'} = $value;\n   }\n   return $self->{'editors'};\n}\n\n\n=head2 encoded_ref\n\n Title   : encoded_ref\n Usage   : $self->encoded_ref($newval)\n Function: Gives the encoded_ref line. No attempt is made to parse the encoded_ref line\n    (this is added for reading PDB records (REFN record), where this contains\n     ISBN/ISSN/ASTM code)\n Example :\n Returns : value of encoded_ref\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"encoded_ref($self,$value)"}},{"kind":12,"line":552,"children":[{"line":553,"kind":13,"localvar":"my","containerName":"doi","definition":"my","name":"$self"},{"name":"$value","containerName":"doi","kind":13,"line":553},{"kind":13,"line":554,"name":"$value","containerName":"doi"},{"line":555,"kind":13,"name":"$self","containerName":"doi"},{"kind":13,"line":555,"name":"$value","containerName":"doi"},{"containerName":"doi","name":"$self","kind":13,"line":557}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :\n\n\n\nsub database{\n    my ($self, @args) = @_;\n    my $default = 'MEDLINE';\n    if (! defined $self->medline && defined $self->pubmed) {\n        $default = 'PUBMED';\n    }\n    return $self->SUPER::database(@args) || $default;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   :\n Function: Overrides DBLink primary_id to provide medline number, or pubmed\n           number if only that has been defined\n Example :\n Returns :\n Args    :\n\n\n\nsub primary_id{\n    my ($self, @args) = @_;\n    if (@args) {\n        $self->medline(@args);\n    }\n    if (! defined $self->medline && defined $self->pubmed) {\n        return $self->pubmed;\n    }\n    return $self->medline;\n}\n\n=head2 optional_id\n\n Title   : optional_id\n Usage   :\n Function: Overrides DBLink optional_id to provide the PubMed number.\n Example :\n Returns :\n Args    :\n\n\n\nsub optional_id{\n   my ($self, @args) = @_;\n\n   return $self->pubmed(@args);\n}\n\n=head2 publisher\n\n Title   : publisher\n Usage   : $self->publisher($newval)\n Function: Gives the publisher line. No attempt is made to parse the publisher line\n Example :\n Returns : value of publisher\n Args    : newvalue (optional)\n\n\n\nsub publisher {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'publisher'} = $value;\n   }\n   return $self->{'publisher'};\n}\n\n\n=head2 editors\n\n Title   : editors\n Usage   : $self->editors($newval)\n Function: Gives the editors line. No attempt is made to parse the editors line\n Example :\n Returns : value of editors\n Args    : newvalue (optional)\n\n\n\nsub editors {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'editors'} = $value;\n   }\n   return $self->{'editors'};\n}\n\n\n=head2 encoded_ref\n\n Title   : encoded_ref\n Usage   : $self->encoded_ref($newval)\n Function: Gives the encoded_ref line. No attempt is made to parse the encoded_ref line\n    (this is added for reading PDB records (REFN record), where this contains\n     ISBN/ISSN/ASTM code)\n Example :\n Returns : value of encoded_ref\n Args    : newvalue (optional)\n\n\n\nsub encoded_ref {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'encoded_ref'} = $value;\n   }\n   return $self->{'encoded_ref'};\n}\n\n=head2 doi\n\n Title   : doi\n Usage   : $self->doi($newval)\n Function: Gives the DOI (Digital Object Identifier) from the International\n           DOI Foundation (http://www.doi.org/), which can be used to resolve\n\t\t   URL links for the full-text documents using:\n\n\t\t   http://dx.doi.org/<doi>\n\n Example :\n Returns : value of doi\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"doi($self,$value)"},"name":"doi","range":{"end":{"character":9999,"line":558},"start":{"character":0,"line":552}}},{"range":{"end":{"line":578,"character":9999},"start":{"character":0,"line":572}},"name":"consortium","children":[{"containerName":"consortium","definition":"my","name":"$self","localvar":"my","kind":13,"line":573},{"containerName":"consortium","name":"$value","line":573,"kind":13},{"containerName":"consortium","name":"$value","line":574,"kind":13},{"containerName":"consortium","name":"$self","line":575,"kind":13},{"line":575,"kind":13,"containerName":"consortium","name":"$value"},{"kind":13,"line":577,"name":"$self","containerName":"consortium"}],"line":572,"kind":12,"signature":{"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :\n\n\n\nsub database{\n    my ($self, @args) = @_;\n    my $default = 'MEDLINE';\n    if (! defined $self->medline && defined $self->pubmed) {\n        $default = 'PUBMED';\n    }\n    return $self->SUPER::database(@args) || $default;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   :\n Function: Overrides DBLink primary_id to provide medline number, or pubmed\n           number if only that has been defined\n Example :\n Returns :\n Args    :\n\n\n\nsub primary_id{\n    my ($self, @args) = @_;\n    if (@args) {\n        $self->medline(@args);\n    }\n    if (! defined $self->medline && defined $self->pubmed) {\n        return $self->pubmed;\n    }\n    return $self->medline;\n}\n\n=head2 optional_id\n\n Title   : optional_id\n Usage   :\n Function: Overrides DBLink optional_id to provide the PubMed number.\n Example :\n Returns :\n Args    :\n\n\n\nsub optional_id{\n   my ($self, @args) = @_;\n\n   return $self->pubmed(@args);\n}\n\n=head2 publisher\n\n Title   : publisher\n Usage   : $self->publisher($newval)\n Function: Gives the publisher line. No attempt is made to parse the publisher line\n Example :\n Returns : value of publisher\n Args    : newvalue (optional)\n\n\n\nsub publisher {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'publisher'} = $value;\n   }\n   return $self->{'publisher'};\n}\n\n\n=head2 editors\n\n Title   : editors\n Usage   : $self->editors($newval)\n Function: Gives the editors line. No attempt is made to parse the editors line\n Example :\n Returns : value of editors\n Args    : newvalue (optional)\n\n\n\nsub editors {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'editors'} = $value;\n   }\n   return $self->{'editors'};\n}\n\n\n=head2 encoded_ref\n\n Title   : encoded_ref\n Usage   : $self->encoded_ref($newval)\n Function: Gives the encoded_ref line. No attempt is made to parse the encoded_ref line\n    (this is added for reading PDB records (REFN record), where this contains\n     ISBN/ISSN/ASTM code)\n Example :\n Returns : value of encoded_ref\n Args    : newvalue (optional)\n\n\n\nsub encoded_ref {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'encoded_ref'} = $value;\n   }\n   return $self->{'encoded_ref'};\n}\n\n=head2 doi\n\n Title   : doi\n Usage   : $self->doi($newval)\n Function: Gives the DOI (Digital Object Identifier) from the International\n           DOI Foundation (http://www.doi.org/), which can be used to resolve\n\t\t   URL links for the full-text documents using:\n\n\t\t   http://dx.doi.org/<doi>\n\n Example :\n Returns : value of doi\n Args    : newvalue (optional)\n\n\nsub doi {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'doi'} = $value;\n    }\n    return $self->{'doi'};\n}\n\n=head2 consortium\n\n Title   : consortium\n Usage   : $self->consortium($newval)\n Function: Gives the consortium line. No attempt is made to parse the consortium line\n Example :\n Returns : value of consortium\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"consortium($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"children":[{"localvar":"my","containerName":"gb_reference","name":"$self","definition":"my","line":598,"kind":13},{"kind":13,"line":598,"name":"$value","containerName":"gb_reference"},{"line":599,"kind":13,"containerName":"gb_reference","name":"$value"},{"containerName":"gb_reference","name":"$self","line":600,"kind":13},{"line":600,"kind":13,"containerName":"gb_reference","name":"$value"},{"name":"$self","containerName":"gb_reference","line":602,"kind":13}],"line":597,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Reference.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Reference\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Reference - Specialised DBLink object for Literature References\n\n=head1 SYNOPSIS\n\n    $reg = Bio::Annotation::Reference->new( -title    => 'title line',\n                                            -location => 'location line',\n                                            -authors  => 'author line',\n                                            -medline  => 998122 );\n\n=head1 DESCRIPTION\n\nObject which presents a literature reference. This is considered to be\na specialised form of database link. The additional methods provided\nare all set/get methods to store strings commonly associated with\nreferences, in particular title, location (ie, journal page) and\nauthors line.\n\nThere is no attempt to do anything more than store these things as\nstrings for processing elsewhere. This is mainly because parsing these\nthings suck and generally are specific to the specific format one is\nusing. To provide an easy route to go format --E<gt> object --E<gt> format\nwithout losing data, we keep them as strings. Feel free to post the\nlist for a better solution, but in general this gets very messy very\nfast...\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Reference;\nuse strict;\n\nuse base qw(Bio::Annotation::DBLink);\n\n=head2 new\n\n Title   : new\n Usage   : $ref = Bio::Annotation::Reference->new( -title => 'title line',\n                           -authors => 'author line',\n                           -location => 'location line',\n                           -medline => 9988812);\n Function:\n Example :\n Returns : a new Bio::Annotation::Reference object\n Args    : a hash with optional title, authors, location, medline, pubmed,\n           start, end, consortium, rp and rg attributes\n\n\n\nsub new{\n    my ($class,@args) = @_;\n\n    my $self = $class->SUPER::new(@args);\n\n    my ($start,$end,$authors,$consortium,$location,$title,$medline,\n    $pubmed,$rp,$rg,$doi) =\n    $self->_rearrange([qw(START\n                  END\n                  AUTHORS\n                  CONSORTIUM\n                  LOCATION\n                  TITLE\n                  MEDLINE\n                  PUBMED\n                  RP\n                  RG\n\t\t\t\t  DOI\n                  )],@args);\n\n    defined $start    && $self->start($start);\n    defined $end      && $self->end($end);\n    defined $authors  && $self->authors($authors);\n    defined $consortium  && $self->consortium($consortium);\n    defined $location && $self->location($location);\n    defined $title    && $self->title($title);\n    defined $medline  && $self->medline($medline);\n    defined $pubmed   && $self->pubmed($pubmed);\n    defined $rp       && $self->rp($rp);\n    defined $rg       && $self->rg($rg);\n\tdefined $doi      && $self->doi($doi);\n    return $self;\n}\n\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   # this could get out of hand!\n   return \"Reference: \".$self->title;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub { $_[0]->title || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns :\n Args    :\n\n\n\nsub hash_tree{\n    my ($self) = @_;\n\n    my $h = {};\n    $h->{'title'}   = $self->title;\n    $h->{'authors'} = $self->authors;\n    $h->{'location'} = $self->location;\n    if (defined $self->start) {\n        $h->{'start'}   = $self->start;\n    }\n    if (defined $self->end) {\n        $h->{'end'} = $self->end;\n    }\n    $h->{'medline'} = $self->medline;\n    if (defined $self->pubmed) {\n        $h->{'pubmed'} = $self->pubmed;\n    }\n\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to provide\n           a tag to Bio::AnnotationCollectionI when adding this object. When\n           obtaining an AnnotationI object from the collection, the collection\n           will set the value to the tag under which it was stored unless the\n           object has a tag stored already.\n Example :\n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\n\n=head1 Specific accessors for References\n\n\n\n=head2 start\n\n Title   : start\n Usage   : $self->start($newval)\n Function: Gives the reference start base\n Example :\n Returns : value of start\n Args    : newvalue (optional)\n\n\n\nsub start {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'start'} = $value;\n    }\n    return $self->{'start'};\n\n}\n\n=head2 end\n\n Title   : end\n Usage   : $self->end($newval)\n Function: Gives the reference end base\n Example :\n Returns : value of end\n Args    : newvalue (optional)\n\n\n\nsub end {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'end'} = $value;\n    }\n    return $self->{'end'};\n}\n\n=head2 rp\n\n Title   : rp\n Usage   : $self->rp($newval)\n Function: Gives the RP line. No attempt is made to parse this line.\n Example :\n Returns : value of rp\n Args    : newvalue (optional)\n\n\n\nsub rp{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'rp'} = $value;\n    }\n    return $self->{'rp'};\n}\n\n=head2 rg\n\n Title   : rg\n Usage   : $obj->rg($newval)\n Function: Gives the RG line. This is Swissprot/Uniprot specific, and\n           if set will usually be identical to the authors attribute,\n           but the swissprot manual does allow both RG and RA (author)\n           to be present for the same reference.\n\n Example :\n Returns : value of rg (a scalar)\n Args    : on set, new value (a scalar or undef, optional)\n\n\n\nsub rg{\n    my $self = shift;\n\n    return $self->{'rg'} = shift if @_;\n    return $self->{'rg'};\n}\n\n=head2 authors\n\n Title   : authors\n Usage   : $self->authors($newval)\n Function: Gives the author line. No attempt is made to parse the author line\n Example :\n Returns : value of authors\n Args    : newvalue (optional)\n\n\n\nsub authors{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'authors'} = $value;\n    }\n    return $self->{'authors'};\n\n}\n\n=head2 location\n\n Title   : location\n Usage   : $self->location($newval)\n Function: Gives the location line. No attempt is made to parse the location line\n Example :\n Returns : value of location\n Args    : newvalue (optional)\n\n\n\nsub location{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'location'} = $value;\n    }\n    return $self->{'location'};\n\n}\n\n=head2 title\n\n Title   : title\n Usage   : $self->title($newval)\n Function: Gives the title line (if exists)\n Example :\n Returns : value of title\n Args    : newvalue (optional)\n\n\n\nsub title{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'title'} = $value;\n    }\n    return $self->{'title'};\n\n}\n\n=head2 medline\n\n Title   : medline\n Usage   : $self->medline($newval)\n Function: Gives the medline number\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub medline{\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'medline'} = $value;\n    }\n    return $self->{'medline'};\n}\n\n=head2 pubmed\n\n Title   : pubmed\n Usage   : $refobj->pubmed($newval)\n Function: Get/Set the PubMed number, if it is different from the MedLine\n           number.\n Example :\n Returns : value of medline\n Args    : newvalue (optional)\n\n\n\nsub pubmed {\n    my ($self,$value) = @_;\n    if( defined $value) {\n    $self->{'pubmed'} = $value;\n    }\n    return $self->{'pubmed'};\n}\n\n=head2 database\n\n Title   : database\n Usage   :\n Function: Overrides DBLink database to be hard coded to 'MEDLINE' (or 'PUBMED'\n           if only pubmed id has been supplied), unless the database has been\n           set explicitely before.\n Example :\n Returns :\n Args    :\n\n\n\nsub database{\n    my ($self, @args) = @_;\n    my $default = 'MEDLINE';\n    if (! defined $self->medline && defined $self->pubmed) {\n        $default = 'PUBMED';\n    }\n    return $self->SUPER::database(@args) || $default;\n}\n\n=head2 primary_id\n\n Title   : primary_id\n Usage   :\n Function: Overrides DBLink primary_id to provide medline number, or pubmed\n           number if only that has been defined\n Example :\n Returns :\n Args    :\n\n\n\nsub primary_id{\n    my ($self, @args) = @_;\n    if (@args) {\n        $self->medline(@args);\n    }\n    if (! defined $self->medline && defined $self->pubmed) {\n        return $self->pubmed;\n    }\n    return $self->medline;\n}\n\n=head2 optional_id\n\n Title   : optional_id\n Usage   :\n Function: Overrides DBLink optional_id to provide the PubMed number.\n Example :\n Returns :\n Args    :\n\n\n\nsub optional_id{\n   my ($self, @args) = @_;\n\n   return $self->pubmed(@args);\n}\n\n=head2 publisher\n\n Title   : publisher\n Usage   : $self->publisher($newval)\n Function: Gives the publisher line. No attempt is made to parse the publisher line\n Example :\n Returns : value of publisher\n Args    : newvalue (optional)\n\n\n\nsub publisher {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'publisher'} = $value;\n   }\n   return $self->{'publisher'};\n}\n\n\n=head2 editors\n\n Title   : editors\n Usage   : $self->editors($newval)\n Function: Gives the editors line. No attempt is made to parse the editors line\n Example :\n Returns : value of editors\n Args    : newvalue (optional)\n\n\n\nsub editors {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'editors'} = $value;\n   }\n   return $self->{'editors'};\n}\n\n\n=head2 encoded_ref\n\n Title   : encoded_ref\n Usage   : $self->encoded_ref($newval)\n Function: Gives the encoded_ref line. No attempt is made to parse the encoded_ref line\n    (this is added for reading PDB records (REFN record), where this contains\n     ISBN/ISSN/ASTM code)\n Example :\n Returns : value of encoded_ref\n Args    : newvalue (optional)\n\n\n\nsub encoded_ref {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'encoded_ref'} = $value;\n   }\n   return $self->{'encoded_ref'};\n}\n\n=head2 doi\n\n Title   : doi\n Usage   : $self->doi($newval)\n Function: Gives the DOI (Digital Object Identifier) from the International\n           DOI Foundation (http://www.doi.org/), which can be used to resolve\n\t\t   URL links for the full-text documents using:\n\n\t\t   http://dx.doi.org/<doi>\n\n Example :\n Returns : value of doi\n Args    : newvalue (optional)\n\n\nsub doi {\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'doi'} = $value;\n    }\n    return $self->{'doi'};\n}\n\n=head2 consortium\n\n Title   : consortium\n Usage   : $self->consortium($newval)\n Function: Gives the consortium line. No attempt is made to parse the consortium line\n Example :\n Returns : value of consortium\n Args    : newvalue (optional)\n\n\n\nsub consortium{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'consortium'} = $value;\n    }\n    return $self->{'consortium'};\n}\n\n=head2 gb_reference\n\n Title   : gb_reference\n Usage   : $obj->gb_reference($newval)\n Function: Gives the generic GenBank REFERENCE line. This is GenBank-specific.\n           If set, this includes everything on the reference line except\n\t\t   the REFERENCE tag and the reference count.  This is mainly a\n\t\t   fallback for the few instances when REFERENCE lines have unusual\n\t\t   additional information such as split sequence locations, feature\n\t\t   references, etc.  See Bug 2020 in Bugzilla for more information.\n Example :\n Returns : value of gb_reference (a scalar)\n Args    : on set, new value (a scalar or undef, optional)","label":"gb_reference($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"end":{"character":9999,"line":604},"start":{"line":597,"character":0}},"name":"gb_reference"}],"version":5}