{"vars":[{"name":"base","containerName":"","kind":2,"line":48},{"range":{"end":{"line":74,"character":9999},"start":{"line":64,"character":0}},"name":"new","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set"},"containerName":"main::","definition":"sub","line":64,"children":[{"localvar":"my","containerName":"new","name":"$class","definition":"my","line":65,"kind":13},{"line":65,"kind":13,"containerName":"new","name":"@args"},{"line":67,"kind":13,"localvar":"my","containerName":"new","name":"$self","definition":"my"},{"containerName":"new","name":"$class","line":67,"kind":13},{"name":"@args","containerName":"new","line":67,"kind":13},{"localvar":"my","containerName":"new","definition":"my","name":"$text","line":68,"kind":13},{"kind":13,"line":68,"name":"$tag","containerName":"new"},{"name":"$type","containerName":"new","line":68,"kind":13},{"containerName":"new","name":"$self","line":68,"kind":13},{"containerName":"new","name":"_rearrange","kind":12,"line":68},{"line":68,"kind":13,"name":"@args","containerName":"new"},{"line":70,"kind":13,"containerName":"new","name":"$text"},{"containerName":"new","name":"$self","kind":13,"line":70},{"kind":12,"line":70,"name":"text","containerName":"new"},{"kind":13,"line":70,"containerName":"new","name":"$text"},{"line":71,"kind":13,"name":"$tag","containerName":"new"},{"line":71,"kind":13,"name":"$self","containerName":"new"},{"name":"tagname","containerName":"new","kind":12,"line":71},{"line":71,"kind":13,"containerName":"new","name":"$tag"},{"containerName":"new","name":"$type","kind":13,"line":72},{"line":72,"kind":13,"name":"$self","containerName":"new"},{"kind":12,"line":72,"containerName":"new","name":"type"},{"line":72,"kind":13,"containerName":"new","name":"$type"},{"containerName":"new","name":"$self","kind":13,"line":73}],"kind":12},{"containerName":"new","name":"SUPER","kind":12,"line":67},{"range":{"end":{"line":96,"character":9999},"start":{"line":92,"character":0}},"name":"as_text","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set\n\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($text,$tag, $type) = $self->_rearrange([qw(TEXT TAGNAME TYPE)], @args);\n\n  defined $text && $self->text($text);\n  defined $tag && $self->tagname($tag);\n  defined $type && $self->type($type);\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"as_text($self)"},"containerName":"main::","definition":"sub","line":92,"children":[{"containerName":"as_text","definition":"my","name":"$self","localvar":"my","kind":13,"line":93},{"kind":13,"line":95,"containerName":"as_text","name":"$self"},{"kind":12,"line":95,"name":"text","containerName":"as_text"}],"kind":12},{"kind":13,"line":115,"containerName":null,"definition":"my","name":"%DEFAULT_CB","localvar":"my"},{"name":"text","containerName":"main::","line":115,"kind":12},{"definition":"sub","containerName":"main::","signature":{"label":"display_text($self,$cb)","parameters":[{"label":"$self"},{"label":"$cb"}],"documentation":""},"detail":"($self,$cb)","kind":12,"children":[{"line":118,"kind":13,"localvar":"my","name":"$self","definition":"my","containerName":"display_text"},{"kind":13,"line":118,"name":"$cb","containerName":"display_text"},{"name":"$cb","containerName":"display_text","line":119,"kind":13},{"containerName":"display_text","name":"$DEFAULT_CB","kind":13,"line":119},{"kind":13,"line":120,"name":"$self","containerName":"display_text"},{"kind":12,"line":120,"name":"throw","containerName":"display_text"},{"name":"$cb","containerName":"display_text","kind":13,"line":120},{"name":"$cb","containerName":"display_text","line":121,"kind":13},{"containerName":"display_text","name":"$self","line":121,"kind":13}],"line":117,"name":"display_text","range":{"start":{"character":0,"line":117},"end":{"character":9999,"line":122}}},{"children":[{"definition":"my","name":"$self","containerName":"hash_tree","localvar":"my","kind":13,"line":139},{"containerName":"hash_tree","definition":"my","name":"$h","localvar":"my","kind":13,"line":141},{"line":142,"kind":13,"name":"$h","containerName":"hash_tree"},{"kind":13,"line":142,"name":"$self","containerName":"hash_tree"},{"containerName":"hash_tree","name":"text","kind":12,"line":142},{"kind":13,"line":143,"containerName":"hash_tree","name":"$h"}],"line":138,"kind":12,"range":{"start":{"line":138,"character":0},"end":{"line":144,"character":9999}},"definition":"sub","name":"hash_tree","containerName":"main::"},{"name":"tagname","range":{"end":{"line":172,"character":9999},"start":{"line":166,"character":0}},"kind":12,"line":166,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"tagname","line":167,"kind":13},{"kind":13,"line":167,"name":"$value","containerName":"tagname"},{"name":"$value","containerName":"tagname","line":168,"kind":13},{"containerName":"tagname","name":"$self","kind":13,"line":169},{"kind":13,"line":169,"name":"$value","containerName":"tagname"},{"line":171,"kind":13,"name":"$self","containerName":"tagname"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set\n\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($text,$tag, $type) = $self->_rearrange([qw(TEXT TAGNAME TYPE)], @args);\n\n  defined $text && $self->text($text);\n  defined $tag && $self->tagname($tag);\n  defined $type && $self->type($type);\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Comment: \".$self->text;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub {$_[0]->text || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub hash_tree{\n    my $self = shift;\n   \n    my $h = {};\n    $h->{'text'} = $self->text;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"tagname($self,$value)"}},{"range":{"end":{"line":200,"character":9999},"start":{"line":193,"character":0}},"name":"text","detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set\n\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($text,$tag, $type) = $self->_rearrange([qw(TEXT TAGNAME TYPE)], @args);\n\n  defined $text && $self->text($text);\n  defined $tag && $self->tagname($tag);\n  defined $type && $self->type($type);\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Comment: \".$self->text;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub {$_[0]->text || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub hash_tree{\n    my $self = shift;\n   \n    my $h = {};\n    $h->{'text'} = $self->text;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'tagname'} = $value;\n    }\n    return $self->{'tagname'};\n}\n\n=head1 Specific accessors for Comments\n\n\n\n=head2 text\n\n Title   : text\n Usage   : $value = $self->text($newval)\n Function: get/set for the text field. A comment object\n           just holds a single string which is accessible through\n           this method\n Example : \n Returns : value of text\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}],"label":"text($self,$value)"},"containerName":"main::","definition":"sub","line":193,"children":[{"line":194,"kind":13,"localvar":"my","containerName":"text","name":"$self","definition":"my"},{"line":194,"kind":13,"name":"$value","containerName":"text"},{"kind":13,"line":195,"name":"$value","containerName":"text"},{"name":"$self","containerName":"text","line":196,"kind":13},{"line":196,"kind":13,"containerName":"text","name":"$value"},{"name":"$self","containerName":"text","line":198,"kind":13}],"kind":12},{"name":"type","range":{"end":{"line":238,"character":9999},"start":{"character":0,"line":231}},"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: Comment.pm 15635 2009-04-14 19:11:13Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Comment\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Comment - A comment object, holding text\n\n=head1 SYNOPSIS\n\n\n    $comment = Bio::Annotation::Comment->new();\n    $comment->text(\"This is the text of this comment\");\n    $annotation->add_Annotation('comment', $comment);\n\n\n=head1 DESCRIPTION\n\nA holder for comments in annotations, just plain text. This is a very simple\nobject, and justifiably so.\n\n=head1 AUTHOR - Ewan Birney \n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\npackage Bio::Annotation::Comment;\nuse strict;\n\nuse base qw(Bio::Root::Root Bio::AnnotationI);\n\n=head2 new\n\n Title   : new\n Usage   : $comment = Bio::Annotation::Comment->new( '-text' => 'some text for this comment');\n Function: This returns a new comment object, optionally with\n           text filed\n Example :\n Returns : a Bio::Annotation::Comment object\n Args    : a hash with -text optionally set\n\n\n\n\nsub new {\n  my($class,@args) = @_;\n\n  my $self = $class->SUPER::new(@args);\n  my ($text,$tag, $type) = $self->_rearrange([qw(TEXT TAGNAME TYPE)], @args);\n\n  defined $text && $self->text($text);\n  defined $tag && $self->tagname($tag);\n  defined $type && $self->type($type);\n  return $self;\n}\n\n=head1 AnnotationI implementing functions\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub as_text{\n   my ($self) = @_;\n\n   return \"Comment: \".$self->text;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n  my $DEFAULT_CB = sub {$_[0]->text || ''};\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"Callback must be a code reference\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n\n}\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub hash_tree{\n    my $self = shift;\n   \n    my $h = {};\n    $h->{'text'} = $self->text;\n    return $h;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my ($self,$value) = @_;\n    if( defined $value) {\n\t$self->{'tagname'} = $value;\n    }\n    return $self->{'tagname'};\n}\n\n=head1 Specific accessors for Comments\n\n\n\n=head2 text\n\n Title   : text\n Usage   : $value = $self->text($newval)\n Function: get/set for the text field. A comment object\n           just holds a single string which is accessible through\n           this method\n Example : \n Returns : value of text\n Args    : newvalue (optional)\n\n\n\nsub text{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'text'} = $value;\n    }\n    return $self->{'text'};\n\n}\n\n=head2 value\n\n Title   : value\n Usage   : $value = $self->value($newval)\n Function: Alias of the 'text' method\n Example :\n Returns : value of text\n Args    : newvalue (optional)\n\n\n\n\n*value = \\&text;\n\n=head2 type\n\n Title   : type\n Usage   : $value = $self->type($newval)\n Function: get/set for the comment type field.  The comment type\n           is normally found as a subfield within comment sections\n           in some files, such as SwissProt\n Example : \n Returns : value of text\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$type"}],"label":"type($self,$type)"},"detail":"($self,$type)","kind":12,"children":[{"kind":13,"line":232,"name":"$self","definition":"my","containerName":"type","localvar":"my"},{"line":232,"kind":13,"containerName":"type","name":"$type"},{"kind":13,"line":233,"containerName":"type","name":"$type"},{"name":"$self","containerName":"type","line":234,"kind":13},{"containerName":"type","name":"$type","line":234,"kind":13},{"containerName":"type","name":"$self","line":236,"kind":13}],"line":231}],"version":5}