{"version":5,"vars":[{"name":"base","containerName":"","line":96,"kind":2},{"kind":12,"line":109,"children":[{"name":"$class","definition":"my","containerName":"new","localvar":"my","kind":13,"line":110},{"name":"@args","containerName":"new","line":110,"kind":13},{"line":112,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"new"},{"name":"$class","containerName":"new","kind":13,"line":112},{"containerName":"new","name":"@args","kind":13,"line":112},{"line":114,"kind":13,"containerName":"new","name":"$self"},{"name":"$self","containerName":"new","kind":13,"line":115},{"kind":12,"line":115,"name":"_typemap","containerName":"new"},{"kind":12,"line":115,"name":"new","containerName":"new"},{"line":117,"kind":13,"containerName":"new","name":"$self"}],"containerName":"main::","definition":"sub","detail":"($class,@args)","signature":{"label":"new($class,@args)","parameters":[{"label":"$class"},{"label":"@args"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none"},"name":"new","range":{"start":{"character":0,"line":109},"end":{"character":9999,"line":118}}},{"kind":12,"line":112,"containerName":"new","name":"SUPER"},{"name":"Bio","containerName":"Annotation::TypeManager","line":115,"kind":12},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none","parameters":[{"label":"$self"}],"label":"get_all_annotation_keys($self)"},"kind":12,"line":135,"children":[{"kind":13,"line":136,"name":"$self","definition":"my","containerName":"get_all_annotation_keys","localvar":"my"},{"containerName":"get_all_annotation_keys","name":"$self","line":137,"kind":13}],"name":"get_all_annotation_keys","range":{"end":{"character":9999,"line":137},"start":{"line":135,"character":0}}},{"range":{"end":{"line":170,"character":9999},"start":{"character":0,"line":158}},"name":"get_Annotations","signature":{"label":"get_Annotations($self,@keys)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)","parameters":[{"label":"$self"},{"label":"@keys"}]},"detail":"($self,@keys)","definition":"sub","containerName":"main::","children":[{"localvar":"my","definition":"my","name":"$self","containerName":"get_Annotations","line":159,"kind":13},{"containerName":"get_Annotations","name":"@keys","line":159,"kind":13},{"definition":"my","name":"@anns","containerName":"get_Annotations","localvar":"my","kind":13,"line":161},{"name":"@keys","containerName":"get_Annotations","line":162,"kind":13},{"name":"$self","containerName":"get_Annotations","kind":13,"line":162},{"name":"get_all_annotation_keys","containerName":"get_Annotations","kind":12,"line":162},{"kind":13,"line":162,"name":"@keys","containerName":"get_Annotations"},{"localvar":"my","definition":"my","name":"$key","containerName":"get_Annotations","line":163,"kind":13},{"line":163,"kind":13,"containerName":"get_Annotations","name":"@keys"},{"name":"$self","containerName":"get_Annotations","line":164,"kind":13},{"kind":13,"line":164,"containerName":"get_Annotations","name":"$key"},{"kind":13,"line":165,"name":"@anns","containerName":"get_Annotations"},{"kind":12,"line":167,"containerName":"get_Annotations","name":"tagname"},{"name":"$key","containerName":"get_Annotations","line":167,"kind":13},{"name":"tagname","containerName":"get_Annotations","kind":12,"line":167},{"kind":13,"line":168,"name":"$self","containerName":"get_Annotations"},{"kind":13,"line":168,"name":"$key","containerName":"get_Annotations"}],"line":158,"kind":12},{"kind":13,"line":171,"containerName":null,"name":"@anns"},{"kind":12,"line":199,"children":[{"line":200,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"get_nested_Annotations"},{"name":"@args","containerName":"get_nested_Annotations","kind":13,"line":200},{"containerName":"get_nested_Annotations","name":"$keys","definition":"my","localvar":"my","kind":13,"line":201},{"kind":13,"line":201,"name":"$recursive","containerName":"get_nested_Annotations"},{"containerName":"get_nested_Annotations","name":"$self","kind":13,"line":201},{"name":"_rearrange","containerName":"get_nested_Annotations","kind":12,"line":201},{"line":201,"kind":13,"containerName":"get_nested_Annotations","name":"@args"},{"kind":13,"line":202,"containerName":"get_nested_Annotations","name":"$self"},{"name":"verbose","containerName":"get_nested_Annotations","kind":12,"line":202},{"name":"@anns","definition":"my","containerName":"get_nested_Annotations","localvar":"my","kind":13,"line":204},{"containerName":"get_nested_Annotations","name":"$recursive","line":206,"kind":13},{"line":207,"kind":13,"localvar":"my","containerName":"get_nested_Annotations","definition":"my","name":"@keys"},{"containerName":"get_nested_Annotations","name":"$keys","line":207,"kind":13},{"name":"$self","containerName":"get_nested_Annotations","kind":13,"line":207},{"kind":12,"line":207,"name":"get_all_annotation_keys","containerName":"get_nested_Annotations"},{"localvar":"my","name":"$key","definition":"my","containerName":"get_nested_Annotations","line":208,"kind":13},{"kind":13,"line":208,"name":"@keys","containerName":"get_nested_Annotations"},{"name":"$self","containerName":"get_nested_Annotations","line":209,"kind":13},{"line":209,"kind":13,"containerName":"get_nested_Annotations","name":"$key"},{"kind":13,"line":210,"name":"@anns","containerName":"get_nested_Annotations"},{"kind":12,"line":212,"containerName":"get_nested_Annotations","name":"tagname"},{"name":"$key","containerName":"get_nested_Annotations","kind":13,"line":212},{"containerName":"get_nested_Annotations","name":"tagname","line":212,"kind":12},{"name":"$self","containerName":"get_nested_Annotations","kind":13,"line":213},{"name":"$key","containerName":"get_nested_Annotations","kind":13,"line":213}],"containerName":"main::","definition":"sub","detail":"($self,@args)","signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.","parameters":[{"label":"$self"},{"label":"@args"}],"label":"get_nested_Annotations($self,@args)"},"name":"get_nested_Annotations","range":{"start":{"line":199,"character":0},"end":{"line":216,"character":9999}}},{"line":219,"kind":13,"localvar":"my","definition":"my","name":"@allkeys","containerName":null},{"containerName":null,"name":"$self","kind":13,"line":219},{"line":219,"kind":12,"name":"get_all_annotation_keys","containerName":"main::"},{"localvar":"my","containerName":null,"name":"$key","definition":"my","line":220,"kind":13},{"containerName":null,"name":"@allkeys","kind":13,"line":220},{"line":221,"kind":13,"localvar":"my","name":"$keymatch","definition":"my","containerName":null},{"kind":13,"line":222,"definition":"my","name":"%searchkey","containerName":null,"localvar":"my"},{"line":223,"kind":13,"name":"$key","containerName":null},{"containerName":null,"name":"%searchkey","line":223,"kind":13},{"line":223,"kind":13,"containerName":null,"name":"$keymatch"},{"containerName":null,"name":"%keymatch","kind":13,"line":225},{"kind":13,"line":226,"containerName":null,"name":"%self"},{"containerName":null,"name":"%key","kind":13,"line":226},{"name":"@anns","containerName":null,"kind":13,"line":227},{"line":229,"kind":12,"name":"tagname","containerName":"main::"},{"kind":13,"line":229,"containerName":null,"name":"$key"},{"containerName":"main::","name":"tagname","kind":12,"line":229},{"kind":13,"line":230,"name":"%self","containerName":null},{"name":"%key","containerName":null,"line":230,"kind":13},{"line":234,"kind":13,"localvar":"my","containerName":null,"definition":"my","name":"@annotations"},{"containerName":null,"name":"%self","kind":13,"line":234},{"kind":13,"line":234,"name":"$key","containerName":null},{"kind":13,"line":235,"name":"@annotations","containerName":null},{"containerName":"main::","name":"isa","kind":12,"line":236},{"kind":13,"line":237,"name":"@anns","containerName":null},{"line":238,"kind":12,"name":"get_nested_Annotations","containerName":"main::"},{"kind":13,"line":238,"containerName":null,"name":"$keys"},{"line":245,"kind":13,"name":"@anns","containerName":null},{"name":"get_all_Annotations","range":{"end":{"line":276,"character":9999},"start":{"character":0,"line":269}},"kind":12,"children":[{"kind":13,"line":270,"definition":"my","name":"$self","containerName":"get_all_Annotations","localvar":"my"},{"kind":13,"line":270,"containerName":"get_all_Annotations","name":"@keys"},{"containerName":"get_all_Annotations","name":"isa","line":273,"kind":12},{"line":274,"kind":12,"name":"get_all_Annotations","containerName":"get_all_Annotations"},{"containerName":"get_all_Annotations","name":"$self","line":275,"kind":13},{"name":"get_Annotations","containerName":"get_all_Annotations","kind":12,"line":275},{"kind":13,"line":275,"containerName":"get_all_Annotations","name":"@keys"}],"line":269,"definition":"sub","containerName":"main::","signature":{"label":"get_all_Annotations($self,@keys)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)","parameters":[{"label":"$self"},{"label":"@keys"}]},"detail":"($self,@keys)"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none","label":"get_num_of_annotations($self)"},"kind":12,"line":290,"children":[{"containerName":"get_num_of_annotations","name":"$self","definition":"my","localvar":"my","kind":13,"line":291},{"localvar":"my","name":"$count","definition":"my","containerName":"get_num_of_annotations","line":292,"kind":13},{"name":"$count","containerName":"get_num_of_annotations","kind":13,"line":293},{"kind":13,"line":293,"name":"$_","containerName":"get_num_of_annotations"},{"name":"$self","containerName":"get_num_of_annotations","kind":13,"line":293}],"name":"get_num_of_annotations","range":{"end":{"line":293,"character":9999},"start":{"line":290,"character":0}}},{"name":"$count","containerName":null,"kind":13,"line":294},{"signature":{"label":"add_Annotation($self,$key,$object,$archetype)","documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to","parameters":[{"label":"$self"},{"label":"$key"},{"label":"$object"},{"label":"$archetype"}]},"detail":"($self,$key,$object,$archetype)","definition":"sub","containerName":"main::","children":[{"kind":13,"line":326,"definition":"my","name":"$self","containerName":"add_Annotation","localvar":"my"},{"name":"$key","containerName":"add_Annotation","line":326,"kind":13},{"kind":13,"line":326,"containerName":"add_Annotation","name":"$object"},{"name":"$archetype","containerName":"add_Annotation","kind":13,"line":326},{"containerName":"add_Annotation","name":"$key","kind":13,"line":329},{"kind":13,"line":329,"name":"$key","containerName":"add_Annotation"},{"kind":12,"line":329,"name":"isa","containerName":"add_Annotation"},{"name":"$object","containerName":"add_Annotation","line":329,"kind":13},{"containerName":"add_Annotation","name":"$archetype","kind":13,"line":330},{"containerName":"add_Annotation","name":"$object","line":330,"kind":13},{"kind":13,"line":330,"name":"$object","containerName":"add_Annotation"},{"line":331,"kind":13,"containerName":"add_Annotation","name":"$object"},{"kind":13,"line":331,"name":"$key","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"$key","line":332,"kind":13},{"kind":13,"line":332,"name":"$object","containerName":"add_Annotation"},{"kind":12,"line":332,"name":"tagname","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"$key","line":333,"kind":13},{"containerName":"add_Annotation","name":"$key","kind":13,"line":333},{"line":333,"kind":12,"name":"name","containerName":"add_Annotation"},{"line":333,"kind":13,"containerName":"add_Annotation","name":"$key"},{"line":334,"kind":13,"name":"$self","containerName":"add_Annotation"},{"name":"throw","containerName":"add_Annotation","kind":12,"line":334},{"kind":13,"line":335,"name":"$key","containerName":"add_Annotation"},{"line":338,"kind":13,"containerName":"add_Annotation","name":"$object"},{"line":339,"kind":13,"containerName":"add_Annotation","name":"$self"},{"containerName":"add_Annotation","name":"throw","kind":12,"line":339},{"containerName":"add_Annotation","name":"$object","line":342,"kind":13},{"kind":13,"line":343,"containerName":"add_Annotation","name":"$self"},{"name":"throw","containerName":"add_Annotation","line":343,"kind":12},{"kind":13,"line":346,"name":"$object","containerName":"add_Annotation"},{"kind":12,"line":346,"containerName":"add_Annotation","name":"isa"},{"kind":13,"line":347,"name":"$self","containerName":"add_Annotation"},{"line":347,"kind":12,"name":"throw","containerName":"add_Annotation"},{"kind":13,"line":353,"containerName":"add_Annotation","name":"$archetype"},{"name":"$archetype","containerName":"add_Annotation","line":354,"kind":13},{"kind":13,"line":354,"containerName":"add_Annotation","name":"$object"},{"kind":13,"line":358,"containerName":"add_Annotation","definition":"my","name":"$stored_map","localvar":"my"},{"line":358,"kind":13,"name":"$self","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"_typemap","line":358,"kind":12},{"line":358,"kind":12,"containerName":"add_Annotation","name":"type_for_key"},{"line":358,"kind":13,"name":"$key","containerName":"add_Annotation"},{"line":360,"kind":13,"containerName":"add_Annotation","name":"$stored_map"},{"kind":13,"line":364,"name":"$self","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"_typemap","kind":12,"line":364},{"name":"is_valid","containerName":"add_Annotation","kind":12,"line":364},{"containerName":"add_Annotation","name":"$key","kind":13,"line":364},{"containerName":"add_Annotation","name":"$object","line":364,"kind":13},{"containerName":"add_Annotation","name":"$self","kind":13,"line":365},{"containerName":"add_Annotation","name":"throw","kind":12,"line":365},{"kind":13,"line":370,"containerName":"add_Annotation","name":"$self"},{"kind":12,"line":370,"name":"_typemap","containerName":"add_Annotation"},{"containerName":"add_Annotation","name":"_add_type_map","line":370,"kind":12},{"line":370,"kind":13,"containerName":"add_Annotation","name":"$key"},{"name":"$archetype","containerName":"add_Annotation","line":370,"kind":13},{"name":"$self","containerName":"add_Annotation","kind":13,"line":375},{"line":375,"kind":13,"name":"$key","containerName":"add_Annotation"},{"name":"$self","containerName":"add_Annotation","line":376,"kind":13},{"name":"$key","containerName":"add_Annotation","line":376,"kind":13},{"containerName":"add_Annotation","name":"$self","line":379,"kind":13},{"containerName":"add_Annotation","name":"$key","kind":13,"line":379}],"line":325,"kind":12,"range":{"start":{"character":0,"line":325},"end":{"character":9999,"line":379}},"name":"add_Annotation"},{"kind":13,"line":379,"containerName":null,"name":"$object"},{"line":399,"children":[{"localvar":"my","containerName":"remove_Annotations","name":"$self","definition":"my","line":400,"kind":13},{"name":"@keys","containerName":"remove_Annotations","kind":13,"line":400},{"name":"@keys","containerName":"remove_Annotations","kind":13,"line":402},{"name":"$self","containerName":"remove_Annotations","kind":13,"line":402},{"kind":12,"line":402,"containerName":"remove_Annotations","name":"get_all_annotation_keys"},{"containerName":"remove_Annotations","name":"@keys","line":402,"kind":13},{"line":403,"kind":13,"localvar":"my","containerName":"remove_Annotations","name":"@anns","definition":"my"},{"line":403,"kind":13,"name":"$self","containerName":"remove_Annotations"},{"kind":12,"line":403,"name":"get_Annotations","containerName":"remove_Annotations"},{"line":403,"kind":13,"containerName":"remove_Annotations","name":"@keys"},{"name":"$key","definition":"my","containerName":"remove_Annotations","localvar":"my","kind":13,"line":405},{"line":405,"kind":13,"containerName":"remove_Annotations","name":"@keys"},{"name":"$self","containerName":"remove_Annotations","line":406,"kind":13},{"name":"$key","containerName":"remove_Annotations","kind":13,"line":406},{"kind":13,"line":407,"containerName":"remove_Annotations","name":"$self"},{"containerName":"remove_Annotations","name":"$key","kind":13,"line":407},{"name":"@anns","containerName":"remove_Annotations","line":409,"kind":13}],"kind":12,"detail":"($self,@keys)","signature":{"parameters":[{"label":"$self"},{"label":"@keys"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)","label":"remove_Annotations($self,@keys)"},"containerName":"main::","definition":"sub","range":{"start":{"character":0,"line":399},"end":{"character":9999,"line":410}},"name":"remove_Annotations"},{"name":"flatten_Annotations","range":{"end":{"line":441,"character":9999},"start":{"character":0,"line":432}},"containerName":"main::","definition":"sub","detail":"($self,@keys)","signature":{"label":"flatten_Annotations($self,@keys)","parameters":[{"label":"$self"},{"label":"@keys"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given"},"kind":12,"line":432,"children":[{"line":433,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"flatten_Annotations"},{"containerName":"flatten_Annotations","name":"@keys","kind":13,"line":433},{"kind":13,"line":435,"containerName":"flatten_Annotations","name":"@anns","definition":"my","localvar":"my"},{"name":"$self","containerName":"flatten_Annotations","line":435,"kind":13},{"name":"get_all_Annotations","containerName":"flatten_Annotations","line":435,"kind":12},{"line":435,"kind":13,"containerName":"flatten_Annotations","name":"@keys"},{"kind":13,"line":436,"containerName":"flatten_Annotations","definition":"my","name":"@origanns","localvar":"my"},{"containerName":"flatten_Annotations","name":"$self","kind":13,"line":436},{"containerName":"flatten_Annotations","name":"remove_Annotations","kind":12,"line":436},{"line":436,"kind":13,"name":"@keys","containerName":"flatten_Annotations"},{"name":"@anns","containerName":"flatten_Annotations","line":437,"kind":13},{"containerName":"flatten_Annotations","name":"$self","line":438,"kind":13},{"name":"add_Annotation","containerName":"flatten_Annotations","line":438,"kind":12},{"kind":13,"line":440,"name":"@origanns","containerName":"flatten_Annotations"}]},{"kind":12,"line":462,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"as_text","line":463,"kind":13},{"kind":13,"line":465,"definition":"my","name":"$txt","containerName":"as_text","localvar":"my"},{"definition":"my","name":"@texts","containerName":"as_text","localvar":"my","kind":13,"line":466},{"kind":13,"line":467,"name":"$ann","definition":"my","containerName":"as_text","localvar":"my"},{"line":467,"kind":13,"containerName":"as_text","name":"$self"},{"name":"get_Annotations","containerName":"as_text","kind":12,"line":467},{"name":"@texts","containerName":"as_text","kind":13,"line":468},{"kind":13,"line":468,"name":"$ann","containerName":"as_text"},{"name":"as_text","containerName":"as_text","kind":12,"line":468},{"line":470,"kind":13,"name":"@texts","containerName":"as_text"},{"line":471,"kind":13,"containerName":"as_text","name":"$txt"},{"kind":13,"line":471,"containerName":"as_text","name":"@texts"},{"containerName":"as_text","name":"$txt","line":473,"kind":13},{"kind":13,"line":475,"name":"$txt","containerName":"as_text"}],"containerName":"main::","definition":"sub","name":"as_text","range":{"end":{"character":9999,"line":476},"start":{"character":0,"line":462}}},{"localvar":"my","definition":"my","name":"%DEFAULT_CB","containerName":null,"line":497,"kind":13},{"definition":"my","name":"$obj","containerName":null,"localvar":"my","kind":13,"line":498},{"kind":13,"line":499,"definition":"my","name":"$txt","containerName":null,"localvar":"my"},{"localvar":"my","containerName":null,"definition":"my","name":"$ann","line":500,"kind":13},{"line":500,"kind":13,"name":"$obj","containerName":null},{"kind":12,"line":500,"name":"get_Annotations","containerName":"main::"},{"name":"$txt","containerName":null,"kind":13,"line":501},{"name":"$ann","containerName":null,"kind":13,"line":501},{"name":"display_text","containerName":"main::","kind":12,"line":501},{"containerName":null,"name":"$txt","line":503,"kind":13},{"kind":12,"line":506,"children":[{"line":507,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"display_text"},{"line":507,"kind":13,"containerName":"display_text","name":"$cb"},{"containerName":"display_text","name":"$cb","kind":13,"line":508},{"name":"$DEFAULT_CB","containerName":"display_text","line":508,"kind":13},{"kind":13,"line":509,"containerName":"display_text","name":"$self"},{"kind":12,"line":509,"name":"throw","containerName":"display_text"},{"line":509,"kind":13,"containerName":"display_text","name":"$cb"},{"name":"$cb","containerName":"display_text","line":510,"kind":13},{"containerName":"display_text","name":"$self","line":510,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$cb)","signature":{"label":"display_text($self,$cb)","documentation":"","parameters":[{"label":"$self"},{"label":"$cb"}]},"name":"display_text","range":{"start":{"character":0,"line":506},"end":{"character":9999,"line":511}}},{"containerName":"main::","definition":"sub","name":"hash_tree","range":{"end":{"line":537,"character":9999},"start":{"character":0,"line":527}},"kind":12,"line":527,"children":[{"localvar":"my","containerName":"hash_tree","name":"$self","definition":"my","line":528,"kind":13},{"localvar":"my","definition":"my","name":"$tree","containerName":"hash_tree","line":529,"kind":13},{"containerName":"hash_tree","definition":"my","name":"$key","localvar":"my","kind":13,"line":531},{"containerName":"hash_tree","name":"$self","line":531,"kind":13},{"containerName":"hash_tree","name":"get_all_annotation_keys","kind":12,"line":531},{"name":"$tree","containerName":"hash_tree","kind":13,"line":534},{"name":"$key","containerName":"hash_tree","line":534,"kind":13},{"kind":13,"line":534,"name":"$self","containerName":"hash_tree"},{"kind":12,"line":534,"containerName":"hash_tree","name":"get_Annotations"},{"line":534,"kind":13,"containerName":"hash_tree","name":"$key"},{"line":536,"kind":13,"name":"$tree","containerName":"hash_tree"}]},{"containerName":"main::","definition":"sub","name":"tagname","range":{"start":{"line":559,"character":0},"end":{"character":9999,"line":564}},"kind":12,"line":559,"children":[{"line":560,"kind":13,"localvar":"my","containerName":"tagname","definition":"my","name":"$self"},{"kind":13,"line":562,"containerName":"tagname","name":"$self"},{"containerName":"tagname","name":"$self","kind":13,"line":563}]},{"range":{"start":{"line":586,"character":0},"end":{"line":601,"character":9999}},"name":"description","line":586,"children":[{"line":587,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"description"},{"line":587,"kind":13,"containerName":"description","name":"$value"},{"name":"$self","containerName":"description","kind":13,"line":589},{"containerName":"description","name":"deprecated","line":589,"kind":12},{"containerName":"description","name":"$value","line":591,"kind":13},{"line":592,"kind":13,"localvar":"my","name":"$val","definition":"my","containerName":"description"},{"line":592,"kind":12,"name":"new","containerName":"description"},{"kind":13,"line":593,"name":"$val","containerName":"description"},{"name":"value","containerName":"description","line":593,"kind":12},{"containerName":"description","name":"$value","kind":13,"line":593},{"containerName":"description","name":"$self","line":594,"kind":13},{"containerName":"description","name":"add_Annotation","kind":12,"line":594},{"line":594,"kind":13,"containerName":"description","name":"$val"},{"kind":13,"line":597,"name":"$desc","definition":"my","containerName":"description","localvar":"my"},{"line":597,"kind":13,"containerName":"description","name":"$self"},{"kind":12,"line":597,"containerName":"description","name":"get_Annotations"},{"line":600,"kind":13,"containerName":"description","name":"$desc"},{"name":"$desc","containerName":"description","kind":13,"line":600},{"containerName":"description","name":"value","line":600,"kind":12}],"kind":12,"detail":"($self,$value)","signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$value"}],"label":"description($self,$value)"},"containerName":"main::","definition":"sub"},{"line":592,"kind":12,"containerName":"Annotation::SimpleValue","name":"Bio"},{"range":{"start":{"line":616,"character":0},"end":{"line":624,"character":9999}},"name":"add_gene_name","children":[{"line":617,"kind":13,"localvar":"my","containerName":"add_gene_name","definition":"my","name":"$self"},{"name":"$value","containerName":"add_gene_name","kind":13,"line":617},{"line":619,"kind":13,"containerName":"add_gene_name","name":"$self"},{"line":619,"kind":12,"name":"deprecated","containerName":"add_gene_name"},{"localvar":"my","containerName":"add_gene_name","name":"$val","definition":"my","line":621,"kind":13},{"name":"new","containerName":"add_gene_name","line":621,"kind":12},{"name":"$val","containerName":"add_gene_name","line":622,"kind":13},{"containerName":"add_gene_name","name":"value","kind":12,"line":622},{"line":622,"kind":13,"containerName":"add_gene_name","name":"$value"},{"name":"$self","containerName":"add_gene_name","line":623,"kind":13},{"kind":12,"line":623,"containerName":"add_gene_name","name":"add_Annotation"},{"containerName":"add_gene_name","name":"$val","kind":13,"line":623}],"line":616,"kind":12,"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"$value"}],"label":"add_gene_name($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"containerName":"Annotation::SimpleValue","name":"Bio","line":621,"kind":12},{"detail":"($self)","signature":{"label":"each_gene_name($self)","parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :"},"containerName":"main::","definition":"sub","line":638,"children":[{"name":"$self","definition":"my","containerName":"each_gene_name","localvar":"my","kind":13,"line":639},{"containerName":"each_gene_name","name":"$self","kind":13,"line":641},{"containerName":"each_gene_name","name":"deprecated","line":641,"kind":12},{"kind":13,"line":643,"name":"@out","definition":"my","containerName":"each_gene_name","localvar":"my"},{"localvar":"my","name":"@gene","definition":"my","containerName":"each_gene_name","line":644,"kind":13},{"line":644,"kind":13,"name":"$self","containerName":"each_gene_name"},{"containerName":"each_gene_name","name":"get_Annotations","kind":12,"line":644},{"definition":"my","name":"$g","containerName":"each_gene_name","localvar":"my","kind":13,"line":646},{"line":646,"kind":13,"containerName":"each_gene_name","name":"@gene"},{"name":"@out","containerName":"each_gene_name","kind":13,"line":647},{"line":647,"kind":13,"name":"$g","containerName":"each_gene_name"},{"kind":12,"line":647,"containerName":"each_gene_name","name":"value"},{"line":650,"kind":13,"name":"@out","containerName":"each_gene_name"}],"kind":12,"range":{"start":{"character":0,"line":638},"end":{"line":651,"character":9999}},"name":"each_gene_name"},{"range":{"end":{"line":674,"character":9999},"start":{"line":665,"character":0}},"name":"add_Reference","children":[{"containerName":"add_Reference","definition":"my","name":"$self","localvar":"my","kind":13,"line":666},{"containerName":"add_Reference","name":"@values","kind":13,"line":666},{"containerName":"add_Reference","name":"$self","kind":13,"line":668},{"line":668,"kind":12,"name":"deprecated","containerName":"add_Reference"},{"localvar":"my","containerName":"add_Reference","name":"$value","definition":"my","line":671,"kind":13},{"containerName":"add_Reference","name":"@values","kind":13,"line":671},{"kind":13,"line":672,"containerName":"add_Reference","name":"$self"},{"kind":12,"line":672,"containerName":"add_Reference","name":"add_Annotation"},{"line":672,"kind":13,"containerName":"add_Reference","name":"$value"}],"line":665,"kind":12,"signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"},{"label":"@values"}],"label":"add_Reference($self,@values)"},"detail":"($self,@values)","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}],"label":"each_Reference($self)"},"kind":12,"line":688,"children":[{"line":689,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"each_Reference"},{"name":"$self","containerName":"each_Reference","line":691,"kind":13},{"name":"deprecated","containerName":"each_Reference","kind":12,"line":691},{"name":"$self","containerName":"each_Reference","line":693,"kind":13},{"containerName":"each_Reference","name":"get_Annotations","line":693,"kind":12}],"name":"each_Reference","range":{"end":{"line":694,"character":9999},"start":{"character":0,"line":688}}},{"range":{"end":{"character":9999,"line":716},"start":{"line":709,"character":0}},"name":"add_Comment","children":[{"kind":13,"line":710,"definition":"my","name":"$self","containerName":"add_Comment","localvar":"my"},{"name":"$value","containerName":"add_Comment","kind":13,"line":710},{"name":"$self","containerName":"add_Comment","line":712,"kind":13},{"line":712,"kind":12,"name":"deprecated","containerName":"add_Comment"},{"line":714,"kind":13,"name":"$self","containerName":"add_Comment"},{"name":"add_Annotation","containerName":"add_Comment","line":714,"kind":12},{"containerName":"add_Comment","name":"$value","kind":13,"line":714}],"line":709,"kind":12,"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"add_Comment($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::"},{"containerName":"main::","definition":"sub","detail":"($self)","signature":{"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Comment{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_Comment (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('comment',$value);\n\n}\n\n=head2 each_Comment\n\n Title   : each_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","parameters":[{"label":"$self"}],"label":"each_Comment($self)"},"kind":12,"line":730,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"each_Comment","line":731,"kind":13},{"kind":13,"line":733,"containerName":"each_Comment","name":"$self"},{"name":"deprecated","containerName":"each_Comment","line":733,"kind":12},{"name":"$self","containerName":"each_Comment","kind":13,"line":735},{"containerName":"each_Comment","name":"get_Annotations","line":735,"kind":12}],"name":"each_Comment","range":{"end":{"character":9999,"line":736},"start":{"character":0,"line":730}}},{"kind":12,"line":752,"children":[{"kind":13,"line":753,"containerName":"add_DBLink","definition":"my","name":"$self","localvar":"my"},{"name":"$value","containerName":"add_DBLink","line":753,"kind":13},{"kind":13,"line":755,"containerName":"add_DBLink","name":"$self"},{"containerName":"add_DBLink","name":"deprecated","kind":12,"line":755},{"containerName":"add_DBLink","name":"$self","kind":13,"line":757},{"kind":12,"line":757,"name":"add_Annotation","containerName":"add_DBLink"},{"containerName":"add_DBLink","name":"$value","line":757,"kind":13}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Comment{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_Comment (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('comment',$value);\n\n}\n\n=head2 each_Comment\n\n Title   : each_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Comment{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Comment (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('comment');\n}\n\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"add_DBLink($self,$value)"},"name":"add_DBLink","range":{"start":{"character":0,"line":752},"end":{"line":759,"character":9999}}},{"range":{"start":{"line":773,"character":0},"end":{"character":9999,"line":779}},"name":"each_DBLink","children":[{"line":774,"kind":13,"localvar":"my","containerName":"each_DBLink","definition":"my","name":"$self"},{"name":"$self","containerName":"each_DBLink","kind":13,"line":776},{"line":776,"kind":12,"name":"deprecated","containerName":"each_DBLink"},{"name":"$self","containerName":"each_DBLink","kind":13,"line":778},{"kind":12,"line":778,"name":"get_Annotations","containerName":"each_DBLink"}],"line":773,"kind":12,"signature":{"parameters":[{"label":"$self"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Comment{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_Comment (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('comment',$value);\n\n}\n\n=head2 each_Comment\n\n Title   : each_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Comment{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Comment (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('comment');\n}\n\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_DBLink{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_DBLink (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('dblink',$value);\n\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :","label":"each_DBLink($self)"},"detail":"($self)","definition":"sub","containerName":"main::"},{"detail":"($self,$value)","signature":{"label":"_typemap($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: Collection.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::Annotation::Collection.pm\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Ewan Birney <birney@ebi.ac.uk>\n#\n# Copyright Ewan Birney\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::Annotation::Collection - Default Perl implementation of \nAnnotationCollectionI\n\n=head1 SYNOPSIS\n\n   # get an AnnotationCollectionI somehow, eg\n\n   $ac = $seq->annotation();\n\n   foreach $key ( $ac->get_all_annotation_keys() ) {\n       @values = $ac->get_Annotations($key);\n       foreach $value ( @values ) {\n          # value is an Bio::AnnotationI, and defines a \"as_text\" method\n          print \"Annotation \",$key,\" stringified value \",$value->as_text,\"\\n\";\n\n          # also defined hash_tree method, which allows data orientated\n          # access into this object\n          $hash = $value->hash_tree();\n       }\n   }\n\n=head1 DESCRIPTION\n\nBioperl implementation for Bio::AnnotationCollectionI \n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to one\nof the Bioperl mailing lists. Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via\nthe web:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Ewan Birney\n\nEmail birney@ebi.ac.uk\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::Annotation::Collection;\n\nuse strict;\n\n# Object preamble - inherits from Bio::Root::Root\n\nuse Bio::Annotation::TypeManager;\nuse Bio::Annotation::SimpleValue;\n\n\nuse base qw(Bio::Root::Root Bio::AnnotationCollectionI Bio::AnnotationI);\n\n\n=head2 new\n\n Title   : new\n Usage   : $coll = Bio::Annotation::Collection->new()\n Function: Makes a new Annotation::Collection object. \n Returns : Bio::Annotation::Collection\n Args    : none\n\n\nsub new{\n   my ($class,@args) = @_;\n\n   my $self = $class->SUPER::new(@args);\n\n   $self->{'_annotation'} = {};\n   $self->_typemap(Bio::Annotation::TypeManager->new());\n\n   return $self;\n}\n\n\n=head1 L<Bio::AnnotationCollectionI> implementing methods\n\n\n=head2 get_all_annotation_keys\n\n Title   : get_all_annotation_keys\n Usage   : $ac->get_all_annotation_keys()\n Function: gives back a list of annotation keys, which are simple text strings\n Returns : list of strings\n Args    : none\n\n\nsub get_all_annotation_keys{\n   my ($self) = @_;\n   return keys %{$self->{'_annotation'}};\n}\n\n=head2 get_Annotations\n\n Title   : get_Annotations\n Usage   : my @annotations = $collection->get_Annotations('key')\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : keys (list of strings) for annotations (optional)\n\n\nsub get_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = ();\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n    return @anns;\n}\n\n\n=head2 get_nested_Annotations\n\n Title   : get_nested_Annotations\n Usage   : my @annotations = $collection->get_nested_Annotations(\n                                '-key' => \\@keys,\n                                '-recursive => 1);\n Function: Retrieves all the Bio::AnnotationI objects for one or more\n           specific key(s). If -recursive is set to true, traverses the nested \n           annotation collections recursively and returns all annotations \n           matching the key(s).\n\n           If no key is given, returns all annotation objects.\n\n           The returned objects will have their tagname() attribute set to\n           the key under which they were attached, unless the tagname was\n           already set.\n\n Returns : list of Bio::AnnotationI - empty if no objects stored for a key\n Args    : -keys      => arrayref of keys to search for (optional)\n           -recursive => boolean, whether or not to recursively traverse the \n            nested annotations and return annotations with matching keys.\n\n\nsub get_nested_Annotations {\n  my ($self, @args) = @_;\n  my ($keys, $recursive) = $self->_rearrange([qw(KEYS RECURSIVE)], @args);\n  $self->verbose(1);\n  \n  my @anns = ();\n  # if not recursive behave exactly like get_Annotations()\n  if (!$recursive) {\n\t  my @keys = $keys? @$keys : $self->get_all_annotation_keys();\n    foreach my $key (@keys) {\n      if(exists($self->{'_annotation'}->{$key})) {\n        push(@anns,\n            map {\n            $_->tagname($key) if ! $_->tagname(); $_;\n            } @{$self->{'_annotation'}->{$key}});\n      }\n    }\n  }\n  # if recursive search for keys recursively\n  else {\n    my @allkeys = $self->get_all_annotation_keys();\n    foreach my $key (@allkeys) {\n      my $keymatch = 0;\n      foreach my $searchkey (@$keys) {\n        if ($key eq $searchkey) { $keymatch = 1;}\n      }\n      if ($keymatch) {\n        if(exists($self->{'_annotation'}->{$key})) {\n          push(@anns,\n              map {\n              $_->tagname($key) if ! $_->tagname(); $_;\n              } @{$self->{'_annotation'}->{$key}});\n        }\n      }\n      else {\n        my @annotations = @{$self->{'_annotation'}->{$key}};\n        foreach (@annotations) {\n          if ($_->isa(\"Bio::AnnotationCollectionI\")) {\n            push (@anns, \n                  $_->get_nested_Annotations('-keys' => $keys, '-recursive' => 1)\n                 );\n          }\n        }\n      }\n    }\n  }\n  return @anns;\n}\n\n=head2 get_all_Annotations\n\n Title   : get_all_Annotations\n Usage   :\n Function: Similar to get_Annotations, but traverses and flattens nested\n           annotation collections. This means that collections in the\n           tree will be replaced by their components.\n\n           Keys will not be passed on to nested collections. I.e., if the\n           tag name of a nested collection matches the key, it will be\n           flattened in its entirety.\n\n           Hence, for un-nested annotation collections this will be identical\n           to get_Annotations.\n Example :\n Returns : an array of L<Bio::AnnotationI> compliant objects\n Args    : keys (list of strings) for annotations (optional)\n\n\n\nsub get_all_Annotations{\n    my ($self,@keys) = @_;\n\n    return map {\n\t$_->isa(\"Bio::AnnotationCollectionI\") ?\n\t    $_->get_all_Annotations() : $_;\n    } $self->get_Annotations(@keys);\n}\n\n\n=head2 get_num_of_annotations\n\n Title   : get_num_of_annotations\n Usage   : my $count = $collection->get_num_of_annotations()\n Function: Returns the count of all annotations stored in this collection \n Returns : integer\n Args    : none\n\n\n\nsub get_num_of_annotations{\n   my ($self) = @_;\n   my $count = 0;\n   map { $count += scalar @$_ } values %{$self->{'_annotation'}};\n   return $count;\n}\n\n=head1 Implementation specific functions - mainly for adding\n\n\n=head2 add_Annotation\n\n Title   : add_Annotation\n Usage   : $self->add_Annotation('reference',$object);\n           $self->add_Annotation($object,'Bio::MyInterface::DiseaseI');\n           $self->add_Annotation($object);\n           $self->add_Annotation('disease',$object,'Bio::MyInterface::DiseaseI');\n Function: Adds an annotation for a specific key.\n\n           If the key is omitted, the object to be added must provide a value\n           via its tagname().\n\n           If the archetype is provided, this and future objects added under\n           that tag have to comply with the archetype and will be rejected\n           otherwise.\n\n Returns : none\n Args    : annotation key ('disease', 'dblink', ...)\n           object to store (must be Bio::AnnotationI compliant)\n           [optional] object archetype to map future storage of object \n                      of these types to\n\n\nsub add_Annotation{\n   my ($self,$key,$object,$archetype) = @_;\n   \n   # if there's no key we use the tagname() as key\n   if(ref($key) && $key->isa(\"Bio::AnnotationI\") && (!ref($object))) {\n       $archetype = $object if defined($object);\n       $object = $key;\n       $key = $object->tagname();\n       $key = $key->name() if ref($key); # OntologyTermI\n       $self->throw(\"Annotation object must have a tagname if key omitted\")\n\t   unless $key;\n   }\n\n   if( !defined $object ) {\n       $self->throw(\"Must have at least key and object in add_Annotation\");\n   }\n\n   if( !ref $object ) {\n       $self->throw(\"Must add an object. Use Bio::Annotation::{Comment,SimpleValue,OntologyTerm} for simple text additions\");\n   }\n\n   if( !$object->isa(\"Bio::AnnotationI\") ) {\n       $self->throw(\"object must be AnnotationI compliant, otherwise we won't add it!\");\n   }\n\n   # ok, now we are ready! If we don't have an archetype, set it\n   # from the type of the object\n\n   if( !defined $archetype ) {\n       $archetype = ref $object;\n   }\n\n   # check typemap, storing if needed.\n   my $stored_map = $self->_typemap->type_for_key($key);\n\n   if( defined $stored_map ) {\n       # check validity, irregardless of archetype. A little cheeky\n       # this means isa stuff is executed correctly\n\n       if( !$self->_typemap()->is_valid($key,$object) ) {\n\t   $self->throw(\"Object $object was not valid with key $key. \".\n         \"If you were adding new keys in, perhaps you want to make use\\n\".\n         \"of the archetype method to allow registration to a more basic type\");\n       }\n   } else {\n       $self->_typemap->_add_type_map($key,$archetype);\n   }\n\n   # we are ok to store\n\n   if( !defined $self->{'_annotation'}->{$key} ) {\n       $self->{'_annotation'}->{$key} = [];\n   }\n\n   push(@{$self->{'_annotation'}->{$key}},$object);\n\n   return 1;\n}\n\n=head2 remove_Annotations\n\n Title   : remove_Annotations\n Usage   :\n Function: Remove the annotations for the specified key from this collection.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : the key(s) (tag name(s), one or more strings) for which to\n           remove annotations (optional; if none given, flushes all\n           annotations)\n\n\n\nsub remove_Annotations{\n    my ($self, @keys) = @_;\n\n    @keys = $self->get_all_annotation_keys() unless @keys;\n    my @anns = $self->get_Annotations(@keys);\n    # flush\n    foreach my $key (@keys) {\n      delete $self->{'_annotation'}->{$key};\n      delete $self->{'_typemap'}->{'_type'}->{$key};\n    }\n    return @anns;\n}\n\n=head2 flatten_Annotations\n\n Title   : flatten_Annotations\n Usage   :\n Function: Flattens part or all of the annotations in this collection.\n\n           This is a convenience method for getting the flattened\n           annotation for the given keys, removing the annotation for\n           those keys, and adding back the flattened array.\n\n           This should not change anything for un-nested collections.\n Example :\n Returns : an array Bio::AnnotationI compliant objects which were stored\n           under the given key(s)\n Args    : list of keys (strings) the annotation for which to flatten,\n           defaults to all keys if not given\n\n\n\nsub flatten_Annotations{\n    my ($self,@keys) = @_;\n\n    my @anns = $self->get_all_Annotations(@keys);\n    my @origanns = $self->remove_Annotations(@keys);\n    foreach (@anns) {\n\t$self->add_Annotation($_);\n    }\n    return @origanns;\n}\n\n=head1 Bio::AnnotationI methods implementations\n\n   This is to allow nested annotation: you can use a collection as an\n   annotation object for an annotation collection.\n\n\n=head2 as_text\n\n Title   : as_text\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a string\n Args    : none\n\n\n\nsub as_text{\n    my $self = shift;\n\n    my $txt = \"Collection consisting of \";\n    my @texts = ();\n    foreach my $ann ($self->get_Annotations()) {\n\tpush(@texts, $ann->as_text());\n    }\n    if(@texts) {\n\t$txt .= join(\", \", map { '['.$_.']'; } @texts);\n    } else {\n\t$txt .= \"no elements\";\n    }\n    return $txt;\n}\n\n=head2 display_text\n\n Title   : display_text\n Usage   : my $str = $ann->display_text();\n Function: returns a string. Unlike as_text(), this method returns a string\n           formatted as would be expected for te specific implementation.\n\n           One can pass a callback as an argument which allows custom text\n           generation; the callback is passed the current instance and any text\n           returned\n Example :\n Returns : a string\n Args    : [optional] callback\n\n\n{\n   # this just calls the default display_text output for\n   # any AnnotationI\n  my $DEFAULT_CB = sub {\n    my $obj = shift;\n    my $txt;\n    foreach my $ann ($obj->get_Annotations()) {\n      $txt .= $ann->display_text().\"\\n\";\n    }\n    return $txt;\n    };\n\n  sub display_text {\n    my ($self, $cb) = @_;\n    $cb ||= $DEFAULT_CB;\n    $self->throw(\"\") if ref $cb ne 'CODE';\n    return $cb->($self);\n  }\n}\n\n\n=head2 hash_tree\n\n Title   : hash_tree\n Usage   :\n Function: See L<Bio::AnnotationI>\n Example :\n Returns : a hash reference\n Args    : none\n\n\n\nsub hash_tree{\n    my $self = shift;\n    my $tree = {};\n\n    foreach my $key ($self->get_all_annotation_keys()) {\n\t# all contained objects will support hash_tree() \n\t# (they are AnnotationIs)\n\t$tree->{$key} = [$self->get_Annotations($key)];\n    }\n    return $tree;\n}\n\n=head2 tagname\n\n Title   : tagname\n Usage   : $obj->tagname($newval)\n Function: Get/set the tagname for this annotation value.\n\n           Setting this is optional. If set, it obviates the need to\n           provide a tag to Bio::AnnotationCollectionI when adding\n           this object. When obtaining an AnnotationI object from the\n           collection, the collection will set the value to the tag\n           under which it was stored unless the object has a tag\n           stored already.\n\n Example : \n Returns : value of tagname (a scalar)\n Args    : new value (a scalar, optional)\n\n\n\nsub tagname{\n    my $self = shift;\n\n    return $self->{'tagname'} = shift if @_;\n    return $self->{'tagname'};\n}\n\n\n=head1 Backward compatible functions\n\nFunctions put in for backward compatibility with old\nBio::Annotation.pm stuff\n\n\n=head2 description\n\n Title   : description\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub description{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Using old style annotation call on new Annotation::Collection object\");\n\n   if( defined $value ) {\n       my $val = Bio::Annotation::SimpleValue->new();\n       $val->value($value);\n       $self->add_Annotation('description',$val);\n   }\n\n   my ($desc) = $self->get_Annotations('description');\n   \n   # If no description tag exists, do not attempt to call value on undef:\n   return $desc ? $desc->value : undef;\n}\n\n\n=head2 add_gene_name\n\n Title   : add_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_gene_name{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"Old style add_gene_name called on new style Annotation::Collection\");\n\n   my $val = Bio::Annotation::SimpleValue->new();\n   $val->value($value);\n   $self->add_Annotation('gene_name',$val);\n}\n\n=head2 each_gene_name\n\n Title   : each_gene_name\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_gene_name{\n   my ($self) = @_;\n\n   $self->deprecated(\"Old style each_gene_name called on new style Annotation::Collection\");\n\n   my @out;\n   my @gene = $self->get_Annotations('gene_name');\n\n   foreach my $g ( @gene ) {\n       push(@out,$g->value);\n   }\n\n   return @out;\n}\n\n=head2 add_Reference\n\n Title   : add_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Reference{\n   my ($self, @values) = @_;\n\n   $self->deprecated(\"add_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   # Allow multiple (or no) references to be passed, as per old method\n   foreach my $value (@values) {\n       $self->add_Annotation('reference',$value);\n   }\n}\n\n=head2 each_Reference\n\n Title   : each_Reference\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Reference{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Reference (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('reference');\n}\n\n\n=head2 add_Comment\n\n Title   : add_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_Comment{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_Comment (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('comment',$value);\n\n}\n\n=head2 each_Comment\n\n Title   : each_Comment\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_Comment{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_Comment (old style Annotation) on new style Annotation::Collection\");\n   \n   return $self->get_Annotations('comment');\n}\n\n\n\n=head2 add_DBLink\n\n Title   : add_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub add_DBLink{\n   my ($self,$value) = @_;\n\n   $self->deprecated(\"add_DBLink (old style Annotation) on new style Annotation::Collection\");\n\n   $self->add_Annotation('dblink',$value);\n\n}\n\n=head2 each_DBLink\n\n Title   : each_DBLink\n Usage   :\n Function:\n Example :\n Returns : \n Args    :\n\n\n\nsub each_DBLink{\n   my ($self) = @_;\n\n   $self->deprecated(\"each_DBLink (old style Annotation) on new style Annotation::Collection - use get_Annotations('dblink')\");\n   \n   return $self->get_Annotations('dblink');\n}\n\n\n\n=head1 Implementation management functions\n\n\n=head2 _typemap\n\n Title   : _typemap\n Usage   : $obj->_typemap($newval)\n Function: \n Example : \n Returns : value of _typemap\n Args    : newvalue (optional)"},"containerName":"main::","definition":"sub","line":799,"children":[{"line":800,"kind":13,"localvar":"my","containerName":"_typemap","definition":"my","name":"$self"},{"line":800,"kind":13,"name":"$value","containerName":"_typemap"},{"kind":13,"line":801,"containerName":"_typemap","name":"$value"},{"name":"$self","containerName":"_typemap","kind":13,"line":802},{"containerName":"_typemap","name":"$value","line":802,"kind":13},{"name":"$self","containerName":"_typemap","line":804,"kind":13}],"kind":12,"range":{"start":{"line":799,"character":0},"end":{"line":806,"character":9999}},"name":"_typemap"}]}