{"vars":[{"containerName":"","name":"vars","line":91,"kind":2},{"name":"base","containerName":"","line":97,"kind":2},{"containerName":null,"name":"$DEFAULTIDLENGTH","kind":13,"line":100},{"name":"$DEFAULTLINELEN","containerName":null,"line":101,"kind":13},{"name":"$DEFAULTTAGLEN","containerName":null,"kind":13,"line":102},{"range":{"start":{"character":0,"line":134},"end":{"character":9999,"line":157}},"name":"_initialize","children":[{"line":135,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"_initialize"},{"name":"@args","containerName":"_initialize","kind":13,"line":135},{"line":136,"kind":13,"name":"$self","containerName":"_initialize"},{"kind":13,"line":136,"containerName":"_initialize","name":"@args"},{"localvar":"my","name":"$interleave","definition":"my","containerName":"_initialize","line":138,"kind":13},{"line":138,"kind":13,"containerName":"_initialize","name":"$linelen"},{"line":138,"kind":13,"name":"$idlinebreak","containerName":"_initialize"},{"containerName":"_initialize","name":"$idlength","kind":13,"line":139},{"name":"$flag_SI","containerName":"_initialize","line":139,"kind":13},{"kind":13,"line":139,"name":"$tag_length","containerName":"_initialize"},{"kind":13,"line":139,"name":"$ws","containerName":"_initialize"},{"containerName":"_initialize","name":"$longid","kind":13,"line":139},{"containerName":"_initialize","name":"$self","kind":13,"line":140},{"name":"_rearrange","containerName":"_initialize","line":140,"kind":12},{"kind":13,"line":147,"name":"@args","containerName":"_initialize"},{"containerName":"_initialize","name":"$self","line":148,"kind":13},{"line":148,"kind":12,"containerName":"_initialize","name":"interleaved"},{"kind":13,"line":148,"containerName":"_initialize","name":"$interleave"},{"line":148,"kind":13,"name":"$interleave","containerName":"_initialize"},{"kind":13,"line":149,"name":"$self","containerName":"_initialize"},{"containerName":"_initialize","name":"idlength","line":149,"kind":12},{"line":149,"kind":13,"containerName":"_initialize","name":"$idlength"},{"kind":13,"line":149,"containerName":"_initialize","name":"$DEFAULTIDLENGTH"},{"containerName":"_initialize","name":"$self","line":150,"kind":13},{"line":150,"kind":12,"name":"id_linebreak","containerName":"_initialize"},{"kind":13,"line":150,"containerName":"_initialize","name":"$idlinebreak"},{"containerName":"_initialize","name":"$self","line":151,"kind":13},{"name":"line_length","containerName":"_initialize","line":151,"kind":12},{"name":"$linelen","containerName":"_initialize","kind":13,"line":151},{"name":"$linelen","containerName":"_initialize","kind":13,"line":151},{"kind":13,"line":151,"name":"$linelen","containerName":"_initialize"},{"line":152,"kind":13,"containerName":"_initialize","name":"$self"},{"kind":12,"line":152,"containerName":"_initialize","name":"flag_SI"},{"containerName":"_initialize","name":"$flag_SI","line":152,"kind":13},{"line":153,"kind":13,"containerName":"_initialize","name":"$self"},{"containerName":"_initialize","name":"tag_length","line":153,"kind":12},{"containerName":"_initialize","name":"$tag_length","kind":13,"line":153},{"kind":13,"line":153,"name":"$tag_length","containerName":"_initialize"},{"line":153,"kind":13,"containerName":"_initialize","name":"$DEFAULTTAGLEN"},{"name":"$self","containerName":"_initialize","line":154,"kind":13},{"containerName":"_initialize","name":"wrap_sequential","kind":12,"line":154},{"containerName":"_initialize","name":"$ws","kind":13,"line":154},{"line":155,"kind":13,"name":"$self","containerName":"_initialize"},{"name":"longid","containerName":"_initialize","line":155,"kind":12},{"containerName":"_initialize","name":"$longid","kind":13,"line":155}],"line":134,"kind":12,"signature":{"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)","parameters":[{"label":"$self"},{"label":"@args"}],"label":"_initialize($self,@args)"},"detail":"($self,@args)","definition":"sub","containerName":"main::"},{"line":136,"kind":12,"containerName":"_initialize","name":"SUPER"},{"range":{"start":{"character":0,"line":171},"end":{"line":298,"character":9999}},"definition":"sub","name":"next_aln","containerName":"main::","children":[{"line":172,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_aln"},{"name":"$entry","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":173},{"localvar":"my","definition":"my","name":"$seqcount","containerName":"next_aln","line":174,"kind":13},{"name":"$residuecount","containerName":"next_aln","line":174,"kind":13},{"name":"%hash","containerName":"next_aln","kind":13,"line":174},{"containerName":"next_aln","name":"$name","kind":13,"line":174},{"name":"$str","containerName":"next_aln","kind":13,"line":174},{"kind":13,"line":175,"name":"@names","containerName":"next_aln"},{"line":175,"kind":13,"name":"$seqname","containerName":"next_aln"},{"name":"$start","containerName":"next_aln","kind":13,"line":175},{"containerName":"next_aln","name":"$end","kind":13,"line":175},{"containerName":"next_aln","name":"$count","line":175,"kind":13},{"kind":13,"line":175,"containerName":"next_aln","name":"$seq"},{"containerName":"next_aln","name":"$aln","definition":"my","localvar":"my","kind":13,"line":177},{"name":"new","containerName":"next_aln","line":177,"kind":12},{"name":"$entry","containerName":"next_aln","kind":13,"line":178},{"kind":13,"line":178,"name":"$self","containerName":"next_aln"},{"containerName":"next_aln","name":"_readline","kind":12,"line":178},{"name":"$seqcount","containerName":"next_aln","kind":13,"line":179},{"name":"$residuecount","containerName":"next_aln","kind":13,"line":179},{"kind":13,"line":179,"name":"$entry","containerName":"next_aln"},{"name":"$seqcount","containerName":"next_aln","line":180,"kind":13},{"name":"$residuecount","containerName":"next_aln","line":180,"kind":13},{"containerName":"next_aln","name":"$idlen","definition":"my","localvar":"my","kind":13,"line":183},{"kind":13,"line":183,"name":"$self","containerName":"next_aln"},{"containerName":"next_aln","name":"idlength","line":183,"kind":12},{"containerName":"next_aln","name":"$count","kind":13,"line":184},{"containerName":"next_aln","name":"$iter","definition":"my","localvar":"my","kind":13,"line":185},{"localvar":"my","definition":"my","name":"$interleaved","containerName":"next_aln","line":186,"kind":13},{"name":"$self","containerName":"next_aln","line":186,"kind":13},{"kind":12,"line":186,"name":"interleaved","containerName":"next_aln"},{"containerName":"next_aln","name":"$entry","line":187,"kind":13},{"line":187,"kind":13,"containerName":"next_aln","name":"$self"},{"name":"_readline","containerName":"next_aln","kind":12,"line":187},{"name":"$entry","containerName":"next_aln","kind":13,"line":188},{"name":"$interleaved","containerName":"next_aln","line":188,"kind":13},{"line":190,"kind":13,"name":"$entry","containerName":"next_aln"},{"containerName":"next_aln","name":"$self","kind":13,"line":191},{"name":"_pushback","containerName":"next_aln","kind":12,"line":191},{"line":191,"kind":13,"name":"$entry","containerName":"next_aln"},{"containerName":"next_aln","name":"$self","line":194,"kind":13},{"line":194,"kind":12,"containerName":"next_aln","name":"longid"},{"name":"$entry","containerName":"next_aln","line":194,"kind":13},{"line":195,"kind":13,"name":"$entry","containerName":"next_aln"},{"name":"$entry","containerName":"next_aln","line":196,"kind":13},{"kind":13,"line":197,"containerName":"next_aln","name":"$name"},{"kind":13,"line":198,"containerName":"next_aln","name":"$str"},{"line":200,"kind":13,"name":"$entry","containerName":"next_aln"},{"kind":13,"line":201,"containerName":"next_aln","name":"$name"},{"line":202,"kind":13,"name":"$str","containerName":"next_aln"},{"kind":13,"line":205,"name":"$name","containerName":"next_aln"},{"name":"@names","containerName":"next_aln","kind":13,"line":207},{"kind":13,"line":207,"name":"$name","containerName":"next_aln"},{"kind":13,"line":208,"name":"$str","containerName":"next_aln"},{"name":"$count","containerName":"next_aln","line":209,"kind":13},{"containerName":"next_aln","name":"@names","line":209,"kind":13},{"name":"$hash","containerName":"next_aln","kind":13,"line":210},{"containerName":"next_aln","name":"$count","kind":13,"line":210},{"line":210,"kind":13,"name":"$str","containerName":"next_aln"},{"containerName":"next_aln","name":"$entry","line":212,"kind":13},{"line":213,"kind":13,"name":"$interleaved","containerName":"next_aln"},{"name":"$str","containerName":"next_aln","kind":13,"line":214},{"containerName":"next_aln","name":"$str","kind":13,"line":215},{"name":"$count","containerName":"next_aln","line":216,"kind":13},{"line":216,"kind":13,"containerName":"next_aln","name":"@names"},{"line":217,"kind":13,"containerName":"next_aln","name":"$hash"},{"kind":13,"line":217,"containerName":"next_aln","name":"$count"},{"containerName":"next_aln","name":"$str","kind":13,"line":217},{"name":"$entry","containerName":"next_aln","kind":13,"line":218},{"name":"$entry","containerName":"next_aln","line":219,"kind":13},{"containerName":"next_aln","name":"$name","line":221,"kind":13},{"containerName":"next_aln","name":"$str","line":222,"kind":13},{"containerName":"next_aln","name":"$name","kind":13,"line":223},{"name":"$name","containerName":"next_aln","kind":13,"line":224},{"containerName":"next_aln","name":"@names","kind":13,"line":226},{"containerName":"next_aln","name":"$name","line":226,"kind":13},{"line":227,"kind":13,"name":"$str","containerName":"next_aln"},{"kind":13,"line":228,"name":"$count","containerName":"next_aln"},{"line":228,"kind":13,"containerName":"next_aln","name":"@names"},{"line":229,"kind":13,"name":"$hash","containerName":"next_aln"},{"name":"$count","containerName":"next_aln","line":229,"kind":13},{"containerName":"next_aln","name":"$str","kind":13,"line":229},{"kind":13,"line":230,"containerName":"next_aln","name":"$interleaved"},{"containerName":"next_aln","name":"$entry","kind":13,"line":231},{"line":232,"kind":13,"containerName":"next_aln","name":"$entry"},{"containerName":"next_aln","name":"$name","line":233,"kind":13},{"line":234,"kind":13,"containerName":"next_aln","name":"$str"},{"line":235,"kind":13,"name":"$name","containerName":"next_aln"},{"line":236,"kind":13,"name":"$name","containerName":"next_aln"},{"name":"@names","containerName":"next_aln","kind":13,"line":237},{"kind":13,"line":237,"containerName":"next_aln","name":"$name"},{"kind":13,"line":238,"containerName":"next_aln","name":"$str"},{"line":239,"kind":13,"containerName":"next_aln","name":"$count"},{"line":239,"kind":13,"name":"@names","containerName":"next_aln"},{"line":240,"kind":13,"name":"$hash","containerName":"next_aln"},{"line":240,"kind":13,"name":"$count","containerName":"next_aln"},{"kind":13,"line":240,"containerName":"next_aln","name":"$str"},{"containerName":"next_aln","name":"$self","kind":13,"line":242},{"line":242,"kind":12,"name":"debug","containerName":"next_aln"},{"name":"$self","containerName":"next_aln","kind":13,"line":245},{"line":245,"kind":12,"containerName":"next_aln","name":"throw"},{"line":245,"kind":13,"containerName":"next_aln","name":"$count"},{"containerName":"next_aln","name":"$seqcount","line":245,"kind":13},{"containerName":"next_aln","name":"$interleaved","kind":13,"line":248},{"kind":13,"line":250,"name":"$count","containerName":"next_aln"},{"line":251,"kind":13,"name":"$entry","containerName":"next_aln"},{"kind":13,"line":251,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","name":"_readline","line":251,"kind":12},{"containerName":"next_aln","name":"$entry","line":253,"kind":13},{"kind":13,"line":254,"containerName":"next_aln","name":"$self"},{"line":254,"kind":12,"name":"_pushback","containerName":"next_aln"},{"containerName":"next_aln","name":"$entry","line":254,"kind":13},{"kind":13,"line":257,"name":"$count","containerName":"next_aln"},{"kind":13,"line":257,"containerName":"next_aln","name":"$entry"},{"containerName":"next_aln","name":"$entry","kind":13,"line":258},{"kind":13,"line":259,"containerName":"next_aln","name":"$str"},{"line":260,"kind":13,"containerName":"next_aln","name":"$str"},{"containerName":"next_aln","name":"$count","kind":13,"line":261},{"line":262,"kind":13,"containerName":"next_aln","name":"$hash"},{"containerName":"next_aln","name":"$count","line":262,"kind":13},{"line":262,"kind":13,"name":"$str","containerName":"next_aln"},{"kind":13,"line":264,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","name":"throw","kind":12,"line":264},{"containerName":"next_aln","name":"$count","line":264,"kind":13},{"kind":13,"line":264,"name":"$seqcount","containerName":"next_aln"},{"containerName":"next_aln","name":"@names","line":267,"kind":13},{"kind":13,"line":270,"name":"$count","containerName":"next_aln"},{"name":"$name","containerName":"next_aln","kind":13,"line":271},{"name":"@names","containerName":"next_aln","kind":13,"line":271},{"line":272,"kind":13,"name":"$count","containerName":"next_aln"},{"kind":13,"line":273,"containerName":"next_aln","name":"$name"},{"kind":13,"line":274,"name":"$seqname","containerName":"next_aln"},{"kind":13,"line":275,"containerName":"next_aln","name":"$start"},{"kind":13,"line":276,"name":"$end","containerName":"next_aln"},{"kind":13,"line":278,"containerName":"next_aln","name":"$seqname"},{"name":"$name","containerName":"next_aln","line":278,"kind":13},{"name":"$start","containerName":"next_aln","line":279,"kind":13},{"line":280,"kind":13,"name":"$str","containerName":"next_aln"},{"containerName":"next_aln","name":"$hash","line":280,"kind":13},{"containerName":"next_aln","name":"$count","kind":13,"line":280},{"line":281,"kind":13,"name":"$str","containerName":"next_aln"},{"name":"$end","containerName":"next_aln","kind":13,"line":282},{"name":"$str","containerName":"next_aln","kind":13,"line":282},{"line":285,"kind":13,"name":"$self","containerName":"next_aln"},{"line":285,"kind":12,"name":"throw","containerName":"next_aln"},{"kind":13,"line":285,"name":"$hash","containerName":"next_aln"},{"line":285,"kind":13,"name":"$count","containerName":"next_aln"},{"line":286,"kind":13,"name":"$hash","containerName":"next_aln"},{"kind":13,"line":286,"containerName":"next_aln","name":"$count"},{"containerName":"next_aln","name":"$residuecount","kind":13,"line":286},{"containerName":"next_aln","name":"$seq","kind":13,"line":288},{"name":"new","containerName":"next_aln","line":288,"kind":12},{"line":288,"kind":13,"containerName":"next_aln","name":"$hash"},{"containerName":"next_aln","name":"$count","kind":13,"line":288},{"line":289,"kind":13,"containerName":"next_aln","name":"$seqname"},{"name":"$start","containerName":"next_aln","line":290,"kind":13},{"line":291,"kind":13,"containerName":"next_aln","name":"$end"},{"line":293,"kind":13,"containerName":"next_aln","name":"$aln"},{"name":"add_seq","containerName":"next_aln","kind":12,"line":293},{"kind":13,"line":293,"containerName":"next_aln","name":"$seq"},{"kind":13,"line":296,"name":"$aln","containerName":"next_aln"},{"containerName":"next_aln","name":"$aln","line":296,"kind":13},{"containerName":"next_aln","name":"num_sequences","kind":12,"line":296}],"line":171,"kind":12},{"line":177,"kind":12,"containerName":"SimpleAlign","name":"Bio"},{"kind":12,"line":285,"containerName":"length","name":"CORE"},{"line":286,"kind":12,"name":"CORE","containerName":"length"},{"name":"Bio","containerName":"LocatableSeq","line":288,"kind":12},{"name":"write_aln","range":{"start":{"line":311,"character":0},"end":{"line":418,"character":9999}},"kind":12,"line":311,"children":[{"localvar":"my","name":"$self","definition":"my","containerName":"write_aln","line":312,"kind":13},{"name":"@aln","containerName":"write_aln","line":312,"kind":13},{"containerName":"write_aln","name":"$count","definition":"my","localvar":"my","kind":13,"line":313},{"kind":13,"line":314,"containerName":"write_aln","definition":"my","name":"$wrapped","localvar":"my"},{"kind":13,"line":315,"containerName":"write_aln","name":"$maxname","definition":"my","localvar":"my"},{"containerName":"write_aln","definition":"my","name":"$width","localvar":"my","kind":13,"line":316},{"containerName":"write_aln","name":"$self","kind":13,"line":316},{"line":316,"kind":12,"containerName":"write_aln","name":"line_length"},{"line":317,"kind":13,"localvar":"my","containerName":"write_aln","name":"$length","definition":"my"},{"containerName":"write_aln","name":"$date","line":317,"kind":13},{"name":"$name","containerName":"write_aln","line":317,"kind":13},{"name":"$seq","containerName":"write_aln","line":317,"kind":13},{"kind":13,"line":317,"containerName":"write_aln","name":"$miss"},{"name":"$pad","containerName":"write_aln","kind":13,"line":317},{"containerName":"write_aln","name":"%hash","kind":13,"line":318},{"line":318,"kind":13,"containerName":"write_aln","name":"@arr"},{"containerName":"write_aln","name":"$tempcount","line":318,"kind":13},{"containerName":"write_aln","name":"$index","line":318,"kind":13},{"kind":13,"line":318,"name":"$idlength","containerName":"write_aln"},{"name":"$flag_SI","containerName":"write_aln","kind":13,"line":318},{"containerName":"write_aln","name":"$line_length","kind":13,"line":318},{"kind":13,"line":318,"name":"$tag_length","containerName":"write_aln"},{"localvar":"my","definition":"my","name":"$aln","containerName":"write_aln","line":320,"kind":13},{"line":320,"kind":13,"name":"@aln","containerName":"write_aln"},{"line":321,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"$aln","containerName":"write_aln","kind":13,"line":321},{"name":"isa","containerName":"write_aln","line":321,"kind":12},{"containerName":"write_aln","name":"$self","kind":13,"line":322},{"name":"warn","containerName":"write_aln","kind":12,"line":322},{"line":325,"kind":13,"name":"$self","containerName":"write_aln"},{"line":325,"kind":12,"containerName":"write_aln","name":"throw"},{"line":326,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"is_flush","line":326,"kind":12},{"kind":13,"line":328,"name":"$flag_SI","containerName":"write_aln"},{"name":"$self","containerName":"write_aln","line":328,"kind":13},{"kind":12,"line":328,"name":"flag_SI","containerName":"write_aln"},{"containerName":"write_aln","name":"$aln","kind":13,"line":329},{"kind":12,"line":329,"name":"set_displayname_flat","containerName":"write_aln"},{"containerName":"write_aln","name":"$length","kind":13,"line":330},{"kind":13,"line":330,"name":"$aln","containerName":"write_aln"},{"line":330,"kind":12,"containerName":"write_aln","name":"length"},{"line":331,"kind":13,"containerName":"write_aln","name":"$flag_SI"},{"kind":13,"line":332,"name":"$self","containerName":"write_aln"},{"kind":12,"line":332,"containerName":"write_aln","name":"interleaved"},{"containerName":"write_aln","name":"$self","line":333,"kind":13},{"name":"_print","containerName":"write_aln","line":333,"kind":12},{"name":"$aln","containerName":"write_aln","kind":13,"line":333},{"line":333,"kind":12,"name":"num_sequences","containerName":"write_aln"},{"name":"$aln","containerName":"write_aln","kind":13,"line":333},{"name":"length","containerName":"write_aln","line":333,"kind":12},{"kind":13,"line":335,"containerName":"write_aln","name":"$self"},{"containerName":"write_aln","name":"_print","line":335,"kind":12},{"containerName":"write_aln","name":"$aln","kind":13,"line":335},{"kind":12,"line":335,"name":"num_sequences","containerName":"write_aln"},{"line":335,"kind":13,"containerName":"write_aln","name":"$aln"},{"kind":12,"line":335,"containerName":"write_aln","name":"length"},{"name":"$self","containerName":"write_aln","line":338,"kind":13},{"containerName":"write_aln","name":"_print","line":338,"kind":12},{"containerName":"write_aln","name":"$aln","line":338,"kind":13},{"containerName":"write_aln","name":"num_sequences","line":338,"kind":12},{"name":"$aln","containerName":"write_aln","kind":13,"line":338},{"line":338,"kind":12,"containerName":"write_aln","name":"length"},{"line":341,"kind":13,"name":"$idlength","containerName":"write_aln"},{"containerName":"write_aln","name":"$self","line":341,"kind":13},{"line":341,"kind":12,"name":"idlength","containerName":"write_aln"},{"containerName":"write_aln","name":"$line_length","line":342,"kind":13},{"containerName":"write_aln","name":"$self","line":342,"kind":13},{"containerName":"write_aln","name":"line_length","line":342,"kind":12},{"containerName":"write_aln","name":"$tag_length","kind":13,"line":343},{"line":343,"kind":13,"name":"$self","containerName":"write_aln"},{"containerName":"write_aln","name":"tag_length","kind":12,"line":343},{"containerName":"write_aln","name":"$seq","kind":13,"line":344},{"name":"$aln","containerName":"write_aln","kind":13,"line":344},{"kind":12,"line":344,"containerName":"write_aln","name":"each_seq"},{"kind":13,"line":345,"containerName":"write_aln","name":"$name"},{"line":345,"kind":13,"containerName":"write_aln","name":"$aln"},{"name":"displayname","containerName":"write_aln","kind":12,"line":345},{"kind":13,"line":345,"containerName":"write_aln","name":"$seq"},{"containerName":"write_aln","name":"get_nse","kind":12,"line":345},{"containerName":"write_aln","name":"$self","line":346,"kind":13},{"kind":12,"line":346,"name":"longid","containerName":"write_aln"},{"line":347,"kind":13,"containerName":"write_aln","name":"$self"},{"name":"warn","containerName":"write_aln","kind":12,"line":347},{"kind":13,"line":348,"name":"$name","containerName":"write_aln"},{"name":"$name","containerName":"write_aln","kind":13,"line":349},{"line":351,"kind":13,"name":"$name","containerName":"write_aln"},{"line":351,"kind":13,"containerName":"write_aln","name":"$name"},{"kind":13,"line":351,"name":"$idlength","containerName":"write_aln"},{"containerName":"write_aln","name":"$name","kind":13,"line":351},{"name":"$idlength","containerName":"write_aln","line":351,"kind":13},{"kind":13,"line":352,"name":"$name","containerName":"write_aln"},{"kind":13,"line":352,"containerName":"write_aln","name":"$idlength"},{"kind":13,"line":352,"name":"$name","containerName":"write_aln"},{"containerName":"write_aln","name":"$self","kind":13,"line":353},{"line":353,"kind":12,"containerName":"write_aln","name":"interleaved"},{"kind":13,"line":354,"name":"$name","containerName":"write_aln"},{"containerName":"write_aln","name":"$self","line":355,"kind":13},{"line":355,"kind":12,"name":"id_linebreak","containerName":"write_aln"},{"name":"$name","containerName":"write_aln","line":356,"kind":13},{"line":360,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$seq"},{"name":"$seq","containerName":"write_aln","kind":13,"line":360},{"containerName":"write_aln","name":"seq","kind":12,"line":360},{"line":361,"kind":13,"containerName":"write_aln","name":"$seq"},{"name":"$hash","containerName":"write_aln","line":362,"kind":13},{"kind":13,"line":362,"containerName":"write_aln","name":"$name"},{"kind":13,"line":362,"containerName":"write_aln","name":"$seq"},{"kind":13,"line":363,"name":"@arr","containerName":"write_aln"},{"line":363,"kind":13,"name":"$name","containerName":"write_aln"},{"kind":13,"line":366,"containerName":"write_aln","name":"$self"},{"containerName":"write_aln","name":"interleaved","kind":12,"line":366},{"localvar":"my","definition":"my","name":"$numtags","containerName":"write_aln","line":367,"kind":13},{"name":"$tag_length","containerName":"write_aln","kind":13,"line":368},{"line":368,"kind":13,"name":"$line_length","containerName":"write_aln"},{"line":369,"kind":13,"name":"$numtags","containerName":"write_aln"},{"line":369,"kind":13,"containerName":"write_aln","name":"$line_length"},{"kind":13,"line":369,"containerName":"write_aln","name":"$tag_length"},{"containerName":"write_aln","name":"$line_length","line":370,"kind":13},{"kind":13,"line":370,"containerName":"write_aln","name":"$tag_length"},{"kind":13,"line":370,"name":"$numtags","containerName":"write_aln"},{"line":372,"kind":13,"containerName":"write_aln","name":"$numtags"},{"kind":13,"line":374,"name":"$count","containerName":"write_aln"},{"name":"$length","containerName":"write_aln","kind":13,"line":374},{"kind":13,"line":377,"name":"$name","containerName":"write_aln"},{"containerName":"write_aln","name":"@arr","line":377,"kind":13},{"kind":13,"line":378,"definition":"my","name":"$dispname","containerName":"write_aln","localvar":"my"},{"containerName":"write_aln","name":"$name","kind":13,"line":378},{"containerName":"write_aln","name":"$dispname","line":379,"kind":13},{"containerName":"write_aln","name":"$wrapped","line":379,"kind":13},{"name":"$self","containerName":"write_aln","kind":13,"line":380},{"line":380,"kind":12,"containerName":"write_aln","name":"_print"},{"name":"$idlength","containerName":"write_aln","line":380,"kind":13},{"containerName":"write_aln","name":"$dispname","line":380,"kind":13},{"kind":13,"line":381,"containerName":"write_aln","name":"$tempcount"},{"line":381,"kind":13,"name":"$count","containerName":"write_aln"},{"containerName":"write_aln","name":"$index","kind":13,"line":382},{"containerName":"write_aln","name":"$self","line":383,"kind":13},{"name":"debug","containerName":"write_aln","line":383,"kind":12},{"name":"$count","containerName":"write_aln","line":383,"kind":13},{"line":383,"kind":13,"name":"%100000","containerName":"write_aln"},{"containerName":"write_aln","name":"$tempcount","line":384,"kind":13},{"kind":13,"line":384,"containerName":"write_aln","name":"$tag_length"},{"line":384,"kind":13,"containerName":"write_aln","name":"$length"},{"containerName":"write_aln","name":"$index","kind":13,"line":385},{"name":"$numtags","containerName":"write_aln","line":385,"kind":13},{"name":"$self","containerName":"write_aln","line":386,"kind":13},{"containerName":"write_aln","name":"_print","kind":12,"line":386},{"kind":13,"line":386,"name":"$hash","containerName":"write_aln"},{"containerName":"write_aln","name":"$name","line":386,"kind":13},{"name":"$tempcount","containerName":"write_aln","line":387,"kind":13},{"line":388,"kind":13,"containerName":"write_aln","name":"$tag_length"},{"line":389,"kind":13,"name":"$tempcount","containerName":"write_aln"},{"line":389,"kind":13,"name":"$tag_length","containerName":"write_aln"},{"line":390,"kind":13,"name":"$index","containerName":"write_aln"},{"line":393,"kind":13,"containerName":"write_aln","name":"$index"},{"kind":13,"line":393,"name":"$numtags","containerName":"write_aln"},{"kind":13,"line":395,"containerName":"write_aln","name":"$self"},{"containerName":"write_aln","name":"_print","line":395,"kind":12},{"line":395,"kind":13,"name":"$hash","containerName":"write_aln"},{"containerName":"write_aln","name":"$name","kind":13,"line":395},{"name":"$tempcount","containerName":"write_aln","kind":13,"line":396},{"name":"$tempcount","containerName":"write_aln","line":397,"kind":13},{"kind":13,"line":397,"name":"$tag_length","containerName":"write_aln"},{"containerName":"write_aln","name":"$self","line":399,"kind":13},{"name":"_print","containerName":"write_aln","line":399,"kind":12},{"kind":13,"line":401,"name":"$self","containerName":"write_aln"},{"line":401,"kind":12,"name":"_print","containerName":"write_aln"},{"kind":13,"line":402,"name":"$count","containerName":"write_aln"},{"kind":13,"line":402,"containerName":"write_aln","name":"$tempcount"},{"kind":13,"line":403,"name":"$wrapped","containerName":"write_aln"},{"line":406,"kind":13,"name":"$name","containerName":"write_aln"},{"kind":13,"line":406,"name":"@arr","containerName":"write_aln"},{"line":407,"kind":13,"localvar":"my","name":"$dispname","definition":"my","containerName":"write_aln"},{"containerName":"write_aln","name":"$name","kind":13,"line":407},{"line":408,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$line"},{"kind":13,"line":408,"containerName":"write_aln","name":"$dispname"},{"kind":13,"line":408,"name":"$hash","containerName":"write_aln"},{"name":"$name","containerName":"write_aln","kind":13,"line":408},{"containerName":"write_aln","name":"$self","kind":13,"line":409},{"name":"wrap_sequential","containerName":"write_aln","line":409,"kind":12},{"containerName":"write_aln","name":"$line","line":410,"kind":13},{"containerName":"write_aln","name":"$self","line":412,"kind":13},{"line":412,"kind":12,"containerName":"write_aln","name":"_print"},{"name":"$line","containerName":"write_aln","kind":13,"line":412},{"line":416,"kind":13,"containerName":"write_aln","name":"$self"},{"line":416,"kind":12,"containerName":"write_aln","name":"flush"},{"kind":13,"line":416,"name":"$self","containerName":"write_aln"},{"line":416,"kind":12,"name":"_flush_on_write","containerName":"write_aln"},{"line":416,"kind":13,"name":"$self","containerName":"write_aln"},{"line":416,"kind":12,"name":"_fh","containerName":"write_aln"}],"containerName":"main::","definition":"sub","detail":"($self,@aln)","signature":{"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"}},{"name":"floor","line":369,"kind":12},{"name":"interleaved","range":{"start":{"line":431,"character":0},"end":{"character":9999,"line":439}},"kind":12,"children":[{"line":432,"kind":13,"localvar":"my","containerName":"interleaved","name":"$self","definition":"my"},{"containerName":"interleaved","name":"$value","line":432,"kind":13},{"containerName":"interleaved","name":"$value","line":433,"kind":13},{"containerName":"interleaved","name":"$value","kind":13,"line":434},{"kind":13,"line":434,"name":"$self","containerName":"interleaved"},{"kind":13,"line":435,"name":"$self","containerName":"interleaved"},{"kind":13,"line":437,"containerName":"interleaved","name":"$self"},{"name":"$self","containerName":"interleaved","kind":13,"line":438}],"line":431,"definition":"sub","containerName":"main::","signature":{"label":"interleaved($self,$value)","documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)"},{"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"flag_SI","line":455,"kind":13},{"name":"$value","containerName":"flag_SI","kind":13,"line":455},{"name":"$previous","definition":"my","containerName":"flag_SI","localvar":"my","kind":13,"line":456},{"line":456,"kind":13,"containerName":"flag_SI","name":"$self"},{"line":457,"kind":13,"name":"$value","containerName":"flag_SI"},{"kind":13,"line":458,"name":"$self","containerName":"flag_SI"},{"containerName":"flag_SI","name":"$value","kind":13,"line":458},{"line":460,"kind":13,"name":"$previous","containerName":"flag_SI"}],"line":454,"kind":12,"signature":{"label":"flag_SI($self,$value)","documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","definition":"sub","containerName":"main::","range":{"start":{"character":0,"line":454},"end":{"line":461,"character":9999}},"name":"flag_SI"},{"kind":12,"line":474,"children":[{"containerName":"idlength","name":"$self","definition":"my","localvar":"my","kind":13,"line":475},{"name":"$value","containerName":"idlength","line":475,"kind":13},{"containerName":"idlength","name":"$value","kind":13,"line":476},{"containerName":"idlength","name":"$self","line":477,"kind":13},{"name":"$value","containerName":"idlength","line":477,"kind":13},{"kind":13,"line":479,"name":"$self","containerName":"idlength"}],"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"idlength($self,$value)","parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string"},"name":"idlength","range":{"start":{"line":474,"character":0},"end":{"character":9999,"line":480}}},{"definition":"sub","containerName":"main::","signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)","label":"line_length($self,$value)"},"detail":"($self,$value)","kind":12,"children":[{"kind":13,"line":494,"name":"$self","definition":"my","containerName":"line_length","localvar":"my"},{"containerName":"line_length","name":"$value","kind":13,"line":494},{"name":"$value","containerName":"line_length","line":495,"kind":13},{"kind":13,"line":496,"name":"$self","containerName":"line_length"},{"line":496,"kind":13,"name":"$value","containerName":"line_length"},{"name":"$self","containerName":"line_length","line":498,"kind":13},{"kind":13,"line":498,"name":"$DEFAULTLINELEN","containerName":"line_length"}],"line":493,"name":"line_length","range":{"start":{"character":0,"line":493},"end":{"line":500,"character":9999}}},{"kind":12,"children":[{"kind":13,"line":515,"definition":"my","name":"$self","containerName":"tag_length","localvar":"my"},{"name":"$value","containerName":"tag_length","line":515,"kind":13},{"name":"$value","containerName":"tag_length","kind":13,"line":516},{"kind":13,"line":517,"name":"$self","containerName":"tag_length"},{"line":517,"kind":13,"containerName":"tag_length","name":"$value"},{"line":519,"kind":13,"containerName":"tag_length","name":"$self"},{"kind":13,"line":519,"containerName":"tag_length","name":"$DEFAULTTAGLEN"}],"line":514,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'} || $DEFAULTLINELEN;\n\n}\n\n=head2 tag_length\n\n Title   : tag_length\n Usage   : $obj->tag_length($newval)\n Function:\n Example : my $tag_length = $obj->tag_length\n Returns : value of the length for each space-separated tag in a line\n Args    : newvalue (optional) - set to zero to have one tag per line","parameters":[{"label":"$self"},{"label":"$value"}],"label":"tag_length($self,$value)"},"detail":"($self,$value)","name":"tag_length","range":{"end":{"character":9999,"line":520},"start":{"character":0,"line":514}}},{"containerName":"main::","definition":"sub","detail":"($self,$value)","signature":{"label":"id_linebreak($self,$value)","documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'} || $DEFAULTLINELEN;\n\n}\n\n=head2 tag_length\n\n Title   : tag_length\n Usage   : $obj->tag_length($newval)\n Function:\n Example : my $tag_length = $obj->tag_length\n Returns : value of the length for each space-separated tag in a line\n Args    : newvalue (optional) - set to zero to have one tag per line\n\n\n\nsub tag_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_tag_length'} = $value;\n    }\n    return $self->{'_tag_length'} || $DEFAULTTAGLEN;\n}\n\n\n=head2 id_linebreak\n\n Title   : id_linebreak\n Usage   : $obj->id_linebreak($newval)\n Function:\n Returns : value of id_linebreak\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"kind":12,"line":534,"children":[{"kind":13,"line":535,"containerName":"id_linebreak","name":"$self","definition":"my","localvar":"my"},{"name":"$value","containerName":"id_linebreak","kind":13,"line":535},{"name":"$value","containerName":"id_linebreak","kind":13,"line":536},{"containerName":"id_linebreak","name":"$self","kind":13,"line":537},{"line":537,"kind":13,"containerName":"id_linebreak","name":"$value"},{"name":"$self","containerName":"id_linebreak","kind":13,"line":539}],"name":"id_linebreak","range":{"start":{"line":534,"character":0},"end":{"line":540,"character":9999}}},{"name":"wrap_sequential","range":{"end":{"character":9999,"line":560},"start":{"line":554,"character":0}},"definition":"sub","containerName":"main::","signature":{"label":"wrap_sequential($self,$value)","documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'} || $DEFAULTLINELEN;\n\n}\n\n=head2 tag_length\n\n Title   : tag_length\n Usage   : $obj->tag_length($newval)\n Function:\n Example : my $tag_length = $obj->tag_length\n Returns : value of the length for each space-separated tag in a line\n Args    : newvalue (optional) - set to zero to have one tag per line\n\n\n\nsub tag_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_tag_length'} = $value;\n    }\n    return $self->{'_tag_length'} || $DEFAULTTAGLEN;\n}\n\n\n=head2 id_linebreak\n\n Title   : id_linebreak\n Usage   : $obj->id_linebreak($newval)\n Function:\n Returns : value of id_linebreak\n Args    : newvalue (optional)\n\n\n\nsub id_linebreak{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_id_linebreak'} = $value;\n    }\n    return $self->{'_id_linebreak'} || 0;\n}\n\n\n=head2 wrap_sequential\n\n Title   : wrap_sequential\n Usage   : $obj->wrap_sequential($newval)\n Function:\n Returns : value of wrap_sequential\n Args    : newvalue (optional)","parameters":[{"label":"$self"},{"label":"$value"}]},"detail":"($self,$value)","kind":12,"children":[{"containerName":"wrap_sequential","name":"$self","definition":"my","localvar":"my","kind":13,"line":555},{"containerName":"wrap_sequential","name":"$value","kind":13,"line":555},{"line":556,"kind":13,"name":"$value","containerName":"wrap_sequential"},{"kind":13,"line":557,"name":"$self","containerName":"wrap_sequential"},{"containerName":"wrap_sequential","name":"$value","line":557,"kind":13},{"line":559,"kind":13,"name":"$self","containerName":"wrap_sequential"}],"line":554},{"signature":{"parameters":[{"label":"$self"},{"label":"$value"}],"documentation":"1;\n# $Id: phylip.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::phylip\n#\n# Copyright Heikki Lehvaslaiho\n#\n\n=head1 NAME\n\nBio::AlignIO::phylip - PHYLIP format sequence input/output stream\n\n=head1 SYNOPSIS\n\n# Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n    use Bio::AlignIO;\n    use Bio::SimpleAlign;\n    #you can set the name length to something other than the default 10\n    #if you use a version of phylip (hacked) that accepts ids > 10\n    my $phylipstream = Bio::AlignIO->new(-format  => 'phylip',\n                                        -fh      => \\*STDOUT,\n                                        -idlength=>30);\n    # convert data from one format to another\n    my $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                          -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n    # do it again with phylip sequential format format\n    $phylipstream->interleaved(0);\n    # can also initialize the object like this\n    $phylipstream = Bio::AlignIO->new(-interleaved => 0,\n                                     -format => 'phylip',\n                                     -fh   => \\*STDOUT,\n                                     -idlength=>10);\n    $gcgstream     =  Bio::AlignIO->new(-format => 'msf',\n                                       -file   => 't/data/cysprot1a.msf');\n\n    while( my $aln = $gcgstream->next_aln ) {\n        $phylipstream->write_aln($aln);\n    }\n\n=head1 DESCRIPTION\n\nThis object can transform Bio::SimpleAlign objects to and from PHYLIP\nfotmat. By deafult it works with the interleaved format. By specifying\nthe flag -interleaved =E<gt> 0 in the initialization the module can\nread or write data in sequential format.\n\nLong IDs up to 50 characters are supported by flag -longid =E<gt>\n1. ID strings can be surrounded by single quoted. They are mandatory\nonly if the IDs contain spaces. \n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution. Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Heikki Lehvaslaiho and Jason Stajich\n\nEmail: heikki at ebi.ac.uk\nEmail: jason at bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::phylip;\nuse vars qw($DEFAULTIDLENGTH $DEFAULTLINELEN $DEFAULTTAGLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse POSIX; # for the rounding call\n\nuse base qw(Bio::AlignIO);\n\nBEGIN {\n    $DEFAULTIDLENGTH = 10;\n    $DEFAULTLINELEN = 60;\n    $DEFAULTTAGLEN = 10;\n}\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'phylip'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::phylip> reader or writer\n Returns : L<Bio::AlignIO> object\n Args    : [specific for writing of phylip format files]\n           -idlength => integer - length of the id (will pad w/\n\t\t\t\t\t\t    spaces if needed)\n           -interleaved => boolean - whether interleaved\n                                     or sequential format required\n           -line_length  => integer of how long a sequence lines should be\n           -idlinebreak => insert a line break after the sequence id\n                           so that sequence starts on the next line\n           -flag_SI => whether or not write a \"S\" or \"I\" just after\n                       the num.seq. and line len., in the first line\n           -tag_length => integer of how long the tags have to be in\n                         each line between the space separator. set it\n                         to 0 to have 1 tag only.\n           -wrap_sequential => boolean for whether or not sequential\n                                   format should be broken up or a single line\n                                   default is false (single line)\n           -longid => boolean for allowing arbitrary long IDs (default is false)\n\n\nsub _initialize {\n  my($self,@args) = @_;\n  $self->SUPER::_initialize(@args);\n\n  my ($interleave,$linelen,$idlinebreak,\n      $idlength, $flag_SI, $tag_length,$ws, $longid) =\n          $self->_rearrange([qw(INTERLEAVED\n                                LINE_LENGTH\n                                IDLINEBREAK\n                                IDLENGTH\n                                FLAG_SI\n                                TAG_LENGTH\n\t\t\t\tWRAP_SEQUENTIAL\n                                LONGID)],@args);\n  $self->interleaved($interleave ? 1 : 0) if defined $interleave;\n  $self->idlength($idlength || $DEFAULTIDLENGTH);\n  $self->id_linebreak(1) if( $idlinebreak );\n  $self->line_length($linelen) if defined $linelen && $linelen > 0;\n  $self->flag_SI(1) if ( $flag_SI );\n  $self->tag_length($tag_length) if ( $tag_length || $DEFAULTTAGLEN );\n  $self->wrap_sequential($ws ? 1 : 0);\n  $self->longid($longid ? 1 : 0);\n  1;\n}\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Throws an exception if trying to read in PHYLIP\n           sequential format.\n Returns : L<Bio::SimpleAlign> object\n Args    :\n\n\nsub next_aln {\n    my $self = shift;\n    my $entry;\n    my ($seqcount, $residuecount, %hash, $name,$str,\n\t@names,$seqname,$start,$end,$count,$seq);\n\n    my $aln =  Bio::SimpleAlign->new(-source => 'phylip');\n    $entry = $self->_readline and\n        ($seqcount, $residuecount) = $entry =~ /\\s*(\\d+)\\s+(\\d+)/;\n    return unless $seqcount and $residuecount;\n\n    # first alignment section\n    my $idlen = $self->idlength;\n    $count = 0;\n    my $iter = 1;\n    my $interleaved = $self->interleaved;\n    while( $entry = $self->_readline) {\n\tlast if( $entry =~ /^\\s?$/ && $interleaved );\n\n\tif( $entry =~ /^\\s+(\\d+)\\s+(\\d+)\\s*$/) {\n\t    $self->_pushback($entry);\n\t    last;\n\t}\n\tif( $self->longid  && $entry =~ /\\w/ ) {\n\t    if ($entry =~ /'/) {\n\t\t$entry =~ /^\\s*'([^']+)'\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    } else {\n\t\t$entry =~ /^\\s*([^\\s]+)\\s+(.+)$/;\n\t\t$name = $1;\n\t\t$str = $2;\n\t    }\n#\t    $name =~ s/[\\s\\/]/_/g; # not sure how wise is it to do this\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\t    \n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\n\t} elsif( $entry =~ /^\\s+(.+)$/ ) {\n\t    $interleaved = 0;\n\t    $str = $1;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} .= $str;\n\t} elsif( $entry =~ /^(.{$idlen})\\s+(.*)\\s$/ ||\n\t\t $entry =~ /^(.{$idlen})(\\S{$idlen}\\s+.+)\\s$/ # Handle weirdnes s when id is too long\n\t\t ) {\n\t    $name = $1;\n\t    $str = $2;\n\t    $name =~ s/[\\s\\/]/_/g;\n\t    $name =~ s/_+$//; # remove any trailing _'s\n\n\t    push @names, $name;\n\t    $str =~ s/\\s//g;\n\t    $count = scalar @names;\n\t    $hash{$count} = $str;\n\t} elsif( $interleaved ) {\n\t    if( $entry =~ /^(\\S+)\\s+(.+)/ ||\n\t\t$entry =~ /^(.{$idlen})(.*)\\s$/ ) {\n\t\t$name = $1;\n\t\t$str = $2;\n\t\t$name =~ s/[\\s\\/]/_/g;\n\t\t$name =~ s/_+$//; # remove any trailing _'s\n\t\tpush @names, $name;\n\t\t$str =~ s/\\s//g;\n\t\t$count = scalar @names;\n\t\t$hash{$count} = $str;\n\t    } else {\n\t\t$self->debug(\"unmatched line: $entry\");\n\t    }\n\t}\n\t$self->throw(\"Not a valid interleaved PHYLIP file!\") if $count > $seqcount;\n    }\n\n    if( $interleaved ) {\n\t# interleaved sections\n\t$count = 0;\n\twhile( $entry = $self->_readline) {\n            # finish current entry\n\t    if($entry =~/\\s*\\d+\\s+\\d+/){\n\t\t$self->_pushback($entry);\n\t\tlast;\n\t    }\n\t    $count = 0, next if $entry =~ /^\\s$/;\n\t    $entry =~ /\\s*(.*)$/ && do {\n\t\t$str = $1;\n\t\t$str =~ s/\\s//g;\n\t\t$count++;\n\t\t$hash{$count} .= $str;\n\t    };\n\t    $self->throw(\"Not a valid interleaved PHYLIP file! [$count,$seqcount] ($entry)\") if $count > $seqcount;\n\t}\n    }\n    return if scalar @names < 1;\n\n    # sequence creation\n    $count = 0;\n    foreach $name ( @names ) {\n\t$count++;\n\tif( $name =~ /(\\S+)\\/(\\d+)-(\\d+)/ ) {\n\t    $seqname = $1;\n\t    $start = $2;\n\t    $end = $3;\n\t} else {\n\t    $seqname=$name;\n\t    $start = 1;\n\t    $str = $hash{$count};\n\t    $str =~ s/[^A-Za-z]//g;\n\t    $end = length($str);\n\t}\n\t# consistency test\n\t$self->throw(\"Length of sequence [$seqname] is not [$residuecount] it is \".CORE::length($hash{$count}).\"! \")\n\t    unless CORE::length($hash{$count}) == $residuecount;\n\n       $seq = Bio::LocatableSeq->new('-seq'=>$hash{$count},\n\t\t\t\t    '-id'=>$seqname,\n\t\t\t\t    '-start'=>$start,\n\t\t\t\t    '-end'=>$end,\n\t\t\t\t   );\n\t$aln->add_seq($seq);\n\n   }\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MSF format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object\n\n\nsub write_aln {\n    my ($self,@aln) = @_;\n    my $count = 0;\n    my $wrapped = 0;\n    my $maxname;\n    my $width = $self->line_length();\n    my ($length,$date,$name,$seq,$miss,$pad,\n\t%hash,@arr,$tempcount,$index,$idlength,$flag_SI,$line_length, $tag_length);\n\n    foreach my $aln (@aln) {\n\tif( ! $aln || ! $aln->isa('Bio::Align::AlignI')  ) {\n\t    $self->warn(\"Must provide a Bio::Align::AlignI object when calling write_aln\");\n\t    next;\n\t}\n\t$self->throw(\"All sequences in the alignment must be the same length\")\n\t    unless $aln->is_flush(1) ;\n\n        $flag_SI = $self->flag_SI();\n\t$aln->set_displayname_flat(); # plain\n\t$length  = $aln->length();\n        if ($flag_SI) {\n            if ($self->interleaved() ) {\n                $self->_print (sprintf(\" %s %s I\\n\", $aln->num_sequences, $aln->length));\n            } else {\n                $self->_print (sprintf(\" %s %s S\\n\", $aln->num_sequences, $aln->length));\n            }\n        } else {\n            $self->_print (sprintf(\" %s %s\\n\", $aln->num_sequences, $aln->length));\n        }\n\n\t$idlength = $self->idlength();\n\t$line_length = $self->line_length();\n\t$tag_length = $self->tag_length();\n\tforeach $seq ( $aln->each_seq() ) {\n\t    $name = $aln->displayname($seq->get_nse);\n\t    if ($self->longid) {\n\t\t$self->warn(\"The lenght of the name is over 50 chars long [$name]\") \n\t\t    if length($name) > 50; \n\t\t$name = \"'$name'  \"\n\t    } else {\n\t\t$name = substr($name, 0, $idlength) if length($name) > $idlength;\n\t\t$name = sprintf(\"%-\".$idlength.\"s\",$name);\n\t\tif( $self->interleaved() ) {\n\t\t    $name .= '   ' ;\n\t\t} elsif( $self->id_linebreak) {\n\t\t    $name .= \"\\n\";\n\t\t}\n\t    }\n\t    #phylip needs dashes not dots\n\t    my $seq = $seq->seq();\n\t    $seq =~ s/\\./-/g;\n\t    $hash{$name} = $seq;\n\t    push(@arr,$name);\n\t}\n\n\tif( $self->interleaved() ) {\n            my $numtags;\n            if ($tag_length <= $line_length) {\n                $numtags = floor($line_length/$tag_length);\n                $line_length = $tag_length*$numtags;\n            } else {\n                $numtags = 1;\n            }\n\t    while( $count < $length ) {\n\n\t\t# there is another block to go!\n\t\tforeach $name ( @arr ) {\n\t\t    my $dispname = $name;\n\t\t    $dispname = '' if $wrapped;\n\t\t    $self->_print (sprintf(\"%\".($idlength+3).\"s\",$dispname));\n\t\t    $tempcount = $count;\n                    $index = 0;\n                    $self->debug(\"residue count: $count\\n\") if ($count%100000 == 0);\n\t\t    while( ($tempcount + $tag_length < $length) &&\n\t\t\t   ($index < $numtags)  ) {\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount,\n\t\t\t\t\t\t\t    $tag_length)));\n\t\t\t$tempcount += $tag_length;\n\t\t\t$index++;\n\t\t    }\n\t\t    # last\n\t\t    if( $index < $numtags) {\n\t\t\t# space to print!\n\t\t\t$self->_print (sprintf(\"%s \",substr($hash{$name},\n\t\t\t\t\t\t\t    $tempcount)));\n\t\t\t$tempcount += $tag_length;\n\t\t    }\n\t\t    $self->_print (\"\\n\");\n\t\t}\n\t\t$self->_print (\"\\n\");\n\t\t$count = $tempcount;\n\t\t$wrapped = 1;\n\t    }\n\t} else {\n\t    foreach $name ( @arr ) {\n\t\tmy $dispname = $name;\n\t\tmy $line = sprintf(\"%s%s\\n\",$dispname,$hash{$name});\n\t\tif( $self->wrap_sequential ) {\n\t\t    $line =~ s/(.{1,$width})/$1\\n/g;\n\t\t}\n\t\t$self->_print ($line);\n\t    }\n\t}\n    }\n    $self->flush if $self->_flush_on_write && defined $self->_fh;\n    return 1;\n}\n\n=head2 interleaved\n\n Title   : interleaved\n Usage   : my $interleaved = $obj->interleaved\n Function: Get/Set Interleaved status\n Returns : boolean\n Args    : boolean\n\n\n\nsub interleaved {\n   my ($self,$value) = @_;\n   if( defined $value ) {\n       if ($value) {$self->{'_interleaved'} = 1 }\n       else {$self->{'_interleaved'} = 0 }\n   }\n   return 1 unless defined $self->{'_interleaved'};\n   return $self->{'_interleaved'};\n}\n\n=head2 flag_SI\n\n Title   : flag_SI\n Usage   : my $flag = $obj->flag_SI\n Function: Get/Set if the Sequential/Interleaved flag has to be shown\n           after the number of sequences and sequence length\n Example :\n Returns : boolean\n Args    : boolean\n\n\n\nsub flag_SI{\n   my ($self,$value) = @_;\n   my $previous = $self->{'_flag_SI'};\n   if( defined $value ) {\n       $self->{'_flag_SI'} = $value;\n   }\n   return $previous;\n}\n\n=head2 idlength\n\n Title   : idlength\n Usage   : my $idlength = $obj->idlength\n Function: Get/Set value of id length\n Returns : string\n Args    : string\n\n\n\nsub idlength {\n\tmy($self,$value) = @_;\n\tif (defined $value){\n\t   $self->{'_idlength'} = $value;\n\t}\n\treturn $self->{'_idlength'};\n}\n\n=head2 line_length\n\n Title   : line_length\n Usage   : $obj->line_length($newval)\n Function:\n Returns : value of line_length\n Args    : newvalue (optional)\n\n\n\nsub line_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_line_length'} = $value;\n    }\n    return $self->{'_line_length'} || $DEFAULTLINELEN;\n\n}\n\n=head2 tag_length\n\n Title   : tag_length\n Usage   : $obj->tag_length($newval)\n Function:\n Example : my $tag_length = $obj->tag_length\n Returns : value of the length for each space-separated tag in a line\n Args    : newvalue (optional) - set to zero to have one tag per line\n\n\n\nsub tag_length{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_tag_length'} = $value;\n    }\n    return $self->{'_tag_length'} || $DEFAULTTAGLEN;\n}\n\n\n=head2 id_linebreak\n\n Title   : id_linebreak\n Usage   : $obj->id_linebreak($newval)\n Function:\n Returns : value of id_linebreak\n Args    : newvalue (optional)\n\n\n\nsub id_linebreak{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_id_linebreak'} = $value;\n    }\n    return $self->{'_id_linebreak'} || 0;\n}\n\n\n=head2 wrap_sequential\n\n Title   : wrap_sequential\n Usage   : $obj->wrap_sequential($newval)\n Function:\n Returns : value of wrap_sequential\n Args    : newvalue (optional)\n\n\n\nsub wrap_sequential{\n   my ($self,$value) = @_;\n   if( defined $value) {\n      $self->{'_wrap_sequential'} = $value;\n    }\n    return $self->{'_wrap_sequential'} || 0;\n}\n\n=head2 longid\n\n Title   : longid\n Usage   : $obj->longid($newval)\n Function:\n Returns : value of longid\n Args    : newvalue (optional)","label":"longid($self,$value)"},"detail":"($self,$value)","definition":"sub","containerName":"main::","children":[{"localvar":"my","containerName":"longid","definition":"my","name":"$self","line":574,"kind":13},{"containerName":"longid","name":"$value","kind":13,"line":574},{"kind":13,"line":575,"containerName":"longid","name":"$value"},{"name":"$self","containerName":"longid","kind":13,"line":576},{"name":"$value","containerName":"longid","kind":13,"line":576},{"containerName":"longid","name":"$self","line":578,"kind":13}],"line":573,"kind":12,"range":{"start":{"line":573,"character":0},"end":{"character":9999,"line":579}},"name":"longid"}],"version":5}