{"version":5,"vars":[{"kind":2,"line":80,"containerName":"","name":"vars"},{"kind":13,"line":89,"containerName":null,"name":"$MEGANAMELEN"},{"name":"LocatableSeq","containerName":"strict::Bio::SimpleAlign::Bio","line":89,"kind":2},{"kind":13,"line":90,"name":"$LINELEN","containerName":null},{"kind":13,"line":91,"containerName":null,"name":"$BLOCKLEN"},{"containerName":null,"name":"%VALID_TYPES","kind":13,"line":92},{"line":94,"kind":2,"name":"base","containerName":""},{"name":"next_aln","range":{"start":{"character":0,"line":115},"end":{"character":9999,"line":176}},"kind":12,"children":[{"line":116,"kind":13,"localvar":"my","definition":"my","name":"$self","containerName":"next_aln"},{"name":"$entry","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":117},{"containerName":"next_aln","definition":"my","name":"$alphabet","localvar":"my","kind":13,"line":118},{"containerName":"next_aln","name":"%seqs","line":118,"kind":13},{"line":119,"kind":13,"name":"$Bio","containerName":"next_aln"},{"line":120,"kind":13,"name":"$Bio","containerName":"next_aln"},{"line":121,"kind":13,"localvar":"my","definition":"my","name":"$aln","containerName":"next_aln"},{"line":121,"kind":12,"name":"new","containerName":"next_aln"},{"name":"$entry","containerName":"next_aln","line":123,"kind":13},{"containerName":"next_aln","name":"$self","kind":13,"line":123},{"kind":12,"line":123,"containerName":"next_aln","name":"_readline"},{"containerName":"next_aln","name":"$entry","line":123,"kind":13},{"name":"$self","containerName":"next_aln","line":125,"kind":13},{"name":"throw","containerName":"next_aln","line":125,"kind":12},{"containerName":"next_aln","name":"$entry","line":126,"kind":13},{"containerName":"next_aln","name":"$entry","kind":13,"line":128},{"containerName":"next_aln","name":"$self","kind":13,"line":128},{"containerName":"next_aln","name":"_readline","kind":12,"line":128},{"kind":13,"line":129,"name":"$entry","containerName":"next_aln"},{"line":130,"kind":13,"name":"$aln","containerName":"next_aln"},{"kind":12,"line":130,"containerName":"next_aln","name":"id"},{"localvar":"my","name":"@fields","definition":"my","containerName":"next_aln","line":132,"kind":13},{"localvar":"my","definition":"my","name":"$f","containerName":"next_aln","line":133,"kind":13},{"name":"@fields","containerName":"next_aln","line":133,"kind":13},{"kind":13,"line":134,"containerName":"next_aln","name":"$name","definition":"my","localvar":"my"},{"kind":13,"line":134,"containerName":"next_aln","name":"$value"},{"kind":13,"line":134,"containerName":"next_aln","name":"$f"},{"kind":13,"line":135,"containerName":"next_aln","name":"$name"},{"containerName":"next_aln","name":"$alphabet","kind":13,"line":136},{"line":136,"kind":13,"name":"$value","containerName":"next_aln"},{"name":"$name","containerName":"next_aln","kind":13,"line":137},{"line":138,"kind":13,"name":"$aln","containerName":"next_aln"},{"kind":12,"line":138,"containerName":"next_aln","name":"match_char"},{"name":"$value","containerName":"next_aln","kind":13,"line":138},{"name":"$name","containerName":"next_aln","kind":13,"line":139},{"line":140,"kind":13,"name":"$aln","containerName":"next_aln"},{"kind":12,"line":140,"containerName":"next_aln","name":"gap_char"},{"containerName":"next_aln","name":"$value","kind":13,"line":140},{"line":147,"kind":13,"localvar":"my","containerName":"next_aln","definition":"my","name":"@order"},{"containerName":"next_aln","name":"$entry","kind":13,"line":148},{"kind":13,"line":149,"name":"$entry","containerName":"next_aln"},{"kind":13,"line":151,"containerName":"next_aln","definition":"my","name":"$seqname","localvar":"my"},{"containerName":"next_aln","name":"$entry","line":151,"kind":13},{"containerName":"next_aln","name":"$MEGANAMELEN","line":151,"kind":13},{"line":152,"kind":13,"containerName":"next_aln","name":"$seqname"},{"localvar":"my","containerName":"next_aln","name":"$line","definition":"my","line":153,"kind":13},{"name":"$entry","containerName":"next_aln","kind":13,"line":153},{"line":153,"kind":13,"containerName":"next_aln","name":"$MEGANAMELEN"},{"kind":13,"line":154,"containerName":"next_aln","name":"$line"},{"kind":13,"line":155,"name":"$seqs","containerName":"next_aln"},{"name":"$seqname","containerName":"next_aln","kind":13,"line":155},{"line":155,"kind":13,"containerName":"next_aln","name":"@order"},{"containerName":"next_aln","name":"$seqname","kind":13,"line":155},{"containerName":"next_aln","name":"$seqs","line":156,"kind":13},{"containerName":"next_aln","name":"$seqname","kind":13,"line":156},{"kind":13,"line":156,"name":"$line","containerName":"next_aln"},{"name":"$entry","containerName":"next_aln","kind":13,"line":158},{"name":"$self","containerName":"next_aln","kind":13,"line":158},{"line":158,"kind":12,"name":"_readline","containerName":"next_aln"},{"kind":13,"line":161,"definition":"my","name":"$seqname","containerName":"next_aln","localvar":"my"},{"kind":13,"line":161,"name":"@order","containerName":"next_aln"},{"localvar":"my","containerName":"next_aln","definition":"my","name":"$s","line":162,"kind":13},{"kind":13,"line":162,"containerName":"next_aln","name":"$seqs"},{"kind":13,"line":162,"name":"$seqname","containerName":"next_aln"},{"line":163,"kind":13,"name":"$s","containerName":"next_aln"},{"localvar":"my","containerName":"next_aln","definition":"my","name":"$end","line":164,"kind":13},{"containerName":"next_aln","name":"$s","kind":13,"line":164},{"containerName":"next_aln","name":"$seq","definition":"my","localvar":"my","kind":13,"line":165},{"name":"new","containerName":"next_aln","kind":12,"line":165},{"name":"$alphabet","containerName":"next_aln","line":165,"kind":13},{"name":"$seqname","containerName":"next_aln","kind":13,"line":166},{"name":"$seqs","containerName":"next_aln","line":167,"kind":13},{"kind":13,"line":167,"name":"$seqname","containerName":"next_aln"},{"line":169,"kind":13,"containerName":"next_aln","name":"$end"},{"line":171,"kind":13,"name":"$aln","containerName":"next_aln"},{"line":171,"kind":12,"name":"add_seq","containerName":"next_aln"},{"kind":13,"line":171,"containerName":"next_aln","name":"$seq"},{"line":173,"kind":13,"name":"$aln","containerName":"next_aln"},{"containerName":"next_aln","name":"unmatch","line":173,"kind":12},{"line":174,"kind":13,"containerName":"next_aln","name":"$aln"},{"line":174,"kind":13,"name":"$aln","containerName":"next_aln"},{"name":"num_sequences","containerName":"next_aln","line":174,"kind":12}],"line":115,"definition":"sub","containerName":"main::","signature":{"documentation":"1;\n# $Id: mega.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::mega\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::mega - Parse and Create MEGA format data files\n\n=head1 SYNOPSIS\n\n    use Bio::AlignIO;\n    my $alignio = Bio::AlignIO->new(-format => 'mega',\n                                   -file   => 't/data/hemoglobinA.meg');\n\n    while( my $aln = $alignio->next_aln ) {\n    # process each alignment or convert to another format like NEXUS\n    }\n\n=head1 DESCRIPTION\n\nThis object handles reading and writing data streams in the MEGA\nformat (Kumar and Nei).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::mega;\nuse vars qw($MEGANAMELEN %VALID_TYPES $LINELEN $BLOCKLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\n\n# symbols are changed due to MEGA's use of '.' for redundant sequences\n\nBEGIN {\n  $MEGANAMELEN = 10;\n  $LINELEN = 60;\n  $BLOCKLEN = 10;\n  %VALID_TYPES =  map {$_, 1} qw( dna rna protein standard);\n}\nuse base qw(Bio::AlignIO);\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Supports the following MEGA format features:\n           - The file has to start with '#mega'\n           - Reads in the name of the alignment from a comment\n             (anything after '!TITLE: ') .\n           - Reads in the format parameters datatype\n\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE","parameters":[{"label":"$self"}],"label":"next_aln($self)"},"detail":"($self)"},{"kind":12,"line":119,"name":"LocatableSeq","containerName":"OTHER_SYMBOLS"},{"line":120,"kind":12,"containerName":"GAP_SYMBOLS","name":"LocatableSeq"},{"kind":12,"line":121,"name":"Bio","containerName":"SimpleAlign"},{"name":"Bio","containerName":"LocatableSeq","kind":12,"line":165},{"detail":"($self,@aln)","signature":{"documentation":"1;\n# $Id: mega.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::mega\n#\n# Please direct questions and support issues to <bioperl-l@bioperl.org> \n#\n# Cared for by Jason Stajich <jason-at-bioperl.org>\n#\n# Copyright Jason Stajich\n#\n# You may distribute this module under the same terms as perl itself\n\n# POD documentation - main docs before the code\n\n=head1 NAME\n\nBio::AlignIO::mega - Parse and Create MEGA format data files\n\n=head1 SYNOPSIS\n\n    use Bio::AlignIO;\n    my $alignio = Bio::AlignIO->new(-format => 'mega',\n                                   -file   => 't/data/hemoglobinA.meg');\n\n    while( my $aln = $alignio->next_aln ) {\n    # process each alignment or convert to another format like NEXUS\n    }\n\n=head1 DESCRIPTION\n\nThis object handles reading and writing data streams in the MEGA\nformat (Kumar and Nei).\n\n\n=head1 FEEDBACK\n\n=head2 Mailing Lists\n\nUser feedback is an integral part of the evolution of this and other\nBioperl modules. Send your comments and suggestions preferably to\nthe Bioperl mailing list.  Your participation is much appreciated.\n\n  bioperl-l@bioperl.org                  - General discussion\n  http://bioperl.org/wiki/Mailing_lists  - About the mailing lists\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nof the bugs and their resolution. Bug reports can be submitted the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHOR - Jason Stajich\n\nEmail jason-at-bioperl.org\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object methods.\nInternal methods are usually preceded with a _\n\n\n\n# Let the code begin...\n\n\npackage Bio::AlignIO::mega;\nuse vars qw($MEGANAMELEN %VALID_TYPES $LINELEN $BLOCKLEN);\nuse strict;\n\nuse Bio::SimpleAlign;\nuse Bio::LocatableSeq;\n\n# symbols are changed due to MEGA's use of '.' for redundant sequences\n\nBEGIN {\n  $MEGANAMELEN = 10;\n  $LINELEN = 60;\n  $BLOCKLEN = 10;\n  %VALID_TYPES =  map {$_, 1} qw( dna rna protein standard);\n}\nuse base qw(Bio::AlignIO);\n\n\n=head2 next_aln\n\n Title   : next_aln\n Usage   : $aln = $stream->next_aln()\n Function: returns the next alignment in the stream.\n           Supports the following MEGA format features:\n           - The file has to start with '#mega'\n           - Reads in the name of the alignment from a comment\n             (anything after '!TITLE: ') .\n           - Reads in the format parameters datatype\n\n Returns : L<Bio::Align::AlignI> object - returns 0 on end of file\n\t    or on error\n Args    : NONE\n\n\n\nsub next_aln{\n   my ($self) = @_;\n   my $entry;\n   my ($alphabet,%seqs);\n   local $Bio::LocatableSeq::OTHER_SYMBOLS = '\\*\\?\\.';\n   local $Bio::LocatableSeq::GAP_SYMBOLS = '\\-';\n   my $aln = Bio::SimpleAlign->new(-source => 'mega');\n\n   while( defined($entry = $self->_readline()) && ($entry =~ /^\\s+$/) ) {}\n\n   $self->throw(\"Not a valid MEGA file! [#mega] not starting the file!\")\n       unless $entry =~ /^#mega/i;\n\n   while( defined($entry = $self->_readline() ) ) {\n       local($_) = $entry;\n       if(/\\!Title:\\s*([^\\;]+)\\s*/i) { $aln->id($1)}\n       elsif( s/\\!Format\\s+([^\\;]+)\\s*/$1/ ) {\n\t   my (@fields) = split(/\\s+/,$1);\n\t   foreach my $f ( @fields ) {\n\t       my ($name,$value) = split(/\\=/,$f);\n\t       if( $name eq 'datatype' ) {\n\t\t   $alphabet = $value;\n\t       } elsif( $name eq 'identical' ) {\n\t\t   $aln->match_char($value);\n\t       } elsif( $name eq 'indel' ) {\n\t\t   $aln->gap_char($value);\n\t       }\n\t   }\n       } elsif( /^\\#/ ) {\n\t   last;\n       }\n   }\n   my @order;\n   while( defined($entry) ) {\n       if( $entry !~ /^\\s+$/ ) {\n\t   # this is to skip the leading '#'\n\t   my $seqname = substr($entry,1,$MEGANAMELEN-1);\n\t   $seqname =~ s/(\\S+)\\s+$/$1/g;\n\t   my $line = substr($entry,$MEGANAMELEN);\n\t   $line =~ s/\\s+//g;\n\t   if( ! defined $seqs{$seqname} ) {push @order, $seqname; }\n\t   $seqs{$seqname} .= $line;\n       }\n       $entry = $self->_readline();\n   }\n\n   foreach my $seqname ( @order ) {\n       my $s = $seqs{$seqname};\n       $s =~ s/[$Bio::LocatableSeq::GAP_SYMBOLS]+//g;\n       my $end = length($s);\n       my $seq = Bio::LocatableSeq->new(-alphabet => $alphabet,\n\t\t\t\t       -id => $seqname,\n\t\t\t\t       -seq => $seqs{$seqname},\n\t\t\t\t       -start => 1,\n\t\t\t\t       -end   => $end);\n\n       $aln->add_seq($seq);\n   }\n   $aln->unmatch;\n   return $aln if $aln->num_sequences;\n   return;\n}\n\n=head2 write_aln\n\n Title   : write_aln\n Usage   : $stream->write_aln(@aln)\n Function: writes the $aln object into the stream in MEGA format\n Returns : 1 for success and 0 for error\n Args    : L<Bio::Align::AlignI> object","parameters":[{"label":"$self"},{"label":"@aln"}],"label":"write_aln($self,@aln)"},"containerName":"main::","definition":"sub","line":188,"children":[{"localvar":"my","definition":"my","name":"$self","containerName":"write_aln","line":189,"kind":13},{"name":"@aln","containerName":"write_aln","kind":13,"line":189},{"line":190,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$count"},{"localvar":"my","containerName":"write_aln","name":"$wrapped","definition":"my","line":191,"kind":13},{"line":192,"kind":13,"localvar":"my","containerName":"write_aln","definition":"my","name":"$maxname"},{"kind":13,"line":194,"containerName":"write_aln","definition":"my","name":"$aln","localvar":"my"},{"line":194,"kind":13,"name":"@aln","containerName":"write_aln"},{"line":195,"kind":13,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"$aln","line":195,"kind":13},{"kind":12,"line":195,"containerName":"write_aln","name":"isa"},{"kind":13,"line":196,"containerName":"write_aln","name":"$self"},{"containerName":"write_aln","name":"warn","line":196,"kind":12},{"containerName":"write_aln","name":"$aln","kind":13,"line":198},{"line":198,"kind":12,"containerName":"write_aln","name":"is_flush"},{"line":198,"kind":13,"name":"$self","containerName":"write_aln"},{"containerName":"write_aln","name":"verbose","kind":12,"line":198},{"line":199,"kind":13,"name":"$self","containerName":"write_aln"},{"containerName":"write_aln","name":"warn","kind":12,"line":199},{"kind":13,"line":202,"containerName":"write_aln","name":"$aln"},{"containerName":"write_aln","name":"match","line":202,"kind":12},{"line":203,"kind":13,"localvar":"my","name":"$len","definition":"my","containerName":"write_aln"},{"name":"$aln","containerName":"write_aln","kind":13,"line":203},{"name":"length","containerName":"write_aln","kind":12,"line":203},{"kind":13,"line":204,"containerName":"write_aln","name":"$format","definition":"my","localvar":"my"},{"kind":13,"line":205,"containerName":"write_aln","name":"$aln"},{"containerName":"write_aln","name":"get_seq_by_pos","line":205,"kind":12},{"containerName":"write_aln","name":"alphabet","kind":12,"line":205},{"line":206,"kind":13,"name":"$aln","containerName":"write_aln"},{"line":206,"kind":12,"name":"match_char","containerName":"write_aln"},{"kind":13,"line":206,"name":"$aln","containerName":"write_aln"},{"containerName":"write_aln","name":"gap_char","kind":12,"line":206},{"line":208,"kind":13,"containerName":"write_aln","name":"$self"},{"kind":12,"line":208,"name":"_print","containerName":"write_aln"},{"containerName":"write_aln","name":"$aln","kind":13,"line":209},{"line":209,"kind":12,"name":"id","containerName":"write_aln"},{"line":209,"kind":13,"containerName":"write_aln","name":"$format"},{"line":211,"kind":13,"localvar":"my","name":"$count","definition":"my","containerName":"write_aln"},{"containerName":"write_aln","name":"$blockcount","line":211,"kind":13},{"name":"$length","containerName":"write_aln","line":211,"kind":13},{"line":211,"kind":13,"containerName":"write_aln","name":"$aln"},{"line":211,"kind":12,"containerName":"write_aln","name":"length"},{"kind":13,"line":212,"name":"$aln","containerName":"write_aln"},{"kind":12,"line":212,"containerName":"write_aln","name":"set_displayname_flat"},{"line":213,"kind":13,"name":"$count","containerName":"write_aln"},{"containerName":"write_aln","name":"$length","line":213,"kind":13},{"localvar":"my","name":"$seq","definition":"my","containerName":"write_aln","line":214,"kind":13},{"containerName":"write_aln","name":"$aln","line":214,"kind":13},{"line":214,"kind":12,"containerName":"write_aln","name":"each_seq"},{"line":215,"kind":13,"localvar":"my","definition":"my","name":"$seqchars","containerName":"write_aln"},{"line":215,"kind":13,"name":"$seq","containerName":"write_aln"},{"line":215,"kind":12,"name":"seq","containerName":"write_aln"},{"containerName":"write_aln","name":"$blockcount","line":216,"kind":13},{"localvar":"my","definition":"my","name":"$substring","containerName":"write_aln","line":217,"kind":13},{"kind":13,"line":217,"name":"$seqchars","containerName":"write_aln"},{"containerName":"write_aln","name":"$count","kind":13,"line":217},{"containerName":"write_aln","name":"$LINELEN","line":217,"kind":13},{"localvar":"my","containerName":"write_aln","name":"@blocks","definition":"my","line":218,"kind":13},{"name":"$blockcount","containerName":"write_aln","line":219,"kind":13},{"containerName":"write_aln","name":"$substring","line":219,"kind":13},{"line":220,"kind":13,"name":"@blocks","containerName":"write_aln"},{"containerName":"write_aln","name":"$substring","kind":13,"line":220},{"name":"$blockcount","containerName":"write_aln","line":220,"kind":13},{"name":"$BLOCKLEN","containerName":"write_aln","line":220,"kind":13},{"kind":13,"line":221,"name":"$blockcount","containerName":"write_aln"},{"kind":13,"line":221,"containerName":"write_aln","name":"$BLOCKLEN"},{"line":223,"kind":13,"containerName":"write_aln","name":"$self"},{"line":223,"kind":12,"containerName":"write_aln","name":"_print"},{"containerName":"write_aln","name":"$MEGANAMELEN","kind":13,"line":223},{"kind":13,"line":224,"containerName":"write_aln","name":"$aln"},{"containerName":"write_aln","name":"displayname","kind":12,"line":224},{"containerName":"write_aln","name":"$seq","kind":13,"line":224},{"line":224,"kind":12,"name":"get_nse","containerName":"write_aln"},{"name":"$MEGANAMELEN","containerName":"write_aln","kind":13,"line":225},{"line":226,"kind":13,"containerName":"write_aln","name":"@blocks"},{"kind":13,"line":228,"name":"$self","containerName":"write_aln"},{"line":228,"kind":12,"containerName":"write_aln","name":"_print"},{"name":"$count","containerName":"write_aln","line":229,"kind":13},{"name":"$LINELEN","containerName":"write_aln","kind":13,"line":229},{"line":232,"kind":13,"containerName":"write_aln","name":"$self"},{"name":"flush","containerName":"write_aln","kind":12,"line":232},{"line":232,"kind":13,"name":"$self","containerName":"write_aln"},{"line":232,"kind":12,"name":"_flush_on_write","containerName":"write_aln"},{"containerName":"write_aln","name":"$self","line":232,"kind":13},{"name":"_fh","containerName":"write_aln","kind":12,"line":232}],"kind":12,"range":{"end":{"character":9999,"line":234},"start":{"character":0,"line":188}},"name":"write_aln"}]}