{"version":5,"vars":[{"kind":2,"line":87,"containerName":"","name":"base"},{"line":102,"children":[{"kind":13,"line":103,"containerName":"_initialize","name":"$self","definition":"my","localvar":"my"},{"kind":13,"line":103,"name":"@args","containerName":"_initialize"},{"name":"$self","containerName":"_initialize","line":104,"kind":13},{"containerName":"_initialize","name":"@args","kind":13,"line":104}],"kind":12,"detail":"($self,@args)","signature":{"label":"_initialize($self,@args)","parameters":[{"label":"$self"},{"label":"@args"}],"documentation":"1;\n# $Id: maf.pm 16123 2009-09-17 12:57:27Z cjfields $\n#\n# BioPerl module for Bio::AlignIO::maf\n#\n# Copyright Allen Day\n#\n\n=head1 NAME\n\nBio::AlignIO::maf - Multiple Alignment Format sequence input stream\n\n=head1 SYNOPSIS\n\n Do not use this module directly.  Use it via the Bio::AlignIO class.\n\n use Bio::AlignIO;\n\n my $alignio = Bio::AlignIO->new(-fh => \\*STDIN, -format => 'maf');\n\n while(my $aln = $alignio->next_aln()){\n   my $match_line = $aln->match_line;\n\n   print $aln, \"\\n\";\n\n   print $aln->length, \"\\n\";\n   print $aln->num_residues, \"\\n\";\n   print $aln->is_flush, \"\\n\";\n   print $aln->num_sequences, \"\\n\";\n\n   $aln->splice_by_seq_pos(1);\n\n   print $aln->consensus_string(60), \"\\n\";\n   print $aln->get_seq_by_pos(1)->seq, \"\\n\";\n   print $aln->match_line(), \"\\n\";\n\n   print \"\\n\";\n }\n\n=head1 DESCRIPTION\n\nThis class constructs Bio::SimpleAlign objects from an MAF-format\nmultiple alignment file.\n\nWriting in MAF format is currently unimplemented.\n\nSpec of MAF format is here:\n  http://genome.ucsc.edu/FAQ/FAQformat\n\n=head1 FEEDBACK\n\n=head2 Support \n\nPlease direct usage questions or support issues to the mailing list:\n\nI<bioperl-l@bioperl.org>\n\nrather than to the module maintainer directly. Many experienced and \nreponsive experts will be able look at the problem and quickly \naddress it. Please include a thorough description of the problem \nwith code and data examples if at all possible.\n\n=head2 Reporting Bugs\n\nReport bugs to the Bioperl bug tracking system to help us keep track\nthe bugs and their resolution.  Bug reports can be submitted via the\nweb:\n\n  http://bugzilla.open-bio.org/\n\n=head1 AUTHORS - Allen Day\n\nEmail: allenday@ucla.edu\n\n=head1 APPENDIX\n\nThe rest of the documentation details each of the object\nmethods. Internal methods are usually preceded with a _\n\n\n# Let the code begin...\n\npackage Bio::AlignIO::maf;\nuse strict;\n\nuse Bio::SimpleAlign;\n\nuse base qw(Bio::AlignIO);\n\n=head2 new\n\n Title   : new\n Usage   : my $alignio = Bio::AlignIO->new(-format => 'maf'\n\t\t\t\t\t  -file   => '>file',\n\t\t\t\t\t  -idlength => 10,\n\t\t\t\t\t  -idlinebreak => 1);\n Function: Initialize a new L<Bio::AlignIO::maf> reader\n Returns : L<Bio::AlignIO> object\n Args    :"},"containerName":"main::","definition":"sub","range":{"end":{"character":9999,"line":107},"start":{"line":102,"character":0}},"name":"_initialize"},{"containerName":"_initialize","name":"SUPER","kind":12,"line":104},{"containerName":"main::","definition":"sub","name":"next_aln","range":{"start":{"character":0,"line":121},"end":{"line":183,"character":9999}},"kind":12,"line":121,"children":[{"kind":13,"line":122,"containerName":"next_aln","definition":"my","name":"$self","localvar":"my"},{"line":125,"kind":13,"containerName":"next_aln","name":"$self"},{"localvar":"my","containerName":"next_aln","name":"$line","definition":"my","line":126,"kind":13},{"name":"$self","containerName":"next_aln","line":126,"kind":13},{"containerName":"next_aln","name":"_readline","line":126,"kind":12},{"kind":13,"line":127,"containerName":"next_aln","name":"$self"},{"containerName":"next_aln","name":"throw","line":127,"kind":12},{"kind":13,"line":127,"name":"$line","containerName":"next_aln"},{"name":"$line","containerName":"next_aln","line":128,"kind":13},{"kind":13,"line":129,"containerName":"next_aln","name":"$self"},{"line":131,"kind":13,"name":"$self","containerName":"next_aln"},{"kind":12,"line":131,"containerName":"next_aln","name":"_pushback"},{"containerName":"next_aln","name":"$line","line":131,"kind":13},{"localvar":"my","name":"$aln","definition":"my","containerName":"next_aln","line":134,"kind":13},{"kind":12,"line":134,"containerName":"next_aln","name":"new"},{"line":136,"kind":13,"localvar":"my","containerName":"next_aln","definition":"my","name":"$aline"},{"name":"@slines","containerName":"next_aln","line":136,"kind":13},{"kind":13,"line":136,"containerName":"next_aln","name":"$seen_aline"},{"kind":13,"line":137,"containerName":"next_aln","definition":"my","name":"$line","localvar":"my"},{"line":137,"kind":13,"name":"$self","containerName":"next_aln"},{"line":137,"kind":12,"name":"_readline","containerName":"next_aln"},{"name":"$line","containerName":"next_aln","line":138,"kind":13},{"line":140,"kind":13,"name":"$seen_aline","containerName":"next_aln"},{"name":"$self","containerName":"next_aln","line":141,"kind":13},{"name":"_pushback","containerName":"next_aln","line":141,"kind":12},{"kind":13,"line":141,"containerName":"next_aln","name":"$line"},{"containerName":"next_aln","name":"$aline","line":144,"kind":13},{"line":144,"kind":13,"name":"$line","containerName":"next_aln"},{"containerName":"next_aln","name":"$seen_aline","line":145,"kind":13},{"name":"$line","containerName":"next_aln","line":146,"kind":13},{"containerName":"next_aln","name":"@slines","line":147,"kind":13},{"line":147,"kind":13,"containerName":"next_aln","name":"$line"},{"name":"$self","containerName":"next_aln","kind":13,"line":150},{"line":150,"kind":12,"containerName":"next_aln","name":"debug"},{"name":"$line","containerName":"next_aln","line":150,"kind":13},{"name":"$aline","containerName":"next_aln","line":155,"kind":13},{"kind":13,"line":157,"containerName":"next_aln","name":"$kvs","definition":"my","localvar":"my"},{"containerName":"next_aln","name":"$aline","kind":13,"line":157},{"kind":13,"line":158,"name":"@kvs","definition":"my","containerName":"next_aln","localvar":"my"},{"line":158,"kind":13,"name":"$kvs","containerName":"next_aln"},{"line":158,"kind":13,"containerName":"next_aln","name":"$kvs"},{"name":"%kv","definition":"my","containerName":"next_aln","localvar":"my","kind":13,"line":159},{"kind":13,"line":160,"definition":"my","name":"$kv","containerName":"next_aln","localvar":"my"},{"kind":13,"line":160,"containerName":"next_aln","name":"@kvs"},{"definition":"my","name":"$k","containerName":"next_aln","localvar":"my","kind":13,"line":161},{"kind":13,"line":161,"containerName":"next_aln","name":"$v"},{"kind":13,"line":161,"name":"$kv","containerName":"next_aln"},{"containerName":"next_aln","name":"$kv","kind":13,"line":162},{"line":162,"kind":13,"name":"$k","containerName":"next_aln"},{"name":"$v","containerName":"next_aln","line":162,"kind":13},{"containerName":"next_aln","name":"$aln","line":165,"kind":13},{"containerName":"next_aln","name":"score","line":165,"kind":12},{"kind":13,"line":165,"containerName":"next_aln","name":"$kv"},{"kind":13,"line":167,"containerName":"next_aln","definition":"my","name":"$sline","localvar":"my"},{"line":167,"kind":13,"name":"@slines","containerName":"next_aln"},{"containerName":"next_aln","definition":"my","name":"$s","localvar":"my","kind":13,"line":168},{"kind":13,"line":168,"name":"$src","containerName":"next_aln"},{"line":168,"kind":13,"name":"$start","containerName":"next_aln"},{"containerName":"next_aln","name":"$size","line":168,"kind":13},{"kind":13,"line":168,"name":"$strand","containerName":"next_aln"},{"containerName":"next_aln","name":"$srcsize","kind":13,"line":168},{"containerName":"next_aln","name":"$text","line":168,"kind":13},{"containerName":"next_aln","name":"$sline","kind":13,"line":169},{"kind":13,"line":171,"containerName":"next_aln","name":"$start"},{"line":171,"kind":13,"containerName":"next_aln","name":"$start"},{"line":172,"kind":13,"localvar":"my","containerName":"next_aln","name":"$seq","definition":"my"},{"containerName":"next_aln","name":"new","line":172,"kind":12},{"line":172,"kind":13,"containerName":"next_aln","name":"$text"},{"name":"$src","containerName":"next_aln","kind":13,"line":173},{"name":"$start","containerName":"next_aln","line":174,"kind":13},{"kind":13,"line":175,"name":"$start","containerName":"next_aln"},{"containerName":"next_aln","name":"$size","kind":13,"line":175},{"containerName":"next_aln","name":"$strand","line":176,"kind":13},{"kind":13,"line":178,"containerName":"next_aln","name":"$aln"},{"name":"add_seq","containerName":"next_aln","line":178,"kind":12},{"kind":13,"line":178,"name":"$seq","containerName":"next_aln"},{"name":"$aln","containerName":"next_aln","kind":13,"line":181},{"name":"$aln","containerName":"next_aln","line":181,"kind":13},{"kind":12,"line":181,"containerName":"next_aln","name":"num_sequences"}]},{"name":"seen_header","line":125,"kind":12},{"name":"seen_header","line":129,"kind":12},{"line":134,"kind":12,"name":"Bio","containerName":"SimpleAlign"},{"name":"score","line":165,"kind":12},{"name":"Bio","containerName":"LocatableSeq","line":172,"kind":12},{"children":[{"line":187,"kind":12,"containerName":"write_aln","name":"throw_not_implemented"}],"line":185,"kind":12,"range":{"end":{"line":187,"character":9999},"start":{"line":185,"character":0}},"definition":"sub","name":"write_aln","containerName":"main::"}]}